<?php

/**
 * BaseLeaveType
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                                     $id                                            Type: integer(4), primary key
 * @property string                                  $name                                          Type: string(50)
 * @property bool                                    $exclude_in_reports_if_no_entitlement          Type: boolean
 * @property int                                     $deleted                                       Type: integer(1), default "0"
 * @property int                                     $operational_country_id                        Type: integer(4)
 * @property OperationalCountry                      $OperationalCountry                            
 * @property Doctrine_Collection|LeaveEntitlement[]  $LeaveEntitlement                              
 * @property Doctrine_Collection|LeaveAdjustment[]   $LeaveAdjustment                               
 * @property Doctrine_Collection|Leave[]             $Leave                                         
 * @property Doctrine_Collection|LeaveRequest[]      $LeaveRequest                                  
 *  
 * @method int                                       getId()                                        Type: integer(4), primary key
 * @method string                                    getName()                                      Type: string(50)
 * @method bool                                      getExcludeInReportsIfNoEntitlement()           Type: boolean
 * @method int                                       getDeleted()                                   Type: integer(1), default "0"
 * @method int                                       getOperationalCountryId()                      Type: integer(4)
 * @method OperationalCountry                        getOperationalCountry()                        
 * @method Doctrine_Collection|LeaveEntitlement[]    getLeaveEntitlement()                          
 * @method Doctrine_Collection|LeaveAdjustment[]     getLeaveAdjustment()                           
 * @method Doctrine_Collection|Leave[]               getLeave()                                     
 * @method Doctrine_Collection|LeaveRequest[]        getLeaveRequest()                              
 *  
 * @method LeaveType                                 setId(int $val)                                Type: integer(4), primary key
 * @method LeaveType                                 setName(string $val)                           Type: string(50)
 * @method LeaveType                                 setExcludeInReportsIfNoEntitlement(bool $val)  Type: boolean
 * @method LeaveType                                 setDeleted(int $val)                           Type: integer(1), default "0"
 * @method LeaveType                                 setOperationalCountryId(int $val)              Type: integer(4)
 * @method LeaveType                                 setOperationalCountry(OperationalCountry $val) 
 * @method LeaveType                                 setLeaveEntitlement(Doctrine_Collection $val)  
 * @method LeaveType                                 setLeaveAdjustment(Doctrine_Collection $val)   
 * @method LeaveType                                 setLeave(Doctrine_Collection $val)             
 * @method LeaveType                                 setLeaveRequest(Doctrine_Collection $val)      
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseLeaveType extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_leave_type');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => true,
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('name', 'string', 50, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => true,
             'autoincrement' => false,
             'length' => 50,
             ));
        $this->hasColumn('exclude_in_reports_if_no_entitlement', 'boolean', null, array(
             'type' => 'boolean',
             ));
        $this->hasColumn('deleted', 'integer', 1, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'default' => '0',
             'notnull' => true,
             'autoincrement' => false,
             'length' => 1,
             ));
        $this->hasColumn('operational_country_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => true,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 4,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('OperationalCountry', array(
             'local' => 'operational_country_id',
             'foreign' => 'id'));

        $this->hasMany('LeaveEntitlement', array(
             'local' => 'id',
             'foreign' => 'leave_type_id'));

        $this->hasMany('LeaveAdjustment', array(
             'local' => 'id',
             'foreign' => 'leave_type_id'));

        $this->hasMany('Leave', array(
             'local' => 'id',
             'foreign' => 'leave_type_id'));

        $this->hasMany('LeaveRequest', array(
             'local' => 'id',
             'foreign' => 'leave_type_id'));
    }
}