#!/usr/pkg/bin/perl
#
# install.pl :  Ŀѥ󥹥ȡ顼
#
# $Id: install.pl,v 1.11 2000/12/20 14:59:26 tom Exp $
################################################################

require 5.000;                # perl5 or later required

use strict;
use Getopt::Std;

#BEGIN { system('perl autosplit.pl')  if $0 =~ /install.pl/; }

use lib ((($0 =~ m%(.*)/.*$%)[0] || ".") . "/web_diary_dir/lib",
	 ($0 =~ m%(.*)/.*$%)[0] || ".");

# option

use TDS;
use TDS::Installer;

my %opt;
getopts("f:r:syhuj", \%opt) || die;
if ($opt{h}){
    print STDERR "% perl install.pl [-uy] [-f filename] [-r filename]

  -f filename  setup file
  -r filename  readonly setup file
  -j           use japanese
  -u           unload setup file
  -s           user setup
  -y           yes

";
    exit;
}

################################################################

my $inst = new TDS::Installer;
# 
$inst->setup_file($opt{'f'} || "$ENV{'HOME'}/.tdssetup");
$inst->ja($opt{j} || $ENV{'LANG'} =~ /^ja/);

# set options
$inst->as_user_setup($opt{'s'});
$inst->yes($opt{'y'});
$inst->unload_setupfile($opt{'u'});
$inst->readonly_setupfile($opt{'r'});

$inst->Do;

exit(0);


