/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CloseableIterator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.ChromosomeNameComparator;
import org.broad.igv.feature.genome.fasta.FastaIndexedSequence;
import org.broad.igv.sam.PicardAlignment;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.util.Interval;
import org.broad.igv.util.IntervalTree;
import org.broad.igv.util.ParsingUtils;

public class TutorialUtils {
    public static void main(String[] args) throws IOException {
        TutorialUtils.sliceFasta(args[0], args[1], args[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void extractFasta(String inputFasta, String outputFasta, String regionsFile) throws IOException {
        FastaIndexedSequence inFasta = new FastaIndexedSequence(inputFasta);
        List<Region> regions = TutorialUtils.parseRegions(new File(regionsFile));
        try (PrintWriter outFasta = null;){
            outFasta = new PrintWriter(new BufferedWriter(new FileWriter(outputFasta)));
            for (Region r : regions) {
                byte[] sequence = inFasta.getSequence(r.chr, r.start, r.end, true);
                outFasta.println(">" + r.name);
                outFasta.println(new String(sequence));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void extractAlignments(String inputFile, String outputFile, String regionsFile) throws IOException {
        AlignmentReader reader = AlignmentReaderFactory.getReader(inputFile, true);
        PrintWriter out = null;
        List<Region> regions = TutorialUtils.parseRegions(new File(regionsFile));
        HashMap<String, ArrayList<Region>> regionMap = new HashMap<String, ArrayList<Region>>();
        for (Region r : regions) {
            ArrayList<Region> rlist = (ArrayList<Region>)regionMap.get(r.chr);
            if (rlist == null) {
                rlist = new ArrayList<Region>();
                regionMap.put(r.chr, rlist);
            }
            rlist.add(r);
        }
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            out.println("@HD VN:1.5 SO:coordinate");
            for (Region r : regions) {
                out.println("@SQ\tSN:" + r.name + "\tLN:" + (r.end - r.start));
            }
            for (Region r : regions) {
                CloseableIterator iter = reader.query(r.chr, r.start, r.end, false);
                while (iter.hasNext()) {
                    PicardAlignment alignment = (PicardAlignment)iter.next();
                    SAMRecord record = alignment.getRecord();
                    record.setReferenceName(r.name);
                    record.setAlignmentStart(record.getAlignmentStart() - r.start);
                    if (record.getReadPairedFlag() && !record.getMateUnmappedFlag()) {
                        if (record.getMateReferenceName().equals(record.getReferenceName())) {
                            record.setMateReferenceName(r.name);
                            record.setMateAlignmentStart(record.getMateAlignmentStart() - r.start);
                        } else {
                            String newMateChr = null;
                            List rlist = (List)regionMap.get(record.getMateReferenceName());
                            if (rlist != null) {
                                for (Region r2 : rlist) {
                                    if (!r2.contains(record.getMateAlignmentStart())) continue;
                                    newMateChr = r.name;
                                    break;
                                }
                            }
                            if (newMateChr != null) {
                                record.setMateReferenceName(newMateChr);
                            } else {
                                record.setMateUnmappedFlag(true);
                            }
                        }
                    }
                    out.print(record.getSAMString());
                }
                iter.close();
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void extractFeatures(String inputFile, String outputFile, String regionsFile) throws IOException {
        PrintWriter out = null;
        List<Region> regions = TutorialUtils.parseRegions(new File(regionsFile));
        Map<String, IntervalTree<List<Feature>>> featureMap = TutorialUtils.loadFeatures(inputFile);
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            for (Region r : regions) {
                IntervalTree<List<Feature>> featureTree = featureMap.get(r.chr);
                if (featureTree == null) continue;
                List<Interval<List<Feature>>> intervals = featureTree.findOverlapping(r.start, r.end);
                for (Interval<List<Feature>> interval : intervals) {
                    List<Feature> features = interval.getValue();
                    for (Feature f : features) {
                        if (f.start < r.start) continue;
                        String s = f.tanslate(r.name, r.start);
                        out.println(s);
                    }
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Region> parseRegions(File file) throws IOException {
        ArrayList<Region> regions = new ArrayList<Region>();
        try (BufferedReader reader = null;){
            String nextLine;
            reader = new BufferedReader(new FileReader(file));
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens;
                if (nextLine.startsWith("#") || (tokens = Globals.whitespacePattern.split(nextLine)).length <= 3) continue;
                regions.add(new Region(tokens[0], Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), tokens[3]));
            }
        }
        return regions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sliceVCF(String inputFile, String outputFile, String chr, int start, int end) throws IOException {
        BufferedReader reader = null;
        PrintWriter out = null;
        try {
            String nextLine;
            reader = ParsingUtils.openBufferedReader(inputFile);
            out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            while ((nextLine = reader.readLine()) != null) {
                if (nextLine.startsWith("#")) {
                    out.println(nextLine);
                    continue;
                }
                String[] tokens = Globals.tabPattern.split(nextLine);
                String c = tokens[0];
                if (!c.equals(chr)) continue;
                int pos = Integer.parseInt(tokens[1]);
                if (pos >= start && pos <= end) {
                    out.println(nextLine);
                }
                if (pos <= end) continue;
                break;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sampleVCF(String inputFile, String outputFile, int n) throws IOException {
        BufferedReader reader = null;
        PrintWriter out = null;
        try {
            String nextLine;
            reader = new BufferedReader(new FileReader(inputFile));
            out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            while ((nextLine = reader.readLine()) != null) {
                int i;
                if (nextLine.startsWith("##")) {
                    out.println(nextLine);
                    continue;
                }
                String[] tokens = Globals.tabPattern.split(nextLine);
                for (i = 0; i < 9; ++i) {
                    out.print(tokens[i]);
                    if (i >= 8) continue;
                    out.print('\t');
                }
                for (i = 9; i < tokens.length; i += n) {
                    if (i >= tokens.length) continue;
                    out.print('\t');
                    out.print(tokens[i]);
                }
                out.println();
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sliceFasta(String inputFasta, String outputFasta, String chr) throws IOException {
        BufferedReader reader = null;
        try (PrintWriter outFasta = null;){
            String nextLine;
            reader = ParsingUtils.openBufferedReader(inputFasta);
            outFasta = new PrintWriter(new BufferedWriter(new FileWriter(outputFasta)));
            boolean chrFound = false;
            while ((nextLine = reader.readLine()) != null) {
                if (chrFound) {
                    if (nextLine.startsWith(">")) {
                        break;
                    }
                    outFasta.println(nextLine);
                    continue;
                }
                if (!nextLine.startsWith(">" + chr)) continue;
                outFasta.println(nextLine);
                chrFound = true;
            }
        }
    }

    private static Comparator<Feature> getPositionComparator() {
        Comparator<Feature> comp = new Comparator<Feature>(){
            private Comparator<String> nameComparator = ChromosomeNameComparator.get();

            @Override
            public int compare(Feature o1, Feature o2) {
                int nameComp = this.nameComparator.compare(o1.chr, o2.chr);
                if (nameComp == 0) {
                    return o1.start - o2.start;
                }
                return nameComp;
            }
        };
        return comp;
    }

    static Map<String, IntervalTree<List<Feature>>> loadFeatures(String file) throws IOException {
        String nextLine;
        BufferedReader reader = null;
        reader = ParsingUtils.openBufferedReader(file);
        String lastChr = null;
        ArrayList<Feature> currentFeatureList = new ArrayList<Feature>();
        int currentMin = Integer.MAX_VALUE;
        int currentMax = 0;
        HashMap<String, IntervalTree<List<Feature>>> map = new HashMap<String, IntervalTree<List<Feature>>>();
        ArrayList<Feature> features = new ArrayList<Feature>();
        while ((nextLine = reader.readLine()) != null) {
            if (nextLine.startsWith("#") || nextLine.startsWith("track") || nextLine.startsWith("browser")) continue;
            String[] tokens = Globals.whitespacePattern.split(nextLine);
            Feature f = new Feature(tokens);
            features.add(f);
        }
        features.sort(TutorialUtils.getPositionComparator());
        for (Feature f : features) {
            IntervalTree tree;
            if (lastChr == null) {
                currentMin = f.start;
                currentMax = f.end;
                currentFeatureList.add(f);
                tree = new IntervalTree();
                map.put(f.chr, tree);
                lastChr = f.chr;
                continue;
            }
            if (!f.chr.equals(lastChr)) {
                tree = (IntervalTree)map.get(lastChr);
                tree.insert(new Interval(currentMin, currentMax, currentFeatureList));
                tree = new IntervalTree();
                map.put(f.chr, tree);
                lastChr = f.chr;
                currentFeatureList = new ArrayList();
                currentFeatureList.add(f);
                currentMin = f.start;
                currentMax = f.end;
                continue;
            }
            if (currentFeatureList.size() > 10) {
                tree = (IntervalTree)map.get(lastChr);
                tree.insert(new Interval(currentMin, currentMax, currentFeatureList));
                currentFeatureList = new ArrayList();
                currentFeatureList.add(f);
                currentMin = f.start;
                currentMax = f.end;
                continue;
            }
            currentMin = Math.min(currentMin, f.start);
            currentMax = Math.max(currentMax, f.end);
            currentFeatureList.add(f);
        }
        return map;
    }

    static class Feature {
        String chr;
        int start;
        int end;
        String[] tokens;

        Feature(String[] tokens) {
            this.chr = tokens[2];
            this.start = Integer.parseInt(tokens[4]);
            this.end = Integer.parseInt(tokens[5]);
            this.tokens = tokens;
        }

        boolean overlaps(String chr, int start, int end) {
            return chr.equals(this.chr) && end > this.start && start <= this.end;
        }

        String tanslate(String newChr, int offset) {
            String[] exonEnds;
            String[] exonStarts;
            this.tokens[2] = newChr;
            this.tokens[4] = String.valueOf(this.start - offset);
            this.tokens[5] = String.valueOf(this.end - offset);
            this.tokens[6] = String.valueOf(Integer.parseInt(this.tokens[6]) - offset);
            this.tokens[7] = String.valueOf(Integer.parseInt(this.tokens[7]) - offset);
            Object newExonStart = "";
            for (String es : exonStarts = this.tokens[9].split(",")) {
                newExonStart = (String)newExonStart + String.valueOf(Integer.parseInt(es) - offset) + ",";
            }
            this.tokens[9] = newExonStart;
            Object newExonEnd = "";
            for (String es : exonEnds = this.tokens[10].split(",")) {
                newExonEnd = (String)newExonEnd + String.valueOf(Integer.parseInt(es) - offset) + ",";
            }
            this.tokens[10] = newExonEnd;
            Object record = this.tokens[0];
            for (int i = 1; i < this.tokens.length; ++i) {
                record = (String)record + "\t" + this.tokens[i];
            }
            return record;
        }
    }

    static class Region {
        String chr;
        int start;
        int end;
        String name;

        public Region(String chr, int start, int end, String name) {
            this.end = end;
            this.chr = chr;
            this.start = start;
            this.name = name;
        }

        public boolean contains(int p) {
            return p >= this.start && p <= this.end;
        }
    }
}

