# This is the file that contains a number of the default configuration
# variables for QuIRC along with their default settings.  If you
# /loadglobal variables.tcl it will set all the variables contained in this
# file to their default values.  It may be useful to do this after upgrading
# in case some variables have changed and things no longer work properly with
# the old values.

# Set up various variable configuration settings.

config type_default boolean 0


# The following list of variables is organized alphabetically.  Each entry
# contains the documentation for the variable, its default value, and possibly
# the type of the variable.

doc add "Variables (Config)/Internal/auto_connect" "Make QuIRC automatically start the connection process when a new server is opened."
config default auto_connect [set ::dynamic::auto_connect 1]
config type auto_connect boolean

doc add "Variables (Config)/Internal/auto_raise_channels" "Automatically raises channel windows to the front when they are created."
config default auto_raise_channels [set ::dynamic::auto_raise_channels 1]
config type auto_raise_channels boolean

doc add "Variables (Config)/Internal/auto_raise_queries" "Automatically raises query windows to the front when they are created."
config default auto_raise_queries [set ::dynamic::auto_raise_queries 1]
config type auto_raise_queries boolean

doc add "Variables (Config)/Internal/auto_reconnect" "If you get disconnected unintentionally, attempt to reconnect."
config default auto_reconnect [set ::dynamic::auto_reconnect 1]
config type auto_reconnect boolean

doc add "Variables (Config)/Internal/auto_rejoin" "Automatically rejoin channels when kicked."
config default auto_rejoin [set ::dynamic::auto_rejoin 0]
config type auto_rejoin boolean

doc add "Variables (Config)/Internal/auto_rejoin_on_connect" "Automatically rejoin previously joined channels when reconnecting to a server."
config default auto_rejoin_on_connect [set ::dynamic::auto_rejoin_on_connect 1]
config type auto_rejoin_on_connect boolean

doc add "Variables (Config)/Internal/blank_lines_before_text" "The number of lines to insert before displaying other text.  This variable is used to control if text starts at the top or the bottom of the screen.  Note that even if this is set to zero, there will always be a single line of space at the top.  If this really annoys you, please submit a patch to eliminate the problem. :)"
config default blank_lines_before_text [set ::dynamic::blank_lines_before_text 100]

doc add "Variables (Config)/Internal/ctcp_userinfo" "The text returned by the USERINFO CTCP reply."
config default ctcp_userinfo [set ::dynamic::ctcp_userinfo ""]

doc add "Variables (Config)/Internal/dcc_auto_accept" "This will make QuIRC auto-accept DCC file requests.  This however will not make it automatically overwrite or rename.  There are other variables for that."
config default dcc_auto_accept [set ::dynamic::dcc_auto_accept 0]
config type dcc_auto_accept boolean

doc add "Variables (Config)/Internal/dcc_auto_overwrite" "If dcc_auto_accept is set, but the file exists, setting this variable will cause it to automatically be overwritten."
config default dcc_auto_overwrite [set ::dynamic::dcc_auto_overwrite 0]
config type dcc_auto_overwrite boolean

doc add "Variables (Config)/Internal/dcc_directory" "The directory dcc files will automatically be recieved into."
config default dcc_directory [set ::dynamic::dcc_directory "$env(HOME)"]

doc add "Variables (Config)/Internal/dcc_localip" "The IP to send in the DCC request.  This variable may be useful if the auto-detected IP is incorrect.  If it is empty, the auto-detected ip will be used."
config default dcc_localip [set ::dynamic::dcc_localip ""]

doc add "Variables (Config)/Internal/dcc_packetsize" "This is how big of a chunk to send at one time.  I've noticed that it doesn't seem to send that big of a chunk anyways, but can always try."
config default dcc_packetsize [set ::dynamic::dcc_packetsize 4096]

doc add "Variables (Config)/Internal/dcc_statuswait" "The minimum time in milliseconds that dcc transfers will wait before updating their stats in the dcc listbox.  This prevents the DCC from lagging due to constantly updating the GUI."
config default dcc_statuswait [set ::dynamic::dcc_statuswait 300]

doc add "Variables (Config)/Internal/default_altnick1" "This is the nick QuIRC will attempt to use if default_nick is taken."
config default default_altnick1 [set ::dynamic::default_altnick1 $env(USER)_]

doc add "Variables (Config)/Internal/default_altnick2" "This is the nick QuIRC will attempt to use if default_altnick1 is taken."
config default default_altnick2 [set ::dynamic::default_altnick2 $env(USER)__]

doc add "Variables (Config)/Internal/default_ctcp_cloak" "This controls what the server specific (::idx::cloak) variable gets set to when a new server is started.  If it is on, all CTCP (including DCC) messages will be ignored."
config default default_ctcp_cloak [set ::dynamic::default_ctcp_cloak 0]
config type default_ctcp_cloak boolean

doc add "Variables (Config)/Internal/default_desc" "The \"real name\" part of the whois and finger replies."
config default default_desc [set ::dynamic::default_desc "QuIRC User"]

doc add "Variables (Config)/Internal/default_globalscripts" "The scripts in this listing are automatically loaded at the start of the client into the global namespace.  Use filenames relative to ~/.quirc/.\nNOTE:  The theme and global.tcl files will be loaded before the scripts in this list."
config default default_globalscripts [set ::dynamic::default_globalscripts "popups.tcl info.tcl doc.tcl"]

doc add "Variables (Config)/Internal/default_mode" "If this variable is set to something, it will be sent as your initial mode when connecting to the server.  +iw-s is a likely setting."
config default default_mode [set ::dynamic::default_mode ""]

doc add "Variables (Config)/Internal/default_nick" "The default nick (alias) you will use on IRC."
config default default_nick [set ::dynamic::default_nick $env(USER)]

doc add "Variables (Config)/Internal/default_port" "The port that QuIRC will try to connect to the IRC server on unless another port number is explicitely specified."
config default default_port [set ::dynamic::default_port 6667]

doc add "Variables (Config)/Internal/default_quit" "The quit message that is used unless another one is explicitely specified."
config default default_quit [set ::dynamic::default_quit "QuIRC for *nix - http://quirc.org/"]

doc add "Variables (Config)/Internal/default_scripts" "The scripts in this listing are automatically loaded when a new server is started.  The filenames should all be relative to ~/.quirc/."
config default default_scripts [set ::dynamic::default_scripts "server.tcl dal.tcl popups.tcl fun.tcl notify.tcl"]

doc add "Variables (Config)/Internal/default_server" "The IRC server that QuIRC will use upon startup if session management (the auto_start variable) is not being used."
config default default_server [set ::dynamic::default_server "irc.dal.net"]

doc add "Variables (Config)/Internal/default_user" "The user part of nick!~user@host.  This setting will show up if ident does not respond or the ident response is not used."
config default default_user [set ::dynamic::default_user $env(USER)]

doc add "Variables (Config)/Internal/default_geometry" "This is the geometry (position and size on screen) the client will use initially."
config default default_geometry [set ::dynamic::default_geometry 600x400+10+10]

doc add "Variables (Config)/Internal/do_rawview" "The variable that determines if raw output/input will be sent to the rawview window which is accessed with /rawview."
config default do_rawview [set ::dynamic::do_rawview 0]
config type do_rawview boolean

doc add "Variables (Config)/Internal/first_time" "This variable is used to detect if instructions should be given on how to set QuIRC up for the first time.  Turn it off to disable them.  This variable also disables autoconnect."
config default first_time [set ::dynamic::first_time 1]
config type first_time boolean

doc add "Variables (Config)/Internal/lag_time" "The lag checking frequency in seconds.  Set it to 0 to disable the lag checker."
config default lag_time [set ::dynamic::lag_time 10]

doc add "Variables (Config)/Internal/max_modes" "The maximum number of mode changes QuIRC will send at a single time."
config default max_modes [set ::dynamic::max_modes 3]

doc add "Variables (Config)/Internal/mute_all" "This is a listing of channels in which to mute all joins, parts, quits, mode changes, nick changes, and kicks.  It is useful for joining large sessions in which you don't want the text to be disturbed by the many non-consequential events occuring.  The nicklist will still be updated but the messages themselves will not be displayed.  Events that involve you will not be muted."
config default mute_all [set ::dynamic::mute_all ""]

doc add "Variables (Config)/Internal/mute_join" "This is a list of channels in which to mute joins.  See mute_all for more details."
config default mute_join [set ::dynamic::mute_join ""]

doc add "Variables (Config)/Internal/mute_kick" "This is a list of channels in which to mute kicks.  See mute_all for more details."
config default mute_kick [set ::dynamic::mute_kick ""]

doc add "Variables (Config)/Internal/mute_mode" "This is a list of channels in which to mute mode changes.  Mode changes will be muted, even if they affect you, unless you generate the mode changes.  See mute_all for more details."
config default mute_mode [set ::dynamic::mute_mode ""]

doc add "Variables (Config)/Internal/mute_nick" "This is a list of channels in which to mute nick changes.  See mute_all for more details."
config default mute_nick [set ::dynamic::mute_nick ""]

doc add "Variables (Config)/Internal/mute_part" "This is a list of channels in which to mute parts.  See mute_all for more details."
config default mute_part [set ::dynamic::mute_part ""]

doc add "Variables (Config)/Internal/mute_quit" "This is a list of channels in which to mute quits.  See mute_all for more details."
config default mute_quit [set ::dynamic::mute_quit ""]

doc add "Variables (Config)/Internal/nick_complete_cycle" "Turn this on to enable cycling within the nick completion engine."
config default nick_complete_cycle [set ::dynamic::nick_complete_cycle 1]
config type nick_complete_cycle boolean

doc add "Variables (Config)/Internal/nick_complete_postfix" "The string inserted after the end of a completed nick."
config default nick_complete_postfix [set ::dynamic::nick_complete_postfix " "]

doc add "Variables (Config)/Internal/nick_complete_seperator" "The seperator used after the nick at the beginning of a line for nick complete."
config default nick_complete_seperator [set ::dynamic::nick_complete_seperator ": "]

doc add "Variables (Config)/Internal/nicklist_scrollbar" "This sets whether or not there will be a scrollbar displayed for the nicklist.  If no scrollbar is displayed, you can scroll using either Ctrl-PgUp/PgDn or by dragging the nicklist with the middle mouse button."
config default nicklist_scrollbar [set ::dynamic::nicklist_scrollbar 1]
config type nicklist_scrollbar boolean

doc add "Variables (Config)/Internal/nicklist_side" "Changes the side on which the nicklist is displayed.  This can be set to either left or right."
config default nicklist_side [set ::dynamic::nicklist_side right]

doc add "Variables (Config)/Internal/rename_servers" "If this is turned on, QuIRC will rename the status window based on what the server claims it is."
config default rename_servers [set ::dynamic::rename_servers 1]
config type rename_servers boolean

doc add "Variables (Config)/Internal/scrollback_length" "The number of lines in the scrollback buffer.  Once this limit is hit, a line will be removed for every line added.  Set this to 0 to disable limiting (may cause sizeable memory usage)."
config default scrollback_length [set ::dynamic::scrollback_length 1000]

doc add "Variables (Config)/Internal/theme" "The tcl file that controls what the majority of the stuff in QuIRC looks like.  It controls output and colors and such."
config default theme [set ::dynamic::theme default.tcl]

doc add "Variables (Config)/Internal/timestamp" "If you are using Tk 8.3 or above, this will set whether the timestamp is turned on or off when QuIRC is started.  With 8.3, you can use Ctrl-t to toggle the timestamp.  If you are using something below 8.3, turning this on will put a non-toggleable timestamp in front of displayed text.  When turned off, the text will not have any timestamp."
config default timestamp [set ::dynamic::timestamp 0]
config type timestamp boolean

doc add "Variables (Config)/Internal/timestamp_format" "The format to use for the timestamp.  For available formats, see the documentation for the clock format tcl command."
config default timestamp_format [set ::dynamic::timestamp_format "\[%m/%d %H:%M:%S]"]

doc add "Variables (Config)/Internal/url_command" "This is used to configure the command used when urls are clicked on.  If you want the built in intelligent netscape handler, use builtin_netscape as the command.  Otherwise, write your command with %u wherever you want the url to appear."
config default url_command [set ::dynamic::url_command "builtin_netscape"]

doc add "Variables (Config)/Internal/url_highlighting" "This setting is used to control whether or not urls will be highlighted and clickable."
config default url_highlighting [set ::dynamic::url_highlighting 1]
config type url_highlighting boolean

doc add "Variables (Config)/Internal/windowlist_nick_highlight" "Make QuIRC highlight a windowlist entry whenever your nick appears in that window."
config default windowlist_nick_highlight [set ::dynamic::windowlist_nick_highlight 1]
config type windowlist_nick_highlight boolean


# Giant list of theme variables (Thanks DawnRazor!)
# These need sorted better.

doc add "Variables (Config)/Internal/theme_windowlist_specialforeground" "Foreground color of an entry in the window list when some trigger text appears in the window."

doc add "Variables (Config)/Internal/theme_windowlist_specialbackground" "Background color of an entry in the window list when some trigger text appears in the window."

doc add "Variables (Config)/Internal/theme_windowlist_activeforeground" "Foreground color of the window list entry of an 'active' channel/window."

doc add "Variables (Config)/Internal/theme_windowlist_activebackground" "Background color of the window list entry of an 'active' channel/window."

doc add "Variables (Config)/Internal/theme_windowlist_selectforeground" "Foreground color of the window list entry of the selected channel/window."

doc add "Variables (Config)/Internal/theme_windowlist_selectbackground" "Background color of the window list entry of the selected channel/window."

doc add "Variables (Config)/Internal/theme_windowlist_font" "Font used in display of the window list."
config command theme_windowlist_font {
    .windowlist.t configure -font $::dynamic::theme_windowlist_font
}

doc add "Variables (Config)/Internal/theme_windowlist_width" "Width in pixels of the window list."
config command theme_windowlist_width {
    .windowlist configure -width $::dynamic::theme_windowlist_width
}

doc add "Variables (Config)/Internal/theme_windowlist_background" "The background color of the window list."
config command theme_windowlist_background {
    .windowlist.t configure -bg $::dynamic::theme_windowlist_background
}

doc add "Variables (Config)/Internal/theme_windowlist_indent" "The characters used to indent items such as channels and queries in the window list."

doc add "Variables (Config)/Internal/theme_color" "Color Map for CTRL-C color codes."  

doc add "Variables (Config)/Internal/theme_buttonbar_background" "The background color of the button bar."
config command theme_buttonbar_background {
    .buttonbar configure -bg $::dynamic::theme_buttonbar_background
}

doc add "Variables (Config)/Internal/theme_button_condis_foreground" "The foreground color of the Connect/Disconnect button."
config command theme_button_condis_foreground {
    .buttonbar.condis configure -fg $::dynamic::theme_button_condis_foreground
}

doc add "Variables (Config)/Internal/theme_button_condis_background" "The background color of the Connect/Disconnect button."
config command theme_button_condis_background {
    .buttonbar.condis configure -bg $::dynamic::theme_button_condis_background
}

doc add "Variables (Config)/Internal/theme_button_condis_activeforeground" "The foreground color when the mouse is over the Connect/Disconnect button."
config command theme_button_condis_activeforeground {
    .buttonbar.condis configure -activeforeground $::dynamic::theme_button_condis_activeforeground
}

doc add "Variables (Config)/Internal/theme_button_condis_activebackground" "The background color when the mouse is over the Connect/Disconnect button."
config command theme_button_condis_activebackground {
    .buttonbar.condis configure -activebackground $::dynamic::theme_button_condis_activebackground
}

doc add "Variables (Config)/Internal/theme_button_close_foreground" "The foreground color of the Close button."
config command theme_button_close_foreground {
    .buttonbar.close configure -fg $::dynamic::theme_button_close_foreground
}

doc add "Variables (Config)/Internal/theme_button_close_background" "The background color of the Close button."
config command theme_button_close_background {
    .buttonbar.close configure -bg $::dynamic::theme_button_close_background
}

doc add "Variables (Config)/Internal/theme_button_close_activeforeground" "The foreground color when the mouse is over the Close button."
config command theme_button_close_activeforeground {
    .buttonbar.close configure -activeforeground $::dynamic::theme_button_close_activeforeground
}

doc add "Variables (Config)/Internal/theme_button_close_activebackground" "The background color when the mouse is over the Close button."
config command theme_button_close_activebackground {
    .buttonbar.close configure -activebackground $::dynamic::theme_button_close_activebackground
}

doc add "Variables (Config)/Internal/theme_button_menu_foreground" "The foreground color of the Menu button."
config command theme_button_menu_foreground {
    .buttonbar.menu configure -fg $::dynamic::theme_button_menu_foreground
}

doc add "Variables (Config)/Internal/theme_button_menu_background" "The background color of the Menu button."
config command theme_button_menu_background {
    .buttonbar.menu configure -bg $::dynamic::theme_button_menu_background
}

doc add "Variables (Config)/Internal/theme_button_menu_activeforeground" "The foreground color when the mouse is over the Menu button."
config command theme_button_menu_activeforeground {
    .buttonbar.menu configure -activeforeground $::dynamic::theme_button_menu_activeforeground
}

doc add "Variables (Config)/Internal/theme_button_menu_activebackground" "The background color when the mouse is over the Menu button."
config command theme_button_menu_activebackground {
    .buttonbar.menu configure -activebackground $::dynamic::theme_button_menu_activebackground
}

doc add "Variables (Config)/Internal/theme_lag_background" "The background color of the lag meter."
config command theme_lag_background {
    .buttonbar.lag configure -bg $::dynamic::theme_lag_background
}

doc add "Variables (Config)/Internal/theme_lag_foreground" "The foreground color of the lag meter."
config command theme_lag_foreground {
    .buttonbar.lag configure -fg $::dynamic::theme_lag_foreground
}

doc add "Variables (Config)/Internal/theme_nicklist_foreground" "The foreground color of the nicklist."
config command theme_nicklist_foreground {
 foreach window [windows] {
  if { [windowtype $window] == "channel" } {
    $window.nicks configure -fg $::dynamic::theme_nicklist_foreground
  }
 }
}

doc add "Variables (Config)/Internal/theme_nicklist_background" "The background color of the nicklist."
config command theme_nicklist_background {
 foreach window [windows] {
  if { [windowtype $window] == "channel" } {
    $window.nicks configure -bg $::dynamic::theme_nicklist_background
  }
 }
}

doc add "Variables (Config)/Internal/theme_nicklist_font" "Font used to display text in the nicklist."
config command theme_nicklist_font {
 foreach window [windows] {
  if { [windowtype $window] == "channel" } {
    $window.nicks configure -font $::dynamic::theme_nicklist_font
  }
 }
}

doc add "Variables (Config)/Internal/theme_nicklist_width" "Width in characters of the nicklist."
config command theme_nicklist_width {
 foreach window [windows] {
  if { [windowtype $window] == "channel" } {
    $window.nicks configure -width $::dynamic::theme_nicklist_width
  }
 }
}

doc add "Variables (Config)/Internal/theme_banlist_font" "Font used for the text in the banlist."
config command theme_banlist_font {
 foreach window $::internal::banwindows {
    $window.f.blist configure -font $::dynamic::theme_banlist_font
 }
}

doc add "Variables (Config)/Internal/theme_banlist_foreground" "Foreground color of the banlist."
config command theme_banlist_foreground {
 foreach window $::internal::banwindows {
    $window.f.blist configure -fg $::dynamic::theme_banlist_foreground
 }
}

doc add "Variables (Config)/Internal/theme_banlist_background" "Background color of the banlist."
config command theme_banlist_background {
 foreach window $::internal::banwindows {
    $window.f.blist configure -bg $::dynamic::theme_banlist_background
 }
}

doc add "Variables (Config)/Internal/theme_banlist_title_foreground" "Foreground color of the title in the banlist."
config command theme_banlist_title_foreground {
 foreach window $::internal::banwindows {
    $window.top configure -fg $::dynamic::theme_banlist_title_foreground
 }
}

doc add "Variables (Config)/Internal/theme_banlist_title_background" "Background color of the title in the banlist."
config command theme_banlist_title_background {
 foreach window $::internal::banwindows {
    $window.top configure -bg $::dynamic::theme_banlist_title_background
 }
}

doc add "Variables (Config)/Internal/theme_banlist_entry_foreground" "Foreground color of the entry bar in the banlist."
config command theme_banlist_entry_foreground {
 foreach window $::internal::banwindows {
    $window.add configure -fg $::dynamic::theme_banlist_entry_foreground
 }
}

doc add "Variables (Config)/Internal/theme_banlist_entry_background" "Background color of the entry bar in the banlist."
config command theme_banlist_entry_background {
 foreach window $::internal::banwindows {
    $window.add configure -bg $::dynamic::theme_banlist_entry_background
 }
}

doc add "Variables (Config)/Internal/theme_banlist_entry_insertbackground" "Color of the cursor in the entry box of the banlist."
config command theme_banlist_entry_insertbackground {
 foreach window $::internal::banwindows {
    $window.add configure -insertbackground $::dynamic::theme_banlist_entry_insertbackground
 }
}

doc add "Variables (Config)/Internal/theme_filelist_foreground" "Foreground color of the top of the File DCC window."
config command theme_filelist_foreground {
 foreach window [windows] {
  if { [windowtype $window] == "files" } {
    $window.list configure -fg $::dynamic::theme_filelist_foreground
  }
 }
}

doc add "Variables (Config)/Internal/theme_filelist_background" "Background color of the top of the File DCC window."
config command theme_filelist_background {
 foreach window [windows] {
  if { [windowtype $window] == "files" } {
    $window.list configure -bg $::dynamic::theme_filelist_background
  }
 }
}

doc add "Variables (Config)/Internal/theme_filelist_font" "Font used to display text in the top of the File DCC window."
config command theme_filelist_font {
 foreach window [windows] {
  if { [windowtype $window] == "files" } {
    $window.list configure -font $::dynamic::theme_filelist_font
  }
 }
}

doc add "Variables (Config)/Internal/theme_status_foreground" "Foreground color of the server window."
config type theme_status_foreground irc_color
config command theme_status_foreground {
 foreach window [windows] {
  if { [windowtype $window] == "status" } {
    $window.text configure -fg $::dynamic::theme_color($::dynamic::theme_status_foreground)
  }
 }
}

doc add "Variables (Config)/Internal/theme_status_background" "Background color of the server window."
config type theme_status_background irc_color
config command theme_status_background {
 foreach window [windows] {
  if { [windowtype $window] == "status" } {
    $window.text configure -bg $::dynamic::theme_color($::dynamic::theme_status_background)
  }
 }
}

doc add "Variables (Config)/Internal/theme_status_selectbackground" "Background color of the selected text in the server window."
config command theme_status_selectbackground {
 foreach window [windows] {
  if { [windowtype $window] == "status" } {
    $window.text configure -selectbackground $::dynamic::theme_status_selectbackground
  }
 }
}

doc add "Variables (Config)/Internal/theme_status_selectforeground" "Foreground color of the selected text in the server window."
config command theme_status_selectforeground {
 foreach window [windows] {
  if { [windowtype $window] == "status" } {
    $window.text configure -selectforeground $::dynamic::theme_status_selectforeground
  }
 }
}

doc add "Variables (Config)/Internal/theme_status_selectborderwidth" "Width of the border around selected text in the server window."
config command theme_status_selectborderwidth {
 foreach window [windows] {
  if { [windowtype $window] == "status" } {
    $window.text configure -selectborderwidth $::dynamic::theme_status_selectborderwidth
  }
 }
}

doc add "Variables (Config)/Internal/theme_status_font_normal" "Font used to display standard text in the server window."
config command theme_status_font_normal {
 foreach window [windows] {
  if { [windowtype $window] == "status" } {
    $window.text configure -font $::dynamic::theme_status_font_normal
    configtags $window.text $::dynamic::theme_status_font_normal $::dynamic::theme_status_font_bold
  }
 }
}

doc add "Variables (Config)/Internal/theme_status_font_bold" "Font used to display bold text in the server window."
config command theme_status_font_bold {
 foreach window [windows] {
  if { [windowtype $window] == "status" } {
    configtags $window.text $::dynamic::theme_status_font_normal $::dynamic::theme_status_font_bold
  }
 }
}

doc add "Variables (Config)/Internal/theme_status_entry_foreground" "Foreground color of the entry box in the server window."
config command theme_status_entry_foreground {
 foreach window [windows] {
  if { [windowtype $window] == "status" } {
    $window.entry configure -fg $::dynamic::theme_status_entry_foreground
  }
 }
}

doc add "Variables (Config)/Internal/theme_status_entry_background" "Background color of the entry box in the server window."
config command theme_status_entry_background {
 foreach window [windows] {
  if { [windowtype $window] == "status" } {
    $window.entry configure -bg $::dynamic::theme_status_entry_background
  }
 }
}

doc add "Variables (Config)/Internal/theme_status_entry_font" "Font used to display text in the entry box of the server window."
config command theme_status_entry_font {
 foreach window [windows] {
  if { [windowtype $window] == "status" } {
    $window.entry configure -font $::dynamic::theme_status_entry_font
  }
 }
}

doc add "Variables (Config)/Internal/theme_status_entry_insertbackground" "Color of the cursor in the entry box of the server window."
config command theme_status_entry_insertbackground {
 foreach window [windows] {
  if { [windowtype $window] == "status" } {
    $window.entry configure -insertbackground $::dynamic::theme_status_entry_insertbackground
  }
 }
}

doc add "Variables (Config)/Internal/theme_chat_foreground" "Foreground color of the DCC chat window."
config type theme_chat_foreground irc_color
config command theme_chat_foreground {
 foreach window [windows] {
  if { [windowtype $window] == "chat" } {
    $window.text configure -fg $::dynamic::theme_color($::dynamic::theme_chat_foreground)
  }
 }
}

doc add "Variables (Config)/Internal/theme_chat_background" "Background color of the DCC chat window."
config type theme_chat_background irc_color
config command theme_chat_background {
 foreach window [windows] {
  if { [windowtype $window] == "chat" } {
    $window.text configure -bg $::dynamic::theme_color($::dynamic::theme_chat_background)
  }
 }
}

doc add "Variables (Config)/Internal/theme_chat_selectbackground" "Background color of selected text in the DCC chat window."
config command theme_chat_selectbackground {
 foreach window [windows] {
  if { [windowtype $window] == "chat" } {
    $window.text configure -selectbackground $::dynamic::theme_chat_selectbackground
  }
 }
}

doc add "Variables (Config)/Internal/theme_chat_selectforeground" "Foreground color of selected text in the DCC chat window."
config command theme_chat_selectforeground {
 foreach window [windows] {
  if { [windowtype $window] == "chat" } {
    $window.text configure -selectforeground $::dynamic::theme_chat_selectforeground
  }
 }
}

doc add "Variables (Config)/Internal/theme_chat_selectborderwidth" "Width of the border around selected text in the DCC chat window."
config command theme_chat_selectborderwidth {
 foreach window [windows] {
  if { [windowtype $window] == "chat" } {
    $window.text configure -selectborderwidth $::dynamic::theme_chat_selectborderwidth
  }
 }
}

doc add "Variables (Config)/Internal/theme_chat_font_normal" "Font used to display standard text in the DCC chat window."
config command theme_chat_font_normal {
 foreach window [windows] {
  if { [windowtype $window] == "chat" } {
    $window.text configure -font $::dynamic::theme_chat_font_normal
    configtags $window.text $::dynamic::theme_chat_font_normal $::dynamic::theme_chat_font_bold
  }
 }
}

doc add "Variables (Config)/Internal/theme_chat_font_bold" "Font used to display bold text in the DCC chat window."
config command theme_chat_font_bold {
 foreach window [windows] {
  if { [windowtype $window] == "chat" } {
    configtags $window.text $::dynamic::theme_chat_font_normal $::dynamic::theme_chat_font_bold
  }
 }
}

doc add "Variables (Config)/Internal/theme_chat_entry_foreground" "Foreground color of the entry box in the DCC chat window."
config command theme_chat_entry_foreground {
 foreach window [windows] {
  if { [windowtype $window] == "chat" } {
    $window.entry configure -fg $::dynamic::theme_chat_entry_foreground
  }
 }
}

doc add "Variables (Config)/Internal/theme_chat_entry_background" "Background color of the entry box in the DCC chat window."
config command theme_chat_entry_background {
 foreach window [windows] {
  if { [windowtype $window] == "chat" } {
    $window.entry configure -bg $::dynamic::theme_chat_entry_background
  }
 }
}

doc add "Variables (Config)/Internal/theme_chat_entry_font" "Font used to display text in the entry box of the DCC chat window."
config command theme_chat_entry_font {
 foreach window [windows] {
  if { [windowtype $window] == "chat" } {
    $window.entry configure -font $::dynamic::theme_chat_entry_font
  }
 }
}

doc add "Variables (Config)/Internal/theme_chat_entry_insertbackground" "Color of the cursor in the entry box of the DCC chat window."
config command theme_chat_entry_insertbackground {
 foreach window [windows] {
  if { [windowtype $window] == "chat" } {
    $window.entry configure -insertbackground $::dynamic::theme_chat_entry_insertbackground
  }
 }
}

doc add "Variables (Config)/Internal/theme_files_foreground" "Foreground color of the DCC File window."
config type theme_files_foreground irc_color
config command theme_files_foreground {
 foreach window [windows] {
  if { [windowtype $window] == "files" } {
    $window.text configure -fg $::dynamic::theme_color($::dynamic::theme_files_foreground)
  }
 }
}

doc add "Variables (Config)/Internal/theme_files_background" "Background color of the DCC File window."
config type theme_files_background irc_color
config command theme_files_background {
 foreach window [windows] {
  if { [windowtype $window] == "files" } {
    $window.text configure -bg $::dynamic::theme_color($::dynamic::theme_files_background)
  }
 }
}

doc add "Variables (Config)/Internal/theme_files_selectbackground" "Background color of the selected text in the DCC File window."
config command theme_files_selectbackground {
 foreach window [windows] {
  if { [windowtype $window] == "files" } {
    $window.text configure -selectbackground $::dynamic::theme_files_selectbackground
  }
 }
}

doc add "Variables (Config)/Internal/theme_files_selectforeground" "Foreground color of the selected text in the DCC File window."
config command theme_files_selectforeground {
 foreach window [windows] {
  if { [windowtype $window] == "files" } {
    $window.text configure -selectforeground $::dynamic::theme_files_selectforeground
  }
 }
}

doc add "Variables (Config)/Internal/theme_files_selectborderwidth" "Width of the border around selected text in the DCC File window."
config command theme_files_selectborderwidth {
 foreach window [windows] {
  if { [windowtype $window] == "files" } {
    $window.text configure -selectborderwidth $::dynamic::theme_files_selectborderwidth
  }
 }
}

doc add "Variables (Config)/Internal/theme_files_font_normal" "Font used to display standard text in the DCC File window."
config command theme_files_font_normal {
 foreach window [windows] {
  if { [windowtype $window] == "files" } {
    $window.text configure -font $::dynamic::theme_files_font_normal
    configtags $window.text $::dynamic::theme_files_font_normal $::dynamic::theme_files_font_bold
  }
 }
}

doc add "Variables (Config)/Internal/theme_files_font_bold" "Font used to display bold text in the DCC File window."
config command theme_files_font_bold {
 foreach window [windows] {
  if { [windowtype $window] == "files" } {
    configtags $window.text $::dynamic::theme_files_font_normal $::dynamic::theme_files_font_bold
  }
 }
}

doc add "Variables (Config)/Internal/theme_files_entry_foreground" "Foreground color of the entry box of the DCC File window."
config command theme_files_entry_foreground {
 foreach window [windows] {
  if { [windowtype $window] == "files" } {
    $window.entry configure -fg $::dynamic::theme_files_entry_foreground
  }
 }
}

doc add "Variables (Config)/Internal/theme_files_entry_background" "Background color of the entry box of the DCC File window."
config command theme_files_entry_background {
 foreach window [windows] {
  if { [windowtype $window] == "files" } {
    $window.entry configure -bg $::dynamic::theme_files_entry_background
  }
 }
}

doc add "Variables (Config)/Internal/theme_files_entry_font" "Font used to display text in the entry box of the DCC File window."
config command theme_files_entry_font {
 foreach window [windows] {
  if { [windowtype $window] == "files" } {
    $window.entry configure -font $::dynamic::theme_files_entry_font
  }
 }
}

doc add "Variables (Config)/Internal/theme_files_entry_insertbackground" "Color of the cursor in the entry box of the DCC File window."
config command theme_files_entry_insertbackground {
 foreach window [windows] {
  if { [windowtype $window] == "files" } {
    $window.entry configure -insertbackground $::dynamic::theme_files_entry_insertbackground
  }
 }
}

doc add "Variables (Config)/Internal/theme_main_foreground" "Foreground color of the Main Status window."
config type theme_main_foreground irc_color
config command theme_main_foreground {
    .main.text configure -fg $::dynamic::theme_color($::dynamic::theme_main_foreground)
}

doc add "Variables (Config)/Internal/theme_main_background" "Background color of the Main Status window."
config type theme_main_background irc_color
config command theme_main_background {
    .main.text configure -bg $::dynamic::theme_color($::dynamic::theme_main_background)
}

doc add "Variables (Config)/Internal/theme_main_selectbackground" "Background color of selected text in the Main Status window."
config command theme_main_selectbackground {
    .main.text configure -selectbackground $::dynamic::theme_main_selectbackground
}

doc add "Variables (Config)/Internal/theme_main_selectforeground" "Foreground color of selected text in the Main Status window."
config command theme_main_selectforeground {
    .main.text configure -selectforeground $::dynamic::theme_main_selectforeground
}

doc add "Variables (Config)/Internal/theme_main_selectborderwidth" "Width of the border around selected text in the Main Status window."
config command theme_main_selectborderwidth {
    .main.text configure -selectborderwidth $::dynamic::theme_main_selectborderwidth
}

doc add "Variables (Config)/Internal/theme_main_font_normal" "Font used to display standard text in the Main Status window."
config command theme_main_font_normal {
    .main.text configure -font $::dynamic::theme_main_font_normal
    configtags .main.text $::dynamic::theme_main_font_normal $::dynamic::theme_main_font_bold
}

doc add "Variables (Config)/Internal/theme_main_font_bold" "Font used to display bold text in the Main Status window."
config command theme_main_font_bold {
    configtags .main.text $::dynamic::theme_main_font_normal $::dynamic::theme_main_font_bold
}

doc add "Variables (Config)/Internal/theme_main_entry_foreground" "Foreground color of the entry box in the Main Status window."
config command theme_main_entry_foreground {
    .main.entry configure -fg $::dynamic::theme_main_entry_foreground
}

doc add "Variables (Config)/Internal/theme_main_entry_background" "Background color of the entry box in the Main Status window."
config command theme_main_entry_background {
    .main.entry configure -bg $::dynamic::theme_main_entry_background
}

doc add "Variables (Config)/Internal/theme_main_entry_font" "Font used to display text in the entry box of the Main Status window."
config command theme_main_entry_font {
    .main.entry configure -font $::dynamic::theme_main_entry_font
}

doc add "Variables (Config)/Internal/theme_main_entry_insertbackground" "Color of the cursor in the entry box of the Main Status window."
config command theme_main_entry_insertbackground {
    .main.entry configure -insertbackground $::dynamic::theme_main_entry_insertbackground
}

doc add "Variables (Config)/Internal/theme_channel_foreground" "Foreground color of the channel window."
config type theme_channel_foreground irc_color
config command theme_channel_foreground {
 foreach window [windows] {
  if { [windowtype $window] == "channel" } {
    $window.text configure -fg $::dynamic::theme_color($::dynamic::theme_channel_foreground)
  }
 }
}

doc add "Variables (Config)/Internal/theme_channel_background" "Background color of the channel window."
config type theme_channel_background irc_color
config command theme_channel_background {
 foreach window [windows] {
  if { [windowtype $window] == "channel" } {
    $window.text configure -bg $::dynamic::theme_color($::dynamic::theme_channel_background)
  }
 }
}

doc add "Variables (Config)/Internal/theme_channel_selectbackground" "Background color of selected text in the channel window."
config command theme_channel_selectbackground {
 foreach window [windows] {
  if { [windowtype $window] == "channel" } {
    $window.text configure -selectbackground $::dynamic::theme_channel_selectbackground
  }
 }
}

doc add "Variables (Config)/Internal/theme_channel_selectforeground" "Foreground color of selected text in the channel window."
config command theme_channel_selectforeground {
 foreach window [windows] {
  if { [windowtype $window] == "channel" } {
    $window.text configure -selectforeground $::dynamic::theme_channel_selectforeground
  }
 }
}

doc add "Variables (Config)/Internal/theme_channel_selectborderwidth" "Width of the border around selected text in the channel window."
config command theme_channel_selectborderwidth {
 foreach window [windows] {
  if { [windowtype $window] == "channel" } {
    $window.text configure -selectborderwidth $::dynamic::theme_channel_selectborderwidth
  }
 }
}

doc add "Variables (Config)/Internal/theme_channel_font_normal" "Font used to display standard text in the channel window."
config command theme_channel_font_normal {
 foreach window [windows] {
  if { [windowtype $window] == "channel" } {
    $window.text configure -font $::dynamic::theme_channel_font_normal
    configtags $window.text $::dynamic::theme_channel_font_normal $::dynamic::theme_channel_font_bold
  }
 }
}

doc add "Variables (Config)/Internal/theme_channel_font_bold" "Font used to display bold text in the channel window."
config command theme_channel_font_bold {
 foreach window [windows] {
  if { [windowtype $window] == "channel" } {
    configtags $window.text $::dynamic::theme_channel_font_normal $::dynamic::theme_channel_font_bold
  }
 }
}

doc add "Variables (Config)/Internal/theme_channel_entry_foreground" "Foreground color of the entry box of the channel window."
config command theme_channel_entry_foreground {
 foreach window [windows] {
  if { [windowtype $window] == "channel" } {
    $window.entry configure -fg $::dynamic::theme_channel_entry_foreground
  }
 }
}

doc add "Variables (Config)/Internal/theme_channel_entry_background" "Background color of the entry box of the channel window."
config command theme_channel_entry_background {
 foreach window [windows] {
  if { [windowtype $window] == "channel" } {
    $window.entry configure -bg $::dynamic::theme_channel_entry_background
  }
 }
}

doc add "Variables (Config)/Internal/theme_channel_entry_font" "Font used to display text in the entry box of the channel window."
config command theme_channel_entry_font {
 foreach window [windows] {
  if { [windowtype $window] == "channel" } {
    $window.entry configure -font $::dynamic::theme_channel_entry_font
  }
 }
}

doc add "Variables (Config)/Internal/theme_channel_entry_insertbackground" "Color of the cursor in the entry box of the channel window."
config command theme_channel_entry_insertbackground {
 foreach window [windows] {
  if { [windowtype $window] == "channel" } {
    $window.entry configure -insertbackground $::dynamic::theme_channel_entry_insertbackground
  }
 }
}

doc add "Variables (Config)/Internal/theme_query_foreground" "Foreground color of the query window."
config type theme_query_foreground irc_color
config command theme_query_foreground {
 foreach window [windows] {
  if { [windowtype $window] == "query" } {
    $window.text configure -fg $::dynamic::theme_color($::dynamic::theme_query_foreground)
  }
 }
}

doc add "Variables (Config)/Internal/theme_query_background" "Background color of the query window."
config type theme_query_background irc_color
config command theme_query_background {
 foreach window [windows] {
  if { [windowtype $window] == "query" } {
    $window.text configure -bg $::dynamic::theme_color($::dynamic::theme_query_background)
  }
 }
}

doc add "Variables (Config)/Internal/theme_query_selectbackground" "Background color of selected text in the query window."
config command theme_query_selectbackground {
 foreach window [windows] {
  if { [windowtype $window] == "query" } {
    $window.text configure -selectbackground $::dynamic::theme_query_selectbackground
  }
 }
}

doc add "Variables (Config)/Internal/theme_query_selectforeground" "Foreground color of selected text in the query window."
config command theme_query_selectforeground {
 foreach window [windows] {
  if { [windowtype $window] == "query" } {
    $window.text configure -selectforeground $::dynamic::theme_query_selectforeground
  }
 }
}

doc add "Variables (Config)/Internal/theme_query_selectborderwidth" "Width of the border around the selected text in the query window."
config command theme_query_selectborderwidth {
 foreach window [windows] {
  if { [windowtype $window] == "query" } {
    $window.text configure -selectborderwidth $::dynamic::theme_query_selectborderwidth
  }
 }
}

doc add "Variables (Config)/Internal/theme_query_font_normal" "Font used to display standard text in the query window."
config command theme_query_font_normal {
 foreach window [windows] {
  if { [windowtype $window] == "query" } {
    $window.text configure -font $::dynamic::theme_query_font_normal
    configtags $window.text $::dynamic::theme_query_font_normal $::dynamic::theme_query_font_bold
  }
 }
}

doc add "Variables (Config)/Internal/theme_query_font_bold" "Font used to display bold text in the query window."
config command theme_query_font_bold {
 foreach window [windows] {
  if { [windowtype $window] == "query" } {
    configtags $window.text $::dynamic::theme_query_font_normal $::dynamic::theme_query_font_bold
  }
 }
}

doc add "Variables (Config)/Internal/theme_query_entry_foreground" "Foreground color of the entry box of the query window."
config command theme_query_entry_foreground {
 foreach window [windows] {
  if { [windowtype $window] == "query" } {
    $window.entry configure -fg $::dynamic::theme_query_entry_foreground
  }
 }
}

doc add "Variables (Config)/Internal/theme_query_entry_background" "Background color of the entry box of the query window."
config command theme_query_entry_background {
 foreach window [windows] {
  if { [windowtype $window] == "query" } {
    $window.entry configure -bg $::dynamic::theme_query_entry_background
  }
 }
}

doc add "Variables (Config)/Internal/theme_query_entry_font" "Font used to display text in the entry box of the query window."
config command theme_query_entry_font {
 foreach window [windows] {
  if { [windowtype $window] == "query" } {
    $window.entry configure -font $::dynamic::theme_query_entry_font
  }
 }
}

doc add "Variables (Config)/Internal/theme_query_entry_insertbackground" "Color of the cursor in the entry box of the query window."
config command theme_query_entry_insertbackground {
 foreach window [windows] {
  if { [windowtype $window] == "query" } {
    $window.entry configure -insertbackground $::dynamic::theme_query_entry_insertbackground
  }
 }
}

# This is where the FSET docs will go...
# Here is a sample.

doc add "FSETs (Server)/Internal/CTCP_REPLY_DATA" "CTCP_REPLY_DATA

CTCP Reply with data.

0 = Type
1 = Nick
2 = Argument"

doc add "FSETs (Global)/Internal/DNS_ERROR" "DNS_ERROR

A DNS lookup error message.

0 = The error message."
