/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.ls.WriterOutputStream;
import gnu.xml.transform.SAXSerializer;
import gnu.xml.transform.StreamSerializer;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TransformerFactoryImpl;
import gnu.xml.transform.TransformerOutputProperties;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

class TransformerImpl
extends Transformer {
    static final String INDENT_WHITESPACE = "  ";
    final TransformerFactoryImpl factory;
    final Stylesheet stylesheet;
    URIResolver uriResolver;
    ErrorListener errorListener;
    Properties outputProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transform(Source xmlSource, Result outputTarget) throws TransformerException {
        var4_3 = this.factory.resolver;
        synchronized (var4_3) {
            this.factory.resolver.setUserResolver(this.uriResolver);
            this.factory.resolver.setUserListener(this.errorListener);
            source = this.factory.resolver.resolveDOM(xmlSource, null, null);
            // MONITOREXIT @DISABLED, blocks:[0, 5] lbl7 : MonitorExitStatement: MONITOREXIT : var4_3
            context = source.getNode();
        }
        v1 = doc = context instanceof Document != false ? (Document)context : context.getOwnerDocument();
        if (doc instanceof DomDocument) {
            ((DomDocument)doc).setBuilding(true);
        }
        parent = null;
        nextSibling = null;
        if (outputTarget instanceof DOMResult) {
            dr = (DOMResult)outputTarget;
            parent = dr.getNode();
            nextSibling = dr.getNextSibling();
            v2 = rdoc = parent instanceof Document != false ? (Document)parent : parent.getOwnerDocument();
            if (rdoc instanceof DomDocument) {
                drdoc = (DomDocument)rdoc;
                drdoc.setBuilding(true);
                drdoc.setCheckWellformedness(false);
            }
        }
        created = false;
        if (this.stylesheet != null) {
            if (parent == null) {
                resultDoc = new DomDocument();
                resultDoc.setBuilding(true);
                resultDoc.setCheckWellformedness(false);
                parent = resultDoc;
                created = true;
            }
            context = context.cloneNode(true);
            this.strip(context);
            try {
                ((TransformerOutputProperties)this.outputProperties).apply();
                this.stylesheet.initTopLevelVariables(context);
                t = this.stylesheet.getTemplate(null, context, false);
                if (t == null) ** GOTO lbl71
                this.stylesheet.current = context;
                t.apply(this.stylesheet, null, context, 1, 1, parent, nextSibling);
            }
            catch (TransformerException e) {
                if (doc instanceof DomDocument == false) throw e;
                ((DomDocument)doc).setBuilding(false);
                throw e;
            }
        } else {
            clone = context.cloneNode(true);
            if (context.getNodeType() != 9) {
                if (parent == null) {
                    rd = new DomDocument();
                    rd.setBuilding(true);
                    rd.setCheckWellformedness(false);
                    resultDoc = rd;
                    parent = resultDoc;
                    created = true;
                } else {
                    resultDoc = parent instanceof Document != false ? (Document)parent : parent.getOwnerDocument();
                }
                sourceDoc = context.getOwnerDocument();
                if (sourceDoc != resultDoc) {
                    clone = resultDoc.adoptNode(clone);
                }
                if (nextSibling != null) {
                    parent.insertBefore(clone, nextSibling);
                } else {
                    parent.appendChild(clone);
                }
            } else {
                parent = clone;
                created = true;
            }
        }
        method = this.outputProperties.getProperty("method");
        v3 = 1;
        if (!"html".equals(method)) {
            v3 = "text".equals(method) != false ? 2 : 0;
        }
        outputMethod = v3;
        encoding = this.outputProperties.getProperty("encoding");
        publicId = this.outputProperties.getProperty("doctype-public");
        systemId = this.outputProperties.getProperty("doctype-system");
        version = this.outputProperties.getProperty("version");
        omitXmlDeclaration = "yes".equals(this.outputProperties.getProperty("omit-xml-declaration"));
        standalone = "yes".equals(this.outputProperties.getProperty("standalone"));
        mediaType = this.outputProperties.getProperty("media-type");
        cdataSectionElements = this.outputProperties.getProperty("cdata-section-elements");
        indent = "yes".equals(this.outputProperties.getProperty("indent"));
        if (created) {
            resultDoc = (DomDocument)parent;
            root = resultDoc.getDocumentElement();
            if ((publicId != null || systemId != null) && root != null) {
                resultDoc.appendChild(new DomDoctype((DomDocument)resultDoc, root.getNodeName(), publicId, systemId));
            }
            resultDoc.setBuilding(false);
            resultDoc.setCheckWellformedness(true);
        } else if (publicId != null || systemId != null) {
            block6 : switch (parent.getNodeType()) {
                case 9: 
                case 11: {
                    resultDoc = parent instanceof Document != false ? (Document)parent : parent.getOwnerDocument();
                    impl = resultDoc.getImplementation();
                    doctype = impl.createDocumentType(resultDoc.getNodeName(), publicId, systemId);
                    ctx = parent.getFirstChild();
                    while (true) {
                        if (ctx == null || ctx.getNodeType() == 1) {
                            if (ctx == null) break;
                            parent.insertBefore(doctype, ctx);
                            break block6;
                        }
                        ctx = ctx.getNextSibling();
                    }
                    parent.appendChild(doctype);
                    break;
                }
            }
        }
        if (version != null) {
            parent.setUserData("version", version, this.stylesheet);
        }
        if (omitXmlDeclaration) {
            parent.setUserData("omit-xml-declaration", "yes", this.stylesheet);
        }
        if (standalone) {
            parent.setUserData("standalone", "yes", this.stylesheet);
        }
        if (mediaType != null) {
            parent.setUserData("media-type", mediaType, this.stylesheet);
        }
        if (cdataSectionElements != null) {
            list = new LinkedList();
            st = new StringTokenizer(cdataSectionElements);
            while (st.hasMoreTokens()) {
                localName = name = st.nextToken();
                uri = null;
                prefix = null;
                ci = name.indexOf(58);
                if (ci != -1) {
                    prefix = name.substring(0, ci);
                    localName = name.substring(ci + 1);
                    uri = this.stylesheet.output.lookupNamespaceURI(prefix);
                }
                list.add(new QName(uri, localName, prefix));
            }
            if (!list.isEmpty()) {
                resultDoc = parent instanceof Document != false ? (Document)parent : parent.getOwnerDocument();
                this.convertCdataSectionElements(resultDoc, parent, list);
            }
        }
        if (indent) {
            parent.normalize();
            this.strip(parent);
            resultDoc = parent instanceof Document != false ? (Document)parent : parent.getOwnerDocument();
            this.reindent(resultDoc, parent, 0);
        }
        if (outputTarget instanceof DOMResult) {
            if (created == false) return;
            dr = (DOMResult)outputTarget;
            dr.setNode(parent);
            dr.setNextSibling(null);
            return;
        }
        if (outputTarget instanceof StreamResult) {
            sr = (StreamResult)outputTarget;
            ex = null;
            try {
                this.writeStreamResult(parent, (StreamResult)sr, outputMethod, encoding);
            }
            catch (UnsupportedEncodingException e) {
                try {
                    this.writeStreamResult(parent, (StreamResult)sr, outputMethod, "UTF-8");
                }
                catch (IOException e2) {
                    ex = e2;
                }
            }
            catch (IOException e) {
                ex = e;
            }
            if (ex == null) return;
            if (this.errorListener != null) {
                this.errorListener.error(new TransformerException(ex));
                return;
            }
            ex.printStackTrace(System.err);
            return;
        }
        if (outputTarget instanceof SAXResult == false) return;
        sr = (SAXResult)outputTarget;
        try {
            ch = sr.getHandler();
            lh = sr.getLexicalHandler();
            if (lh == null && ch instanceof LexicalHandler) {
                lh = (LexicalHandler)ch;
            }
            serializer = new SAXSerializer();
            serializer.serialize(parent, ch, lh);
            return;
        }
        catch (SAXException e) {
            if (this.errorListener != null) {
                this.errorListener.error(new TransformerException(e));
                return;
            }
            e.printStackTrace(System.err);
        }
    }

    void strip(Node node2) throws TransformerConfigurationException {
        block6: {
            block4: {
                String stripped;
                block5: {
                    short nt = node2.getNodeType();
                    if (nt == 5) {
                        Node parent = node2.getParentNode();
                        Node child = node2.getFirstChild();
                        if (child != null) {
                            this.strip(child);
                        }
                        while (child != null) {
                            Node next = child.getNextSibling();
                            node2.removeChild(child);
                            parent.insertBefore(child, node2);
                            child = next;
                        }
                        parent.removeChild(node2);
                    }
                    if (nt != 3 && nt != 4) break block4;
                    if (this.stylesheet.isPreserved((Text)node2)) break block5;
                    node2.getParentNode().removeChild(node2);
                    break block6;
                }
                String text = node2.getNodeValue();
                if (text.equals(stripped = text.trim())) break block6;
                node2.setNodeValue(stripped);
                break block6;
            }
            Node child = node2.getFirstChild();
            while (child != null) {
                this.strip(child);
                child = child.getNextSibling();
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void writeStreamResult(Node node2, StreamResult sr, int outputMethod, String encoding) throws IOException {
        OutputStream out = null;
        try {
            Writer writer;
            out = sr.getOutputStream();
            if (out == null && (writer = sr.getWriter()) != null) {
                out = new WriterOutputStream(writer);
            }
            if (out == null) {
                String systemId = sr.getSystemId();
                try {
                    URL url = new URL(systemId);
                    URLConnection connection = url.openConnection();
                    connection.setDoInput(false);
                    connection.setDoOutput(true);
                    out = connection.getOutputStream();
                }
                catch (MalformedURLException e) {
                    out = new FileOutputStream(systemId);
                }
                catch (UnknownServiceException e) {
                    URL url = new URL(systemId);
                    out = new FileOutputStream(url.getPath());
                }
            }
            out = new BufferedOutputStream(out);
            StreamSerializer serializer = new StreamSerializer(outputMethod, encoding, null);
            if (this.stylesheet != null) {
                Collection celem = this.stylesheet.outputCdataSectionElements;
                serializer.setCdataSectionElements(celem);
            }
            serializer.serialize(node2, out);
            out.flush();
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            try {
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var7_14 = null;
        }
        try {}
        catch (IOException e) {
            return;
        }
        if (out == null) return;
        out.close();
    }

    void copyChildren(Document dstDoc, Node src, Node dst) {
        Node srcChild = src.getFirstChild();
        while (srcChild != null) {
            Node dstChild = dstDoc.adoptNode(srcChild);
            dst.appendChild(dstChild);
            srcChild = srcChild.getNextSibling();
        }
    }

    public void setParameter(String name, Object value) {
        if (this.stylesheet != null) {
            this.stylesheet.bindings.set(new QName(null, name), value, 1);
        }
    }

    public Object getParameter(String name) {
        if (this.stylesheet != null) {
            return this.stylesheet.bindings.get(new QName(null, name), null, 1, 1);
        }
        return null;
    }

    public void clearParameters() {
        if (this.stylesheet != null) {
            this.stylesheet.bindings.pop(1);
            this.stylesheet.bindings.push(1);
        }
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setOutputProperties(Properties oformat) throws IllegalArgumentException {
        if (oformat == null) {
            this.outputProperties.clear();
        } else {
            this.outputProperties.putAll(oformat);
        }
    }

    public Properties getOutputProperties() {
        return (Properties)this.outputProperties.clone();
    }

    public void setOutputProperty(String name, String value) throws IllegalArgumentException {
        this.outputProperties.put(name, value);
    }

    public String getOutputProperty(String name) throws IllegalArgumentException {
        return this.outputProperties.getProperty(name);
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    void reindent(Document doc, Node node2, int offset) {
        if (node2.hasChildNodes()) {
            boolean markupContent = false;
            boolean textContent = false;
            LinkedList children = new LinkedList();
            Node ctx = node2.getFirstChild();
            while (ctx != null) {
                switch (ctx.getNodeType()) {
                    case 1: 
                    case 7: 
                    case 10: {
                        markupContent = true;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: {
                        textContent = true;
                        break;
                    }
                }
                children.add(ctx);
                ctx = ctx.getNextSibling();
            }
            if (markupContent) {
                short nodeType = node2.getNodeType();
                if (nodeType == 9) {
                    Iterator i = children.iterator();
                    while (i.hasNext()) {
                        ctx = (Node)i.next();
                        this.reindent(doc, ctx, offset + 1);
                    }
                } else {
                    StringBuffer buf = new StringBuffer();
                    buf.append('\n');
                    int i = 0;
                    while (i < offset + 1) {
                        buf.append(INDENT_WHITESPACE);
                        ++i;
                    }
                    String ws = buf.toString();
                    Iterator i2 = children.iterator();
                    while (i2.hasNext()) {
                        ctx = (Node)i2.next();
                        node2.insertBefore(doc.createTextNode(ws), ctx);
                        this.reindent(doc, ctx, offset + 1);
                    }
                    buf = new StringBuffer();
                    buf.append('\n');
                    ws = buf.toString();
                    int i22 = 0;
                    while (i22 < offset) {
                        buf.append(INDENT_WHITESPACE);
                        ++i22;
                    }
                    node2.appendChild(doc.createTextNode(ws));
                }
            }
        }
    }

    void convertCdataSectionElements(Document doc, Node node2, List list2) {
        if (node2.getNodeType() == 1) {
            boolean match = false;
            Iterator i = list2.iterator();
            while (i.hasNext()) {
                QName qname = (QName)i.next();
                if (!this.match(qname, node2)) continue;
                match = true;
                break;
            }
            if (match) {
                Node ctx = node2.getFirstChild();
                while (ctx != null) {
                    if (ctx.getNodeType() == 3) {
                        CDATASection cdata = doc.createCDATASection(ctx.getNodeValue());
                        node2.replaceChild(cdata, ctx);
                        ctx = cdata;
                    }
                    ctx = ctx.getNextSibling();
                }
            }
        }
        Node ctx = node2.getFirstChild();
        while (ctx != null) {
            if (ctx.hasChildNodes()) {
                this.convertCdataSectionElements(doc, ctx, list2);
            }
            ctx = ctx.getNextSibling();
        }
    }

    boolean match(QName qname, Node node2) {
        String ln1 = qname.getLocalPart();
        String ln2 = node2.getLocalName();
        if (ln2 == null) {
            return ln1.equals(node2.getNodeName());
        }
        String uri1 = qname.getNamespaceURI();
        String uri2 = node2.getNamespaceURI();
        boolean bl = false;
        if (uri1.equals(uri2) && ln1.equals(ln2)) {
            bl = true;
        }
        return bl;
    }

    TransformerImpl(TransformerFactoryImpl factory, Stylesheet stylesheet, Properties outputProperties) throws TransformerConfigurationException {
        this.factory = factory;
        this.uriResolver = factory.userResolver;
        this.errorListener = factory.userListener;
        this.stylesheet = stylesheet;
        this.outputProperties = outputProperties;
        if (stylesheet != null) {
            stylesheet.bindings.push(1);
        }
    }
}

