require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&SANITIZER_NETBSD_SYSCALL_HOOKS_H)) {
    eval 'sub SANITIZER_NETBSD_SYSCALL_HOOKS_H () {1;}' unless defined(&SANITIZER_NETBSD_SYSCALL_HOOKS_H);
    eval 'sub __sanitizer_syscall_pre_syscall {
        my($code, $arg0, $arg1, $arg2, $arg3, $arg4,					    $arg5, $arg6, $arg7) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_syscall( , , , , , , , , ($arg7)));
    }' unless defined(&__sanitizer_syscall_pre_syscall);
    eval 'sub __sanitizer_syscall_post_syscall {
        my($res, $code, $arg0, $arg1, $arg2, $arg3,					     $arg4, $arg5, $arg6, $arg7) = @_;
	    eval q( &__sanitizer_syscall_post_impl_syscall( $res, , , , , , , , , ($arg7)));
    }' unless defined(&__sanitizer_syscall_post_syscall);
    eval 'sub __sanitizer_syscall_pre_exit {
        my($rval) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_exit(($rval)));
    }' unless defined(&__sanitizer_syscall_pre_exit);
    eval 'sub __sanitizer_syscall_post_exit {
        my($res, $rval) = @_;
	    eval q( &__sanitizer_syscall_post_impl_exit($res, ($rval)));
    }' unless defined(&__sanitizer_syscall_post_exit);
    eval 'sub __sanitizer_syscall_pre_fork () {
        eval q( &__sanitizer_syscall_pre_impl_fork());
    }' unless defined(&__sanitizer_syscall_pre_fork);
    eval 'sub __sanitizer_syscall_post_fork {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fork($res));
    }' unless defined(&__sanitizer_syscall_post_fork);
    eval 'sub __sanitizer_syscall_pre_read {
        my($fd, $buf, $nbyte) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_read(, , ($nbyte)));
    }' unless defined(&__sanitizer_syscall_pre_read);
    eval 'sub __sanitizer_syscall_post_read {
        my($res, $fd, $buf, $nbyte) = @_;
	    eval q( &__sanitizer_syscall_post_impl_read($res, , , ($nbyte)));
    }' unless defined(&__sanitizer_syscall_post_read);
    eval 'sub __sanitizer_syscall_pre_write {
        my($fd, $buf, $nbyte) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_write(, , ($nbyte)));
    }' unless defined(&__sanitizer_syscall_pre_write);
    eval 'sub __sanitizer_syscall_post_write {
        my($res, $fd, $buf, $nbyte) = @_;
	    eval q( &__sanitizer_syscall_post_impl_write($res, , , ($nbyte)));
    }' unless defined(&__sanitizer_syscall_post_write);
    eval 'sub __sanitizer_syscall_pre_open {
        my($path, $flags, $mode) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_open(, , ($mode)));
    }' unless defined(&__sanitizer_syscall_pre_open);
    eval 'sub __sanitizer_syscall_post_open {
        my($res, $path, $flags, $mode) = @_;
	    eval q( &__sanitizer_syscall_post_impl_open($res, , , ($mode)));
    }' unless defined(&__sanitizer_syscall_post_open);
    eval 'sub __sanitizer_syscall_pre_close {
        my($fd) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_close(($fd)));
    }' unless defined(&__sanitizer_syscall_pre_close);
    eval 'sub __sanitizer_syscall_post_close {
        my($res, $fd) = @_;
	    eval q( &__sanitizer_syscall_post_impl_close($res, ($fd)));
    }' unless defined(&__sanitizer_syscall_post_close);
    eval 'sub __sanitizer_syscall_pre_compat_50_wait4 {
        my($pid, $status, $options, $rusage) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_wait4( , , , ($rusage)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_wait4);
    eval 'sub __sanitizer_syscall_post_compat_50_wait4 {
        my($res, $pid, $status, $options,						     $rusage) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_wait4( $res, , , , ($rusage)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_wait4);
    eval 'sub __sanitizer_syscall_pre_compat_43_ocreat {
        my($path, $mode) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_ocreat(, ($mode)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_ocreat);
    eval 'sub __sanitizer_syscall_post_compat_43_ocreat {
        my($res, $path, $mode) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_ocreat($res, , ($mode)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_ocreat);
    eval 'sub __sanitizer_syscall_pre_link {
        my($path, $link) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_link(, ($link)));
    }' unless defined(&__sanitizer_syscall_pre_link);
    eval 'sub __sanitizer_syscall_post_link {
        my($res, $path, $link) = @_;
	    eval q( &__sanitizer_syscall_post_impl_link($res, , ($link)));
    }' unless defined(&__sanitizer_syscall_post_link);
    eval 'sub __sanitizer_syscall_pre_unlink {
        my($path) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_unlink(($path)));
    }' unless defined(&__sanitizer_syscall_pre_unlink);
    eval 'sub __sanitizer_syscall_post_unlink {
        my($res, $path) = @_;
	    eval q( &__sanitizer_syscall_post_impl_unlink($res, ($path)));
    }' unless defined(&__sanitizer_syscall_post_unlink);
    eval 'sub __sanitizer_syscall_pre_chdir {
        my($path) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_chdir(($path)));
    }' unless defined(&__sanitizer_syscall_pre_chdir);
    eval 'sub __sanitizer_syscall_post_chdir {
        my($res, $path) = @_;
	    eval q( &__sanitizer_syscall_post_impl_chdir($res, ($path)));
    }' unless defined(&__sanitizer_syscall_post_chdir);
    eval 'sub __sanitizer_syscall_pre_fchdir {
        my($fd) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fchdir(($fd)));
    }' unless defined(&__sanitizer_syscall_pre_fchdir);
    eval 'sub __sanitizer_syscall_post_fchdir {
        my($res, $fd) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fchdir($res, ($fd)));
    }' unless defined(&__sanitizer_syscall_post_fchdir);
    eval 'sub __sanitizer_syscall_pre_compat_50_mknod {
        my($path, $mode, $dev) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_mknod( , , ($dev)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_mknod);
    eval 'sub __sanitizer_syscall_post_compat_50_mknod {
        my($res, $path, $mode, $dev) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_mknod( $res, , , ($dev)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_mknod);
    eval 'sub __sanitizer_syscall_pre_chmod {
        my($path, $mode) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_chmod(, ($mode)));
    }' unless defined(&__sanitizer_syscall_pre_chmod);
    eval 'sub __sanitizer_syscall_post_chmod {
        my($res, $path, $mode) = @_;
	    eval q( &__sanitizer_syscall_post_impl_chmod($res, , ($mode)));
    }' unless defined(&__sanitizer_syscall_post_chmod);
    eval 'sub __sanitizer_syscall_pre_chown {
        my($path, $uid, $gid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_chown(, , ($gid)));
    }' unless defined(&__sanitizer_syscall_pre_chown);
    eval 'sub __sanitizer_syscall_post_chown {
        my($res, $path, $uid, $gid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_chown($res, , , ($gid)));
    }' unless defined(&__sanitizer_syscall_post_chown);
    eval 'sub __sanitizer_syscall_pre_break {
        my($nsize) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_break(($nsize)));
    }' unless defined(&__sanitizer_syscall_pre_break);
    eval 'sub __sanitizer_syscall_post_break {
        my($res, $nsize) = @_;
	    eval q( &__sanitizer_syscall_post_impl_break($res, ($nsize)));
    }' unless defined(&__sanitizer_syscall_post_break);
    eval 'sub __sanitizer_syscall_pre_compat_20_getfsstat {
        my($buf, $bufsize, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_20_getfsstat( , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_compat_20_getfsstat);
    eval 'sub __sanitizer_syscall_post_compat_20_getfsstat {
        my($res, $buf, $bufsize, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_20_getfsstat( $res, , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_compat_20_getfsstat);
    eval 'sub __sanitizer_syscall_pre_compat_43_olseek {
        my($fd, $offset, $whence) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_olseek( , , ($whence)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_olseek);
    eval 'sub __sanitizer_syscall_post_compat_43_olseek {
        my($res, $fd, $offset, $whence) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_olseek( $res, , , ($whence)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_olseek);
    eval 'sub __sanitizer_syscall_pre_getpid () {
        eval q( &__sanitizer_syscall_pre_impl_getpid());
    }' unless defined(&__sanitizer_syscall_pre_getpid);
    eval 'sub __sanitizer_syscall_post_getpid {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_getpid($res));
    }' unless defined(&__sanitizer_syscall_post_getpid);
    eval 'sub __sanitizer_syscall_pre_compat_40_mount {
        my($type, $path, $flags, $data) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_40_mount( , , , ($data)));
    }' unless defined(&__sanitizer_syscall_pre_compat_40_mount);
    eval 'sub __sanitizer_syscall_post_compat_40_mount {
        my($res, $type, $path, $flags, $data) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_40_mount( $res, , , , ($data)));
    }' unless defined(&__sanitizer_syscall_post_compat_40_mount);
    eval 'sub __sanitizer_syscall_pre_unmount {
        my($path, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_unmount(, ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_unmount);
    eval 'sub __sanitizer_syscall_post_unmount {
        my($res, $path, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_unmount($res, , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_unmount);
    eval 'sub __sanitizer_syscall_pre_setuid {
        my($uid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_setuid(($uid)));
    }' unless defined(&__sanitizer_syscall_pre_setuid);
    eval 'sub __sanitizer_syscall_post_setuid {
        my($res, $uid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_setuid($res, ($uid)));
    }' unless defined(&__sanitizer_syscall_post_setuid);
    eval 'sub __sanitizer_syscall_pre_getuid () {
        eval q( &__sanitizer_syscall_pre_impl_getuid());
    }' unless defined(&__sanitizer_syscall_pre_getuid);
    eval 'sub __sanitizer_syscall_post_getuid {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_getuid($res));
    }' unless defined(&__sanitizer_syscall_post_getuid);
    eval 'sub __sanitizer_syscall_pre_geteuid () {
        eval q( &__sanitizer_syscall_pre_impl_geteuid());
    }' unless defined(&__sanitizer_syscall_pre_geteuid);
    eval 'sub __sanitizer_syscall_post_geteuid {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_geteuid($res));
    }' unless defined(&__sanitizer_syscall_post_geteuid);
    eval 'sub __sanitizer_syscall_pre_ptrace {
        my($req, $pid, $addr, $data) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_ptrace(, , , ($data)));
    }' unless defined(&__sanitizer_syscall_pre_ptrace);
    eval 'sub __sanitizer_syscall_post_ptrace {
        my($res, $req, $pid, $addr, $data) = @_;
	    eval q( &__sanitizer_syscall_post_impl_ptrace($res, , , , ($data)));
    }' unless defined(&__sanitizer_syscall_post_ptrace);
    eval 'sub __sanitizer_syscall_pre_recvmsg {
        my($s, $msg, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_recvmsg(, , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_recvmsg);
    eval 'sub __sanitizer_syscall_post_recvmsg {
        my($res, $s, $msg, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_recvmsg($res, , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_recvmsg);
    eval 'sub __sanitizer_syscall_pre_sendmsg {
        my($s, $msg, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_sendmsg(, , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_sendmsg);
    eval 'sub __sanitizer_syscall_post_sendmsg {
        my($res, $s, $msg, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_sendmsg($res, , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_sendmsg);
    eval 'sub __sanitizer_syscall_pre_recvfrom {
        my($s, $buf, $len, $flags, $from,						      $fromlenaddr) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_recvfrom( , , , , , ($fromlenaddr)));
    }' unless defined(&__sanitizer_syscall_pre_recvfrom);
    eval 'sub __sanitizer_syscall_post_recvfrom {
        my($res, $s, $buf, $len, $flags, $from,						 $fromlenaddr) = @_;
	    eval q( &__sanitizer_syscall_post_impl_recvfrom( $res, , , , , , ($fromlenaddr)));
    }' unless defined(&__sanitizer_syscall_post_recvfrom);
    eval 'sub __sanitizer_syscall_pre_accept {
        my($s, $name, $anamelen) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_accept(, , ($anamelen)));
    }' unless defined(&__sanitizer_syscall_pre_accept);
    eval 'sub __sanitizer_syscall_post_accept {
        my($res, $s, $name, $anamelen) = @_;
	    eval q( &__sanitizer_syscall_post_impl_accept($res, , , ($anamelen)));
    }' unless defined(&__sanitizer_syscall_post_accept);
    eval 'sub __sanitizer_syscall_pre_getpeername {
        my($fdes, $asa, $alen) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_getpeername( , , ($alen)));
    }' unless defined(&__sanitizer_syscall_pre_getpeername);
    eval 'sub __sanitizer_syscall_post_getpeername {
        my($res, $fdes, $asa, $alen) = @_;
	    eval q( &__sanitizer_syscall_post_impl_getpeername( $res, , , ($alen)));
    }' unless defined(&__sanitizer_syscall_post_getpeername);
    eval 'sub __sanitizer_syscall_pre_getsockname {
        my($fdes, $asa, $alen) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_getsockname( , , ($alen)));
    }' unless defined(&__sanitizer_syscall_pre_getsockname);
    eval 'sub __sanitizer_syscall_post_getsockname {
        my($res, $fdes, $asa, $alen) = @_;
	    eval q( &__sanitizer_syscall_post_impl_getsockname( $res, , , ($alen)));
    }' unless defined(&__sanitizer_syscall_post_getsockname);
    eval 'sub __sanitizer_syscall_pre_access {
        my($path, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_access(, ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_access);
    eval 'sub __sanitizer_syscall_post_access {
        my($res, $path, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_access($res, , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_access);
    eval 'sub __sanitizer_syscall_pre_chflags {
        my($path, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_chflags(, ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_chflags);
    eval 'sub __sanitizer_syscall_post_chflags {
        my($res, $path, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_chflags($res, , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_chflags);
    eval 'sub __sanitizer_syscall_pre_fchflags {
        my($fd, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fchflags(, ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_fchflags);
    eval 'sub __sanitizer_syscall_post_fchflags {
        my($res, $fd, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fchflags($res, , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_fchflags);
    eval 'sub __sanitizer_syscall_pre_sync () {
        eval q( &__sanitizer_syscall_pre_impl_sync());
    }' unless defined(&__sanitizer_syscall_pre_sync);
    eval 'sub __sanitizer_syscall_post_sync {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_sync($res));
    }' unless defined(&__sanitizer_syscall_post_sync);
    eval 'sub __sanitizer_syscall_pre_kill {
        my($pid, $signum) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_kill(, ($signum)));
    }' unless defined(&__sanitizer_syscall_pre_kill);
    eval 'sub __sanitizer_syscall_post_kill {
        my($res, $pid, $signum) = @_;
	    eval q( &__sanitizer_syscall_post_impl_kill($res, , ($signum)));
    }' unless defined(&__sanitizer_syscall_post_kill);
    eval 'sub __sanitizer_syscall_pre_compat_43_stat43 {
        my($path, $ub) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_stat43(, ($ub)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_stat43);
    eval 'sub __sanitizer_syscall_post_compat_43_stat43 {
        my($res, $path, $ub) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_stat43($res, , ($ub)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_stat43);
    eval 'sub __sanitizer_syscall_pre_getppid () {
        eval q( &__sanitizer_syscall_pre_impl_getppid());
    }' unless defined(&__sanitizer_syscall_pre_getppid);
    eval 'sub __sanitizer_syscall_post_getppid {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_getppid($res));
    }' unless defined(&__sanitizer_syscall_post_getppid);
    eval 'sub __sanitizer_syscall_pre_compat_43_lstat43 {
        my($path, $ub) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_lstat43(, ($ub)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_lstat43);
    eval 'sub __sanitizer_syscall_post_compat_43_lstat43 {
        my($res, $path, $ub) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_lstat43($res, , ($ub)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_lstat43);
    eval 'sub __sanitizer_syscall_pre_dup {
        my($fd) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_dup(($fd)));
    }' unless defined(&__sanitizer_syscall_pre_dup);
    eval 'sub __sanitizer_syscall_post_dup {
        my($res, $fd) = @_;
	    eval q( &__sanitizer_syscall_post_impl_dup($res, ($fd)));
    }' unless defined(&__sanitizer_syscall_post_dup);
    eval 'sub __sanitizer_syscall_pre_pipe () {
        eval q( &__sanitizer_syscall_pre_impl_pipe());
    }' unless defined(&__sanitizer_syscall_pre_pipe);
    eval 'sub __sanitizer_syscall_post_pipe {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_pipe($res));
    }' unless defined(&__sanitizer_syscall_post_pipe);
    eval 'sub __sanitizer_syscall_pre_getegid () {
        eval q( &__sanitizer_syscall_pre_impl_getegid());
    }' unless defined(&__sanitizer_syscall_pre_getegid);
    eval 'sub __sanitizer_syscall_post_getegid {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_getegid($res));
    }' unless defined(&__sanitizer_syscall_post_getegid);
    eval 'sub __sanitizer_syscall_pre_profil {
        my($samples, $size, $offset, $scale) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_profil(, , , ($scale)));
    }' unless defined(&__sanitizer_syscall_pre_profil);
    eval 'sub __sanitizer_syscall_post_profil {
        my($res, $samples, $size, $offset, $scale) = @_;
	    eval q( &__sanitizer_syscall_post_impl_profil($res, , , , ($scale)));
    }' unless defined(&__sanitizer_syscall_post_profil);
    eval 'sub __sanitizer_syscall_pre_ktrace {
        my($fname, $ops, $facs, $pid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_ktrace(, , , ($pid)));
    }' unless defined(&__sanitizer_syscall_pre_ktrace);
    eval 'sub __sanitizer_syscall_post_ktrace {
        my($res, $fname, $ops, $facs, $pid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_ktrace($res, , , , ($pid)));
    }' unless defined(&__sanitizer_syscall_post_ktrace);
    eval 'sub __sanitizer_syscall_pre_compat_13_sigaction13 {
        my($signum, $nsa, $osa) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_13_sigaction13( , , ($osa)));
    }' unless defined(&__sanitizer_syscall_pre_compat_13_sigaction13);
    eval 'sub __sanitizer_syscall_post_compat_13_sigaction13 {
        my($res, $signum, $nsa, $osa) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_13_sigaction13( $res, , , ($osa)));
    }' unless defined(&__sanitizer_syscall_post_compat_13_sigaction13);
    eval 'sub __sanitizer_syscall_pre_getgid () {
        eval q( &__sanitizer_syscall_pre_impl_getgid());
    }' unless defined(&__sanitizer_syscall_pre_getgid);
    eval 'sub __sanitizer_syscall_post_getgid {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_getgid($res));
    }' unless defined(&__sanitizer_syscall_post_getgid);
    eval 'sub __sanitizer_syscall_pre_compat_13_sigprocmask13 {
        my($how, $mask) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_13_sigprocmask13(, ($mask)));
    }' unless defined(&__sanitizer_syscall_pre_compat_13_sigprocmask13);
    eval 'sub __sanitizer_syscall_post_compat_13_sigprocmask13 {
        my($res, $how, $mask) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_13_sigprocmask13($res, , ($mask)));
    }' unless defined(&__sanitizer_syscall_post_compat_13_sigprocmask13);
    eval 'sub __sanitizer_syscall_pre___getlogin {
        my($namebuf, $namelen) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___getlogin(, ($namelen)));
    }' unless defined(&__sanitizer_syscall_pre___getlogin);
    eval 'sub __sanitizer_syscall_post___getlogin {
        my($res, $namebuf, $namelen) = @_;
	    eval q( &__sanitizer_syscall_post_impl___getlogin($res, , ($namelen)));
    }' unless defined(&__sanitizer_syscall_post___getlogin);
    eval 'sub __sanitizer_syscall_pre___setlogin {
        my($namebuf) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___setlogin(($namebuf)));
    }' unless defined(&__sanitizer_syscall_pre___setlogin);
    eval 'sub __sanitizer_syscall_post___setlogin {
        my($res, $namebuf) = @_;
	    eval q( &__sanitizer_syscall_post_impl___setlogin($res, ($namebuf)));
    }' unless defined(&__sanitizer_syscall_post___setlogin);
    eval 'sub __sanitizer_syscall_pre_acct {
        my($path) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_acct(($path)));
    }' unless defined(&__sanitizer_syscall_pre_acct);
    eval 'sub __sanitizer_syscall_post_acct {
        my($res, $path) = @_;
	    eval q( &__sanitizer_syscall_post_impl_acct($res, ($path)));
    }' unless defined(&__sanitizer_syscall_post_acct);
    eval 'sub __sanitizer_syscall_pre_compat_13_sigpending13 () {
        eval q( &__sanitizer_syscall_pre_impl_compat_13_sigpending13());
    }' unless defined(&__sanitizer_syscall_pre_compat_13_sigpending13);
    eval 'sub __sanitizer_syscall_post_compat_13_sigpending13 {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_13_sigpending13($res));
    }' unless defined(&__sanitizer_syscall_post_compat_13_sigpending13);
    eval 'sub __sanitizer_syscall_pre_compat_13_sigaltstack13 {
        my($nss, $oss) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_13_sigaltstack13(, ($oss)));
    }' unless defined(&__sanitizer_syscall_pre_compat_13_sigaltstack13);
    eval 'sub __sanitizer_syscall_post_compat_13_sigaltstack13 {
        my($res, $nss, $oss) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_13_sigaltstack13($res, , ($oss)));
    }' unless defined(&__sanitizer_syscall_post_compat_13_sigaltstack13);
    eval 'sub __sanitizer_syscall_pre_ioctl {
        my($fd, $com, $data) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_ioctl(, , ($data)));
    }' unless defined(&__sanitizer_syscall_pre_ioctl);
    eval 'sub __sanitizer_syscall_post_ioctl {
        my($res, $fd, $com, $data) = @_;
	    eval q( &__sanitizer_syscall_post_impl_ioctl($res, , , ($data)));
    }' unless defined(&__sanitizer_syscall_post_ioctl);
    eval 'sub __sanitizer_syscall_pre_compat_12_oreboot {
        my($opt) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_12_oreboot(($opt)));
    }' unless defined(&__sanitizer_syscall_pre_compat_12_oreboot);
    eval 'sub __sanitizer_syscall_post_compat_12_oreboot {
        my($res, $opt) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_12_oreboot($res, ($opt)));
    }' unless defined(&__sanitizer_syscall_post_compat_12_oreboot);
    eval 'sub __sanitizer_syscall_pre_revoke {
        my($path) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_revoke(($path)));
    }' unless defined(&__sanitizer_syscall_pre_revoke);
    eval 'sub __sanitizer_syscall_post_revoke {
        my($res, $path) = @_;
	    eval q( &__sanitizer_syscall_post_impl_revoke($res, ($path)));
    }' unless defined(&__sanitizer_syscall_post_revoke);
    eval 'sub __sanitizer_syscall_pre_symlink {
        my($path, $link) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_symlink(, ($link)));
    }' unless defined(&__sanitizer_syscall_pre_symlink);
    eval 'sub __sanitizer_syscall_post_symlink {
        my($res, $path, $link) = @_;
	    eval q( &__sanitizer_syscall_post_impl_symlink($res, , ($link)));
    }' unless defined(&__sanitizer_syscall_post_symlink);
    eval 'sub __sanitizer_syscall_pre_readlink {
        my($path, $buf, $count) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_readlink(, , ($count)));
    }' unless defined(&__sanitizer_syscall_pre_readlink);
    eval 'sub __sanitizer_syscall_post_readlink {
        my($res, $path, $buf, $count) = @_;
	    eval q( &__sanitizer_syscall_post_impl_readlink($res, , , ($count)));
    }' unless defined(&__sanitizer_syscall_post_readlink);
    eval 'sub __sanitizer_syscall_pre_execve {
        my($path, $argp, $envp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_execve(, , ($envp)));
    }' unless defined(&__sanitizer_syscall_pre_execve);
    eval 'sub __sanitizer_syscall_post_execve {
        my($res, $path, $argp, $envp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_execve($res, , , ($envp)));
    }' unless defined(&__sanitizer_syscall_post_execve);
    eval 'sub __sanitizer_syscall_pre_umask {
        my($newmask) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_umask(($newmask)));
    }' unless defined(&__sanitizer_syscall_pre_umask);
    eval 'sub __sanitizer_syscall_post_umask {
        my($res, $newmask) = @_;
	    eval q( &__sanitizer_syscall_post_impl_umask($res, ($newmask)));
    }' unless defined(&__sanitizer_syscall_post_umask);
    eval 'sub __sanitizer_syscall_pre_chroot {
        my($path) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_chroot(($path)));
    }' unless defined(&__sanitizer_syscall_pre_chroot);
    eval 'sub __sanitizer_syscall_post_chroot {
        my($res, $path) = @_;
	    eval q( &__sanitizer_syscall_post_impl_chroot($res, ($path)));
    }' unless defined(&__sanitizer_syscall_post_chroot);
    eval 'sub __sanitizer_syscall_pre_compat_43_fstat43 {
        my($fd, $sb) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_fstat43(, ($sb)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_fstat43);
    eval 'sub __sanitizer_syscall_post_compat_43_fstat43 {
        my($res, $fd, $sb) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_fstat43($res, , ($sb)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_fstat43);
    eval 'sub __sanitizer_syscall_pre_compat_43_ogetkerninfo {
        my($op, $where, $size, $arg) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_ogetkerninfo( , , , ($arg)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_ogetkerninfo);
    eval 'sub __sanitizer_syscall_post_compat_43_ogetkerninfo {
        my($res, $op, $where, $size,							  $arg) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_ogetkerninfo( $res, , , , ($arg)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_ogetkerninfo);
    eval 'sub __sanitizer_syscall_pre_compat_43_ogetpagesize () {
        eval q( &__sanitizer_syscall_pre_impl_compat_43_ogetpagesize());
    }' unless defined(&__sanitizer_syscall_pre_compat_43_ogetpagesize);
    eval 'sub __sanitizer_syscall_post_compat_43_ogetpagesize {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_ogetpagesize($res));
    }' unless defined(&__sanitizer_syscall_post_compat_43_ogetpagesize);
    eval 'sub __sanitizer_syscall_pre_compat_12_msync {
        my($addr, $len) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_12_msync(, ($len)));
    }' unless defined(&__sanitizer_syscall_pre_compat_12_msync);
    eval 'sub __sanitizer_syscall_post_compat_12_msync {
        my($res, $addr, $len) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_12_msync($res, , ($len)));
    }' unless defined(&__sanitizer_syscall_post_compat_12_msync);
    eval 'sub __sanitizer_syscall_pre_vfork () {
        eval q( &__sanitizer_syscall_pre_impl_vfork());
    }' unless defined(&__sanitizer_syscall_pre_vfork);
    eval 'sub __sanitizer_syscall_post_vfork {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_vfork($res));
    }' unless defined(&__sanitizer_syscall_post_vfork);
    eval 'sub __sanitizer_syscall_pre_compat_43_ommap {
        my($addr, $len, $prot, $flags, $fd,						    $pos) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_ommap( , , , , , ($pos)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_ommap);
    eval 'sub __sanitizer_syscall_post_compat_43_ommap {
        my($res, $addr, $len, $prot, $flags,						   $fd, $pos) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_ommap( $res, , , , , , ($pos)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_ommap);
    eval 'sub __sanitizer_syscall_pre_vadvise {
        my($anom) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_vadvise(($anom)));
    }' unless defined(&__sanitizer_syscall_pre_vadvise);
    eval 'sub __sanitizer_syscall_post_vadvise {
        my($res, $anom) = @_;
	    eval q( &__sanitizer_syscall_post_impl_vadvise($res, ($anom)));
    }' unless defined(&__sanitizer_syscall_post_vadvise);
    eval 'sub __sanitizer_syscall_pre_munmap {
        my($addr, $len) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_munmap(, ($len)));
    }' unless defined(&__sanitizer_syscall_pre_munmap);
    eval 'sub __sanitizer_syscall_post_munmap {
        my($res, $addr, $len) = @_;
	    eval q( &__sanitizer_syscall_post_impl_munmap($res, , ($len)));
    }' unless defined(&__sanitizer_syscall_post_munmap);
    eval 'sub __sanitizer_syscall_pre_mprotect {
        my($addr, $len, $prot) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mprotect(, , ($prot)));
    }' unless defined(&__sanitizer_syscall_pre_mprotect);
    eval 'sub __sanitizer_syscall_post_mprotect {
        my($res, $addr, $len, $prot) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mprotect($res, , , ($prot)));
    }' unless defined(&__sanitizer_syscall_post_mprotect);
    eval 'sub __sanitizer_syscall_pre_madvise {
        my($addr, $len, $behav) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_madvise(, , ($behav)));
    }' unless defined(&__sanitizer_syscall_pre_madvise);
    eval 'sub __sanitizer_syscall_post_madvise {
        my($res, $addr, $len, $behav) = @_;
	    eval q( &__sanitizer_syscall_post_impl_madvise($res, , , ($behav)));
    }' unless defined(&__sanitizer_syscall_post_madvise);
    eval 'sub __sanitizer_syscall_pre_mincore {
        my($addr, $len, $vec) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mincore(, , ($vec)));
    }' unless defined(&__sanitizer_syscall_pre_mincore);
    eval 'sub __sanitizer_syscall_post_mincore {
        my($res, $addr, $len, $vec) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mincore($res, , , ($vec)));
    }' unless defined(&__sanitizer_syscall_post_mincore);
    eval 'sub __sanitizer_syscall_pre_getgroups {
        my($gidsetsize, $gidset) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_getgroups(, ($gidset)));
    }' unless defined(&__sanitizer_syscall_pre_getgroups);
    eval 'sub __sanitizer_syscall_post_getgroups {
        my($res, $gidsetsize, $gidset) = @_;
	    eval q( &__sanitizer_syscall_post_impl_getgroups($res, , ($gidset)));
    }' unless defined(&__sanitizer_syscall_post_getgroups);
    eval 'sub __sanitizer_syscall_pre_setgroups {
        my($gidsetsize, $gidset) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_setgroups(, ($gidset)));
    }' unless defined(&__sanitizer_syscall_pre_setgroups);
    eval 'sub __sanitizer_syscall_post_setgroups {
        my($res, $gidsetsize, $gidset) = @_;
	    eval q( &__sanitizer_syscall_post_impl_setgroups($res, , ($gidset)));
    }' unless defined(&__sanitizer_syscall_post_setgroups);
    eval 'sub __sanitizer_syscall_pre_getpgrp () {
        eval q( &__sanitizer_syscall_pre_impl_getpgrp());
    }' unless defined(&__sanitizer_syscall_pre_getpgrp);
    eval 'sub __sanitizer_syscall_post_getpgrp {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_getpgrp($res));
    }' unless defined(&__sanitizer_syscall_post_getpgrp);
    eval 'sub __sanitizer_syscall_pre_setpgid {
        my($pid, $pgid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_setpgid(, ($pgid)));
    }' unless defined(&__sanitizer_syscall_pre_setpgid);
    eval 'sub __sanitizer_syscall_post_setpgid {
        my($res, $pid, $pgid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_setpgid($res, , ($pgid)));
    }' unless defined(&__sanitizer_syscall_post_setpgid);
    eval 'sub __sanitizer_syscall_pre_compat_50_setitimer {
        my($which, $itv, $oitv) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_setitimer( , , ($oitv)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_setitimer);
    eval 'sub __sanitizer_syscall_post_compat_50_setitimer {
        my($res, $which, $itv, $oitv) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_setitimer( $res, , , ($oitv)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_setitimer);
    eval 'sub __sanitizer_syscall_pre_compat_43_owait () {
        eval q( &__sanitizer_syscall_pre_impl_compat_43_owait());
    }' unless defined(&__sanitizer_syscall_pre_compat_43_owait);
    eval 'sub __sanitizer_syscall_post_compat_43_owait {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_owait($res));
    }' unless defined(&__sanitizer_syscall_post_compat_43_owait);
    eval 'sub __sanitizer_syscall_pre_compat_12_oswapon {
        my($name) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_12_oswapon(($name)));
    }' unless defined(&__sanitizer_syscall_pre_compat_12_oswapon);
    eval 'sub __sanitizer_syscall_post_compat_12_oswapon {
        my($res, $name) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_12_oswapon($res, ($name)));
    }' unless defined(&__sanitizer_syscall_post_compat_12_oswapon);
    eval 'sub __sanitizer_syscall_pre_compat_50_getitimer {
        my($which, $itv) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_getitimer(, ($itv)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_getitimer);
    eval 'sub __sanitizer_syscall_post_compat_50_getitimer {
        my($res, $which, $itv) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_getitimer($res, , ($itv)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_getitimer);
    eval 'sub __sanitizer_syscall_pre_compat_43_ogethostname {
        my($hostname, $len) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_ogethostname(, ($len)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_ogethostname);
    eval 'sub __sanitizer_syscall_post_compat_43_ogethostname {
        my($res, $hostname, $len) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_ogethostname( $res, , ($len)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_ogethostname);
    eval 'sub __sanitizer_syscall_pre_compat_43_osethostname {
        my($hostname, $len) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_osethostname(, ($len)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_osethostname);
    eval 'sub __sanitizer_syscall_post_compat_43_osethostname {
        my($res, $hostname, $len) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_osethostname( $res, , ($len)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_osethostname);
    eval 'sub __sanitizer_syscall_pre_compat_43_ogetdtablesize () {
        eval q( &__sanitizer_syscall_pre_impl_compat_43_ogetdtablesize());
    }' unless defined(&__sanitizer_syscall_pre_compat_43_ogetdtablesize);
    eval 'sub __sanitizer_syscall_post_compat_43_ogetdtablesize {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_ogetdtablesize($res));
    }' unless defined(&__sanitizer_syscall_post_compat_43_ogetdtablesize);
    eval 'sub __sanitizer_syscall_pre_dup2 {
        my($from, $to) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_dup2(, ($to)));
    }' unless defined(&__sanitizer_syscall_pre_dup2);
    eval 'sub __sanitizer_syscall_post_dup2 {
        my($res, $from, $to) = @_;
	    eval q( &__sanitizer_syscall_post_impl_dup2($res, , ($to)));
    }' unless defined(&__sanitizer_syscall_post_dup2);
    eval 'sub __sanitizer_syscall_pre_getrandom {
        my($buf, $buflen, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_getrandom( , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_getrandom);
    eval 'sub __sanitizer_syscall_post_getrandom {
        my($res, $buf, $buflen, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_getrandom( $res, , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_getrandom);
    eval 'sub __sanitizer_syscall_pre_fcntl {
        my($fd, $cmd, $arg) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fcntl(, , ($arg)));
    }' unless defined(&__sanitizer_syscall_pre_fcntl);
    eval 'sub __sanitizer_syscall_post_fcntl {
        my($res, $fd, $cmd, $arg) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fcntl($res, , , ($arg)));
    }' unless defined(&__sanitizer_syscall_post_fcntl);
    eval 'sub __sanitizer_syscall_pre_compat_50_select {
        my($nd, $in, $ou, $ex, $tv) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_select( , , , , ($tv)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_select);
    eval 'sub __sanitizer_syscall_post_compat_50_select {
        my($res, $nd, $in, $ou, $ex, $tv) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_select( $res, , , , , ($tv)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_select);
    eval 'sub __sanitizer_syscall_pre_fsync {
        my($fd) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fsync(($fd)));
    }' unless defined(&__sanitizer_syscall_pre_fsync);
    eval 'sub __sanitizer_syscall_post_fsync {
        my($res, $fd) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fsync($res, ($fd)));
    }' unless defined(&__sanitizer_syscall_post_fsync);
    eval 'sub __sanitizer_syscall_pre_setpriority {
        my($which, $who, $prio) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_setpriority( , , ($prio)));
    }' unless defined(&__sanitizer_syscall_pre_setpriority);
    eval 'sub __sanitizer_syscall_post_setpriority {
        my($res, $which, $who, $prio) = @_;
	    eval q( &__sanitizer_syscall_post_impl_setpriority( $res, , , ($prio)));
    }' unless defined(&__sanitizer_syscall_post_setpriority);
    eval 'sub __sanitizer_syscall_pre_compat_30_socket {
        my($domain, $type, $protocol) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_30_socket( , , ($protocol)));
    }' unless defined(&__sanitizer_syscall_pre_compat_30_socket);
    eval 'sub __sanitizer_syscall_post_compat_30_socket {
        my($res, $domain, $type, $protocol) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_30_socket( $res, , , ($protocol)));
    }' unless defined(&__sanitizer_syscall_post_compat_30_socket);
    eval 'sub __sanitizer_syscall_pre_connect {
        my($s, $name, $namelen) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_connect(, , ($namelen)));
    }' unless defined(&__sanitizer_syscall_pre_connect);
    eval 'sub __sanitizer_syscall_post_connect {
        my($res, $s, $name, $namelen) = @_;
	    eval q( &__sanitizer_syscall_post_impl_connect( $res, , , ($namelen)));
    }' unless defined(&__sanitizer_syscall_post_connect);
    eval 'sub __sanitizer_syscall_pre_compat_43_oaccept {
        my($s, $name, $anamelen) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_oaccept( , , ($anamelen)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_oaccept);
    eval 'sub __sanitizer_syscall_post_compat_43_oaccept {
        my($res, $s, $name, $anamelen) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_oaccept( $res, , , ($anamelen)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_oaccept);
    eval 'sub __sanitizer_syscall_pre_getpriority {
        my($which, $who) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_getpriority(, ($who)));
    }' unless defined(&__sanitizer_syscall_pre_getpriority);
    eval 'sub __sanitizer_syscall_post_getpriority {
        my($res, $which, $who) = @_;
	    eval q( &__sanitizer_syscall_post_impl_getpriority($res, , ($who)));
    }' unless defined(&__sanitizer_syscall_post_getpriority);
    eval 'sub __sanitizer_syscall_pre_compat_43_osend {
        my($s, $buf, $len, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_osend( , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_osend);
    eval 'sub __sanitizer_syscall_post_compat_43_osend {
        my($res, $s, $buf, $len, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_osend( $res, , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_osend);
    eval 'sub __sanitizer_syscall_pre_compat_43_orecv {
        my($s, $buf, $len, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_orecv( , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_orecv);
    eval 'sub __sanitizer_syscall_post_compat_43_orecv {
        my($res, $s, $buf, $len, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_orecv( $res, , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_orecv);
    eval 'sub __sanitizer_syscall_pre_compat_13_sigreturn13 {
        my($sigcntxp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_13_sigreturn13(($sigcntxp)));
    }' unless defined(&__sanitizer_syscall_pre_compat_13_sigreturn13);
    eval 'sub __sanitizer_syscall_post_compat_13_sigreturn13 {
        my($res, $sigcntxp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_13_sigreturn13($res, ($sigcntxp)));
    }' unless defined(&__sanitizer_syscall_post_compat_13_sigreturn13);
    eval 'sub __sanitizer_syscall_pre_bind {
        my($s, $name, $namelen) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_bind(, , ($namelen)));
    }' unless defined(&__sanitizer_syscall_pre_bind);
    eval 'sub __sanitizer_syscall_post_bind {
        my($res, $s, $name, $namelen) = @_;
	    eval q( &__sanitizer_syscall_post_impl_bind($res, , , ($namelen)));
    }' unless defined(&__sanitizer_syscall_post_bind);
    eval 'sub __sanitizer_syscall_pre_setsockopt {
        my($s, $level, $name, $val, $valsize) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_setsockopt(, , , , ($valsize)));
    }' unless defined(&__sanitizer_syscall_pre_setsockopt);
    eval 'sub __sanitizer_syscall_post_setsockopt {
        my($res, $s, $level, $name, $val, $valsize) = @_;
	    eval q( &__sanitizer_syscall_post_impl_setsockopt( $res, , , , , ($valsize)));
    }' unless defined(&__sanitizer_syscall_post_setsockopt);
    eval 'sub __sanitizer_syscall_pre_listen {
        my($s, $backlog) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_listen(, ($backlog)));
    }' unless defined(&__sanitizer_syscall_pre_listen);
    eval 'sub __sanitizer_syscall_post_listen {
        my($res, $s, $backlog) = @_;
	    eval q( &__sanitizer_syscall_post_impl_listen($res, , ($backlog)));
    }' unless defined(&__sanitizer_syscall_post_listen);
    eval 'sub __sanitizer_syscall_pre_compat_43_osigvec {
        my($signum, $nsv, $osv) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_osigvec( , , ($osv)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_osigvec);
    eval 'sub __sanitizer_syscall_post_compat_43_osigvec {
        my($res, $signum, $nsv, $osv) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_osigvec( $res, , , ($osv)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_osigvec);
    eval 'sub __sanitizer_syscall_pre_compat_43_osigblock {
        my($mask) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_osigblock(($mask)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_osigblock);
    eval 'sub __sanitizer_syscall_post_compat_43_osigblock {
        my($res, $mask) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_osigblock($res, ($mask)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_osigblock);
    eval 'sub __sanitizer_syscall_pre_compat_43_osigsetmask {
        my($mask) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_osigsetmask(($mask)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_osigsetmask);
    eval 'sub __sanitizer_syscall_post_compat_43_osigsetmask {
        my($res, $mask) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_osigsetmask($res, ($mask)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_osigsetmask);
    eval 'sub __sanitizer_syscall_pre_compat_13_sigsuspend13 {
        my($mask) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_13_sigsuspend13(($mask)));
    }' unless defined(&__sanitizer_syscall_pre_compat_13_sigsuspend13);
    eval 'sub __sanitizer_syscall_post_compat_13_sigsuspend13 {
        my($res, $mask) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_13_sigsuspend13($res, ($mask)));
    }' unless defined(&__sanitizer_syscall_post_compat_13_sigsuspend13);
    eval 'sub __sanitizer_syscall_pre_compat_43_osigstack {
        my($nss, $oss) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_osigstack(, ($oss)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_osigstack);
    eval 'sub __sanitizer_syscall_post_compat_43_osigstack {
        my($res, $nss, $oss) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_osigstack($res, , ($oss)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_osigstack);
    eval 'sub __sanitizer_syscall_pre_compat_43_orecvmsg {
        my($s, $msg, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_orecvmsg( , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_orecvmsg);
    eval 'sub __sanitizer_syscall_post_compat_43_orecvmsg {
        my($res, $s, $msg, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_orecvmsg( $res, , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_orecvmsg);
    eval 'sub __sanitizer_syscall_pre_compat_43_osendmsg {
        my($s, $msg, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_osendmsg( , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_osendmsg);
    eval 'sub __sanitizer_syscall_post_compat_43_osendmsg {
        my($res, $s, $msg, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_osendmsg( $res, , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_osendmsg);
    eval 'sub __sanitizer_syscall_pre_compat_50_gettimeofday {
        my($tp, $tzp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_gettimeofday(, ($tzp)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_gettimeofday);
    eval 'sub __sanitizer_syscall_post_compat_50_gettimeofday {
        my($res, $tp, $tzp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_gettimeofday($res, , ($tzp)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_gettimeofday);
    eval 'sub __sanitizer_syscall_pre_compat_50_getrusage {
        my($who, $rusage) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_getrusage(, ($rusage)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_getrusage);
    eval 'sub __sanitizer_syscall_post_compat_50_getrusage {
        my($res, $who, $rusage) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_getrusage($res, , ($rusage)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_getrusage);
    eval 'sub __sanitizer_syscall_pre_getsockopt {
        my($s, $level, $name, $val, $avalsize) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_getsockopt(, , , , ($avalsize)));
    }' unless defined(&__sanitizer_syscall_pre_getsockopt);
    eval 'sub __sanitizer_syscall_post_getsockopt {
        my($res, $s, $level, $name, $val,						      $avalsize) = @_;
	    eval q( &__sanitizer_syscall_post_impl_getsockopt( $res, , , , , ($avalsize)));
    }' unless defined(&__sanitizer_syscall_post_getsockopt);
    eval 'sub __sanitizer_syscall_pre_readv {
        my($fd, $iovp, $iovcnt) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_readv(, , ($iovcnt)));
    }' unless defined(&__sanitizer_syscall_pre_readv);
    eval 'sub __sanitizer_syscall_post_readv {
        my($res, $fd, $iovp, $iovcnt) = @_;
	    eval q( &__sanitizer_syscall_post_impl_readv($res, , , ($iovcnt)));
    }' unless defined(&__sanitizer_syscall_post_readv);
    eval 'sub __sanitizer_syscall_pre_writev {
        my($fd, $iovp, $iovcnt) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_writev(, , ($iovcnt)));
    }' unless defined(&__sanitizer_syscall_pre_writev);
    eval 'sub __sanitizer_syscall_post_writev {
        my($res, $fd, $iovp, $iovcnt) = @_;
	    eval q( &__sanitizer_syscall_post_impl_writev($res, , , ($iovcnt)));
    }' unless defined(&__sanitizer_syscall_post_writev);
    eval 'sub __sanitizer_syscall_pre_compat_50_settimeofday {
        my($tv, $tzp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_settimeofday(, ($tzp)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_settimeofday);
    eval 'sub __sanitizer_syscall_post_compat_50_settimeofday {
        my($res, $tv, $tzp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_settimeofday($res, , ($tzp)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_settimeofday);
    eval 'sub __sanitizer_syscall_pre_fchown {
        my($fd, $uid, $gid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fchown(, , ($gid)));
    }' unless defined(&__sanitizer_syscall_pre_fchown);
    eval 'sub __sanitizer_syscall_post_fchown {
        my($res, $fd, $uid, $gid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fchown($res, , , ($gid)));
    }' unless defined(&__sanitizer_syscall_post_fchown);
    eval 'sub __sanitizer_syscall_pre_fchmod {
        my($fd, $mode) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fchmod(, ($mode)));
    }' unless defined(&__sanitizer_syscall_pre_fchmod);
    eval 'sub __sanitizer_syscall_post_fchmod {
        my($res, $fd, $mode) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fchmod($res, , ($mode)));
    }' unless defined(&__sanitizer_syscall_post_fchmod);
    eval 'sub __sanitizer_syscall_pre_compat_43_orecvfrom {
        my($s, $buf, $len, $flags, $from,						      $fromlenaddr) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_orecvfrom( , , , , , ($fromlenaddr)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_orecvfrom);
    eval 'sub __sanitizer_syscall_post_compat_43_orecvfrom {
        my($res, $s, $buf, $len, $flags,						       $from, $fromlenaddr) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_orecvfrom( $res, , , , , , ($fromlenaddr)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_orecvfrom);
    eval 'sub __sanitizer_syscall_pre_setreuid {
        my($ruid, $euid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_setreuid(, ($euid)));
    }' unless defined(&__sanitizer_syscall_pre_setreuid);
    eval 'sub __sanitizer_syscall_post_setreuid {
        my($res, $ruid, $euid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_setreuid($res, , ($euid)));
    }' unless defined(&__sanitizer_syscall_post_setreuid);
    eval 'sub __sanitizer_syscall_pre_setregid {
        my($rgid, $egid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_setregid(, ($egid)));
    }' unless defined(&__sanitizer_syscall_pre_setregid);
    eval 'sub __sanitizer_syscall_post_setregid {
        my($res, $rgid, $egid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_setregid($res, , ($egid)));
    }' unless defined(&__sanitizer_syscall_post_setregid);
    eval 'sub __sanitizer_syscall_pre_rename {
        my($from, $to) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_rename(, ($to)));
    }' unless defined(&__sanitizer_syscall_pre_rename);
    eval 'sub __sanitizer_syscall_post_rename {
        my($res, $from, $to) = @_;
	    eval q( &__sanitizer_syscall_post_impl_rename($res, , ($to)));
    }' unless defined(&__sanitizer_syscall_post_rename);
    eval 'sub __sanitizer_syscall_pre_compat_43_otruncate {
        my($path, $length) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_otruncate(, ($length)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_otruncate);
    eval 'sub __sanitizer_syscall_post_compat_43_otruncate {
        my($res, $path, $length) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_otruncate($res, , ($length)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_otruncate);
    eval 'sub __sanitizer_syscall_pre_compat_43_oftruncate {
        my($fd, $length) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_oftruncate(, ($length)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_oftruncate);
    eval 'sub __sanitizer_syscall_post_compat_43_oftruncate {
        my($res, $fd, $length) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_oftruncate($res, , ($length)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_oftruncate);
    eval 'sub __sanitizer_syscall_pre_flock {
        my($fd, $how) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_flock(, ($how)));
    }' unless defined(&__sanitizer_syscall_pre_flock);
    eval 'sub __sanitizer_syscall_post_flock {
        my($res, $fd, $how) = @_;
	    eval q( &__sanitizer_syscall_post_impl_flock($res, , ($how)));
    }' unless defined(&__sanitizer_syscall_post_flock);
    eval 'sub __sanitizer_syscall_pre_mkfifo {
        my($path, $mode) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mkfifo(, ($mode)));
    }' unless defined(&__sanitizer_syscall_pre_mkfifo);
    eval 'sub __sanitizer_syscall_post_mkfifo {
        my($res, $path, $mode) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mkfifo($res, , ($mode)));
    }' unless defined(&__sanitizer_syscall_post_mkfifo);
    eval 'sub __sanitizer_syscall_pre_sendto {
        my($s, $buf, $len, $flags, $to, $tolen) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_sendto(, , , , , ($tolen)));
    }' unless defined(&__sanitizer_syscall_pre_sendto);
    eval 'sub __sanitizer_syscall_post_sendto {
        my($res, $s, $buf, $len, $flags, $to, $tolen) = @_;
	    eval q( &__sanitizer_syscall_post_impl_sendto($res, , , , , , ($tolen)));
    }' unless defined(&__sanitizer_syscall_post_sendto);
    eval 'sub __sanitizer_syscall_pre_shutdown {
        my($s, $how) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_shutdown(, ($how)));
    }' unless defined(&__sanitizer_syscall_pre_shutdown);
    eval 'sub __sanitizer_syscall_post_shutdown {
        my($res, $s, $how) = @_;
	    eval q( &__sanitizer_syscall_post_impl_shutdown($res, , ($how)));
    }' unless defined(&__sanitizer_syscall_post_shutdown);
    eval 'sub __sanitizer_syscall_pre_socketpair {
        my($domain, $type, $protocol, $rsv) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_socketpair( , , , ($rsv)));
    }' unless defined(&__sanitizer_syscall_pre_socketpair);
    eval 'sub __sanitizer_syscall_post_socketpair {
        my($res, $domain, $type, $protocol, $rsv) = @_;
	    eval q( &__sanitizer_syscall_post_impl_socketpair( $res, , , , ($rsv)));
    }' unless defined(&__sanitizer_syscall_post_socketpair);
    eval 'sub __sanitizer_syscall_pre_mkdir {
        my($path, $mode) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mkdir(, ($mode)));
    }' unless defined(&__sanitizer_syscall_pre_mkdir);
    eval 'sub __sanitizer_syscall_post_mkdir {
        my($res, $path, $mode) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mkdir($res, , ($mode)));
    }' unless defined(&__sanitizer_syscall_post_mkdir);
    eval 'sub __sanitizer_syscall_pre_rmdir {
        my($path) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_rmdir(($path)));
    }' unless defined(&__sanitizer_syscall_pre_rmdir);
    eval 'sub __sanitizer_syscall_post_rmdir {
        my($res, $path) = @_;
	    eval q( &__sanitizer_syscall_post_impl_rmdir($res, ($path)));
    }' unless defined(&__sanitizer_syscall_post_rmdir);
    eval 'sub __sanitizer_syscall_pre_compat_50_utimes {
        my($path, $tptr) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_utimes(, ($tptr)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_utimes);
    eval 'sub __sanitizer_syscall_post_compat_50_utimes {
        my($res, $path, $tptr) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_utimes($res, , ($tptr)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_utimes);
    eval 'sub __sanitizer_syscall_pre_compat_50_adjtime {
        my($delta, $olddelta) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_adjtime(, ($olddelta)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_adjtime);
    eval 'sub __sanitizer_syscall_post_compat_50_adjtime {
        my($res, $delta, $olddelta) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_adjtime($res, , ($olddelta)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_adjtime);
    eval 'sub __sanitizer_syscall_pre_compat_43_ogetpeername {
        my($fdes, $asa, $alen) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_ogetpeername( , , ($alen)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_ogetpeername);
    eval 'sub __sanitizer_syscall_post_compat_43_ogetpeername {
        my($res, $fdes, $asa, $alen) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_ogetpeername( $res, , , ($alen)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_ogetpeername);
    eval 'sub __sanitizer_syscall_pre_compat_43_ogethostid () {
        eval q( &__sanitizer_syscall_pre_impl_compat_43_ogethostid());
    }' unless defined(&__sanitizer_syscall_pre_compat_43_ogethostid);
    eval 'sub __sanitizer_syscall_post_compat_43_ogethostid {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_ogethostid($res));
    }' unless defined(&__sanitizer_syscall_post_compat_43_ogethostid);
    eval 'sub __sanitizer_syscall_pre_compat_43_osethostid {
        my($hostid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_osethostid(($hostid)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_osethostid);
    eval 'sub __sanitizer_syscall_post_compat_43_osethostid {
        my($res, $hostid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_osethostid($res, ($hostid)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_osethostid);
    eval 'sub __sanitizer_syscall_pre_compat_43_ogetrlimit {
        my($which, $rlp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_ogetrlimit(, ($rlp)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_ogetrlimit);
    eval 'sub __sanitizer_syscall_post_compat_43_ogetrlimit {
        my($res, $which, $rlp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_ogetrlimit($res, , ($rlp)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_ogetrlimit);
    eval 'sub __sanitizer_syscall_pre_compat_43_osetrlimit {
        my($which, $rlp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_osetrlimit(, ($rlp)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_osetrlimit);
    eval 'sub __sanitizer_syscall_post_compat_43_osetrlimit {
        my($res, $which, $rlp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_osetrlimit($res, , ($rlp)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_osetrlimit);
    eval 'sub __sanitizer_syscall_pre_compat_43_okillpg {
        my($pgid, $signum) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_okillpg(, ($signum)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_okillpg);
    eval 'sub __sanitizer_syscall_post_compat_43_okillpg {
        my($res, $pgid, $signum) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_okillpg($res, , ($signum)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_okillpg);
    eval 'sub __sanitizer_syscall_pre_setsid () {
        eval q( &__sanitizer_syscall_pre_impl_setsid());
    }' unless defined(&__sanitizer_syscall_pre_setsid);
    eval 'sub __sanitizer_syscall_post_setsid {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_setsid($res));
    }' unless defined(&__sanitizer_syscall_post_setsid);
    eval 'sub __sanitizer_syscall_pre_compat_50_quotactl {
        my($path, $cmd, $uid, $arg) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_quotactl( , , , ($arg)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_quotactl);
    eval 'sub __sanitizer_syscall_post_compat_50_quotactl {
        my($res, $path, $cmd, $uid, $arg) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_quotactl( $res, , , , ($arg)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_quotactl);
    eval 'sub __sanitizer_syscall_pre_compat_43_oquota () {
        eval q( &__sanitizer_syscall_pre_impl_compat_43_oquota());
    }' unless defined(&__sanitizer_syscall_pre_compat_43_oquota);
    eval 'sub __sanitizer_syscall_post_compat_43_oquota {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_oquota($res));
    }' unless defined(&__sanitizer_syscall_post_compat_43_oquota);
    eval 'sub __sanitizer_syscall_pre_compat_43_ogetsockname {
        my($fdec, $asa, $alen) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_ogetsockname( , , ($alen)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_ogetsockname);
    eval 'sub __sanitizer_syscall_post_compat_43_ogetsockname {
        my($res, $fdec, $asa, $alen) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_ogetsockname( $res, , , ($alen)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_ogetsockname);
    eval 'sub __sanitizer_syscall_pre_nfssvc {
        my($flag, $argp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_nfssvc(, ($argp)));
    }' unless defined(&__sanitizer_syscall_pre_nfssvc);
    eval 'sub __sanitizer_syscall_post_nfssvc {
        my($res, $flag, $argp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_nfssvc($res, , ($argp)));
    }' unless defined(&__sanitizer_syscall_post_nfssvc);
    eval 'sub __sanitizer_syscall_pre_compat_43_ogetdirentries {
        my($fd, $buf, $count,								$basep) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_43_ogetdirentries( , , , ($basep)));
    }' unless defined(&__sanitizer_syscall_pre_compat_43_ogetdirentries);
    eval 'sub __sanitizer_syscall_post_compat_43_ogetdirentries {
        my($res, $fd, $buf, $count,							   $basep) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_43_ogetdirentries( $res, , , , ($basep)));
    }' unless defined(&__sanitizer_syscall_post_compat_43_ogetdirentries);
    eval 'sub __sanitizer_syscall_pre_compat_20_statfs {
        my($path, $buf) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_20_statfs(, ($buf)));
    }' unless defined(&__sanitizer_syscall_pre_compat_20_statfs);
    eval 'sub __sanitizer_syscall_post_compat_20_statfs {
        my($res, $path, $buf) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_20_statfs($res, , ($buf)));
    }' unless defined(&__sanitizer_syscall_post_compat_20_statfs);
    eval 'sub __sanitizer_syscall_pre_compat_20_fstatfs {
        my($fd, $buf) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_20_fstatfs(, ($buf)));
    }' unless defined(&__sanitizer_syscall_pre_compat_20_fstatfs);
    eval 'sub __sanitizer_syscall_post_compat_20_fstatfs {
        my($res, $fd, $buf) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_20_fstatfs($res, , ($buf)));
    }' unless defined(&__sanitizer_syscall_post_compat_20_fstatfs);
    eval 'sub __sanitizer_syscall_pre_compat_30_getfh {
        my($fname, $fhp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_30_getfh(, ($fhp)));
    }' unless defined(&__sanitizer_syscall_pre_compat_30_getfh);
    eval 'sub __sanitizer_syscall_post_compat_30_getfh {
        my($res, $fname, $fhp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_30_getfh($res, , ($fhp)));
    }' unless defined(&__sanitizer_syscall_post_compat_30_getfh);
    eval 'sub __sanitizer_syscall_pre_compat_09_ogetdomainname {
        my($domainname, $len) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_09_ogetdomainname( , ($len)));
    }' unless defined(&__sanitizer_syscall_pre_compat_09_ogetdomainname);
    eval 'sub __sanitizer_syscall_post_compat_09_ogetdomainname {
        my($res, $domainname,							       $len) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_09_ogetdomainname( $res, , ($len)));
    }' unless defined(&__sanitizer_syscall_post_compat_09_ogetdomainname);
    eval 'sub __sanitizer_syscall_pre_compat_09_osetdomainname {
        my($domainname, $len) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_09_osetdomainname( , ($len)));
    }' unless defined(&__sanitizer_syscall_pre_compat_09_osetdomainname);
    eval 'sub __sanitizer_syscall_post_compat_09_osetdomainname {
        my($res, $domainname,							       $len) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_09_osetdomainname( $res, , ($len)));
    }' unless defined(&__sanitizer_syscall_post_compat_09_osetdomainname);
    eval 'sub __sanitizer_syscall_pre_compat_09_ouname {
        my($name) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_09_ouname(($name)));
    }' unless defined(&__sanitizer_syscall_pre_compat_09_ouname);
    eval 'sub __sanitizer_syscall_post_compat_09_ouname {
        my($res, $name) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_09_ouname($res, ($name)));
    }' unless defined(&__sanitizer_syscall_post_compat_09_ouname);
    eval 'sub __sanitizer_syscall_pre_sysarch {
        my($op, $parms) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_sysarch(, ($parms)));
    }' unless defined(&__sanitizer_syscall_pre_sysarch);
    eval 'sub __sanitizer_syscall_post_sysarch {
        my($res, $op, $parms) = @_;
	    eval q( &__sanitizer_syscall_post_impl_sysarch($res, , ($parms)));
    }' unless defined(&__sanitizer_syscall_post_sysarch);
    eval 'sub __sanitizer_syscall_pre___futex {
        my($uaddr, $op, $val, $timeout, $uaddr2, $val2,					 $val3) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___futex(, , , , , , ($val3)));
    }' unless defined(&__sanitizer_syscall_pre___futex);
    eval 'sub __sanitizer_syscall_post___futex {
        my($res, $uaddr, $op, $val, $timeout, $uaddr2,					  $val2, $val3) = @_;
	    eval q( &__sanitizer_syscall_post_impl___futex( $res, , , , , , , ($val3)));
    }' unless defined(&__sanitizer_syscall_post___futex);
    eval 'sub __sanitizer_syscall_pre___futex_set_robust_list {
        my($head, $len) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___futex_set_robust_list(, ($len)));
    }' unless defined(&__sanitizer_syscall_pre___futex_set_robust_list);
    eval 'sub __sanitizer_syscall_post___futex_set_robust_list {
        my($res, $head, $len) = @_;
	    eval q( &__sanitizer_syscall_post_impl___futex_set_robust_list( $res, , ($len)));
    }' unless defined(&__sanitizer_syscall_post___futex_set_robust_list);
    eval 'sub __sanitizer_syscall_pre___futex_get_robust_list {
        my($lwpid, $headp, $lenp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___futex_get_robust_list( , , ($lenp)));
    }' unless defined(&__sanitizer_syscall_pre___futex_get_robust_list);
    eval 'sub __sanitizer_syscall_post___futex_get_robust_list {
        my($res, $lwpid, $headp,							     $lenp) = @_;
	    eval q( &__sanitizer_syscall_post_impl___futex_get_robust_list( $res, , , ($lenp)));
    }' unless defined(&__sanitizer_syscall_post___futex_get_robust_list);
    if(!defined(&_LP64)) {
	eval 'sub __sanitizer_syscall_pre_compat_10_osemsys {
	    my($which, $a2, $a3, $a4, $a5) = @_;
    	    eval q( &__sanitizer_syscall_pre_impl_compat_10_osemsys( , , , , ($a5)));
	}' unless defined(&__sanitizer_syscall_pre_compat_10_osemsys);
	eval 'sub __sanitizer_syscall_post_compat_10_osemsys {
	    my($res, $which, $a2, $a3, $a4, $a5) = @_;
    	    eval q( &__sanitizer_syscall_post_impl_compat_10_osemsys( $res, , , , , ($a5)));
	}' unless defined(&__sanitizer_syscall_post_compat_10_osemsys);
    } else {
    }
    if(!defined(&_LP64)) {
	eval 'sub __sanitizer_syscall_pre_compat_10_omsgsys {
	    my($which, $a2, $a3, $a4, $a5, $a6) = @_;
    	    eval q( &__sanitizer_syscall_pre_impl_compat_10_omsgsys( , , , , , ($a6)));
	}' unless defined(&__sanitizer_syscall_pre_compat_10_omsgsys);
	eval 'sub __sanitizer_syscall_post_compat_10_omsgsys {
	    my($res, $which, $a2, $a3, $a4, $a5,						    $a6) = @_;
    	    eval q( &__sanitizer_syscall_post_impl_compat_10_omsgsys( $res, , , , , , ($a6)));
	}' unless defined(&__sanitizer_syscall_post_compat_10_omsgsys);
    } else {
    }
    if(!defined(&_LP64)) {
	eval 'sub __sanitizer_syscall_pre_compat_10_oshmsys {
	    my($which, $a2, $a3, $a4) = @_;
    	    eval q( &__sanitizer_syscall_pre_impl_compat_10_oshmsys( , , , ($a4)));
	}' unless defined(&__sanitizer_syscall_pre_compat_10_oshmsys);
	eval 'sub __sanitizer_syscall_post_compat_10_oshmsys {
	    my($res, $which, $a2, $a3, $a4) = @_;
    	    eval q( &__sanitizer_syscall_post_impl_compat_10_oshmsys( $res, , , , ($a4)));
	}' unless defined(&__sanitizer_syscall_post_compat_10_oshmsys);
    } else {
    }
    eval 'sub __sanitizer_syscall_pre_pread {
        my($fd, $buf, $nbyte, $PAD, $offset) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_pread(, , , , ($offset)));
    }' unless defined(&__sanitizer_syscall_pre_pread);
    eval 'sub __sanitizer_syscall_post_pread {
        my($res, $fd, $buf, $nbyte, $PAD, $offset) = @_;
	    eval q( &__sanitizer_syscall_post_impl_pread($res, , , , , ($offset)));
    }' unless defined(&__sanitizer_syscall_post_pread);
    eval 'sub __sanitizer_syscall_pre_pwrite {
        my($fd, $buf, $nbyte, $PAD, $offset) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_pwrite(, , , , ($offset)));
    }' unless defined(&__sanitizer_syscall_pre_pwrite);
    eval 'sub __sanitizer_syscall_post_pwrite {
        my($res, $fd, $buf, $nbyte, $PAD, $offset) = @_;
	    eval q( &__sanitizer_syscall_post_impl_pwrite($res, , , , , ($offset)));
    }' unless defined(&__sanitizer_syscall_post_pwrite);
    eval 'sub __sanitizer_syscall_pre_compat_30_ntp_gettime {
        my($ntvp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_30_ntp_gettime(($ntvp)));
    }' unless defined(&__sanitizer_syscall_pre_compat_30_ntp_gettime);
    eval 'sub __sanitizer_syscall_post_compat_30_ntp_gettime {
        my($res, $ntvp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_30_ntp_gettime($res, ($ntvp)));
    }' unless defined(&__sanitizer_syscall_post_compat_30_ntp_gettime);
    if(defined(&NTP) || !defined(&_KERNEL_OPT)) {
	eval 'sub __sanitizer_syscall_pre_ntp_adjtime {
	    my($tp) = @_;
    	    eval q( &__sanitizer_syscall_pre_impl_ntp_adjtime(($tp)));
	}' unless defined(&__sanitizer_syscall_pre_ntp_adjtime);
	eval 'sub __sanitizer_syscall_post_ntp_adjtime {
	    my($res, $tp) = @_;
    	    eval q( &__sanitizer_syscall_post_impl_ntp_adjtime($res, ($tp)));
	}' unless defined(&__sanitizer_syscall_post_ntp_adjtime);
    } else {
    }
    eval 'sub __sanitizer_syscall_pre_setgid {
        my($gid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_setgid(($gid)));
    }' unless defined(&__sanitizer_syscall_pre_setgid);
    eval 'sub __sanitizer_syscall_post_setgid {
        my($res, $gid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_setgid($res, ($gid)));
    }' unless defined(&__sanitizer_syscall_post_setgid);
    eval 'sub __sanitizer_syscall_pre_setegid {
        my($egid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_setegid(($egid)));
    }' unless defined(&__sanitizer_syscall_pre_setegid);
    eval 'sub __sanitizer_syscall_post_setegid {
        my($res, $egid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_setegid($res, ($egid)));
    }' unless defined(&__sanitizer_syscall_post_setegid);
    eval 'sub __sanitizer_syscall_pre_seteuid {
        my($euid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_seteuid(($euid)));
    }' unless defined(&__sanitizer_syscall_pre_seteuid);
    eval 'sub __sanitizer_syscall_post_seteuid {
        my($res, $euid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_seteuid($res, ($euid)));
    }' unless defined(&__sanitizer_syscall_post_seteuid);
    eval 'sub __sanitizer_syscall_pre_lfs_bmapv {
        my($fsidp, $blkiov, $blkcnt) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_lfs_bmapv( , , ($blkcnt)));
    }' unless defined(&__sanitizer_syscall_pre_lfs_bmapv);
    eval 'sub __sanitizer_syscall_post_lfs_bmapv {
        my($res, $fsidp, $blkiov, $blkcnt) = @_;
	    eval q( &__sanitizer_syscall_post_impl_lfs_bmapv( $res, , , ($blkcnt)));
    }' unless defined(&__sanitizer_syscall_post_lfs_bmapv);
    eval 'sub __sanitizer_syscall_pre_lfs_markv {
        my($fsidp, $blkiov, $blkcnt) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_lfs_markv( , , ($blkcnt)));
    }' unless defined(&__sanitizer_syscall_pre_lfs_markv);
    eval 'sub __sanitizer_syscall_post_lfs_markv {
        my($res, $fsidp, $blkiov, $blkcnt) = @_;
	    eval q( &__sanitizer_syscall_post_impl_lfs_markv( $res, , , ($blkcnt)));
    }' unless defined(&__sanitizer_syscall_post_lfs_markv);
    eval 'sub __sanitizer_syscall_pre_lfs_segclean {
        my($fsidp, $segment) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_lfs_segclean(, ($segment)));
    }' unless defined(&__sanitizer_syscall_pre_lfs_segclean);
    eval 'sub __sanitizer_syscall_post_lfs_segclean {
        my($res, $fsidp, $segment) = @_;
	    eval q( &__sanitizer_syscall_post_impl_lfs_segclean($res, , ($segment)));
    }' unless defined(&__sanitizer_syscall_post_lfs_segclean);
    eval 'sub __sanitizer_syscall_pre_compat_50_lfs_segwait {
        my($fsidp, $tv) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_lfs_segwait(, ($tv)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_lfs_segwait);
    eval 'sub __sanitizer_syscall_post_compat_50_lfs_segwait {
        my($res, $fsidp, $tv) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_lfs_segwait($res, , ($tv)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_lfs_segwait);
    eval 'sub __sanitizer_syscall_pre_compat_12_stat12 {
        my($path, $ub) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_12_stat12(, ($ub)));
    }' unless defined(&__sanitizer_syscall_pre_compat_12_stat12);
    eval 'sub __sanitizer_syscall_post_compat_12_stat12 {
        my($res, $path, $ub) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_12_stat12($res, , ($ub)));
    }' unless defined(&__sanitizer_syscall_post_compat_12_stat12);
    eval 'sub __sanitizer_syscall_pre_compat_12_fstat12 {
        my($fd, $sb) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_12_fstat12(, ($sb)));
    }' unless defined(&__sanitizer_syscall_pre_compat_12_fstat12);
    eval 'sub __sanitizer_syscall_post_compat_12_fstat12 {
        my($res, $fd, $sb) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_12_fstat12($res, , ($sb)));
    }' unless defined(&__sanitizer_syscall_post_compat_12_fstat12);
    eval 'sub __sanitizer_syscall_pre_compat_12_lstat12 {
        my($path, $ub) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_12_lstat12(, ($ub)));
    }' unless defined(&__sanitizer_syscall_pre_compat_12_lstat12);
    eval 'sub __sanitizer_syscall_post_compat_12_lstat12 {
        my($res, $path, $ub) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_12_lstat12($res, , ($ub)));
    }' unless defined(&__sanitizer_syscall_post_compat_12_lstat12);
    eval 'sub __sanitizer_syscall_pre_pathconf {
        my($path, $name) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_pathconf(, ($name)));
    }' unless defined(&__sanitizer_syscall_pre_pathconf);
    eval 'sub __sanitizer_syscall_post_pathconf {
        my($res, $path, $name) = @_;
	    eval q( &__sanitizer_syscall_post_impl_pathconf($res, , ($name)));
    }' unless defined(&__sanitizer_syscall_post_pathconf);
    eval 'sub __sanitizer_syscall_pre_fpathconf {
        my($fd, $name) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fpathconf(, ($name)));
    }' unless defined(&__sanitizer_syscall_pre_fpathconf);
    eval 'sub __sanitizer_syscall_post_fpathconf {
        my($res, $fd, $name) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fpathconf($res, , ($name)));
    }' unless defined(&__sanitizer_syscall_post_fpathconf);
    eval 'sub __sanitizer_syscall_pre_getsockopt2 {
        my($s, $level, $name, $val, $avalsize) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_getsockopt2( , , , , ($avalsize)));
    }' unless defined(&__sanitizer_syscall_pre_getsockopt2);
    eval 'sub __sanitizer_syscall_post_getsockopt2 {
        my($res, $s, $level, $name, $val,						      $avalsize) = @_;
	    eval q( &__sanitizer_syscall_post_impl_getsockopt2( $res, , , , , ($avalsize)));
    }' unless defined(&__sanitizer_syscall_post_getsockopt2);
    eval 'sub __sanitizer_syscall_pre_getrlimit {
        my($which, $rlp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_getrlimit(, ($rlp)));
    }' unless defined(&__sanitizer_syscall_pre_getrlimit);
    eval 'sub __sanitizer_syscall_post_getrlimit {
        my($res, $which, $rlp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_getrlimit($res, , ($rlp)));
    }' unless defined(&__sanitizer_syscall_post_getrlimit);
    eval 'sub __sanitizer_syscall_pre_setrlimit {
        my($which, $rlp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_setrlimit(, ($rlp)));
    }' unless defined(&__sanitizer_syscall_pre_setrlimit);
    eval 'sub __sanitizer_syscall_post_setrlimit {
        my($res, $which, $rlp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_setrlimit($res, , ($rlp)));
    }' unless defined(&__sanitizer_syscall_post_setrlimit);
    eval 'sub __sanitizer_syscall_pre_compat_12_getdirentries {
        my($fd, $buf, $count, $basep) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_12_getdirentries( , , , ($basep)));
    }' unless defined(&__sanitizer_syscall_pre_compat_12_getdirentries);
    eval 'sub __sanitizer_syscall_post_compat_12_getdirentries {
        my($res, $fd, $buf, $count,							   $basep) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_12_getdirentries( $res, , , , ($basep)));
    }' unless defined(&__sanitizer_syscall_post_compat_12_getdirentries);
    eval 'sub __sanitizer_syscall_pre_mmap {
        my($addr, $len, $prot, $flags, $fd, $PAD, $pos) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mmap( , , , , , , ($pos)));
    }' unless defined(&__sanitizer_syscall_pre_mmap);
    eval 'sub __sanitizer_syscall_post_mmap {
        my($res, $addr, $len, $prot, $flags, $fd, $PAD,					  $pos) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mmap( $res, , , , , , , ($pos)));
    }' unless defined(&__sanitizer_syscall_post_mmap);
    eval 'sub __sanitizer_syscall_pre___syscall {
        my($code, $arg0, $arg1, $arg2, $arg3, $arg4,					    $arg5, $arg6, $arg7) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___syscall( , , , , , , , , ($arg7)));
    }' unless defined(&__sanitizer_syscall_pre___syscall);
    eval 'sub __sanitizer_syscall_post___syscall {
        my($res, $code, $arg0, $arg1, $arg2, $arg3,					     $arg4, $arg5, $arg6, $arg7) = @_;
	    eval q( &__sanitizer_syscall_post_impl___syscall( $res, , , , , , , , , ($arg7)));
    }' unless defined(&__sanitizer_syscall_post___syscall);
    eval 'sub __sanitizer_syscall_pre_lseek {
        my($fd, $PAD, $offset, $whence) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_lseek(, , , ($whence)));
    }' unless defined(&__sanitizer_syscall_pre_lseek);
    eval 'sub __sanitizer_syscall_post_lseek {
        my($res, $fd, $PAD, $offset, $whence) = @_;
	    eval q( &__sanitizer_syscall_post_impl_lseek($res, , , , ($whence)));
    }' unless defined(&__sanitizer_syscall_post_lseek);
    eval 'sub __sanitizer_syscall_pre_truncate {
        my($path, $PAD, $length) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_truncate(, , ($length)));
    }' unless defined(&__sanitizer_syscall_pre_truncate);
    eval 'sub __sanitizer_syscall_post_truncate {
        my($res, $path, $PAD, $length) = @_;
	    eval q( &__sanitizer_syscall_post_impl_truncate( $res, , , ($length)));
    }' unless defined(&__sanitizer_syscall_post_truncate);
    eval 'sub __sanitizer_syscall_pre_ftruncate {
        my($fd, $PAD, $length) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_ftruncate(, , ($length)));
    }' unless defined(&__sanitizer_syscall_pre_ftruncate);
    eval 'sub __sanitizer_syscall_post_ftruncate {
        my($res, $fd, $PAD, $length) = @_;
	    eval q( &__sanitizer_syscall_post_impl_ftruncate( $res, , , ($length)));
    }' unless defined(&__sanitizer_syscall_post_ftruncate);
    eval 'sub __sanitizer_syscall_pre___sysctl {
        my($name, $namelen, $oldv, $oldlenp, $newv,					    $newlen) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___sysctl( , , , , , ($newlen)));
    }' unless defined(&__sanitizer_syscall_pre___sysctl);
    eval 'sub __sanitizer_syscall_post___sysctl {
        my($res, $name, $namelen, $oldv, $oldlenp,					     $newv, $newlen) = @_;
	    eval q( &__sanitizer_syscall_post_impl___sysctl( $res, , , , , , ($newlen)));
    }' unless defined(&__sanitizer_syscall_post___sysctl);
    eval 'sub __sanitizer_syscall_pre_mlock {
        my($addr, $len) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mlock(, ($len)));
    }' unless defined(&__sanitizer_syscall_pre_mlock);
    eval 'sub __sanitizer_syscall_post_mlock {
        my($res, $addr, $len) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mlock($res, , ($len)));
    }' unless defined(&__sanitizer_syscall_post_mlock);
    eval 'sub __sanitizer_syscall_pre_munlock {
        my($addr, $len) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_munlock(, ($len)));
    }' unless defined(&__sanitizer_syscall_pre_munlock);
    eval 'sub __sanitizer_syscall_post_munlock {
        my($res, $addr, $len) = @_;
	    eval q( &__sanitizer_syscall_post_impl_munlock($res, , ($len)));
    }' unless defined(&__sanitizer_syscall_post_munlock);
    eval 'sub __sanitizer_syscall_pre_undelete {
        my($path) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_undelete(($path)));
    }' unless defined(&__sanitizer_syscall_pre_undelete);
    eval 'sub __sanitizer_syscall_post_undelete {
        my($res, $path) = @_;
	    eval q( &__sanitizer_syscall_post_impl_undelete($res, ($path)));
    }' unless defined(&__sanitizer_syscall_post_undelete);
    eval 'sub __sanitizer_syscall_pre_compat_50_futimes {
        my($fd, $tptr) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_futimes(, ($tptr)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_futimes);
    eval 'sub __sanitizer_syscall_post_compat_50_futimes {
        my($res, $fd, $tptr) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_futimes($res, , ($tptr)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_futimes);
    eval 'sub __sanitizer_syscall_pre_getpgid {
        my($pid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_getpgid(($pid)));
    }' unless defined(&__sanitizer_syscall_pre_getpgid);
    eval 'sub __sanitizer_syscall_post_getpgid {
        my($res, $pid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_getpgid($res, ($pid)));
    }' unless defined(&__sanitizer_syscall_post_getpgid);
    eval 'sub __sanitizer_syscall_pre_reboot {
        my($opt, $bootstr) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_reboot(, ($bootstr)));
    }' unless defined(&__sanitizer_syscall_pre_reboot);
    eval 'sub __sanitizer_syscall_post_reboot {
        my($res, $opt, $bootstr) = @_;
	    eval q( &__sanitizer_syscall_post_impl_reboot($res, , ($bootstr)));
    }' unless defined(&__sanitizer_syscall_post_reboot);
    eval 'sub __sanitizer_syscall_pre_poll {
        my($fds, $nfds, $timeout) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_poll(, , ($timeout)));
    }' unless defined(&__sanitizer_syscall_pre_poll);
    eval 'sub __sanitizer_syscall_post_poll {
        my($res, $fds, $nfds, $timeout) = @_;
	    eval q( &__sanitizer_syscall_post_impl_poll($res, , , ($timeout)));
    }' unless defined(&__sanitizer_syscall_post_poll);
    eval 'sub __sanitizer_syscall_pre_afssys {
        my($id, $a1, $a2, $a3, $a4, $a5, $a6) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_afssys( , , , , , , ($a6)));
    }' unless defined(&__sanitizer_syscall_pre_afssys);
    eval 'sub __sanitizer_syscall_post_afssys {
        my($res, $id, $a1, $a2, $a3, $a4, $a5, $a6) = @_;
	    eval q( &__sanitizer_syscall_post_impl_afssys( $res, , , , , , , ($a6)));
    }' unless defined(&__sanitizer_syscall_post_afssys);
    eval 'sub __sanitizer_syscall_pre_compat_14___semctl {
        my($semid, $semnum, $cmd, $arg) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_14___semctl( , , , ($arg)));
    }' unless defined(&__sanitizer_syscall_pre_compat_14___semctl);
    eval 'sub __sanitizer_syscall_post_compat_14___semctl {
        my($res, $semid, $semnum, $cmd,						       $arg) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_14___semctl( $res, , , , ($arg)));
    }' unless defined(&__sanitizer_syscall_post_compat_14___semctl);
    eval 'sub __sanitizer_syscall_pre_semget {
        my($key, $nsems, $semflg) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_semget(, , ($semflg)));
    }' unless defined(&__sanitizer_syscall_pre_semget);
    eval 'sub __sanitizer_syscall_post_semget {
        my($res, $key, $nsems, $semflg) = @_;
	    eval q( &__sanitizer_syscall_post_impl_semget( $res, , , ($semflg)));
    }' unless defined(&__sanitizer_syscall_post_semget);
    eval 'sub __sanitizer_syscall_pre_semop {
        my($semid, $sops, $nsops) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_semop(, , ($nsops)));
    }' unless defined(&__sanitizer_syscall_pre_semop);
    eval 'sub __sanitizer_syscall_post_semop {
        my($res, $semid, $sops, $nsops) = @_;
	    eval q( &__sanitizer_syscall_post_impl_semop($res, , , ($nsops)));
    }' unless defined(&__sanitizer_syscall_post_semop);
    eval 'sub __sanitizer_syscall_pre_semconfig {
        my($flag) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_semconfig(($flag)));
    }' unless defined(&__sanitizer_syscall_pre_semconfig);
    eval 'sub __sanitizer_syscall_post_semconfig {
        my($res, $flag) = @_;
	    eval q( &__sanitizer_syscall_post_impl_semconfig($res, ($flag)));
    }' unless defined(&__sanitizer_syscall_post_semconfig);
    eval 'sub __sanitizer_syscall_pre_compat_14_msgctl {
        my($msqid, $cmd, $buf) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_14_msgctl( , , ($buf)));
    }' unless defined(&__sanitizer_syscall_pre_compat_14_msgctl);
    eval 'sub __sanitizer_syscall_post_compat_14_msgctl {
        my($res, $msqid, $cmd, $buf) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_14_msgctl( $res, , , ($buf)));
    }' unless defined(&__sanitizer_syscall_post_compat_14_msgctl);
    eval 'sub __sanitizer_syscall_pre_msgget {
        my($key, $msgflg) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_msgget(, ($msgflg)));
    }' unless defined(&__sanitizer_syscall_pre_msgget);
    eval 'sub __sanitizer_syscall_post_msgget {
        my($res, $key, $msgflg) = @_;
	    eval q( &__sanitizer_syscall_post_impl_msgget($res, , ($msgflg)));
    }' unless defined(&__sanitizer_syscall_post_msgget);
    eval 'sub __sanitizer_syscall_pre_msgsnd {
        my($msqid, $msgp, $msgsz, $msgflg) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_msgsnd(, , , ($msgflg)));
    }' unless defined(&__sanitizer_syscall_pre_msgsnd);
    eval 'sub __sanitizer_syscall_post_msgsnd {
        my($res, $msqid, $msgp, $msgsz, $msgflg) = @_;
	    eval q( &__sanitizer_syscall_post_impl_msgsnd($res, , , , ($msgflg)));
    }' unless defined(&__sanitizer_syscall_post_msgsnd);
    eval 'sub __sanitizer_syscall_pre_msgrcv {
        my($msqid, $msgp, $msgsz, $msgtyp, $msgflg) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_msgrcv(, , , , ($msgflg)));
    }' unless defined(&__sanitizer_syscall_pre_msgrcv);
    eval 'sub __sanitizer_syscall_post_msgrcv {
        my($res, $msqid, $msgp, $msgsz, $msgtyp,					       $msgflg) = @_;
	    eval q( &__sanitizer_syscall_post_impl_msgrcv( $res, , , , , ($msgflg)));
    }' unless defined(&__sanitizer_syscall_post_msgrcv);
    eval 'sub __sanitizer_syscall_pre_shmat {
        my($shmid, $shmaddr, $shmflg) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_shmat(, , ($shmflg)));
    }' unless defined(&__sanitizer_syscall_pre_shmat);
    eval 'sub __sanitizer_syscall_post_shmat {
        my($res, $shmid, $shmaddr, $shmflg) = @_;
	    eval q( &__sanitizer_syscall_post_impl_shmat( $res, , , ($shmflg)));
    }' unless defined(&__sanitizer_syscall_post_shmat);
    eval 'sub __sanitizer_syscall_pre_compat_14_shmctl {
        my($shmid, $cmd, $buf) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_14_shmctl( , , ($buf)));
    }' unless defined(&__sanitizer_syscall_pre_compat_14_shmctl);
    eval 'sub __sanitizer_syscall_post_compat_14_shmctl {
        my($res, $shmid, $cmd, $buf) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_14_shmctl( $res, , , ($buf)));
    }' unless defined(&__sanitizer_syscall_post_compat_14_shmctl);
    eval 'sub __sanitizer_syscall_pre_shmdt {
        my($shmaddr) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_shmdt(($shmaddr)));
    }' unless defined(&__sanitizer_syscall_pre_shmdt);
    eval 'sub __sanitizer_syscall_post_shmdt {
        my($res, $shmaddr) = @_;
	    eval q( &__sanitizer_syscall_post_impl_shmdt($res, ($shmaddr)));
    }' unless defined(&__sanitizer_syscall_post_shmdt);
    eval 'sub __sanitizer_syscall_pre_shmget {
        my($key, $size, $shmflg) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_shmget(, , ($shmflg)));
    }' unless defined(&__sanitizer_syscall_pre_shmget);
    eval 'sub __sanitizer_syscall_post_shmget {
        my($res, $key, $size, $shmflg) = @_;
	    eval q( &__sanitizer_syscall_post_impl_shmget($res, , , ($shmflg)));
    }' unless defined(&__sanitizer_syscall_post_shmget);
    eval 'sub __sanitizer_syscall_pre_compat_50_clock_gettime {
        my($clock_id, $tp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_clock_gettime(, ($tp)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_clock_gettime);
    eval 'sub __sanitizer_syscall_post_compat_50_clock_gettime {
        my($res, $clock_id, $tp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_clock_gettime( $res, , ($tp)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_clock_gettime);
    eval 'sub __sanitizer_syscall_pre_compat_50_clock_settime {
        my($clock_id, $tp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_clock_settime(, ($tp)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_clock_settime);
    eval 'sub __sanitizer_syscall_post_compat_50_clock_settime {
        my($res, $clock_id, $tp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_clock_settime( $res, , ($tp)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_clock_settime);
    eval 'sub __sanitizer_syscall_pre_compat_50_clock_getres {
        my($clock_id, $tp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_clock_getres(, ($tp)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_clock_getres);
    eval 'sub __sanitizer_syscall_post_compat_50_clock_getres {
        my($res, $clock_id, $tp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_clock_getres( $res, , ($tp)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_clock_getres);
    eval 'sub __sanitizer_syscall_pre_timer_create {
        my($clock_id, $evp, $timerid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_timer_create( , , ($timerid)));
    }' unless defined(&__sanitizer_syscall_pre_timer_create);
    eval 'sub __sanitizer_syscall_post_timer_create {
        my($res, $clock_id, $evp, $timerid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_timer_create( $res, , , ($timerid)));
    }' unless defined(&__sanitizer_syscall_post_timer_create);
    eval 'sub __sanitizer_syscall_pre_timer_delete {
        my($timerid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_timer_delete(($timerid)));
    }' unless defined(&__sanitizer_syscall_pre_timer_delete);
    eval 'sub __sanitizer_syscall_post_timer_delete {
        my($res, $timerid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_timer_delete($res, ($timerid)));
    }' unless defined(&__sanitizer_syscall_post_timer_delete);
    eval 'sub __sanitizer_syscall_pre_compat_50_timer_settime {
        my($timerid, $flags, $value,							 $ovalue) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_timer_settime( , , , ($ovalue)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_timer_settime);
    eval 'sub __sanitizer_syscall_post_compat_50_timer_settime {
        my($res, $timerid, $flags,							   $value, $ovalue) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_timer_settime( $res, , , , ($ovalue)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_timer_settime);
    eval 'sub __sanitizer_syscall_pre_compat_50_timer_gettime {
        my($timerid, $value) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_timer_gettime(, ($value)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_timer_gettime);
    eval 'sub __sanitizer_syscall_post_compat_50_timer_gettime {
        my($res, $timerid, $value) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_timer_gettime( $res, , ($value)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_timer_gettime);
    eval 'sub __sanitizer_syscall_pre_timer_getoverrun {
        my($timerid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_timer_getoverrun(($timerid)));
    }' unless defined(&__sanitizer_syscall_pre_timer_getoverrun);
    eval 'sub __sanitizer_syscall_post_timer_getoverrun {
        my($res, $timerid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_timer_getoverrun($res, ($timerid)));
    }' unless defined(&__sanitizer_syscall_post_timer_getoverrun);
    eval 'sub __sanitizer_syscall_pre_compat_50_nanosleep {
        my($rqtp, $rmtp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_nanosleep(, ($rmtp)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_nanosleep);
    eval 'sub __sanitizer_syscall_post_compat_50_nanosleep {
        my($res, $rqtp, $rmtp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_nanosleep($res, , ($rmtp)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_nanosleep);
    eval 'sub __sanitizer_syscall_pre_fdatasync {
        my($fd) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fdatasync(($fd)));
    }' unless defined(&__sanitizer_syscall_pre_fdatasync);
    eval 'sub __sanitizer_syscall_post_fdatasync {
        my($res, $fd) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fdatasync($res, ($fd)));
    }' unless defined(&__sanitizer_syscall_post_fdatasync);
    eval 'sub __sanitizer_syscall_pre_mlockall {
        my($flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mlockall(($flags)));
    }' unless defined(&__sanitizer_syscall_pre_mlockall);
    eval 'sub __sanitizer_syscall_post_mlockall {
        my($res, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mlockall($res, ($flags)));
    }' unless defined(&__sanitizer_syscall_post_mlockall);
    eval 'sub __sanitizer_syscall_pre_munlockall () {
        eval q( &__sanitizer_syscall_pre_impl_munlockall());
    }' unless defined(&__sanitizer_syscall_pre_munlockall);
    eval 'sub __sanitizer_syscall_post_munlockall {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_munlockall($res));
    }' unless defined(&__sanitizer_syscall_post_munlockall);
    eval 'sub __sanitizer_syscall_pre_compat_50___sigtimedwait {
        my($set, $info, $timeout) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50___sigtimedwait( , , ($timeout)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50___sigtimedwait);
    eval 'sub __sanitizer_syscall_post_compat_50___sigtimedwait {
        my($res, $set, $info,								$timeout) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50___sigtimedwait( $res, , , ($timeout)));
    }' unless defined(&__sanitizer_syscall_post_compat_50___sigtimedwait);
    eval 'sub __sanitizer_syscall_pre_sigqueueinfo {
        my($pid, $info) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_sigqueueinfo(, ($info)));
    }' unless defined(&__sanitizer_syscall_pre_sigqueueinfo);
    eval 'sub __sanitizer_syscall_post_sigqueueinfo {
        my($res, $pid, $info) = @_;
	    eval q( &__sanitizer_syscall_post_impl_sigqueueinfo($res, , ($info)));
    }' unless defined(&__sanitizer_syscall_post_sigqueueinfo);
    eval 'sub __sanitizer_syscall_pre_modctl {
        my($cmd, $arg) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_modctl(, ($arg)));
    }' unless defined(&__sanitizer_syscall_pre_modctl);
    eval 'sub __sanitizer_syscall_post_modctl {
        my($res, $cmd, $arg) = @_;
	    eval q( &__sanitizer_syscall_post_impl_modctl($res, , ($arg)));
    }' unless defined(&__sanitizer_syscall_post_modctl);
    eval 'sub __sanitizer_syscall_pre__ksem_init {
        my($value, $idp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__ksem_init(, ($idp)));
    }' unless defined(&__sanitizer_syscall_pre__ksem_init);
    eval 'sub __sanitizer_syscall_post__ksem_init {
        my($res, $value, $idp) = @_;
	    eval q( &__sanitizer_syscall_post_impl__ksem_init($res, , ($idp)));
    }' unless defined(&__sanitizer_syscall_post__ksem_init);
    eval 'sub __sanitizer_syscall_pre__ksem_open {
        my($name, $oflag, $mode, $value, $idp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__ksem_open( , , , , ($idp)));
    }' unless defined(&__sanitizer_syscall_pre__ksem_open);
    eval 'sub __sanitizer_syscall_post__ksem_open {
        my($res, $name, $oflag, $mode, $value,						 $idp) = @_;
	    eval q( &__sanitizer_syscall_post_impl__ksem_open( $res, , , , , ($idp)));
    }' unless defined(&__sanitizer_syscall_post__ksem_open);
    eval 'sub __sanitizer_syscall_pre__ksem_unlink {
        my($name) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__ksem_unlink(($name)));
    }' unless defined(&__sanitizer_syscall_pre__ksem_unlink);
    eval 'sub __sanitizer_syscall_post__ksem_unlink {
        my($res, $name) = @_;
	    eval q( &__sanitizer_syscall_post_impl__ksem_unlink($res, ($name)));
    }' unless defined(&__sanitizer_syscall_post__ksem_unlink);
    eval 'sub __sanitizer_syscall_pre__ksem_close {
        my($id) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__ksem_close(($id)));
    }' unless defined(&__sanitizer_syscall_pre__ksem_close);
    eval 'sub __sanitizer_syscall_post__ksem_close {
        my($res, $id) = @_;
	    eval q( &__sanitizer_syscall_post_impl__ksem_close($res, ($id)));
    }' unless defined(&__sanitizer_syscall_post__ksem_close);
    eval 'sub __sanitizer_syscall_pre__ksem_post {
        my($id) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__ksem_post(($id)));
    }' unless defined(&__sanitizer_syscall_pre__ksem_post);
    eval 'sub __sanitizer_syscall_post__ksem_post {
        my($res, $id) = @_;
	    eval q( &__sanitizer_syscall_post_impl__ksem_post($res, ($id)));
    }' unless defined(&__sanitizer_syscall_post__ksem_post);
    eval 'sub __sanitizer_syscall_pre__ksem_wait {
        my($id) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__ksem_wait(($id)));
    }' unless defined(&__sanitizer_syscall_pre__ksem_wait);
    eval 'sub __sanitizer_syscall_post__ksem_wait {
        my($res, $id) = @_;
	    eval q( &__sanitizer_syscall_post_impl__ksem_wait($res, ($id)));
    }' unless defined(&__sanitizer_syscall_post__ksem_wait);
    eval 'sub __sanitizer_syscall_pre__ksem_trywait {
        my($id) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__ksem_trywait(($id)));
    }' unless defined(&__sanitizer_syscall_pre__ksem_trywait);
    eval 'sub __sanitizer_syscall_post__ksem_trywait {
        my($res, $id) = @_;
	    eval q( &__sanitizer_syscall_post_impl__ksem_trywait($res, ($id)));
    }' unless defined(&__sanitizer_syscall_post__ksem_trywait);
    eval 'sub __sanitizer_syscall_pre__ksem_getvalue {
        my($id, $value) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__ksem_getvalue(, ($value)));
    }' unless defined(&__sanitizer_syscall_pre__ksem_getvalue);
    eval 'sub __sanitizer_syscall_post__ksem_getvalue {
        my($res, $id, $value) = @_;
	    eval q( &__sanitizer_syscall_post_impl__ksem_getvalue($res, , ($value)));
    }' unless defined(&__sanitizer_syscall_post__ksem_getvalue);
    eval 'sub __sanitizer_syscall_pre__ksem_destroy {
        my($id) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__ksem_destroy(($id)));
    }' unless defined(&__sanitizer_syscall_pre__ksem_destroy);
    eval 'sub __sanitizer_syscall_post__ksem_destroy {
        my($res, $id) = @_;
	    eval q( &__sanitizer_syscall_post_impl__ksem_destroy($res, ($id)));
    }' unless defined(&__sanitizer_syscall_post__ksem_destroy);
    eval 'sub __sanitizer_syscall_pre__ksem_timedwait {
        my($id, $abstime) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__ksem_timedwait(, ($abstime)));
    }' unless defined(&__sanitizer_syscall_pre__ksem_timedwait);
    eval 'sub __sanitizer_syscall_post__ksem_timedwait {
        my($res, $id, $abstime) = @_;
	    eval q( &__sanitizer_syscall_post_impl__ksem_timedwait($res, , ($abstime)));
    }' unless defined(&__sanitizer_syscall_post__ksem_timedwait);
    eval 'sub __sanitizer_syscall_pre_mq_open {
        my($name, $oflag, $mode, $attr) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mq_open(, , , ($attr)));
    }' unless defined(&__sanitizer_syscall_pre_mq_open);
    eval 'sub __sanitizer_syscall_post_mq_open {
        my($res, $name, $oflag, $mode, $attr) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mq_open($res, , , , ($attr)));
    }' unless defined(&__sanitizer_syscall_post_mq_open);
    eval 'sub __sanitizer_syscall_pre_mq_close {
        my($mqdes) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mq_close(($mqdes)));
    }' unless defined(&__sanitizer_syscall_pre_mq_close);
    eval 'sub __sanitizer_syscall_post_mq_close {
        my($res, $mqdes) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mq_close($res, ($mqdes)));
    }' unless defined(&__sanitizer_syscall_post_mq_close);
    eval 'sub __sanitizer_syscall_pre_mq_unlink {
        my($name) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mq_unlink(($name)));
    }' unless defined(&__sanitizer_syscall_pre_mq_unlink);
    eval 'sub __sanitizer_syscall_post_mq_unlink {
        my($res, $name) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mq_unlink($res, ($name)));
    }' unless defined(&__sanitizer_syscall_post_mq_unlink);
    eval 'sub __sanitizer_syscall_pre_mq_getattr {
        my($mqdes, $mqstat) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mq_getattr(, ($mqstat)));
    }' unless defined(&__sanitizer_syscall_pre_mq_getattr);
    eval 'sub __sanitizer_syscall_post_mq_getattr {
        my($res, $mqdes, $mqstat) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mq_getattr($res, , ($mqstat)));
    }' unless defined(&__sanitizer_syscall_post_mq_getattr);
    eval 'sub __sanitizer_syscall_pre_mq_setattr {
        my($mqdes, $mqstat, $omqstat) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mq_setattr( , , ($omqstat)));
    }' unless defined(&__sanitizer_syscall_pre_mq_setattr);
    eval 'sub __sanitizer_syscall_post_mq_setattr {
        my($res, $mqdes, $mqstat, $omqstat) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mq_setattr( $res, , , ($omqstat)));
    }' unless defined(&__sanitizer_syscall_post_mq_setattr);
    eval 'sub __sanitizer_syscall_pre_mq_notify {
        my($mqdes, $notification) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mq_notify(, ($notification)));
    }' unless defined(&__sanitizer_syscall_pre_mq_notify);
    eval 'sub __sanitizer_syscall_post_mq_notify {
        my($res, $mqdes, $notification) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mq_notify($res, , ($notification)));
    }' unless defined(&__sanitizer_syscall_post_mq_notify);
    eval 'sub __sanitizer_syscall_pre_mq_send {
        my($mqdes, $msg_ptr, $msg_len, $msg_prio) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mq_send( , , , ($msg_prio)));
    }' unless defined(&__sanitizer_syscall_pre_mq_send);
    eval 'sub __sanitizer_syscall_post_mq_send {
        my($res, $mqdes, $msg_ptr, $msg_len,						  $msg_prio) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mq_send( $res, , , , ($msg_prio)));
    }' unless defined(&__sanitizer_syscall_post_mq_send);
    eval 'sub __sanitizer_syscall_pre_mq_receive {
        my($mqdes, $msg_ptr, $msg_len, $msg_prio) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mq_receive( , , , ($msg_prio)));
    }' unless defined(&__sanitizer_syscall_pre_mq_receive);
    eval 'sub __sanitizer_syscall_post_mq_receive {
        my($res, $mqdes, $msg_ptr, $msg_len,						  $msg_prio) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mq_receive( $res, , , , ($msg_prio)));
    }' unless defined(&__sanitizer_syscall_post_mq_receive);
    eval 'sub __sanitizer_syscall_pre_compat_50_mq_timedsend {
        my(			    $mqdes, $msg_ptr, $msg_len, $msg_prio, $abs_timeout) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_mq_timedsend( , , , , ($abs_timeout)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_mq_timedsend);
    eval 'sub __sanitizer_syscall_post_compat_50_mq_timedsend {
        my(			   $res, $mqdes, $msg_ptr, $msg_len, $msg_prio, $abs_timeout) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_mq_timedsend( $res, , , , , ($abs_timeout)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_mq_timedsend);
    eval 'sub __sanitizer_syscall_pre_compat_50_mq_timedreceive {
        my(			 $mqdes, $msg_ptr, $msg_len, $msg_prio, $abs_timeout) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_mq_timedreceive( , , , , ($abs_timeout)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_mq_timedreceive);
    eval 'sub __sanitizer_syscall_post_compat_50_mq_timedreceive {
        my(			$res, $mqdes, $msg_ptr, $msg_len, $msg_prio, $abs_timeout) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_mq_timedreceive( $res, , , , , ($abs_timeout)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_mq_timedreceive);
    eval 'sub __sanitizer_syscall_pre___posix_rename {
        my($from, $to) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___posix_rename(, ($to)));
    }' unless defined(&__sanitizer_syscall_pre___posix_rename);
    eval 'sub __sanitizer_syscall_post___posix_rename {
        my($res, $from, $to) = @_;
	    eval q( &__sanitizer_syscall_post_impl___posix_rename($res, , ($to)));
    }' unless defined(&__sanitizer_syscall_post___posix_rename);
    eval 'sub __sanitizer_syscall_pre_swapctl {
        my($cmd, $arg, $misc) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_swapctl(, , ($misc)));
    }' unless defined(&__sanitizer_syscall_pre_swapctl);
    eval 'sub __sanitizer_syscall_post_swapctl {
        my($res, $cmd, $arg, $misc) = @_;
	    eval q( &__sanitizer_syscall_post_impl_swapctl($res, , , ($misc)));
    }' unless defined(&__sanitizer_syscall_post_swapctl);
    eval 'sub __sanitizer_syscall_pre_compat_30_getdents {
        my($fd, $buf, $count) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_30_getdents( , , ($count)));
    }' unless defined(&__sanitizer_syscall_pre_compat_30_getdents);
    eval 'sub __sanitizer_syscall_post_compat_30_getdents {
        my($res, $fd, $buf, $count) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_30_getdents( $res, , , ($count)));
    }' unless defined(&__sanitizer_syscall_post_compat_30_getdents);
    eval 'sub __sanitizer_syscall_pre_minherit {
        my($addr, $len, $inherit) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_minherit(, , ($inherit)));
    }' unless defined(&__sanitizer_syscall_pre_minherit);
    eval 'sub __sanitizer_syscall_post_minherit {
        my($res, $addr, $len, $inherit) = @_;
	    eval q( &__sanitizer_syscall_post_impl_minherit( $res, , , ($inherit)));
    }' unless defined(&__sanitizer_syscall_post_minherit);
    eval 'sub __sanitizer_syscall_pre_lchmod {
        my($path, $mode) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_lchmod(, ($mode)));
    }' unless defined(&__sanitizer_syscall_pre_lchmod);
    eval 'sub __sanitizer_syscall_post_lchmod {
        my($res, $path, $mode) = @_;
	    eval q( &__sanitizer_syscall_post_impl_lchmod($res, , ($mode)));
    }' unless defined(&__sanitizer_syscall_post_lchmod);
    eval 'sub __sanitizer_syscall_pre_lchown {
        my($path, $uid, $gid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_lchown(, , ($gid)));
    }' unless defined(&__sanitizer_syscall_pre_lchown);
    eval 'sub __sanitizer_syscall_post_lchown {
        my($res, $path, $uid, $gid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_lchown($res, , , ($gid)));
    }' unless defined(&__sanitizer_syscall_post_lchown);
    eval 'sub __sanitizer_syscall_pre_compat_50_lutimes {
        my($path, $tptr) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_lutimes(, ($tptr)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_lutimes);
    eval 'sub __sanitizer_syscall_post_compat_50_lutimes {
        my($res, $path, $tptr) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_lutimes($res, , ($tptr)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_lutimes);
    eval 'sub __sanitizer_syscall_pre___msync13 {
        my($addr, $len, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___msync13(, , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre___msync13);
    eval 'sub __sanitizer_syscall_post___msync13 {
        my($res, $addr, $len, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl___msync13( $res, , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post___msync13);
    eval 'sub __sanitizer_syscall_pre_compat_30___stat13 {
        my($path, $ub) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_30___stat13(, ($ub)));
    }' unless defined(&__sanitizer_syscall_pre_compat_30___stat13);
    eval 'sub __sanitizer_syscall_post_compat_30___stat13 {
        my($res, $path, $ub) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_30___stat13($res, , ($ub)));
    }' unless defined(&__sanitizer_syscall_post_compat_30___stat13);
    eval 'sub __sanitizer_syscall_pre_compat_30___fstat13 {
        my($fd, $sb) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_30___fstat13(, ($sb)));
    }' unless defined(&__sanitizer_syscall_pre_compat_30___fstat13);
    eval 'sub __sanitizer_syscall_post_compat_30___fstat13 {
        my($res, $fd, $sb) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_30___fstat13($res, , ($sb)));
    }' unless defined(&__sanitizer_syscall_post_compat_30___fstat13);
    eval 'sub __sanitizer_syscall_pre_compat_30___lstat13 {
        my($path, $ub) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_30___lstat13(, ($ub)));
    }' unless defined(&__sanitizer_syscall_pre_compat_30___lstat13);
    eval 'sub __sanitizer_syscall_post_compat_30___lstat13 {
        my($res, $path, $ub) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_30___lstat13($res, , ($ub)));
    }' unless defined(&__sanitizer_syscall_post_compat_30___lstat13);
    eval 'sub __sanitizer_syscall_pre___sigaltstack14 {
        my($nss, $oss) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___sigaltstack14(, ($oss)));
    }' unless defined(&__sanitizer_syscall_pre___sigaltstack14);
    eval 'sub __sanitizer_syscall_post___sigaltstack14 {
        my($res, $nss, $oss) = @_;
	    eval q( &__sanitizer_syscall_post_impl___sigaltstack14($res, , ($oss)));
    }' unless defined(&__sanitizer_syscall_post___sigaltstack14);
    eval 'sub __sanitizer_syscall_pre___vfork14 () {
        eval q( &__sanitizer_syscall_pre_impl___vfork14());
    }' unless defined(&__sanitizer_syscall_pre___vfork14);
    eval 'sub __sanitizer_syscall_post___vfork14 {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl___vfork14($res));
    }' unless defined(&__sanitizer_syscall_post___vfork14);
    eval 'sub __sanitizer_syscall_pre___posix_chown {
        my($path, $uid, $gid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___posix_chown( , , ($gid)));
    }' unless defined(&__sanitizer_syscall_pre___posix_chown);
    eval 'sub __sanitizer_syscall_post___posix_chown {
        my($res, $path, $uid, $gid) = @_;
	    eval q( &__sanitizer_syscall_post_impl___posix_chown( $res, , , ($gid)));
    }' unless defined(&__sanitizer_syscall_post___posix_chown);
    eval 'sub __sanitizer_syscall_pre___posix_fchown {
        my($fd, $uid, $gid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___posix_fchown( , , ($gid)));
    }' unless defined(&__sanitizer_syscall_pre___posix_fchown);
    eval 'sub __sanitizer_syscall_post___posix_fchown {
        my($res, $fd, $uid, $gid) = @_;
	    eval q( &__sanitizer_syscall_post_impl___posix_fchown( $res, , , ($gid)));
    }' unless defined(&__sanitizer_syscall_post___posix_fchown);
    eval 'sub __sanitizer_syscall_pre___posix_lchown {
        my($path, $uid, $gid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___posix_lchown( , , ($gid)));
    }' unless defined(&__sanitizer_syscall_pre___posix_lchown);
    eval 'sub __sanitizer_syscall_post___posix_lchown {
        my($res, $path, $uid, $gid) = @_;
	    eval q( &__sanitizer_syscall_post_impl___posix_lchown( $res, , , ($gid)));
    }' unless defined(&__sanitizer_syscall_post___posix_lchown);
    eval 'sub __sanitizer_syscall_pre_getsid {
        my($pid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_getsid(($pid)));
    }' unless defined(&__sanitizer_syscall_pre_getsid);
    eval 'sub __sanitizer_syscall_post_getsid {
        my($res, $pid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_getsid($res, ($pid)));
    }' unless defined(&__sanitizer_syscall_post_getsid);
    eval 'sub __sanitizer_syscall_pre___clone {
        my($flags, $stack) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___clone(, ($stack)));
    }' unless defined(&__sanitizer_syscall_pre___clone);
    eval 'sub __sanitizer_syscall_post___clone {
        my($res, $flags, $stack) = @_;
	    eval q( &__sanitizer_syscall_post_impl___clone($res, , ($stack)));
    }' unless defined(&__sanitizer_syscall_post___clone);
    eval 'sub __sanitizer_syscall_pre_fktrace {
        my($fd, $ops, $facs, $pid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fktrace(, , , ($pid)));
    }' unless defined(&__sanitizer_syscall_pre_fktrace);
    eval 'sub __sanitizer_syscall_post_fktrace {
        my($res, $fd, $ops, $facs, $pid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fktrace($res, , , , ($pid)));
    }' unless defined(&__sanitizer_syscall_post_fktrace);
    eval 'sub __sanitizer_syscall_pre_preadv {
        my($fd, $iovp, $iovcnt, $PAD, $offset) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_preadv(, , , , ($offset)));
    }' unless defined(&__sanitizer_syscall_pre_preadv);
    eval 'sub __sanitizer_syscall_post_preadv {
        my($res, $fd, $iovp, $iovcnt, $PAD, $offset) = @_;
	    eval q( &__sanitizer_syscall_post_impl_preadv($res, , , , , ($offset)));
    }' unless defined(&__sanitizer_syscall_post_preadv);
    eval 'sub __sanitizer_syscall_pre_pwritev {
        my($fd, $iovp, $iovcnt, $PAD, $offset) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_pwritev(, , , , ($offset)));
    }' unless defined(&__sanitizer_syscall_pre_pwritev);
    eval 'sub __sanitizer_syscall_post_pwritev {
        my($res, $fd, $iovp, $iovcnt, $PAD, $offset) = @_;
	    eval q( &__sanitizer_syscall_post_impl_pwritev( $res, , , , , ($offset)));
    }' unless defined(&__sanitizer_syscall_post_pwritev);
    eval 'sub __sanitizer_syscall_pre_compat_16___sigaction14 {
        my($signum, $nsa, $osa) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_16___sigaction14( , , ($osa)));
    }' unless defined(&__sanitizer_syscall_pre_compat_16___sigaction14);
    eval 'sub __sanitizer_syscall_post_compat_16___sigaction14 {
        my($res, $signum, $nsa,							      $osa) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_16___sigaction14( $res, , , ($osa)));
    }' unless defined(&__sanitizer_syscall_post_compat_16___sigaction14);
    eval 'sub __sanitizer_syscall_pre___sigpending14 {
        my($set) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___sigpending14(($set)));
    }' unless defined(&__sanitizer_syscall_pre___sigpending14);
    eval 'sub __sanitizer_syscall_post___sigpending14 {
        my($res, $set) = @_;
	    eval q( &__sanitizer_syscall_post_impl___sigpending14($res, ($set)));
    }' unless defined(&__sanitizer_syscall_post___sigpending14);
    eval 'sub __sanitizer_syscall_pre___sigprocmask14 {
        my($how, $set, $oset) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___sigprocmask14( , , ($oset)));
    }' unless defined(&__sanitizer_syscall_pre___sigprocmask14);
    eval 'sub __sanitizer_syscall_post___sigprocmask14 {
        my($res, $how, $set, $oset) = @_;
	    eval q( &__sanitizer_syscall_post_impl___sigprocmask14( $res, , , ($oset)));
    }' unless defined(&__sanitizer_syscall_post___sigprocmask14);
    eval 'sub __sanitizer_syscall_pre___sigsuspend14 {
        my($set) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___sigsuspend14(($set)));
    }' unless defined(&__sanitizer_syscall_pre___sigsuspend14);
    eval 'sub __sanitizer_syscall_post___sigsuspend14 {
        my($res, $set) = @_;
	    eval q( &__sanitizer_syscall_post_impl___sigsuspend14($res, ($set)));
    }' unless defined(&__sanitizer_syscall_post___sigsuspend14);
    eval 'sub __sanitizer_syscall_pre_compat_16___sigreturn14 {
        my($sigcntxp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_16___sigreturn14(($sigcntxp)));
    }' unless defined(&__sanitizer_syscall_pre_compat_16___sigreturn14);
    eval 'sub __sanitizer_syscall_post_compat_16___sigreturn14 {
        my($res, $sigcntxp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_16___sigreturn14($res, ($sigcntxp)));
    }' unless defined(&__sanitizer_syscall_post_compat_16___sigreturn14);
    eval 'sub __sanitizer_syscall_pre___getcwd {
        my($bufp, $length) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___getcwd(, ($length)));
    }' unless defined(&__sanitizer_syscall_pre___getcwd);
    eval 'sub __sanitizer_syscall_post___getcwd {
        my($res, $bufp, $length) = @_;
	    eval q( &__sanitizer_syscall_post_impl___getcwd($res, , ($length)));
    }' unless defined(&__sanitizer_syscall_post___getcwd);
    eval 'sub __sanitizer_syscall_pre_fchroot {
        my($fd) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fchroot(($fd)));
    }' unless defined(&__sanitizer_syscall_pre_fchroot);
    eval 'sub __sanitizer_syscall_post_fchroot {
        my($res, $fd) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fchroot($res, ($fd)));
    }' unless defined(&__sanitizer_syscall_post_fchroot);
    eval 'sub __sanitizer_syscall_pre_compat_30_fhopen {
        my($fhp, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_30_fhopen(, ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_compat_30_fhopen);
    eval 'sub __sanitizer_syscall_post_compat_30_fhopen {
        my($res, $fhp, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_30_fhopen($res, , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_compat_30_fhopen);
    eval 'sub __sanitizer_syscall_pre_compat_30_fhstat {
        my($fhp, $sb) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_30_fhstat(, ($sb)));
    }' unless defined(&__sanitizer_syscall_pre_compat_30_fhstat);
    eval 'sub __sanitizer_syscall_post_compat_30_fhstat {
        my($res, $fhp, $sb) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_30_fhstat($res, , ($sb)));
    }' unless defined(&__sanitizer_syscall_post_compat_30_fhstat);
    eval 'sub __sanitizer_syscall_pre_compat_20_fhstatfs {
        my($fhp, $buf) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_20_fhstatfs(, ($buf)));
    }' unless defined(&__sanitizer_syscall_pre_compat_20_fhstatfs);
    eval 'sub __sanitizer_syscall_post_compat_20_fhstatfs {
        my($res, $fhp, $buf) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_20_fhstatfs($res, , ($buf)));
    }' unless defined(&__sanitizer_syscall_post_compat_20_fhstatfs);
    eval 'sub __sanitizer_syscall_pre_compat_50_____semctl13 {
        my($semid, $semnum, $cmd,							    $arg) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_____semctl13( , , , ($arg)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_____semctl13);
    eval 'sub __sanitizer_syscall_post_compat_50_____semctl13 {
        my($res, $semid, $semnum,							    $cmd, $arg) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_____semctl13( $res, , , , ($arg)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_____semctl13);
    eval 'sub __sanitizer_syscall_pre_compat_50___msgctl13 {
        my($msqid, $cmd, $buf) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50___msgctl13( , , ($buf)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50___msgctl13);
    eval 'sub __sanitizer_syscall_post_compat_50___msgctl13 {
        my($res, $msqid, $cmd, $buf) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50___msgctl13( $res, , , ($buf)));
    }' unless defined(&__sanitizer_syscall_post_compat_50___msgctl13);
    eval 'sub __sanitizer_syscall_pre_compat_50___shmctl13 {
        my($shmid, $cmd, $buf) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50___shmctl13( , , ($buf)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50___shmctl13);
    eval 'sub __sanitizer_syscall_post_compat_50___shmctl13 {
        my($res, $shmid, $cmd, $buf) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50___shmctl13( $res, , , ($buf)));
    }' unless defined(&__sanitizer_syscall_post_compat_50___shmctl13);
    eval 'sub __sanitizer_syscall_pre_lchflags {
        my($path, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_lchflags(, ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_lchflags);
    eval 'sub __sanitizer_syscall_post_lchflags {
        my($res, $path, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_lchflags($res, , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_lchflags);
    eval 'sub __sanitizer_syscall_pre_issetugid () {
        eval q( &__sanitizer_syscall_pre_impl_issetugid());
    }' unless defined(&__sanitizer_syscall_pre_issetugid);
    eval 'sub __sanitizer_syscall_post_issetugid {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_issetugid($res));
    }' unless defined(&__sanitizer_syscall_post_issetugid);
    eval 'sub __sanitizer_syscall_pre_utrace {
        my($label, $addr, $len) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_utrace(, , ($len)));
    }' unless defined(&__sanitizer_syscall_pre_utrace);
    eval 'sub __sanitizer_syscall_post_utrace {
        my($res, $label, $addr, $len) = @_;
	    eval q( &__sanitizer_syscall_post_impl_utrace($res, , , ($len)));
    }' unless defined(&__sanitizer_syscall_post_utrace);
    eval 'sub __sanitizer_syscall_pre_getcontext {
        my($ucp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_getcontext(($ucp)));
    }' unless defined(&__sanitizer_syscall_pre_getcontext);
    eval 'sub __sanitizer_syscall_post_getcontext {
        my($res, $ucp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_getcontext($res, ($ucp)));
    }' unless defined(&__sanitizer_syscall_post_getcontext);
    eval 'sub __sanitizer_syscall_pre_setcontext {
        my($ucp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_setcontext(($ucp)));
    }' unless defined(&__sanitizer_syscall_pre_setcontext);
    eval 'sub __sanitizer_syscall_post_setcontext {
        my($res, $ucp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_setcontext($res, ($ucp)));
    }' unless defined(&__sanitizer_syscall_post_setcontext);
    eval 'sub __sanitizer_syscall_pre__lwp_create {
        my($ucp, $flags, $new_lwp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__lwp_create( , , ($new_lwp)));
    }' unless defined(&__sanitizer_syscall_pre__lwp_create);
    eval 'sub __sanitizer_syscall_post__lwp_create {
        my($res, $ucp, $flags, $new_lwp) = @_;
	    eval q( &__sanitizer_syscall_post_impl__lwp_create( $res, , , ($new_lwp)));
    }' unless defined(&__sanitizer_syscall_post__lwp_create);
    eval 'sub __sanitizer_syscall_pre__lwp_exit () {
        eval q( &__sanitizer_syscall_pre_impl__lwp_exit());
    }' unless defined(&__sanitizer_syscall_pre__lwp_exit);
    eval 'sub __sanitizer_syscall_post__lwp_exit {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl__lwp_exit($res));
    }' unless defined(&__sanitizer_syscall_post__lwp_exit);
    eval 'sub __sanitizer_syscall_pre__lwp_self () {
        eval q( &__sanitizer_syscall_pre_impl__lwp_self());
    }' unless defined(&__sanitizer_syscall_pre__lwp_self);
    eval 'sub __sanitizer_syscall_post__lwp_self {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl__lwp_self($res));
    }' unless defined(&__sanitizer_syscall_post__lwp_self);
    eval 'sub __sanitizer_syscall_pre__lwp_wait {
        my($wait_for, $departed) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__lwp_wait(, ($departed)));
    }' unless defined(&__sanitizer_syscall_pre__lwp_wait);
    eval 'sub __sanitizer_syscall_post__lwp_wait {
        my($res, $wait_for, $departed) = @_;
	    eval q( &__sanitizer_syscall_post_impl__lwp_wait($res, , ($departed)));
    }' unless defined(&__sanitizer_syscall_post__lwp_wait);
    eval 'sub __sanitizer_syscall_pre__lwp_suspend {
        my($target) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__lwp_suspend(($target)));
    }' unless defined(&__sanitizer_syscall_pre__lwp_suspend);
    eval 'sub __sanitizer_syscall_post__lwp_suspend {
        my($res, $target) = @_;
	    eval q( &__sanitizer_syscall_post_impl__lwp_suspend($res, ($target)));
    }' unless defined(&__sanitizer_syscall_post__lwp_suspend);
    eval 'sub __sanitizer_syscall_pre__lwp_continue {
        my($target) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__lwp_continue(($target)));
    }' unless defined(&__sanitizer_syscall_pre__lwp_continue);
    eval 'sub __sanitizer_syscall_post__lwp_continue {
        my($res, $target) = @_;
	    eval q( &__sanitizer_syscall_post_impl__lwp_continue($res, ($target)));
    }' unless defined(&__sanitizer_syscall_post__lwp_continue);
    eval 'sub __sanitizer_syscall_pre__lwp_wakeup {
        my($target) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__lwp_wakeup(($target)));
    }' unless defined(&__sanitizer_syscall_pre__lwp_wakeup);
    eval 'sub __sanitizer_syscall_post__lwp_wakeup {
        my($res, $target) = @_;
	    eval q( &__sanitizer_syscall_post_impl__lwp_wakeup($res, ($target)));
    }' unless defined(&__sanitizer_syscall_post__lwp_wakeup);
    eval 'sub __sanitizer_syscall_pre__lwp_getprivate () {
        eval q( &__sanitizer_syscall_pre_impl__lwp_getprivate());
    }' unless defined(&__sanitizer_syscall_pre__lwp_getprivate);
    eval 'sub __sanitizer_syscall_post__lwp_getprivate {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl__lwp_getprivate($res));
    }' unless defined(&__sanitizer_syscall_post__lwp_getprivate);
    eval 'sub __sanitizer_syscall_pre__lwp_setprivate {
        my($ptr) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__lwp_setprivate(($ptr)));
    }' unless defined(&__sanitizer_syscall_pre__lwp_setprivate);
    eval 'sub __sanitizer_syscall_post__lwp_setprivate {
        my($res, $ptr) = @_;
	    eval q( &__sanitizer_syscall_post_impl__lwp_setprivate($res, ($ptr)));
    }' unless defined(&__sanitizer_syscall_post__lwp_setprivate);
    eval 'sub __sanitizer_syscall_pre__lwp_kill {
        my($target, $signo) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__lwp_kill(, ($signo)));
    }' unless defined(&__sanitizer_syscall_pre__lwp_kill);
    eval 'sub __sanitizer_syscall_post__lwp_kill {
        my($res, $target, $signo) = @_;
	    eval q( &__sanitizer_syscall_post_impl__lwp_kill($res, , ($signo)));
    }' unless defined(&__sanitizer_syscall_post__lwp_kill);
    eval 'sub __sanitizer_syscall_pre__lwp_detach {
        my($target) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__lwp_detach(($target)));
    }' unless defined(&__sanitizer_syscall_pre__lwp_detach);
    eval 'sub __sanitizer_syscall_post__lwp_detach {
        my($res, $target) = @_;
	    eval q( &__sanitizer_syscall_post_impl__lwp_detach($res, ($target)));
    }' unless defined(&__sanitizer_syscall_post__lwp_detach);
    eval 'sub __sanitizer_syscall_pre_compat_50__lwp_park {
        my($ts, $unpark, $hint,							      $unparkhint) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50__lwp_park( , , , ($unparkhint)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50__lwp_park);
    eval 'sub __sanitizer_syscall_post_compat_50__lwp_park {
        my($res, $ts, $unpark, $hint,							 $unparkhint) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50__lwp_park( $res, , , , ($unparkhint)));
    }' unless defined(&__sanitizer_syscall_post_compat_50__lwp_park);
    eval 'sub __sanitizer_syscall_pre__lwp_unpark {
        my($target, $hint) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__lwp_unpark(, ($hint)));
    }' unless defined(&__sanitizer_syscall_pre__lwp_unpark);
    eval 'sub __sanitizer_syscall_post__lwp_unpark {
        my($res, $target, $hint) = @_;
	    eval q( &__sanitizer_syscall_post_impl__lwp_unpark($res, , ($hint)));
    }' unless defined(&__sanitizer_syscall_post__lwp_unpark);
    eval 'sub __sanitizer_syscall_pre__lwp_unpark_all {
        my($targets, $ntargets, $hint) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__lwp_unpark_all( , , ($hint)));
    }' unless defined(&__sanitizer_syscall_pre__lwp_unpark_all);
    eval 'sub __sanitizer_syscall_post__lwp_unpark_all {
        my($res, $targets, $ntargets, $hint) = @_;
	    eval q( &__sanitizer_syscall_post_impl__lwp_unpark_all( $res, , , ($hint)));
    }' unless defined(&__sanitizer_syscall_post__lwp_unpark_all);
    eval 'sub __sanitizer_syscall_pre__lwp_setname {
        my($target, $name) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__lwp_setname(, ($name)));
    }' unless defined(&__sanitizer_syscall_pre__lwp_setname);
    eval 'sub __sanitizer_syscall_post__lwp_setname {
        my($res, $target, $name) = @_;
	    eval q( &__sanitizer_syscall_post_impl__lwp_setname($res, , ($name)));
    }' unless defined(&__sanitizer_syscall_post__lwp_setname);
    eval 'sub __sanitizer_syscall_pre__lwp_getname {
        my($target, $name, $len) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__lwp_getname( , , ($len)));
    }' unless defined(&__sanitizer_syscall_pre__lwp_getname);
    eval 'sub __sanitizer_syscall_post__lwp_getname {
        my($res, $target, $name, $len) = @_;
	    eval q( &__sanitizer_syscall_post_impl__lwp_getname( $res, , , ($len)));
    }' unless defined(&__sanitizer_syscall_post__lwp_getname);
    eval 'sub __sanitizer_syscall_pre__lwp_ctl {
        my($features, $address) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__lwp_ctl(, ($address)));
    }' unless defined(&__sanitizer_syscall_pre__lwp_ctl);
    eval 'sub __sanitizer_syscall_post__lwp_ctl {
        my($res, $features, $address) = @_;
	    eval q( &__sanitizer_syscall_post_impl__lwp_ctl($res, , ($address)));
    }' unless defined(&__sanitizer_syscall_post__lwp_ctl);
    eval 'sub __sanitizer_syscall_pre_compat_60_sa_register {
        my($newv, $oldv, $flags,							     $stackinfo_offset) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_60_sa_register( , , , ($stackinfo_offset)));
    }' unless defined(&__sanitizer_syscall_pre_compat_60_sa_register);
    eval 'sub __sanitizer_syscall_post_compat_60_sa_register {
        my($res, $newv, $oldv, $flags,							$stackinfo_offset) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_60_sa_register( $res, , , , ($stackinfo_offset)));
    }' unless defined(&__sanitizer_syscall_post_compat_60_sa_register);
    eval 'sub __sanitizer_syscall_pre_compat_60_sa_stacks {
        my($num, $stacks) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_60_sa_stacks(, ($stacks)));
    }' unless defined(&__sanitizer_syscall_pre_compat_60_sa_stacks);
    eval 'sub __sanitizer_syscall_post_compat_60_sa_stacks {
        my($res, $num, $stacks) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_60_sa_stacks($res, , ($stacks)));
    }' unless defined(&__sanitizer_syscall_post_compat_60_sa_stacks);
    eval 'sub __sanitizer_syscall_pre_compat_60_sa_enable () {
        eval q( &__sanitizer_syscall_pre_impl_compat_60_sa_enable());
    }' unless defined(&__sanitizer_syscall_pre_compat_60_sa_enable);
    eval 'sub __sanitizer_syscall_post_compat_60_sa_enable {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_60_sa_enable($res));
    }' unless defined(&__sanitizer_syscall_post_compat_60_sa_enable);
    eval 'sub __sanitizer_syscall_pre_compat_60_sa_setconcurrency {
        my($concurrency) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_60_sa_setconcurrency( ($concurrency)));
    }' unless defined(&__sanitizer_syscall_pre_compat_60_sa_setconcurrency);
    eval 'sub __sanitizer_syscall_post_compat_60_sa_setconcurrency {
        my($res, $concurrency) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_60_sa_setconcurrency( $res, ($concurrency)));
    }' unless defined(&__sanitizer_syscall_post_compat_60_sa_setconcurrency);
    eval 'sub __sanitizer_syscall_pre_compat_60_sa_yield () {
        eval q( &__sanitizer_syscall_pre_impl_compat_60_sa_yield());
    }' unless defined(&__sanitizer_syscall_pre_compat_60_sa_yield);
    eval 'sub __sanitizer_syscall_post_compat_60_sa_yield {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_60_sa_yield($res));
    }' unless defined(&__sanitizer_syscall_post_compat_60_sa_yield);
    eval 'sub __sanitizer_syscall_pre_compat_60_sa_preempt {
        my($sa_id) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_60_sa_preempt(($sa_id)));
    }' unless defined(&__sanitizer_syscall_pre_compat_60_sa_preempt);
    eval 'sub __sanitizer_syscall_post_compat_60_sa_preempt {
        my($res, $sa_id) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_60_sa_preempt($res, ($sa_id)));
    }' unless defined(&__sanitizer_syscall_post_compat_60_sa_preempt);
    eval 'sub __sanitizer_syscall_pre___sigaction_sigtramp {
        my($signum, $nsa, $osa, $tramp,						       $vers) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___sigaction_sigtramp( , , , , ($vers)));
    }' unless defined(&__sanitizer_syscall_pre___sigaction_sigtramp);
    eval 'sub __sanitizer_syscall_post___sigaction_sigtramp {
        my($res, $signum, $nsa, $osa,							 $tramp, $vers) = @_;
	    eval q( &__sanitizer_syscall_post_impl___sigaction_sigtramp( $res, , , , , ($vers)));
    }' unless defined(&__sanitizer_syscall_post___sigaction_sigtramp);
    eval 'sub __sanitizer_syscall_pre_rasctl {
        my($addr, $len, $op) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_rasctl(, , ($op)));
    }' unless defined(&__sanitizer_syscall_pre_rasctl);
    eval 'sub __sanitizer_syscall_post_rasctl {
        my($res, $addr, $len, $op) = @_;
	    eval q( &__sanitizer_syscall_post_impl_rasctl($res, , , ($op)));
    }' unless defined(&__sanitizer_syscall_post_rasctl);
    eval 'sub __sanitizer_syscall_pre_kqueue () {
        eval q( &__sanitizer_syscall_pre_impl_kqueue());
    }' unless defined(&__sanitizer_syscall_pre_kqueue);
    eval 'sub __sanitizer_syscall_post_kqueue {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_kqueue($res));
    }' unless defined(&__sanitizer_syscall_post_kqueue);
    eval 'sub __sanitizer_syscall_pre_compat_50_kevent {
        my($fd, $changelist, $nchanges,						      $eventlist, $nevents, $timeout) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_kevent( , , , , , ($timeout)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_kevent);
    eval 'sub __sanitizer_syscall_post_compat_50_kevent {
        my(				 $res, $fd, $changelist, $nchanges, $eventlist, $nevents, $timeout) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_kevent( $res, , , , , , ($timeout)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_kevent);
    eval 'sub __sanitizer_syscall_pre__sched_setparam {
        my($pid, $lid, $policy, $params) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__sched_setparam( , , , ($params)));
    }' unless defined(&__sanitizer_syscall_pre__sched_setparam);
    eval 'sub __sanitizer_syscall_post__sched_setparam {
        my($res, $pid, $lid, $policy,							 $params) = @_;
	    eval q( &__sanitizer_syscall_post_impl__sched_setparam( $res, , , , ($params)));
    }' unless defined(&__sanitizer_syscall_post__sched_setparam);
    eval 'sub __sanitizer_syscall_pre__sched_getparam {
        my($pid, $lid, $policy, $params) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__sched_getparam( , , , ($params)));
    }' unless defined(&__sanitizer_syscall_pre__sched_getparam);
    eval 'sub __sanitizer_syscall_post__sched_getparam {
        my($res, $pid, $lid, $policy,							 $params) = @_;
	    eval q( &__sanitizer_syscall_post_impl__sched_getparam( $res, , , , ($params)));
    }' unless defined(&__sanitizer_syscall_post__sched_getparam);
    eval 'sub __sanitizer_syscall_pre__sched_setaffinity {
        my($pid, $lid, $size, $cpuset) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__sched_setaffinity( , , , ($cpuset)));
    }' unless defined(&__sanitizer_syscall_pre__sched_setaffinity);
    eval 'sub __sanitizer_syscall_post__sched_setaffinity {
        my($res, $pid, $lid, $size,							   $cpuset) = @_;
	    eval q( &__sanitizer_syscall_post_impl__sched_setaffinity( $res, , , , ($cpuset)));
    }' unless defined(&__sanitizer_syscall_post__sched_setaffinity);
    eval 'sub __sanitizer_syscall_pre__sched_getaffinity {
        my($pid, $lid, $size, $cpuset) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__sched_getaffinity( , , , ($cpuset)));
    }' unless defined(&__sanitizer_syscall_pre__sched_getaffinity);
    eval 'sub __sanitizer_syscall_post__sched_getaffinity {
        my($res, $pid, $lid, $size,							   $cpuset) = @_;
	    eval q( &__sanitizer_syscall_post_impl__sched_getaffinity( $res, , , , ($cpuset)));
    }' unless defined(&__sanitizer_syscall_post__sched_getaffinity);
    eval 'sub __sanitizer_syscall_pre_sched_yield () {
        eval q( &__sanitizer_syscall_pre_impl_sched_yield());
    }' unless defined(&__sanitizer_syscall_pre_sched_yield);
    eval 'sub __sanitizer_syscall_post_sched_yield {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_sched_yield($res));
    }' unless defined(&__sanitizer_syscall_post_sched_yield);
    eval 'sub __sanitizer_syscall_pre__sched_protect {
        my($priority) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__sched_protect(($priority)));
    }' unless defined(&__sanitizer_syscall_pre__sched_protect);
    eval 'sub __sanitizer_syscall_post__sched_protect {
        my($res, $priority) = @_;
	    eval q( &__sanitizer_syscall_post_impl__sched_protect($res, ($priority)));
    }' unless defined(&__sanitizer_syscall_post__sched_protect);
    eval 'sub __sanitizer_syscall_pre_fsync_range {
        my($fd, $flags, $start, $length) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fsync_range( , , , ($length)));
    }' unless defined(&__sanitizer_syscall_pre_fsync_range);
    eval 'sub __sanitizer_syscall_post_fsync_range {
        my($res, $fd, $flags, $start, $length) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fsync_range( $res, , , , ($length)));
    }' unless defined(&__sanitizer_syscall_post_fsync_range);
    eval 'sub __sanitizer_syscall_pre_uuidgen {
        my($store, $count) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_uuidgen(, ($count)));
    }' unless defined(&__sanitizer_syscall_pre_uuidgen);
    eval 'sub __sanitizer_syscall_post_uuidgen {
        my($res, $store, $count) = @_;
	    eval q( &__sanitizer_syscall_post_impl_uuidgen($res, , ($count)));
    }' unless defined(&__sanitizer_syscall_post_uuidgen);
    eval 'sub __sanitizer_syscall_pre_compat_90_getvfsstat {
        my($buf, $bufsize, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_90_getvfsstat( , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_compat_90_getvfsstat);
    eval 'sub __sanitizer_syscall_post_compat_90_getvfsstat {
        my($res, $buf, $bufsize,							     $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_90_getvfsstat( $res, , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_compat_90_getvfsstat);
    eval 'sub __sanitizer_syscall_pre_compat_90_statvfs1 {
        my($path, $buf, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_90_statvfs1( , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_compat_90_statvfs1);
    eval 'sub __sanitizer_syscall_post_compat_90_statvfs1 {
        my($res, $path, $buf, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_90_statvfs1( $res, , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_compat_90_statvfs1);
    eval 'sub __sanitizer_syscall_pre_compat_90_fstatvfs1 {
        my($fd, $buf, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_90_fstatvfs1( , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_compat_90_fstatvfs1);
    eval 'sub __sanitizer_syscall_post_compat_90_fstatvfs1 {
        my($res, $fd, $buf, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_90_fstatvfs1( $res, , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_compat_90_fstatvfs1);
    eval 'sub __sanitizer_syscall_pre_compat_30_fhstatvfs1 {
        my($fhp, $buf, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_30_fhstatvfs1( , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_compat_30_fhstatvfs1);
    eval 'sub __sanitizer_syscall_post_compat_30_fhstatvfs1 {
        my($res, $fhp, $buf, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_30_fhstatvfs1( $res, , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_compat_30_fhstatvfs1);
    eval 'sub __sanitizer_syscall_pre_extattrctl {
        my($path, $cmd, $filename, $attrnamespace,					    $attrname) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_extattrctl( , , , , ($attrname)));
    }' unless defined(&__sanitizer_syscall_pre_extattrctl);
    eval 'sub __sanitizer_syscall_post_extattrctl {
        my($res, $path, $cmd, $filename,						      $attrnamespace, $attrname) = @_;
	    eval q( &__sanitizer_syscall_post_impl_extattrctl( $res, , , , , ($attrname)));
    }' unless defined(&__sanitizer_syscall_post_extattrctl);
    eval 'sub __sanitizer_syscall_pre_extattr_set_file {
        my($path, $attrnamespace,							   $attrname, $data, $nbytes) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_extattr_set_file( , , , , ($nbytes)));
    }' unless defined(&__sanitizer_syscall_pre_extattr_set_file);
    eval 'sub __sanitizer_syscall_post_extattr_set_file {
        my($res, $path, $attrnamespace,						      $attrname, $data, $nbytes) = @_;
	    eval q( &__sanitizer_syscall_post_impl_extattr_set_file( $res, , , , , ($nbytes)));
    }' unless defined(&__sanitizer_syscall_post_extattr_set_file);
    eval 'sub __sanitizer_syscall_pre_extattr_get_file {
        my($path, $attrnamespace,							   $attrname, $data, $nbytes) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_extattr_get_file( , , , , ($nbytes)));
    }' unless defined(&__sanitizer_syscall_pre_extattr_get_file);
    eval 'sub __sanitizer_syscall_post_extattr_get_file {
        my($res, $path, $attrnamespace,						      $attrname, $data, $nbytes) = @_;
	    eval q( &__sanitizer_syscall_post_impl_extattr_get_file( $res, , , , , ($nbytes)));
    }' unless defined(&__sanitizer_syscall_post_extattr_get_file);
    eval 'sub __sanitizer_syscall_pre_extattr_delete_file {
        my($path, $attrnamespace,							   $attrname) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_extattr_delete_file( , , ($attrname)));
    }' unless defined(&__sanitizer_syscall_pre_extattr_delete_file);
    eval 'sub __sanitizer_syscall_post_extattr_delete_file {
        my($res, $path, $attrnamespace,						      $attrname) = @_;
	    eval q( &__sanitizer_syscall_post_impl_extattr_delete_file( $res, , , ($attrname)));
    }' unless defined(&__sanitizer_syscall_post_extattr_delete_file);
    eval 'sub __sanitizer_syscall_pre_extattr_set_fd {
        my($fd, $attrnamespace, $attrname,						   $data, $nbytes) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_extattr_set_fd( , , , , ($nbytes)));
    }' unless defined(&__sanitizer_syscall_pre_extattr_set_fd);
    eval 'sub __sanitizer_syscall_post_extattr_set_fd {
        my($res, $fd, $attrnamespace,							$attrname, $data, $nbytes) = @_;
	    eval q( &__sanitizer_syscall_post_impl_extattr_set_fd( $res, , , , , ($nbytes)));
    }' unless defined(&__sanitizer_syscall_post_extattr_set_fd);
    eval 'sub __sanitizer_syscall_pre_extattr_get_fd {
        my($fd, $attrnamespace, $attrname,						   $data, $nbytes) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_extattr_get_fd( , , , , ($nbytes)));
    }' unless defined(&__sanitizer_syscall_pre_extattr_get_fd);
    eval 'sub __sanitizer_syscall_post_extattr_get_fd {
        my($res, $fd, $attrnamespace,							$attrname, $data, $nbytes) = @_;
	    eval q( &__sanitizer_syscall_post_impl_extattr_get_fd( $res, , , , , ($nbytes)));
    }' unless defined(&__sanitizer_syscall_post_extattr_get_fd);
    eval 'sub __sanitizer_syscall_pre_extattr_delete_fd {
        my($fd, $attrnamespace, $attrname) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_extattr_delete_fd( , , ($attrname)));
    }' unless defined(&__sanitizer_syscall_pre_extattr_delete_fd);
    eval 'sub __sanitizer_syscall_post_extattr_delete_fd {
        my($res, $fd, $attrnamespace,							$attrname) = @_;
	    eval q( &__sanitizer_syscall_post_impl_extattr_delete_fd( $res, , , ($attrname)));
    }' unless defined(&__sanitizer_syscall_post_extattr_delete_fd);
    eval 'sub __sanitizer_syscall_pre_extattr_set_link {
        my($path, $attrnamespace,							   $attrname, $data, $nbytes) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_extattr_set_link( , , , , ($nbytes)));
    }' unless defined(&__sanitizer_syscall_pre_extattr_set_link);
    eval 'sub __sanitizer_syscall_post_extattr_set_link {
        my($res, $path, $attrnamespace,						      $attrname, $data, $nbytes) = @_;
	    eval q( &__sanitizer_syscall_post_impl_extattr_set_link( $res, , , , , ($nbytes)));
    }' unless defined(&__sanitizer_syscall_post_extattr_set_link);
    eval 'sub __sanitizer_syscall_pre_extattr_get_link {
        my($path, $attrnamespace,							   $attrname, $data, $nbytes) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_extattr_get_link( , , , , ($nbytes)));
    }' unless defined(&__sanitizer_syscall_pre_extattr_get_link);
    eval 'sub __sanitizer_syscall_post_extattr_get_link {
        my($res, $path, $attrnamespace,						      $attrname, $data, $nbytes) = @_;
	    eval q( &__sanitizer_syscall_post_impl_extattr_get_link( $res, , , , , ($nbytes)));
    }' unless defined(&__sanitizer_syscall_post_extattr_get_link);
    eval 'sub __sanitizer_syscall_pre_extattr_delete_link {
        my($path, $attrnamespace,							   $attrname) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_extattr_delete_link( , , ($attrname)));
    }' unless defined(&__sanitizer_syscall_pre_extattr_delete_link);
    eval 'sub __sanitizer_syscall_post_extattr_delete_link {
        my($res, $path, $attrnamespace,						      $attrname) = @_;
	    eval q( &__sanitizer_syscall_post_impl_extattr_delete_link( $res, , , ($attrname)));
    }' unless defined(&__sanitizer_syscall_post_extattr_delete_link);
    eval 'sub __sanitizer_syscall_pre_extattr_list_fd {
        my($fd, $attrnamespace, $data,						       $nbytes) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_extattr_list_fd( , , , ($nbytes)));
    }' unless defined(&__sanitizer_syscall_pre_extattr_list_fd);
    eval 'sub __sanitizer_syscall_post_extattr_list_fd {
        my($res, $fd, $attrnamespace, $data,						  $nbytes) = @_;
	    eval q( &__sanitizer_syscall_post_impl_extattr_list_fd( $res, , , , ($nbytes)));
    }' unless defined(&__sanitizer_syscall_post_extattr_list_fd);
    eval 'sub __sanitizer_syscall_pre_extattr_list_file {
        my($path, $attrnamespace, $data,						     $nbytes) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_extattr_list_file( , , , ($nbytes)));
    }' unless defined(&__sanitizer_syscall_pre_extattr_list_file);
    eval 'sub __sanitizer_syscall_post_extattr_list_file {
        my($res, $path, $attrnamespace,						      $data, $nbytes) = @_;
	    eval q( &__sanitizer_syscall_post_impl_extattr_list_file( $res, , , , ($nbytes)));
    }' unless defined(&__sanitizer_syscall_post_extattr_list_file);
    eval 'sub __sanitizer_syscall_pre_extattr_list_link {
        my($path, $attrnamespace, $data,						     $nbytes) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_extattr_list_link( , , , ($nbytes)));
    }' unless defined(&__sanitizer_syscall_pre_extattr_list_link);
    eval 'sub __sanitizer_syscall_post_extattr_list_link {
        my($res, $path, $attrnamespace,						      $data, $nbytes) = @_;
	    eval q( &__sanitizer_syscall_post_impl_extattr_list_link( $res, , , , ($nbytes)));
    }' unless defined(&__sanitizer_syscall_post_extattr_list_link);
    eval 'sub __sanitizer_syscall_pre_compat_50_pselect {
        my($nd, $in, $ou, $ex, $ts, $mask) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_pselect( , , , , , ($mask)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_pselect);
    eval 'sub __sanitizer_syscall_post_compat_50_pselect {
        my($res, $nd, $in, $ou, $ex, $ts,						       $mask) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_pselect( $res, , , , , , ($mask)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_pselect);
    eval 'sub __sanitizer_syscall_pre_compat_50_pollts {
        my($fds, $nfds, $ts, $mask) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_pollts( , , , ($mask)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_pollts);
    eval 'sub __sanitizer_syscall_post_compat_50_pollts {
        my($res, $fds, $nfds, $ts, $mask) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_pollts( $res, , , , ($mask)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_pollts);
    eval 'sub __sanitizer_syscall_pre_setxattr {
        my($path, $name, $value, $size, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_setxattr(, , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_setxattr);
    eval 'sub __sanitizer_syscall_post_setxattr {
        my($res, $path, $name, $value, $size, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_setxattr( $res, , , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_setxattr);
    eval 'sub __sanitizer_syscall_pre_lsetxattr {
        my($path, $name, $value, $size, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_lsetxattr( , , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_lsetxattr);
    eval 'sub __sanitizer_syscall_post_lsetxattr {
        my($res, $path, $name, $value, $size,						  $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_lsetxattr( $res, , , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_lsetxattr);
    eval 'sub __sanitizer_syscall_pre_fsetxattr {
        my($fd, $name, $value, $size, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fsetxattr( , , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_fsetxattr);
    eval 'sub __sanitizer_syscall_post_fsetxattr {
        my($res, $fd, $name, $value, $size, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fsetxattr( $res, , , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_fsetxattr);
    eval 'sub __sanitizer_syscall_pre_getxattr {
        my($path, $name, $value, $size) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_getxattr(, , , ($size)));
    }' unless defined(&__sanitizer_syscall_pre_getxattr);
    eval 'sub __sanitizer_syscall_post_getxattr {
        my($res, $path, $name, $value, $size) = @_;
	    eval q( &__sanitizer_syscall_post_impl_getxattr( $res, , , , ($size)));
    }' unless defined(&__sanitizer_syscall_post_getxattr);
    eval 'sub __sanitizer_syscall_pre_lgetxattr {
        my($path, $name, $value, $size) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_lgetxattr(, , , ($size)));
    }' unless defined(&__sanitizer_syscall_pre_lgetxattr);
    eval 'sub __sanitizer_syscall_post_lgetxattr {
        my($res, $path, $name, $value, $size) = @_;
	    eval q( &__sanitizer_syscall_post_impl_lgetxattr( $res, , , , ($size)));
    }' unless defined(&__sanitizer_syscall_post_lgetxattr);
    eval 'sub __sanitizer_syscall_pre_fgetxattr {
        my($fd, $name, $value, $size) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fgetxattr(, , , ($size)));
    }' unless defined(&__sanitizer_syscall_pre_fgetxattr);
    eval 'sub __sanitizer_syscall_post_fgetxattr {
        my($res, $fd, $name, $value, $size) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fgetxattr( $res, , , , ($size)));
    }' unless defined(&__sanitizer_syscall_post_fgetxattr);
    eval 'sub __sanitizer_syscall_pre_listxattr {
        my($path, $list, $size) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_listxattr(, , ($size)));
    }' unless defined(&__sanitizer_syscall_pre_listxattr);
    eval 'sub __sanitizer_syscall_post_listxattr {
        my($res, $path, $list, $size) = @_;
	    eval q( &__sanitizer_syscall_post_impl_listxattr( $res, , , ($size)));
    }' unless defined(&__sanitizer_syscall_post_listxattr);
    eval 'sub __sanitizer_syscall_pre_llistxattr {
        my($path, $list, $size) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_llistxattr( , , ($size)));
    }' unless defined(&__sanitizer_syscall_pre_llistxattr);
    eval 'sub __sanitizer_syscall_post_llistxattr {
        my($res, $path, $list, $size) = @_;
	    eval q( &__sanitizer_syscall_post_impl_llistxattr( $res, , , ($size)));
    }' unless defined(&__sanitizer_syscall_post_llistxattr);
    eval 'sub __sanitizer_syscall_pre_flistxattr {
        my($fd, $list, $size) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_flistxattr(, , ($size)));
    }' unless defined(&__sanitizer_syscall_pre_flistxattr);
    eval 'sub __sanitizer_syscall_post_flistxattr {
        my($res, $fd, $list, $size) = @_;
	    eval q( &__sanitizer_syscall_post_impl_flistxattr( $res, , , ($size)));
    }' unless defined(&__sanitizer_syscall_post_flistxattr);
    eval 'sub __sanitizer_syscall_pre_removexattr {
        my($path, $name) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_removexattr(, ($name)));
    }' unless defined(&__sanitizer_syscall_pre_removexattr);
    eval 'sub __sanitizer_syscall_post_removexattr {
        my($res, $path, $name) = @_;
	    eval q( &__sanitizer_syscall_post_impl_removexattr($res, , ($name)));
    }' unless defined(&__sanitizer_syscall_post_removexattr);
    eval 'sub __sanitizer_syscall_pre_lremovexattr {
        my($path, $name) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_lremovexattr(, ($name)));
    }' unless defined(&__sanitizer_syscall_pre_lremovexattr);
    eval 'sub __sanitizer_syscall_post_lremovexattr {
        my($res, $path, $name) = @_;
	    eval q( &__sanitizer_syscall_post_impl_lremovexattr($res, , ($name)));
    }' unless defined(&__sanitizer_syscall_post_lremovexattr);
    eval 'sub __sanitizer_syscall_pre_fremovexattr {
        my($fd, $name) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fremovexattr(, ($name)));
    }' unless defined(&__sanitizer_syscall_pre_fremovexattr);
    eval 'sub __sanitizer_syscall_post_fremovexattr {
        my($res, $fd, $name) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fremovexattr($res, , ($name)));
    }' unless defined(&__sanitizer_syscall_post_fremovexattr);
    eval 'sub __sanitizer_syscall_pre_compat_50___stat30 {
        my($path, $ub) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50___stat30(, ($ub)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50___stat30);
    eval 'sub __sanitizer_syscall_post_compat_50___stat30 {
        my($res, $path, $ub) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50___stat30($res, , ($ub)));
    }' unless defined(&__sanitizer_syscall_post_compat_50___stat30);
    eval 'sub __sanitizer_syscall_pre_compat_50___fstat30 {
        my($fd, $sb) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50___fstat30(, ($sb)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50___fstat30);
    eval 'sub __sanitizer_syscall_post_compat_50___fstat30 {
        my($res, $fd, $sb) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50___fstat30($res, , ($sb)));
    }' unless defined(&__sanitizer_syscall_post_compat_50___fstat30);
    eval 'sub __sanitizer_syscall_pre_compat_50___lstat30 {
        my($path, $ub) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50___lstat30(, ($ub)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50___lstat30);
    eval 'sub __sanitizer_syscall_post_compat_50___lstat30 {
        my($res, $path, $ub) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50___lstat30($res, , ($ub)));
    }' unless defined(&__sanitizer_syscall_post_compat_50___lstat30);
    eval 'sub __sanitizer_syscall_pre___getdents30 {
        my($fd, $buf, $count) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___getdents30(, , ($count)));
    }' unless defined(&__sanitizer_syscall_pre___getdents30);
    eval 'sub __sanitizer_syscall_post___getdents30 {
        my($res, $fd, $buf, $count) = @_;
	    eval q( &__sanitizer_syscall_post_impl___getdents30( $res, , , ($count)));
    }' unless defined(&__sanitizer_syscall_post___getdents30);
    eval 'sub __sanitizer_syscall_pre_posix_fadvise () {
        eval q( &__sanitizer_syscall_pre_impl_posix_fadvise(()));
    }' unless defined(&__sanitizer_syscall_pre_posix_fadvise);
    eval 'sub __sanitizer_syscall_post_posix_fadvise {
        my($res) = @_;
	    eval q( &__sanitizer_syscall_post_impl_posix_fadvise($res, ()));
    }' unless defined(&__sanitizer_syscall_post_posix_fadvise);
    eval 'sub __sanitizer_syscall_pre_compat_30___fhstat30 {
        my($fhp, $sb) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_30___fhstat30(, ($sb)));
    }' unless defined(&__sanitizer_syscall_pre_compat_30___fhstat30);
    eval 'sub __sanitizer_syscall_post_compat_30___fhstat30 {
        my($res, $fhp, $sb) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_30___fhstat30($res, , ($sb)));
    }' unless defined(&__sanitizer_syscall_post_compat_30___fhstat30);
    eval 'sub __sanitizer_syscall_pre_compat_50___ntp_gettime30 {
        my($ntvp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50___ntp_gettime30(($ntvp)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50___ntp_gettime30);
    eval 'sub __sanitizer_syscall_post_compat_50___ntp_gettime30 {
        my($res, $ntvp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50___ntp_gettime30($res, ($ntvp)));
    }' unless defined(&__sanitizer_syscall_post_compat_50___ntp_gettime30);
    eval 'sub __sanitizer_syscall_pre___socket30 {
        my($domain, $type, $protocol) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___socket30( , , ($protocol)));
    }' unless defined(&__sanitizer_syscall_pre___socket30);
    eval 'sub __sanitizer_syscall_post___socket30 {
        my($res, $domain, $type, $protocol) = @_;
	    eval q( &__sanitizer_syscall_post_impl___socket30( $res, , , ($protocol)));
    }' unless defined(&__sanitizer_syscall_post___socket30);
    eval 'sub __sanitizer_syscall_pre___getfh30 {
        my($fname, $fhp, $fh_size) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___getfh30(, , ($fh_size)));
    }' unless defined(&__sanitizer_syscall_pre___getfh30);
    eval 'sub __sanitizer_syscall_post___getfh30 {
        my($res, $fname, $fhp, $fh_size) = @_;
	    eval q( &__sanitizer_syscall_post_impl___getfh30( $res, , , ($fh_size)));
    }' unless defined(&__sanitizer_syscall_post___getfh30);
    eval 'sub __sanitizer_syscall_pre___fhopen40 {
        my($fhp, $fh_size, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___fhopen40( , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre___fhopen40);
    eval 'sub __sanitizer_syscall_post___fhopen40 {
        my($res, $fhp, $fh_size, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl___fhopen40( $res, , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post___fhopen40);
    eval 'sub __sanitizer_syscall_pre_compat_90_fhstatvfs1 {
        my($fhp, $fh_size, $buf, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_90_fhstatvfs1( , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_compat_90_fhstatvfs1);
    eval 'sub __sanitizer_syscall_post_compat_90_fhstatvfs1 {
        my($res, $fhp, $fh_size, $buf,							$flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_90_fhstatvfs1( $res, , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_compat_90_fhstatvfs1);
    eval 'sub __sanitizer_syscall_pre_compat_50___fhstat40 {
        my($fhp, $fh_size, $sb) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50___fhstat40( , , ($sb)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50___fhstat40);
    eval 'sub __sanitizer_syscall_post_compat_50___fhstat40 {
        my($res, $fhp, $fh_size, $sb) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50___fhstat40( $res, , , ($sb)));
    }' unless defined(&__sanitizer_syscall_post_compat_50___fhstat40);
    eval 'sub __sanitizer_syscall_pre_aio_cancel {
        my($fildes, $aiocbp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_aio_cancel(, ($aiocbp)));
    }' unless defined(&__sanitizer_syscall_pre_aio_cancel);
    eval 'sub __sanitizer_syscall_post_aio_cancel {
        my($res, $fildes, $aiocbp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_aio_cancel($res, , ($aiocbp)));
    }' unless defined(&__sanitizer_syscall_post_aio_cancel);
    eval 'sub __sanitizer_syscall_pre_aio_error {
        my($aiocbp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_aio_error(($aiocbp)));
    }' unless defined(&__sanitizer_syscall_pre_aio_error);
    eval 'sub __sanitizer_syscall_post_aio_error {
        my($res, $aiocbp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_aio_error($res, ($aiocbp)));
    }' unless defined(&__sanitizer_syscall_post_aio_error);
    eval 'sub __sanitizer_syscall_pre_aio_fsync {
        my($op, $aiocbp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_aio_fsync(, ($aiocbp)));
    }' unless defined(&__sanitizer_syscall_pre_aio_fsync);
    eval 'sub __sanitizer_syscall_post_aio_fsync {
        my($res, $op, $aiocbp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_aio_fsync($res, , ($aiocbp)));
    }' unless defined(&__sanitizer_syscall_post_aio_fsync);
    eval 'sub __sanitizer_syscall_pre_aio_read {
        my($aiocbp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_aio_read(($aiocbp)));
    }' unless defined(&__sanitizer_syscall_pre_aio_read);
    eval 'sub __sanitizer_syscall_post_aio_read {
        my($res, $aiocbp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_aio_read($res, ($aiocbp)));
    }' unless defined(&__sanitizer_syscall_post_aio_read);
    eval 'sub __sanitizer_syscall_pre_aio_return {
        my($aiocbp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_aio_return(($aiocbp)));
    }' unless defined(&__sanitizer_syscall_pre_aio_return);
    eval 'sub __sanitizer_syscall_post_aio_return {
        my($res, $aiocbp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_aio_return($res, ($aiocbp)));
    }' unless defined(&__sanitizer_syscall_post_aio_return);
    eval 'sub __sanitizer_syscall_pre_compat_50_aio_suspend {
        my($list, $nent, $timeout) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_50_aio_suspend( , , ($timeout)));
    }' unless defined(&__sanitizer_syscall_pre_compat_50_aio_suspend);
    eval 'sub __sanitizer_syscall_post_compat_50_aio_suspend {
        my($res, $list, $nent,							       $timeout) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_50_aio_suspend( $res, , , ($timeout)));
    }' unless defined(&__sanitizer_syscall_post_compat_50_aio_suspend);
    eval 'sub __sanitizer_syscall_pre_aio_write {
        my($aiocbp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_aio_write(($aiocbp)));
    }' unless defined(&__sanitizer_syscall_pre_aio_write);
    eval 'sub __sanitizer_syscall_post_aio_write {
        my($res, $aiocbp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_aio_write($res, ($aiocbp)));
    }' unless defined(&__sanitizer_syscall_post_aio_write);
    eval 'sub __sanitizer_syscall_pre_lio_listio {
        my($mode, $list, $nent, $sig) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_lio_listio(, , , ($sig)));
    }' unless defined(&__sanitizer_syscall_pre_lio_listio);
    eval 'sub __sanitizer_syscall_post_lio_listio {
        my($res, $mode, $list, $nent, $sig) = @_;
	    eval q( &__sanitizer_syscall_post_impl_lio_listio( $res, , , , ($sig)));
    }' unless defined(&__sanitizer_syscall_post_lio_listio);
    eval 'sub __sanitizer_syscall_pre___mount50 {
        my($type, $path, $flags, $data, $data_len) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___mount50( , , , , ($data_len)));
    }' unless defined(&__sanitizer_syscall_pre___mount50);
    eval 'sub __sanitizer_syscall_post___mount50 {
        my($res, $type, $path, $flags, $data,						  $data_len) = @_;
	    eval q( &__sanitizer_syscall_post_impl___mount50( $res, , , , , ($data_len)));
    }' unless defined(&__sanitizer_syscall_post___mount50);
    eval 'sub __sanitizer_syscall_pre_mremap {
        my($old_address, $old_size, $new_address,					    $new_size, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mremap( , , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_mremap);
    eval 'sub __sanitizer_syscall_post_mremap {
        my($res, $old_address, $old_size,						    $new_address, $new_size, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mremap( $res, , , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_mremap);
    eval 'sub __sanitizer_syscall_pre_pset_create {
        my($psid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_pset_create(($psid)));
    }' unless defined(&__sanitizer_syscall_pre_pset_create);
    eval 'sub __sanitizer_syscall_post_pset_create {
        my($res, $psid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_pset_create($res, ($psid)));
    }' unless defined(&__sanitizer_syscall_post_pset_create);
    eval 'sub __sanitizer_syscall_pre_pset_destroy {
        my($psid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_pset_destroy(($psid)));
    }' unless defined(&__sanitizer_syscall_pre_pset_destroy);
    eval 'sub __sanitizer_syscall_post_pset_destroy {
        my($res, $psid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_pset_destroy($res, ($psid)));
    }' unless defined(&__sanitizer_syscall_post_pset_destroy);
    eval 'sub __sanitizer_syscall_pre_pset_assign {
        my($psid, $cpuid, $opsid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_pset_assign( , , ($opsid)));
    }' unless defined(&__sanitizer_syscall_pre_pset_assign);
    eval 'sub __sanitizer_syscall_post_pset_assign {
        my($res, $psid, $cpuid, $opsid) = @_;
	    eval q( &__sanitizer_syscall_post_impl_pset_assign( $res, , , ($opsid)));
    }' unless defined(&__sanitizer_syscall_post_pset_assign);
    eval 'sub __sanitizer_syscall_pre__pset_bind {
        my($idtype, $first_id, $second_id, $psid,					     $opsid) = @_;
	    eval q( &__sanitizer_syscall_pre_impl__pset_bind( , , , , ($opsid)));
    }' unless defined(&__sanitizer_syscall_pre__pset_bind);
    eval 'sub __sanitizer_syscall_post__pset_bind {
        my($res, $idtype, $first_id, $second_id,					      $psid, $opsid) = @_;
	    eval q( &__sanitizer_syscall_post_impl__pset_bind( $res, , , , , ($opsid)));
    }' unless defined(&__sanitizer_syscall_post__pset_bind);
    eval 'sub __sanitizer_syscall_pre___posix_fadvise50 {
        my($fd, $PAD, $offset, $len,							  $advice) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___posix_fadvise50( , , , , ($advice)));
    }' unless defined(&__sanitizer_syscall_pre___posix_fadvise50);
    eval 'sub __sanitizer_syscall_post___posix_fadvise50 {
        my($res, $fd, $PAD, $offset, $len,						     $advice) = @_;
	    eval q( &__sanitizer_syscall_post_impl___posix_fadvise50( $res, , , , , ($advice)));
    }' unless defined(&__sanitizer_syscall_post___posix_fadvise50);
    eval 'sub __sanitizer_syscall_pre___select50 {
        my($nd, $in, $ou, $ex, $tv) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___select50(, , , , ($tv)));
    }' unless defined(&__sanitizer_syscall_pre___select50);
    eval 'sub __sanitizer_syscall_post___select50 {
        my($res, $nd, $in, $ou, $ex, $tv) = @_;
	    eval q( &__sanitizer_syscall_post_impl___select50($res, , , , , ($tv)));
    }' unless defined(&__sanitizer_syscall_post___select50);
    eval 'sub __sanitizer_syscall_pre___gettimeofday50 {
        my($tp, $tzp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___gettimeofday50(, ($tzp)));
    }' unless defined(&__sanitizer_syscall_pre___gettimeofday50);
    eval 'sub __sanitizer_syscall_post___gettimeofday50 {
        my($res, $tp, $tzp) = @_;
	    eval q( &__sanitizer_syscall_post_impl___gettimeofday50($res, , ($tzp)));
    }' unless defined(&__sanitizer_syscall_post___gettimeofday50);
    eval 'sub __sanitizer_syscall_pre___settimeofday50 {
        my($tv, $tzp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___settimeofday50(, ($tzp)));
    }' unless defined(&__sanitizer_syscall_pre___settimeofday50);
    eval 'sub __sanitizer_syscall_post___settimeofday50 {
        my($res, $tv, $tzp) = @_;
	    eval q( &__sanitizer_syscall_post_impl___settimeofday50($res, , ($tzp)));
    }' unless defined(&__sanitizer_syscall_post___settimeofday50);
    eval 'sub __sanitizer_syscall_pre___utimes50 {
        my($path, $tptr) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___utimes50(, ($tptr)));
    }' unless defined(&__sanitizer_syscall_pre___utimes50);
    eval 'sub __sanitizer_syscall_post___utimes50 {
        my($res, $path, $tptr) = @_;
	    eval q( &__sanitizer_syscall_post_impl___utimes50($res, , ($tptr)));
    }' unless defined(&__sanitizer_syscall_post___utimes50);
    eval 'sub __sanitizer_syscall_pre___adjtime50 {
        my($delta, $olddelta) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___adjtime50(, ($olddelta)));
    }' unless defined(&__sanitizer_syscall_pre___adjtime50);
    eval 'sub __sanitizer_syscall_post___adjtime50 {
        my($res, $delta, $olddelta) = @_;
	    eval q( &__sanitizer_syscall_post_impl___adjtime50($res, , ($olddelta)));
    }' unless defined(&__sanitizer_syscall_post___adjtime50);
    eval 'sub __sanitizer_syscall_pre___lfs_segwait50 {
        my($fsidp, $tv) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___lfs_segwait50(, ($tv)));
    }' unless defined(&__sanitizer_syscall_pre___lfs_segwait50);
    eval 'sub __sanitizer_syscall_post___lfs_segwait50 {
        my($res, $fsidp, $tv) = @_;
	    eval q( &__sanitizer_syscall_post_impl___lfs_segwait50($res, , ($tv)));
    }' unless defined(&__sanitizer_syscall_post___lfs_segwait50);
    eval 'sub __sanitizer_syscall_pre___futimes50 {
        my($fd, $tptr) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___futimes50(, ($tptr)));
    }' unless defined(&__sanitizer_syscall_pre___futimes50);
    eval 'sub __sanitizer_syscall_post___futimes50 {
        my($res, $fd, $tptr) = @_;
	    eval q( &__sanitizer_syscall_post_impl___futimes50($res, , ($tptr)));
    }' unless defined(&__sanitizer_syscall_post___futimes50);
    eval 'sub __sanitizer_syscall_pre___lutimes50 {
        my($path, $tptr) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___lutimes50(, ($tptr)));
    }' unless defined(&__sanitizer_syscall_pre___lutimes50);
    eval 'sub __sanitizer_syscall_post___lutimes50 {
        my($res, $path, $tptr) = @_;
	    eval q( &__sanitizer_syscall_post_impl___lutimes50($res, , ($tptr)));
    }' unless defined(&__sanitizer_syscall_post___lutimes50);
    eval 'sub __sanitizer_syscall_pre___setitimer50 {
        my($which, $itv, $oitv) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___setitimer50( , , ($oitv)));
    }' unless defined(&__sanitizer_syscall_pre___setitimer50);
    eval 'sub __sanitizer_syscall_post___setitimer50 {
        my($res, $which, $itv, $oitv) = @_;
	    eval q( &__sanitizer_syscall_post_impl___setitimer50( $res, , , ($oitv)));
    }' unless defined(&__sanitizer_syscall_post___setitimer50);
    eval 'sub __sanitizer_syscall_pre___getitimer50 {
        my($which, $itv) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___getitimer50(, ($itv)));
    }' unless defined(&__sanitizer_syscall_pre___getitimer50);
    eval 'sub __sanitizer_syscall_post___getitimer50 {
        my($res, $which, $itv) = @_;
	    eval q( &__sanitizer_syscall_post_impl___getitimer50($res, , ($itv)));
    }' unless defined(&__sanitizer_syscall_post___getitimer50);
    eval 'sub __sanitizer_syscall_pre___clock_gettime50 {
        my($clock_id, $tp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___clock_gettime50(, ($tp)));
    }' unless defined(&__sanitizer_syscall_pre___clock_gettime50);
    eval 'sub __sanitizer_syscall_post___clock_gettime50 {
        my($res, $clock_id, $tp) = @_;
	    eval q( &__sanitizer_syscall_post_impl___clock_gettime50($res, , ($tp)));
    }' unless defined(&__sanitizer_syscall_post___clock_gettime50);
    eval 'sub __sanitizer_syscall_pre___clock_settime50 {
        my($clock_id, $tp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___clock_settime50(, ($tp)));
    }' unless defined(&__sanitizer_syscall_pre___clock_settime50);
    eval 'sub __sanitizer_syscall_post___clock_settime50 {
        my($res, $clock_id, $tp) = @_;
	    eval q( &__sanitizer_syscall_post_impl___clock_settime50($res, , ($tp)));
    }' unless defined(&__sanitizer_syscall_post___clock_settime50);
    eval 'sub __sanitizer_syscall_pre___clock_getres50 {
        my($clock_id, $tp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___clock_getres50(, ($tp)));
    }' unless defined(&__sanitizer_syscall_pre___clock_getres50);
    eval 'sub __sanitizer_syscall_post___clock_getres50 {
        my($res, $clock_id, $tp) = @_;
	    eval q( &__sanitizer_syscall_post_impl___clock_getres50($res, , ($tp)));
    }' unless defined(&__sanitizer_syscall_post___clock_getres50);
    eval 'sub __sanitizer_syscall_pre___nanosleep50 {
        my($rqtp, $rmtp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___nanosleep50(, ($rmtp)));
    }' unless defined(&__sanitizer_syscall_pre___nanosleep50);
    eval 'sub __sanitizer_syscall_post___nanosleep50 {
        my($res, $rqtp, $rmtp) = @_;
	    eval q( &__sanitizer_syscall_post_impl___nanosleep50($res, , ($rmtp)));
    }' unless defined(&__sanitizer_syscall_post___nanosleep50);
    eval 'sub __sanitizer_syscall_pre_____sigtimedwait50 {
        my($set, $info, $timeout) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_____sigtimedwait50( , , ($timeout)));
    }' unless defined(&__sanitizer_syscall_pre_____sigtimedwait50);
    eval 'sub __sanitizer_syscall_post_____sigtimedwait50 {
        my($res, $set, $info, $timeout) = @_;
	    eval q( &__sanitizer_syscall_post_impl_____sigtimedwait50( $res, , , ($timeout)));
    }' unless defined(&__sanitizer_syscall_post_____sigtimedwait50);
    eval 'sub __sanitizer_syscall_pre___mq_timedsend50 {
        my($mqdes, $msg_ptr, $msg_len,						       $msg_prio, $abs_timeout) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___mq_timedsend50( , , , , ($abs_timeout)));
    }' unless defined(&__sanitizer_syscall_pre___mq_timedsend50);
    eval 'sub __sanitizer_syscall_post___mq_timedsend50 {
        my(				 $res, $mqdes, $msg_ptr, $msg_len, $msg_prio, $abs_timeout) = @_;
	    eval q( &__sanitizer_syscall_post_impl___mq_timedsend50( $res, , , , , ($abs_timeout)));
    }' unless defined(&__sanitizer_syscall_post___mq_timedsend50);
    eval 'sub __sanitizer_syscall_pre___mq_timedreceive50 {
        my($mqdes, $msg_ptr, $msg_len,						       $msg_prio, $abs_timeout) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___mq_timedreceive50( , , , , ($abs_timeout)));
    }' unless defined(&__sanitizer_syscall_pre___mq_timedreceive50);
    eval 'sub __sanitizer_syscall_post___mq_timedreceive50 {
        my(			      $res, $mqdes, $msg_ptr, $msg_len, $msg_prio, $abs_timeout) = @_;
	    eval q( &__sanitizer_syscall_post_impl___mq_timedreceive50( $res, , , , , ($abs_timeout)));
    }' unless defined(&__sanitizer_syscall_post___mq_timedreceive50);
    eval 'sub __sanitizer_syscall_pre_compat_60__lwp_park {
        my($ts, $unpark, $hint,							      $unparkhint) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_compat_60__lwp_park( , , , ($unparkhint)));
    }' unless defined(&__sanitizer_syscall_pre_compat_60__lwp_park);
    eval 'sub __sanitizer_syscall_post_compat_60__lwp_park {
        my($res, $ts, $unpark, $hint,							 $unparkhint) = @_;
	    eval q( &__sanitizer_syscall_post_impl_compat_60__lwp_park( $res, , , , ($unparkhint)));
    }' unless defined(&__sanitizer_syscall_post_compat_60__lwp_park);
    eval 'sub __sanitizer_syscall_pre___kevent50 {
        my($fd, $changelist, $nchanges,						      $eventlist, $nevents, $timeout) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___kevent50( , , , , , ($timeout)));
    }' unless defined(&__sanitizer_syscall_pre___kevent50);
    eval 'sub __sanitizer_syscall_post___kevent50 {
        my($res, $fd, $changelist, $nchanges,						 $eventlist, $nevents, $timeout) = @_;
	    eval q( &__sanitizer_syscall_post_impl___kevent50( $res, , , , , , ($timeout)));
    }' unless defined(&__sanitizer_syscall_post___kevent50);
    eval 'sub __sanitizer_syscall_pre___pselect50 {
        my($nd, $in, $ou, $ex, $ts, $mask) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___pselect50(, , , , , ($mask)));
    }' unless defined(&__sanitizer_syscall_pre___pselect50);
    eval 'sub __sanitizer_syscall_post___pselect50 {
        my($res, $nd, $in, $ou, $ex, $ts, $mask) = @_;
	    eval q( &__sanitizer_syscall_post_impl___pselect50( $res, , , , , , ($mask)));
    }' unless defined(&__sanitizer_syscall_post___pselect50);
    eval 'sub __sanitizer_syscall_pre___pollts50 {
        my($fds, $nfds, $ts, $mask) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___pollts50(, , , ($mask)));
    }' unless defined(&__sanitizer_syscall_pre___pollts50);
    eval 'sub __sanitizer_syscall_post___pollts50 {
        my($res, $fds, $nfds, $ts, $mask) = @_;
	    eval q( &__sanitizer_syscall_post_impl___pollts50($res, , , , ($mask)));
    }' unless defined(&__sanitizer_syscall_post___pollts50);
    eval 'sub __sanitizer_syscall_pre___aio_suspend50 {
        my($list, $nent, $timeout) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___aio_suspend50( , , ($timeout)));
    }' unless defined(&__sanitizer_syscall_pre___aio_suspend50);
    eval 'sub __sanitizer_syscall_post___aio_suspend50 {
        my($res, $list, $nent, $timeout) = @_;
	    eval q( &__sanitizer_syscall_post_impl___aio_suspend50( $res, , , ($timeout)));
    }' unless defined(&__sanitizer_syscall_post___aio_suspend50);
    eval 'sub __sanitizer_syscall_pre___stat50 {
        my($path, $ub) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___stat50(, ($ub)));
    }' unless defined(&__sanitizer_syscall_pre___stat50);
    eval 'sub __sanitizer_syscall_post___stat50 {
        my($res, $path, $ub) = @_;
	    eval q( &__sanitizer_syscall_post_impl___stat50($res, , ($ub)));
    }' unless defined(&__sanitizer_syscall_post___stat50);
    eval 'sub __sanitizer_syscall_pre___fstat50 {
        my($fd, $sb) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___fstat50(, ($sb)));
    }' unless defined(&__sanitizer_syscall_pre___fstat50);
    eval 'sub __sanitizer_syscall_post___fstat50 {
        my($res, $fd, $sb) = @_;
	    eval q( &__sanitizer_syscall_post_impl___fstat50($res, , ($sb)));
    }' unless defined(&__sanitizer_syscall_post___fstat50);
    eval 'sub __sanitizer_syscall_pre___lstat50 {
        my($path, $ub) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___lstat50(, ($ub)));
    }' unless defined(&__sanitizer_syscall_pre___lstat50);
    eval 'sub __sanitizer_syscall_post___lstat50 {
        my($res, $path, $ub) = @_;
	    eval q( &__sanitizer_syscall_post_impl___lstat50($res, , ($ub)));
    }' unless defined(&__sanitizer_syscall_post___lstat50);
    eval 'sub __sanitizer_syscall_pre_____semctl50 {
        my($semid, $semnum, $cmd, $arg) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_____semctl50( , , , ($arg)));
    }' unless defined(&__sanitizer_syscall_pre_____semctl50);
    eval 'sub __sanitizer_syscall_post_____semctl50 {
        my($res, $semid, $semnum, $cmd, $arg) = @_;
	    eval q( &__sanitizer_syscall_post_impl_____semctl50( $res, , , , ($arg)));
    }' unless defined(&__sanitizer_syscall_post_____semctl50);
    eval 'sub __sanitizer_syscall_pre___shmctl50 {
        my($shmid, $cmd, $buf) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___shmctl50(, , ($buf)));
    }' unless defined(&__sanitizer_syscall_pre___shmctl50);
    eval 'sub __sanitizer_syscall_post___shmctl50 {
        my($res, $shmid, $cmd, $buf) = @_;
	    eval q( &__sanitizer_syscall_post_impl___shmctl50($res, , , ($buf)));
    }' unless defined(&__sanitizer_syscall_post___shmctl50);
    eval 'sub __sanitizer_syscall_pre___msgctl50 {
        my($msqid, $cmd, $buf) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___msgctl50(, , ($buf)));
    }' unless defined(&__sanitizer_syscall_pre___msgctl50);
    eval 'sub __sanitizer_syscall_post___msgctl50 {
        my($res, $msqid, $cmd, $buf) = @_;
	    eval q( &__sanitizer_syscall_post_impl___msgctl50($res, , , ($buf)));
    }' unless defined(&__sanitizer_syscall_post___msgctl50);
    eval 'sub __sanitizer_syscall_pre___getrusage50 {
        my($who, $rusage) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___getrusage50(, ($rusage)));
    }' unless defined(&__sanitizer_syscall_pre___getrusage50);
    eval 'sub __sanitizer_syscall_post___getrusage50 {
        my($res, $who, $rusage) = @_;
	    eval q( &__sanitizer_syscall_post_impl___getrusage50($res, , ($rusage)));
    }' unless defined(&__sanitizer_syscall_post___getrusage50);
    eval 'sub __sanitizer_syscall_pre___timer_settime50 {
        my($timerid, $flags, $value,							 $ovalue) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___timer_settime50( , , , ($ovalue)));
    }' unless defined(&__sanitizer_syscall_pre___timer_settime50);
    eval 'sub __sanitizer_syscall_post___timer_settime50 {
        my($res, $timerid, $flags, $value,						    $ovalue) = @_;
	    eval q( &__sanitizer_syscall_post_impl___timer_settime50( $res, , , , ($ovalue)));
    }' unless defined(&__sanitizer_syscall_post___timer_settime50);
    eval 'sub __sanitizer_syscall_pre___timer_gettime50 {
        my($timerid, $value) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___timer_gettime50(, ($value)));
    }' unless defined(&__sanitizer_syscall_pre___timer_gettime50);
    eval 'sub __sanitizer_syscall_post___timer_gettime50 {
        my($res, $timerid, $value) = @_;
	    eval q( &__sanitizer_syscall_post_impl___timer_gettime50($res, , ($value)));
    }' unless defined(&__sanitizer_syscall_post___timer_gettime50);
    if(defined(&NTP) || !defined(&_KERNEL_OPT)) {
	eval 'sub __sanitizer_syscall_pre___ntp_gettime50 {
	    my($ntvp) = @_;
    	    eval q( &__sanitizer_syscall_pre_impl___ntp_gettime50(($ntvp)));
	}' unless defined(&__sanitizer_syscall_pre___ntp_gettime50);
	eval 'sub __sanitizer_syscall_post___ntp_gettime50 {
	    my($res, $ntvp) = @_;
    	    eval q( &__sanitizer_syscall_post_impl___ntp_gettime50($res, ($ntvp)));
	}' unless defined(&__sanitizer_syscall_post___ntp_gettime50);
    } else {
    }
    eval 'sub __sanitizer_syscall_pre___wait450 {
        my($pid, $status, $options, $rusage) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___wait450( , , , ($rusage)));
    }' unless defined(&__sanitizer_syscall_pre___wait450);
    eval 'sub __sanitizer_syscall_post___wait450 {
        my($res, $pid, $status, $options, $rusage) = @_;
	    eval q( &__sanitizer_syscall_post_impl___wait450( $res, , , , ($rusage)));
    }' unless defined(&__sanitizer_syscall_post___wait450);
    eval 'sub __sanitizer_syscall_pre___mknod50 {
        my($path, $mode, $dev) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___mknod50(, , ($dev)));
    }' unless defined(&__sanitizer_syscall_pre___mknod50);
    eval 'sub __sanitizer_syscall_post___mknod50 {
        my($res, $path, $mode, $dev) = @_;
	    eval q( &__sanitizer_syscall_post_impl___mknod50($res, , , ($dev)));
    }' unless defined(&__sanitizer_syscall_post___mknod50);
    eval 'sub __sanitizer_syscall_pre___fhstat50 {
        my($fhp, $fh_size, $sb) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___fhstat50( , , ($sb)));
    }' unless defined(&__sanitizer_syscall_pre___fhstat50);
    eval 'sub __sanitizer_syscall_post___fhstat50 {
        my($res, $fhp, $fh_size, $sb) = @_;
	    eval q( &__sanitizer_syscall_post_impl___fhstat50( $res, , , ($sb)));
    }' unless defined(&__sanitizer_syscall_post___fhstat50);
    eval 'sub __sanitizer_syscall_pre_pipe2 {
        my($fildes, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_pipe2(, ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_pipe2);
    eval 'sub __sanitizer_syscall_post_pipe2 {
        my($res, $fildes, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_pipe2($res, , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_pipe2);
    eval 'sub __sanitizer_syscall_pre_dup3 {
        my($from, $to, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_dup3(, , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_dup3);
    eval 'sub __sanitizer_syscall_post_dup3 {
        my($res, $from, $to, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_dup3($res, , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_dup3);
    eval 'sub __sanitizer_syscall_pre_kqueue1 {
        my($flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_kqueue1(($flags)));
    }' unless defined(&__sanitizer_syscall_pre_kqueue1);
    eval 'sub __sanitizer_syscall_post_kqueue1 {
        my($res, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_kqueue1($res, ($flags)));
    }' unless defined(&__sanitizer_syscall_post_kqueue1);
    eval 'sub __sanitizer_syscall_pre_paccept {
        my($s, $name, $anamelen, $mask, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_paccept(, , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_paccept);
    eval 'sub __sanitizer_syscall_post_paccept {
        my($res, $s, $name, $anamelen, $mask, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_paccept( $res, , , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_paccept);
    eval 'sub __sanitizer_syscall_pre_linkat {
        my($fd1, $name1, $fd2, $name2, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_linkat(, , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_linkat);
    eval 'sub __sanitizer_syscall_post_linkat {
        my($res, $fd1, $name1, $fd2, $name2, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_linkat($res, , , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_linkat);
    eval 'sub __sanitizer_syscall_pre_renameat {
        my($fromfd, $from, $tofd, $to) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_renameat(, , , ($to)));
    }' unless defined(&__sanitizer_syscall_pre_renameat);
    eval 'sub __sanitizer_syscall_post_renameat {
        my($res, $fromfd, $from, $tofd, $to) = @_;
	    eval q( &__sanitizer_syscall_post_impl_renameat($res, , , , ($to)));
    }' unless defined(&__sanitizer_syscall_post_renameat);
    eval 'sub __sanitizer_syscall_pre_mkfifoat {
        my($fd, $path, $mode) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mkfifoat(, , ($mode)));
    }' unless defined(&__sanitizer_syscall_pre_mkfifoat);
    eval 'sub __sanitizer_syscall_post_mkfifoat {
        my($res, $fd, $path, $mode) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mkfifoat($res, , , ($mode)));
    }' unless defined(&__sanitizer_syscall_post_mkfifoat);
    eval 'sub __sanitizer_syscall_pre_mknodat {
        my($fd, $path, $mode, $PAD, $dev) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mknodat(, , , , ($dev)));
    }' unless defined(&__sanitizer_syscall_pre_mknodat);
    eval 'sub __sanitizer_syscall_post_mknodat {
        my($res, $fd, $path, $mode, $PAD, $dev) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mknodat($res, , , , , ($dev)));
    }' unless defined(&__sanitizer_syscall_post_mknodat);
    eval 'sub __sanitizer_syscall_pre_mkdirat {
        my($fd, $path, $mode) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_mkdirat(, , ($mode)));
    }' unless defined(&__sanitizer_syscall_pre_mkdirat);
    eval 'sub __sanitizer_syscall_post_mkdirat {
        my($res, $fd, $path, $mode) = @_;
	    eval q( &__sanitizer_syscall_post_impl_mkdirat($res, , , ($mode)));
    }' unless defined(&__sanitizer_syscall_post_mkdirat);
    eval 'sub __sanitizer_syscall_pre_faccessat {
        my($fd, $path, $amode, $flag) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_faccessat(, , , ($flag)));
    }' unless defined(&__sanitizer_syscall_pre_faccessat);
    eval 'sub __sanitizer_syscall_post_faccessat {
        my($res, $fd, $path, $amode, $flag) = @_;
	    eval q( &__sanitizer_syscall_post_impl_faccessat( $res, , , , ($flag)));
    }' unless defined(&__sanitizer_syscall_post_faccessat);
    eval 'sub __sanitizer_syscall_pre_fchmodat {
        my($fd, $path, $mode, $flag) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fchmodat(, , , ($flag)));
    }' unless defined(&__sanitizer_syscall_pre_fchmodat);
    eval 'sub __sanitizer_syscall_post_fchmodat {
        my($res, $fd, $path, $mode, $flag) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fchmodat($res, , , , ($flag)));
    }' unless defined(&__sanitizer_syscall_post_fchmodat);
    eval 'sub __sanitizer_syscall_pre_fchownat {
        my($fd, $path, $owner, $group, $flag) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fchownat(, , , , ($flag)));
    }' unless defined(&__sanitizer_syscall_pre_fchownat);
    eval 'sub __sanitizer_syscall_post_fchownat {
        my($res, $fd, $path, $owner, $group, $flag) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fchownat( $res, , , , , ($flag)));
    }' unless defined(&__sanitizer_syscall_post_fchownat);
    eval 'sub __sanitizer_syscall_pre_fexecve {
        my($fd, $argp, $envp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fexecve(, , ($envp)));
    }' unless defined(&__sanitizer_syscall_pre_fexecve);
    eval 'sub __sanitizer_syscall_post_fexecve {
        my($res, $fd, $argp, $envp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fexecve($res, , , ($envp)));
    }' unless defined(&__sanitizer_syscall_post_fexecve);
    eval 'sub __sanitizer_syscall_pre_fstatat {
        my($fd, $path, $buf, $flag) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fstatat(, , , ($flag)));
    }' unless defined(&__sanitizer_syscall_pre_fstatat);
    eval 'sub __sanitizer_syscall_post_fstatat {
        my($res, $fd, $path, $buf, $flag) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fstatat($res, , , , ($flag)));
    }' unless defined(&__sanitizer_syscall_post_fstatat);
    eval 'sub __sanitizer_syscall_pre_utimensat {
        my($fd, $path, $tptr, $flag) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_utimensat(, , , ($flag)));
    }' unless defined(&__sanitizer_syscall_pre_utimensat);
    eval 'sub __sanitizer_syscall_post_utimensat {
        my($res, $fd, $path, $tptr, $flag) = @_;
	    eval q( &__sanitizer_syscall_post_impl_utimensat( $res, , , , ($flag)));
    }' unless defined(&__sanitizer_syscall_post_utimensat);
    eval 'sub __sanitizer_syscall_pre_openat {
        my($fd, $path, $oflags, $mode) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_openat(, , , ($mode)));
    }' unless defined(&__sanitizer_syscall_pre_openat);
    eval 'sub __sanitizer_syscall_post_openat {
        my($res, $fd, $path, $oflags, $mode) = @_;
	    eval q( &__sanitizer_syscall_post_impl_openat($res, , , , ($mode)));
    }' unless defined(&__sanitizer_syscall_post_openat);
    eval 'sub __sanitizer_syscall_pre_readlinkat {
        my($fd, $path, $buf, $bufsize) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_readlinkat(, , , ($bufsize)));
    }' unless defined(&__sanitizer_syscall_pre_readlinkat);
    eval 'sub __sanitizer_syscall_post_readlinkat {
        my($res, $fd, $path, $buf, $bufsize) = @_;
	    eval q( &__sanitizer_syscall_post_impl_readlinkat( $res, , , , ($bufsize)));
    }' unless defined(&__sanitizer_syscall_post_readlinkat);
    eval 'sub __sanitizer_syscall_pre_symlinkat {
        my($path1, $fd, $path2) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_symlinkat(, , ($path2)));
    }' unless defined(&__sanitizer_syscall_pre_symlinkat);
    eval 'sub __sanitizer_syscall_post_symlinkat {
        my($res, $path1, $fd, $path2) = @_;
	    eval q( &__sanitizer_syscall_post_impl_symlinkat($res, , , ($path2)));
    }' unless defined(&__sanitizer_syscall_post_symlinkat);
    eval 'sub __sanitizer_syscall_pre_unlinkat {
        my($fd, $path, $flag) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_unlinkat(, , ($flag)));
    }' unless defined(&__sanitizer_syscall_pre_unlinkat);
    eval 'sub __sanitizer_syscall_post_unlinkat {
        my($res, $fd, $path, $flag) = @_;
	    eval q( &__sanitizer_syscall_post_impl_unlinkat($res, , , ($flag)));
    }' unless defined(&__sanitizer_syscall_post_unlinkat);
    eval 'sub __sanitizer_syscall_pre_futimens {
        my($fd, $tptr) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_futimens(, ($tptr)));
    }' unless defined(&__sanitizer_syscall_pre_futimens);
    eval 'sub __sanitizer_syscall_post_futimens {
        my($res, $fd, $tptr) = @_;
	    eval q( &__sanitizer_syscall_post_impl_futimens($res, , ($tptr)));
    }' unless defined(&__sanitizer_syscall_post_futimens);
    eval 'sub __sanitizer_syscall_pre___quotactl {
        my($path, $args) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___quotactl(, ($args)));
    }' unless defined(&__sanitizer_syscall_pre___quotactl);
    eval 'sub __sanitizer_syscall_post___quotactl {
        my($res, $path, $args) = @_;
	    eval q( &__sanitizer_syscall_post_impl___quotactl($res, , ($args)));
    }' unless defined(&__sanitizer_syscall_post___quotactl);
    eval 'sub __sanitizer_syscall_pre_posix_spawn {
        my($pid, $path, $file_actions, $attrp,						$argv, $envp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_posix_spawn( , , , , , ($envp)));
    }' unless defined(&__sanitizer_syscall_pre_posix_spawn);
    eval 'sub __sanitizer_syscall_post_posix_spawn {
        my($res, $pid, $path, $file_actions,						  $attrp, $argv, $envp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_posix_spawn( $res, , , , , , ($envp)));
    }' unless defined(&__sanitizer_syscall_post_posix_spawn);
    eval 'sub __sanitizer_syscall_pre_recvmmsg {
        my($s, $mmsg, $vlen, $flags, $timeout) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_recvmmsg(, , , , ($timeout)));
    }' unless defined(&__sanitizer_syscall_pre_recvmmsg);
    eval 'sub __sanitizer_syscall_post_recvmmsg {
        my($res, $s, $mmsg, $vlen, $flags, $timeout) = @_;
	    eval q( &__sanitizer_syscall_post_impl_recvmmsg( $res, , , , , ($timeout)));
    }' unless defined(&__sanitizer_syscall_post_recvmmsg);
    eval 'sub __sanitizer_syscall_pre_sendmmsg {
        my($s, $mmsg, $vlen, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_sendmmsg(, , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre_sendmmsg);
    eval 'sub __sanitizer_syscall_post_sendmmsg {
        my($res, $s, $mmsg, $vlen, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl_sendmmsg($res, , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post_sendmmsg);
    eval 'sub __sanitizer_syscall_pre_clock_nanosleep {
        my($clock_id, $flags, $rqtp, $rmtp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_clock_nanosleep( , , , ($rmtp)));
    }' unless defined(&__sanitizer_syscall_pre_clock_nanosleep);
    eval 'sub __sanitizer_syscall_post_clock_nanosleep {
        my($res, $clock_id, $flags, $rqtp,						    $rmtp) = @_;
	    eval q( &__sanitizer_syscall_post_impl_clock_nanosleep( $res, , , , ($rmtp)));
    }' unless defined(&__sanitizer_syscall_post_clock_nanosleep);
    eval 'sub __sanitizer_syscall_pre____lwp_park60 {
        my($clock_id, $flags, $ts, $unpark,						   $hint, $unparkhint) = @_;
	    eval q( &__sanitizer_syscall_pre_impl____lwp_park60( , , , , , ($unparkhint)));
    }' unless defined(&__sanitizer_syscall_pre____lwp_park60);
    eval 'sub __sanitizer_syscall_post____lwp_park60 {
        my($res, $clock_id, $flags, $ts,						      $unpark, $hint, $unparkhint) = @_;
	    eval q( &__sanitizer_syscall_post_impl____lwp_park60( $res, , , , , , ($unparkhint)));
    }' unless defined(&__sanitizer_syscall_post____lwp_park60);
    eval 'sub __sanitizer_syscall_pre_posix_fallocate {
        my($fd, $PAD, $pos, $len) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_posix_fallocate( , , , ($len)));
    }' unless defined(&__sanitizer_syscall_pre_posix_fallocate);
    eval 'sub __sanitizer_syscall_post_posix_fallocate {
        my($res, $fd, $PAD, $pos, $len) = @_;
	    eval q( &__sanitizer_syscall_post_impl_posix_fallocate( $res, , , , ($len)));
    }' unless defined(&__sanitizer_syscall_post_posix_fallocate);
    eval 'sub __sanitizer_syscall_pre_fdiscard {
        my($fd, $PAD, $pos, $len) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_fdiscard(, , , ($len)));
    }' unless defined(&__sanitizer_syscall_pre_fdiscard);
    eval 'sub __sanitizer_syscall_post_fdiscard {
        my($res, $fd, $PAD, $pos, $len) = @_;
	    eval q( &__sanitizer_syscall_post_impl_fdiscard($res, , , , ($len)));
    }' unless defined(&__sanitizer_syscall_post_fdiscard);
    eval 'sub __sanitizer_syscall_pre_wait6 {
        my($idtype, $id, $status, $options, $wru, $info) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_wait6( , , , , , ($info)));
    }' unless defined(&__sanitizer_syscall_pre_wait6);
    eval 'sub __sanitizer_syscall_post_wait6 {
        my($res, $idtype, $id, $status, $options, $wru,					 $info) = @_;
	    eval q( &__sanitizer_syscall_post_impl_wait6( $res, , , , , , ($info)));
    }' unless defined(&__sanitizer_syscall_post_wait6);
    eval 'sub __sanitizer_syscall_pre_clock_getcpuclockid2 {
        my($idtype, $id, $clock_id) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_clock_getcpuclockid2( , , ($clock_id)));
    }' unless defined(&__sanitizer_syscall_pre_clock_getcpuclockid2);
    eval 'sub __sanitizer_syscall_post_clock_getcpuclockid2 {
        my($res, $idtype, $id,							       $clock_id) = @_;
	    eval q( &__sanitizer_syscall_post_impl_clock_getcpuclockid2( $res, , , ($clock_id)));
    }' unless defined(&__sanitizer_syscall_post_clock_getcpuclockid2);
    eval 'sub __sanitizer_syscall_pre___getvfsstat90 {
        my($buf, $bufsize, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___getvfsstat90( , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre___getvfsstat90);
    eval 'sub __sanitizer_syscall_post___getvfsstat90 {
        my($res, $buf, $bufsize, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl___getvfsstat90( $res, , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post___getvfsstat90);
    eval 'sub __sanitizer_syscall_pre___statvfs190 {
        my($path, $buf, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___statvfs190( , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre___statvfs190);
    eval 'sub __sanitizer_syscall_post___statvfs190 {
        my($res, $path, $buf, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl___statvfs190( $res, , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post___statvfs190);
    eval 'sub __sanitizer_syscall_pre___fstatvfs190 {
        my($fd, $buf, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___fstatvfs190( , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre___fstatvfs190);
    eval 'sub __sanitizer_syscall_post___fstatvfs190 {
        my($res, $fd, $buf, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl___fstatvfs190( $res, , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post___fstatvfs190);
    eval 'sub __sanitizer_syscall_pre___fhstatvfs190 {
        my($fhp, $fh_size, $buf, $flags) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___fhstatvfs190( , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_pre___fhstatvfs190);
    eval 'sub __sanitizer_syscall_post___fhstatvfs190 {
        my($res, $fhp, $fh_size, $buf, $flags) = @_;
	    eval q( &__sanitizer_syscall_post_impl___fhstatvfs190( $res, , , , ($flags)));
    }' unless defined(&__sanitizer_syscall_post___fhstatvfs190);
    eval 'sub __sanitizer_syscall_pre___acl_get_link {
        my($path, $type, $aclp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___acl_get_link( , , ($aclp)));
    }' unless defined(&__sanitizer_syscall_pre___acl_get_link);
    eval 'sub __sanitizer_syscall_post___acl_get_link {
        my($res, $path, $type, $aclp) = @_;
	    eval q( &__sanitizer_syscall_post_impl___acl_get_link( $res, , , ($aclp)));
    }' unless defined(&__sanitizer_syscall_post___acl_get_link);
    eval 'sub __sanitizer_syscall_pre___acl_set_link {
        my($path, $type, $aclp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___acl_set_link( , , ($aclp)));
    }' unless defined(&__sanitizer_syscall_pre___acl_set_link);
    eval 'sub __sanitizer_syscall_post___acl_set_link {
        my($res, $path, $type, $aclp) = @_;
	    eval q( &__sanitizer_syscall_post_impl___acl_set_link( $res, , , ($aclp)));
    }' unless defined(&__sanitizer_syscall_post___acl_set_link);
    eval 'sub __sanitizer_syscall_pre___acl_delete_link {
        my($path, $type) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___acl_delete_link(, ($type)));
    }' unless defined(&__sanitizer_syscall_pre___acl_delete_link);
    eval 'sub __sanitizer_syscall_post___acl_delete_link {
        my($res, $path, $type) = @_;
	    eval q( &__sanitizer_syscall_post_impl___acl_delete_link($res, , ($type)));
    }' unless defined(&__sanitizer_syscall_post___acl_delete_link);
    eval 'sub __sanitizer_syscall_pre___acl_aclcheck_link {
        my($path, $type, $aclp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___acl_aclcheck_link( , , ($aclp)));
    }' unless defined(&__sanitizer_syscall_pre___acl_aclcheck_link);
    eval 'sub __sanitizer_syscall_post___acl_aclcheck_link {
        my($res, $path, $type, $aclp) = @_;
	    eval q( &__sanitizer_syscall_post_impl___acl_aclcheck_link( $res, , , ($aclp)));
    }' unless defined(&__sanitizer_syscall_post___acl_aclcheck_link);
    eval 'sub __sanitizer_syscall_pre___acl_get_file {
        my($path, $type, $aclp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___acl_get_file( , , ($aclp)));
    }' unless defined(&__sanitizer_syscall_pre___acl_get_file);
    eval 'sub __sanitizer_syscall_post___acl_get_file {
        my($res, $path, $type, $aclp) = @_;
	    eval q( &__sanitizer_syscall_post_impl___acl_get_file( $res, , , ($aclp)));
    }' unless defined(&__sanitizer_syscall_post___acl_get_file);
    eval 'sub __sanitizer_syscall_pre___acl_set_file {
        my($path, $type, $aclp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___acl_set_file( , , ($aclp)));
    }' unless defined(&__sanitizer_syscall_pre___acl_set_file);
    eval 'sub __sanitizer_syscall_post___acl_set_file {
        my($res, $path, $type, $aclp) = @_;
	    eval q( &__sanitizer_syscall_post_impl___acl_set_file( $res, , , ($aclp)));
    }' unless defined(&__sanitizer_syscall_post___acl_set_file);
    eval 'sub __sanitizer_syscall_pre___acl_get_fd {
        my($filedes, $type, $aclp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___acl_get_fd( , , ($aclp)));
    }' unless defined(&__sanitizer_syscall_pre___acl_get_fd);
    eval 'sub __sanitizer_syscall_post___acl_get_fd {
        my($res, $filedes, $type, $aclp) = @_;
	    eval q( &__sanitizer_syscall_post_impl___acl_get_fd( $res, , , ($aclp)));
    }' unless defined(&__sanitizer_syscall_post___acl_get_fd);
    eval 'sub __sanitizer_syscall_pre___acl_set_fd {
        my($filedes, $type, $aclp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___acl_set_fd( , , ($aclp)));
    }' unless defined(&__sanitizer_syscall_pre___acl_set_fd);
    eval 'sub __sanitizer_syscall_post___acl_set_fd {
        my($res, $filedes, $type, $aclp) = @_;
	    eval q( &__sanitizer_syscall_post_impl___acl_set_fd( $res, , , ($aclp)));
    }' unless defined(&__sanitizer_syscall_post___acl_set_fd);
    eval 'sub __sanitizer_syscall_pre___acl_delete_file {
        my($path, $type) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___acl_delete_file(, ($type)));
    }' unless defined(&__sanitizer_syscall_pre___acl_delete_file);
    eval 'sub __sanitizer_syscall_post___acl_delete_file {
        my($res, $path, $type) = @_;
	    eval q( &__sanitizer_syscall_post_impl___acl_delete_file($res, , ($type)));
    }' unless defined(&__sanitizer_syscall_post___acl_delete_file);
    eval 'sub __sanitizer_syscall_pre___acl_delete_fd {
        my($filedes, $type) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___acl_delete_fd(, ($type)));
    }' unless defined(&__sanitizer_syscall_pre___acl_delete_fd);
    eval 'sub __sanitizer_syscall_post___acl_delete_fd {
        my($res, $filedes, $type) = @_;
	    eval q( &__sanitizer_syscall_post_impl___acl_delete_fd($res, , ($type)));
    }' unless defined(&__sanitizer_syscall_post___acl_delete_fd);
    eval 'sub __sanitizer_syscall_pre___acl_aclcheck_file {
        my($path, $type, $aclp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___acl_aclcheck_file( , , ($aclp)));
    }' unless defined(&__sanitizer_syscall_pre___acl_aclcheck_file);
    eval 'sub __sanitizer_syscall_post___acl_aclcheck_file {
        my($res, $path, $type, $aclp) = @_;
	    eval q( &__sanitizer_syscall_post_impl___acl_aclcheck_file( $res, , , ($aclp)));
    }' unless defined(&__sanitizer_syscall_post___acl_aclcheck_file);
    eval 'sub __sanitizer_syscall_pre___acl_aclcheck_fd {
        my($filedes, $type, $aclp) = @_;
	    eval q( &__sanitizer_syscall_pre_impl___acl_aclcheck_fd( , , ($aclp)));
    }' unless defined(&__sanitizer_syscall_pre___acl_aclcheck_fd);
    eval 'sub __sanitizer_syscall_post___acl_aclcheck_fd {
        my($res, $filedes, $type, $aclp) = @_;
	    eval q( &__sanitizer_syscall_post_impl___acl_aclcheck_fd( $res, , , ($aclp)));
    }' unless defined(&__sanitizer_syscall_post___acl_aclcheck_fd);
    eval 'sub __sanitizer_syscall_pre_lpathconf {
        my($path, $name) = @_;
	    eval q( &__sanitizer_syscall_pre_impl_lpathconf(, ($name)));
    }' unless defined(&__sanitizer_syscall_pre_lpathconf);
    eval 'sub __sanitizer_syscall_post_lpathconf {
        my($res, $path, $name) = @_;
	    eval q( &__sanitizer_syscall_post_impl_lpathconf($res, , ($name)));
    }' unless defined(&__sanitizer_syscall_post_lpathconf);
    eval 'sub __sanitizer_syscall_pre_getvfsstat () { &__sanitizer_syscall_pre_compat_90_getvfsstat;}' unless defined(&__sanitizer_syscall_pre_getvfsstat);
    eval 'sub __sanitizer_syscall_post_getvfsstat () { &__sanitizer_syscall_post_compat_90_getvfsstat;}' unless defined(&__sanitizer_syscall_post_getvfsstat);
    eval 'sub __sanitizer_syscall_pre_statvfs1 () { &__sanitizer_syscall_pre_compat_90_statvfs1;}' unless defined(&__sanitizer_syscall_pre_statvfs1);
    eval 'sub __sanitizer_syscall_post_statvfs1 () { &__sanitizer_syscall_post_compat_90_statvfs1;}' unless defined(&__sanitizer_syscall_post_statvfs1);
    eval 'sub __sanitizer_syscall_pre_fstatvfs1 () { &__sanitizer_syscall_pre_compat_90_fstatvfs1;}' unless defined(&__sanitizer_syscall_pre_fstatvfs1);
    eval 'sub __sanitizer_syscall_post_fstatvfs1 () { &__sanitizer_syscall_post_compat_90_fstatvfs1;}' unless defined(&__sanitizer_syscall_post_fstatvfs1);
    eval 'sub __sanitizer_syscall_pre___fhstatvfs140 () { &__sanitizer_syscall_pre_compat_90_fhstatvfs1;}' unless defined(&__sanitizer_syscall_pre___fhstatvfs140);
    eval 'sub __sanitizer_syscall_post___fhstatvfs140 () { &__sanitizer_syscall_post_compat_90_fhstatvfs1;}' unless defined(&__sanitizer_syscall_post___fhstatvfs140);
    if(defined(&__cplusplus)) {
    }
    if(!defined(&_LP64)) {
    } else {
    }
    if(!defined(&_LP64)) {
    } else {
    }
    if(!defined(&_LP64)) {
    } else {
    }
    if(defined(&NTP) || !defined(&_KERNEL_OPT)) {
    } else {
    }
    if(defined(&NTP) || !defined(&_KERNEL_OPT)) {
    } else {
    }
    if(defined(&__cplusplus)) {
    }
}
1;
