/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jde.wizards.ClassRegistry;
import jde.wizards.NameFactory;

public class Signature {
    private Method method;
    private Class[] parameters;
    private Class[] exceptions;
    private Class returnValue;
    private Class declaring;
    private ClassRegistry registry;
    private boolean truncate;
    private boolean see;

    public Signature(Method meth, ClassRegistry aregistry) {
        this(meth, aregistry, true);
    }

    public Signature(Method meth, ClassRegistry aregistry, boolean truncate) {
        this(meth, aregistry, truncate, false);
    }

    public Signature(Method meth, ClassRegistry aregistry, boolean truncate, boolean see) {
        this.method = meth;
        this.registry = aregistry;
        this.truncate = truncate;
        this.see = see;
        this.parameters = this.method.getParameterTypes();
        this.exceptions = this.method.getExceptionTypes();
        this.returnValue = this.method.getReturnType();
        this.declaring = this.method.getDeclaringClass();
        this.register();
    }

    public void setTruncating(boolean b) {
        this.truncate = b;
    }

    public void setRegistry(ClassRegistry registry) {
        this.registry = registry;
    }

    public Class getDeclaringClass() {
        return this.declaring;
    }

    public String toJavaDoc() {
        NameFactory factory = this.registry.getNameFactory();
        StringBuffer buf = new StringBuffer("/**\n *\n *");
        int i = 0;
        while (i < this.parameters.length) {
            buf.append(" @param " + factory.getParameterName(this, i) + " <description>\n *");
            ++i;
        }
        if (!"void".equals(this.returnValue.getName())) {
            buf.append(" @return <description>\n *");
        }
        int i2 = 0;
        while (i2 < this.exceptions.length) {
            buf.append(" @exception " + this.exceptions[i2].getName() + " <description>\n *");
            ++i2;
        }
        if (this.see) {
            buf.append(" @see ");
            buf.append(this.method.getDeclaringClass().getName());
            buf.append('#');
            buf.append(this.method.getName());
            buf.append('(');
            buf.append(this.getParameters(this.method.getParameterTypes(), false));
            buf.append(')');
            buf.append("\n *");
        }
        buf.append("/");
        return buf.toString();
    }

    public String toString() {
        String m = this.getModifiers();
        String r = this.baseName(this.returnValue);
        String meth = this.method.getName();
        String p = this.getParameters(this.parameters);
        String e = this.getExceptions(this.exceptions);
        return m + " " + r + " " + meth + "(" + p + ")" + e;
    }

    public boolean paramsEqual(Class[] p) {
        boolean res;
        int n = this.parameters.length;
        boolean bl = res = p.length == n;
        if (res) {
            int i = 0;
            while (i < n) {
                if (!p[i].equals(this.parameters[i])) {
                    res = false;
                    break;
                }
                ++i;
            }
        }
        return res;
    }

    public boolean equals(Object compare) {
        if (compare instanceof Signature) {
            Signature sig = (Signature)compare;
            return this.method.getName().equals(sig.getMethod().getName()) && this.paramsEqual(sig.getMethod().getParameterTypes());
        }
        return false;
    }

    public Method getMethod() {
        return this.method;
    }

    public final String baseName(Class type) {
        int idx;
        String name = null;
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    cl = cl.getComponentType();
                    ++dimensions;
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                int i = 0;
                while (i < dimensions) {
                    sb.append("[]");
                    ++i;
                }
                name = sb.toString();
            }
            catch (Throwable e) {
                name = type.getName();
            }
        } else {
            name = type.getName();
        }
        if (this.truncate && (idx = name.lastIndexOf(46)) > -1) {
            name = name.substring(idx + 1);
        }
        name = name.replace('$', '.');
        return name;
    }

    public final String getExceptionList() {
        return this.getExceptionList(this.exceptions);
    }

    public final String getExceptionList(Class[] except) {
        if (null == except || except.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < except.length) {
            String type = this.baseName(except[i]);
            buf.append(type);
            if (i < except.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }

    private final String getExceptions(Class[] except) {
        String res = this.getExceptionList(except);
        if (res.length() == 0) {
            return res;
        }
        return " throws " + res;
    }

    public final String getParameters() {
        return this.getParameters(this.parameters, true);
    }

    public final String getParameters(Class[] params) {
        return this.getParameters(params, true);
    }

    public final String getParameters(Class[] params, boolean withName) {
        if (null == params || params.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        NameFactory factory = this.registry.getNameFactory();
        int i = 0;
        while (i < params.length) {
            String type = this.baseName(params[i]);
            String name = factory.getParameterName(this, i);
            buf.append(type);
            if (withName) {
                buf.append(' ');
                buf.append(name);
            }
            if (i < params.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }

    public final String getParameterNames() {
        return this.getParameterNames(this.method.getParameterTypes());
    }

    public final String getParameterNames(Class[] params) {
        if (null == params || params.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        NameFactory factory = this.registry.getNameFactory();
        int i = 0;
        while (i < params.length) {
            String type = this.baseName(params[i]);
            String name = factory.getParameterName(this, i);
            buf.append(name);
            if (i < params.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }

    public final String getModifiers() {
        StringBuffer buf = new StringBuffer("public");
        int mod = this.method.getModifiers();
        if (Modifier.isSynchronized(mod)) {
            buf.append(" synchronized");
        }
        return buf.toString();
    }

    public String getReturnBaseType() {
        return this.baseName(this.returnValue);
    }

    private final void register() {
        if (null != this.registry) {
            this.registry.registerImport(this.declaring);
            this.registry.registerImport(this.returnValue);
            int i = 0;
            while (i < this.parameters.length) {
                this.registry.registerImport(this.parameters[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < this.exceptions.length) {
                this.registry.registerImport(this.exceptions[i2]);
                ++i2;
            }
        }
    }
}

