require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SH3_VMPARAM_H_)) {
    eval 'sub _SH3_VMPARAM_H_ () {1;}' unless defined(&_SH3_VMPARAM_H_);
    require 'sys/queue.ph';
    eval 'sub __USE_TOPDOWN_VM () {1;}' unless defined(&__USE_TOPDOWN_VM);
    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub VM_MIN_ADDRESS () {(( &vaddr_t)0);}' unless defined(&VM_MIN_ADDRESS);
    eval 'sub VM_MAXUSER_ADDRESS () {(( &vaddr_t)0x7ffff000);}' unless defined(&VM_MAXUSER_ADDRESS);
    eval 'sub VM_MAX_ADDRESS () {(( &vaddr_t)0x7ffff000);}' unless defined(&VM_MAX_ADDRESS);
    eval 'sub VM_MIN_KERNEL_ADDRESS () {(( &vaddr_t)0xc0000000);}' unless defined(&VM_MIN_KERNEL_ADDRESS);
    eval 'sub VM_MAX_KERNEL_ADDRESS () {(( &vaddr_t)0xe0000000);}' unless defined(&VM_MAX_KERNEL_ADDRESS);
    eval 'sub USRSTACK () { &VM_MAXUSER_ADDRESS;}' unless defined(&USRSTACK);
    eval 'sub MAXTSIZ () {(64* 1024* 1024);}' unless defined(&MAXTSIZ);
    unless(defined(&MAXDSIZ)) {
	eval 'sub MAXDSIZ () {(512* 1024* 1024);}' unless defined(&MAXDSIZ);
    }
    unless(defined(&MAXSSIZ)) {
	eval 'sub MAXSSIZ () {(32* 1024* 1024);}' unless defined(&MAXSSIZ);
    }
    unless(defined(&DFLDSIZ)) {
	eval 'sub DFLDSIZ () {(128* 1024* 1024);}' unless defined(&DFLDSIZ);
    }
    unless(defined(&DFLSSIZ)) {
	eval 'sub DFLSSIZ () {(2* 1024* 1024);}' unless defined(&DFLSSIZ);
    }
    unless(defined(&USRIOSIZE)) {
	eval 'sub USRIOSIZE () {( &MAXBSIZE /  &PAGE_SIZE * 8);}' unless defined(&USRIOSIZE);
    }
    eval 'sub VM_PHYS_SIZE () {( &USRIOSIZE *  &PAGE_SIZE);}' unless defined(&VM_PHYS_SIZE);
    eval 'sub VM_PHYSSEG_STRAT () { &VM_PSTRAT_BSEARCH;}' unless defined(&VM_PHYSSEG_STRAT);
    eval 'sub sh3_round_page {
        my($x) = @_;
	    eval q((((( &uint32_t)($x)) +  &PGOFSET) & ~ &PGOFSET));
    }' unless defined(&sh3_round_page);
    eval 'sub sh3_trunc_page {
        my($x) = @_;
	    eval q((( &uint32_t)($x) & ~ &PGOFSET));
    }' unless defined(&sh3_trunc_page);
    eval 'sub sh3_btop {
        my($x) = @_;
	    eval q((( &uint32_t)($x) >>  &PGSHIFT));
    }' unless defined(&sh3_btop);
    eval 'sub sh3_ptob {
        my($x) = @_;
	    eval q((( &uint32_t)($x) <<  &PGSHIFT));
    }' unless defined(&sh3_ptob);
}
1;
