/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.Collator;
import java.util.Arrays;

public final class CollationKey
implements Comparable {
    private Collator collator;
    private String originalText;
    private byte[] key;

    public final int compareTo(CollationKey ck) {
        int max = Math.min(this.key.length, ck.key.length);
        int i = 0;
        while (i < max) {
            if (this.key[i] != ck.key[i]) {
                return this.key[i] - ck.key[i];
            }
            ++i;
        }
        return this.key.length - ck.key.length;
    }

    public final int compareTo(Object obj) {
        return this.compareTo((CollationKey)obj);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof CollationKey)) {
            return false;
        }
        CollationKey ck = (CollationKey)obj;
        if (ck.collator != this.collator) {
            return false;
        }
        if (!ck.getSourceString().equals(this.getSourceString())) {
            return false;
        }
        return Arrays.equals(ck.toByteArray(), this.toByteArray());
    }

    public final String getSourceString() {
        return this.originalText;
    }

    public final int hashCode() {
        long h = this.originalText.hashCode();
        int i = this.key.length - 1;
        while (i >= 0) {
            h ^= (long)(this.key[i] * (i + 1));
            --i;
        }
        return (int)(h >> 32 ^ h);
    }

    public final byte[] toByteArray() {
        return this.key;
    }

    CollationKey(Collator collator, String originalText, byte[] key) {
        this.collator = collator;
        this.originalText = originalText;
        this.key = key;
    }
}

