/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.LoggingPermission;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LogManager {
    private static LogManager logManager;
    private static final LoggingPermission controlPermission;
    private Map loggers;
    final Logger rootLogger;
    private Properties properties;
    private final PropertyChangeSupport pcs;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$logging$LogManager;

    public static LogManager getLogManager() {
        return logManager;
    }

    private static final LogManager makeLogManager() {
        LogManager manager;
        String managerClassName = System.getProperty("java.util.logging.manager");
        Class clazz = class$java$util$logging$LogManager;
        if (clazz == null) {
            clazz = class$java$util$logging$LogManager = LogManager.class("[Ljava.util.logging.LogManager;", false);
        }
        if ((manager = (LogManager)LogManager.createInstance(managerClassName, clazz)) != null) {
            return manager;
        }
        if (managerClassName != null) {
            System.err.println("WARNING: System property \"java.util.logging.manager\" should be the name of a subclass of java.util.logging.LogManager");
        }
        return new LogManager();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        listener.getClass();
        this.pcs.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public synchronized boolean addLogger(Logger logger) {
        String name = logger.getName();
        WeakReference ref = (WeakReference)this.loggers.get(name);
        if (ref != null) {
            if (ref.get() != null) {
                return false;
            }
            this.loggers.remove(ref);
        }
        if (name != null && !name.equals("")) {
            this.checkAccess();
        }
        Logger parent = this.findAncestor(logger);
        this.loggers.put(name, new WeakReference(logger));
        if (parent != logger.getParent()) {
            logger.setParent(parent);
        }
        if (parent != this.rootLogger) {
            Iterator iter = this.loggers.keySet().iterator();
            while (iter.hasNext()) {
                Logger possChild = (Logger)((WeakReference)this.loggers.get(iter.next())).get();
                if (possChild == null || possChild == logger || possChild.getParent() != parent || !possChild.getName().startsWith(name) || possChild.getName().charAt(name.length()) != '.') continue;
                possChild.setParent(logger);
            }
        }
        return true;
    }

    private final synchronized Logger findAncestor(Logger child) {
        String childName = child.getName();
        int childNameLength = childName.length();
        Logger best = this.rootLogger;
        int bestNameLength = 0;
        if (child == this.rootLogger) {
            return null;
        }
        Iterator iter = this.loggers.keySet().iterator();
        while (iter.hasNext()) {
            Logger cand;
            String candName = (String)iter.next();
            int candNameLength = candName.length();
            if (candNameLength <= bestNameLength || childNameLength <= candNameLength || !childName.startsWith(candName) || childName.charAt(candNameLength) != '.' || (cand = (Logger)((WeakReference)this.loggers.get(candName)).get()) == null || cand == child) continue;
            bestNameLength = candName.length();
            best = cand;
        }
        return best;
    }

    public synchronized Logger getLogger(String name) {
        name.getClass();
        WeakReference ref = (WeakReference)this.loggers.get(name);
        if (ref != null) {
            return (Logger)ref.get();
        }
        return null;
    }

    public synchronized Enumeration getLoggerNames() {
        return Collections.enumeration(this.loggers.keySet());
    }

    public synchronized void reset() throws SecurityException {
        this.checkAccess();
        this.properties = new Properties();
        Iterator iter = this.loggers.values().iterator();
        while (iter.hasNext()) {
            WeakReference ref = (WeakReference)iter.next();
            if (ref == null) continue;
            Logger logger = (Logger)ref.get();
            if (logger == null) {
                iter.remove();
                continue;
            }
            if (logger == this.rootLogger) continue;
            logger.resetLogger();
            logger.setLevel(null);
        }
        this.rootLogger.setLevel(Level.INFO);
        this.rootLogger.resetLogger();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void readConfiguration() throws IOException, SecurityException {
        InputStream inputStream;
        String path = System.getProperty("java.util.logging.config.file");
        if (path == null || path.length() == 0) {
            String url = System.getProperty("gnu.classpath.home.url") + "/logging.properties";
            inputStream = new URL(url).openStream();
        } else {
            inputStream = new FileInputStream(path);
        }
        try {
            this.readConfiguration(inputStream);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            inputStream.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        inputStream.close();
    }

    public synchronized void readConfiguration(InputStream inputStream) throws IOException, SecurityException {
        this.checkAccess();
        Properties newProperties = new Properties();
        newProperties.load(inputStream);
        this.reset();
        this.properties = newProperties;
        Enumeration keys = newProperties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = ((String)keys.nextElement()).trim();
            String value = newProperties.getProperty(key);
            if (value == null) continue;
            value = value.trim();
            if ("handlers".equals(key)) {
                StringTokenizer tokenizer = new StringTokenizer(value);
                while (tokenizer.hasMoreTokens()) {
                    String handlerName = tokenizer.nextToken();
                    try {
                        Class handlerClass = ClassLoader.getSystemClassLoader().loadClass(handlerName);
                        this.getLogger("").addHandler((Handler)handlerClass.newInstance());
                    }
                    catch (ClassCastException ex) {
                        System.err.println("[LogManager] class " + handlerName + " is not subclass of java.util.logging.Handler");
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            if (!key.endsWith(".level")) continue;
            String loggerName = key.substring(0, key.length() - 6);
            Logger logger = this.getLogger(loggerName);
            if (logger == null) {
                logger = Logger.getLogger(loggerName);
                this.addLogger(logger);
            }
            try {
                logger.setLevel(Level.parse(value));
            }
            catch (Exception _) {
                // empty catch block
            }
        }
        this.pcs.firePropertyChange(null, null, null);
    }

    public synchronized String getProperty(String name) {
        if (this.properties != null) {
            return this.properties.getProperty(name);
        }
        return null;
    }

    static int getIntProperty(String name, int defaultValue) {
        try {
            return Integer.parseInt(LogManager.getLogManager().getProperty(name));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    static int getIntPropertyClamped(String name, int defaultValue, int minValue, int maxValue) {
        int val = LogManager.getIntProperty(name, defaultValue);
        if (val < minValue || val > maxValue) {
            val = defaultValue;
        }
        return val;
    }

    static boolean getBooleanProperty(String name, boolean defaultValue) {
        try {
            return Boolean.valueOf(LogManager.getLogManager().getProperty(name));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    static Level getLevelProperty(String propertyName, Level defaultValue) {
        try {
            return Level.parse(LogManager.getLogManager().getProperty(propertyName));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    static final Class getClassProperty(String propertyName, Class defaultValue) {
        Class usingClass = null;
        try {
            String propertyValue = logManager.getProperty(propertyName);
            if (propertyValue != null) {
                usingClass = Class.forName(propertyValue);
            }
            if (usingClass != null) {
                return usingClass;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    static final Object getInstanceProperty(String propertyName, Class ofClass, Class defaultClass) {
        Class klass = LogManager.getClassProperty(propertyName, defaultClass);
        if (klass == null) {
            return null;
        }
        try {
            Object obj = klass.newInstance();
            if (ofClass.isInstance(obj)) {
                return obj;
            }
        }
        catch (Exception _) {
            // empty catch block
        }
        if (defaultClass == null) {
            return null;
        }
        try {
            return defaultClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void checkAccess() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(controlPermission);
        }
    }

    static final Object createInstance(String className, Class ofClass) {
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            Class klass = Class.forName(className);
            if (!ofClass.isAssignableFrom(klass)) {
                return null;
            }
            return klass.newInstance();
        }
        catch (Exception _) {
            return null;
        }
        catch (LinkageError _) {
            return null;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$java$util$logging$LogManager;
        if (clazz == null) {
            clazz = class$java$util$logging$LogManager = LogManager.class("[Ljava.util.logging.LogManager;", false);
        }
        this.pcs = new PropertyChangeSupport(clazz);
    }

    protected LogManager() {
        this.this();
        if (logManager != null) {
            throw new IllegalStateException("there can be only one LogManager; use LogManager.getLogManager()");
        }
        logManager = this;
        this.loggers = new HashMap();
        this.rootLogger = new Logger("", null);
        this.rootLogger.setLevel(Level.INFO);
        this.addLogger(this.rootLogger);
        Logger.getLogger("global").setParent(this.rootLogger);
        Logger.getLogger("global").setUseParentHandlers(true);
    }

    static {
        LogManager.makeLogManager();
        String string = System.getProperty("java.util.logging.config.class");
        Class clazz = class$java$lang$Object;
        if (clazz == null) {
            clazz = class$java$lang$Object = LogManager.class("[Ljava.lang.Object;", false);
        }
        Object configurator = LogManager.createInstance(string, clazz);
        try {
            if (configurator == null) {
                LogManager.getLogManager().readConfiguration();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        controlPermission = new LoggingPermission("control", null);
    }
}

