/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.iterators;

import edu.cornell.med.icb.iterators.TextFileLineIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;

public class PreSortedMergeTextFilesLineIterator
implements Iterable<String>,
Iterator<String> {
    private Iterator<String>[] lineIterators;
    private String[] nextLines;
    private List<String> sortedList;
    private String lastLine;
    private boolean skipDuplicates;
    private boolean skipEmptyLines;

    public PreSortedMergeTextFilesLineIterator(String[] inputFiles) throws IOException {
        this.initialize(inputFiles);
    }

    public PreSortedMergeTextFilesLineIterator(List inputObjects) throws IOException {
        if (inputObjects == null) {
            throw new FileNotFoundException("No specified files");
        }
        if (inputObjects.size() == 0) {
            throw new FileNotFoundException("No specified files");
        }
        Object inputFile = inputObjects.get(0);
        if (inputFile instanceof String) {
            this.initialize(inputObjects.toArray(new String[inputObjects.size()]));
        } else if (inputFile instanceof InputStream) {
            this.initialize(inputObjects.toArray(new InputStream[inputObjects.size()]));
        } else {
            throw new IOException("Only List<String> and List<InputStream> supported.");
        }
    }

    public PreSortedMergeTextFilesLineIterator(InputStream[] inputStreams) throws IOException {
        this.initialize(inputStreams);
    }

    private void initialize(String[] inputFiles) throws IOException {
        InputStream[] inputStreams = new InputStream[inputFiles.length];
        for (int pos = 0; pos < inputFiles.length; ++pos) {
            String inputFile = inputFiles[pos];
            File inputFileFile = new File(inputFile);
            if (!inputFileFile.exists() || !inputFileFile.isFile()) {
                throw new FileNotFoundException("Input file " + inputFile + " does not exist.");
            }
            InputStream is = inputFile.endsWith(".gz") ? new GZIPInputStream(new FileInputStream(inputFile)) : new FileInputStream(inputFile);
            inputStreams[pos] = is;
        }
        this.initialize(inputStreams);
    }

    private void initialize(InputStream[] inputStreams) throws IOException {
        if (inputStreams.length == 0) {
            throw new FileNotFoundException("No specified files");
        }
        this.lineIterators = new Iterator[inputStreams.length];
        this.nextLines = new String[inputStreams.length];
        this.sortedList = new ArrayList<String>(inputStreams.length);
        int pos = 0;
        for (InputStream inputStream : inputStreams) {
            this.lineIterators[pos++] = new TextFileLineIterator(inputStream).iterator();
        }
        this.lastLine = "";
        this.skipDuplicates = true;
        this.skipEmptyLines = true;
    }

    @Override
    public boolean hasNext() {
        this.fetchNexts();
        return this.someReadData();
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements in iterator, use hasNext()");
        }
        this.lastLine = this.sortedList.remove(0);
        if (this.skipDuplicates) {
            while (this.sortedList.contains(this.lastLine)) {
                this.sortedList.remove(this.lastLine);
            }
        }
        for (int i = 0; i < this.nextLines.length; ++i) {
            if (this.nextLines[i] == null || !this.nextLines[i].equals(this.lastLine)) continue;
            this.nextLines[i] = null;
        }
        return this.lastLine;
    }

    private void fetchNexts() {
        block0: for (int i = 0; i < this.lineIterators.length; ++i) {
            if (this.nextLines[i] != null || this.lineIterators[i] == null) continue;
            while (this.lineIterators[i].hasNext()) {
                String nextLine = this.lineIterators[i].next();
                if (this.skipEmptyLines && nextLine.length() == 0 || this.skipDuplicates && nextLine.equals(this.lastLine)) continue;
                this.nextLines[i] = nextLine;
                this.sortedList.add(this.nextLines[i]);
                continue block0;
            }
            this.lineIterators[i] = null;
        }
        Collections.sort(this.sortedList);
    }

    private boolean someReadData() {
        for (int i = 0; i < this.lineIterators.length; ++i) {
            if (this.nextLines[i] == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean isSkipEmptyLines() {
        return this.skipEmptyLines;
    }

    public void setSkipEmptyLines(boolean skipEmptyLines) {
        this.skipEmptyLines = skipEmptyLines;
    }

    public boolean isSkipDuplicates() {
        return this.skipDuplicates;
    }

    public void setSkipDuplicates(boolean skipDuplicates) {
        this.skipDuplicates = skipDuplicates;
    }
}

