/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.protocols.xml.internal.unmarshall;

import java.io.InputStream;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.http.SdkHttpFullResponse;
import software.amazon.awssdk.protocols.query.unmarshall.XmlDomParser;
import software.amazon.awssdk.protocols.query.unmarshall.XmlElement;

@SdkInternalApi
public final class XmlResponseParserUtils {
    private XmlResponseParserUtils() {
    }

    public static XmlElement parse(SdkPojo sdkPojo, SdkHttpFullResponse response) {
        try {
            Optional responseContent = response.content();
            if ((!response.isSuccessful() || XmlResponseParserUtils.hasPayloadMembers(sdkPojo)) && responseContent.isPresent() && !XmlResponseParserUtils.contentLengthZero(response)) {
                return XmlDomParser.parse((InputStream)((InputStream)responseContent.get()));
            }
            return XmlElement.empty();
        }
        catch (RuntimeException e) {
            if (response.isSuccessful()) {
                throw e;
            }
            return XmlElement.empty();
        }
    }

    private static boolean hasPayloadMembers(SdkPojo sdkPojo) {
        return sdkPojo.sdkFields().stream().anyMatch(f -> f.location() == MarshallLocation.PAYLOAD);
    }

    private static boolean contentLengthZero(SdkHttpFullResponse response) {
        return response.firstMatchingHeader("Content-Length").map(l -> Long.parseLong(l) == 0L).orElse(false);
    }
}

