package Url;
# $Id: Url.pm,v 1.2 2000/06/25 10:15:32 tom Exp $
################################################################

=head1 NAME

Url - URL Υ֥ȥ饹

=head1 SYNOPSIS

 use Uri;
 my $uri = new Uri(uri=>"http://www.foo.com/bar/a.html");
 print $uri->Query;
 print $uri->QueryOmitted;
 print $uri->QueryDecoded;

=head1 MEMBER VARIABLES

 uri    URI
 scheme http:// ʤɤΥ
 host   ۥ̾
 path   ѥ
 query  ? ޤ꡼

=head1 DESCRIPTION

ɬ Set() ǥåȤ뤳ȡ

=cut

use strict;
use vars qw(@ISA);
@ISA = qw(ObjectTemplate);

use JConv;
use ObjectTemplate;

attributes qw(uri scheme host port path filename query);

################################################################
sub initialize ($)
{
    my $self = shift;

    $self->Rationize if $self->uri;
    
    $self->SUPER::initialize;
}

=head2 $u->Set($uri);

URI򥻥åȤ롣
Ȥʬ򤹤롣

=cut
sub Set ($$)
{
    my ($self, $uri) = @_;

    $self->uri($uri);
    $self->Rationize;
}

=head2 $u->AsUri;

URI ȤƤΤޤ֤

=cut

sub AsUri ($)
{
    my $self = shift;

    my $port;
    if ($self->port != 80){
	$port = ":" . $self->port;
    }
    return $self->uri(sprintf("%s%s%s%s%s",
			      $self->scheme,
			      $self->host,
			      $port,
			      $self->path,
			      $self->query));
}

=head2 $u->Rationize

֤

  %7e -> ~
  query ʳʸѴ

=cut

sub Rationize
{
    my $self = shift;

    my ($scheme, $host, $path, $query, $port) = $self->split;
    $host = lc($host);
    $path =~ s/%7e/~/i;
#    $path = lc($path);
    $self->scheme($scheme);
    $self->host($host);
    $self->path($path);
    $self->query($query);
    $self->port($port);

    # filename
    $path =~ m!^.*/([^/]*)!;
    $self->filename($1);
    
    return $self->AsUri;
}


=head2 $u->QueryOmitted;

Query ά֤

=cut

sub QueryOmitted
{
    my $self = shift;

    return sprintf("%s%s%s",
		   $self->scheme,
		   $self->host,
		   $self->path);


}

=head2 $u->QueryDecoded

Query ǥɤ uri ֤

=cut
    
sub QueryDecoded
{
    my $self = shift;

    my $decoded_query = $self->query;
    if ($decoded_query =~ /^\?/){
#	$decoded_query =~ s/^\?//;
	$decoded_query =~ s/%([0-9a-fA-F]{2})/pack("c",hex($1))/ge;
	jconv(\$decoded_query, 'euc');
    }
    return sprintf("%s%s%s%s",
		   $self->scheme,
		   $self->host,
		   $self->path,
		   $decoded_query);
}

=head2 $q->Query;

?  query

=cut

sub Query
{
    my $self = shift;
    my $q = $self->query;
    $q =~ s/^\?//;
    return $q;
}

################################################################
# private:
# ࡢۥȡѥȥ꡼ʬΥ֤
sub split
{
    my $self = shift;

    my ($tmp, $query) = $self->uri =~ /^([^\?]*)(\??.*)$/;
    my ($scheme, $host, $path);
    my $port =80;
    
    if ($tmp =~ m!^[a-z]+://!){
#	print "http\n";
	($scheme, $host, $path) =
	    $tmp =~ m!^([a-z]+://)([^/]+)(.*)$!;
	if ($host =~ /^([^:]+):([\d]+)/){
	    $host = $1;
	    $port = $2;
	}
#	print "$tmp, $scheme, $host, $path, $query\n";
    } else {
	$scheme = undef;
	$path = $tmp;
    }
    
    return ($scheme, $host, $path, $query, $port);
}

1;
