//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#include "libgpspoint_config.h"
#include "declarations.h"
#include "datatypes.h"

#ifdef HAVE_TERMIOS_H

#include <iostream>
#include <stdio.h>   /* Standard input/output definitions */
#include <string>  /* String function definitions */
#include <unistd.h>  /* UNIX standard function definitions */
#include <fcntl.h>   /* File control definitions */
#include <errno.h>   /* Error number definitions */
#include <termios.h> /* POSIX terminal control definitions */

#include <sys/types.h> // for filestat
#include <sys/stat.h>
#include <unistd.h>

#include <string>



#ifdef DEBUG
#if HAVE_STDLIB_H
#define  POSIX_SERIAL_IO_DEBUG
#include <fstream>
#include <iomanip>
#endif 
#endif 

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;

/// This class implements an interfache to serial ports for posix-compliant OS.
class Serial
{
   public:
      Serial(void);
      ~Serial();


   protected:
      /// write one Byte to the device 
      int writeByte(g_byte );

      /// read one byte from the device
      int readByte(g_byte &);

      /// set device e.g. /dev/ttyS1
      void setDevice(string);

      /// set bauds
      void setSpeed(string );

      /// open the device 
      int openPort();
      
      /// close the device
      void closePort();


   private:
      string lockfile;
      string device;
      struct stat filestat; // lockfile 
      string speed;

      struct termios options, old_options;        

      int fd;    // file descriptor

      int err;

		#ifdef POSIX_SERIAL_IO_DEBUG
		ofstream debugfile;
		string byteTrans(int b);
		bool dle;
		#endif
};

}
#endif 

