# by Timothy Downs, inputbox written for my map editor

# This program needs a little cleaning up
# It ignores the shift key
# And, for reasons of my own, this program converts "-" to "_"

# A program to get user input, allowing backspace etc
# shown in a box in the middle of the screen
# Called by:
# import inputbox
# answer = inputbox.ask(screen, "Your name")
#
# Only near the center of the screen is blitted to


# 05/03/2003: Modified slightly for use with Jools by Paul Pelzl
# - Added an optional parameter to provide the location of the box.
# - Foreground and background colors are required inputs.
# - Made the box a bit bigger
# - Removed "-" --> "_" transformation
# - Switched to upper case
# - Bounded the input length

import pygame, pygame.font, pygame.event, pygame.draw, string
from pygame.locals import *

def get_key():
  while 1:
    event = pygame.event.poll()
    if event.type == KEYDOWN:
      return event.key
    else:
      pass

def display_box(screen, location, fgcolor, bgcolor, message):
  "Print a message in a box in the middle of the screen"
  fontobject = pygame.font.Font(None,25)
  if not location:
    locX = screen.get_width()/2
    locY = screen.get_height()/2
  else:
    locX = location[0]
    locY = location[1]

  pygame.draw.rect(screen, bgcolor,
                 (locX - 150,
                  locY - 15,
                  300,30), 0)
  pygame.draw.rect(screen, fgcolor,
                 (locX - 151,
                  locY - 16,
                  302,32), 1)
  if len(message) != 0:
    screen.blit(fontobject.render(message, 1, fgcolor),
                (locX - 150, locY - 10))
  pygame.display.flip()

def ask(screen, fgcolor, bgcolor, question, location=None):
  "ask(screen, question) -> answer"
  pygame.font.init()
  current_string = []
  display_box(screen, location, fgcolor, bgcolor, 
    question + ": " + string.join(current_string,""))
  while 1:
    inkey = get_key()
    if inkey == K_BACKSPACE:
      current_string = current_string[0:-1]
    elif inkey == K_RETURN:
      break
    elif inkey <= 127 and len(current_string) < 16:
      current_string.append(string.upper(chr(inkey)))
    display_box(screen, location, fgcolor, bgcolor, 
      question + ": " + string.join(current_string,""))
  return string.join(current_string,"")


# arch-tag: input box for pygame
