;;Example of a ViDAL (ViSta Data Analysis Language) script file.
;;Load this file with the Load-Edit command.

;;Principal Components Example

;;This example involves generating random data and then analyzing it.

;;Create nine-dimensional normal random data


(when *guidemap* (send *guidemap* :close))  
(show-workmap)


(data "NormalRand"
:variables '("A" "B" "C" "D" "E" "F" "G" "H" "I")
:data (combine
       (+ (normal-rand 360) 2)
       (+ (normal-rand 360) 1)
       (normal-rand 360)
       (- (normal-rand 360) 1)
       (- (normal-rand 360) 2)))

;;Perform a Principal Components Analysis of these data and visualize result

(principal-components)
(create-data)
(setcd scores-pca-normalrand)
(normalize-data)
(vista-message "Please wait while visualization is constructed.")
(visualize-data)
(vista-message "Normal Random Data Example Finished")