require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_TIME_H_)) {
    eval 'sub _SYS_TIME_H_ () {1;}' unless defined(&_SYS_TIME_H_);
    require 'sys/featuretest.ph';
    require 'sys/types.ph';
    require 'sys/timespec.ph';
    if(defined(&_NETBSD_SOURCE)) {
	eval 'sub TIMEVAL_TO_TIMESPEC {
	    my($tv, $ts) = @_;
    	    eval q( &do { ($ts)-> &tv_sec = ($tv)-> &tv_sec; ($ts)-> &tv_nsec = ($tv)-> &tv_usec * 1000; }  &while ( 0));
	}' unless defined(&TIMEVAL_TO_TIMESPEC);
	eval 'sub TIMESPEC_TO_TIMEVAL {
	    my($tv, $ts) = @_;
    	    eval q( &do { ($tv)-> &tv_sec = ($ts)-> &tv_sec; ($tv)-> &tv_usec = ( &suseconds_t)($ts)-> &tv_nsec / 1000; }  &while ( 0));
	}' unless defined(&TIMESPEC_TO_TIMEVAL);
	eval 'sub timerclear {
	    my($tvp) = @_;
    	    eval q(($tvp)-> &tv_sec = ($tvp)-> &tv_usec = 0);
	}' unless defined(&timerclear);
	eval 'sub timerisset {
	    my($tvp) = @_;
    	    eval q((($tvp)-> &tv_sec || ($tvp)-> &tv_usec));
	}' unless defined(&timerisset);
	eval 'sub timercmp {
	    my($tvp, $uvp, $cmp) = @_;
    	    eval q(((($tvp)-> &tv_sec == ($uvp)-> &tv_sec) ? (($tvp)-> &tv_usec $cmp ($uvp)-> &tv_usec) : (($tvp)-> &tv_sec $cmp ($uvp)-> &tv_sec)));
	}' unless defined(&timercmp);
	eval 'sub timeradd {
	    my($tvp, $uvp, $vvp) = @_;
    	    eval q( &do { ($vvp)-> &tv_sec = ($tvp)-> &tv_sec + ($uvp)-> &tv_sec; ($vvp)-> &tv_usec = ($tvp)-> &tv_usec + ($uvp)-> &tv_usec;  &if (($vvp)-> &tv_usec >= 1000000) { ($vvp)-> &tv_sec++; ($vvp)-> &tv_usec -= 1000000; } }  &while ( 0));
	}' unless defined(&timeradd);
	eval 'sub timersub {
	    my($tvp, $uvp, $vvp) = @_;
    	    eval q( &do { ($vvp)-> &tv_sec = ($tvp)-> &tv_sec - ($uvp)-> &tv_sec; ($vvp)-> &tv_usec = ($tvp)-> &tv_usec - ($uvp)-> &tv_usec;  &if (($vvp)-> &tv_usec < 0) { ($vvp)-> &tv_sec--; ($vvp)-> &tv_usec += 1000000; } }  &while ( 0));
	}' unless defined(&timersub);
	if(!defined(&_STANDALONE)) {
	    eval 'sub bintime_addx {
	        my($bt,$x) = @_;
    		eval q({  &uint64_t  &u;  &u =  ($bt->{frac});  ($bt->{frac}) += $x;  &if ( &u >  ($bt->{frac}))  ($bt->{sec})++; });
	    }' unless defined(&bintime_addx);
	    eval 'sub bintime_add {
	        my($bt,$bt2) = @_;
    		eval q({  &uint64_t  &u;  &u =  ($bt->{frac});  ($bt->{frac}) +=  ($bt2->{frac});  &if ( &u >  ($bt->{frac}))  ($bt->{sec})++;  ($bt->{sec}) +=  ($bt2->{sec}); });
	    }' unless defined(&bintime_add);
	    eval 'sub bintime_sub {
	        my($bt,$bt2) = @_;
    		eval q({  &uint64_t  &u;  &u =  ($bt->{frac});  ($bt->{frac}) -=  ($bt2->{frac});  &if ( &u <  ($bt->{frac}))  ($bt->{sec})--;  ($bt->{sec}) -=  ($bt2->{sec}); });
	    }' unless defined(&bintime_sub);
	    eval 'sub bintimecmp {
	        my($bta, $btb, $cmp) = @_;
    		eval q(((($bta)-> &sec == ($btb)-> &sec) ? (($bta)-> &frac $cmp ($btb)-> &frac) : (($bta)-> &sec $cmp ($btb)-> &sec)));
	    }' unless defined(&bintimecmp);
	    eval 'sub BINTIME_SCALE_MS () {(( &uint64_t)18446744073709551);}' unless defined(&BINTIME_SCALE_MS);
	    eval 'sub BINTIME_SCALE_US () {(( &uint64_t)18446744073709);}' unless defined(&BINTIME_SCALE_US);
	    eval 'sub BINTIME_SCALE_NS () {(( &uint64_t)18446744073);}' unless defined(&BINTIME_SCALE_NS);
	    eval 'sub bintime2timespec {
	        my($bt,$ts) = @_;
    		eval q({  ($ts->{tv_sec}) =  ($bt->{sec});  ($ts->{tv_nsec}) = ((1000000000 * ( &uint32_t)( ($bt->{frac}) >> 32)) >> 32); });
	    }' unless defined(&bintime2timespec);
	    eval 'sub timespec2bintime {
	        my($ts,$bt) = @_;
    		eval q({  ($bt->{sec}) =  ($ts->{tv_sec});  ($bt->{frac}) = ( &uint64_t) ($ts->{tv_nsec}) *  &BINTIME_SCALE_NS; });
	    }' unless defined(&timespec2bintime);
	    eval 'sub bintime2timeval {
	        my($bt,$tv) = @_;
    		eval q({  ($tv->{tv_sec}) =  ($bt->{sec});  ($tv->{tv_usec}) = ( &suseconds_t)((1000000 * ( &uint32_t)( ($bt->{frac}) >> 32)) >> 32); });
	    }' unless defined(&bintime2timeval);
	    eval 'sub timeval2bintime {
	        my($tv,$bt) = @_;
    		eval q({  ($bt->{sec}) =  ($tv->{tv_sec});  ($bt->{frac}) = ( &uint64_t) ($tv->{tv_usec}) *  &BINTIME_SCALE_US; });
	    }' unless defined(&timeval2bintime);
	    eval 'sub ms2bintime {
	        my($ms) = @_;
    		eval q({ \'struct bintime\'  &bt;  ($bt->{sec}) = ( &time_t)($ms / 1000);  ($bt->{frac}) = ( &uint64_t)($ms % 1000) *  &BINTIME_SCALE_MS;  &bt; });
	    }' unless defined(&ms2bintime);
	    eval 'sub us2bintime {
	        my($us) = @_;
    		eval q({ \'struct bintime\'  &bt;  ($bt->{sec}) = ( &time_t)($us / 1000000);  ($bt->{frac}) = ( &uint64_t)($us % 1000000) *  &BINTIME_SCALE_US;  &bt; });
	    }' unless defined(&us2bintime);
	    eval 'sub ns2bintime {
	        my($ns) = @_;
    		eval q({ \'struct bintime\'  &bt;  ($bt->{sec}) = ( &time_t)($ns / 1000000000);  ($bt->{frac}) = ( &uint64_t)($ns % 1000000000) *  &BINTIME_SCALE_NS;  &bt; });
	    }' unless defined(&ns2bintime);
	}
	eval 'sub timespecclear {
	    my($tsp) = @_;
    	    eval q(($tsp)-> &tv_sec = ( &time_t)(($tsp)-> &tv_nsec = 0));
	}' unless defined(&timespecclear);
	eval 'sub timespecisset {
	    my($tsp) = @_;
    	    eval q((($tsp)-> &tv_sec || ($tsp)-> &tv_nsec));
	}' unless defined(&timespecisset);
	eval 'sub timespeccmp {
	    my($tsp, $usp, $cmp) = @_;
    	    eval q(((($tsp)-> &tv_sec == ($usp)-> &tv_sec) ? (($tsp)-> &tv_nsec $cmp ($usp)-> &tv_nsec) : (($tsp)-> &tv_sec $cmp ($usp)-> &tv_sec)));
	}' unless defined(&timespeccmp);
	eval 'sub timespecadd {
	    my($tsp, $usp, $vsp) = @_;
    	    eval q( &do { ($vsp)-> &tv_sec = ($tsp)-> &tv_sec + ($usp)-> &tv_sec; ($vsp)-> &tv_nsec = ($tsp)-> &tv_nsec + ($usp)-> &tv_nsec;  &if (($vsp)-> &tv_nsec >= 1000000000) { ($vsp)-> &tv_sec++; ($vsp)-> &tv_nsec -= 1000000000; } }  &while ( 0));
	}' unless defined(&timespecadd);
	eval 'sub timespecsub {
	    my($tsp, $usp, $vsp) = @_;
    	    eval q( &do { ($vsp)-> &tv_sec = ($tsp)-> &tv_sec - ($usp)-> &tv_sec; ($vsp)-> &tv_nsec = ($tsp)-> &tv_nsec - ($usp)-> &tv_nsec;  &if (($vsp)-> &tv_nsec < 0) { ($vsp)-> &tv_sec--; ($vsp)-> &tv_nsec += 1000000000; } }  &while ( 0));
	}' unless defined(&timespecsub);
	eval 'sub timespec2ns {
	    my($x) = @_;
    	    eval q(((( &uint64_t)($x)-> &tv_sec) * 1000000000 + ($x)-> &tv_nsec));
	}' unless defined(&timespec2ns);
	if(defined(&_KERNEL)) {
	}
    }
    eval 'sub ITIMER_REAL () {0;}' unless defined(&ITIMER_REAL);
    eval 'sub ITIMER_VIRTUAL () {1;}' unless defined(&ITIMER_VIRTUAL);
    eval 'sub ITIMER_PROF () {2;}' unless defined(&ITIMER_PROF);
    eval 'sub ITIMER_MONOTONIC () {3;}' unless defined(&ITIMER_MONOTONIC);
    eval 'sub CLOCK_REALTIME () {0;}' unless defined(&CLOCK_REALTIME);
    eval 'sub CLOCK_VIRTUAL () {1;}' unless defined(&CLOCK_VIRTUAL);
    eval 'sub CLOCK_PROF () {2;}' unless defined(&CLOCK_PROF);
    eval 'sub CLOCK_MONOTONIC () {3;}' unless defined(&CLOCK_MONOTONIC);
    eval 'sub CLOCK_THREAD_CPUTIME_ID () {0x20000000;}' unless defined(&CLOCK_THREAD_CPUTIME_ID);
    eval 'sub CLOCK_PROCESS_CPUTIME_ID () {0x40000000;}' unless defined(&CLOCK_PROCESS_CPUTIME_ID);
    if(defined(&_NETBSD_SOURCE)) {
	eval 'sub TIMER_RELTIME () {0x;}' unless defined(&TIMER_RELTIME);
    }
    eval 'sub TIMER_ABSTIME () {0x1;}' unless defined(&TIMER_ABSTIME);
    if(defined(&_KERNEL)) {
	require 'sys/timevar.ph';
    } else {
	unless(defined(&_STANDALONE)) {
	    if(((defined(&_POSIX_C_SOURCE) ? &_POSIX_C_SOURCE : undef) - 0) >= 200112 || (defined(&_XOPEN_SOURCE)  && defined(&_XOPEN_SOURCE_EXTENDED)) || ((defined(&_XOPEN_SOURCE) ? &_XOPEN_SOURCE : undef) - 0) >= 500|| defined(&_NETBSD_SOURCE)) {
		require 'sys/select.ph';
	    }
	    require 'sys/cdefs.ph';
	    require 'time.ph';
	    unless(defined(&__LIBC12_SOURCE__)) {
		if(((defined(&_POSIX_C_SOURCE) ? &_POSIX_C_SOURCE : undef) - 0) >= 200112 || defined(&_XOPEN_SOURCE) || defined(&_NETBSD_SOURCE)) {
		}
		if(defined(&_NETBSD_SOURCE) || defined(&HAVE_NBTOOL_CONFIG_H)) {
		}
	    }
	}
    }
}
1;
