/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.parser.models;

import gnu.javax.swing.text.html.parser.models.list;
import gnu.javax.swing.text.html.parser.models.node;
import java.io.Serializable;
import javax.swing.text.html.parser.ContentModel;
import javax.swing.text.html.parser.DTD;

public class transformer
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static String binary = "&|,";
    protected static String unary = "+*?";

    public static int measureChainLength(ContentModel c) {
        if (c == null) {
            return 0;
        }
        return transformer.measureChainLength(c.next) + 1;
    }

    public static node transform(ContentModel c) {
        return transformer.transform(c, null);
    }

    public static node transform(ContentModel c, DTD dtd) {
        node n;
        if (c.content instanceof node) {
            return (node)c.content;
        }
        if (c.next == null) {
            n = transformer.optionalTransform(c, dtd);
        } else {
            node[] l = new node[transformer.measureChainLength(c)];
            ContentModel m = c;
            int i = 0;
            while (i < l.length) {
                if (m.content instanceof ContentModel) {
                    ContentModel nested = (ContentModel)m.content;
                    l[i] = nested.next == null && !(nested.content instanceof ContentModel) ? new node((char)m.type, (char)nested.type, nested.content) : transformer.transform(nested, dtd);
                } else {
                    l[i] = new node('\u0000', '\u0000', m.content);
                }
                transformer.addtype(l[i], (char)m.type);
                m = m.next;
                ++i;
            }
            if (transformer.isBinary(c.type)) {
                i = 0;
                while (i < l.length) {
                    l[i].binary = (char)c.type;
                    ++i;
                }
            }
            n = new list(l);
        }
        transformer.addtype(n, (char)c.type);
        return n;
    }

    private static final boolean isBinary(int c) {
        boolean bl = false;
        if (binary.indexOf((char)c) >= 0) {
            bl = true;
        }
        return bl;
    }

    private static final boolean isUnary(int c) {
        boolean bl = false;
        if (unary.indexOf((char)c) >= 0) {
            bl = true;
        }
        return bl;
    }

    private static final void addtype(node n, char type) {
        if (transformer.isBinary(type)) {
            n.binary = type;
        } else if (transformer.isUnary(type)) {
            n.unary = type;
        } else if (type != '\u0000') {
            throw new Error("Invalid operation '" + type + '\'');
        }
    }

    private static final node optionalTransform(ContentModel c, DTD dtd) {
        node n = c.content instanceof ContentModel ? transformer.transform((ContentModel)c.content, dtd) : new node('\u0000', '\u0000', c.content);
        return n;
    }
}

