/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;

public final class DataBufferUShort
extends DataBuffer {
    private short[] data;
    private short[][] bankData;

    public final short[] getData() {
        return this.data;
    }

    public final short[] getData(int bank) {
        return this.bankData[bank];
    }

    public final short[][] getBankData() {
        return this.bankData;
    }

    public final int getElem(int i) {
        return this.data[i + this.offset] & (char)-1;
    }

    public final int getElem(int bank, int i) {
        return this.bankData[bank][i + this.offsets[bank]] & (char)-1;
    }

    public final void setElem(int i, int val) {
        this.data[i + this.offset] = (short)val;
    }

    public final void setElem(int bank, int i, int val) {
        this.bankData[bank][i + this.offsets[bank]] = (short)val;
    }

    public DataBufferUShort(int size) {
        super(1, size, 1, 0);
        this.bankData = new short[1][];
        this.data = new short[size];
        this.bankData[0] = this.data;
    }

    public DataBufferUShort(int size, int numBanks) {
        super(1, size, numBanks);
        this.bankData = new short[numBanks][size];
        this.data = this.bankData[0];
    }

    public DataBufferUShort(short[] dataArray, int size) {
        super(1, size, 1, 0);
        if (dataArray == null) {
            throw new NullPointerException();
        }
        this.bankData = new short[1][];
        this.data = dataArray;
        this.bankData[0] = this.data;
    }

    public DataBufferUShort(short[] dataArray, int size, int offset) {
        super(1, size, 1, offset);
        if (dataArray == null) {
            throw new NullPointerException();
        }
        this.bankData = new short[1][];
        this.data = dataArray;
        this.bankData[0] = this.data;
    }

    public DataBufferUShort(short[][] dataArray, int size) {
        super(1, size, dataArray.length);
        this.bankData = dataArray;
        this.data = this.bankData[0];
    }

    public DataBufferUShort(short[][] dataArray, int size, int[] offsets) {
        super(1, size, dataArray.length, offsets);
        this.bankData = dataArray;
        this.data = this.bankData[0];
    }
}

