/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import gnu.java.nio.ChannelReader;
import gnu.java.nio.InputStreamChannel;
import gnu.java.nio.OutputStreamChannel;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.VMChannels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public final class Channels {
    public static final InputStream newInputStream(ReadableByteChannel ch) {
        return VMChannels.newInputStream(ch);
    }

    public static final OutputStream newOutputStream(WritableByteChannel ch) {
        return VMChannels.newOutputStream(ch);
    }

    public static final ReadableByteChannel newChannel(InputStream in) {
        return new InputStreamChannel(in);
    }

    public static final WritableByteChannel newChannel(OutputStream out) {
        return new OutputStreamChannel(out);
    }

    public static final Reader newReader(ReadableByteChannel ch, CharsetDecoder dec, int minBufferCap) {
        return new ChannelReader(ch, dec, minBufferCap);
    }

    public static final Reader newReader(ReadableByteChannel ch, String csName) {
        return Channels.newReader(ch, Charset.forName(csName).newDecoder(), -1);
    }

    public static final Writer newWriter(WritableByteChannel ch, CharsetEncoder enc, int minBufferCap) {
        throw new Error("not implemented");
    }

    public static final Writer newWriter(WritableByteChannel ch, String csName) {
        return Channels.newWriter(ch, Charset.forName(csName).newEncoder(), -1);
    }

    private Channels() {
    }
}

