/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    private static ToolTipManager shared;
    private static Component currentComponent;
    private static JToolTip currentTip;
    private static Point currentPoint;
    private static Container containerPanel;
    private static JDialog tooltipWindow;
    Timer enterTimer;
    Timer exitTimer;
    Timer insideTimer;
    private transient boolean enabled;
    protected boolean lightWeightPopupEnabled;
    protected boolean heavyWeightPopupEnabled;
    static /* synthetic */ Class class$javax$swing$JRootPane;

    public static ToolTipManager sharedInstance() {
        if (shared == null) {
            shared = new ToolTipManager();
        }
        return shared;
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.enterTimer.stop();
            this.exitTimer.stop();
            this.insideTimer.stop();
        }
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setLightWeightPopupEnabled(boolean enabled) {
        this.lightWeightPopupEnabled = enabled;
        this.heavyWeightPopupEnabled = enabled ^ true;
    }

    public int getInitialDelay() {
        return this.enterTimer.getDelay();
    }

    public void setInitialDelay(int delay) {
        this.enterTimer.setDelay(delay);
    }

    public int getDismissDelay() {
        return this.insideTimer.getDelay();
    }

    public void setDismissDelay(int delay) {
        this.insideTimer.setDelay(delay);
    }

    public int getReshowDelay() {
        return this.exitTimer.getDelay();
    }

    public void setReshowDelay(int delay) {
        this.exitTimer.setDelay(delay);
    }

    public void registerComponent(JComponent component) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    public void unregisterComponent(JComponent component) {
        component.removeMouseMotionListener(this);
        component.removeMouseListener(this);
    }

    public void mouseEntered(MouseEvent event) {
        if (currentComponent != null && this.getContentPaneDeepestComponent(event) == currentComponent) {
            return;
        }
        currentPoint = event.getPoint();
        currentComponent = (Component)event.getSource();
        if (this.exitTimer.isRunning()) {
            this.exitTimer.stop();
            this.insideTimer.start();
            return;
        }
        if (!this.enterTimer.isRunning()) {
            this.enterTimer.start();
        }
    }

    public void mouseExited(MouseEvent event) {
        if (this.getContentPaneDeepestComponent(event) == currentComponent) {
            return;
        }
        currentPoint = event.getPoint();
        currentComponent = null;
        this.hideTip();
        if (!this.enterTimer.isRunning() && this.insideTimer.isRunning()) {
            this.exitTimer.start();
        }
        if (this.enterTimer.isRunning()) {
            this.enterTimer.stop();
        }
        if (this.insideTimer.isRunning()) {
            this.insideTimer.stop();
        }
    }

    public void mousePressed(MouseEvent event) {
        currentPoint = event.getPoint();
        if (this.enterTimer.isRunning()) {
            this.enterTimer.restart();
        } else if (this.insideTimer.isRunning()) {
            this.insideTimer.stop();
            this.hideTip();
        }
    }

    public void mouseDragged(MouseEvent event) {
        currentPoint = event.getPoint();
        if (this.enterTimer.isRunning()) {
            this.enterTimer.restart();
        }
    }

    public void mouseMoved(MouseEvent event) {
        currentPoint = event.getPoint();
        if (this.enterTimer.isRunning()) {
            this.enterTimer.restart();
        }
    }

    void showTip() {
        if (!this.enabled || currentComponent == null || !currentComponent.isEnabled() || currentTip != null && currentTip.isVisible()) {
            return;
        }
        if (currentTip == null || currentTip.getComponent() != currentComponent && currentComponent instanceof JComponent) {
            currentTip = ((JComponent)currentComponent).createToolTip();
        }
        currentTip.setVisible(true);
        Container parent = currentComponent.getParent();
        Point p = currentPoint;
        Dimension dims = currentTip.getPreferredSize();
        if (parent instanceof JPopupMenu) {
            this.setLightWeightPopupEnabled(((JPopupMenu)parent).isLightWeightPopupEnabled());
        } else {
            this.setLightWeightPopupEnabled(true);
        }
        if (this.isLightWeightPopupEnabled()) {
            JRootPane r;
            JLayeredPane pane = null;
            Class clazz = class$javax$swing$JRootPane;
            if (clazz == null) {
                clazz = class$javax$swing$JRootPane = ToolTipManager.class("[Ljavax.swing.JRootPane;", false);
            }
            if ((r = (JRootPane)SwingUtilities.getAncestorOfClass(clazz, currentComponent)) != null) {
                pane = r.getLayeredPane();
            }
            if (pane == null) {
                return;
            }
            if (containerPanel != null) {
                this.hideTip();
            }
            containerPanel = new Panel();
            JRootPane root = new JRootPane();
            root.getContentPane().add(currentTip);
            containerPanel.add(root);
            LayoutManager lm = containerPanel.getLayout();
            if (lm instanceof FlowLayout) {
                FlowLayout fm = (FlowLayout)lm;
                fm.setVgap(0);
                fm.setHgap(0);
            }
            p = SwingUtilities.convertPoint(currentComponent, p, pane);
            p = this.adjustLocation(p, pane, dims);
            pane.add(containerPanel);
            containerPanel.setBounds(p.x, p.y, dims.width, dims.height);
            currentTip.setBounds(0, 0, dims.width, dims.height);
            containerPanel.validate();
            containerPanel.repaint();
        } else if (currentComponent.isShowing()) {
            SwingUtilities.convertPointToScreen(p, currentComponent);
            p = this.adjustLocation(p, SwingUtilities.getWindowAncestor(currentComponent), dims);
            tooltipWindow = new JDialog();
            tooltipWindow.setContentPane(currentTip);
            tooltipWindow.setUndecorated(true);
            tooltipWindow.getRootPane().setWindowDecorationStyle(2);
            tooltipWindow.pack();
            tooltipWindow.setBounds(p.x, p.y, dims.width, dims.height);
            tooltipWindow.show();
            tooltipWindow.validate();
            tooltipWindow.repaint();
            currentTip.revalidate();
            currentTip.repaint();
        }
    }

    private final Point adjustLocation(Point p, Component c, Dimension d) {
        if (p.x + d.width > c.getWidth()) {
            p.x -= d.width;
        }
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y + d.height < c.getHeight()) {
            p.y += d.height;
        }
        if (p.y + d.height > c.getHeight()) {
            p.y -= d.height * 2;
        }
        return p;
    }

    void hideTip() {
        if (currentTip == null || !currentTip.isVisible() || !this.enabled) {
            return;
        }
        currentTip.setVisible(false);
        if (containerPanel != null) {
            Container parent = containerPanel.getParent();
            if (parent == null) {
                return;
            }
            parent.remove(containerPanel);
            parent = currentTip.getParent();
            if (parent == null) {
                return;
            }
            parent.remove(currentTip);
            containerPanel = null;
        }
        if (tooltipWindow != null) {
            tooltipWindow.hide();
            tooltipWindow.dispose();
            tooltipWindow = null;
        }
        currentTip = null;
    }

    private final Component getContentPaneDeepestComponent(MouseEvent e) {
        Container parent;
        Component source = (Component)e.getSource();
        Class clazz = class$javax$swing$JRootPane;
        if (clazz == null) {
            clazz = class$javax$swing$JRootPane = ToolTipManager.class("[Ljavax.swing.JRootPane;", false);
        }
        if ((parent = SwingUtilities.getAncestorOfClass(clazz, currentComponent)) == null) {
            return null;
        }
        parent = ((JRootPane)parent).getContentPane();
        Point p = e.getPoint();
        p = SwingUtilities.convertPoint(source, p, parent);
        Component target = SwingUtilities.getDeepestComponentAt(parent, p.x, p.y);
        return target;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.enabled = true;
        this.lightWeightPopupEnabled = true;
        this.heavyWeightPopupEnabled = false;
    }

    ToolTipManager() {
        this.this();
        this.enterTimer = new Timer(750, new insideTimerAction());
        this.enterTimer.setRepeats(false);
        this.insideTimer = new Timer(4000, new stillInsideTimerAction());
        this.insideTimer.setRepeats(false);
        this.exitTimer = new Timer(500, new outsideTimerAction());
        this.exitTimer.setRepeats(false);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class insideTimerAction
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            ToolTipManager.this.showTip();
        }

        protected insideTimerAction() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class stillInsideTimerAction
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            ToolTipManager.this.hideTip();
        }

        protected stillInsideTimerAction() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class outsideTimerAction
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
        }

        protected outsideTimerAction() {
        }
    }
}

