/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorChooserComponentFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.plaf.ComponentUI;

public class BasicColorChooserUI
extends ColorChooserUI {
    protected AbstractColorChooserPanel[] defaultChoosers;
    protected ChangeListener previewListener;
    protected PropertyChangeListener propertyChangeListener;
    JColorChooser chooser;
    JTabbedPane pane;
    private Container prevContainer;

    public static ComponentUI createUI(JComponent c) {
        return new BasicColorChooserUI();
    }

    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        return ColorChooserComponentFactory.getDefaultChooserPanels();
    }

    public void installUI(JComponent c) {
        if (c instanceof JColorChooser) {
            this.chooser = (JColorChooser)c;
            this.chooser.setLayout(new BorderLayout());
            this.defaultChoosers = this.createDefaultChoosers();
            this.chooser.setChooserPanels(this.defaultChoosers);
            this.pane = new JTabbedPane();
            this.pane.addChangeListener(new ChangeListener(){

                public final void stateChanged(ChangeEvent e) {
                    BasicColorChooserUI.this.pane.repaint();
                }
            });
            this.makeTabs(this.defaultChoosers);
            this.chooser.add((Component)this.pane, "North");
            this.installPreviewPanel();
            this.installDefaults();
            this.installListeners();
        }
    }

    void makeTabs(AbstractColorChooserPanel[] panels) {
        this.pane.removeAll();
        int i = 0;
        while (i < panels.length) {
            this.pane.addTab(panels[i].getDisplayName(), panels[i].getSmallDisplayIcon(), panels[i]);
            ++i;
        }
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallDefaultChoosers();
        this.pane = null;
        this.chooser = null;
    }

    protected void uninstallDefaultChoosers() {
        this.defaultChoosers = null;
    }

    protected void installPreviewPanel() {
        this.updatePreviewPanel(ColorChooserComponentFactory.getPreviewPanel());
    }

    void updatePreviewPanel(JComponent preview) {
        if (this.prevContainer == null) {
            this.prevContainer = new JPanel();
            this.prevContainer.setLayout(new BorderLayout());
            this.chooser.add((Component)this.prevContainer, "Center");
        }
        this.prevContainer.removeAll();
        this.prevContainer.add((Component)preview, "Center");
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.chooser, "ColorChooser.background", "ColorChooser.foreground", "ColorChooser.font");
    }

    protected void uninstallDefaults() {
        this.chooser.setBackground(null);
        this.chooser.setForeground(null);
        this.chooser.setFont(null);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.previewListener = new PreviewListener();
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().addChangeListener(this.previewListener);
        this.pane.addChangeListener(new TabPaneListener());
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler();
    }

    protected void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().removeChangeListener(this.previewListener);
        this.previewListener = null;
        this.propertyChangeListener = null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PreviewListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            AbstractColorChooserPanel panel;
            if (BasicColorChooserUI.this.pane != null && (panel = (AbstractColorChooserPanel)BasicColorChooserUI.this.pane.getSelectedComponent()) != null) {
                panel.updateChooser();
            }
            BasicColorChooserUI.this.chooser.repaint();
        }

        private PreviewListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class TabPaneListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            AbstractColorChooserPanel comp = (AbstractColorChooserPanel)BasicColorChooserUI.this.pane.getSelectedComponent();
            comp.updateChooser();
        }

        private TabPaneListener() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class PropertyHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == "chooserPanels") {
                BasicColorChooserUI.this.makeTabs(BasicColorChooserUI.this.chooser.getChooserPanels());
            } else if (e.getPropertyName() == "previewPanel") {
                BasicColorChooserUI.this.updatePreviewPanel(BasicColorChooserUI.this.chooser.getPreviewPanel());
            } else if (e.getPropertyName() == "selectionModel") {
                ((AbstractColorChooserPanel)BasicColorChooserUI.this.pane.getSelectedComponent()).updateChooser();
            }
            BasicColorChooserUI.this.chooser.repaint();
        }
    }
}

