/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.text.FormatCharacterIterator;
import java.io.InvalidObjectException;
import java.text.AttributedCharacterIterator;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;

public class MessageFormat
extends Format {
    private static final long serialVersionUID = 6479157306784022952L;
    private String pattern;
    private Locale locale;
    private MessageFormatElement[] elements;
    private String leader;

    private static final int scanString(String pat, int index, StringBuffer buffer) {
        int max = pat.length();
        buffer.setLength(0);
        boolean quoted = false;
        while (index < max) {
            char c = pat.charAt(index);
            if (quoted) {
                if (c == '\'') {
                    quoted = false;
                } else {
                    buffer.append(c);
                }
            } else if (c == '\'' && index + 1 < max && pat.charAt(index + 1) == '\'') {
                buffer.append(c);
                ++index;
            } else if (c == '\'') {
                quoted = true;
            } else {
                if (c == '{') break;
                buffer.append(c);
            }
            ++index;
        }
        return index;
    }

    private static final int scanFormatElement(String pat, int index, StringBuffer buffer, char term) {
        int max = pat.length();
        buffer.setLength(0);
        int brace_depth = 1;
        boolean quoted = false;
        while (index < max) {
            char c = pat.charAt(index);
            if (quoted) {
                if (c == '\'') {
                    quoted = false;
                }
            } else if (c == '\'' && index + 1 < max && pat.charAt(index + 1) == '\'') {
                buffer.append(c);
                ++index;
            } else if (c == '\'') {
                quoted = true;
            } else if (c == '{') {
                ++brace_depth;
            } else if (c == '}' ? --brace_depth == 0 : c == term) break;
            buffer.append(c);
            ++index;
        }
        return index;
    }

    private static final int scanFormat(String pat, int index, StringBuffer buffer, Vector elts, Locale locale) {
        MessageFormatElement mfe = new MessageFormatElement();
        elts.addElement(mfe);
        int max = pat.length();
        ++index;
        index = MessageFormat.scanFormatElement(pat, index, buffer, ',');
        try {
            mfe.argNumber = Integer.parseInt(buffer.toString());
        }
        catch (NumberFormatException nfx) {
            IllegalArgumentException iae = new IllegalArgumentException(pat);
            iae.initCause(nfx);
            throw iae;
        }
        if (index < max && pat.charAt(index) == ',') {
            index = MessageFormat.scanFormatElement(pat, index + 1, buffer, ',');
            mfe.type = buffer.toString();
            if (index < max && pat.charAt(index) == ',') {
                index = MessageFormat.scanFormatElement(pat, index + 1, buffer, '}');
                mfe.style = buffer.toString();
            }
        }
        if (index >= max || pat.charAt(index) != '}') {
            throw new IllegalArgumentException("Missing '}' at end of message format");
        }
        ++index;
        index = MessageFormat.scanString(pat, index, buffer);
        mfe.trailer = buffer.toString();
        mfe.setLocale(locale);
        return index;
    }

    public void applyPattern(String newPattern) {
        this.pattern = newPattern;
        StringBuffer tempBuffer = new StringBuffer();
        int index = MessageFormat.scanString(newPattern, 0, tempBuffer);
        this.leader = tempBuffer.toString();
        Vector elts = new Vector();
        while (index < newPattern.length()) {
            index = MessageFormat.scanFormat(newPattern, index, tempBuffer, elts, this.locale);
        }
        this.elements = new MessageFormatElement[elts.size()];
        elts.copyInto(this.elements);
    }

    public Object clone() {
        MessageFormat c = (MessageFormat)super.clone();
        c.elements = (MessageFormatElement[])this.elements.clone();
        return c;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MessageFormat)) {
            return false;
        }
        MessageFormat mf = (MessageFormat)obj;
        boolean bl = false;
        if (this.pattern.equals(mf.pattern) && this.locale.equals(mf.locale)) {
            bl = true;
        }
        return bl;
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object arguments) {
        Object[] arguments_array = (Object[])arguments;
        FormatCharacterIterator iterator = new FormatCharacterIterator();
        this.formatInternal(arguments_array, new StringBuffer(), null, iterator);
        return iterator;
    }

    public static String format(String pattern2, Object[] arguments) {
        MessageFormat mf = new MessageFormat(pattern2);
        StringBuffer sb = new StringBuffer();
        FieldPosition fp = new FieldPosition(0);
        return mf.formatInternal(arguments, sb, fp, null).toString();
    }

    public final StringBuffer format(Object[] arguments, StringBuffer appendBuf, FieldPosition fp) {
        return this.formatInternal(arguments, appendBuf, fp, null);
    }

    private final StringBuffer formatInternal(Object[] arguments, StringBuffer appendBuf, FieldPosition fp, FormatCharacterIterator output_iterator) {
        appendBuf.append(this.leader);
        if (output_iterator != null) {
            output_iterator.append(this.leader);
        }
        int i = 0;
        while (i < this.elements.length) {
            Object thisArg = null;
            boolean unavailable = false;
            if (arguments == null || this.elements[i].argNumber >= arguments.length) {
                unavailable = true;
            } else {
                thisArg = arguments[this.elements[i].argNumber];
            }
            AttributedCharacterIterator iterator = null;
            Format formatter = null;
            if (fp != null && i == fp.getField() && fp.getFieldAttribute() == Field.ARGUMENT) {
                fp.setBeginIndex(appendBuf.length());
            }
            if (unavailable) {
                appendBuf.append("{" + this.elements[i].argNumber + '}');
            } else if (this.elements[i].setFormat != null) {
                formatter = this.elements[i].setFormat;
            } else if (this.elements[i].format != null) {
                if (this.elements[i].formatClass != null && !this.elements[i].formatClass.isInstance(thisArg)) {
                    throw new IllegalArgumentException("Wrong format class");
                }
                formatter = this.elements[i].format;
            } else if (thisArg instanceof Number) {
                formatter = NumberFormat.getInstance(this.locale);
            } else if (thisArg instanceof Date) {
                formatter = DateFormat.getTimeInstance(2, this.locale);
            } else {
                appendBuf.append(thisArg);
            }
            if (fp != null && fp.getField() == i && fp.getFieldAttribute() == Field.ARGUMENT) {
                fp.setEndIndex(appendBuf.length());
            }
            if (formatter != null) {
                if (formatter instanceof ChoiceFormat) {
                    StringBuffer buf = new StringBuffer();
                    formatter.format(thisArg, buf, fp);
                    MessageFormat mf = new MessageFormat();
                    mf.setLocale(this.locale);
                    mf.applyPattern(buf.toString());
                    mf.format(arguments, appendBuf, fp);
                } else if (output_iterator != null) {
                    iterator = formatter.formatToCharacterIterator(thisArg);
                } else {
                    formatter.format(thisArg, appendBuf, fp);
                }
                this.elements[i].format = formatter;
            }
            if (output_iterator != null) {
                HashMap hash_argument = new HashMap();
                int position = output_iterator.getEndIndex();
                hash_argument.put(Field.ARGUMENT, new Integer(this.elements[i].argNumber));
                if (iterator != null) {
                    output_iterator.append(iterator);
                    output_iterator.addAttributes(hash_argument, position, output_iterator.getEndIndex());
                } else {
                    output_iterator.append(thisArg.toString(), hash_argument);
                }
                output_iterator.append(this.elements[i].trailer);
            }
            appendBuf.append(this.elements[i].trailer);
            ++i;
        }
        return appendBuf;
    }

    public final StringBuffer format(Object objectArray, StringBuffer appendBuf, FieldPosition fpos) {
        return this.format((Object[])objectArray, appendBuf, fpos);
    }

    public Format[] getFormats() {
        Format[] f = new Format[this.elements.length];
        int i = this.elements.length - 1;
        while (i >= 0) {
            f[i] = this.elements[i].setFormat;
            --i;
        }
        return f;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        return this.pattern.hashCode() + this.locale.hashCode();
    }

    public Object[] parse(String sourceStr, ParsePosition pos) {
        int index = pos.getIndex();
        if (!sourceStr.startsWith(this.leader, index)) {
            pos.setErrorIndex(index);
            return null;
        }
        index += this.leader.length();
        Vector results = new Vector(this.elements.length, 1);
        int i = 0;
        while (i < this.elements.length) {
            Format formatter = null;
            if (this.elements[i].setFormat != null) {
                formatter = this.elements[i].setFormat;
            } else if (this.elements[i].format != null) {
                formatter = this.elements[i].format;
            }
            Object[] value = null;
            if (formatter instanceof ChoiceFormat) {
                ChoiceFormat cf = (ChoiceFormat)formatter;
                String[] formats = (String[])cf.getFormats();
                double[] limits = cf.getLimits();
                MessageFormat subfmt = new MessageFormat();
                subfmt.setLocale(this.locale);
                ParsePosition subpos = new ParsePosition(index);
                int j = 0;
                while (value == null && j < limits.length) {
                    subfmt.applyPattern(formats[j]);
                    subpos.setIndex(index);
                    value = subfmt.parse(sourceStr, subpos);
                    ++j;
                }
                if (value != null) {
                    index = subpos.getIndex();
                    value = new Double(limits[j]);
                }
            } else if (formatter != null) {
                pos.setIndex(index);
                value = formatter.parseObject(sourceStr, pos);
                if (value != null) {
                    index = pos.getIndex();
                }
            } else {
                int next_index = this.elements[i].trailer.length() > 0 ? sourceStr.indexOf(this.elements[i].trailer, index) : sourceStr.length();
                if (next_index == -1) {
                    pos.setErrorIndex(index);
                    return null;
                }
                value = sourceStr.substring(index, next_index);
                index = next_index;
            }
            if (value == null || !sourceStr.startsWith(this.elements[i].trailer, index)) {
                pos.setErrorIndex(index);
                return null;
            }
            if (this.elements[i].argNumber >= results.size()) {
                results.setSize(this.elements[i].argNumber + 1);
            }
            results.setElementAt(value, this.elements[i].argNumber);
            index += this.elements[i].trailer.length();
            ++i;
        }
        Object[] r = new Object[results.size()];
        results.copyInto(r);
        return r;
    }

    public Object[] parse(String sourceStr) throws ParseException {
        ParsePosition pp = new ParsePosition(0);
        Object[] r = this.parse(sourceStr, pp);
        if (r == null) {
            throw new ParseException("couldn't parse string", pp.getErrorIndex());
        }
        return r;
    }

    public Object parseObject(String sourceStr, ParsePosition pos) {
        return this.parse(sourceStr, pos);
    }

    public void setFormat(int variableNum, Format newFormat) {
        this.elements[variableNum].setFormat = newFormat;
    }

    public void setFormats(Format[] newFormats) {
        if (newFormats.length < this.elements.length) {
            throw new IllegalArgumentException("Not enough format objects");
        }
        int len = Math.min(newFormats.length, this.elements.length);
        int i = 0;
        while (i < len) {
            this.elements[i].setFormat = newFormats[i];
            ++i;
        }
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
        if (this.elements != null) {
            int i = 0;
            while (i < this.elements.length) {
                this.elements[i].setLocale(loc);
                ++i;
            }
        }
    }

    public String toPattern() {
        return this.pattern;
    }

    public Format[] getFormatsByArgumentIndex() {
        int argNumMax = 0;
        int i = 0;
        while (i < this.elements.length) {
            if (this.elements[i].argNumber > argNumMax) {
                argNumMax = this.elements[i].argNumber;
            }
            ++i;
        }
        Format[] formats = new Format[argNumMax];
        int i2 = 0;
        while (i2 < this.elements.length) {
            if (this.elements[i2].setFormat != null) {
                formats[this.elements[i2].argNumber] = this.elements[i2].setFormat;
            } else if (this.elements[i2].format != null) {
                formats[this.elements[i2].argNumber] = this.elements[i2].format;
            }
            ++i2;
        }
        return formats;
    }

    public void setFormatByArgumentIndex(int argumentIndex, Format newFormat) {
        int i = 0;
        while (i < this.elements.length) {
            if (this.elements[i].argNumber == argumentIndex) {
                this.elements[i].setFormat = newFormat;
            }
            ++i;
        }
    }

    public void setFormatsByArgumentIndex(Format[] newFormats) {
        int i = 0;
        while (i < newFormats.length) {
            this.setFormatByArgumentIndex(i, newFormats[i]);
            ++i;
        }
    }

    private MessageFormat() {
    }

    public MessageFormat(String pattern2) {
        this(pattern2, Locale.getDefault());
    }

    public MessageFormat(String pattern2, Locale locale) {
        this.locale = locale;
        this.applyPattern(pattern2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static final class MessageFormatElement {
        int argNumber;
        Format setFormat;
        Format format;
        Class formatClass;
        String type;
        String style;
        String trailer;
        static /* synthetic */ Class class$java$lang$Number;
        static /* synthetic */ Class class$java$util$Date;

        final void setLocale(Locale loc) {
            if (this.type != null) {
                if (this.type.equals("number")) {
                    Class clazz = class$java$lang$Number;
                    if (clazz == null) {
                        clazz = this.formatClass = (class$java$lang$Number = MessageFormatElement.class("[Ljava.lang.Number;", false));
                    }
                    if (this.style == null) {
                        this.format = NumberFormat.getInstance(loc);
                    } else if (this.style.equals("currency")) {
                        this.format = NumberFormat.getCurrencyInstance(loc);
                    } else if (this.style.equals("percent")) {
                        this.format = NumberFormat.getPercentInstance(loc);
                    } else if (this.style.equals("integer")) {
                        NumberFormat nf = NumberFormat.getNumberInstance(loc);
                        nf.setMaximumFractionDigits(0);
                        nf.setGroupingUsed(false);
                        this.format = nf;
                    } else {
                        this.format = NumberFormat.getNumberInstance(loc);
                        DecimalFormat df = (DecimalFormat)this.format;
                        df.applyPattern(this.style);
                    }
                } else if (this.type.equals("time") || this.type.equals("date")) {
                    Class clazz = class$java$util$Date;
                    if (clazz == null) {
                        clazz = class$java$util$Date = MessageFormatElement.class("[Ljava.util.Date;", false);
                    }
                    this.formatClass = clazz;
                    int val = 2;
                    boolean styleIsPattern = false;
                    if (this.style != null) {
                        if (this.style.equals("short")) {
                            val = 3;
                        } else if (this.style.equals("medium")) {
                            val = 2;
                        } else if (this.style.equals("long")) {
                            val = 1;
                        } else if (this.style.equals("full")) {
                            val = 0;
                        } else {
                            styleIsPattern = true;
                        }
                    }
                    this.format = this.type.equals("time") ? DateFormat.getTimeInstance(val, loc) : DateFormat.getDateInstance(val, loc);
                    if (styleIsPattern) {
                        SimpleDateFormat sdf = (SimpleDateFormat)this.format;
                        sdf.applyPattern(this.style);
                    }
                } else if (this.type.equals("choice")) {
                    Class clazz = class$java$lang$Number;
                    if (clazz == null) {
                        clazz = this.formatClass = (class$java$lang$Number = MessageFormatElement.class("[Ljava.lang.Number;", false));
                    }
                    if (this.style == null) {
                        throw new IllegalArgumentException("style required for choice format");
                    }
                    this.format = new ChoiceFormat(this.style);
                }
            }
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError().initCause(classNotFoundException);
            }
        }

        private MessageFormatElement() {
        }
    }

    public static class Field
    extends Format.Field {
        static final long serialVersionUID = 7899943957617360810L;
        public static final Field ARGUMENT = new Field("argument");

        protected Object readResolve() throws InvalidObjectException {
            if (this.getName().equals(ARGUMENT.getName())) {
                return ARGUMENT;
            }
            throw new InvalidObjectException("no such MessageFormat field called " + this.getName());
        }

        private Field() {
            super("");
        }

        protected Field(String s) {
            super(s);
        }
    }
}

