/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicMenuItemUI
extends MenuItemUI {
    protected Font acceleratorFont;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    protected Icon arrowIcon;
    protected Icon checkIcon;
    protected int defaultTextIconGap;
    protected Color disabledForeground;
    protected MenuDragMouseListener menuDragMouseListener;
    protected JMenuItem menuItem;
    protected MenuKeyListener menuKeyListener;
    protected MouseInputListener mouseInputListener;
    protected boolean oldBorderPainted;
    protected Color selectionBackground;
    protected Color selectionForeground;
    private String acceleratorDelimiter;
    private ItemListener itemListener;
    private int defaultAcceleratorLabelGap;
    private int defaultTextArrowIconGap;

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return new MenuKeyHandler();
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicMenuItemUI();
    }

    protected void doClick(MenuSelectionManager msm) {
        this.menuItem.doClick();
        msm.clearSelectedPath();
    }

    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    public MenuElement[] getPath() {
        ArrayList path = new ArrayList();
        if (this.menuItem instanceof JMenu) {
            path.add(((JMenu)this.menuItem).getPopupMenu());
        }
        Component c = this.menuItem;
        while (c instanceof MenuElement) {
            path.add(0, c);
            c = c instanceof JPopupMenu ? ((JPopupMenu)c).getInvoker() : c.getParent();
        }
        Object[] pathArray = new MenuElement[path.size()];
        path.toArray(pathArray);
        return pathArray;
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        JMenuItem m = (JMenuItem)c;
        Dimension d = BasicGraphicsUtils.getPreferredButtonSize(m, defaultTextIconGap);
        KeyStroke accelerator = m.getAccelerator();
        if (accelerator != null) {
            Rectangle rect = this.getAcceleratorRect(accelerator, m.getToolkit().getFontMetrics(this.acceleratorFont));
            d.width += rect.width + this.defaultAcceleratorLabelGap;
            if (d.height < rect.height) {
                d.height = rect.height;
            }
        }
        if (checkIcon != null) {
            d.width = d.width + checkIcon.getIconWidth() + defaultTextIconGap;
            if (checkIcon.getIconHeight() > d.height) {
                d.height = checkIcon.getIconHeight();
            }
        }
        if (arrowIcon != null && c instanceof JMenu) {
            d.width = d.width + arrowIcon.getIconWidth() + this.defaultTextArrowIconGap;
            if (arrowIcon.getIconHeight() > d.height) {
                d.height = arrowIcon.getIconHeight();
            }
        }
        return d;
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getPreferredMenuItemSize(c, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installComponents(JMenuItem menuItem) {
    }

    protected void installDefaults() {
        String prefix = this.getPropertyPrefix();
        LookAndFeel.installBorder(this.menuItem, prefix + ".border");
        LookAndFeel.installColorsAndFont(this.menuItem, prefix + ".background", prefix + ".foreground", prefix + ".font");
        this.menuItem.setMargin(UIManager.getInsets(prefix + ".margin"));
        this.acceleratorFont = UIManager.getFont(prefix + ".acceleratorFont");
        this.acceleratorForeground = UIManager.getColor(prefix + ".acceleratorForeground");
        this.acceleratorSelectionForeground = UIManager.getColor(prefix + ".acceleratorSelectionForeground");
        this.selectionBackground = UIManager.getColor(prefix + ".selectionBackground");
        this.selectionForeground = UIManager.getColor(prefix + ".selectionForeground");
        this.acceleratorDelimiter = UIManager.getString(prefix + ".acceleratorDelimiter");
        this.checkIcon = UIManager.getIcon(prefix + ".checkIcon");
        this.menuItem.setHorizontalTextPosition(11);
        this.menuItem.setHorizontalAlignment(10);
        this.menuItem.setOpaque(true);
    }

    protected void installKeyboardActions() {
    }

    protected void installListeners() {
        this.menuItem.addMouseListener(this.mouseInputListener);
        this.menuItem.addMouseMotionListener(this.mouseInputListener);
        this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.addMenuKeyListener(this.menuKeyListener);
        this.menuItem.addItemListener(this.itemListener);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.menuItem = (JMenuItem)c;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
    }

    public void paint(Graphics g, JComponent c) {
        this.paintMenuItem(g, c, this.checkIcon, this.arrowIcon, c.getBackground(), c.getForeground(), this.defaultTextIconGap);
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        Dimension size = this.getPreferredSize(menuItem);
        Color foreground = g.getColor();
        g.setColor(bgColor);
        g.drawRect(0, 0, size.width, size.height);
        g.setColor(foreground);
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        JMenuItem m = (JMenuItem)c;
        Rectangle tr = new Rectangle();
        Rectangle ir = new Rectangle();
        Rectangle vr = new Rectangle();
        Rectangle br = new Rectangle();
        Rectangle ar = new Rectangle();
        Rectangle cr = new Rectangle();
        int vertAlign = m.getVerticalAlignment();
        int horAlign = m.getHorizontalAlignment();
        int vertTextPos = m.getVerticalTextPosition();
        int horTextPos = m.getHorizontalTextPosition();
        Font f = m.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        SwingUtilities.calculateInnerArea(m, br);
        SwingUtilities.calculateInsetArea(br, m.getInsets(), vr);
        this.paintBackground(g, m, m.getBackground());
        Insets insets = m.getInsets();
        br.x -= insets.left;
        br.y -= insets.top;
        br.width += insets.right + insets.left;
        br.height += insets.top + insets.bottom;
        ButtonModel mod = m.getModel();
        if (m.isSelected() && checkIcon == null || mod != null && mod.isArmed() && m.getParent() instanceof MenuElement) {
            if (m.isContentAreaFilled()) {
                g.setColor(this.selectionBackground);
                g.fillRect(br.x, br.y, br.width, br.height);
            }
        } else if (m.isContentAreaFilled()) {
            g.setColor(m.getBackground());
            g.fillRect(br.x, br.y, br.width, br.height);
        }
        if (checkIcon != null) {
            SwingUtilities.layoutCompoundLabel(m, fm, null, checkIcon, vertAlign, horAlign, vertTextPos, horTextPos, vr, cr, tr, defaultTextIconGap);
            checkIcon.paintIcon(m, g, cr.x, cr.y);
            vr.x = cr.x + cr.width + defaultTextIconGap;
        }
        if (arrowIcon != null && c instanceof JMenu && !((JMenu)c).isTopLevelMenu()) {
            int width = arrowIcon.getIconWidth();
            int height = arrowIcon.getIconHeight();
            int offset = (vr.height - height) / 2;
            arrowIcon.paintIcon(m, g, vr.width - width, vr.y + offset);
        }
        Icon i = m.getIcon();
        SwingUtilities.layoutCompoundLabel(c, fm, m.getText(), i, vertAlign, horAlign, vertTextPos, horTextPos, vr, ir, tr, defaultTextIconGap);
        if (i != null) {
            i.paintIcon(c, g, ir.x, ir.y);
        }
        this.paintText(g, m, tr, m.getText());
        String acceleratorText = "";
        if (m.getAccelerator() != null) {
            acceleratorText = this.getAcceleratorText(m.getAccelerator());
            fm = g.getFontMetrics(this.acceleratorFont);
            ar.width = fm.stringWidth(acceleratorText);
            ar.x = br.width - ar.width;
            vr.x = br.width - ar.width - defaultTextIconGap;
            SwingUtilities.layoutCompoundLabel(m, fm, acceleratorText, null, vertAlign, horAlign, vertTextPos, horTextPos, vr, ir, ar, defaultTextIconGap);
            this.paintAccelerator(g, m, ar, acceleratorText);
        }
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        Font f = menuItem.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        if (text != null && !text.equals("")) {
            if (menuItem.isEnabled()) {
                ButtonModel mod = menuItem.getModel();
                if (menuItem.isSelected() && this.checkIcon == null || mod != null && mod.isArmed() && menuItem.getParent() instanceof MenuElement) {
                    g.setColor(this.selectionForeground);
                } else {
                    g.setColor(menuItem.getForeground());
                }
            } else {
                g.setColor(Color.gray);
            }
            int mnemonicIndex = menuItem.getDisplayedMnemonicIndex();
            if (mnemonicIndex != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            } else {
                BasicGraphicsUtils.drawString(g, text, 0, textRect.x, textRect.y + fm.getAscent());
            }
        }
    }

    protected void uninstallComponents(JMenuItem menuItem) {
    }

    protected void uninstallDefaults() {
        this.menuItem.setForeground(null);
        this.menuItem.setBackground(null);
        this.menuItem.setBorder(null);
        this.menuItem.setMargin(null);
        this.menuItem.setBackground(null);
        this.menuItem.setBorder(null);
        this.menuItem.setFont(null);
        this.menuItem.setForeground(null);
        this.menuItem.setMargin(null);
        this.acceleratorFont = null;
        this.acceleratorForeground = null;
        this.acceleratorSelectionForeground = null;
        this.arrowIcon = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.acceleratorDelimiter = null;
    }

    protected void uninstallKeyboardActions() {
    }

    protected void uninstallListeners() {
        this.menuItem.removeMouseListener(this.mouseInputListener);
        this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        this.menuItem.removeItemListener(this.itemListener);
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.menuItem = null;
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    private final String getAcceleratorText(KeyStroke accelerator) {
        String modifiersText = "";
        int modifiers = accelerator.getModifiers();
        char keyChar = accelerator.getKeyChar();
        int keyCode = accelerator.getKeyCode();
        if (modifiers != 0) {
            modifiersText = KeyEvent.getKeyModifiersText(modifiers) + this.acceleratorDelimiter;
        }
        if (keyCode == 0) {
            return modifiersText + keyChar;
        }
        return modifiersText + KeyEvent.getKeyText(keyCode);
    }

    private final Rectangle getAcceleratorRect(KeyStroke accelerator, FontMetrics fm) {
        int width = fm.stringWidth(this.getAcceleratorText(accelerator));
        int height = fm.getHeight();
        return new Rectangle(0, 0, width, height);
    }

    private final void paintAccelerator(Graphics g, JMenuItem menuItem, Rectangle acceleratorRect, String acceleratorText) {
        g.setFont(this.acceleratorFont);
        FontMetrics fm = g.getFontMetrics(this.acceleratorFont);
        if (menuItem.isEnabled()) {
            g.setColor(this.acceleratorForeground);
        } else {
            g.setColor(Color.gray);
        }
        BasicGraphicsUtils.drawString(g, acceleratorText, 0, acceleratorRect.x, acceleratorRect.y + fm.getAscent());
    }

    private final /* synthetic */ void this() {
        this.defaultTextIconGap = 4;
        this.defaultAcceleratorLabelGap = 10;
        this.defaultTextArrowIconGap = 10;
    }

    public BasicMenuItemUI() {
        this.this();
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem);
        this.menuKeyListener = this.createMenuKeyListener(this.menuItem);
        this.itemListener = new ItemHandler();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.setSelectedPath(e.getPath());
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.setSelectedPath(e.getPath());
        }

        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e) {
            MenuElement[] path = e.getPath();
            if (path[path.length - 1] instanceof JMenuItem) {
                ((JMenuItem)path[path.length - 1]).doClick();
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.clearSelectedPath();
        }

        private MenuDragMouseHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class MenuKeyHandler
    implements MenuKeyListener {
        public void menuKeyPressed(MenuKeyEvent e) {
        }

        public void menuKeyReleased(MenuKeyEvent e) {
        }

        public void menuKeyTyped(MenuKeyEvent e) {
        }

        private MenuKeyHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class MouseInputHandler
    implements MouseInputListener {
        public void mouseClicked(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mouseEntered(MouseEvent e) {
            Component source = (Component)e.getSource();
            if (source.getParent() instanceof MenuElement) {
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                manager.setSelectedPath(BasicMenuItemUI.this.getPath());
                manager.processMouseEvent(e);
            }
        }

        public void mouseExited(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            Rectangle size = BasicMenuItemUI.this.menuItem.getBounds();
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            if (e.getX() > 0 && e.getX() < size.width && e.getY() > 0 && e.getY() < size.height) {
                manager.clearSelectedPath();
                BasicMenuItemUI.this.menuItem.doClick();
            } else {
                manager.processMouseEvent(e);
            }
        }

        protected MouseInputHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ItemHandler
    implements ItemListener {
        public void itemStateChanged(ItemEvent evt) {
            boolean state = false;
            if (BasicMenuItemUI.this.menuItem instanceof JCheckBoxMenuItem) {
                if (evt.getStateChange() == 1) {
                    state = true;
                }
                ((JCheckBoxMenuItem)BasicMenuItemUI.this.menuItem).setState(state);
            }
            BasicMenuItemUI.this.menuItem.revalidate();
            BasicMenuItemUI.this.menuItem.repaint();
        }

        private ItemHandler() {
        }
    }
}

