/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DER;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.GnuPKIExtension;
import gnu.java.security.x509.Util;
import gnu.java.security.x509.X500DistinguishedName;
import gnu.java.security.x509.ext.BasicConstraints;
import gnu.java.security.x509.ext.ExtendedKeyUsage;
import gnu.java.security.x509.ext.Extension;
import gnu.java.security.x509.ext.IssuerAlternativeNames;
import gnu.java.security.x509.ext.KeyUsage;
import gnu.java.security.x509.ext.SubjectAlternativeNames;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class X509Certificate
extends java.security.cert.X509Certificate
implements Serializable,
GnuPKIExtension {
    private static final Logger logger = SystemLogger.SYSTEM;
    protected static final OID ID_DSA = new OID("1.2.840.10040.4.1");
    protected static final OID ID_DSA_WITH_SHA1 = new OID("1.2.840.10040.4.3");
    protected static final OID ID_RSA = new OID("1.2.840.113549.1.1.1");
    protected static final OID ID_RSA_WITH_MD2 = new OID("1.2.840.113549.1.1.2");
    protected static final OID ID_RSA_WITH_MD5 = new OID("1.2.840.113549.1.1.4");
    protected static final OID ID_RSA_WITH_SHA1 = new OID("1.2.840.113549.1.1.5");
    protected static final OID ID_ECDSA_WITH_SHA1 = new OID("1.2.840.10045.4.1");
    protected transient byte[] encoded;
    protected transient byte[] tbsCertBytes;
    protected transient int version;
    protected transient BigInteger serialNo;
    protected transient OID algId;
    protected transient byte[] algVal;
    protected transient X500DistinguishedName issuer;
    protected transient Date notBefore;
    protected transient Date notAfter;
    protected transient X500DistinguishedName subject;
    protected transient PublicKey subjectKey;
    protected transient BitString issuerUniqueId;
    protected transient BitString subjectUniqueId;
    protected transient Map extensions = new HashMap();
    protected transient OID sigAlgId;
    protected transient byte[] sigAlgVal;
    protected transient byte[] signature;
    static /* synthetic */ Class class$gnu$java$security$x509$X509Certificate;

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.compareTo(this.notBefore) < 0) {
            throw new CertificateNotYetValidException();
        }
        if (date.compareTo(this.notAfter) > 0) {
            throw new CertificateExpiredException();
        }
    }

    public int getVersion() {
        return this.version;
    }

    public BigInteger getSerialNumber() {
        return this.serialNo;
    }

    public Principal getIssuerDN() {
        return this.issuer;
    }

    public X500Principal getIssuerX500Principal() {
        return new X500Principal(this.issuer.getDer());
    }

    public Principal getSubjectDN() {
        return this.subject;
    }

    public X500Principal getSubjectX500Principal() {
        return new X500Principal(this.subject.getDer());
    }

    public Date getNotBefore() {
        return (Date)this.notBefore.clone();
    }

    public Date getNotAfter() {
        return (Date)this.notAfter.clone();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return (byte[])this.tbsCertBytes.clone();
    }

    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    public String getSigAlgName() {
        if (this.sigAlgId.equals(ID_DSA_WITH_SHA1)) {
            return "SHA1withDSA";
        }
        if (this.sigAlgId.equals(ID_RSA_WITH_MD2)) {
            return "MD2withRSA";
        }
        if (this.sigAlgId.equals(ID_RSA_WITH_MD5)) {
            return "MD5withRSA";
        }
        if (this.sigAlgId.equals(ID_RSA_WITH_SHA1)) {
            return "SHA1withRSA";
        }
        return "unknown";
    }

    public String getSigAlgOID() {
        return this.sigAlgId.toString();
    }

    public byte[] getSigAlgParams() {
        return (byte[])this.sigAlgVal.clone();
    }

    public boolean[] getIssuerUniqueID() {
        if (this.issuerUniqueId != null) {
            return this.issuerUniqueId.toBooleanArray();
        }
        return null;
    }

    public boolean[] getSubjectUniqueID() {
        if (this.subjectUniqueId != null) {
            return this.subjectUniqueId.toBooleanArray();
        }
        return null;
    }

    public boolean[] getKeyUsage() {
        Extension e = this.getExtension(KeyUsage.ID);
        if (e != null) {
            KeyUsage ku = (KeyUsage)e.getValue();
            boolean[] result = new boolean[9];
            boolean[] b = ku.getKeyUsage().toBooleanArray();
            System.arraycopy(b, 0, result, 0, b.length);
            return result;
        }
        return null;
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        Extension e = this.getExtension(ExtendedKeyUsage.ID);
        if (e != null) {
            List a = ((ExtendedKeyUsage)e.getValue()).getPurposeIds();
            ArrayList b = new ArrayList(a.size());
            Iterator it = a.iterator();
            while (it.hasNext()) {
                b.add(it.next().toString());
            }
            return Collections.unmodifiableList(b);
        }
        return null;
    }

    public int getBasicConstraints() {
        Extension e = this.getExtension(BasicConstraints.ID);
        if (e != null) {
            return ((BasicConstraints)e.getValue()).getPathLengthConstraint();
        }
        return -1;
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        Extension e = this.getExtension(SubjectAlternativeNames.ID);
        if (e != null) {
            return ((SubjectAlternativeNames)e.getValue()).getNames();
        }
        return null;
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        Extension e = this.getExtension(IssuerAlternativeNames.ID);
        if (e != null) {
            return ((IssuerAlternativeNames)e.getValue()).getNames();
        }
        return null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        Iterator it = this.extensions.values().iterator();
        while (it.hasNext()) {
            Extension e = (Extension)it.next();
            if (!e.isCritical() || e.isSupported()) continue;
            return true;
        }
        return false;
    }

    public Set getCriticalExtensionOIDs() {
        HashSet s = new HashSet();
        Iterator it = this.extensions.values().iterator();
        while (it.hasNext()) {
            Extension e = (Extension)it.next();
            if (!e.isCritical()) continue;
            s.add(e.getOid().toString());
        }
        return Collections.unmodifiableSet(s);
    }

    public Set getNonCriticalExtensionOIDs() {
        HashSet s = new HashSet();
        Iterator it = this.extensions.values().iterator();
        while (it.hasNext()) {
            Extension e = (Extension)it.next();
            if (e.isCritical()) continue;
            s.add(e.getOid().toString());
        }
        return Collections.unmodifiableSet(s);
    }

    public byte[] getExtensionValue(String oid) {
        Extension e = this.getExtension(new OID(oid));
        if (e != null) {
            return e.getValue().getEncoded();
        }
        return null;
    }

    public Extension getExtension(OID oid) {
        return (Extension)this.extensions.get(oid);
    }

    public Collection getExtensions() {
        return this.extensions.values();
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return (byte[])this.encoded.clone();
    }

    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature sig = Signature.getInstance(this.sigAlgId.toString());
        this.doVerify(sig, key);
    }

    public void verify(PublicKey key, String provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature sig = Signature.getInstance(this.sigAlgId.toString(), provider);
        this.doVerify(sig, key);
    }

    public String toString() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$gnu$java$security$x509$X509Certificate;
        if (clazz == null) {
            clazz = class$gnu$java$security$x509$X509Certificate = X509Certificate.class("[Lgnu.java.security.x509.X509Certificate;", false);
        }
        out.println(stringBuffer.append(clazz.getName()).append(" {").toString());
        out.println("  TBSCertificate {");
        out.println("    version = " + this.version + ';');
        out.println("    serialNo = " + this.serialNo + ';');
        out.println("    signature = {");
        out.println("      algorithm = " + this.getSigAlgName() + ';');
        out.print("      parameters =");
        if (this.sigAlgVal != null) {
            out.println();
            out.print(Util.hexDump(this.sigAlgVal, "        "));
        } else {
            out.println(" null;");
        }
        out.println("    }");
        out.println("    issuer = " + this.issuer.getName() + ';');
        out.println("    validity = {");
        out.println("      notBefore = " + this.notBefore + ';');
        out.println("      notAfter  = " + this.notAfter + ';');
        out.println("    }");
        out.println("    subject = " + this.subject.getName() + ';');
        out.println("    subjectPublicKeyInfo = {");
        out.println("      algorithm = " + this.subjectKey.getAlgorithm());
        out.println("      key =");
        out.print(Util.hexDump(this.subjectKey.getEncoded(), "        "));
        out.println("    };");
        out.println("    issuerUniqueId  = " + this.issuerUniqueId + ';');
        out.println("    subjectUniqueId = " + this.subjectUniqueId + ';');
        out.println("    extensions = {");
        Iterator it = this.extensions.values().iterator();
        while (it.hasNext()) {
            out.println("      " + it.next());
        }
        out.println("    }");
        out.println("  }");
        out.println("  signatureAlgorithm = " + this.getSigAlgName() + ';');
        out.println("  signatureValue =");
        out.print(Util.hexDump(this.signature, "    "));
        out.println("}");
        return str.toString();
    }

    public PublicKey getPublicKey() {
        return this.subjectKey;
    }

    public boolean equals(Object other) {
        if (!(other instanceof X509Certificate)) {
            return false;
        }
        try {
            if (other instanceof X509Certificate) {
                return Arrays.equals(this.encoded, ((X509Certificate)other).encoded);
            }
            byte[] enc = ((X509Certificate)other).getEncoded();
            if (enc == null) {
                return false;
            }
            return Arrays.equals(this.encoded, enc);
        }
        catch (CertificateEncodingException cee) {
            return false;
        }
    }

    private final void doVerify(Signature sig, PublicKey key) throws CertificateException, InvalidKeyException, SignatureException {
        logger.log((Level)Component.X509, "verifying sig={0} key={1}", new Object[]{sig, key});
        sig.initVerify(key);
        sig.update(this.tbsCertBytes);
        if (!sig.verify(this.signature)) {
            throw new CertificateException("signature not validated");
        }
    }

    private final void parse(InputStream encoded) throws Exception {
        byte[] b;
        DERReader der = new DERReader(encoded);
        DERValue cert = der.read();
        logger.log((Level)Component.X509, "start Certificate  len == {0}", new Integer(cert.getLength()));
        this.encoded = cert.getEncoded();
        if (!cert.isConstructed()) {
            throw new IOException("malformed Certificate");
        }
        DERValue tbsCert = der.read();
        if (tbsCert.getValue() != DER.CONSTRUCTED_VALUE) {
            throw new IOException("malformed TBSCertificate");
        }
        this.tbsCertBytes = tbsCert.getEncoded();
        logger.log((Level)Component.X509, "start TBSCertificate  len == {0}", new Integer(tbsCert.getLength()));
        DERValue val = der.read();
        if (val.getTagClass() == 128 && val.getTag() == 0) {
            this.version = ((BigInteger)der.read().getValue()).intValue() + 1;
            val = der.read();
        } else {
            this.version = 1;
        }
        logger.log((Level)Component.X509, "read version == {0}", new Integer(this.version));
        this.serialNo = (BigInteger)val.getValue();
        logger.log((Level)Component.X509, "read serial number == {0}", this.serialNo);
        val = der.read();
        if (!val.isConstructed()) {
            throw new IOException("malformed AlgorithmIdentifier");
        }
        int certAlgLen = val.getLength();
        logger.log((Level)Component.X509, "start AlgorithmIdentifier  len == {0}", new Integer(certAlgLen));
        val = der.read();
        this.algId = (OID)val.getValue();
        logger.log((Level)Component.X509, "read algorithm ID == {0}", this.algId);
        if (certAlgLen > val.getEncodedLength()) {
            val = der.read();
            if (val == null) {
                this.algVal = null;
            } else {
                this.algVal = val.getEncoded();
                if (val.isConstructed()) {
                    encoded.skip(val.getLength());
                }
            }
            logger.log((Level)Component.X509, "read algorithm parameters == {0}", (Object)this.algVal);
        }
        val = der.read();
        this.issuer = new X500DistinguishedName(val.getEncoded());
        der.skip(val.getLength());
        logger.log((Level)Component.X509, "read issuer == {0}", this.issuer);
        if (!der.read().isConstructed()) {
            throw new IOException("malformed Validity");
        }
        this.notBefore = (Date)der.read().getValue();
        logger.log((Level)Component.X509, "read notBefore == {0}", this.notBefore);
        this.notAfter = (Date)der.read().getValue();
        logger.log((Level)Component.X509, "read notAfter == {0}", this.notAfter);
        val = der.read();
        this.subject = new X500DistinguishedName(val.getEncoded());
        der.skip(val.getLength());
        logger.log((Level)Component.X509, "read subject == {0}", this.subject);
        DERValue spki = der.read();
        if (!spki.isConstructed()) {
            throw new IOException("malformed SubjectPublicKeyInfo");
        }
        KeyFactory spkFac = KeyFactory.getInstance("X.509");
        this.subjectKey = spkFac.generatePublic(new X509EncodedKeySpec(spki.getEncoded()));
        der.skip(spki.getLength());
        logger.log((Level)Component.X509, "read subjectPublicKey == {0}", this.subjectKey);
        if (this.version > 1) {
            val = der.read();
        }
        if (this.version >= 2 && val.getTagClass() != 0 && val.getTag() == 1) {
            b = (byte[])val.getValue();
            this.issuerUniqueId = new BitString(b, 1, b.length - 1, b[0] & 0xFF);
            logger.log((Level)Component.X509, "read issuerUniqueId == {0}", this.issuerUniqueId);
            val = der.read();
        }
        if (this.version >= 2 && val.getTagClass() != 0 && val.getTag() == 2) {
            b = (byte[])val.getValue();
            this.subjectUniqueId = new BitString(b, 1, b.length - 1, b[0] & 0xFF);
            logger.log((Level)Component.X509, "read subjectUniqueId == {0}", this.subjectUniqueId);
            val = der.read();
        }
        if (this.version >= 3 && val.getTagClass() != 0 && val.getTag() == 3) {
            val = der.read();
            logger.log((Level)Component.X509, "start Extensions  len == {0}", new Integer(val.getLength()));
            int len = 0;
            while (len < val.getLength()) {
                DERValue ext = der.read();
                logger.log((Level)Component.X509, "start extension  len == {0}", new Integer(ext.getLength()));
                Extension e = new Extension(ext.getEncoded());
                this.extensions.put(e.getOid(), e);
                der.skip(ext.getLength());
                logger.log((Level)Component.X509, "read extension {0} == {1}", new Object[]{e.getOid(), e});
                logger.log((Level)Component.X509, "count == {0}", new Integer(len += ext.getEncodedLength()));
            }
            val = der.read();
        }
        logger.log((Level)Component.X509, "read value {0}", val);
        if (!val.isConstructed()) {
            throw new CertificateException("malformed AlgorithmIdentifier");
        }
        int sigAlgLen = val.getLength();
        logger.log((Level)Component.X509, "start AlgorithmIdentifier  len == {0}", new Integer(sigAlgLen));
        val = der.read();
        this.sigAlgId = (OID)val.getValue();
        logger.log((Level)Component.X509, "read algorithm id == {0}", this.sigAlgId);
        if (sigAlgLen > val.getEncodedLength()) {
            val = der.read();
            if (val.getValue() == null) {
                if (this.subjectKey instanceof DSAPublicKey) {
                    AlgorithmParameters params = AlgorithmParameters.getInstance("DSA");
                    DSAParams dsap = ((DSAPublicKey)this.subjectKey).getParams();
                    DSAParameterSpec spec = new DSAParameterSpec(dsap.getP(), dsap.getQ(), dsap.getG());
                    params.init(spec);
                    this.sigAlgVal = params.getEncoded();
                }
            } else {
                this.sigAlgVal = val.getEncoded();
            }
            if (val.isConstructed()) {
                encoded.skip(val.getLength());
            }
            logger.log((Level)Component.X509, "read parameters == {0}", (Object)this.sigAlgVal);
        }
        this.signature = ((BitString)der.read().getValue()).toByteArray();
        logger.log((Level)Component.X509, "read signature ==\n{0}", Util.hexDump(this.signature, ">>>> "));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    /*
     * WARNING - void declaration
     */
    public X509Certificate(InputStream encoded) throws CertificateException, IOException {
        try {
            this.parse(encoded);
        }
        catch (IOException ioe) {
            void e;
            logger.log((Level)Component.X509, "", ioe);
            throw e;
        }
        catch (Exception e) {
            logger.log((Level)Component.X509, "", e);
            CertificateException ce = new CertificateException(e.getMessage());
            ce.initCause(e);
            throw ce;
        }
    }

    protected X509Certificate() {
    }
}

