require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UFS_EXT2FS_EXT2FS_DIR_H_)) {
    eval 'sub _UFS_EXT2FS_EXT2FS_DIR_H_ () {1;}' unless defined(&_UFS_EXT2FS_EXT2FS_DIR_H_);
    require 'sys/dirent.ph';
    require 'ufs/ext2fs/ext2fs_dinode.ph';
    eval 'sub doff_t () { &int32_t;}' unless defined(&doff_t);
    eval 'sub EXT2FS_MAXDIRSIZE () { &INT32_MAX;}' unless defined(&EXT2FS_MAXDIRSIZE);
    eval 'sub EXT2FS_MAXNAMLEN () {255;}' unless defined(&EXT2FS_MAXNAMLEN);
    eval("sub NONE () { 0; }") unless defined(&NONE);
    eval("sub COMPACT () { 1; }") unless defined(&COMPACT);
    eval("sub FOUND () { 2; }") unless defined(&FOUND);
    eval 'sub EXT2_FT_UNKNOWN () {0;}' unless defined(&EXT2_FT_UNKNOWN);
    eval 'sub EXT2_FT_REG_FILE () {1;}' unless defined(&EXT2_FT_REG_FILE);
    eval 'sub EXT2_FT_DIR () {2;}' unless defined(&EXT2_FT_DIR);
    eval 'sub EXT2_FT_CHRDEV () {3;}' unless defined(&EXT2_FT_CHRDEV);
    eval 'sub EXT2_FT_BLKDEV () {4;}' unless defined(&EXT2_FT_BLKDEV);
    eval 'sub EXT2_FT_FIFO () {5;}' unless defined(&EXT2_FT_FIFO);
    eval 'sub EXT2_FT_SOCK () {6;}' unless defined(&EXT2_FT_SOCK);
    eval 'sub EXT2_FT_SYMLINK () {7;}' unless defined(&EXT2_FT_SYMLINK);
    eval 'sub EXT2_FT_MAX () {8;}' unless defined(&EXT2_FT_MAX);
    eval 'sub E2IFTODT {
        my($mode) = @_;
	    eval q(((($mode) & 0170000) >> 12));
    }' unless defined(&E2IFTODT);
    eval 'sub inot2ext2dt {
        my($type) = @_;
	    eval q({  &switch ($type) {  &case  &E2IFTODT( &EXT2_IFIFO):  &EXT2_FT_FIFO;  &case  &E2IFTODT( &EXT2_IFCHR):  &EXT2_FT_CHRDEV;  &case  &E2IFTODT( &EXT2_IFDIR):  &EXT2_FT_DIR;  &case  &E2IFTODT( &EXT2_IFBLK):  &EXT2_FT_BLKDEV;  &case  &E2IFTODT( &EXT2_IFREG):  &EXT2_FT_REG_FILE;  &case  &E2IFTODT( &EXT2_IFLNK):  &EXT2_FT_SYMLINK;  &case  &E2IFTODT( &EXT2_IFSOCK):  &EXT2_FT_SOCK;  &default: 0; } });
    }' unless defined(&inot2ext2dt);
    eval 'sub ext2dt2dt {
        my($type) = @_;
	    eval q({  &switch ($type) {  &case  &EXT2_FT_REG_FILE:  &DT_FIFO;  &case  &EXT2_FT_DIR:  &DT_DIR;  &case  &EXT2_FT_CHRDEV:  &DT_CHR;  &case  &EXT2_FT_BLKDEV:  &DT_BLK;  &case  &EXT2_FT_FIFO:  &DT_FIFO;  &case  &EXT2_FT_SOCK:  &DT_SOCK;  &case  &EXT2_FT_SYMLINK:  &DT_LNK;  &default:  &DT_UNKNOWN; } });
    }' unless defined(&ext2dt2dt);
    eval 'sub EXT2FS_DIRSIZ {
        my($len) = @_;
	    eval q( &roundup2(8+ $len, 4));
    }' unless defined(&EXT2FS_DIRSIZ);
    eval 'sub EXT2_DIR_PAD () {4;}' unless defined(&EXT2_DIR_PAD);
    eval 'sub EXT2_DIR_ROUND () {( &EXT2_DIR_PAD - 1);}' unless defined(&EXT2_DIR_ROUND);
    eval 'sub EXT2_DIR_REC_LEN {
        my($namelen) = @_;
	    eval q(((($namelen) + 8+  &EXT2_DIR_ROUND) & ~ &EXT2_DIR_ROUND));
    }' unless defined(&EXT2_DIR_REC_LEN);
}
1;
