/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.service.StorageService;

public class TokenFct
extends NativeScalarFunction {
    private static final IPartitioner partitioner = StorageService.getPartitioner();
    private final CFMetaData cfm;

    public TokenFct(CFMetaData cfm) {
        super("token", partitioner.getTokenValidator(), TokenFct.getKeyTypes(cfm));
        this.cfm = cfm;
    }

    private static AbstractType[] getKeyTypes(CFMetaData cfm) {
        AbstractType[] types = new AbstractType[cfm.partitionKeyColumns().size()];
        int i = 0;
        for (ColumnDefinition def : cfm.partitionKeyColumns()) {
            types[i++] = def.type;
        }
        return types;
    }

    @Override
    public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) throws InvalidRequestException {
        CBuilder builder = this.cfm.getKeyValidatorAsCType().builder();
        for (int i = 0; i < parameters.size(); ++i) {
            ByteBuffer bb = parameters.get(i);
            if (bb == null) {
                return null;
            }
            builder.add(bb);
        }
        return partitioner.getTokenFactory().toByteArray(partitioner.getToken(builder.build().toByteBuffer()));
    }
}

