/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.MigrationListener;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SizeEstimatesRecorder
extends MigrationListener
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SizeEstimatesRecorder.class);
    public static final SizeEstimatesRecorder instance = new SizeEstimatesRecorder();

    private SizeEstimatesRecorder() {
        MigrationManager.instance.register(this);
    }

    @Override
    public void run() {
        TokenMetadata metadata = StorageService.instance.getTokenMetadata().cloneOnlyTokenMap();
        if (!metadata.isMember(FBUtilities.getBroadcastAddress())) {
            logger.debug("Node is not part of the ring; not recording size estimates");
            return;
        }
        logger.trace("Recording size estimates");
        Collection<Token> localTokens = StorageService.instance.getLocalTokens();
        Collection<Range<Token>> localRanges = metadata.getPrimaryRangesFor(localTokens);
        for (Keyspace keyspace : Keyspace.nonSystem()) {
            for (ColumnFamilyStore table : keyspace.getColumnFamilyStores()) {
                long start = System.nanoTime();
                this.recordSizeEstimates(table, localRanges);
                long passed = System.nanoTime() - start;
                logger.trace("Spent {} milliseconds on estimating {}.{} size", new Object[]{TimeUnit.NANOSECONDS.toMillis(passed), table.metadata.ksName, table.metadata.cfName});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordSizeEstimates(ColumnFamilyStore table, Collection<Range<Token>> localRanges) {
        List unwrappedRanges = Range.normalize(localRanges);
        HashMap<Range<Token>, Pair<Long, Long>> estimates = new HashMap<Range<Token>, Pair<Long, Long>>(localRanges.size());
        for (Range<Token> range : unwrappedRanges) {
            long meanPartitionSize;
            long partitionsCount;
            Refs<SSTableReader> refs = null;
            try {
                while (refs == null) {
                    ColumnFamilyStore.ViewFragment view = table.select(table.viewFilter(Range.makeRowRange(range)));
                    refs = Refs.tryRef(view.sstables);
                }
                partitionsCount = this.estimatePartitionsCount(refs, range);
                meanPartitionSize = this.estimateMeanPartitionSize((Collection<SSTableReader>)refs);
            }
            finally {
                if (refs != null) {
                    refs.release();
                }
            }
            estimates.put(range, Pair.create(partitionsCount, meanPartitionSize));
        }
        SystemKeyspace.updateSizeEstimates(table.metadata.ksName, table.metadata.cfName, estimates);
    }

    private long estimatePartitionsCount(Collection<SSTableReader> sstables, Range<Token> range) {
        long count = 0L;
        for (SSTableReader sstable : sstables) {
            count += sstable.estimatedKeysForRanges(Collections.singleton(range));
        }
        return count;
    }

    private long estimateMeanPartitionSize(Collection<SSTableReader> sstables) {
        long sum = 0L;
        long count = 0L;
        for (SSTableReader sstable : sstables) {
            long n = sstable.getEstimatedRowSize().count();
            sum += sstable.getEstimatedRowSize().mean() * n;
            count += n;
        }
        return count > 0L ? sum / count : 0L;
    }

    @Override
    public void onDropColumnFamily(String keyspace, String table) {
        SystemKeyspace.clearSizeEstimates(keyspace, table);
    }
}

