/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.ImageIcon;

public class JideCursors {
    public static final int FIRST_CUSTOM_CURSOR = 20;
    public static final int HSPLIT_CURSOR = 20;
    public static final int VSPLIT_CURSOR = 21;
    public static final int DRAG_CURSOR = 22;
    public static final int DRAG_STOP_CURSOR = 23;
    public static final int NORTH_CURSOR = 24;
    public static final int SOUTH_CURSOR = 25;
    public static final int EAST_CURSOR = 26;
    public static final int WEST_CURSOR = 27;
    public static final int TAB_CURSOR = 28;
    public static final int FLOAT_CURSOR = 29;
    public static final int VERTICAL_CURSOR = 30;
    public static final int HORIZONTAL_CURSOR = 31;
    public static final int DELETE_CURSOR = 32;
    public static final int DRAG_TEXT_CURSOR = 33;
    public static final int DRAG_TEXT_STOP_CURSOR = 34;
    public static final int PERCENTAGE_CURSOR = 35;
    public static final int MOVE_EAST_CURSOR = 36;
    public static final int MOVE_WEST_CURSOR = 37;
    public static final int LAST_CUSTOM_CURSOR = 38;
    private static final Cursor[] predefined = new Cursor[19];

    public static Cursor getPredefinedCursor(int type) {
        if (type < 20 || type > 38) {
            throw new IllegalArgumentException("illegal cursor type");
        }
        if (predefined[type - 20] == null) {
            JideCursors.predefined[type - 20] = JideCursors.createCursor(type);
        }
        return predefined[type - 20];
    }

    public static void setPredefinedCursor(int type, Cursor cursor) {
        if (type < 20 || type > 38) {
            throw new IllegalArgumentException("illegal cursor type");
        }
        JideCursors.predefined[type - 20] = cursor == null ? JideCursors.createCursor(type) : cursor;
    }

    protected static Cursor createCursor(int type) {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension bestSize = toolkit.getBestCursorSize(32, 32);
            int maxColor = toolkit.getMaximumCursorColors();
            switch (type) {
                case 20: {
                    if (bestSize.width != 0 && maxColor > 3) {
                        ImageIcon icon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.hsplit");
                        if (icon == null) {
                            return Cursor.getPredefinedCursor(11);
                        }
                        return toolkit.createCustomCursor(icon.getImage(), new Point(15, 15), "Horizonal Split");
                    }
                    return Cursor.getPredefinedCursor(11);
                }
                case 21: {
                    if (bestSize.width != 0 && maxColor > 3) {
                        ImageIcon icon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.vsplit");
                        if (icon == null) {
                            return Cursor.getPredefinedCursor(9);
                        }
                        return toolkit.createCustomCursor(icon.getImage(), new Point(15, 15), "Vertical Split");
                    }
                    return Cursor.getPredefinedCursor(9);
                }
                case 22: {
                    if (bestSize.width != 0 && maxColor > 3) {
                        ImageIcon icon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.drag");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(icon.getImage(), new Point(17, 12), "Drag");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 23: {
                    if (bestSize.width != 0 && maxColor > 3) {
                        ImageIcon icon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.dragStop");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(icon.getImage(), new Point(17, 12), "Drag Stop");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 33: {
                    if (bestSize.width != 0 && maxColor > 3) {
                        ImageIcon icon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.dragText");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(icon.getImage(), new Point(0, 0), "Drag Text");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 34: {
                    if (bestSize.width != 0 && maxColor > 3) {
                        ImageIcon icon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.dragTextStop");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(icon.getImage(), new Point(15, 15), "Drag Text Stop");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 24: {
                    if (bestSize.width != 0 && maxColor > 3) {
                        ImageIcon icon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.north");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(icon.getImage(), new Point(15, 10), "North");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 25: {
                    if (bestSize.width != 0 && maxColor > 3) {
                        ImageIcon icon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.south");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(icon.getImage(), new Point(15, 20), "South");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 26: {
                    if (bestSize.width != 0 && maxColor > 3) {
                        ImageIcon icon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.east");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(icon.getImage(), new Point(20, 15), "East");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 27: {
                    if (bestSize.width != 0 && maxColor > 3) {
                        ImageIcon icon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.west");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(icon.getImage(), new Point(10, 15), "West");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 28: {
                    if (bestSize.width != 0 && maxColor > 3) {
                        ImageIcon icon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.tab");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(icon.getImage(), new Point(15, 15), "Tabbed");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 29: {
                    if (bestSize.width != 0 && maxColor > 3) {
                        ImageIcon icon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.float");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(icon.getImage(), new Point(15, 15), "Floating");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 30: {
                    if (bestSize.width != 0 && maxColor > 3) {
                        ImageIcon icon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.vertical");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(icon.getImage(), new Point(15, 15), "Vertical");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 31: {
                    if (bestSize.width != 0 && maxColor > 3) {
                        ImageIcon icon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.horizontal");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(icon.getImage(), new Point(15, 15), "Horizontal");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 32: {
                    if (bestSize.width != 0 && maxColor > 3) {
                        ImageIcon icon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.delete");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(icon.getImage(), new Point(10, 10), "Delete");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 35: {
                    if (bestSize.width != 0 && maxColor > 3) {
                        ImageIcon icon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.percentage");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(icon.getImage(), new Point(20, 15), "Percentage");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 36: {
                    if (bestSize.width != 0 && maxColor > 3) {
                        ImageIcon icon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.moveEast");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(icon.getImage(), new Point(11, 15), "Move East");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 37: {
                    if (bestSize.width != 0 && maxColor > 3) {
                        ImageIcon icon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.moveWest");
                        if (icon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(icon.getImage(), new Point(20, 15), "Move West");
                    }
                    return Cursor.getDefaultCursor();
                }
            }
            return null;
        }
        catch (Exception e) {
            return Cursor.getDefaultCursor();
        }
    }

    static {
        for (int i = 20; i < 38; ++i) {
            JideCursors.getPredefinedCursor(i);
        }
    }
}

