/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro;

import java.awt.Rectangle;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import net.bluecow.spectro.Clip;
import net.bluecow.spectro.Frame;

public class ClipDataEdit
extends AbstractUndoableEdit {
    private static final Logger logger = Logger.getLogger(ClipDataEdit.class.getName());
    private final Clip clip;
    private final int firstFrame;
    private final int firstFreqIndex;
    private double[][] oldData;
    private double[][] newData;

    public ClipDataEdit(Clip clip, int firstFrame, int firstFreqIndex, int nFrames, int nFreqs) {
        if (nFrames == 0) {
            throw new IllegalArgumentException("Data area to capture is empty (nFrames == 0)");
        }
        if (nFreqs == 0) {
            throw new IllegalArgumentException("Data area to capture is empty (nFreqs == 0)");
        }
        this.clip = clip;
        this.firstFrame = firstFrame;
        this.firstFreqIndex = firstFreqIndex;
        this.oldData = new double[nFrames][nFreqs];
        this.capture(this.oldData);
    }

    public ClipDataEdit(Clip clip, Rectangle r) {
        this(clip, r.x, r.y, r.width, r.height);
    }

    public boolean replaceEdit(UndoableEdit anEdit) {
        boolean replace = false;
        if (anEdit instanceof ClipDataEdit) {
            ClipDataEdit other = (ClipDataEdit)anEdit;
            if (other.firstFrame == this.firstFrame && other.firstFreqIndex == this.firstFreqIndex && other.oldData.length == this.oldData.length && other.oldData[0].length == this.oldData[0].length && other.clip == this.clip) {
                replace = true;
                this.oldData = other.oldData;
                other.die();
            }
        }
        logger.fine("Replace edit? " + replace);
        return replace;
    }

    public void captureNewData() {
        if (this.newData != null) {
            throw new IllegalStateException("Already captured new data");
        }
        this.newData = new double[this.oldData.length][this.oldData[0].length];
        this.capture(this.newData);
        if (Arrays.deepEquals((Object[])this.oldData, (Object[])this.newData)) {
            logger.fine("Captured new data == old data!");
        }
    }

    public void undo() throws CannotUndoException {
        super.undo();
        logger.fine("Undoing edit at " + this.getRegion());
        this.apply(this.oldData);
        this.clip.regionChanged(this.getRegion());
    }

    public void redo() throws CannotRedoException {
        super.redo();
        logger.fine("Redoing edit at " + this.getRegion());
        this.apply(this.newData);
        this.clip.regionChanged(this.getRegion());
    }

    private void apply(double[][] data) {
        for (int i = 0; i < data.length; ++i) {
            Frame f = this.clip.getFrame(i + this.firstFrame);
            for (int j = 0; j < data[0].length; ++j) {
                f.setReal(j + this.firstFreqIndex, data[i][j]);
            }
        }
    }

    private void capture(double[][] data) {
        for (int i = 0; i < data.length; ++i) {
            Frame f = this.clip.getFrame(i + this.firstFrame);
            for (int j = 0; j < data[0].length; ++j) {
                data[i][j] = f.getReal(j + this.firstFreqIndex);
            }
        }
    }

    public Rectangle getRegion() {
        return new Rectangle(this.firstFrame, this.firstFreqIndex, this.oldData.length, this.oldData[0].length);
    }

    public boolean isSameRegion(Rectangle r) {
        if (r == null) {
            return false;
        }
        return r.x == this.firstFrame && r.y == this.firstFreqIndex && r.width == this.oldData.length && r.height == this.oldData[0].length;
    }

    public double[][] getOldData() {
        return this.oldData;
    }

    public String toString() {
        return String.format("Clip Data Edit @ [%d, %d %d x %d]", this.firstFrame, this.firstFreqIndex, this.oldData.length, this.oldData[0].length);
    }
}

