/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import writer2latex.office.OfficeStyle;
import writer2latex.util.Misc;

public class StyleWithProperties
extends OfficeStyle {
    private Hashtable properties = new Hashtable();

    public void loadStyleFromDOM(Node node) {
        NamedNodeMap attrNodes;
        Element properties;
        super.loadStyleFromDOM(node);
        if (node.hasChildNodes() && (properties = Misc.getChildByTagName(node, "style:properties")) != null && (attrNodes = properties.getAttributes()) != null) {
            int nLen = attrNodes.getLength();
            int i = 0;
            while (i < nLen) {
                Node attr = attrNodes.item(i);
                this.setProperty(attr.getNodeName(), attr.getNodeValue());
                ++i;
            }
        }
    }

    public void setProperty(String sProperty, String sValue) {
        this.properties.put(sProperty, sValue);
    }

    public String getProperty(String sProperty, boolean bInherit) {
        if (bInherit) {
            return this.getProperty(sProperty);
        }
        if (this.properties.containsKey(sProperty)) {
            String sValue = (String)this.properties.get(sProperty);
            return Misc.truncateLength(sValue);
        }
        return null;
    }

    public String getProperty(String sProperty) {
        StyleWithProperties parentStyle;
        if (this.properties.containsKey(sProperty)) {
            String sValue = (String)this.properties.get(sProperty);
            return Misc.truncateLength(sValue);
        }
        if (this.sParentName != null && (parentStyle = (StyleWithProperties)this.family.getStyle(this.sParentName)) != null) {
            return parentStyle.getProperty(sProperty);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getAbsoluteProperty(String sProperty) {
        StyleWithProperties style;
        String sValue;
        if (this.properties.containsKey(sProperty)) {
            String sValue2 = (String)this.properties.get(sProperty);
            if (!sValue2.endsWith("%")) return Misc.truncateLength(sValue2);
            StyleWithProperties parentStyle = (StyleWithProperties)this.family.getStyle(this.sParentName);
            if (parentStyle != null) {
                String sParentValue = parentStyle.getAbsoluteProperty(sProperty);
                if (sParentValue == null) return null;
                return Misc.multiply(sValue2, sParentValue);
            }
            if (this.getFamily() == null || this.getFamily().getDefaultStyle() == null) return null;
            StyleWithProperties style2 = (StyleWithProperties)this.getFamily().getDefaultStyle();
            String sDefaultValue = style2.getProperty(sProperty);
            if (sValue2 == null) return null;
            return Misc.multiply(sValue2, sDefaultValue);
        }
        if (this.sParentName != null) {
            StyleWithProperties parentStyle = (StyleWithProperties)this.family.getStyle(this.sParentName);
            if (parentStyle == null) return null;
            return parentStyle.getAbsoluteProperty(sProperty);
        }
        if (this.getFamily() == null || this.getFamily().getDefaultStyle() == null || (sValue = (style = (StyleWithProperties)this.getFamily().getDefaultStyle()).getProperty(sProperty)) == null) return null;
        return sValue;
    }
}

