/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xml.output;

import com.jclark.xml.output.XMLWriter;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;

public class UTF8XMLWriter
extends XMLWriter {
    private OutputStream out;
    private boolean inStartTag;
    private boolean quoteWhitespace;
    private static final int DEFAULT_BUF_LENGTH = 4096;
    private byte[] buf = new byte[4096];
    private int bufUsed;
    private String sysLineSeparator;
    private String lineSeparator;
    private boolean minimizeEmptyElements;
    private boolean minimizeEmptyElementsHtml;
    public static final int MINIMIZE_EMPTY_ELEMENTS = 1;
    public static final int MINIMIZE_EMPTY_ELEMENTS_HTML = 2;
    private static final int DEFAULT_OPTIONS = 0;

    public void entityReference(boolean bl, String string) throws IOException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.put(bl ? (byte)37 : 38);
        this.writeRaw(string);
        this.put((byte)59);
    }

    private final void writeSurrogatePair(char c, char c2) throws IOException {
        if ((c & 0xFC00) != 55296 || (c2 & 0xFC00) != 56320) {
            throw new CharConversionException();
        }
        int n = (c & 0x3FF) << 10 | c2 & 0x3FF;
        this.put((byte)((n += 65536) >> 18 & 7 | 0xF0));
        this.put((byte)(n >> 12 & 0x3F | 0x80));
        this.put((byte)(n >> 6 & 0x3F | 0x80));
        this.put((byte)(n & 0x3F | 0x80));
    }

    public void characterReference(int n) throws IOException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.writeRaw("&#");
        this.writeRaw(Integer.toString(n));
        this.put((byte)59);
    }

    public void cdataSection(String string) throws IOException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.writeRaw("<![CDATA[");
        this.writeMarkup(string);
        this.writeRaw("]]>");
    }

    public void close() throws IOException {
        if (this.out != null) {
            if (this.bufUsed != 0) {
                this.flushBuf();
            }
            this.out.close();
            this.out = null;
            this.buf = null;
        }
    }

    public void startElement(String string) throws IOException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.put((byte)60);
        this.writeRaw(string);
        this.inStartTag = true;
    }

    public void startAttribute(String string) throws IOException {
        if (!this.inStartTag) {
            throw new IllegalStateException("attribute outside of start-tag");
        }
        this.inStartTag = false;
        this.quoteWhitespace = true;
        this.put((byte)32);
        this.writeRaw(string);
        this.put((byte)61);
        this.put((byte)34);
    }

    private final void put(byte by) throws IOException {
        if (this.bufUsed == this.buf.length) {
            this.flushBuf();
        }
        this.buf[this.bufUsed++] = by;
    }

    private final void flushBuf() throws IOException {
        this.out.write(this.buf, 0, this.bufUsed);
        this.bufUsed = 0;
    }

    public UTF8XMLWriter(OutputStream outputStream, int n) {
        super(outputStream);
        this.out = outputStream;
        if ((n & 2) != 0) {
            this.minimizeEmptyElementsHtml = true;
            this.minimizeEmptyElements = true;
        } else if ((n & 1) != 0) {
            this.minimizeEmptyElements = true;
        }
        this.sysLineSeparator = this.lineSeparator = System.getProperty("line.separator");
    }

    public UTF8XMLWriter(OutputStream outputStream) {
        this(outputStream, 0);
    }

    public void endAttribute() throws IOException {
        this.put((byte)34);
        this.inStartTag = true;
        this.quoteWhitespace = false;
    }

    public void endElement(String string) throws IOException {
        if (this.inStartTag) {
            this.inStartTag = false;
            if (this.minimizeEmptyElements) {
                if (this.minimizeEmptyElementsHtml) {
                    this.put((byte)32);
                }
                this.put((byte)47);
                this.put((byte)62);
                return;
            }
            this.put((byte)62);
        }
        this.put((byte)60);
        this.put((byte)47);
        this.writeRaw(string);
        this.put((byte)62);
    }

    private void finishStartTag() throws IOException {
        this.inStartTag = false;
        this.put((byte)62);
    }

    public void startReplacementText() throws IOException {
        this.flushBuf();
        this.out = new ReplacementTextOutputStream(this.out);
        this.lineSeparator = "\n";
    }

    private final void writeMB(char c) throws IOException {
        switch (c & 0xF800) {
            case 0: {
                this.put((byte)(c >> 6 & 0x1F | 0xC0));
                this.put((byte)(c & 0x3F | 0x80));
                return;
            }
            default: {
                this.put((byte)(c >> 12 & 0xF | 0xE0));
                this.put((byte)(c >> 6 & 0x3F | 0x80));
                this.put((byte)(c & 0x3F | 0x80));
                return;
            }
            case 55296: 
        }
        throw new CharConversionException();
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        if (this.inStartTag) {
            this.finishStartTag();
        }
        do {
            try {
                this.writeQuote(cArray[n++]);
            }
            catch (CharConversionException charConversionException) {
                if (n2-- == 0) {
                    throw charConversionException;
                }
                this.writeSurrogatePair(cArray[n - 1], cArray[n]);
                ++n;
            }
        } while (--n2 > 0);
    }

    public void write(char c) throws IOException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.writeQuote(c);
    }

    public void write(String string) throws IOException {
        int n = string.length();
        if (n == 0) {
            return;
        }
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.writeQuote(string, 0, n);
    }

    public void write(String string, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.writeQuote(string, n, n2);
    }

    private final void writeQuote(String string, int n, int n2) throws IOException {
        while (n < n2) {
            try {
                this.writeQuote(string.charAt(n));
            }
            catch (CharConversionException charConversionException) {
                if (++n == n2) {
                    throw charConversionException;
                }
                this.writeSurrogatePair(string.charAt(n - 1), string.charAt(n));
            }
            ++n;
        }
    }

    private final void writeQuote(char c) throws IOException {
        switch (c) {
            case '\n': {
                this.writeRaw(this.quoteWhitespace ? "&#10;" : this.lineSeparator);
                return;
            }
            case '&': {
                this.writeRaw("&amp;");
                return;
            }
            case '<': {
                this.writeRaw("&lt;");
                return;
            }
            case '>': {
                this.writeRaw("&gt;");
                return;
            }
            case '\"': {
                this.writeRaw("&quot;");
                return;
            }
            case '\r': {
                if (this.quoteWhitespace || !(this.out instanceof ReplacementTextOutputStream)) {
                    this.writeRaw("&#13;");
                    return;
                }
                this.put((byte)13);
                return;
            }
            case '\t': {
                if (this.quoteWhitespace) {
                    this.writeRaw("&#9;");
                    return;
                }
                this.put((byte)9);
                return;
            }
        }
        if (c < '\u0080') {
            this.put((byte)c);
            return;
        }
        this.writeMB(c);
    }

    private void writeRaw(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < '\u0080') {
                this.put((byte)c);
            } else {
                try {
                    this.writeMB(string.charAt(n2));
                }
                catch (CharConversionException charConversionException) {
                    if (++n2 == n) {
                        throw charConversionException;
                    }
                    this.writeSurrogatePair(c, string.charAt(n2));
                }
            }
            ++n2;
        }
    }

    public void comment(String string) throws IOException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.writeRaw("<!--");
        this.writeMarkup(string);
        this.writeRaw("-->");
    }

    public void endReplacementText() throws IOException {
        this.flushBuf();
        this.out = ((ReplacementTextOutputStream)this.out).getOutputStream();
        if (!(this.out instanceof ReplacementTextOutputStream)) {
            this.lineSeparator = this.sysLineSeparator;
        }
    }

    public void writeUTF8(byte[] byArray, int n, int n2) throws IOException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        while (--n2 >= 0) {
            byte by = byArray[n++];
            switch (by) {
                case 10: {
                    this.writeRaw(this.lineSeparator);
                    break;
                }
                case 38: {
                    this.writeRaw("&amp;");
                    break;
                }
                case 60: {
                    this.writeRaw("&lt;");
                    break;
                }
                case 62: {
                    this.writeRaw("&gt;");
                    break;
                }
                case 34: {
                    this.writeRaw("&quot;");
                    break;
                }
                default: {
                    this.put(by);
                }
            }
        }
    }

    private void writeMarkup(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\n') {
                this.writeRaw(this.lineSeparator);
            } else {
                try {
                    if (c < '\u0080') {
                        this.put((byte)c);
                    } else {
                        this.writeMB(c);
                    }
                }
                catch (CharConversionException charConversionException) {
                    if (++n2 == n) {
                        throw charConversionException;
                    }
                    this.writeSurrogatePair(c, string.charAt(n2));
                }
            }
            ++n2;
        }
    }

    public void markup(String string) throws IOException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.writeMarkup(string);
    }

    public void flush() throws IOException {
        if (this.bufUsed != 0) {
            this.flushBuf();
        }
        this.out.flush();
    }

    public void attribute(String string, String string2) throws IOException {
        if (!this.inStartTag) {
            throw new IllegalStateException("attribute outside of start-tag");
        }
        this.put((byte)32);
        this.writeRaw(string);
        this.put((byte)61);
        this.put((byte)34);
        this.quoteWhitespace = true;
        this.writeQuote(string2, 0, string2.length());
        this.quoteWhitespace = false;
        this.put((byte)34);
    }

    public void processingInstruction(String string, String string2) throws IOException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.put((byte)60);
        this.put((byte)63);
        this.writeRaw(string);
        if (string2.length() > 0) {
            this.put((byte)32);
            this.writeMarkup(string2);
        }
        this.put((byte)63);
        this.put((byte)62);
    }

    private static class ReplacementTextOutputStream
    extends OutputStream {
        private OutputStream out;

        public void close() throws IOException {
            this.out.close();
        }

        ReplacementTextOutputStream(OutputStream outputStream) {
            this.out = outputStream;
        }

        OutputStream getOutputStream() {
            return this.out;
        }

        public void write(int n) throws IOException {
            switch (n) {
                case 13: 
                case 34: 
                case 37: 
                case 38: 
                case 39: {
                    this.out.write(38);
                    this.out.write(35);
                    String string = Integer.toString(n);
                    int n2 = 0;
                    while (n2 < string.length()) {
                        this.out.write(string.charAt(n2));
                        ++n2;
                    }
                    this.out.write(59);
                    return;
                }
            }
            this.out.write(n);
        }

        public void flush() throws IOException {
            this.out.flush();
        }
    }
}

