/*
 * Decompiled with CFR 0.152.
 */
package com.gokgs.client.swing.plaf;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;
import org.igoweb.go.swing.StoneImages;
import org.igoweb.util.swing.ArrowIcon;

public class ScrollBarUI
extends MetalScrollBarUI {
    private static final int MAX_SIZE = 64;
    private BufferedImage top;
    private BufferedImage middle;
    private BufferedImage bottom;
    private int size = -1;

    public static ComponentUI createUI(JComponent c) {
        return new ScrollBarUI();
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        int sbw = (Integer)UIManager.get("ScrollBar.width") - 4;
        return new JButton(new ArrowIcon(sbw, orientation >> 1));
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        int sbw = (Integer)UIManager.get("ScrollBar.width") - 4;
        return new JButton(new ArrowIcon(sbw, orientation >> 1));
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        int w;
        int orient = ((JScrollBar)c).getOrientation();
        int n = w = orient == 1 ? c.getWidth() : c.getHeight();
        if (w < 2) {
            return;
        }
        if (this.size != w) {
            this.newImages(w, orient);
            this.size = w;
        }
        g.drawImage(this.top, thumbBounds.x, thumbBounds.y, null);
        int topSize = w + 1 >> 1;
        if (orient == 1) {
            if (thumbBounds.height > w) {
                Shape oldClip = g.getClip();
                g.clipRect(thumbBounds.x, thumbBounds.y + topSize, w, thumbBounds.height - w);
                for (int y = thumbBounds.y + topSize; y < thumbBounds.y + thumbBounds.height - this.bottom.getHeight(); y += 64) {
                    g.drawImage(this.middle, thumbBounds.x, y, null);
                }
                g.setClip(oldClip);
            }
            g.drawImage(this.bottom, thumbBounds.x, thumbBounds.y + thumbBounds.height - this.bottom.getHeight(), null);
        } else {
            if (thumbBounds.width > w) {
                Shape oldClip = g.getClip();
                g.clipRect(thumbBounds.x + topSize, thumbBounds.y, thumbBounds.width - w, thumbBounds.height);
                for (int x = thumbBounds.x + topSize; x < thumbBounds.x + thumbBounds.width - this.bottom.getWidth(); x += 64) {
                    g.drawImage(this.middle, x, thumbBounds.y, null);
                }
                g.setClip(oldClip);
            }
            g.drawImage(this.bottom, thumbBounds.x + thumbBounds.width - this.bottom.getWidth(), thumbBounds.y, null);
        }
    }

    private void newImages(int w, int orientation) {
        boolean isVert;
        if (w == 0) {
            return;
        }
        boolean bl = isVert = orientation == 1;
        if (isVert) {
            this.top = new BufferedImage(w, w + 1 >> 1, 2);
            this.bottom = new BufferedImage(w, w >> 1, 2);
            this.middle = new BufferedImage(w, 64, 1);
        } else {
            this.top = new BufferedImage(w + 1 >> 1, w, 2);
            this.bottom = new BufferedImage(w >> 1, w, 2);
            this.middle = new BufferedImage(64, w, 1);
        }
        BufferedImage bigImg = new BufferedImage(w, w, 2);
        for (int x = 0; x < w; ++x) {
            int y;
            int color = (int)((StoneImages.getBrightness(w, (double)w * 0.5, (double)x + 0.25, null) + StoneImages.getBrightness(w, (double)w * 0.5, (double)x + 0.75, null)) * 0.5);
            color |= color << 16 | color << 8;
            for (y = 0; y < 64; ++y) {
                if (isVert) {
                    this.middle.setRGB(x, y, color);
                    continue;
                }
                this.middle.setRGB(y, x, color);
            }
            for (y = 0; y < w; ++y) {
                bigImg.setRGB(x, y, 0xFF000000 | StoneImages.getColor(w, x, y, null));
            }
        }
        Graphics2D g2d = bigImg.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setComposite(AlphaComposite.getInstance(1));
        Area stoneClip = new Area(new Rectangle2D.Double(0.0, 0.0, w, w));
        stoneClip.subtract(new Area(new Ellipse2D.Double(0.0, 0.0, w, w)));
        g2d.fill(stoneClip);
        int botOffX = w - this.bottom.getWidth();
        int botOffY = w - this.bottom.getHeight();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < w; ++y) {
                if (x < this.top.getWidth() && y < this.top.getHeight()) {
                    this.top.setRGB(x, y, bigImg.getRGB(x, y));
                }
                if (x < botOffX || y < botOffY) continue;
                this.bottom.setRGB(x - botOffX, y - botOffY, bigImg.getRGB(x, y));
            }
        }
        bigImg.flush();
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.setColor(c.getBackground());
        g.draw3DRect(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, false);
    }
}

