require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SPARC_PMAP_H_)) {
    eval 'sub _SPARC_PMAP_H_ () {1;}' unless defined(&_SPARC_PMAP_H_);
    if(defined(&_KERNEL_OPT)) {
	require './sparc/opt_sparc_arch.ph';
    }
    require 'uvm/uvm_prot.ph';
    require 'uvm/uvm_pmap.ph';
    require 'sparc/pte.ph';
    eval 'sub NKREG () {(((- &KERNBASE) /  &NBPRG));}' unless defined(&NKREG);
    eval 'sub NUREG () {(256-  &NKREG);}' unless defined(&NUREG);
    eval 'sub PMAP_USERCACHECLEAN () {1;}' unless defined(&PMAP_USERCACHECLEAN);
    if(defined(&_KERNEL)) {
	eval 'sub PMAP_NULL () {(( &pmap_t)0);}' unless defined(&PMAP_NULL);
	eval 'sub PMAP_OBIO () {1;}' unless defined(&PMAP_OBIO);
	eval 'sub PMAP_VME16 () {2;}' unless defined(&PMAP_VME16);
	eval 'sub PMAP_VME32 () {3;}' unless defined(&PMAP_VME32);
	eval 'sub PMAP_NC () {4;}' unless defined(&PMAP_NC);
	eval 'sub PMAP_TNC_4 () {7;}' unless defined(&PMAP_TNC_4);
	eval 'sub PMAP_T2PTE_4 {
	    my($x) = @_;
    	    eval q(((($x) &  &PMAP_TNC_4) <<  &PG_TNC_SHIFT));
	}' unless defined(&PMAP_T2PTE_4);
	eval 'sub PMAP_IOENC_4 {
	    my($io) = @_;
    	    eval q(($io));
	}' unless defined(&PMAP_IOENC_4);
	eval 'sub PMAP_TYPE_SRMMU () {0x78;}' unless defined(&PMAP_TYPE_SRMMU);
	eval 'sub PMAP_PTESHFT_SRMMU () {25;}' unless defined(&PMAP_PTESHFT_SRMMU);
	eval 'sub PMAP_SHFT_SRMMU () {3;}' unless defined(&PMAP_SHFT_SRMMU);
	eval 'sub PMAP_TNC_SRMMU () {127;}' unless defined(&PMAP_TNC_SRMMU);
	eval 'sub PMAP_T2PTE_SRMMU {
	    my($x) = @_;
    	    eval q(((($x) &  &PMAP_TYPE_SRMMU) <<  &PMAP_PTESHFT_SRMMU));
	}' unless defined(&PMAP_T2PTE_SRMMU);
	eval 'sub PMAP_IOENC_SRMMU {
	    my($io) = @_;
    	    eval q((($io) <<  &PMAP_SHFT_SRMMU));
	}' unless defined(&PMAP_IOENC_SRMMU);
	eval 'sub PMAP_IOENC {
	    my($io) = @_;
    	    eval q(( &CPU_HAS_SRMMU ?  &PMAP_IOENC_SRMMU($io) :  &PMAP_IOENC_4($io)));
	}' unless defined(&PMAP_IOENC);
	eval 'sub pmap_resident_count {
	    my($pm) = @_;
    	    eval q((($pm)-> ($pm_stats->{resident_count})));
	}' unless defined(&pmap_resident_count);
	eval 'sub pmap_wired_count {
	    my($pm) = @_;
    	    eval q((($pm)-> ($pm_stats->{wired_count})));
	}' unless defined(&pmap_wired_count);
	eval 'sub PMAP_PREFER {
	    my($fo, $ap, $sz, $td) = @_;
    	    eval q( &pmap_prefer(($fo), ($ap), ($sz), ($td)));
	}' unless defined(&PMAP_PREFER);
	eval 'sub PMAP_EXCLUDE_DECLS () {1;}' unless defined(&PMAP_EXCLUDE_DECLS);
	eval 'sub pmap_phys_address {
	    my($x) = @_;
    	    eval q(($x));
	}' unless defined(&pmap_phys_address);
	eval 'sub pmap_update {
	    my($pmap) = @_;
    	    eval q( &__USE($pmap));
	}' unless defined(&pmap_update);
	if(defined(&PMAP_GROWKERNEL)) {
	}
	eval 'sub pmap_mmap_flags {
	    my($x) = @_;
    	    eval q(0);
	}' unless defined(&pmap_mmap_flags);
	if(defined(&SUN4) || defined(&SUN4C)) {
	}
	if(defined(&SUN4M) || defined(&SUN4D)) {
	}
	if(!(defined(&SUN4M) || defined(&SUN4D))  && (defined(&SUN4) || defined(&SUN4C))) {
	    eval 'sub pmap_clear_modify () { &pmap_clear_modify4_4c;}' unless defined(&pmap_clear_modify);
	    eval 'sub pmap_clear_reference () { &pmap_clear_reference4_4c;}' unless defined(&pmap_clear_reference);
	    eval 'sub pmap_enter () { &pmap_enter4_4c;}' unless defined(&pmap_enter);
	    eval 'sub pmap_extract () { &pmap_extract4_4c;}' unless defined(&pmap_extract);
	    eval 'sub pmap_is_modified () { &pmap_is_modified4_4c;}' unless defined(&pmap_is_modified);
	    eval 'sub pmap_is_referenced () { &pmap_is_referenced4_4c;}' unless defined(&pmap_is_referenced);
	    eval 'sub pmap_kenter_pa () { &pmap_kenter_pa4_4c;}' unless defined(&pmap_kenter_pa);
	    eval 'sub pmap_kremove () { &pmap_kremove4_4c;}' unless defined(&pmap_kremove);
	    eval 'sub pmap_kprotect () { &pmap_kprotect4_4c;}' unless defined(&pmap_kprotect);
	    eval 'sub pmap_page_protect () { &pmap_page_protect4_4c;}' unless defined(&pmap_page_protect);
	    eval 'sub pmap_protect () { &pmap_protect4_4c;}' unless defined(&pmap_protect);
	}
 elsif((defined(&SUN4M) || defined(&SUN4D))  && !(defined(&SUN4) || defined(&SUN4C))) {
	    eval 'sub pmap_clear_modify () { &pmap_clear_modify4m;}' unless defined(&pmap_clear_modify);
	    eval 'sub pmap_clear_reference () { &pmap_clear_reference4m;}' unless defined(&pmap_clear_reference);
	    eval 'sub pmap_enter () { &pmap_enter4m;}' unless defined(&pmap_enter);
	    eval 'sub pmap_extract () { &pmap_extract4m;}' unless defined(&pmap_extract);
	    eval 'sub pmap_is_modified () { &pmap_is_modified4m;}' unless defined(&pmap_is_modified);
	    eval 'sub pmap_is_referenced () { &pmap_is_referenced4m;}' unless defined(&pmap_is_referenced);
	    eval 'sub pmap_kenter_pa () { &pmap_kenter_pa4m;}' unless defined(&pmap_kenter_pa);
	    eval 'sub pmap_kremove () { &pmap_kremove4m;}' unless defined(&pmap_kremove);
	    eval 'sub pmap_kprotect () { &pmap_kprotect4m;}' unless defined(&pmap_kprotect);
	    eval 'sub pmap_page_protect () { &pmap_page_protect4m;}' unless defined(&pmap_page_protect);
	    eval 'sub pmap_protect () { &pmap_protect4m;}' unless defined(&pmap_protect);
	} else {
	    eval 'sub pmap_clear_modify () {(* &pmap_clear_modify_p);}' unless defined(&pmap_clear_modify);
	    eval 'sub pmap_clear_reference () {(* &pmap_clear_reference_p);}' unless defined(&pmap_clear_reference);
	    eval 'sub pmap_enter () {(* &pmap_enter_p);}' unless defined(&pmap_enter);
	    eval 'sub pmap_extract () {(* &pmap_extract_p);}' unless defined(&pmap_extract);
	    eval 'sub pmap_is_modified () {(* &pmap_is_modified_p);}' unless defined(&pmap_is_modified);
	    eval 'sub pmap_is_referenced () {(* &pmap_is_referenced_p);}' unless defined(&pmap_is_referenced);
	    eval 'sub pmap_kenter_pa () {(* &pmap_kenter_pa_p);}' unless defined(&pmap_kenter_pa);
	    eval 'sub pmap_kremove () {(* &pmap_kremove_p);}' unless defined(&pmap_kremove);
	    eval 'sub pmap_kprotect () {(* &pmap_kprotect_p);}' unless defined(&pmap_kprotect);
	    eval 'sub pmap_page_protect () {(* &pmap_page_protect_p);}' unless defined(&pmap_page_protect);
	    eval 'sub pmap_protect () {(* &pmap_protect_p);}' unless defined(&pmap_protect);
	}
	eval 'sub pmap_zero_page () {(* ($cpuinfo->{zero_page}));}' unless defined(&pmap_zero_page);
	eval 'sub pmap_copy_page () {(* ($cpuinfo->{copy_page}));}' unless defined(&pmap_copy_page);
	if(defined(&SUN4M) || defined(&SUN4D)) {
	    eval 'sub tlb_flush_page_real {
	        my($va) = @_;
    		eval q( &sta((( &vaddr_t)($va) & 0xfffff000) |  &ASI_SRMMUFP_L3,  &ASI_SRMMUFP, 0));
	    }' unless defined(&tlb_flush_page_real);
	    eval 'sub tlb_flush_segment_real {
	        my($va) = @_;
    		eval q( &sta((( &vaddr_t)($va) & 0xfffc0000) |  &ASI_SRMMUFP_L2,  &ASI_SRMMUFP, 0));
	    }' unless defined(&tlb_flush_segment_real);
	    eval 'sub tlb_flush_region_real {
	        my($va) = @_;
    		eval q( &sta((( &vaddr_t)($va) & 0xff000000) |  &ASI_SRMMUFP_L1,  &ASI_SRMMUFP, 0));
	    }' unless defined(&tlb_flush_region_real);
	    eval 'sub tlb_flush_context_real () {
	        eval q( &sta( &ASI_SRMMUFP_L0,  &ASI_SRMMUFP, 0));
	    }' unless defined(&tlb_flush_context_real);
	    eval 'sub tlb_flush_all_real () {
	        eval q( &sta( &ASI_SRMMUFP_LN,  &ASI_SRMMUFP, 0));
	    }' unless defined(&tlb_flush_all_real);
	}
	eval 'sub __HAVE_VM_PAGE_MD () {1;}' unless defined(&__HAVE_VM_PAGE_MD);
	eval 'sub VM_MDPAGE_PVHEAD {
	    my($pg) = @_;
    	    eval q((($pg)-> ($mdpage->{pvlisthead})));
	}' unless defined(&VM_MDPAGE_PVHEAD);
	eval 'sub VM_MDPAGE_INIT {
	    my($pg) = @_;
    	    eval q( &do { ($pg)-> ($mdpage->{pvlisthead}->{pv_next}) =  &NULL; ($pg)-> ($mdpage->{pvlisthead}->{pv_pmap}) =  &NULL; ($pg)-> ($mdpage->{pvlisthead}->{pv_va}) = 0; ($pg)-> ($mdpage->{pvlisthead}->{pv_flags}) = 0; }  &while( 0));
	}' unless defined(&VM_MDPAGE_INIT);
    }
}
1;
