#    Jools -- a graphical puzzle game in the Tetris tradition
#    
#    Copyright (C) 2002-2003 Paul Pelzl
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# timer.py
# Provides graphics and gameplay functions associated with a game timer.


import pygame
from initialize import *
from globals import *

class Timer:

   def __init__(self):
      self.gradient  = timerImage
      self.rect      = timerRect
      self.timer_dec = TIMER_DECREMENT


   def new(self, xpos, ypos):
      self.rect.left = xpos
      self.rect.top  = ypos

      # Generate the "mask" that is drawn on top of the parts of the timer
      # that have disappeared
      self.mask      = pygame.Surface((self.rect.width, self.rect.height))
      self.mask.convert()
      self.mask.fill((1,1,1))                      # FIXME: change to blit from background
      self.mask_rect = pygame.Rect(self.rect)
      self.mask_rect.height = 0                    # Initially the mask covers nothing

      self.time     = float(MAXTIME)

   def draw_border(self, screen):
      self.border    = pygame.Surface((self.rect.width+8, self.rect.height+8))
      self.border.convert()
      self.border.fill((100,100,100))
      
      border_inner   = pygame.Surface((self.rect.width+4, self.rect.height+4))
      border_inner.convert()
      border_inner.fill((1,1,1))
      self.border.blit(border_inner, (2, 2))

      screen.blit(self.border, (self.rect.left-4, self.rect.top-4))
      pygame.display.update(self.rect.left-4, self.rect.top-4, self.rect.width+8, self.rect.height+8)


   # Call this like "pygame.display.update(timer.draw())", for example
   def draw(self,screen):
      screen.blit(self.gradient, self.rect)
      screen.blit(self.mask, self.mask_rect, (0, 0, self.mask_rect.width, self.mask_rect.height))
      pygame.display.update(self.rect)
      return self.rect

       
   # Time is passing...
   def tick(self):
      self.time -= self.timer_dec

      if self.time < 0:
         self.time = 0

      # Update the mask to reflect the time change
      timer_height = int(float(self.rect.height) * self.time / float(MAXTIME))
      if timer_height < 0:
         timer_height = 0
      self.mask_rect.height = self.rect.height - timer_height

      pygame.display.update(self.draw(screen))


   # Time is boosted (presumably due to scoring points)
   def boost(self, quantity):
      self.time += float(quantity)
      if int(self.time) >= MAXTIME:
         self.time = float(MAXTIME)
       
      # Update the mask to reflect the time change
      timer_height = int(float(self.rect.height) * self.time / float(MAXTIME))
      if timer_height < 0:
         timer_height = 0
      self.mask_rect.height = self.rect.height - timer_height

      pygame.display.update(self.draw(screen))




# arch-tag: timer display

