/*
 * Decompiled with CFR 0.152.
 */
package kafka.security;

import java.util.Collection;
import java.util.Properties;
import kafka.security.CredentialProvider$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.ScramCredentialUtils;
import org.apache.kafka.common.security.scram.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.DelegationTokenCache;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001\u000f\t\u00112I]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s\u0015\t\u0019A!\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007\u0002C\b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\t\u0002\u001fM\u001c'/Y7NK\u000eD\u0017M\\5t[N\u00042!\u0005\f\u0019\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011)H/\u001b7\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u000b\u0007>dG.Z2uS>t\u0007CA\r!\u001d\tQb\u0004\u0005\u0002\u001c\u00155\tAD\u0003\u0002\u001e\r\u00051AH]8pizJ!a\b\u0006\u0002\rA\u0013X\rZ3g\u0013\t\t#E\u0001\u0004TiJLgn\u001a\u0006\u0003?)A\u0001\u0002\n\u0001\u0003\u0006\u0004%\t!J\u0001\u000bi>\\WM\\\"bG\",W#\u0001\u0014\u0011\u0005\u001d\"T\"\u0001\u0015\u000b\u0005%R\u0013A\u00033fY\u0016<\u0017\r^5p]*\u00111\u0006L\u0001\u0006i>\\WM\u001c\u0006\u0003\u00075R!AL\u0018\u0002\r\r|W.\\8o\u0015\t)\u0001G\u0003\u00022e\u00051\u0011\r]1dQ\u0016T\u0011aM\u0001\u0004_J<\u0017BA\u001b)\u0005Q!U\r\\3hCRLwN\u001c+pW\u0016t7)Y2iK\"Aq\u0007\u0001B\u0001B\u0003%a%A\u0006u_.,gnQ1dQ\u0016\u0004\u0003\"B\u001d\u0001\t\u0003Q\u0014A\u0002\u001fj]&$h\bF\u0002<{y\u0002\"\u0001\u0010\u0001\u000e\u0003\tAQa\u0004\u001dA\u0002AAQ\u0001\n\u001dA\u0002\u0019Bq\u0001\u0011\u0001C\u0002\u0013\u0005\u0011)A\bde\u0016$WM\u001c;jC2\u001c\u0015m\u00195f+\u0005\u0011\u0005CA\"G\u001b\u0005!%BA#-\u00035\tW\u000f\u001e5f]RL7-\u0019;pe&\u0011q\t\u0012\u0002\u0010\u0007J,G-\u001a8uS\u0006d7)Y2iK\"1\u0011\n\u0001Q\u0001\n\t\u000b\u0001c\u0019:fI\u0016tG/[1m\u0007\u0006\u001c\u0007.\u001a\u0011\t\u000b-\u0003A\u0011\u0001'\u0002#U\u0004H-\u0019;f\u0007J,G-\u001a8uS\u0006d7\u000fF\u0002N!J\u0003\"!\u0003(\n\u0005=S!\u0001B+oSRDQ!\u0015&A\u0002a\t\u0001\"^:fe:\fW.\u001a\u0005\u0006'*\u0003\r\u0001V\u0001\u0007G>tg-[4\u0011\u0005E)\u0016B\u0001,\u0013\u0005)\u0001&o\u001c9feRLWm]\u0004\u00061\nA\t!W\u0001\u0013\u0007J,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'\u000f\u0005\u0002=5\u001a)\u0011A\u0001E\u00017N\u0011!\f\u0003\u0005\u0006si#\t!\u0018\u000b\u00023\")qL\u0017C\u0001A\u0006)Ro]3s\u0007J,G-\u001a8uS\u0006d7i\u001c8gS\u001e\u001cX#A1\u0011\u0005\t$W\"A2\u000b\u0005Mk\u0013BA3d\u0005%\u0019uN\u001c4jO\u0012+g\r")
public class CredentialProvider {
    private final DelegationTokenCache tokenCache;
    private final CredentialCache credentialCache;

    public static ConfigDef userCredentialConfigs() {
        return CredentialProvider$.MODULE$.userCredentialConfigs();
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public CredentialCache credentialCache() {
        return this.credentialCache;
    }

    public void updateCredentials(String username, Properties config) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values())).foreach((Function1 & java.io.Serializable & Serializable)mechanism -> {
            BoxedUnit boxedUnit;
            CredentialCache.Cache cache = this.credentialCache().cache(mechanism.mechanismName(), ScramCredential.class);
            if (cache != null) {
                String string = config.getProperty(mechanism.mechanismName());
                ScramCredential scramCredential = string == null ? (ScramCredential)cache.remove(username) : (ScramCredential)cache.put(username, (Object)ScramCredentialUtils.credentialFromString((String)string));
                boxedUnit = scramCredential;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    public CredentialProvider(Collection<String> scramMechanisms, DelegationTokenCache tokenCache) {
        this.tokenCache = tokenCache;
        this.credentialCache = new CredentialCache();
        ScramCredentialUtils.createCache((CredentialCache)this.credentialCache(), scramMechanisms);
    }
}

