/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.containers.ConcurrentSoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.WeakHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class CollectionFactory {
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap() {
        return new ConcurrentWeakHashMap(0.75f);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftValueMap() {
        return new ConcurrentSoftValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakIdentityMap() {
        return new ConcurrentWeakHashMap(HashingStrategy.identity());
    }

    @NotNull
    public static <K, V> Map<K, V> createWeakIdentityMap(int initialCapacity, float loadFactor) {
        return new WeakHashMap(initialCapacity, loadFactor, HashingStrategy.identity());
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(List<CharSequence> items) {
        return new ObjectOpenCustomHashSet<CharSequence>(items, FastUtilHashingStrategies.getCharSequenceStrategy(true));
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet() {
        return new ObjectOpenCustomHashSet<String>(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap() {
        return new Object2ObjectOpenCustomHashMap(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathSet() {
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return new HashSet<String>();
        }
        return CollectionFactory.createCaseInsensitiveStringSet();
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap() {
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return new HashMap();
        }
        return CollectionFactory.createCaseInsensitiveStringMap();
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap() {
        return new Object2ObjectOpenHashMap();
    }

    @Contract(value="_-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintSet(int expected) {
        return new ObjectOpenHashSet(expected);
    }
}

