/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.rcache;

import java.util.Objects;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.internal.rcache.AuthTime;

public class AuthTimeWithHash
extends AuthTime
implements Comparable<AuthTimeWithHash> {
    public static final String DEFAULT_HASH_ALG = GetPropertyAction.privilegedGetProperty("jdk.krb5.rcache.useMD5", "false").equals("true") ? "HASH" : "SHA256";
    final String hashAlg;
    final String hash;

    public static String realAlg(String string) {
        switch (string) {
            case "HASH": {
                return "MD5";
            }
            case "SHA256": {
                return "SHA-256";
            }
        }
        throw new AssertionError((Object)(string + " is not HASH or SHA256"));
    }

    public AuthTimeWithHash(String string, String string2, int n, int n2, String string3, String string4) {
        super(string, string2, n, n2);
        this.hashAlg = string3;
        this.hash = string4;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AuthTimeWithHash)) {
            return false;
        }
        AuthTimeWithHash authTimeWithHash = (AuthTimeWithHash)object;
        return Objects.equals(this.hash, authTimeWithHash.hash) && Objects.equals(this.hashAlg, authTimeWithHash.hashAlg) && Objects.equals(this.client, authTimeWithHash.client) && Objects.equals(this.server, authTimeWithHash.server) && this.ctime == authTimeWithHash.ctime && this.cusec == authTimeWithHash.cusec;
    }

    public int hashCode() {
        return Objects.hash(this.hash);
    }

    @Override
    public String toString() {
        return String.format("%d/%06d/%s/%s", this.ctime, this.cusec, this.hash, this.client);
    }

    @Override
    public int compareTo(AuthTimeWithHash authTimeWithHash) {
        int n = 0;
        n = this.ctime != authTimeWithHash.ctime ? Integer.compare(this.ctime, authTimeWithHash.ctime) : (this.cusec != authTimeWithHash.cusec ? Integer.compare(this.cusec, authTimeWithHash.cusec) : this.hash.compareTo(authTimeWithHash.hash));
        return n;
    }

    public boolean sameTimeDiffHash(AuthTimeWithHash authTimeWithHash) {
        if (!this.isSameIgnoresHash(authTimeWithHash)) {
            return false;
        }
        return this.hashAlg.equals(authTimeWithHash.hashAlg) && !this.hash.equals(authTimeWithHash.hash);
    }

    public boolean isSameIgnoresHash(AuthTime authTime) {
        return this.client.equals(authTime.client) && this.server.equals(authTime.server) && this.ctime == authTime.ctime && this.cusec == authTime.cusec;
    }

    @Override
    public byte[] encode(boolean bl) {
        String string;
        String string2;
        if (bl) {
            string2 = "";
            string = String.format("%s:%s %d:%s %d:%s", this.hashAlg, this.hash, this.client.length(), this.client, this.server.length(), this.server);
        } else {
            string2 = this.client;
            string = this.server;
        }
        return this.encode0(string2, string);
    }
}

