/*! third party licenses: js/vendor.LICENSE.txt */
const appName = "viewer";
const appVersion = "2.3.0";
const global$j = globalThis || void 0 || self;
var define_global_process_env_default = {};
/*!
 * Vue.js v2.7.16
 * (c) 2014-2023 Evan You
 * Released under the MIT License.
 */
var emptyObject = Object.freeze({});
var isArray$5 = Array.isArray;
function isUndef(v2) {
  return v2 === void 0 || v2 === null;
}
function isDef(v2) {
  return v2 !== void 0 && v2 !== null;
}
function isTrue(v2) {
  return v2 === true;
}
function isFalse(v2) {
  return v2 === false;
}
function isPrimitive(value3) {
  return typeof value3 === "string" || typeof value3 === "number" || // $flow-disable-line
  typeof value3 === "symbol" || typeof value3 === "boolean";
}
function isFunction$2(value3) {
  return typeof value3 === "function";
}
function isObject$f(obj) {
  return obj !== null && typeof obj === "object";
}
var _toString = Object.prototype.toString;
function toRawType(value3) {
  return _toString.call(value3).slice(8, -1);
}
function isPlainObject$1(obj) {
  return _toString.call(obj) === "[object Object]";
}
function isRegExp$1(v2) {
  return _toString.call(v2) === "[object RegExp]";
}
function isValidArrayIndex(val2) {
  var n2 = parseFloat(String(val2));
  return n2 >= 0 && Math.floor(n2) === n2 && isFinite(val2);
}
function isPromise(val2) {
  return isDef(val2) && typeof val2.then === "function" && typeof val2.catch === "function";
}
function toString$f(val2) {
  return val2 == null ? "" : Array.isArray(val2) || isPlainObject$1(val2) && val2.toString === _toString ? JSON.stringify(val2, replacer, 2) : String(val2);
}
function replacer(_key2, val2) {
  if (val2 && val2.__v_isRef) {
    return val2.value;
  }
  return val2;
}
function toNumber$1(val2) {
  var n2 = parseFloat(val2);
  return isNaN(n2) ? val2 : n2;
}
function makeMap(str, expectsLowerCase) {
  var map = /* @__PURE__ */ Object.create(null);
  var list2 = str.split(",");
  for (var i2 = 0; i2 < list2.length; i2++) {
    map[list2[i2]] = true;
  }
  return expectsLowerCase ? function(val2) {
    return map[val2.toLowerCase()];
  } : function(val2) {
    return map[val2];
  };
}
makeMap("slot,component", true);
var isReservedAttribute = makeMap("key,ref,slot,slot-scope,is");
function remove$2(arr, item) {
  var len = arr.length;
  if (len) {
    if (item === arr[len - 1]) {
      arr.length = len - 1;
      return;
    }
    var index2 = arr.indexOf(item);
    if (index2 > -1) {
      return arr.splice(index2, 1);
    }
  }
}
var hasOwnProperty$4 = Object.prototype.hasOwnProperty;
function hasOwn$g(obj, key) {
  return hasOwnProperty$4.call(obj, key);
}
function cached(fn) {
  var cache = /* @__PURE__ */ Object.create(null);
  return function cachedFn(str) {
    var hit = cache[str];
    return hit || (cache[str] = fn(str));
  };
}
var camelizeRE = /-(\w)/g;
var camelize = cached(function(str) {
  return str.replace(camelizeRE, function(_2, c2) {
    return c2 ? c2.toUpperCase() : "";
  });
});
var capitalize = cached(function(str) {
  return str.charAt(0).toUpperCase() + str.slice(1);
});
var hyphenateRE = /\B([A-Z])/g;
var hyphenate = cached(function(str) {
  return str.replace(hyphenateRE, "-$1").toLowerCase();
});
function polyfillBind(fn, ctx) {
  function boundFn(a3) {
    var l2 = arguments.length;
    return l2 ? l2 > 1 ? fn.apply(ctx, arguments) : fn.call(ctx, a3) : fn.call(ctx);
  }
  boundFn._length = fn.length;
  return boundFn;
}
function nativeBind(fn, ctx) {
  return fn.bind(ctx);
}
var bind$4 = Function.prototype.bind ? nativeBind : polyfillBind;
function toArray$1(list2, start) {
  start = start || 0;
  var i2 = list2.length - start;
  var ret = new Array(i2);
  while (i2--) {
    ret[i2] = list2[i2 + start];
  }
  return ret;
}
function extend$2(to, _from) {
  for (var key in _from) {
    to[key] = _from[key];
  }
  return to;
}
function toObject$7(arr) {
  var res = {};
  for (var i2 = 0; i2 < arr.length; i2++) {
    if (arr[i2]) {
      extend$2(res, arr[i2]);
    }
  }
  return res;
}
function noop$6(a3, b2, c2) {
}
var no = function(a3, b2, c2) {
  return false;
};
var identity = function(_2) {
  return _2;
};
function looseEqual(a3, b2) {
  if (a3 === b2)
    return true;
  var isObjectA = isObject$f(a3);
  var isObjectB = isObject$f(b2);
  if (isObjectA && isObjectB) {
    try {
      var isArrayA = Array.isArray(a3);
      var isArrayB = Array.isArray(b2);
      if (isArrayA && isArrayB) {
        return a3.length === b2.length && a3.every(function(e2, i2) {
          return looseEqual(e2, b2[i2]);
        });
      } else if (a3 instanceof Date && b2 instanceof Date) {
        return a3.getTime() === b2.getTime();
      } else if (!isArrayA && !isArrayB) {
        var keysA = Object.keys(a3);
        var keysB = Object.keys(b2);
        return keysA.length === keysB.length && keysA.every(function(key) {
          return looseEqual(a3[key], b2[key]);
        });
      } else {
        return false;
      }
    } catch (e2) {
      return false;
    }
  } else if (!isObjectA && !isObjectB) {
    return String(a3) === String(b2);
  } else {
    return false;
  }
}
function looseIndexOf(arr, val2) {
  for (var i2 = 0; i2 < arr.length; i2++) {
    if (looseEqual(arr[i2], val2))
      return i2;
  }
  return -1;
}
function once$1(fn) {
  var called = false;
  return function() {
    if (!called) {
      called = true;
      fn.apply(this, arguments);
    }
  };
}
function hasChanged(x3, y2) {
  if (x3 === y2) {
    return x3 === 0 && 1 / x3 !== 1 / y2;
  } else {
    return x3 === x3 || y2 === y2;
  }
}
var SSR_ATTR = "data-server-rendered";
var ASSET_TYPES = ["component", "directive", "filter"];
var LIFECYCLE_HOOKS = [
  "beforeCreate",
  "created",
  "beforeMount",
  "mounted",
  "beforeUpdate",
  "updated",
  "beforeDestroy",
  "destroyed",
  "activated",
  "deactivated",
  "errorCaptured",
  "serverPrefetch",
  "renderTracked",
  "renderTriggered"
];
var config$2 = {
  /**
   * Option merge strategies (used in core/util/options)
   */
  // $flow-disable-line
  optionMergeStrategies: /* @__PURE__ */ Object.create(null),
  /**
   * Whether to suppress warnings.
   */
  silent: false,
  /**
   * Show production mode tip message on boot?
   */
  productionTip: false,
  /**
   * Whether to enable devtools
   */
  devtools: false,
  /**
   * Whether to record perf
   */
  performance: false,
  /**
   * Error handler for watcher errors
   */
  errorHandler: null,
  /**
   * Warn handler for watcher warns
   */
  warnHandler: null,
  /**
   * Ignore certain custom elements
   */
  ignoredElements: [],
  /**
   * Custom user key aliases for v-on
   */
  // $flow-disable-line
  keyCodes: /* @__PURE__ */ Object.create(null),
  /**
   * Check if a tag is reserved so that it cannot be registered as a
   * component. This is platform-dependent and may be overwritten.
   */
  isReservedTag: no,
  /**
   * Check if an attribute is reserved so that it cannot be used as a component
   * prop. This is platform-dependent and may be overwritten.
   */
  isReservedAttr: no,
  /**
   * Check if a tag is an unknown element.
   * Platform-dependent.
   */
  isUnknownElement: no,
  /**
   * Get the namespace of an element
   */
  getTagNamespace: noop$6,
  /**
   * Parse the real tag name for the specific platform.
   */
  parsePlatformTagName: identity,
  /**
   * Check if an attribute must be bound using property, e.g. value
   * Platform-dependent.
   */
  mustUseProp: no,
  /**
   * Perform updates asynchronously. Intended to be used by Vue Test Utils
   * This will significantly reduce performance if set to false.
   */
  async: true,
  /**
   * Exposed for legacy reasons
   */
  _lifecycleHooks: LIFECYCLE_HOOKS
};
var unicodeRegExp = /a-zA-Z\u00B7\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u037D\u037F-\u1FFF\u200C-\u200D\u203F-\u2040\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD/;
function isReserved(str) {
  var c2 = (str + "").charCodeAt(0);
  return c2 === 36 || c2 === 95;
}
function def(obj, key, val2, enumerable) {
  Object.defineProperty(obj, key, {
    value: val2,
    enumerable: !!enumerable,
    writable: true,
    configurable: true
  });
}
var bailRE = new RegExp("[^".concat(unicodeRegExp.source, ".$_\\d]"));
function parsePath$2(path2) {
  if (bailRE.test(path2)) {
    return;
  }
  var segments = path2.split(".");
  return function(obj) {
    for (var i2 = 0; i2 < segments.length; i2++) {
      if (!obj)
        return;
      obj = obj[segments[i2]];
    }
    return obj;
  };
}
var hasProto = "__proto__" in {};
var inBrowser$1 = typeof window !== "undefined";
var UA = inBrowser$1 && window.navigator.userAgent.toLowerCase();
var isIE$1 = UA && /msie|trident/.test(UA);
var isIE9 = UA && UA.indexOf("msie 9.0") > 0;
var isEdge = UA && UA.indexOf("edge/") > 0;
UA && UA.indexOf("android") > 0;
var isIOS$2 = UA && /iphone|ipad|ipod|ios/.test(UA);
var isFF = UA && UA.match(/firefox\/(\d+)/);
var nativeWatch = {}.watch;
var supportsPassive$1 = false;
if (inBrowser$1) {
  try {
    var opts = {};
    Object.defineProperty(opts, "passive", {
      get: function() {
        supportsPassive$1 = true;
      }
    });
    window.addEventListener("test-passive", null, opts);
  } catch (e2) {
  }
}
var _isServer;
var isServerRendering = function() {
  if (_isServer === void 0) {
    if (!inBrowser$1 && typeof global$j !== "undefined") {
      _isServer = global$j["process"] && define_global_process_env_default.VUE_ENV === "server";
    } else {
      _isServer = false;
    }
  }
  return _isServer;
};
var devtools = inBrowser$1 && window.__VUE_DEVTOOLS_GLOBAL_HOOK__;
function isNative(Ctor) {
  return typeof Ctor === "function" && /native code/.test(Ctor.toString());
}
var hasSymbol$1 = typeof Symbol !== "undefined" && isNative(Symbol) && typeof Reflect !== "undefined" && isNative(Reflect.ownKeys);
var _Set;
if (typeof Set !== "undefined" && isNative(Set)) {
  _Set = Set;
} else {
  _Set = /** @class */
  function() {
    function Set2() {
      this.set = /* @__PURE__ */ Object.create(null);
    }
    Set2.prototype.has = function(key) {
      return this.set[key] === true;
    };
    Set2.prototype.add = function(key) {
      this.set[key] = true;
    };
    Set2.prototype.clear = function() {
      this.set = /* @__PURE__ */ Object.create(null);
    };
    return Set2;
  }();
}
var currentInstance = null;
function getCurrentInstance() {
  return currentInstance && { proxy: currentInstance };
}
function setCurrentInstance(vm) {
  if (vm === void 0) {
    vm = null;
  }
  if (!vm)
    currentInstance && currentInstance._scope.off();
  currentInstance = vm;
  vm && vm._scope.on();
}
var VNode = (
  /** @class */
  function() {
    function VNode2(tag, data12, children, text3, elm, context, componentOptions, asyncFactory) {
      this.tag = tag;
      this.data = data12;
      this.children = children;
      this.text = text3;
      this.elm = elm;
      this.ns = void 0;
      this.context = context;
      this.fnContext = void 0;
      this.fnOptions = void 0;
      this.fnScopeId = void 0;
      this.key = data12 && data12.key;
      this.componentOptions = componentOptions;
      this.componentInstance = void 0;
      this.parent = void 0;
      this.raw = false;
      this.isStatic = false;
      this.isRootInsert = true;
      this.isComment = false;
      this.isCloned = false;
      this.isOnce = false;
      this.asyncFactory = asyncFactory;
      this.asyncMeta = void 0;
      this.isAsyncPlaceholder = false;
    }
    Object.defineProperty(VNode2.prototype, "child", {
      // DEPRECATED: alias for componentInstance for backwards compat.
      /* istanbul ignore next */
      get: function() {
        return this.componentInstance;
      },
      enumerable: false,
      configurable: true
    });
    return VNode2;
  }()
);
var createEmptyVNode = function(text3) {
  if (text3 === void 0) {
    text3 = "";
  }
  var node = new VNode();
  node.text = text3;
  node.isComment = true;
  return node;
};
function createTextVNode(val2) {
  return new VNode(void 0, void 0, void 0, String(val2));
}
function cloneVNode(vnode) {
  var cloned = new VNode(
    vnode.tag,
    vnode.data,
    // #7975
    // clone children array to avoid mutating original in case of cloning
    // a child.
    vnode.children && vnode.children.slice(),
    vnode.text,
    vnode.elm,
    vnode.context,
    vnode.componentOptions,
    vnode.asyncFactory
  );
  cloned.ns = vnode.ns;
  cloned.isStatic = vnode.isStatic;
  cloned.key = vnode.key;
  cloned.isComment = vnode.isComment;
  cloned.fnContext = vnode.fnContext;
  cloned.fnOptions = vnode.fnOptions;
  cloned.fnScopeId = vnode.fnScopeId;
  cloned.asyncMeta = vnode.asyncMeta;
  cloned.isCloned = true;
  return cloned;
}
typeof SuppressedError === "function" ? SuppressedError : function(error, suppressed, message) {
  var e2 = new Error(message);
  return e2.name = "SuppressedError", e2.error = error, e2.suppressed = suppressed, e2;
};
var uid$2$1 = 0;
var pendingCleanupDeps = [];
var cleanupDeps = function() {
  for (var i2 = 0; i2 < pendingCleanupDeps.length; i2++) {
    var dep = pendingCleanupDeps[i2];
    dep.subs = dep.subs.filter(function(s3) {
      return s3;
    });
    dep._pending = false;
  }
  pendingCleanupDeps.length = 0;
};
var Dep = (
  /** @class */
  function() {
    function Dep2() {
      this._pending = false;
      this.id = uid$2$1++;
      this.subs = [];
    }
    Dep2.prototype.addSub = function(sub) {
      this.subs.push(sub);
    };
    Dep2.prototype.removeSub = function(sub) {
      this.subs[this.subs.indexOf(sub)] = null;
      if (!this._pending) {
        this._pending = true;
        pendingCleanupDeps.push(this);
      }
    };
    Dep2.prototype.depend = function(info) {
      if (Dep2.target) {
        Dep2.target.addDep(this);
      }
    };
    Dep2.prototype.notify = function(info) {
      var subs = this.subs.filter(function(s3) {
        return s3;
      });
      for (var i2 = 0, l2 = subs.length; i2 < l2; i2++) {
        var sub = subs[i2];
        sub.update();
      }
    };
    return Dep2;
  }()
);
Dep.target = null;
var targetStack = [];
function pushTarget(target2) {
  targetStack.push(target2);
  Dep.target = target2;
}
function popTarget() {
  targetStack.pop();
  Dep.target = targetStack[targetStack.length - 1];
}
var arrayProto$1 = Array.prototype;
var arrayMethods = Object.create(arrayProto$1);
var methodsToPatch = [
  "push",
  "pop",
  "shift",
  "unshift",
  "splice",
  "sort",
  "reverse"
];
methodsToPatch.forEach(function(method) {
  var original = arrayProto$1[method];
  def(arrayMethods, method, function mutator() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
      args[_i] = arguments[_i];
    }
    var result = original.apply(this, args);
    var ob = this.__ob__;
    var inserted;
    switch (method) {
      case "push":
      case "unshift":
        inserted = args;
        break;
      case "splice":
        inserted = args.slice(2);
        break;
    }
    if (inserted)
      ob.observeArray(inserted);
    {
      ob.dep.notify();
    }
    return result;
  });
});
var arrayKeys = Object.getOwnPropertyNames(arrayMethods);
var NO_INITIAL_VALUE = {};
var shouldObserve = true;
function toggleObserving(value3) {
  shouldObserve = value3;
}
var mockDep = {
  notify: noop$6,
  depend: noop$6,
  addSub: noop$6,
  removeSub: noop$6
};
var Observer = (
  /** @class */
  function() {
    function Observer2(value3, shallow, mock) {
      if (shallow === void 0) {
        shallow = false;
      }
      if (mock === void 0) {
        mock = false;
      }
      this.value = value3;
      this.shallow = shallow;
      this.mock = mock;
      this.dep = mock ? mockDep : new Dep();
      this.vmCount = 0;
      def(value3, "__ob__", this);
      if (isArray$5(value3)) {
        if (!mock) {
          if (hasProto) {
            value3.__proto__ = arrayMethods;
          } else {
            for (var i2 = 0, l2 = arrayKeys.length; i2 < l2; i2++) {
              var key = arrayKeys[i2];
              def(value3, key, arrayMethods[key]);
            }
          }
        }
        if (!shallow) {
          this.observeArray(value3);
        }
      } else {
        var keys3 = Object.keys(value3);
        for (var i2 = 0; i2 < keys3.length; i2++) {
          var key = keys3[i2];
          defineReactive(value3, key, NO_INITIAL_VALUE, void 0, shallow, mock);
        }
      }
    }
    Observer2.prototype.observeArray = function(value3) {
      for (var i2 = 0, l2 = value3.length; i2 < l2; i2++) {
        observe(value3[i2], false, this.mock);
      }
    };
    return Observer2;
  }()
);
function observe(value3, shallow, ssrMockReactivity) {
  if (value3 && hasOwn$g(value3, "__ob__") && value3.__ob__ instanceof Observer) {
    return value3.__ob__;
  }
  if (shouldObserve && (ssrMockReactivity || !isServerRendering()) && (isArray$5(value3) || isPlainObject$1(value3)) && Object.isExtensible(value3) && !value3.__v_skip && !isRef(value3) && !(value3 instanceof VNode)) {
    return new Observer(value3, shallow, ssrMockReactivity);
  }
}
function defineReactive(obj, key, val2, customSetter, shallow, mock, observeEvenIfShallow) {
  if (observeEvenIfShallow === void 0) {
    observeEvenIfShallow = false;
  }
  var dep = new Dep();
  var property = Object.getOwnPropertyDescriptor(obj, key);
  if (property && property.configurable === false) {
    return;
  }
  var getter = property && property.get;
  var setter = property && property.set;
  if ((!getter || setter) && (val2 === NO_INITIAL_VALUE || arguments.length === 2)) {
    val2 = obj[key];
  }
  var childOb = shallow ? val2 && val2.__ob__ : observe(val2, false, mock);
  Object.defineProperty(obj, key, {
    enumerable: true,
    configurable: true,
    get: function reactiveGetter() {
      var value3 = getter ? getter.call(obj) : val2;
      if (Dep.target) {
        {
          dep.depend();
        }
        if (childOb) {
          childOb.dep.depend();
          if (isArray$5(value3)) {
            dependArray(value3);
          }
        }
      }
      return isRef(value3) && !shallow ? value3.value : value3;
    },
    set: function reactiveSetter(newVal) {
      var value3 = getter ? getter.call(obj) : val2;
      if (!hasChanged(value3, newVal)) {
        return;
      }
      if (setter) {
        setter.call(obj, newVal);
      } else if (getter) {
        return;
      } else if (!shallow && isRef(value3) && !isRef(newVal)) {
        value3.value = newVal;
        return;
      } else {
        val2 = newVal;
      }
      childOb = shallow ? newVal && newVal.__ob__ : observe(newVal, false, mock);
      {
        dep.notify();
      }
    }
  });
  return dep;
}
function set$1(target2, key, val2) {
  if (isReadonly(target2)) {
    return;
  }
  var ob = target2.__ob__;
  if (isArray$5(target2) && isValidArrayIndex(key)) {
    target2.length = Math.max(target2.length, key);
    target2.splice(key, 1, val2);
    if (ob && !ob.shallow && ob.mock) {
      observe(val2, false, true);
    }
    return val2;
  }
  if (key in target2 && !(key in Object.prototype)) {
    target2[key] = val2;
    return val2;
  }
  if (target2._isVue || ob && ob.vmCount) {
    return val2;
  }
  if (!ob) {
    target2[key] = val2;
    return val2;
  }
  defineReactive(ob.value, key, val2, void 0, ob.shallow, ob.mock);
  {
    ob.dep.notify();
  }
  return val2;
}
function del(target2, key) {
  if (isArray$5(target2) && isValidArrayIndex(key)) {
    target2.splice(key, 1);
    return;
  }
  var ob = target2.__ob__;
  if (target2._isVue || ob && ob.vmCount) {
    return;
  }
  if (isReadonly(target2)) {
    return;
  }
  if (!hasOwn$g(target2, key)) {
    return;
  }
  delete target2[key];
  if (!ob) {
    return;
  }
  {
    ob.dep.notify();
  }
}
function dependArray(value3) {
  for (var e2 = void 0, i2 = 0, l2 = value3.length; i2 < l2; i2++) {
    e2 = value3[i2];
    if (e2 && e2.__ob__) {
      e2.__ob__.dep.depend();
    }
    if (isArray$5(e2)) {
      dependArray(e2);
    }
  }
}
function reactive(target2) {
  makeReactive(target2, false);
  return target2;
}
function shallowReactive(target2) {
  makeReactive(target2, true);
  def(target2, "__v_isShallow", true);
  return target2;
}
function makeReactive(target2, shallow) {
  if (!isReadonly(target2)) {
    observe(
      target2,
      shallow,
      isServerRendering()
      /* ssr mock reactivity */
    );
  }
}
function isReactive(value3) {
  if (isReadonly(value3)) {
    return isReactive(value3[
      "__v_raw"
      /* ReactiveFlags.RAW */
    ]);
  }
  return !!(value3 && value3.__ob__);
}
function isShallow(value3) {
  return !!(value3 && value3.__v_isShallow);
}
function isReadonly(value3) {
  return !!(value3 && value3.__v_isReadonly);
}
var RefFlag = "__v_isRef";
function isRef(r2) {
  return !!(r2 && r2.__v_isRef === true);
}
function ref$1(value3) {
  return createRef(value3, false);
}
function createRef(rawValue, shallow) {
  if (isRef(rawValue)) {
    return rawValue;
  }
  var ref2 = {};
  def(ref2, RefFlag, true);
  def(ref2, "__v_isShallow", shallow);
  def(ref2, "dep", defineReactive(ref2, "value", rawValue, null, shallow, isServerRendering()));
  return ref2;
}
function unref(ref2) {
  return isRef(ref2) ? ref2.value : ref2;
}
function proxyWithRefUnwrap(target2, source, key) {
  Object.defineProperty(target2, key, {
    enumerable: true,
    configurable: true,
    get: function() {
      var val2 = source[key];
      if (isRef(val2)) {
        return val2.value;
      } else {
        var ob = val2 && val2.__ob__;
        if (ob)
          ob.dep.depend();
        return val2;
      }
    },
    set: function(value3) {
      var oldValue = source[key];
      if (isRef(oldValue) && !isRef(value3)) {
        oldValue.value = value3;
      } else {
        source[key] = value3;
      }
    }
  });
}
function customRef(factory) {
  var dep = new Dep();
  var _a2 = factory(function() {
    {
      dep.depend();
    }
  }, function() {
    {
      dep.notify();
    }
  }), get2 = _a2.get, set2 = _a2.set;
  var ref2 = {
    get value() {
      return get2();
    },
    set value(newVal) {
      set2(newVal);
    }
  };
  def(ref2, RefFlag, true);
  return ref2;
}
function toRef$1(object, key, defaultValue) {
  var val2 = object[key];
  if (isRef(val2)) {
    return val2;
  }
  var ref2 = {
    get value() {
      var val22 = object[key];
      return val22 === void 0 ? defaultValue : val22;
    },
    set value(newVal) {
      object[key] = newVal;
    }
  };
  def(ref2, RefFlag, true);
  return ref2;
}
var rawToReadonlyFlag = "__v_rawToReadonly";
function readonly(target2) {
  return createReadonly(target2);
}
function createReadonly(target2, shallow) {
  if (!isPlainObject$1(target2)) {
    return target2;
  }
  if (isReadonly(target2)) {
    return target2;
  }
  var existingFlag = rawToReadonlyFlag;
  var existingProxy = target2[existingFlag];
  if (existingProxy) {
    return existingProxy;
  }
  var proxy2 = Object.create(Object.getPrototypeOf(target2));
  def(target2, existingFlag, proxy2);
  def(proxy2, "__v_isReadonly", true);
  def(proxy2, "__v_raw", target2);
  if (isRef(target2)) {
    def(proxy2, RefFlag, true);
  }
  if (isShallow(target2)) {
    def(proxy2, "__v_isShallow", true);
  }
  var keys3 = Object.keys(target2);
  for (var i2 = 0; i2 < keys3.length; i2++) {
    defineReadonlyProperty(proxy2, target2, keys3[i2]);
  }
  return proxy2;
}
function defineReadonlyProperty(proxy2, target2, key, shallow) {
  Object.defineProperty(proxy2, key, {
    enumerable: true,
    configurable: true,
    get: function() {
      var val2 = target2[key];
      return !isPlainObject$1(val2) ? val2 : readonly(val2);
    },
    set: function() {
    }
  });
}
function computed(getterOrOptions, debugOptions) {
  var getter;
  var setter;
  var onlyGetter = isFunction$2(getterOrOptions);
  if (onlyGetter) {
    getter = getterOrOptions;
    setter = noop$6;
  } else {
    getter = getterOrOptions.get;
    setter = getterOrOptions.set;
  }
  var watcher = isServerRendering() ? null : new Watcher(currentInstance, getter, noop$6, { lazy: true });
  var ref2 = {
    // some libs rely on the presence effect for checking computed refs
    // from normal refs, but the implementation doesn't matter
    effect: watcher,
    get value() {
      if (watcher) {
        if (watcher.dirty) {
          watcher.evaluate();
        }
        if (Dep.target) {
          watcher.depend();
        }
        return watcher.value;
      } else {
        return getter();
      }
    },
    set value(newVal) {
      setter(newVal);
    }
  };
  def(ref2, RefFlag, true);
  def(ref2, "__v_isReadonly", onlyGetter);
  return ref2;
}
var WATCHER = "watcher";
var WATCHER_CB = "".concat(WATCHER, " callback");
var WATCHER_GETTER = "".concat(WATCHER, " getter");
var WATCHER_CLEANUP = "".concat(WATCHER, " cleanup");
function watchEffect(effect, options2) {
  return doWatch(effect, null, options2);
}
function watchPostEffect(effect, options2) {
  return doWatch(effect, null, { flush: "post" });
}
var INITIAL_WATCHER_VALUE = {};
function watch(source, cb, options2) {
  return doWatch(source, cb, options2);
}
function doWatch(source, cb, _a2) {
  var _b2 = _a2 === void 0 ? emptyObject : _a2, immediate = _b2.immediate, deep = _b2.deep, _c2 = _b2.flush, flush = _c2 === void 0 ? "pre" : _c2;
  _b2.onTrack;
  _b2.onTrigger;
  var instance = currentInstance;
  var call2 = function(fn, type, args) {
    if (args === void 0) {
      args = null;
    }
    var res = invokeWithErrorHandling(fn, null, args, instance, type);
    if (deep && res && res.__ob__)
      res.__ob__.dep.depend();
    return res;
  };
  var getter;
  var forceTrigger = false;
  var isMultiSource = false;
  if (isRef(source)) {
    getter = function() {
      return source.value;
    };
    forceTrigger = isShallow(source);
  } else if (isReactive(source)) {
    getter = function() {
      source.__ob__.dep.depend();
      return source;
    };
    deep = true;
  } else if (isArray$5(source)) {
    isMultiSource = true;
    forceTrigger = source.some(function(s3) {
      return isReactive(s3) || isShallow(s3);
    });
    getter = function() {
      return source.map(function(s3) {
        if (isRef(s3)) {
          return s3.value;
        } else if (isReactive(s3)) {
          s3.__ob__.dep.depend();
          return traverse(s3);
        } else if (isFunction$2(s3)) {
          return call2(s3, WATCHER_GETTER);
        } else ;
      });
    };
  } else if (isFunction$2(source)) {
    if (cb) {
      getter = function() {
        return call2(source, WATCHER_GETTER);
      };
    } else {
      getter = function() {
        if (instance && instance._isDestroyed) {
          return;
        }
        if (cleanup) {
          cleanup();
        }
        return call2(source, WATCHER, [onCleanup]);
      };
    }
  } else {
    getter = noop$6;
  }
  if (cb && deep) {
    var baseGetter_1 = getter;
    getter = function() {
      return traverse(baseGetter_1());
    };
  }
  var cleanup;
  var onCleanup = function(fn) {
    cleanup = watcher.onStop = function() {
      call2(fn, WATCHER_CLEANUP);
    };
  };
  if (isServerRendering()) {
    onCleanup = noop$6;
    if (!cb) {
      getter();
    } else if (immediate) {
      call2(cb, WATCHER_CB, [
        getter(),
        isMultiSource ? [] : void 0,
        onCleanup
      ]);
    }
    return noop$6;
  }
  var watcher = new Watcher(currentInstance, getter, noop$6, {
    lazy: true
  });
  watcher.noRecurse = !cb;
  var oldValue = isMultiSource ? [] : INITIAL_WATCHER_VALUE;
  watcher.run = function() {
    if (!watcher.active) {
      return;
    }
    if (cb) {
      var newValue = watcher.get();
      if (deep || forceTrigger || (isMultiSource ? newValue.some(function(v2, i2) {
        return hasChanged(v2, oldValue[i2]);
      }) : hasChanged(newValue, oldValue))) {
        if (cleanup) {
          cleanup();
        }
        call2(cb, WATCHER_CB, [
          newValue,
          // pass undefined as the old value when it's changed for the first time
          oldValue === INITIAL_WATCHER_VALUE ? void 0 : oldValue,
          onCleanup
        ]);
        oldValue = newValue;
      }
    } else {
      watcher.get();
    }
  };
  if (flush === "sync") {
    watcher.update = watcher.run;
  } else if (flush === "post") {
    watcher.post = true;
    watcher.update = function() {
      return queueWatcher(watcher);
    };
  } else {
    watcher.update = function() {
      if (instance && instance === currentInstance && !instance._isMounted) {
        var buffer2 = instance._preWatchers || (instance._preWatchers = []);
        if (buffer2.indexOf(watcher) < 0)
          buffer2.push(watcher);
      } else {
        queueWatcher(watcher);
      }
    };
  }
  if (cb) {
    if (immediate) {
      watcher.run();
    } else {
      oldValue = watcher.get();
    }
  } else if (flush === "post" && instance) {
    instance.$once("hook:mounted", function() {
      return watcher.get();
    });
  } else {
    watcher.get();
  }
  return function() {
    watcher.teardown();
  };
}
var activeEffectScope;
var EffectScope = (
  /** @class */
  function() {
    function EffectScope2(detached) {
      if (detached === void 0) {
        detached = false;
      }
      this.detached = detached;
      this.active = true;
      this.effects = [];
      this.cleanups = [];
      this.parent = activeEffectScope;
      if (!detached && activeEffectScope) {
        this.index = (activeEffectScope.scopes || (activeEffectScope.scopes = [])).push(this) - 1;
      }
    }
    EffectScope2.prototype.run = function(fn) {
      if (this.active) {
        var currentEffectScope = activeEffectScope;
        try {
          activeEffectScope = this;
          return fn();
        } finally {
          activeEffectScope = currentEffectScope;
        }
      }
    };
    EffectScope2.prototype.on = function() {
      activeEffectScope = this;
    };
    EffectScope2.prototype.off = function() {
      activeEffectScope = this.parent;
    };
    EffectScope2.prototype.stop = function(fromParent) {
      if (this.active) {
        var i2 = void 0, l2 = void 0;
        for (i2 = 0, l2 = this.effects.length; i2 < l2; i2++) {
          this.effects[i2].teardown();
        }
        for (i2 = 0, l2 = this.cleanups.length; i2 < l2; i2++) {
          this.cleanups[i2]();
        }
        if (this.scopes) {
          for (i2 = 0, l2 = this.scopes.length; i2 < l2; i2++) {
            this.scopes[i2].stop(true);
          }
        }
        if (!this.detached && this.parent && !fromParent) {
          var last = this.parent.scopes.pop();
          if (last && last !== this) {
            this.parent.scopes[this.index] = last;
            last.index = this.index;
          }
        }
        this.parent = void 0;
        this.active = false;
      }
    };
    return EffectScope2;
  }()
);
function recordEffectScope(effect, scope) {
  if (scope === void 0) {
    scope = activeEffectScope;
  }
  if (scope && scope.active) {
    scope.effects.push(effect);
  }
}
function getCurrentScope() {
  return activeEffectScope;
}
function onScopeDispose(fn) {
  if (activeEffectScope) {
    activeEffectScope.cleanups.push(fn);
  }
}
function resolveProvided(vm) {
  var existing = vm._provided;
  var parentProvides = vm.$parent && vm.$parent._provided;
  if (parentProvides === existing) {
    return vm._provided = Object.create(parentProvides);
  } else {
    return existing;
  }
}
var normalizeEvent = cached(function(name) {
  var passive = name.charAt(0) === "&";
  name = passive ? name.slice(1) : name;
  var once2 = name.charAt(0) === "~";
  name = once2 ? name.slice(1) : name;
  var capture = name.charAt(0) === "!";
  name = capture ? name.slice(1) : name;
  return {
    name,
    once: once2,
    capture,
    passive
  };
});
function createFnInvoker(fns, vm) {
  function invoker() {
    var fns2 = invoker.fns;
    if (isArray$5(fns2)) {
      var cloned = fns2.slice();
      for (var i2 = 0; i2 < cloned.length; i2++) {
        invokeWithErrorHandling(cloned[i2], null, arguments, vm, "v-on handler");
      }
    } else {
      return invokeWithErrorHandling(fns2, null, arguments, vm, "v-on handler");
    }
  }
  invoker.fns = fns;
  return invoker;
}
function updateListeners(on, oldOn, add2, remove2, createOnceHandler2, vm) {
  var name, cur, old, event;
  for (name in on) {
    cur = on[name];
    old = oldOn[name];
    event = normalizeEvent(name);
    if (isUndef(cur)) ;
    else if (isUndef(old)) {
      if (isUndef(cur.fns)) {
        cur = on[name] = createFnInvoker(cur, vm);
      }
      if (isTrue(event.once)) {
        cur = on[name] = createOnceHandler2(event.name, cur, event.capture);
      }
      add2(event.name, cur, event.capture, event.passive, event.params);
    } else if (cur !== old) {
      old.fns = cur;
      on[name] = old;
    }
  }
  for (name in oldOn) {
    if (isUndef(on[name])) {
      event = normalizeEvent(name);
      remove2(event.name, oldOn[name], event.capture);
    }
  }
}
function mergeVNodeHook(def2, hookKey, hook) {
  if (def2 instanceof VNode) {
    def2 = def2.data.hook || (def2.data.hook = {});
  }
  var invoker;
  var oldHook = def2[hookKey];
  function wrappedHook() {
    hook.apply(this, arguments);
    remove$2(invoker.fns, wrappedHook);
  }
  if (isUndef(oldHook)) {
    invoker = createFnInvoker([wrappedHook]);
  } else {
    if (isDef(oldHook.fns) && isTrue(oldHook.merged)) {
      invoker = oldHook;
      invoker.fns.push(wrappedHook);
    } else {
      invoker = createFnInvoker([oldHook, wrappedHook]);
    }
  }
  invoker.merged = true;
  def2[hookKey] = invoker;
}
function extractPropsFromVNodeData(data12, Ctor, tag) {
  var propOptions = Ctor.options.props;
  if (isUndef(propOptions)) {
    return;
  }
  var res = {};
  var attrs2 = data12.attrs, props2 = data12.props;
  if (isDef(attrs2) || isDef(props2)) {
    for (var key in propOptions) {
      var altKey = hyphenate(key);
      checkProp(res, props2, key, altKey, true) || checkProp(res, attrs2, key, altKey, false);
    }
  }
  return res;
}
function checkProp(res, hash2, key, altKey, preserve) {
  if (isDef(hash2)) {
    if (hasOwn$g(hash2, key)) {
      res[key] = hash2[key];
      if (!preserve) {
        delete hash2[key];
      }
      return true;
    } else if (hasOwn$g(hash2, altKey)) {
      res[key] = hash2[altKey];
      if (!preserve) {
        delete hash2[altKey];
      }
      return true;
    }
  }
  return false;
}
function simpleNormalizeChildren(children) {
  for (var i2 = 0; i2 < children.length; i2++) {
    if (isArray$5(children[i2])) {
      return Array.prototype.concat.apply([], children);
    }
  }
  return children;
}
function normalizeChildren(children) {
  return isPrimitive(children) ? [createTextVNode(children)] : isArray$5(children) ? normalizeArrayChildren(children) : void 0;
}
function isTextNode(node) {
  return isDef(node) && isDef(node.text) && isFalse(node.isComment);
}
function normalizeArrayChildren(children, nestedIndex) {
  var res = [];
  var i2, c2, lastIndex, last;
  for (i2 = 0; i2 < children.length; i2++) {
    c2 = children[i2];
    if (isUndef(c2) || typeof c2 === "boolean")
      continue;
    lastIndex = res.length - 1;
    last = res[lastIndex];
    if (isArray$5(c2)) {
      if (c2.length > 0) {
        c2 = normalizeArrayChildren(c2, "".concat(nestedIndex || "", "_").concat(i2));
        if (isTextNode(c2[0]) && isTextNode(last)) {
          res[lastIndex] = createTextVNode(last.text + c2[0].text);
          c2.shift();
        }
        res.push.apply(res, c2);
      }
    } else if (isPrimitive(c2)) {
      if (isTextNode(last)) {
        res[lastIndex] = createTextVNode(last.text + c2);
      } else if (c2 !== "") {
        res.push(createTextVNode(c2));
      }
    } else {
      if (isTextNode(c2) && isTextNode(last)) {
        res[lastIndex] = createTextVNode(last.text + c2.text);
      } else {
        if (isTrue(children._isVList) && isDef(c2.tag) && isUndef(c2.key) && isDef(nestedIndex)) {
          c2.key = "__vlist".concat(nestedIndex, "_").concat(i2, "__");
        }
        res.push(c2);
      }
    }
  }
  return res;
}
function renderList(val2, render66) {
  var ret = null, i2, l2, keys3, key;
  if (isArray$5(val2) || typeof val2 === "string") {
    ret = new Array(val2.length);
    for (i2 = 0, l2 = val2.length; i2 < l2; i2++) {
      ret[i2] = render66(val2[i2], i2);
    }
  } else if (typeof val2 === "number") {
    ret = new Array(val2);
    for (i2 = 0; i2 < val2; i2++) {
      ret[i2] = render66(i2 + 1, i2);
    }
  } else if (isObject$f(val2)) {
    if (hasSymbol$1 && val2[Symbol.iterator]) {
      ret = [];
      var iterator = val2[Symbol.iterator]();
      var result = iterator.next();
      while (!result.done) {
        ret.push(render66(result.value, ret.length));
        result = iterator.next();
      }
    } else {
      keys3 = Object.keys(val2);
      ret = new Array(keys3.length);
      for (i2 = 0, l2 = keys3.length; i2 < l2; i2++) {
        key = keys3[i2];
        ret[i2] = render66(val2[key], key, i2);
      }
    }
  }
  if (!isDef(ret)) {
    ret = [];
  }
  ret._isVList = true;
  return ret;
}
function renderSlot(name, fallbackRender, props2, bindObject) {
  var scopedSlotFn = this.$scopedSlots[name];
  var nodes;
  if (scopedSlotFn) {
    props2 = props2 || {};
    if (bindObject) {
      props2 = extend$2(extend$2({}, bindObject), props2);
    }
    nodes = scopedSlotFn(props2) || (isFunction$2(fallbackRender) ? fallbackRender() : fallbackRender);
  } else {
    nodes = this.$slots[name] || (isFunction$2(fallbackRender) ? fallbackRender() : fallbackRender);
  }
  var target2 = props2 && props2.slot;
  if (target2) {
    return this.$createElement("template", { slot: target2 }, nodes);
  } else {
    return nodes;
  }
}
function resolveFilter(id2) {
  return resolveAsset(this.$options, "filters", id2) || identity;
}
function isKeyNotMatch(expect, actual) {
  if (isArray$5(expect)) {
    return expect.indexOf(actual) === -1;
  } else {
    return expect !== actual;
  }
}
function checkKeyCodes(eventKeyCode, key, builtInKeyCode, eventKeyName, builtInKeyName) {
  var mappedKeyCode = config$2.keyCodes[key] || builtInKeyCode;
  if (builtInKeyName && eventKeyName && !config$2.keyCodes[key]) {
    return isKeyNotMatch(builtInKeyName, eventKeyName);
  } else if (mappedKeyCode) {
    return isKeyNotMatch(mappedKeyCode, eventKeyCode);
  } else if (eventKeyName) {
    return hyphenate(eventKeyName) !== key;
  }
  return eventKeyCode === void 0;
}
function bindObjectProps(data12, tag, value3, asProp, isSync) {
  if (value3) {
    if (!isObject$f(value3)) ;
    else {
      if (isArray$5(value3)) {
        value3 = toObject$7(value3);
      }
      var hash2 = void 0;
      var _loop_1 = function(key2) {
        if (key2 === "class" || key2 === "style" || isReservedAttribute(key2)) {
          hash2 = data12;
        } else {
          var type = data12.attrs && data12.attrs.type;
          hash2 = asProp || config$2.mustUseProp(tag, type, key2) ? data12.domProps || (data12.domProps = {}) : data12.attrs || (data12.attrs = {});
        }
        var camelizedKey = camelize(key2);
        var hyphenatedKey = hyphenate(key2);
        if (!(camelizedKey in hash2) && !(hyphenatedKey in hash2)) {
          hash2[key2] = value3[key2];
          if (isSync) {
            var on = data12.on || (data12.on = {});
            on["update:".concat(key2)] = function($event) {
              value3[key2] = $event;
            };
          }
        }
      };
      for (var key in value3) {
        _loop_1(key);
      }
    }
  }
  return data12;
}
function renderStatic(index2, isInFor) {
  var cached2 = this._staticTrees || (this._staticTrees = []);
  var tree = cached2[index2];
  if (tree && !isInFor) {
    return tree;
  }
  tree = cached2[index2] = this.$options.staticRenderFns[index2].call(
    this._renderProxy,
    this._c,
    this
    // for render fns generated for functional component templates
  );
  markStatic(tree, "__static__".concat(index2), false);
  return tree;
}
function markOnce(tree, index2, key) {
  markStatic(tree, "__once__".concat(index2).concat(key ? "_".concat(key) : ""), true);
  return tree;
}
function markStatic(tree, key, isOnce) {
  if (isArray$5(tree)) {
    for (var i2 = 0; i2 < tree.length; i2++) {
      if (tree[i2] && typeof tree[i2] !== "string") {
        markStaticNode(tree[i2], "".concat(key, "_").concat(i2), isOnce);
      }
    }
  } else {
    markStaticNode(tree, key, isOnce);
  }
}
function markStaticNode(node, key, isOnce) {
  node.isStatic = true;
  node.key = key;
  node.isOnce = isOnce;
}
function bindObjectListeners(data12, value3) {
  if (value3) {
    if (!isPlainObject$1(value3)) ;
    else {
      var on = data12.on = data12.on ? extend$2({}, data12.on) : {};
      for (var key in value3) {
        var existing = on[key];
        var ours = value3[key];
        on[key] = existing ? [].concat(existing, ours) : ours;
      }
    }
  }
  return data12;
}
function resolveScopedSlots(fns, res, hasDynamicKeys, contentHashKey) {
  res = res || { $stable: !hasDynamicKeys };
  for (var i2 = 0; i2 < fns.length; i2++) {
    var slot = fns[i2];
    if (isArray$5(slot)) {
      resolveScopedSlots(slot, res, hasDynamicKeys);
    } else if (slot) {
      if (slot.proxy) {
        slot.fn.proxy = true;
      }
      res[slot.key] = slot.fn;
    }
  }
  if (contentHashKey) {
    res.$key = contentHashKey;
  }
  return res;
}
function bindDynamicKeys(baseObj, values2) {
  for (var i2 = 0; i2 < values2.length; i2 += 2) {
    var key = values2[i2];
    if (typeof key === "string" && key) {
      baseObj[values2[i2]] = values2[i2 + 1];
    }
  }
  return baseObj;
}
function prependModifier(value3, symbol) {
  return typeof value3 === "string" ? symbol + value3 : value3;
}
function installRenderHelpers(target2) {
  target2._o = markOnce;
  target2._n = toNumber$1;
  target2._s = toString$f;
  target2._l = renderList;
  target2._t = renderSlot;
  target2._q = looseEqual;
  target2._i = looseIndexOf;
  target2._m = renderStatic;
  target2._f = resolveFilter;
  target2._k = checkKeyCodes;
  target2._b = bindObjectProps;
  target2._v = createTextVNode;
  target2._e = createEmptyVNode;
  target2._u = resolveScopedSlots;
  target2._g = bindObjectListeners;
  target2._d = bindDynamicKeys;
  target2._p = prependModifier;
}
function resolveSlots(children, context) {
  if (!children || !children.length) {
    return {};
  }
  var slots = {};
  for (var i2 = 0, l2 = children.length; i2 < l2; i2++) {
    var child = children[i2];
    var data12 = child.data;
    if (data12 && data12.attrs && data12.attrs.slot) {
      delete data12.attrs.slot;
    }
    if ((child.context === context || child.fnContext === context) && data12 && data12.slot != null) {
      var name_1 = data12.slot;
      var slot = slots[name_1] || (slots[name_1] = []);
      if (child.tag === "template") {
        slot.push.apply(slot, child.children || []);
      } else {
        slot.push(child);
      }
    } else {
      (slots.default || (slots.default = [])).push(child);
    }
  }
  for (var name_2 in slots) {
    if (slots[name_2].every(isWhitespace)) {
      delete slots[name_2];
    }
  }
  return slots;
}
function isWhitespace(node) {
  return node.isComment && !node.asyncFactory || node.text === " ";
}
function isAsyncPlaceholder(node) {
  return node.isComment && node.asyncFactory;
}
function normalizeScopedSlots(ownerVm, scopedSlots, normalSlots, prevScopedSlots) {
  var res;
  var hasNormalSlots = Object.keys(normalSlots).length > 0;
  var isStable = scopedSlots ? !!scopedSlots.$stable : !hasNormalSlots;
  var key = scopedSlots && scopedSlots.$key;
  if (!scopedSlots) {
    res = {};
  } else if (scopedSlots._normalized) {
    return scopedSlots._normalized;
  } else if (isStable && prevScopedSlots && prevScopedSlots !== emptyObject && key === prevScopedSlots.$key && !hasNormalSlots && !prevScopedSlots.$hasNormal) {
    return prevScopedSlots;
  } else {
    res = {};
    for (var key_1 in scopedSlots) {
      if (scopedSlots[key_1] && key_1[0] !== "$") {
        res[key_1] = normalizeScopedSlot(ownerVm, normalSlots, key_1, scopedSlots[key_1]);
      }
    }
  }
  for (var key_2 in normalSlots) {
    if (!(key_2 in res)) {
      res[key_2] = proxyNormalSlot(normalSlots, key_2);
    }
  }
  if (scopedSlots && Object.isExtensible(scopedSlots)) {
    scopedSlots._normalized = res;
  }
  def(res, "$stable", isStable);
  def(res, "$key", key);
  def(res, "$hasNormal", hasNormalSlots);
  return res;
}
function normalizeScopedSlot(vm, normalSlots, key, fn) {
  var normalized = function() {
    var cur = currentInstance;
    setCurrentInstance(vm);
    var res = arguments.length ? fn.apply(null, arguments) : fn({});
    res = res && typeof res === "object" && !isArray$5(res) ? [res] : normalizeChildren(res);
    var vnode = res && res[0];
    setCurrentInstance(cur);
    return res && (!vnode || res.length === 1 && vnode.isComment && !isAsyncPlaceholder(vnode)) ? void 0 : res;
  };
  if (fn.proxy) {
    Object.defineProperty(normalSlots, key, {
      get: normalized,
      enumerable: true,
      configurable: true
    });
  }
  return normalized;
}
function proxyNormalSlot(slots, key) {
  return function() {
    return slots[key];
  };
}
function initSetup(vm) {
  var options2 = vm.$options;
  var setup = options2.setup;
  if (setup) {
    var ctx = vm._setupContext = createSetupContext(vm);
    setCurrentInstance(vm);
    pushTarget();
    var setupResult = invokeWithErrorHandling(setup, null, [vm._props || shallowReactive({}), ctx], vm, "setup");
    popTarget();
    setCurrentInstance();
    if (isFunction$2(setupResult)) {
      options2.render = setupResult;
    } else if (isObject$f(setupResult)) {
      vm._setupState = setupResult;
      if (!setupResult.__sfc) {
        for (var key in setupResult) {
          if (!isReserved(key)) {
            proxyWithRefUnwrap(vm, setupResult, key);
          }
        }
      } else {
        var proxy2 = vm._setupProxy = {};
        for (var key in setupResult) {
          if (key !== "__sfc") {
            proxyWithRefUnwrap(proxy2, setupResult, key);
          }
        }
      }
    } else ;
  }
}
function createSetupContext(vm) {
  return {
    get attrs() {
      if (!vm._attrsProxy) {
        var proxy2 = vm._attrsProxy = {};
        def(proxy2, "_v_attr_proxy", true);
        syncSetupProxy(proxy2, vm.$attrs, emptyObject, vm, "$attrs");
      }
      return vm._attrsProxy;
    },
    get listeners() {
      if (!vm._listenersProxy) {
        var proxy2 = vm._listenersProxy = {};
        syncSetupProxy(proxy2, vm.$listeners, emptyObject, vm, "$listeners");
      }
      return vm._listenersProxy;
    },
    get slots() {
      return initSlotsProxy(vm);
    },
    emit: bind$4(vm.$emit, vm),
    expose: function(exposed) {
      if (exposed) {
        Object.keys(exposed).forEach(function(key) {
          return proxyWithRefUnwrap(vm, exposed, key);
        });
      }
    }
  };
}
function syncSetupProxy(to, from, prev, instance, type) {
  var changed = false;
  for (var key in from) {
    if (!(key in to)) {
      changed = true;
      defineProxyAttr(to, key, instance, type);
    } else if (from[key] !== prev[key]) {
      changed = true;
    }
  }
  for (var key in to) {
    if (!(key in from)) {
      changed = true;
      delete to[key];
    }
  }
  return changed;
}
function defineProxyAttr(proxy2, key, instance, type) {
  Object.defineProperty(proxy2, key, {
    enumerable: true,
    configurable: true,
    get: function() {
      return instance[type][key];
    }
  });
}
function initSlotsProxy(vm) {
  if (!vm._slotsProxy) {
    syncSetupSlots(vm._slotsProxy = {}, vm.$scopedSlots);
  }
  return vm._slotsProxy;
}
function syncSetupSlots(to, from) {
  for (var key in from) {
    to[key] = from[key];
  }
  for (var key in to) {
    if (!(key in from)) {
      delete to[key];
    }
  }
}
function useSlots() {
  return getContext().slots;
}
function getContext() {
  var vm = currentInstance;
  return vm._setupContext || (vm._setupContext = createSetupContext(vm));
}
function initRender(vm) {
  vm._vnode = null;
  vm._staticTrees = null;
  var options2 = vm.$options;
  var parentVnode = vm.$vnode = options2._parentVnode;
  var renderContext = parentVnode && parentVnode.context;
  vm.$slots = resolveSlots(options2._renderChildren, renderContext);
  vm.$scopedSlots = parentVnode ? normalizeScopedSlots(vm.$parent, parentVnode.data.scopedSlots, vm.$slots) : emptyObject;
  vm._c = function(a3, b2, c2, d3) {
    return createElement$1(vm, a3, b2, c2, d3, false);
  };
  vm.$createElement = function(a3, b2, c2, d3) {
    return createElement$1(vm, a3, b2, c2, d3, true);
  };
  var parentData = parentVnode && parentVnode.data;
  {
    defineReactive(vm, "$attrs", parentData && parentData.attrs || emptyObject, null, true);
    defineReactive(vm, "$listeners", options2._parentListeners || emptyObject, null, true);
  }
}
var currentRenderingInstance = null;
function renderMixin(Vue2) {
  installRenderHelpers(Vue2.prototype);
  Vue2.prototype.$nextTick = function(fn) {
    return nextTick(fn, this);
  };
  Vue2.prototype._render = function() {
    var vm = this;
    var _a2 = vm.$options, render66 = _a2.render, _parentVnode = _a2._parentVnode;
    if (_parentVnode && vm._isMounted) {
      vm.$scopedSlots = normalizeScopedSlots(vm.$parent, _parentVnode.data.scopedSlots, vm.$slots, vm.$scopedSlots);
      if (vm._slotsProxy) {
        syncSetupSlots(vm._slotsProxy, vm.$scopedSlots);
      }
    }
    vm.$vnode = _parentVnode;
    var prevInst = currentInstance;
    var prevRenderInst = currentRenderingInstance;
    var vnode;
    try {
      setCurrentInstance(vm);
      currentRenderingInstance = vm;
      vnode = render66.call(vm._renderProxy, vm.$createElement);
    } catch (e2) {
      handleError(e2, vm, "render");
      {
        vnode = vm._vnode;
      }
    } finally {
      currentRenderingInstance = prevRenderInst;
      setCurrentInstance(prevInst);
    }
    if (isArray$5(vnode) && vnode.length === 1) {
      vnode = vnode[0];
    }
    if (!(vnode instanceof VNode)) {
      vnode = createEmptyVNode();
    }
    vnode.parent = _parentVnode;
    return vnode;
  };
}
function ensureCtor(comp, base) {
  if (comp.__esModule || hasSymbol$1 && comp[Symbol.toStringTag] === "Module") {
    comp = comp.default;
  }
  return isObject$f(comp) ? base.extend(comp) : comp;
}
function createAsyncPlaceholder(factory, data12, context, children, tag) {
  var node = createEmptyVNode();
  node.asyncFactory = factory;
  node.asyncMeta = { data: data12, context, children, tag };
  return node;
}
function resolveAsyncComponent(factory, baseCtor) {
  if (isTrue(factory.error) && isDef(factory.errorComp)) {
    return factory.errorComp;
  }
  if (isDef(factory.resolved)) {
    return factory.resolved;
  }
  var owner = currentRenderingInstance;
  if (owner && isDef(factory.owners) && factory.owners.indexOf(owner) === -1) {
    factory.owners.push(owner);
  }
  if (isTrue(factory.loading) && isDef(factory.loadingComp)) {
    return factory.loadingComp;
  }
  if (owner && !isDef(factory.owners)) {
    var owners_1 = factory.owners = [owner];
    var sync_1 = true;
    var timerLoading_1 = null;
    var timerTimeout_1 = null;
    owner.$on("hook:destroyed", function() {
      return remove$2(owners_1, owner);
    });
    var forceRender_1 = function(renderCompleted) {
      for (var i2 = 0, l2 = owners_1.length; i2 < l2; i2++) {
        owners_1[i2].$forceUpdate();
      }
      if (renderCompleted) {
        owners_1.length = 0;
        if (timerLoading_1 !== null) {
          clearTimeout(timerLoading_1);
          timerLoading_1 = null;
        }
        if (timerTimeout_1 !== null) {
          clearTimeout(timerTimeout_1);
          timerTimeout_1 = null;
        }
      }
    };
    var resolve4 = once$1(function(res) {
      factory.resolved = ensureCtor(res, baseCtor);
      if (!sync_1) {
        forceRender_1(true);
      } else {
        owners_1.length = 0;
      }
    });
    var reject_1 = once$1(function(reason) {
      if (isDef(factory.errorComp)) {
        factory.error = true;
        forceRender_1(true);
      }
    });
    var res_1 = factory(resolve4, reject_1);
    if (isObject$f(res_1)) {
      if (isPromise(res_1)) {
        if (isUndef(factory.resolved)) {
          res_1.then(resolve4, reject_1);
        }
      } else if (isPromise(res_1.component)) {
        res_1.component.then(resolve4, reject_1);
        if (isDef(res_1.error)) {
          factory.errorComp = ensureCtor(res_1.error, baseCtor);
        }
        if (isDef(res_1.loading)) {
          factory.loadingComp = ensureCtor(res_1.loading, baseCtor);
          if (res_1.delay === 0) {
            factory.loading = true;
          } else {
            timerLoading_1 = setTimeout(function() {
              timerLoading_1 = null;
              if (isUndef(factory.resolved) && isUndef(factory.error)) {
                factory.loading = true;
                forceRender_1(false);
              }
            }, res_1.delay || 200);
          }
        }
        if (isDef(res_1.timeout)) {
          timerTimeout_1 = setTimeout(function() {
            timerTimeout_1 = null;
            if (isUndef(factory.resolved)) {
              reject_1(null);
            }
          }, res_1.timeout);
        }
      }
    }
    sync_1 = false;
    return factory.loading ? factory.loadingComp : factory.resolved;
  }
}
function getFirstComponentChild(children) {
  if (isArray$5(children)) {
    for (var i2 = 0; i2 < children.length; i2++) {
      var c2 = children[i2];
      if (isDef(c2) && (isDef(c2.componentOptions) || isAsyncPlaceholder(c2))) {
        return c2;
      }
    }
  }
}
var SIMPLE_NORMALIZE = 1;
var ALWAYS_NORMALIZE = 2;
function createElement$1(context, tag, data12, children, normalizationType, alwaysNormalize) {
  if (isArray$5(data12) || isPrimitive(data12)) {
    normalizationType = children;
    children = data12;
    data12 = void 0;
  }
  if (isTrue(alwaysNormalize)) {
    normalizationType = ALWAYS_NORMALIZE;
  }
  return _createElement(context, tag, data12, children, normalizationType);
}
function _createElement(context, tag, data12, children, normalizationType) {
  if (isDef(data12) && isDef(data12.__ob__)) {
    return createEmptyVNode();
  }
  if (isDef(data12) && isDef(data12.is)) {
    tag = data12.is;
  }
  if (!tag) {
    return createEmptyVNode();
  }
  if (isArray$5(children) && isFunction$2(children[0])) {
    data12 = data12 || {};
    data12.scopedSlots = { default: children[0] };
    children.length = 0;
  }
  if (normalizationType === ALWAYS_NORMALIZE) {
    children = normalizeChildren(children);
  } else if (normalizationType === SIMPLE_NORMALIZE) {
    children = simpleNormalizeChildren(children);
  }
  var vnode, ns;
  if (typeof tag === "string") {
    var Ctor = void 0;
    ns = context.$vnode && context.$vnode.ns || config$2.getTagNamespace(tag);
    if (config$2.isReservedTag(tag)) {
      vnode = new VNode(config$2.parsePlatformTagName(tag), data12, children, void 0, void 0, context);
    } else if ((!data12 || !data12.pre) && isDef(Ctor = resolveAsset(context.$options, "components", tag))) {
      vnode = createComponent(Ctor, data12, context, children, tag);
    } else {
      vnode = new VNode(tag, data12, children, void 0, void 0, context);
    }
  } else {
    vnode = createComponent(tag, data12, context, children);
  }
  if (isArray$5(vnode)) {
    return vnode;
  } else if (isDef(vnode)) {
    if (isDef(ns))
      applyNS(vnode, ns);
    if (isDef(data12))
      registerDeepBindings(data12);
    return vnode;
  } else {
    return createEmptyVNode();
  }
}
function applyNS(vnode, ns, force) {
  vnode.ns = ns;
  if (vnode.tag === "foreignObject") {
    ns = void 0;
    force = true;
  }
  if (isDef(vnode.children)) {
    for (var i2 = 0, l2 = vnode.children.length; i2 < l2; i2++) {
      var child = vnode.children[i2];
      if (isDef(child.tag) && (isUndef(child.ns) || isTrue(force) && child.tag !== "svg")) {
        applyNS(child, ns, force);
      }
    }
  }
}
function registerDeepBindings(data12) {
  if (isObject$f(data12.style)) {
    traverse(data12.style);
  }
  if (isObject$f(data12.class)) {
    traverse(data12.class);
  }
}
function handleError(err, vm, info) {
  pushTarget();
  try {
    if (vm) {
      var cur = vm;
      while (cur = cur.$parent) {
        var hooks2 = cur.$options.errorCaptured;
        if (hooks2) {
          for (var i2 = 0; i2 < hooks2.length; i2++) {
            try {
              var capture = hooks2[i2].call(cur, err, vm, info) === false;
              if (capture)
                return;
            } catch (e2) {
              globalHandleError(e2, cur, "errorCaptured hook");
            }
          }
        }
      }
    }
    globalHandleError(err, vm, info);
  } finally {
    popTarget();
  }
}
function invokeWithErrorHandling(handler9, context, args, vm, info) {
  var res;
  try {
    res = args ? handler9.apply(context, args) : handler9.call(context);
    if (res && !res._isVue && isPromise(res) && !res._handled) {
      res.catch(function(e2) {
        return handleError(e2, vm, info + " (Promise/async)");
      });
      res._handled = true;
    }
  } catch (e2) {
    handleError(e2, vm, info);
  }
  return res;
}
function globalHandleError(err, vm, info) {
  if (config$2.errorHandler) {
    try {
      return config$2.errorHandler.call(null, err, vm, info);
    } catch (e2) {
      if (e2 !== err) {
        logError(e2);
      }
    }
  }
  logError(err);
}
function logError(err, vm, info) {
  if (inBrowser$1 && typeof console !== "undefined") {
    console.error(err);
  } else {
    throw err;
  }
}
var isUsingMicroTask = false;
var callbacks = [];
var pending = false;
function flushCallbacks() {
  pending = false;
  var copies = callbacks.slice(0);
  callbacks.length = 0;
  for (var i2 = 0; i2 < copies.length; i2++) {
    copies[i2]();
  }
}
var timerFunc;
if (typeof Promise !== "undefined" && isNative(Promise)) {
  var p_1 = Promise.resolve();
  timerFunc = function() {
    p_1.then(flushCallbacks);
    if (isIOS$2)
      setTimeout(noop$6);
  };
  isUsingMicroTask = true;
} else if (!isIE$1 && typeof MutationObserver !== "undefined" && (isNative(MutationObserver) || // PhantomJS and iOS 7.x
MutationObserver.toString() === "[object MutationObserverConstructor]")) {
  var counter_1 = 1;
  var observer = new MutationObserver(flushCallbacks);
  var textNode_1 = document.createTextNode(String(counter_1));
  observer.observe(textNode_1, {
    characterData: true
  });
  timerFunc = function() {
    counter_1 = (counter_1 + 1) % 2;
    textNode_1.data = String(counter_1);
  };
  isUsingMicroTask = true;
} else if (typeof setImmediate !== "undefined" && isNative(setImmediate)) {
  timerFunc = function() {
    setImmediate(flushCallbacks);
  };
} else {
  timerFunc = function() {
    setTimeout(flushCallbacks, 0);
  };
}
function nextTick(cb, ctx) {
  var _resolve;
  callbacks.push(function() {
    if (cb) {
      try {
        cb.call(ctx);
      } catch (e2) {
        handleError(e2, ctx, "nextTick");
      }
    } else if (_resolve) {
      _resolve(ctx);
    }
  });
  if (!pending) {
    pending = true;
    timerFunc();
  }
  if (!cb && typeof Promise !== "undefined") {
    return new Promise(function(resolve4) {
      _resolve = resolve4;
    });
  }
}
function useCssVars(getter) {
  if (!inBrowser$1 && true)
    return;
  var instance = currentInstance;
  if (!instance) {
    return;
  }
  watchPostEffect(function() {
    var el = instance.$el;
    var vars = getter(instance, instance._setupProxy);
    if (el && el.nodeType === 1) {
      var style2 = el.style;
      for (var key in vars) {
        style2.setProperty("--".concat(key), vars[key]);
      }
    }
  });
}
function createLifeCycle(hookName) {
  return function(fn, target2) {
    if (target2 === void 0) {
      target2 = currentInstance;
    }
    if (!target2) {
      return;
    }
    return injectHook(target2, hookName, fn);
  };
}
function injectHook(instance, hookName, fn) {
  var options2 = instance.$options;
  options2[hookName] = mergeLifecycleHook(options2[hookName], fn);
}
var onMounted = createLifeCycle("mounted");
var version$2 = "2.7.16";
function defineComponent(options2) {
  return options2;
}
var seenObjects = new _Set();
function traverse(val2) {
  _traverse(val2, seenObjects);
  seenObjects.clear();
  return val2;
}
function _traverse(val2, seen2) {
  var i2, keys3;
  var isA = isArray$5(val2);
  if (!isA && !isObject$f(val2) || val2.__v_skip || Object.isFrozen(val2) || val2 instanceof VNode) {
    return;
  }
  if (val2.__ob__) {
    var depId = val2.__ob__.dep.id;
    if (seen2.has(depId)) {
      return;
    }
    seen2.add(depId);
  }
  if (isA) {
    i2 = val2.length;
    while (i2--)
      _traverse(val2[i2], seen2);
  } else if (isRef(val2)) {
    _traverse(val2.value, seen2);
  } else {
    keys3 = Object.keys(val2);
    i2 = keys3.length;
    while (i2--)
      _traverse(val2[keys3[i2]], seen2);
  }
}
var uid$1$1 = 0;
var Watcher = (
  /** @class */
  function() {
    function Watcher2(vm, expOrFn, cb, options2, isRenderWatcher) {
      recordEffectScope(
        this,
        // if the active effect scope is manually created (not a component scope),
        // prioritize it
        activeEffectScope && !activeEffectScope._vm ? activeEffectScope : vm ? vm._scope : void 0
      );
      if ((this.vm = vm) && isRenderWatcher) {
        vm._watcher = this;
      }
      if (options2) {
        this.deep = !!options2.deep;
        this.user = !!options2.user;
        this.lazy = !!options2.lazy;
        this.sync = !!options2.sync;
        this.before = options2.before;
      } else {
        this.deep = this.user = this.lazy = this.sync = false;
      }
      this.cb = cb;
      this.id = ++uid$1$1;
      this.active = true;
      this.post = false;
      this.dirty = this.lazy;
      this.deps = [];
      this.newDeps = [];
      this.depIds = new _Set();
      this.newDepIds = new _Set();
      this.expression = "";
      if (isFunction$2(expOrFn)) {
        this.getter = expOrFn;
      } else {
        this.getter = parsePath$2(expOrFn);
        if (!this.getter) {
          this.getter = noop$6;
        }
      }
      this.value = this.lazy ? void 0 : this.get();
    }
    Watcher2.prototype.get = function() {
      pushTarget(this);
      var value3;
      var vm = this.vm;
      try {
        value3 = this.getter.call(vm, vm);
      } catch (e2) {
        if (this.user) {
          handleError(e2, vm, 'getter for watcher "'.concat(this.expression, '"'));
        } else {
          throw e2;
        }
      } finally {
        if (this.deep) {
          traverse(value3);
        }
        popTarget();
        this.cleanupDeps();
      }
      return value3;
    };
    Watcher2.prototype.addDep = function(dep) {
      var id2 = dep.id;
      if (!this.newDepIds.has(id2)) {
        this.newDepIds.add(id2);
        this.newDeps.push(dep);
        if (!this.depIds.has(id2)) {
          dep.addSub(this);
        }
      }
    };
    Watcher2.prototype.cleanupDeps = function() {
      var i2 = this.deps.length;
      while (i2--) {
        var dep = this.deps[i2];
        if (!this.newDepIds.has(dep.id)) {
          dep.removeSub(this);
        }
      }
      var tmp = this.depIds;
      this.depIds = this.newDepIds;
      this.newDepIds = tmp;
      this.newDepIds.clear();
      tmp = this.deps;
      this.deps = this.newDeps;
      this.newDeps = tmp;
      this.newDeps.length = 0;
    };
    Watcher2.prototype.update = function() {
      if (this.lazy) {
        this.dirty = true;
      } else if (this.sync) {
        this.run();
      } else {
        queueWatcher(this);
      }
    };
    Watcher2.prototype.run = function() {
      if (this.active) {
        var value3 = this.get();
        if (value3 !== this.value || // Deep watchers and watchers on Object/Arrays should fire even
        // when the value is the same, because the value may
        // have mutated.
        isObject$f(value3) || this.deep) {
          var oldValue = this.value;
          this.value = value3;
          if (this.user) {
            var info = 'callback for watcher "'.concat(this.expression, '"');
            invokeWithErrorHandling(this.cb, this.vm, [value3, oldValue], this.vm, info);
          } else {
            this.cb.call(this.vm, value3, oldValue);
          }
        }
      }
    };
    Watcher2.prototype.evaluate = function() {
      this.value = this.get();
      this.dirty = false;
    };
    Watcher2.prototype.depend = function() {
      var i2 = this.deps.length;
      while (i2--) {
        this.deps[i2].depend();
      }
    };
    Watcher2.prototype.teardown = function() {
      if (this.vm && !this.vm._isBeingDestroyed) {
        remove$2(this.vm._scope.effects, this);
      }
      if (this.active) {
        var i2 = this.deps.length;
        while (i2--) {
          this.deps[i2].removeSub(this);
        }
        this.active = false;
        if (this.onStop) {
          this.onStop();
        }
      }
    };
    return Watcher2;
  }()
);
function initEvents(vm) {
  vm._events = /* @__PURE__ */ Object.create(null);
  vm._hasHookEvent = false;
  var listeners = vm.$options._parentListeners;
  if (listeners) {
    updateComponentListeners(vm, listeners);
  }
}
var target$1;
function add$1(event, fn) {
  target$1.$on(event, fn);
}
function remove$1(event, fn) {
  target$1.$off(event, fn);
}
function createOnceHandler$1(event, fn) {
  var _target = target$1;
  return function onceHandler() {
    var res = fn.apply(null, arguments);
    if (res !== null) {
      _target.$off(event, onceHandler);
    }
  };
}
function updateComponentListeners(vm, listeners, oldListeners) {
  target$1 = vm;
  updateListeners(listeners, oldListeners || {}, add$1, remove$1, createOnceHandler$1, vm);
  target$1 = void 0;
}
function eventsMixin(Vue2) {
  var hookRE = /^hook:/;
  Vue2.prototype.$on = function(event, fn) {
    var vm = this;
    if (isArray$5(event)) {
      for (var i2 = 0, l2 = event.length; i2 < l2; i2++) {
        vm.$on(event[i2], fn);
      }
    } else {
      (vm._events[event] || (vm._events[event] = [])).push(fn);
      if (hookRE.test(event)) {
        vm._hasHookEvent = true;
      }
    }
    return vm;
  };
  Vue2.prototype.$once = function(event, fn) {
    var vm = this;
    function on() {
      vm.$off(event, on);
      fn.apply(vm, arguments);
    }
    on.fn = fn;
    vm.$on(event, on);
    return vm;
  };
  Vue2.prototype.$off = function(event, fn) {
    var vm = this;
    if (!arguments.length) {
      vm._events = /* @__PURE__ */ Object.create(null);
      return vm;
    }
    if (isArray$5(event)) {
      for (var i_1 = 0, l2 = event.length; i_1 < l2; i_1++) {
        vm.$off(event[i_1], fn);
      }
      return vm;
    }
    var cbs = vm._events[event];
    if (!cbs) {
      return vm;
    }
    if (!fn) {
      vm._events[event] = null;
      return vm;
    }
    var cb;
    var i2 = cbs.length;
    while (i2--) {
      cb = cbs[i2];
      if (cb === fn || cb.fn === fn) {
        cbs.splice(i2, 1);
        break;
      }
    }
    return vm;
  };
  Vue2.prototype.$emit = function(event) {
    var vm = this;
    var cbs = vm._events[event];
    if (cbs) {
      cbs = cbs.length > 1 ? toArray$1(cbs) : cbs;
      var args = toArray$1(arguments, 1);
      var info = 'event handler for "'.concat(event, '"');
      for (var i2 = 0, l2 = cbs.length; i2 < l2; i2++) {
        invokeWithErrorHandling(cbs[i2], vm, args, vm, info);
      }
    }
    return vm;
  };
}
var activeInstance = null;
function setActiveInstance(vm) {
  var prevActiveInstance = activeInstance;
  activeInstance = vm;
  return function() {
    activeInstance = prevActiveInstance;
  };
}
function initLifecycle(vm) {
  var options2 = vm.$options;
  var parent = options2.parent;
  if (parent && !options2.abstract) {
    while (parent.$options.abstract && parent.$parent) {
      parent = parent.$parent;
    }
    parent.$children.push(vm);
  }
  vm.$parent = parent;
  vm.$root = parent ? parent.$root : vm;
  vm.$children = [];
  vm.$refs = {};
  vm._provided = parent ? parent._provided : /* @__PURE__ */ Object.create(null);
  vm._watcher = null;
  vm._inactive = null;
  vm._directInactive = false;
  vm._isMounted = false;
  vm._isDestroyed = false;
  vm._isBeingDestroyed = false;
}
function lifecycleMixin(Vue2) {
  Vue2.prototype._update = function(vnode, hydrating) {
    var vm = this;
    var prevEl = vm.$el;
    var prevVnode = vm._vnode;
    var restoreActiveInstance = setActiveInstance(vm);
    vm._vnode = vnode;
    if (!prevVnode) {
      vm.$el = vm.__patch__(
        vm.$el,
        vnode,
        hydrating,
        false
        /* removeOnly */
      );
    } else {
      vm.$el = vm.__patch__(prevVnode, vnode);
    }
    restoreActiveInstance();
    if (prevEl) {
      prevEl.__vue__ = null;
    }
    if (vm.$el) {
      vm.$el.__vue__ = vm;
    }
    var wrapper = vm;
    while (wrapper && wrapper.$vnode && wrapper.$parent && wrapper.$vnode === wrapper.$parent._vnode) {
      wrapper.$parent.$el = wrapper.$el;
      wrapper = wrapper.$parent;
    }
  };
  Vue2.prototype.$forceUpdate = function() {
    var vm = this;
    if (vm._watcher) {
      vm._watcher.update();
    }
  };
  Vue2.prototype.$destroy = function() {
    var vm = this;
    if (vm._isBeingDestroyed) {
      return;
    }
    callHook$1(vm, "beforeDestroy");
    vm._isBeingDestroyed = true;
    var parent = vm.$parent;
    if (parent && !parent._isBeingDestroyed && !vm.$options.abstract) {
      remove$2(parent.$children, vm);
    }
    vm._scope.stop();
    if (vm._data.__ob__) {
      vm._data.__ob__.vmCount--;
    }
    vm._isDestroyed = true;
    vm.__patch__(vm._vnode, null);
    callHook$1(vm, "destroyed");
    vm.$off();
    if (vm.$el) {
      vm.$el.__vue__ = null;
    }
    if (vm.$vnode) {
      vm.$vnode.parent = null;
    }
  };
}
function mountComponent(vm, el, hydrating) {
  vm.$el = el;
  if (!vm.$options.render) {
    vm.$options.render = createEmptyVNode;
  }
  callHook$1(vm, "beforeMount");
  var updateComponent;
  {
    updateComponent = function() {
      vm._update(vm._render(), hydrating);
    };
  }
  var watcherOptions = {
    before: function() {
      if (vm._isMounted && !vm._isDestroyed) {
        callHook$1(vm, "beforeUpdate");
      }
    }
  };
  new Watcher(
    vm,
    updateComponent,
    noop$6,
    watcherOptions,
    true
    /* isRenderWatcher */
  );
  hydrating = false;
  var preWatchers = vm._preWatchers;
  if (preWatchers) {
    for (var i2 = 0; i2 < preWatchers.length; i2++) {
      preWatchers[i2].run();
    }
  }
  if (vm.$vnode == null) {
    vm._isMounted = true;
    callHook$1(vm, "mounted");
  }
  return vm;
}
function updateChildComponent(vm, propsData, listeners, parentVnode, renderChildren) {
  var newScopedSlots = parentVnode.data.scopedSlots;
  var oldScopedSlots = vm.$scopedSlots;
  var hasDynamicScopedSlot = !!(newScopedSlots && !newScopedSlots.$stable || oldScopedSlots !== emptyObject && !oldScopedSlots.$stable || newScopedSlots && vm.$scopedSlots.$key !== newScopedSlots.$key || !newScopedSlots && vm.$scopedSlots.$key);
  var needsForceUpdate = !!(renderChildren || // has new static slots
  vm.$options._renderChildren || // has old static slots
  hasDynamicScopedSlot);
  var prevVNode = vm.$vnode;
  vm.$options._parentVnode = parentVnode;
  vm.$vnode = parentVnode;
  if (vm._vnode) {
    vm._vnode.parent = parentVnode;
  }
  vm.$options._renderChildren = renderChildren;
  var attrs2 = parentVnode.data.attrs || emptyObject;
  if (vm._attrsProxy) {
    if (syncSetupProxy(vm._attrsProxy, attrs2, prevVNode.data && prevVNode.data.attrs || emptyObject, vm, "$attrs")) {
      needsForceUpdate = true;
    }
  }
  vm.$attrs = attrs2;
  listeners = listeners || emptyObject;
  var prevListeners = vm.$options._parentListeners;
  if (vm._listenersProxy) {
    syncSetupProxy(vm._listenersProxy, listeners, prevListeners || emptyObject, vm, "$listeners");
  }
  vm.$listeners = vm.$options._parentListeners = listeners;
  updateComponentListeners(vm, listeners, prevListeners);
  if (propsData && vm.$options.props) {
    toggleObserving(false);
    var props2 = vm._props;
    var propKeys = vm.$options._propKeys || [];
    for (var i2 = 0; i2 < propKeys.length; i2++) {
      var key = propKeys[i2];
      var propOptions = vm.$options.props;
      props2[key] = validateProp(key, propOptions, propsData, vm);
    }
    toggleObserving(true);
    vm.$options.propsData = propsData;
  }
  if (needsForceUpdate) {
    vm.$slots = resolveSlots(renderChildren, parentVnode.context);
    vm.$forceUpdate();
  }
}
function isInInactiveTree(vm) {
  while (vm && (vm = vm.$parent)) {
    if (vm._inactive)
      return true;
  }
  return false;
}
function activateChildComponent(vm, direct) {
  if (direct) {
    vm._directInactive = false;
    if (isInInactiveTree(vm)) {
      return;
    }
  } else if (vm._directInactive) {
    return;
  }
  if (vm._inactive || vm._inactive === null) {
    vm._inactive = false;
    for (var i2 = 0; i2 < vm.$children.length; i2++) {
      activateChildComponent(vm.$children[i2]);
    }
    callHook$1(vm, "activated");
  }
}
function deactivateChildComponent(vm, direct) {
  if (direct) {
    vm._directInactive = true;
    if (isInInactiveTree(vm)) {
      return;
    }
  }
  if (!vm._inactive) {
    vm._inactive = true;
    for (var i2 = 0; i2 < vm.$children.length; i2++) {
      deactivateChildComponent(vm.$children[i2]);
    }
    callHook$1(vm, "deactivated");
  }
}
function callHook$1(vm, hook, args, setContext) {
  if (setContext === void 0) {
    setContext = true;
  }
  pushTarget();
  var prevInst = currentInstance;
  var prevScope = getCurrentScope();
  setContext && setCurrentInstance(vm);
  var handlers = vm.$options[hook];
  var info = "".concat(hook, " hook");
  if (handlers) {
    for (var i2 = 0, j2 = handlers.length; i2 < j2; i2++) {
      invokeWithErrorHandling(handlers[i2], vm, null, vm, info);
    }
  }
  if (vm._hasHookEvent) {
    vm.$emit("hook:" + hook);
  }
  if (setContext) {
    setCurrentInstance(prevInst);
    prevScope && prevScope.on();
  }
  popTarget();
}
var queue$1 = [];
var activatedChildren = [];
var has$1 = {};
var waiting = false;
var flushing = false;
var index$2 = 0;
function resetSchedulerState() {
  index$2 = queue$1.length = activatedChildren.length = 0;
  has$1 = {};
  waiting = flushing = false;
}
var currentFlushTimestamp = 0;
var getNow = Date.now;
if (inBrowser$1 && !isIE$1) {
  var performance_1 = window.performance;
  if (performance_1 && typeof performance_1.now === "function" && getNow() > document.createEvent("Event").timeStamp) {
    getNow = function() {
      return performance_1.now();
    };
  }
}
var sortCompareFn = function(a3, b2) {
  if (a3.post) {
    if (!b2.post)
      return 1;
  } else if (b2.post) {
    return -1;
  }
  return a3.id - b2.id;
};
function flushSchedulerQueue() {
  currentFlushTimestamp = getNow();
  flushing = true;
  var watcher, id2;
  queue$1.sort(sortCompareFn);
  for (index$2 = 0; index$2 < queue$1.length; index$2++) {
    watcher = queue$1[index$2];
    if (watcher.before) {
      watcher.before();
    }
    id2 = watcher.id;
    has$1[id2] = null;
    watcher.run();
  }
  var activatedQueue = activatedChildren.slice();
  var updatedQueue = queue$1.slice();
  resetSchedulerState();
  callActivatedHooks(activatedQueue);
  callUpdatedHooks(updatedQueue);
  cleanupDeps();
  if (devtools && config$2.devtools) {
    devtools.emit("flush");
  }
}
function callUpdatedHooks(queue2) {
  var i2 = queue2.length;
  while (i2--) {
    var watcher = queue2[i2];
    var vm = watcher.vm;
    if (vm && vm._watcher === watcher && vm._isMounted && !vm._isDestroyed) {
      callHook$1(vm, "updated");
    }
  }
}
function queueActivatedComponent(vm) {
  vm._inactive = false;
  activatedChildren.push(vm);
}
function callActivatedHooks(queue2) {
  for (var i2 = 0; i2 < queue2.length; i2++) {
    queue2[i2]._inactive = true;
    activateChildComponent(
      queue2[i2],
      true
      /* true */
    );
  }
}
function queueWatcher(watcher) {
  var id2 = watcher.id;
  if (has$1[id2] != null) {
    return;
  }
  if (watcher === Dep.target && watcher.noRecurse) {
    return;
  }
  has$1[id2] = true;
  if (!flushing) {
    queue$1.push(watcher);
  } else {
    var i2 = queue$1.length - 1;
    while (i2 > index$2 && queue$1[i2].id > watcher.id) {
      i2--;
    }
    queue$1.splice(i2 + 1, 0, watcher);
  }
  if (!waiting) {
    waiting = true;
    nextTick(flushSchedulerQueue);
  }
}
function initProvide(vm) {
  var provideOption = vm.$options.provide;
  if (provideOption) {
    var provided = isFunction$2(provideOption) ? provideOption.call(vm) : provideOption;
    if (!isObject$f(provided)) {
      return;
    }
    var source = resolveProvided(vm);
    var keys3 = hasSymbol$1 ? Reflect.ownKeys(provided) : Object.keys(provided);
    for (var i2 = 0; i2 < keys3.length; i2++) {
      var key = keys3[i2];
      Object.defineProperty(source, key, Object.getOwnPropertyDescriptor(provided, key));
    }
  }
}
function initInjections(vm) {
  var result = resolveInject(vm.$options.inject, vm);
  if (result) {
    toggleObserving(false);
    Object.keys(result).forEach(function(key) {
      {
        defineReactive(vm, key, result[key]);
      }
    });
    toggleObserving(true);
  }
}
function resolveInject(inject2, vm) {
  if (inject2) {
    var result = /* @__PURE__ */ Object.create(null);
    var keys3 = hasSymbol$1 ? Reflect.ownKeys(inject2) : Object.keys(inject2);
    for (var i2 = 0; i2 < keys3.length; i2++) {
      var key = keys3[i2];
      if (key === "__ob__")
        continue;
      var provideKey = inject2[key].from;
      if (provideKey in vm._provided) {
        result[key] = vm._provided[provideKey];
      } else if ("default" in inject2[key]) {
        var provideDefault = inject2[key].default;
        result[key] = isFunction$2(provideDefault) ? provideDefault.call(vm) : provideDefault;
      } else ;
    }
    return result;
  }
}
function FunctionalRenderContext(data12, props2, children, parent, Ctor) {
  var _this = this;
  var options2 = Ctor.options;
  var contextVm;
  if (hasOwn$g(parent, "_uid")) {
    contextVm = Object.create(parent);
    contextVm._original = parent;
  } else {
    contextVm = parent;
    parent = parent._original;
  }
  var isCompiled = isTrue(options2._compiled);
  var needNormalization = !isCompiled;
  this.data = data12;
  this.props = props2;
  this.children = children;
  this.parent = parent;
  this.listeners = data12.on || emptyObject;
  this.injections = resolveInject(options2.inject, parent);
  this.slots = function() {
    if (!_this.$slots) {
      normalizeScopedSlots(parent, data12.scopedSlots, _this.$slots = resolveSlots(children, parent));
    }
    return _this.$slots;
  };
  Object.defineProperty(this, "scopedSlots", {
    enumerable: true,
    get: function() {
      return normalizeScopedSlots(parent, data12.scopedSlots, this.slots());
    }
  });
  if (isCompiled) {
    this.$options = options2;
    this.$slots = this.slots();
    this.$scopedSlots = normalizeScopedSlots(parent, data12.scopedSlots, this.$slots);
  }
  if (options2._scopeId) {
    this._c = function(a3, b2, c2, d3) {
      var vnode = createElement$1(contextVm, a3, b2, c2, d3, needNormalization);
      if (vnode && !isArray$5(vnode)) {
        vnode.fnScopeId = options2._scopeId;
        vnode.fnContext = parent;
      }
      return vnode;
    };
  } else {
    this._c = function(a3, b2, c2, d3) {
      return createElement$1(contextVm, a3, b2, c2, d3, needNormalization);
    };
  }
}
installRenderHelpers(FunctionalRenderContext.prototype);
function createFunctionalComponent(Ctor, propsData, data12, contextVm, children) {
  var options2 = Ctor.options;
  var props2 = {};
  var propOptions = options2.props;
  if (isDef(propOptions)) {
    for (var key in propOptions) {
      props2[key] = validateProp(key, propOptions, propsData || emptyObject);
    }
  } else {
    if (isDef(data12.attrs))
      mergeProps(props2, data12.attrs);
    if (isDef(data12.props))
      mergeProps(props2, data12.props);
  }
  var renderContext = new FunctionalRenderContext(data12, props2, children, contextVm, Ctor);
  var vnode = options2.render.call(null, renderContext._c, renderContext);
  if (vnode instanceof VNode) {
    return cloneAndMarkFunctionalResult(vnode, data12, renderContext.parent, options2);
  } else if (isArray$5(vnode)) {
    var vnodes = normalizeChildren(vnode) || [];
    var res = new Array(vnodes.length);
    for (var i2 = 0; i2 < vnodes.length; i2++) {
      res[i2] = cloneAndMarkFunctionalResult(vnodes[i2], data12, renderContext.parent, options2);
    }
    return res;
  }
}
function cloneAndMarkFunctionalResult(vnode, data12, contextVm, options2, renderContext) {
  var clone2 = cloneVNode(vnode);
  clone2.fnContext = contextVm;
  clone2.fnOptions = options2;
  if (data12.slot) {
    (clone2.data || (clone2.data = {})).slot = data12.slot;
  }
  return clone2;
}
function mergeProps(to, from) {
  for (var key in from) {
    to[camelize(key)] = from[key];
  }
}
function getComponentName(options2) {
  return options2.name || options2.__name || options2._componentTag;
}
var componentVNodeHooks = {
  init: function(vnode, hydrating) {
    if (vnode.componentInstance && !vnode.componentInstance._isDestroyed && vnode.data.keepAlive) {
      var mountedNode = vnode;
      componentVNodeHooks.prepatch(mountedNode, mountedNode);
    } else {
      var child = vnode.componentInstance = createComponentInstanceForVnode(vnode, activeInstance);
      child.$mount(hydrating ? vnode.elm : void 0, hydrating);
    }
  },
  prepatch: function(oldVnode, vnode) {
    var options2 = vnode.componentOptions;
    var child = vnode.componentInstance = oldVnode.componentInstance;
    updateChildComponent(
      child,
      options2.propsData,
      // updated props
      options2.listeners,
      // updated listeners
      vnode,
      // new parent vnode
      options2.children
      // new children
    );
  },
  insert: function(vnode) {
    var context = vnode.context, componentInstance = vnode.componentInstance;
    if (!componentInstance._isMounted) {
      componentInstance._isMounted = true;
      callHook$1(componentInstance, "mounted");
    }
    if (vnode.data.keepAlive) {
      if (context._isMounted) {
        queueActivatedComponent(componentInstance);
      } else {
        activateChildComponent(
          componentInstance,
          true
          /* direct */
        );
      }
    }
  },
  destroy: function(vnode) {
    var componentInstance = vnode.componentInstance;
    if (!componentInstance._isDestroyed) {
      if (!vnode.data.keepAlive) {
        componentInstance.$destroy();
      } else {
        deactivateChildComponent(
          componentInstance,
          true
          /* direct */
        );
      }
    }
  }
};
var hooksToMerge = Object.keys(componentVNodeHooks);
function createComponent(Ctor, data12, context, children, tag) {
  if (isUndef(Ctor)) {
    return;
  }
  var baseCtor = context.$options._base;
  if (isObject$f(Ctor)) {
    Ctor = baseCtor.extend(Ctor);
  }
  if (typeof Ctor !== "function") {
    return;
  }
  var asyncFactory;
  if (isUndef(Ctor.cid)) {
    asyncFactory = Ctor;
    Ctor = resolveAsyncComponent(asyncFactory, baseCtor);
    if (Ctor === void 0) {
      return createAsyncPlaceholder(asyncFactory, data12, context, children, tag);
    }
  }
  data12 = data12 || {};
  resolveConstructorOptions(Ctor);
  if (isDef(data12.model)) {
    transformModel(Ctor.options, data12);
  }
  var propsData = extractPropsFromVNodeData(data12, Ctor);
  if (isTrue(Ctor.options.functional)) {
    return createFunctionalComponent(Ctor, propsData, data12, context, children);
  }
  var listeners = data12.on;
  data12.on = data12.nativeOn;
  if (isTrue(Ctor.options.abstract)) {
    var slot = data12.slot;
    data12 = {};
    if (slot) {
      data12.slot = slot;
    }
  }
  installComponentHooks(data12);
  var name = getComponentName(Ctor.options) || tag;
  var vnode = new VNode(
    // @ts-expect-error
    "vue-component-".concat(Ctor.cid).concat(name ? "-".concat(name) : ""),
    data12,
    void 0,
    void 0,
    void 0,
    context,
    // @ts-expect-error
    { Ctor, propsData, listeners, tag, children },
    asyncFactory
  );
  return vnode;
}
function createComponentInstanceForVnode(vnode, parent) {
  var options2 = {
    _isComponent: true,
    _parentVnode: vnode,
    parent
  };
  var inlineTemplate = vnode.data.inlineTemplate;
  if (isDef(inlineTemplate)) {
    options2.render = inlineTemplate.render;
    options2.staticRenderFns = inlineTemplate.staticRenderFns;
  }
  return new vnode.componentOptions.Ctor(options2);
}
function installComponentHooks(data12) {
  var hooks2 = data12.hook || (data12.hook = {});
  for (var i2 = 0; i2 < hooksToMerge.length; i2++) {
    var key = hooksToMerge[i2];
    var existing = hooks2[key];
    var toMerge = componentVNodeHooks[key];
    if (existing !== toMerge && !(existing && existing._merged)) {
      hooks2[key] = existing ? mergeHook(toMerge, existing) : toMerge;
    }
  }
}
function mergeHook(f1, f2) {
  var merged = function(a3, b2) {
    f1(a3, b2);
    f2(a3, b2);
  };
  merged._merged = true;
  return merged;
}
function transformModel(options2, data12) {
  var prop = options2.model && options2.model.prop || "value";
  var event = options2.model && options2.model.event || "input";
  (data12.attrs || (data12.attrs = {}))[prop] = data12.model.value;
  var on = data12.on || (data12.on = {});
  var existing = on[event];
  var callback = data12.model.callback;
  if (isDef(existing)) {
    if (isArray$5(existing) ? existing.indexOf(callback) === -1 : existing !== callback) {
      on[event] = [callback].concat(existing);
    }
  } else {
    on[event] = callback;
  }
}
var warn = noop$6;
var strats = config$2.optionMergeStrategies;
function mergeData(to, from, recursive) {
  if (recursive === void 0) {
    recursive = true;
  }
  if (!from)
    return to;
  var key, toVal, fromVal;
  var keys3 = hasSymbol$1 ? Reflect.ownKeys(from) : Object.keys(from);
  for (var i2 = 0; i2 < keys3.length; i2++) {
    key = keys3[i2];
    if (key === "__ob__")
      continue;
    toVal = to[key];
    fromVal = from[key];
    if (!recursive || !hasOwn$g(to, key)) {
      set$1(to, key, fromVal);
    } else if (toVal !== fromVal && isPlainObject$1(toVal) && isPlainObject$1(fromVal)) {
      mergeData(toVal, fromVal);
    }
  }
  return to;
}
function mergeDataOrFn(parentVal, childVal, vm) {
  if (!vm) {
    if (!childVal) {
      return parentVal;
    }
    if (!parentVal) {
      return childVal;
    }
    return function mergedDataFn() {
      return mergeData(isFunction$2(childVal) ? childVal.call(this, this) : childVal, isFunction$2(parentVal) ? parentVal.call(this, this) : parentVal);
    };
  } else {
    return function mergedInstanceDataFn() {
      var instanceData = isFunction$2(childVal) ? childVal.call(vm, vm) : childVal;
      var defaultData = isFunction$2(parentVal) ? parentVal.call(vm, vm) : parentVal;
      if (instanceData) {
        return mergeData(instanceData, defaultData);
      } else {
        return defaultData;
      }
    };
  }
}
strats.data = function(parentVal, childVal, vm) {
  if (!vm) {
    if (childVal && typeof childVal !== "function") {
      return parentVal;
    }
    return mergeDataOrFn(parentVal, childVal);
  }
  return mergeDataOrFn(parentVal, childVal, vm);
};
function mergeLifecycleHook(parentVal, childVal) {
  var res = childVal ? parentVal ? parentVal.concat(childVal) : isArray$5(childVal) ? childVal : [childVal] : parentVal;
  return res ? dedupeHooks(res) : res;
}
function dedupeHooks(hooks2) {
  var res = [];
  for (var i2 = 0; i2 < hooks2.length; i2++) {
    if (res.indexOf(hooks2[i2]) === -1) {
      res.push(hooks2[i2]);
    }
  }
  return res;
}
LIFECYCLE_HOOKS.forEach(function(hook) {
  strats[hook] = mergeLifecycleHook;
});
function mergeAssets(parentVal, childVal, vm, key) {
  var res = Object.create(parentVal || null);
  if (childVal) {
    return extend$2(res, childVal);
  } else {
    return res;
  }
}
ASSET_TYPES.forEach(function(type) {
  strats[type + "s"] = mergeAssets;
});
strats.watch = function(parentVal, childVal, vm, key) {
  if (parentVal === nativeWatch)
    parentVal = void 0;
  if (childVal === nativeWatch)
    childVal = void 0;
  if (!childVal)
    return Object.create(parentVal || null);
  if (!parentVal)
    return childVal;
  var ret = {};
  extend$2(ret, parentVal);
  for (var key_1 in childVal) {
    var parent_1 = ret[key_1];
    var child = childVal[key_1];
    if (parent_1 && !isArray$5(parent_1)) {
      parent_1 = [parent_1];
    }
    ret[key_1] = parent_1 ? parent_1.concat(child) : isArray$5(child) ? child : [child];
  }
  return ret;
};
strats.props = strats.methods = strats.inject = strats.computed = function(parentVal, childVal, vm, key) {
  if (childVal && false) {
    assertObjectType(key, childVal);
  }
  if (!parentVal)
    return childVal;
  var ret = /* @__PURE__ */ Object.create(null);
  extend$2(ret, parentVal);
  if (childVal)
    extend$2(ret, childVal);
  return ret;
};
strats.provide = function(parentVal, childVal) {
  if (!parentVal)
    return childVal;
  return function() {
    var ret = /* @__PURE__ */ Object.create(null);
    mergeData(ret, isFunction$2(parentVal) ? parentVal.call(this) : parentVal);
    if (childVal) {
      mergeData(
        ret,
        isFunction$2(childVal) ? childVal.call(this) : childVal,
        false
        // non-recursive
      );
    }
    return ret;
  };
};
var defaultStrat = function(parentVal, childVal) {
  return childVal === void 0 ? parentVal : childVal;
};
function normalizeProps(options2, vm) {
  var props2 = options2.props;
  if (!props2)
    return;
  var res = {};
  var i2, val2, name;
  if (isArray$5(props2)) {
    i2 = props2.length;
    while (i2--) {
      val2 = props2[i2];
      if (typeof val2 === "string") {
        name = camelize(val2);
        res[name] = { type: null };
      }
    }
  } else if (isPlainObject$1(props2)) {
    for (var key in props2) {
      val2 = props2[key];
      name = camelize(key);
      res[name] = isPlainObject$1(val2) ? val2 : { type: val2 };
    }
  } else ;
  options2.props = res;
}
function normalizeInject(options2, vm) {
  var inject2 = options2.inject;
  if (!inject2)
    return;
  var normalized = options2.inject = {};
  if (isArray$5(inject2)) {
    for (var i2 = 0; i2 < inject2.length; i2++) {
      normalized[inject2[i2]] = { from: inject2[i2] };
    }
  } else if (isPlainObject$1(inject2)) {
    for (var key in inject2) {
      var val2 = inject2[key];
      normalized[key] = isPlainObject$1(val2) ? extend$2({ from: key }, val2) : { from: val2 };
    }
  } else ;
}
function normalizeDirectives$1(options2) {
  var dirs = options2.directives;
  if (dirs) {
    for (var key in dirs) {
      var def2 = dirs[key];
      if (isFunction$2(def2)) {
        dirs[key] = { bind: def2, update: def2 };
      }
    }
  }
}
function assertObjectType(name, value3, vm) {
  if (!isPlainObject$1(value3)) {
    warn('Invalid value for option "'.concat(name, '": expected an Object, ') + "but got ".concat(toRawType(value3), "."));
  }
}
function mergeOptions(parent, child, vm) {
  if (isFunction$2(child)) {
    child = child.options;
  }
  normalizeProps(child);
  normalizeInject(child);
  normalizeDirectives$1(child);
  if (!child._base) {
    if (child.extends) {
      parent = mergeOptions(parent, child.extends, vm);
    }
    if (child.mixins) {
      for (var i2 = 0, l2 = child.mixins.length; i2 < l2; i2++) {
        parent = mergeOptions(parent, child.mixins[i2], vm);
      }
    }
  }
  var options2 = {};
  var key;
  for (key in parent) {
    mergeField(key);
  }
  for (key in child) {
    if (!hasOwn$g(parent, key)) {
      mergeField(key);
    }
  }
  function mergeField(key2) {
    var strat = strats[key2] || defaultStrat;
    options2[key2] = strat(parent[key2], child[key2], vm, key2);
  }
  return options2;
}
function resolveAsset(options2, type, id2, warnMissing) {
  if (typeof id2 !== "string") {
    return;
  }
  var assets = options2[type];
  if (hasOwn$g(assets, id2))
    return assets[id2];
  var camelizedId = camelize(id2);
  if (hasOwn$g(assets, camelizedId))
    return assets[camelizedId];
  var PascalCaseId = capitalize(camelizedId);
  if (hasOwn$g(assets, PascalCaseId))
    return assets[PascalCaseId];
  var res = assets[id2] || assets[camelizedId] || assets[PascalCaseId];
  return res;
}
function validateProp(key, propOptions, propsData, vm) {
  var prop = propOptions[key];
  var absent = !hasOwn$g(propsData, key);
  var value3 = propsData[key];
  var booleanIndex = getTypeIndex(Boolean, prop.type);
  if (booleanIndex > -1) {
    if (absent && !hasOwn$g(prop, "default")) {
      value3 = false;
    } else if (value3 === "" || value3 === hyphenate(key)) {
      var stringIndex = getTypeIndex(String, prop.type);
      if (stringIndex < 0 || booleanIndex < stringIndex) {
        value3 = true;
      }
    }
  }
  if (value3 === void 0) {
    value3 = getPropDefaultValue(vm, prop, key);
    var prevShouldObserve = shouldObserve;
    toggleObserving(true);
    observe(value3);
    toggleObserving(prevShouldObserve);
  }
  return value3;
}
function getPropDefaultValue(vm, prop, key) {
  if (!hasOwn$g(prop, "default")) {
    return void 0;
  }
  var def2 = prop.default;
  if (vm && vm.$options.propsData && vm.$options.propsData[key] === void 0 && vm._props[key] !== void 0) {
    return vm._props[key];
  }
  return isFunction$2(def2) && getType(prop.type) !== "Function" ? def2.call(vm) : def2;
}
var functionTypeCheckRE = /^\s*function (\w+)/;
function getType(fn) {
  var match6 = fn && fn.toString().match(functionTypeCheckRE);
  return match6 ? match6[1] : "";
}
function isSameType(a3, b2) {
  return getType(a3) === getType(b2);
}
function getTypeIndex(type, expectedTypes) {
  if (!isArray$5(expectedTypes)) {
    return isSameType(expectedTypes, type) ? 0 : -1;
  }
  for (var i2 = 0, len = expectedTypes.length; i2 < len; i2++) {
    if (isSameType(expectedTypes[i2], type)) {
      return i2;
    }
  }
  return -1;
}
var sharedPropertyDefinition = {
  enumerable: true,
  configurable: true,
  get: noop$6,
  set: noop$6
};
function proxy(target2, sourceKey, key) {
  sharedPropertyDefinition.get = function proxyGetter() {
    return this[sourceKey][key];
  };
  sharedPropertyDefinition.set = function proxySetter(val2) {
    this[sourceKey][key] = val2;
  };
  Object.defineProperty(target2, key, sharedPropertyDefinition);
}
function initState(vm) {
  var opts = vm.$options;
  if (opts.props)
    initProps$1(vm, opts.props);
  initSetup(vm);
  if (opts.methods)
    initMethods(vm, opts.methods);
  if (opts.data) {
    initData(vm);
  } else {
    var ob = observe(vm._data = {});
    ob && ob.vmCount++;
  }
  if (opts.computed)
    initComputed$1(vm, opts.computed);
  if (opts.watch && opts.watch !== nativeWatch) {
    initWatch(vm, opts.watch);
  }
}
function initProps$1(vm, propsOptions) {
  var propsData = vm.$options.propsData || {};
  var props2 = vm._props = shallowReactive({});
  var keys3 = vm.$options._propKeys = [];
  var isRoot = !vm.$parent;
  if (!isRoot) {
    toggleObserving(false);
  }
  var _loop_1 = function(key2) {
    keys3.push(key2);
    var value3 = validateProp(key2, propsOptions, propsData, vm);
    {
      defineReactive(
        props2,
        key2,
        value3,
        void 0,
        true
        /* shallow */
      );
    }
    if (!(key2 in vm)) {
      proxy(vm, "_props", key2);
    }
  };
  for (var key in propsOptions) {
    _loop_1(key);
  }
  toggleObserving(true);
}
function initData(vm) {
  var data12 = vm.$options.data;
  data12 = vm._data = isFunction$2(data12) ? getData(data12, vm) : data12 || {};
  if (!isPlainObject$1(data12)) {
    data12 = {};
  }
  var keys3 = Object.keys(data12);
  var props2 = vm.$options.props;
  vm.$options.methods;
  var i2 = keys3.length;
  while (i2--) {
    var key = keys3[i2];
    if (props2 && hasOwn$g(props2, key)) ;
    else if (!isReserved(key)) {
      proxy(vm, "_data", key);
    }
  }
  var ob = observe(data12);
  ob && ob.vmCount++;
}
function getData(data12, vm) {
  pushTarget();
  try {
    return data12.call(vm, vm);
  } catch (e2) {
    handleError(e2, vm, "data()");
    return {};
  } finally {
    popTarget();
  }
}
var computedWatcherOptions = { lazy: true };
function initComputed$1(vm, computed2) {
  var watchers = vm._computedWatchers = /* @__PURE__ */ Object.create(null);
  var isSSR = isServerRendering();
  for (var key in computed2) {
    var userDef = computed2[key];
    var getter = isFunction$2(userDef) ? userDef : userDef.get;
    if (!isSSR) {
      watchers[key] = new Watcher(vm, getter || noop$6, noop$6, computedWatcherOptions);
    }
    if (!(key in vm)) {
      defineComputed(vm, key, userDef);
    }
  }
}
function defineComputed(target2, key, userDef) {
  var shouldCache = !isServerRendering();
  if (isFunction$2(userDef)) {
    sharedPropertyDefinition.get = shouldCache ? createComputedGetter(key) : createGetterInvoker(userDef);
    sharedPropertyDefinition.set = noop$6;
  } else {
    sharedPropertyDefinition.get = userDef.get ? shouldCache && userDef.cache !== false ? createComputedGetter(key) : createGetterInvoker(userDef.get) : noop$6;
    sharedPropertyDefinition.set = userDef.set || noop$6;
  }
  Object.defineProperty(target2, key, sharedPropertyDefinition);
}
function createComputedGetter(key) {
  return function computedGetter() {
    var watcher = this._computedWatchers && this._computedWatchers[key];
    if (watcher) {
      if (watcher.dirty) {
        watcher.evaluate();
      }
      if (Dep.target) {
        watcher.depend();
      }
      return watcher.value;
    }
  };
}
function createGetterInvoker(fn) {
  return function computedGetter() {
    return fn.call(this, this);
  };
}
function initMethods(vm, methods) {
  vm.$options.props;
  for (var key in methods) {
    vm[key] = typeof methods[key] !== "function" ? noop$6 : bind$4(methods[key], vm);
  }
}
function initWatch(vm, watch2) {
  for (var key in watch2) {
    var handler9 = watch2[key];
    if (isArray$5(handler9)) {
      for (var i2 = 0; i2 < handler9.length; i2++) {
        createWatcher(vm, key, handler9[i2]);
      }
    } else {
      createWatcher(vm, key, handler9);
    }
  }
}
function createWatcher(vm, expOrFn, handler9, options2) {
  if (isPlainObject$1(handler9)) {
    options2 = handler9;
    handler9 = handler9.handler;
  }
  if (typeof handler9 === "string") {
    handler9 = vm[handler9];
  }
  return vm.$watch(expOrFn, handler9, options2);
}
function stateMixin(Vue2) {
  var dataDef = {};
  dataDef.get = function() {
    return this._data;
  };
  var propsDef = {};
  propsDef.get = function() {
    return this._props;
  };
  Object.defineProperty(Vue2.prototype, "$data", dataDef);
  Object.defineProperty(Vue2.prototype, "$props", propsDef);
  Vue2.prototype.$set = set$1;
  Vue2.prototype.$delete = del;
  Vue2.prototype.$watch = function(expOrFn, cb, options2) {
    var vm = this;
    if (isPlainObject$1(cb)) {
      return createWatcher(vm, expOrFn, cb, options2);
    }
    options2 = options2 || {};
    options2.user = true;
    var watcher = new Watcher(vm, expOrFn, cb, options2);
    if (options2.immediate) {
      var info = 'callback for immediate watcher "'.concat(watcher.expression, '"');
      pushTarget();
      invokeWithErrorHandling(cb, vm, [watcher.value], vm, info);
      popTarget();
    }
    return function unwatchFn() {
      watcher.teardown();
    };
  };
}
var uid$4 = 0;
function initMixin$1(Vue2) {
  Vue2.prototype._init = function(options2) {
    var vm = this;
    vm._uid = uid$4++;
    vm._isVue = true;
    vm.__v_skip = true;
    vm._scope = new EffectScope(
      true
      /* detached */
    );
    vm._scope.parent = void 0;
    vm._scope._vm = true;
    if (options2 && options2._isComponent) {
      initInternalComponent(vm, options2);
    } else {
      vm.$options = mergeOptions(resolveConstructorOptions(vm.constructor), options2 || {}, vm);
    }
    {
      vm._renderProxy = vm;
    }
    vm._self = vm;
    initLifecycle(vm);
    initEvents(vm);
    initRender(vm);
    callHook$1(
      vm,
      "beforeCreate",
      void 0,
      false
      /* setContext */
    );
    initInjections(vm);
    initState(vm);
    initProvide(vm);
    callHook$1(vm, "created");
    if (vm.$options.el) {
      vm.$mount(vm.$options.el);
    }
  };
}
function initInternalComponent(vm, options2) {
  var opts = vm.$options = Object.create(vm.constructor.options);
  var parentVnode = options2._parentVnode;
  opts.parent = options2.parent;
  opts._parentVnode = parentVnode;
  var vnodeComponentOptions = parentVnode.componentOptions;
  opts.propsData = vnodeComponentOptions.propsData;
  opts._parentListeners = vnodeComponentOptions.listeners;
  opts._renderChildren = vnodeComponentOptions.children;
  opts._componentTag = vnodeComponentOptions.tag;
  if (options2.render) {
    opts.render = options2.render;
    opts.staticRenderFns = options2.staticRenderFns;
  }
}
function resolveConstructorOptions(Ctor) {
  var options2 = Ctor.options;
  if (Ctor.super) {
    var superOptions = resolveConstructorOptions(Ctor.super);
    var cachedSuperOptions = Ctor.superOptions;
    if (superOptions !== cachedSuperOptions) {
      Ctor.superOptions = superOptions;
      var modifiedOptions = resolveModifiedOptions(Ctor);
      if (modifiedOptions) {
        extend$2(Ctor.extendOptions, modifiedOptions);
      }
      options2 = Ctor.options = mergeOptions(superOptions, Ctor.extendOptions);
      if (options2.name) {
        options2.components[options2.name] = Ctor;
      }
    }
  }
  return options2;
}
function resolveModifiedOptions(Ctor) {
  var modified;
  var latest = Ctor.options;
  var sealed = Ctor.sealedOptions;
  for (var key in latest) {
    if (latest[key] !== sealed[key]) {
      if (!modified)
        modified = {};
      modified[key] = latest[key];
    }
  }
  return modified;
}
function Vue(options2) {
  this._init(options2);
}
initMixin$1(Vue);
stateMixin(Vue);
eventsMixin(Vue);
lifecycleMixin(Vue);
renderMixin(Vue);
function initUse(Vue2) {
  Vue2.use = function(plugin2) {
    var installedPlugins = this._installedPlugins || (this._installedPlugins = []);
    if (installedPlugins.indexOf(plugin2) > -1) {
      return this;
    }
    var args = toArray$1(arguments, 1);
    args.unshift(this);
    if (isFunction$2(plugin2.install)) {
      plugin2.install.apply(plugin2, args);
    } else if (isFunction$2(plugin2)) {
      plugin2.apply(null, args);
    }
    installedPlugins.push(plugin2);
    return this;
  };
}
function initMixin(Vue2) {
  Vue2.mixin = function(mixin) {
    this.options = mergeOptions(this.options, mixin);
    return this;
  };
}
function initExtend(Vue2) {
  Vue2.cid = 0;
  var cid = 1;
  Vue2.extend = function(extendOptions) {
    extendOptions = extendOptions || {};
    var Super = this;
    var SuperId = Super.cid;
    var cachedCtors = extendOptions._Ctor || (extendOptions._Ctor = {});
    if (cachedCtors[SuperId]) {
      return cachedCtors[SuperId];
    }
    var name = getComponentName(extendOptions) || getComponentName(Super.options);
    var Sub = function VueComponent(options2) {
      this._init(options2);
    };
    Sub.prototype = Object.create(Super.prototype);
    Sub.prototype.constructor = Sub;
    Sub.cid = cid++;
    Sub.options = mergeOptions(Super.options, extendOptions);
    Sub["super"] = Super;
    if (Sub.options.props) {
      initProps(Sub);
    }
    if (Sub.options.computed) {
      initComputed(Sub);
    }
    Sub.extend = Super.extend;
    Sub.mixin = Super.mixin;
    Sub.use = Super.use;
    ASSET_TYPES.forEach(function(type) {
      Sub[type] = Super[type];
    });
    if (name) {
      Sub.options.components[name] = Sub;
    }
    Sub.superOptions = Super.options;
    Sub.extendOptions = extendOptions;
    Sub.sealedOptions = extend$2({}, Sub.options);
    cachedCtors[SuperId] = Sub;
    return Sub;
  };
}
function initProps(Comp) {
  var props2 = Comp.options.props;
  for (var key in props2) {
    proxy(Comp.prototype, "_props", key);
  }
}
function initComputed(Comp) {
  var computed2 = Comp.options.computed;
  for (var key in computed2) {
    defineComputed(Comp.prototype, key, computed2[key]);
  }
}
function initAssetRegisters(Vue2) {
  ASSET_TYPES.forEach(function(type) {
    Vue2[type] = function(id2, definition) {
      if (!definition) {
        return this.options[type + "s"][id2];
      } else {
        if (type === "component" && isPlainObject$1(definition)) {
          definition.name = definition.name || id2;
          definition = this.options._base.extend(definition);
        }
        if (type === "directive" && isFunction$2(definition)) {
          definition = { bind: definition, update: definition };
        }
        this.options[type + "s"][id2] = definition;
        return definition;
      }
    };
  });
}
function _getComponentName(opts) {
  return opts && (getComponentName(opts.Ctor.options) || opts.tag);
}
function matches$1(pattern, name) {
  if (isArray$5(pattern)) {
    return pattern.indexOf(name) > -1;
  } else if (typeof pattern === "string") {
    return pattern.split(",").indexOf(name) > -1;
  } else if (isRegExp$1(pattern)) {
    return pattern.test(name);
  }
  return false;
}
function pruneCache(keepAliveInstance, filter2) {
  var cache = keepAliveInstance.cache, keys3 = keepAliveInstance.keys, _vnode = keepAliveInstance._vnode, $vnode = keepAliveInstance.$vnode;
  for (var key in cache) {
    var entry = cache[key];
    if (entry) {
      var name_1 = entry.name;
      if (name_1 && !filter2(name_1)) {
        pruneCacheEntry(cache, key, keys3, _vnode);
      }
    }
  }
  $vnode.componentOptions.children = void 0;
}
function pruneCacheEntry(cache, key, keys3, current) {
  var entry = cache[key];
  if (entry && (!current || entry.tag !== current.tag)) {
    entry.componentInstance.$destroy();
  }
  cache[key] = null;
  remove$2(keys3, key);
}
var patternTypes = [String, RegExp, Array];
var KeepAlive = {
  name: "keep-alive",
  abstract: true,
  props: {
    include: patternTypes,
    exclude: patternTypes,
    max: [String, Number]
  },
  methods: {
    cacheVNode: function() {
      var _a2 = this, cache = _a2.cache, keys3 = _a2.keys, vnodeToCache = _a2.vnodeToCache, keyToCache = _a2.keyToCache;
      if (vnodeToCache) {
        var tag = vnodeToCache.tag, componentInstance = vnodeToCache.componentInstance, componentOptions = vnodeToCache.componentOptions;
        cache[keyToCache] = {
          name: _getComponentName(componentOptions),
          tag,
          componentInstance
        };
        keys3.push(keyToCache);
        if (this.max && keys3.length > parseInt(this.max)) {
          pruneCacheEntry(cache, keys3[0], keys3, this._vnode);
        }
        this.vnodeToCache = null;
      }
    }
  },
  created: function() {
    this.cache = /* @__PURE__ */ Object.create(null);
    this.keys = [];
  },
  destroyed: function() {
    for (var key in this.cache) {
      pruneCacheEntry(this.cache, key, this.keys);
    }
  },
  mounted: function() {
    var _this = this;
    this.cacheVNode();
    this.$watch("include", function(val2) {
      pruneCache(_this, function(name) {
        return matches$1(val2, name);
      });
    });
    this.$watch("exclude", function(val2) {
      pruneCache(_this, function(name) {
        return !matches$1(val2, name);
      });
    });
  },
  updated: function() {
    this.cacheVNode();
  },
  render: function() {
    var slot = this.$slots.default;
    var vnode = getFirstComponentChild(slot);
    var componentOptions = vnode && vnode.componentOptions;
    if (componentOptions) {
      var name_2 = _getComponentName(componentOptions);
      var _a2 = this, include = _a2.include, exclude = _a2.exclude;
      if (
        // not included
        include && (!name_2 || !matches$1(include, name_2)) || // excluded
        exclude && name_2 && matches$1(exclude, name_2)
      ) {
        return vnode;
      }
      var _b2 = this, cache = _b2.cache, keys3 = _b2.keys;
      var key = vnode.key == null ? (
        // same constructor may get registered as different local components
        // so cid alone is not enough (#3269)
        componentOptions.Ctor.cid + (componentOptions.tag ? "::".concat(componentOptions.tag) : "")
      ) : vnode.key;
      if (cache[key]) {
        vnode.componentInstance = cache[key].componentInstance;
        remove$2(keys3, key);
        keys3.push(key);
      } else {
        this.vnodeToCache = vnode;
        this.keyToCache = key;
      }
      vnode.data.keepAlive = true;
    }
    return vnode || slot && slot[0];
  }
};
var builtInComponents = {
  KeepAlive
};
function initGlobalAPI(Vue2) {
  var configDef = {};
  configDef.get = function() {
    return config$2;
  };
  Object.defineProperty(Vue2, "config", configDef);
  Vue2.util = {
    warn,
    extend: extend$2,
    mergeOptions,
    defineReactive
  };
  Vue2.set = set$1;
  Vue2.delete = del;
  Vue2.nextTick = nextTick;
  Vue2.observable = function(obj) {
    observe(obj);
    return obj;
  };
  Vue2.options = /* @__PURE__ */ Object.create(null);
  ASSET_TYPES.forEach(function(type) {
    Vue2.options[type + "s"] = /* @__PURE__ */ Object.create(null);
  });
  Vue2.options._base = Vue2;
  extend$2(Vue2.options.components, builtInComponents);
  initUse(Vue2);
  initMixin(Vue2);
  initExtend(Vue2);
  initAssetRegisters(Vue2);
}
initGlobalAPI(Vue);
Object.defineProperty(Vue.prototype, "$isServer", {
  get: isServerRendering
});
Object.defineProperty(Vue.prototype, "$ssrContext", {
  get: function() {
    return this.$vnode && this.$vnode.ssrContext;
  }
});
Object.defineProperty(Vue, "FunctionalRenderContext", {
  value: FunctionalRenderContext
});
Vue.version = version$2;
var isReservedAttr = makeMap("style,class");
var acceptValue = makeMap("input,textarea,option,select,progress");
var mustUseProp = function(tag, type, attr) {
  return attr === "value" && acceptValue(tag) && type !== "button" || attr === "selected" && tag === "option" || attr === "checked" && tag === "input" || attr === "muted" && tag === "video";
};
var isEnumeratedAttr = makeMap("contenteditable,draggable,spellcheck");
var isValidContentEditableValue = makeMap("events,caret,typing,plaintext-only");
var convertEnumeratedValue = function(key, value3) {
  return isFalsyAttrValue(value3) || value3 === "false" ? "false" : (
    // allow arbitrary string value for contenteditable
    key === "contenteditable" && isValidContentEditableValue(value3) ? value3 : "true"
  );
};
var isBooleanAttr = makeMap("allowfullscreen,async,autofocus,autoplay,checked,compact,controls,declare,default,defaultchecked,defaultmuted,defaultselected,defer,disabled,enabled,formnovalidate,hidden,indeterminate,inert,ismap,itemscope,loop,multiple,muted,nohref,noresize,noshade,novalidate,nowrap,open,pauseonexit,readonly,required,reversed,scoped,seamless,selected,sortable,truespeed,typemustmatch,visible");
var xlinkNS = "http://www.w3.org/1999/xlink";
var isXlink = function(name) {
  return name.charAt(5) === ":" && name.slice(0, 5) === "xlink";
};
var getXlinkProp = function(name) {
  return isXlink(name) ? name.slice(6, name.length) : "";
};
var isFalsyAttrValue = function(val2) {
  return val2 == null || val2 === false;
};
function genClassForVnode(vnode) {
  var data12 = vnode.data;
  var parentNode2 = vnode;
  var childNode = vnode;
  while (isDef(childNode.componentInstance)) {
    childNode = childNode.componentInstance._vnode;
    if (childNode && childNode.data) {
      data12 = mergeClassData(childNode.data, data12);
    }
  }
  while (isDef(parentNode2 = parentNode2.parent)) {
    if (parentNode2 && parentNode2.data) {
      data12 = mergeClassData(data12, parentNode2.data);
    }
  }
  return renderClass(data12.staticClass, data12.class);
}
function mergeClassData(child, parent) {
  return {
    staticClass: concat$3(child.staticClass, parent.staticClass),
    class: isDef(child.class) ? [child.class, parent.class] : parent.class
  };
}
function renderClass(staticClass, dynamicClass) {
  if (isDef(staticClass) || isDef(dynamicClass)) {
    return concat$3(staticClass, stringifyClass(dynamicClass));
  }
  return "";
}
function concat$3(a3, b2) {
  return a3 ? b2 ? a3 + " " + b2 : a3 : b2 || "";
}
function stringifyClass(value3) {
  if (Array.isArray(value3)) {
    return stringifyArray(value3);
  }
  if (isObject$f(value3)) {
    return stringifyObject(value3);
  }
  if (typeof value3 === "string") {
    return value3;
  }
  return "";
}
function stringifyArray(value3) {
  var res = "";
  var stringified;
  for (var i2 = 0, l2 = value3.length; i2 < l2; i2++) {
    if (isDef(stringified = stringifyClass(value3[i2])) && stringified !== "") {
      if (res)
        res += " ";
      res += stringified;
    }
  }
  return res;
}
function stringifyObject(value3) {
  var res = "";
  for (var key in value3) {
    if (value3[key]) {
      if (res)
        res += " ";
      res += key;
    }
  }
  return res;
}
var namespaceMap = {
  svg: "http://www.w3.org/2000/svg",
  math: "http://www.w3.org/1998/Math/MathML"
};
var isHTMLTag = makeMap("html,body,base,head,link,meta,style,title,address,article,aside,footer,header,h1,h2,h3,h4,h5,h6,hgroup,nav,section,div,dd,dl,dt,figcaption,figure,picture,hr,img,li,main,ol,p,pre,ul,a,b,abbr,bdi,bdo,br,cite,code,data,dfn,em,i,kbd,mark,q,rp,rt,rtc,ruby,s,samp,small,span,strong,sub,sup,time,u,var,wbr,area,audio,map,track,video,embed,object,param,source,canvas,script,noscript,del,ins,caption,col,colgroup,table,thead,tbody,td,th,tr,button,datalist,fieldset,form,input,label,legend,meter,optgroup,option,output,progress,select,textarea,details,dialog,menu,menuitem,summary,content,element,shadow,template,blockquote,iframe,tfoot");
var isSVG = makeMap("svg,animate,circle,clippath,cursor,defs,desc,ellipse,filter,font-face,foreignobject,g,glyph,image,line,marker,mask,missing-glyph,path,pattern,polygon,polyline,rect,switch,symbol,text,textpath,tspan,use,view", true);
var isReservedTag = function(tag) {
  return isHTMLTag(tag) || isSVG(tag);
};
function getTagNamespace(tag) {
  if (isSVG(tag)) {
    return "svg";
  }
  if (tag === "math") {
    return "math";
  }
}
var unknownElementCache = /* @__PURE__ */ Object.create(null);
function isUnknownElement(tag) {
  if (!inBrowser$1) {
    return true;
  }
  if (isReservedTag(tag)) {
    return false;
  }
  tag = tag.toLowerCase();
  if (unknownElementCache[tag] != null) {
    return unknownElementCache[tag];
  }
  var el = document.createElement(tag);
  if (tag.indexOf("-") > -1) {
    return unknownElementCache[tag] = el.constructor === window.HTMLUnknownElement || el.constructor === window.HTMLElement;
  } else {
    return unknownElementCache[tag] = /HTMLUnknownElement/.test(el.toString());
  }
}
var isTextInputType = makeMap("text,number,password,search,email,tel,url");
function query(el) {
  if (typeof el === "string") {
    var selected = document.querySelector(el);
    if (!selected) {
      return document.createElement("div");
    }
    return selected;
  } else {
    return el;
  }
}
function createElement$2(tagName2, vnode) {
  var elm = document.createElement(tagName2);
  if (tagName2 !== "select") {
    return elm;
  }
  if (vnode.data && vnode.data.attrs && vnode.data.attrs.multiple !== void 0) {
    elm.setAttribute("multiple", "multiple");
  }
  return elm;
}
function createElementNS(namespace, tagName2) {
  return document.createElementNS(namespaceMap[namespace], tagName2);
}
function createTextNode(text3) {
  return document.createTextNode(text3);
}
function createComment(text3) {
  return document.createComment(text3);
}
function insertBefore(parentNode2, newNode, referenceNode) {
  parentNode2.insertBefore(newNode, referenceNode);
}
function removeChild(node, child) {
  node.removeChild(child);
}
function appendChild(node, child) {
  node.appendChild(child);
}
function parentNode(node) {
  return node.parentNode;
}
function nextSibling(node) {
  return node.nextSibling;
}
function tagName(node) {
  return node.tagName;
}
function setTextContent(node, text3) {
  node.textContent = text3;
}
function setStyleScope(node, scopeId) {
  node.setAttribute(scopeId, "");
}
var nodeOps = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  createElement: createElement$2,
  createElementNS,
  createTextNode,
  createComment,
  insertBefore,
  removeChild,
  appendChild,
  parentNode,
  nextSibling,
  tagName,
  setTextContent,
  setStyleScope
});
var ref = {
  create: function(_2, vnode) {
    registerRef(vnode);
  },
  update: function(oldVnode, vnode) {
    if (oldVnode.data.ref !== vnode.data.ref) {
      registerRef(oldVnode, true);
      registerRef(vnode);
    }
  },
  destroy: function(vnode) {
    registerRef(vnode, true);
  }
};
function registerRef(vnode, isRemoval) {
  var ref2 = vnode.data.ref;
  if (!isDef(ref2))
    return;
  var vm = vnode.context;
  var refValue = vnode.componentInstance || vnode.elm;
  var value3 = isRemoval ? null : refValue;
  var $refsValue = isRemoval ? void 0 : refValue;
  if (isFunction$2(ref2)) {
    invokeWithErrorHandling(ref2, vm, [value3], vm, "template ref function");
    return;
  }
  var isFor = vnode.data.refInFor;
  var _isString = typeof ref2 === "string" || typeof ref2 === "number";
  var _isRef = isRef(ref2);
  var refs = vm.$refs;
  if (_isString || _isRef) {
    if (isFor) {
      var existing = _isString ? refs[ref2] : ref2.value;
      if (isRemoval) {
        isArray$5(existing) && remove$2(existing, refValue);
      } else {
        if (!isArray$5(existing)) {
          if (_isString) {
            refs[ref2] = [refValue];
            setSetupRef(vm, ref2, refs[ref2]);
          } else {
            ref2.value = [refValue];
          }
        } else if (!existing.includes(refValue)) {
          existing.push(refValue);
        }
      }
    } else if (_isString) {
      if (isRemoval && refs[ref2] !== refValue) {
        return;
      }
      refs[ref2] = $refsValue;
      setSetupRef(vm, ref2, value3);
    } else if (_isRef) {
      if (isRemoval && ref2.value !== refValue) {
        return;
      }
      ref2.value = value3;
    } else ;
  }
}
function setSetupRef(_a2, key, val2) {
  var _setupState = _a2._setupState;
  if (_setupState && hasOwn$g(_setupState, key)) {
    if (isRef(_setupState[key])) {
      _setupState[key].value = val2;
    } else {
      _setupState[key] = val2;
    }
  }
}
var emptyNode = new VNode("", {}, []);
var hooks = ["create", "activate", "update", "remove", "destroy"];
function sameVnode(a3, b2) {
  return a3.key === b2.key && a3.asyncFactory === b2.asyncFactory && (a3.tag === b2.tag && a3.isComment === b2.isComment && isDef(a3.data) === isDef(b2.data) && sameInputType(a3, b2) || isTrue(a3.isAsyncPlaceholder) && isUndef(b2.asyncFactory.error));
}
function sameInputType(a3, b2) {
  if (a3.tag !== "input")
    return true;
  var i2;
  var typeA = isDef(i2 = a3.data) && isDef(i2 = i2.attrs) && i2.type;
  var typeB = isDef(i2 = b2.data) && isDef(i2 = i2.attrs) && i2.type;
  return typeA === typeB || isTextInputType(typeA) && isTextInputType(typeB);
}
function createKeyToOldIdx(children, beginIdx, endIdx) {
  var i2, key;
  var map = {};
  for (i2 = beginIdx; i2 <= endIdx; ++i2) {
    key = children[i2].key;
    if (isDef(key))
      map[key] = i2;
  }
  return map;
}
function createPatchFunction(backend) {
  var i2, j2;
  var cbs = {};
  var modules2 = backend.modules, nodeOps2 = backend.nodeOps;
  for (i2 = 0; i2 < hooks.length; ++i2) {
    cbs[hooks[i2]] = [];
    for (j2 = 0; j2 < modules2.length; ++j2) {
      if (isDef(modules2[j2][hooks[i2]])) {
        cbs[hooks[i2]].push(modules2[j2][hooks[i2]]);
      }
    }
  }
  function emptyNodeAt(elm) {
    return new VNode(nodeOps2.tagName(elm).toLowerCase(), {}, [], void 0, elm);
  }
  function createRmCb(childElm, listeners) {
    function remove2() {
      if (--remove2.listeners === 0) {
        removeNode(childElm);
      }
    }
    remove2.listeners = listeners;
    return remove2;
  }
  function removeNode(el) {
    var parent = nodeOps2.parentNode(el);
    if (isDef(parent)) {
      nodeOps2.removeChild(parent, el);
    }
  }
  function createElm(vnode, insertedVnodeQueue, parentElm, refElm, nested, ownerArray, index2) {
    if (isDef(vnode.elm) && isDef(ownerArray)) {
      vnode = ownerArray[index2] = cloneVNode(vnode);
    }
    vnode.isRootInsert = !nested;
    if (createComponent2(vnode, insertedVnodeQueue, parentElm, refElm)) {
      return;
    }
    var data12 = vnode.data;
    var children = vnode.children;
    var tag = vnode.tag;
    if (isDef(tag)) {
      vnode.elm = vnode.ns ? nodeOps2.createElementNS(vnode.ns, tag) : nodeOps2.createElement(tag, vnode);
      setScope(vnode);
      createChildren(vnode, children, insertedVnodeQueue);
      if (isDef(data12)) {
        invokeCreateHooks(vnode, insertedVnodeQueue);
      }
      insert(parentElm, vnode.elm, refElm);
    } else if (isTrue(vnode.isComment)) {
      vnode.elm = nodeOps2.createComment(vnode.text);
      insert(parentElm, vnode.elm, refElm);
    } else {
      vnode.elm = nodeOps2.createTextNode(vnode.text);
      insert(parentElm, vnode.elm, refElm);
    }
  }
  function createComponent2(vnode, insertedVnodeQueue, parentElm, refElm) {
    var i22 = vnode.data;
    if (isDef(i22)) {
      var isReactivated = isDef(vnode.componentInstance) && i22.keepAlive;
      if (isDef(i22 = i22.hook) && isDef(i22 = i22.init)) {
        i22(
          vnode,
          false
          /* hydrating */
        );
      }
      if (isDef(vnode.componentInstance)) {
        initComponent(vnode, insertedVnodeQueue);
        insert(parentElm, vnode.elm, refElm);
        if (isTrue(isReactivated)) {
          reactivateComponent(vnode, insertedVnodeQueue, parentElm, refElm);
        }
        return true;
      }
    }
  }
  function initComponent(vnode, insertedVnodeQueue) {
    if (isDef(vnode.data.pendingInsert)) {
      insertedVnodeQueue.push.apply(insertedVnodeQueue, vnode.data.pendingInsert);
      vnode.data.pendingInsert = null;
    }
    vnode.elm = vnode.componentInstance.$el;
    if (isPatchable(vnode)) {
      invokeCreateHooks(vnode, insertedVnodeQueue);
      setScope(vnode);
    } else {
      registerRef(vnode);
      insertedVnodeQueue.push(vnode);
    }
  }
  function reactivateComponent(vnode, insertedVnodeQueue, parentElm, refElm) {
    var i22;
    var innerNode = vnode;
    while (innerNode.componentInstance) {
      innerNode = innerNode.componentInstance._vnode;
      if (isDef(i22 = innerNode.data) && isDef(i22 = i22.transition)) {
        for (i22 = 0; i22 < cbs.activate.length; ++i22) {
          cbs.activate[i22](emptyNode, innerNode);
        }
        insertedVnodeQueue.push(innerNode);
        break;
      }
    }
    insert(parentElm, vnode.elm, refElm);
  }
  function insert(parent, elm, ref2) {
    if (isDef(parent)) {
      if (isDef(ref2)) {
        if (nodeOps2.parentNode(ref2) === parent) {
          nodeOps2.insertBefore(parent, elm, ref2);
        }
      } else {
        nodeOps2.appendChild(parent, elm);
      }
    }
  }
  function createChildren(vnode, children, insertedVnodeQueue) {
    if (isArray$5(children)) {
      for (var i_1 = 0; i_1 < children.length; ++i_1) {
        createElm(children[i_1], insertedVnodeQueue, vnode.elm, null, true, children, i_1);
      }
    } else if (isPrimitive(vnode.text)) {
      nodeOps2.appendChild(vnode.elm, nodeOps2.createTextNode(String(vnode.text)));
    }
  }
  function isPatchable(vnode) {
    while (vnode.componentInstance) {
      vnode = vnode.componentInstance._vnode;
    }
    return isDef(vnode.tag);
  }
  function invokeCreateHooks(vnode, insertedVnodeQueue) {
    for (var i_2 = 0; i_2 < cbs.create.length; ++i_2) {
      cbs.create[i_2](emptyNode, vnode);
    }
    i2 = vnode.data.hook;
    if (isDef(i2)) {
      if (isDef(i2.create))
        i2.create(emptyNode, vnode);
      if (isDef(i2.insert))
        insertedVnodeQueue.push(vnode);
    }
  }
  function setScope(vnode) {
    var i22;
    if (isDef(i22 = vnode.fnScopeId)) {
      nodeOps2.setStyleScope(vnode.elm, i22);
    } else {
      var ancestor = vnode;
      while (ancestor) {
        if (isDef(i22 = ancestor.context) && isDef(i22 = i22.$options._scopeId)) {
          nodeOps2.setStyleScope(vnode.elm, i22);
        }
        ancestor = ancestor.parent;
      }
    }
    if (isDef(i22 = activeInstance) && i22 !== vnode.context && i22 !== vnode.fnContext && isDef(i22 = i22.$options._scopeId)) {
      nodeOps2.setStyleScope(vnode.elm, i22);
    }
  }
  function addVnodes(parentElm, refElm, vnodes, startIdx, endIdx, insertedVnodeQueue) {
    for (; startIdx <= endIdx; ++startIdx) {
      createElm(vnodes[startIdx], insertedVnodeQueue, parentElm, refElm, false, vnodes, startIdx);
    }
  }
  function invokeDestroyHook(vnode) {
    var i22, j22;
    var data12 = vnode.data;
    if (isDef(data12)) {
      if (isDef(i22 = data12.hook) && isDef(i22 = i22.destroy))
        i22(vnode);
      for (i22 = 0; i22 < cbs.destroy.length; ++i22)
        cbs.destroy[i22](vnode);
    }
    if (isDef(i22 = vnode.children)) {
      for (j22 = 0; j22 < vnode.children.length; ++j22) {
        invokeDestroyHook(vnode.children[j22]);
      }
    }
  }
  function removeVnodes(vnodes, startIdx, endIdx) {
    for (; startIdx <= endIdx; ++startIdx) {
      var ch = vnodes[startIdx];
      if (isDef(ch)) {
        if (isDef(ch.tag)) {
          removeAndInvokeRemoveHook(ch);
          invokeDestroyHook(ch);
        } else {
          removeNode(ch.elm);
        }
      }
    }
  }
  function removeAndInvokeRemoveHook(vnode, rm) {
    if (isDef(rm) || isDef(vnode.data)) {
      var i_3;
      var listeners = cbs.remove.length + 1;
      if (isDef(rm)) {
        rm.listeners += listeners;
      } else {
        rm = createRmCb(vnode.elm, listeners);
      }
      if (isDef(i_3 = vnode.componentInstance) && isDef(i_3 = i_3._vnode) && isDef(i_3.data)) {
        removeAndInvokeRemoveHook(i_3, rm);
      }
      for (i_3 = 0; i_3 < cbs.remove.length; ++i_3) {
        cbs.remove[i_3](vnode, rm);
      }
      if (isDef(i_3 = vnode.data.hook) && isDef(i_3 = i_3.remove)) {
        i_3(vnode, rm);
      } else {
        rm();
      }
    } else {
      removeNode(vnode.elm);
    }
  }
  function updateChildren(parentElm, oldCh, newCh, insertedVnodeQueue, removeOnly) {
    var oldStartIdx = 0;
    var newStartIdx = 0;
    var oldEndIdx = oldCh.length - 1;
    var oldStartVnode = oldCh[0];
    var oldEndVnode = oldCh[oldEndIdx];
    var newEndIdx = newCh.length - 1;
    var newStartVnode = newCh[0];
    var newEndVnode = newCh[newEndIdx];
    var oldKeyToIdx, idxInOld, vnodeToMove, refElm;
    var canMove = !removeOnly;
    while (oldStartIdx <= oldEndIdx && newStartIdx <= newEndIdx) {
      if (isUndef(oldStartVnode)) {
        oldStartVnode = oldCh[++oldStartIdx];
      } else if (isUndef(oldEndVnode)) {
        oldEndVnode = oldCh[--oldEndIdx];
      } else if (sameVnode(oldStartVnode, newStartVnode)) {
        patchVnode(oldStartVnode, newStartVnode, insertedVnodeQueue, newCh, newStartIdx);
        oldStartVnode = oldCh[++oldStartIdx];
        newStartVnode = newCh[++newStartIdx];
      } else if (sameVnode(oldEndVnode, newEndVnode)) {
        patchVnode(oldEndVnode, newEndVnode, insertedVnodeQueue, newCh, newEndIdx);
        oldEndVnode = oldCh[--oldEndIdx];
        newEndVnode = newCh[--newEndIdx];
      } else if (sameVnode(oldStartVnode, newEndVnode)) {
        patchVnode(oldStartVnode, newEndVnode, insertedVnodeQueue, newCh, newEndIdx);
        canMove && nodeOps2.insertBefore(parentElm, oldStartVnode.elm, nodeOps2.nextSibling(oldEndVnode.elm));
        oldStartVnode = oldCh[++oldStartIdx];
        newEndVnode = newCh[--newEndIdx];
      } else if (sameVnode(oldEndVnode, newStartVnode)) {
        patchVnode(oldEndVnode, newStartVnode, insertedVnodeQueue, newCh, newStartIdx);
        canMove && nodeOps2.insertBefore(parentElm, oldEndVnode.elm, oldStartVnode.elm);
        oldEndVnode = oldCh[--oldEndIdx];
        newStartVnode = newCh[++newStartIdx];
      } else {
        if (isUndef(oldKeyToIdx))
          oldKeyToIdx = createKeyToOldIdx(oldCh, oldStartIdx, oldEndIdx);
        idxInOld = isDef(newStartVnode.key) ? oldKeyToIdx[newStartVnode.key] : findIdxInOld(newStartVnode, oldCh, oldStartIdx, oldEndIdx);
        if (isUndef(idxInOld)) {
          createElm(newStartVnode, insertedVnodeQueue, parentElm, oldStartVnode.elm, false, newCh, newStartIdx);
        } else {
          vnodeToMove = oldCh[idxInOld];
          if (sameVnode(vnodeToMove, newStartVnode)) {
            patchVnode(vnodeToMove, newStartVnode, insertedVnodeQueue, newCh, newStartIdx);
            oldCh[idxInOld] = void 0;
            canMove && nodeOps2.insertBefore(parentElm, vnodeToMove.elm, oldStartVnode.elm);
          } else {
            createElm(newStartVnode, insertedVnodeQueue, parentElm, oldStartVnode.elm, false, newCh, newStartIdx);
          }
        }
        newStartVnode = newCh[++newStartIdx];
      }
    }
    if (oldStartIdx > oldEndIdx) {
      refElm = isUndef(newCh[newEndIdx + 1]) ? null : newCh[newEndIdx + 1].elm;
      addVnodes(parentElm, refElm, newCh, newStartIdx, newEndIdx, insertedVnodeQueue);
    } else if (newStartIdx > newEndIdx) {
      removeVnodes(oldCh, oldStartIdx, oldEndIdx);
    }
  }
  function findIdxInOld(node, oldCh, start, end) {
    for (var i_5 = start; i_5 < end; i_5++) {
      var c2 = oldCh[i_5];
      if (isDef(c2) && sameVnode(node, c2))
        return i_5;
    }
  }
  function patchVnode(oldVnode, vnode, insertedVnodeQueue, ownerArray, index2, removeOnly) {
    if (oldVnode === vnode) {
      return;
    }
    if (isDef(vnode.elm) && isDef(ownerArray)) {
      vnode = ownerArray[index2] = cloneVNode(vnode);
    }
    var elm = vnode.elm = oldVnode.elm;
    if (isTrue(oldVnode.isAsyncPlaceholder)) {
      if (isDef(vnode.asyncFactory.resolved)) {
        hydrate(oldVnode.elm, vnode, insertedVnodeQueue);
      } else {
        vnode.isAsyncPlaceholder = true;
      }
      return;
    }
    if (isTrue(vnode.isStatic) && isTrue(oldVnode.isStatic) && vnode.key === oldVnode.key && (isTrue(vnode.isCloned) || isTrue(vnode.isOnce))) {
      vnode.componentInstance = oldVnode.componentInstance;
      return;
    }
    var i22;
    var data12 = vnode.data;
    if (isDef(data12) && isDef(i22 = data12.hook) && isDef(i22 = i22.prepatch)) {
      i22(oldVnode, vnode);
    }
    var oldCh = oldVnode.children;
    var ch = vnode.children;
    if (isDef(data12) && isPatchable(vnode)) {
      for (i22 = 0; i22 < cbs.update.length; ++i22)
        cbs.update[i22](oldVnode, vnode);
      if (isDef(i22 = data12.hook) && isDef(i22 = i22.update))
        i22(oldVnode, vnode);
    }
    if (isUndef(vnode.text)) {
      if (isDef(oldCh) && isDef(ch)) {
        if (oldCh !== ch)
          updateChildren(elm, oldCh, ch, insertedVnodeQueue, removeOnly);
      } else if (isDef(ch)) {
        if (isDef(oldVnode.text))
          nodeOps2.setTextContent(elm, "");
        addVnodes(elm, null, ch, 0, ch.length - 1, insertedVnodeQueue);
      } else if (isDef(oldCh)) {
        removeVnodes(oldCh, 0, oldCh.length - 1);
      } else if (isDef(oldVnode.text)) {
        nodeOps2.setTextContent(elm, "");
      }
    } else if (oldVnode.text !== vnode.text) {
      nodeOps2.setTextContent(elm, vnode.text);
    }
    if (isDef(data12)) {
      if (isDef(i22 = data12.hook) && isDef(i22 = i22.postpatch))
        i22(oldVnode, vnode);
    }
  }
  function invokeInsertHook(vnode, queue2, initial) {
    if (isTrue(initial) && isDef(vnode.parent)) {
      vnode.parent.data.pendingInsert = queue2;
    } else {
      for (var i_6 = 0; i_6 < queue2.length; ++i_6) {
        queue2[i_6].data.hook.insert(queue2[i_6]);
      }
    }
  }
  var isRenderedModule = makeMap("attrs,class,staticClass,staticStyle,key");
  function hydrate(elm, vnode, insertedVnodeQueue, inVPre) {
    var i22;
    var tag = vnode.tag, data12 = vnode.data, children = vnode.children;
    inVPre = inVPre || data12 && data12.pre;
    vnode.elm = elm;
    if (isTrue(vnode.isComment) && isDef(vnode.asyncFactory)) {
      vnode.isAsyncPlaceholder = true;
      return true;
    }
    if (isDef(data12)) {
      if (isDef(i22 = data12.hook) && isDef(i22 = i22.init))
        i22(
          vnode,
          true
          /* hydrating */
        );
      if (isDef(i22 = vnode.componentInstance)) {
        initComponent(vnode, insertedVnodeQueue);
        return true;
      }
    }
    if (isDef(tag)) {
      if (isDef(children)) {
        if (!elm.hasChildNodes()) {
          createChildren(vnode, children, insertedVnodeQueue);
        } else {
          if (isDef(i22 = data12) && isDef(i22 = i22.domProps) && isDef(i22 = i22.innerHTML)) {
            if (i22 !== elm.innerHTML) {
              return false;
            }
          } else {
            var childrenMatch = true;
            var childNode = elm.firstChild;
            for (var i_7 = 0; i_7 < children.length; i_7++) {
              if (!childNode || !hydrate(childNode, children[i_7], insertedVnodeQueue, inVPre)) {
                childrenMatch = false;
                break;
              }
              childNode = childNode.nextSibling;
            }
            if (!childrenMatch || childNode) {
              return false;
            }
          }
        }
      }
      if (isDef(data12)) {
        var fullInvoke = false;
        for (var key in data12) {
          if (!isRenderedModule(key)) {
            fullInvoke = true;
            invokeCreateHooks(vnode, insertedVnodeQueue);
            break;
          }
        }
        if (!fullInvoke && data12["class"]) {
          traverse(data12["class"]);
        }
      }
    } else if (elm.data !== vnode.text) {
      elm.data = vnode.text;
    }
    return true;
  }
  return function patch2(oldVnode, vnode, hydrating, removeOnly) {
    if (isUndef(vnode)) {
      if (isDef(oldVnode))
        invokeDestroyHook(oldVnode);
      return;
    }
    var isInitialPatch = false;
    var insertedVnodeQueue = [];
    if (isUndef(oldVnode)) {
      isInitialPatch = true;
      createElm(vnode, insertedVnodeQueue);
    } else {
      var isRealElement = isDef(oldVnode.nodeType);
      if (!isRealElement && sameVnode(oldVnode, vnode)) {
        patchVnode(oldVnode, vnode, insertedVnodeQueue, null, null, removeOnly);
      } else {
        if (isRealElement) {
          if (oldVnode.nodeType === 1 && oldVnode.hasAttribute(SSR_ATTR)) {
            oldVnode.removeAttribute(SSR_ATTR);
            hydrating = true;
          }
          if (isTrue(hydrating)) {
            if (hydrate(oldVnode, vnode, insertedVnodeQueue)) {
              invokeInsertHook(vnode, insertedVnodeQueue, true);
              return oldVnode;
            }
          }
          oldVnode = emptyNodeAt(oldVnode);
        }
        var oldElm = oldVnode.elm;
        var parentElm = nodeOps2.parentNode(oldElm);
        createElm(
          vnode,
          insertedVnodeQueue,
          // extremely rare edge case: do not insert if old element is in a
          // leaving transition. Only happens when combining transition +
          // keep-alive + HOCs. (#4590)
          oldElm._leaveCb ? null : parentElm,
          nodeOps2.nextSibling(oldElm)
        );
        if (isDef(vnode.parent)) {
          var ancestor = vnode.parent;
          var patchable = isPatchable(vnode);
          while (ancestor) {
            for (var i_8 = 0; i_8 < cbs.destroy.length; ++i_8) {
              cbs.destroy[i_8](ancestor);
            }
            ancestor.elm = vnode.elm;
            if (patchable) {
              for (var i_9 = 0; i_9 < cbs.create.length; ++i_9) {
                cbs.create[i_9](emptyNode, ancestor);
              }
              var insert_1 = ancestor.data.hook.insert;
              if (insert_1.merged) {
                var cloned = insert_1.fns.slice(1);
                for (var i_10 = 0; i_10 < cloned.length; i_10++) {
                  cloned[i_10]();
                }
              }
            } else {
              registerRef(ancestor);
            }
            ancestor = ancestor.parent;
          }
        }
        if (isDef(parentElm)) {
          removeVnodes([oldVnode], 0, 0);
        } else if (isDef(oldVnode.tag)) {
          invokeDestroyHook(oldVnode);
        }
      }
    }
    invokeInsertHook(vnode, insertedVnodeQueue, isInitialPatch);
    return vnode.elm;
  };
}
var directives = {
  create: updateDirectives,
  update: updateDirectives,
  destroy: function unbindDirectives(vnode) {
    updateDirectives(vnode, emptyNode);
  }
};
function updateDirectives(oldVnode, vnode) {
  if (oldVnode.data.directives || vnode.data.directives) {
    _update(oldVnode, vnode);
  }
}
function _update(oldVnode, vnode) {
  var isCreate = oldVnode === emptyNode;
  var isDestroy = vnode === emptyNode;
  var oldDirs = normalizeDirectives(oldVnode.data.directives, oldVnode.context);
  var newDirs = normalizeDirectives(vnode.data.directives, vnode.context);
  var dirsWithInsert = [];
  var dirsWithPostpatch = [];
  var key, oldDir, dir;
  for (key in newDirs) {
    oldDir = oldDirs[key];
    dir = newDirs[key];
    if (!oldDir) {
      callHook(dir, "bind", vnode, oldVnode);
      if (dir.def && dir.def.inserted) {
        dirsWithInsert.push(dir);
      }
    } else {
      dir.oldValue = oldDir.value;
      dir.oldArg = oldDir.arg;
      callHook(dir, "update", vnode, oldVnode);
      if (dir.def && dir.def.componentUpdated) {
        dirsWithPostpatch.push(dir);
      }
    }
  }
  if (dirsWithInsert.length) {
    var callInsert = function() {
      for (var i2 = 0; i2 < dirsWithInsert.length; i2++) {
        callHook(dirsWithInsert[i2], "inserted", vnode, oldVnode);
      }
    };
    if (isCreate) {
      mergeVNodeHook(vnode, "insert", callInsert);
    } else {
      callInsert();
    }
  }
  if (dirsWithPostpatch.length) {
    mergeVNodeHook(vnode, "postpatch", function() {
      for (var i2 = 0; i2 < dirsWithPostpatch.length; i2++) {
        callHook(dirsWithPostpatch[i2], "componentUpdated", vnode, oldVnode);
      }
    });
  }
  if (!isCreate) {
    for (key in oldDirs) {
      if (!newDirs[key]) {
        callHook(oldDirs[key], "unbind", oldVnode, oldVnode, isDestroy);
      }
    }
  }
}
var emptyModifiers = /* @__PURE__ */ Object.create(null);
function normalizeDirectives(dirs, vm) {
  var res = /* @__PURE__ */ Object.create(null);
  if (!dirs) {
    return res;
  }
  var i2, dir;
  for (i2 = 0; i2 < dirs.length; i2++) {
    dir = dirs[i2];
    if (!dir.modifiers) {
      dir.modifiers = emptyModifiers;
    }
    res[getRawDirName(dir)] = dir;
    if (vm._setupState && vm._setupState.__sfc) {
      var setupDef = dir.def || resolveAsset(vm, "_setupState", "v-" + dir.name);
      if (typeof setupDef === "function") {
        dir.def = {
          bind: setupDef,
          update: setupDef
        };
      } else {
        dir.def = setupDef;
      }
    }
    dir.def = dir.def || resolveAsset(vm.$options, "directives", dir.name);
  }
  return res;
}
function getRawDirName(dir) {
  return dir.rawName || "".concat(dir.name, ".").concat(Object.keys(dir.modifiers || {}).join("."));
}
function callHook(dir, hook, vnode, oldVnode, isDestroy) {
  var fn = dir.def && dir.def[hook];
  if (fn) {
    try {
      fn(vnode.elm, dir, vnode, oldVnode, isDestroy);
    } catch (e2) {
      handleError(e2, vnode.context, "directive ".concat(dir.name, " ").concat(hook, " hook"));
    }
  }
}
var baseModules = [ref, directives];
function updateAttrs(oldVnode, vnode) {
  var opts = vnode.componentOptions;
  if (isDef(opts) && opts.Ctor.options.inheritAttrs === false) {
    return;
  }
  if (isUndef(oldVnode.data.attrs) && isUndef(vnode.data.attrs)) {
    return;
  }
  var key, cur, old;
  var elm = vnode.elm;
  var oldAttrs = oldVnode.data.attrs || {};
  var attrs2 = vnode.data.attrs || {};
  if (isDef(attrs2.__ob__) || isTrue(attrs2._v_attr_proxy)) {
    attrs2 = vnode.data.attrs = extend$2({}, attrs2);
  }
  for (key in attrs2) {
    cur = attrs2[key];
    old = oldAttrs[key];
    if (old !== cur) {
      setAttr(elm, key, cur, vnode.data.pre);
    }
  }
  if ((isIE$1 || isEdge) && attrs2.value !== oldAttrs.value) {
    setAttr(elm, "value", attrs2.value);
  }
  for (key in oldAttrs) {
    if (isUndef(attrs2[key])) {
      if (isXlink(key)) {
        elm.removeAttributeNS(xlinkNS, getXlinkProp(key));
      } else if (!isEnumeratedAttr(key)) {
        elm.removeAttribute(key);
      }
    }
  }
}
function setAttr(el, key, value3, isInPre) {
  if (isInPre || el.tagName.indexOf("-") > -1) {
    baseSetAttr(el, key, value3);
  } else if (isBooleanAttr(key)) {
    if (isFalsyAttrValue(value3)) {
      el.removeAttribute(key);
    } else {
      value3 = key === "allowfullscreen" && el.tagName === "EMBED" ? "true" : key;
      el.setAttribute(key, value3);
    }
  } else if (isEnumeratedAttr(key)) {
    el.setAttribute(key, convertEnumeratedValue(key, value3));
  } else if (isXlink(key)) {
    if (isFalsyAttrValue(value3)) {
      el.removeAttributeNS(xlinkNS, getXlinkProp(key));
    } else {
      el.setAttributeNS(xlinkNS, key, value3);
    }
  } else {
    baseSetAttr(el, key, value3);
  }
}
function baseSetAttr(el, key, value3) {
  if (isFalsyAttrValue(value3)) {
    el.removeAttribute(key);
  } else {
    if (isIE$1 && !isIE9 && el.tagName === "TEXTAREA" && key === "placeholder" && value3 !== "" && !el.__ieph) {
      var blocker_1 = function(e2) {
        e2.stopImmediatePropagation();
        el.removeEventListener("input", blocker_1);
      };
      el.addEventListener("input", blocker_1);
      el.__ieph = true;
    }
    el.setAttribute(key, value3);
  }
}
var attrs = {
  create: updateAttrs,
  update: updateAttrs
};
function updateClass(oldVnode, vnode) {
  var el = vnode.elm;
  var data12 = vnode.data;
  var oldData = oldVnode.data;
  if (isUndef(data12.staticClass) && isUndef(data12.class) && (isUndef(oldData) || isUndef(oldData.staticClass) && isUndef(oldData.class))) {
    return;
  }
  var cls = genClassForVnode(vnode);
  var transitionClass = el._transitionClasses;
  if (isDef(transitionClass)) {
    cls = concat$3(cls, stringifyClass(transitionClass));
  }
  if (cls !== el._prevClass) {
    el.setAttribute("class", cls);
    el._prevClass = cls;
  }
}
var klass = {
  create: updateClass,
  update: updateClass
};
var RANGE_TOKEN = "__r";
var CHECKBOX_RADIO_TOKEN = "__c";
function normalizeEvents(on) {
  if (isDef(on[RANGE_TOKEN])) {
    var event_1 = isIE$1 ? "change" : "input";
    on[event_1] = [].concat(on[RANGE_TOKEN], on[event_1] || []);
    delete on[RANGE_TOKEN];
  }
  if (isDef(on[CHECKBOX_RADIO_TOKEN])) {
    on.change = [].concat(on[CHECKBOX_RADIO_TOKEN], on.change || []);
    delete on[CHECKBOX_RADIO_TOKEN];
  }
}
var target;
function createOnceHandler(event, handler9, capture) {
  var _target = target;
  return function onceHandler() {
    var res = handler9.apply(null, arguments);
    if (res !== null) {
      remove(event, onceHandler, capture, _target);
    }
  };
}
var useMicrotaskFix = isUsingMicroTask && !(isFF && Number(isFF[1]) <= 53);
function add(name, handler9, capture, passive) {
  if (useMicrotaskFix) {
    var attachedTimestamp_1 = currentFlushTimestamp;
    var original_1 = handler9;
    handler9 = original_1._wrapper = function(e2) {
      if (
        // no bubbling, should always fire.
        // this is just a safety net in case event.timeStamp is unreliable in
        // certain weird environments...
        e2.target === e2.currentTarget || // event is fired after handler attachment
        e2.timeStamp >= attachedTimestamp_1 || // bail for environments that have buggy event.timeStamp implementations
        // #9462 iOS 9 bug: event.timeStamp is 0 after history.pushState
        // #9681 QtWebEngine event.timeStamp is negative value
        e2.timeStamp <= 0 || // #9448 bail if event is fired in another document in a multi-page
        // electron/nw.js app, since event.timeStamp will be using a different
        // starting reference
        e2.target.ownerDocument !== document
      ) {
        return original_1.apply(this, arguments);
      }
    };
  }
  target.addEventListener(name, handler9, supportsPassive$1 ? { capture, passive } : capture);
}
function remove(name, handler9, capture, _target) {
  (_target || target).removeEventListener(
    name,
    //@ts-expect-error
    handler9._wrapper || handler9,
    capture
  );
}
function updateDOMListeners(oldVnode, vnode) {
  if (isUndef(oldVnode.data.on) && isUndef(vnode.data.on)) {
    return;
  }
  var on = vnode.data.on || {};
  var oldOn = oldVnode.data.on || {};
  target = vnode.elm || oldVnode.elm;
  normalizeEvents(on);
  updateListeners(on, oldOn, add, remove, createOnceHandler, vnode.context);
  target = void 0;
}
var events = {
  create: updateDOMListeners,
  update: updateDOMListeners,
  // @ts-expect-error emptyNode has actually data
  destroy: function(vnode) {
    return updateDOMListeners(vnode, emptyNode);
  }
};
var svgContainer;
function updateDOMProps(oldVnode, vnode) {
  if (isUndef(oldVnode.data.domProps) && isUndef(vnode.data.domProps)) {
    return;
  }
  var key, cur;
  var elm = vnode.elm;
  var oldProps = oldVnode.data.domProps || {};
  var props2 = vnode.data.domProps || {};
  if (isDef(props2.__ob__) || isTrue(props2._v_attr_proxy)) {
    props2 = vnode.data.domProps = extend$2({}, props2);
  }
  for (key in oldProps) {
    if (!(key in props2)) {
      elm[key] = "";
    }
  }
  for (key in props2) {
    cur = props2[key];
    if (key === "textContent" || key === "innerHTML") {
      if (vnode.children)
        vnode.children.length = 0;
      if (cur === oldProps[key])
        continue;
      if (elm.childNodes.length === 1) {
        elm.removeChild(elm.childNodes[0]);
      }
    }
    if (key === "value" && elm.tagName !== "PROGRESS") {
      elm._value = cur;
      var strCur = isUndef(cur) ? "" : String(cur);
      if (shouldUpdateValue(elm, strCur)) {
        elm.value = strCur;
      }
    } else if (key === "innerHTML" && isSVG(elm.tagName) && isUndef(elm.innerHTML)) {
      svgContainer = svgContainer || document.createElement("div");
      svgContainer.innerHTML = "<svg>".concat(cur, "</svg>");
      var svg2 = svgContainer.firstChild;
      while (elm.firstChild) {
        elm.removeChild(elm.firstChild);
      }
      while (svg2.firstChild) {
        elm.appendChild(svg2.firstChild);
      }
    } else if (
      // skip the update if old and new VDOM state is the same.
      // `value` is handled separately because the DOM value may be temporarily
      // out of sync with VDOM state due to focus, composition and modifiers.
      // This  #4521 by skipping the unnecessary `checked` update.
      cur !== oldProps[key]
    ) {
      try {
        elm[key] = cur;
      } catch (e2) {
      }
    }
  }
}
function shouldUpdateValue(elm, checkVal) {
  return (
    //@ts-expect-error
    !elm.composing && (elm.tagName === "OPTION" || isNotInFocusAndDirty(elm, checkVal) || isDirtyWithModifiers(elm, checkVal))
  );
}
function isNotInFocusAndDirty(elm, checkVal) {
  var notInFocus = true;
  try {
    notInFocus = document.activeElement !== elm;
  } catch (e2) {
  }
  return notInFocus && elm.value !== checkVal;
}
function isDirtyWithModifiers(elm, newVal) {
  var value3 = elm.value;
  var modifiers = elm._vModifiers;
  if (isDef(modifiers)) {
    if (modifiers.number) {
      return toNumber$1(value3) !== toNumber$1(newVal);
    }
    if (modifiers.trim) {
      return value3.trim() !== newVal.trim();
    }
  }
  return value3 !== newVal;
}
var domProps = {
  create: updateDOMProps,
  update: updateDOMProps
};
var parseStyleText = cached(function(cssText) {
  var res = {};
  var listDelimiter = /;(?![^(]*\))/g;
  var propertyDelimiter = /:(.+)/;
  cssText.split(listDelimiter).forEach(function(item) {
    if (item) {
      var tmp = item.split(propertyDelimiter);
      tmp.length > 1 && (res[tmp[0].trim()] = tmp[1].trim());
    }
  });
  return res;
});
function normalizeStyleData(data12) {
  var style2 = normalizeStyleBinding(data12.style);
  return data12.staticStyle ? extend$2(data12.staticStyle, style2) : style2;
}
function normalizeStyleBinding(bindingStyle) {
  if (Array.isArray(bindingStyle)) {
    return toObject$7(bindingStyle);
  }
  if (typeof bindingStyle === "string") {
    return parseStyleText(bindingStyle);
  }
  return bindingStyle;
}
function getStyle(vnode, checkChild) {
  var res = {};
  var styleData;
  {
    var childNode = vnode;
    while (childNode.componentInstance) {
      childNode = childNode.componentInstance._vnode;
      if (childNode && childNode.data && (styleData = normalizeStyleData(childNode.data))) {
        extend$2(res, styleData);
      }
    }
  }
  if (styleData = normalizeStyleData(vnode.data)) {
    extend$2(res, styleData);
  }
  var parentNode2 = vnode;
  while (parentNode2 = parentNode2.parent) {
    if (parentNode2.data && (styleData = normalizeStyleData(parentNode2.data))) {
      extend$2(res, styleData);
    }
  }
  return res;
}
var cssVarRE = /^--/;
var importantRE = /\s*!important$/;
var setProp = function(el, name, val2) {
  if (cssVarRE.test(name)) {
    el.style.setProperty(name, val2);
  } else if (importantRE.test(val2)) {
    el.style.setProperty(hyphenate(name), val2.replace(importantRE, ""), "important");
  } else {
    var normalizedName = normalize$1(name);
    if (Array.isArray(val2)) {
      for (var i2 = 0, len = val2.length; i2 < len; i2++) {
        el.style[normalizedName] = val2[i2];
      }
    } else {
      el.style[normalizedName] = val2;
    }
  }
};
var vendorNames = ["Webkit", "Moz", "ms"];
var emptyStyle;
var normalize$1 = cached(function(prop) {
  emptyStyle = emptyStyle || document.createElement("div").style;
  prop = camelize(prop);
  if (prop !== "filter" && prop in emptyStyle) {
    return prop;
  }
  var capName = prop.charAt(0).toUpperCase() + prop.slice(1);
  for (var i2 = 0; i2 < vendorNames.length; i2++) {
    var name_1 = vendorNames[i2] + capName;
    if (name_1 in emptyStyle) {
      return name_1;
    }
  }
});
function updateStyle(oldVnode, vnode) {
  var data12 = vnode.data;
  var oldData = oldVnode.data;
  if (isUndef(data12.staticStyle) && isUndef(data12.style) && isUndef(oldData.staticStyle) && isUndef(oldData.style)) {
    return;
  }
  var cur, name;
  var el = vnode.elm;
  var oldStaticStyle = oldData.staticStyle;
  var oldStyleBinding = oldData.normalizedStyle || oldData.style || {};
  var oldStyle = oldStaticStyle || oldStyleBinding;
  var style2 = normalizeStyleBinding(vnode.data.style) || {};
  vnode.data.normalizedStyle = isDef(style2.__ob__) ? extend$2({}, style2) : style2;
  var newStyle = getStyle(vnode);
  for (name in oldStyle) {
    if (isUndef(newStyle[name])) {
      setProp(el, name, "");
    }
  }
  for (name in newStyle) {
    cur = newStyle[name];
    setProp(el, name, cur == null ? "" : cur);
  }
}
var style = {
  create: updateStyle,
  update: updateStyle
};
var whitespaceRE = /\s+/;
function addClass(el, cls) {
  if (!cls || !(cls = cls.trim())) {
    return;
  }
  if (el.classList) {
    if (cls.indexOf(" ") > -1) {
      cls.split(whitespaceRE).forEach(function(c2) {
        return el.classList.add(c2);
      });
    } else {
      el.classList.add(cls);
    }
  } else {
    var cur = " ".concat(el.getAttribute("class") || "", " ");
    if (cur.indexOf(" " + cls + " ") < 0) {
      el.setAttribute("class", (cur + cls).trim());
    }
  }
}
function removeClass(el, cls) {
  if (!cls || !(cls = cls.trim())) {
    return;
  }
  if (el.classList) {
    if (cls.indexOf(" ") > -1) {
      cls.split(whitespaceRE).forEach(function(c2) {
        return el.classList.remove(c2);
      });
    } else {
      el.classList.remove(cls);
    }
    if (!el.classList.length) {
      el.removeAttribute("class");
    }
  } else {
    var cur = " ".concat(el.getAttribute("class") || "", " ");
    var tar = " " + cls + " ";
    while (cur.indexOf(tar) >= 0) {
      cur = cur.replace(tar, " ");
    }
    cur = cur.trim();
    if (cur) {
      el.setAttribute("class", cur);
    } else {
      el.removeAttribute("class");
    }
  }
}
function resolveTransition(def2) {
  if (!def2) {
    return;
  }
  if (typeof def2 === "object") {
    var res = {};
    if (def2.css !== false) {
      extend$2(res, autoCssTransition(def2.name || "v"));
    }
    extend$2(res, def2);
    return res;
  } else if (typeof def2 === "string") {
    return autoCssTransition(def2);
  }
}
var autoCssTransition = cached(function(name) {
  return {
    enterClass: "".concat(name, "-enter"),
    enterToClass: "".concat(name, "-enter-to"),
    enterActiveClass: "".concat(name, "-enter-active"),
    leaveClass: "".concat(name, "-leave"),
    leaveToClass: "".concat(name, "-leave-to"),
    leaveActiveClass: "".concat(name, "-leave-active")
  };
});
var hasTransition = inBrowser$1 && !isIE9;
var TRANSITION = "transition";
var ANIMATION = "animation";
var transitionProp = "transition";
var transitionEndEvent = "transitionend";
var animationProp = "animation";
var animationEndEvent = "animationend";
if (hasTransition) {
  if (window.ontransitionend === void 0 && window.onwebkittransitionend !== void 0) {
    transitionProp = "WebkitTransition";
    transitionEndEvent = "webkitTransitionEnd";
  }
  if (window.onanimationend === void 0 && window.onwebkitanimationend !== void 0) {
    animationProp = "WebkitAnimation";
    animationEndEvent = "webkitAnimationEnd";
  }
}
var raf = inBrowser$1 ? window.requestAnimationFrame ? window.requestAnimationFrame.bind(window) : setTimeout : (
  /* istanbul ignore next */
  function(fn) {
    return fn();
  }
);
function nextFrame$1(fn) {
  raf(function() {
    raf(fn);
  });
}
function addTransitionClass(el, cls) {
  var transitionClasses = el._transitionClasses || (el._transitionClasses = []);
  if (transitionClasses.indexOf(cls) < 0) {
    transitionClasses.push(cls);
    addClass(el, cls);
  }
}
function removeTransitionClass(el, cls) {
  if (el._transitionClasses) {
    remove$2(el._transitionClasses, cls);
  }
  removeClass(el, cls);
}
function whenTransitionEnds(el, expectedType, cb) {
  var _a2 = getTransitionInfo(el, expectedType), type = _a2.type, timeout = _a2.timeout, propCount = _a2.propCount;
  if (!type)
    return cb();
  var event = type === TRANSITION ? transitionEndEvent : animationEndEvent;
  var ended = 0;
  var end = function() {
    el.removeEventListener(event, onEnd);
    cb();
  };
  var onEnd = function(e2) {
    if (e2.target === el) {
      if (++ended >= propCount) {
        end();
      }
    }
  };
  setTimeout(function() {
    if (ended < propCount) {
      end();
    }
  }, timeout + 1);
  el.addEventListener(event, onEnd);
}
var transformRE = /\b(transform|all)(,|$)/;
function getTransitionInfo(el, expectedType) {
  var styles = window.getComputedStyle(el);
  var transitionDelays = (styles[transitionProp + "Delay"] || "").split(", ");
  var transitionDurations = (styles[transitionProp + "Duration"] || "").split(", ");
  var transitionTimeout = getTimeout(transitionDelays, transitionDurations);
  var animationDelays = (styles[animationProp + "Delay"] || "").split(", ");
  var animationDurations = (styles[animationProp + "Duration"] || "").split(", ");
  var animationTimeout = getTimeout(animationDelays, animationDurations);
  var type;
  var timeout = 0;
  var propCount = 0;
  if (expectedType === TRANSITION) {
    if (transitionTimeout > 0) {
      type = TRANSITION;
      timeout = transitionTimeout;
      propCount = transitionDurations.length;
    }
  } else if (expectedType === ANIMATION) {
    if (animationTimeout > 0) {
      type = ANIMATION;
      timeout = animationTimeout;
      propCount = animationDurations.length;
    }
  } else {
    timeout = Math.max(transitionTimeout, animationTimeout);
    type = timeout > 0 ? transitionTimeout > animationTimeout ? TRANSITION : ANIMATION : null;
    propCount = type ? type === TRANSITION ? transitionDurations.length : animationDurations.length : 0;
  }
  var hasTransform = type === TRANSITION && transformRE.test(styles[transitionProp + "Property"]);
  return {
    type,
    timeout,
    propCount,
    hasTransform
  };
}
function getTimeout(delays, durations) {
  while (delays.length < durations.length) {
    delays = delays.concat(delays);
  }
  return Math.max.apply(null, durations.map(function(d3, i2) {
    return toMs(d3) + toMs(delays[i2]);
  }));
}
function toMs(s3) {
  return Number(s3.slice(0, -1).replace(",", ".")) * 1e3;
}
function enter(vnode, toggleDisplay) {
  var el = vnode.elm;
  if (isDef(el._leaveCb)) {
    el._leaveCb.cancelled = true;
    el._leaveCb();
  }
  var data12 = resolveTransition(vnode.data.transition);
  if (isUndef(data12)) {
    return;
  }
  if (isDef(el._enterCb) || el.nodeType !== 1) {
    return;
  }
  var css = data12.css, type = data12.type, enterClass = data12.enterClass, enterToClass = data12.enterToClass, enterActiveClass = data12.enterActiveClass, appearClass = data12.appearClass, appearToClass = data12.appearToClass, appearActiveClass = data12.appearActiveClass, beforeEnter = data12.beforeEnter, enter2 = data12.enter, afterEnter = data12.afterEnter, enterCancelled = data12.enterCancelled, beforeAppear = data12.beforeAppear, appear = data12.appear, afterAppear = data12.afterAppear, appearCancelled = data12.appearCancelled, duration = data12.duration;
  var context = activeInstance;
  var transitionNode = activeInstance.$vnode;
  while (transitionNode && transitionNode.parent) {
    context = transitionNode.context;
    transitionNode = transitionNode.parent;
  }
  var isAppear = !context._isMounted || !vnode.isRootInsert;
  if (isAppear && !appear && appear !== "") {
    return;
  }
  var startClass = isAppear && appearClass ? appearClass : enterClass;
  var activeClass = isAppear && appearActiveClass ? appearActiveClass : enterActiveClass;
  var toClass = isAppear && appearToClass ? appearToClass : enterToClass;
  var beforeEnterHook = isAppear ? beforeAppear || beforeEnter : beforeEnter;
  var enterHook = isAppear ? isFunction$2(appear) ? appear : enter2 : enter2;
  var afterEnterHook = isAppear ? afterAppear || afterEnter : afterEnter;
  var enterCancelledHook = isAppear ? appearCancelled || enterCancelled : enterCancelled;
  var explicitEnterDuration = toNumber$1(isObject$f(duration) ? duration.enter : duration);
  var expectsCSS = css !== false && !isIE9;
  var userWantsControl = getHookArgumentsLength(enterHook);
  var cb = el._enterCb = once$1(function() {
    if (expectsCSS) {
      removeTransitionClass(el, toClass);
      removeTransitionClass(el, activeClass);
    }
    if (cb.cancelled) {
      if (expectsCSS) {
        removeTransitionClass(el, startClass);
      }
      enterCancelledHook && enterCancelledHook(el);
    } else {
      afterEnterHook && afterEnterHook(el);
    }
    el._enterCb = null;
  });
  if (!vnode.data.show) {
    mergeVNodeHook(vnode, "insert", function() {
      var parent = el.parentNode;
      var pendingNode = parent && parent._pending && parent._pending[vnode.key];
      if (pendingNode && pendingNode.tag === vnode.tag && pendingNode.elm._leaveCb) {
        pendingNode.elm._leaveCb();
      }
      enterHook && enterHook(el, cb);
    });
  }
  beforeEnterHook && beforeEnterHook(el);
  if (expectsCSS) {
    addTransitionClass(el, startClass);
    addTransitionClass(el, activeClass);
    nextFrame$1(function() {
      removeTransitionClass(el, startClass);
      if (!cb.cancelled) {
        addTransitionClass(el, toClass);
        if (!userWantsControl) {
          if (isValidDuration(explicitEnterDuration)) {
            setTimeout(cb, explicitEnterDuration);
          } else {
            whenTransitionEnds(el, type, cb);
          }
        }
      }
    });
  }
  if (vnode.data.show) {
    toggleDisplay && toggleDisplay();
    enterHook && enterHook(el, cb);
  }
  if (!expectsCSS && !userWantsControl) {
    cb();
  }
}
function leave(vnode, rm) {
  var el = vnode.elm;
  if (isDef(el._enterCb)) {
    el._enterCb.cancelled = true;
    el._enterCb();
  }
  var data12 = resolveTransition(vnode.data.transition);
  if (isUndef(data12) || el.nodeType !== 1) {
    return rm();
  }
  if (isDef(el._leaveCb)) {
    return;
  }
  var css = data12.css, type = data12.type, leaveClass = data12.leaveClass, leaveToClass = data12.leaveToClass, leaveActiveClass = data12.leaveActiveClass, beforeLeave = data12.beforeLeave, leave2 = data12.leave, afterLeave = data12.afterLeave, leaveCancelled = data12.leaveCancelled, delayLeave = data12.delayLeave, duration = data12.duration;
  var expectsCSS = css !== false && !isIE9;
  var userWantsControl = getHookArgumentsLength(leave2);
  var explicitLeaveDuration = toNumber$1(isObject$f(duration) ? duration.leave : duration);
  var cb = el._leaveCb = once$1(function() {
    if (el.parentNode && el.parentNode._pending) {
      el.parentNode._pending[vnode.key] = null;
    }
    if (expectsCSS) {
      removeTransitionClass(el, leaveToClass);
      removeTransitionClass(el, leaveActiveClass);
    }
    if (cb.cancelled) {
      if (expectsCSS) {
        removeTransitionClass(el, leaveClass);
      }
      leaveCancelled && leaveCancelled(el);
    } else {
      rm();
      afterLeave && afterLeave(el);
    }
    el._leaveCb = null;
  });
  if (delayLeave) {
    delayLeave(performLeave);
  } else {
    performLeave();
  }
  function performLeave() {
    if (cb.cancelled) {
      return;
    }
    if (!vnode.data.show && el.parentNode) {
      (el.parentNode._pending || (el.parentNode._pending = {}))[vnode.key] = vnode;
    }
    beforeLeave && beforeLeave(el);
    if (expectsCSS) {
      addTransitionClass(el, leaveClass);
      addTransitionClass(el, leaveActiveClass);
      nextFrame$1(function() {
        removeTransitionClass(el, leaveClass);
        if (!cb.cancelled) {
          addTransitionClass(el, leaveToClass);
          if (!userWantsControl) {
            if (isValidDuration(explicitLeaveDuration)) {
              setTimeout(cb, explicitLeaveDuration);
            } else {
              whenTransitionEnds(el, type, cb);
            }
          }
        }
      });
    }
    leave2 && leave2(el, cb);
    if (!expectsCSS && !userWantsControl) {
      cb();
    }
  }
}
function isValidDuration(val2) {
  return typeof val2 === "number" && !isNaN(val2);
}
function getHookArgumentsLength(fn) {
  if (isUndef(fn)) {
    return false;
  }
  var invokerFns = fn.fns;
  if (isDef(invokerFns)) {
    return getHookArgumentsLength(Array.isArray(invokerFns) ? invokerFns[0] : invokerFns);
  } else {
    return (fn._length || fn.length) > 1;
  }
}
function _enter(_2, vnode) {
  if (vnode.data.show !== true) {
    enter(vnode);
  }
}
var transition = inBrowser$1 ? {
  create: _enter,
  activate: _enter,
  remove: function(vnode, rm) {
    if (vnode.data.show !== true) {
      leave(vnode, rm);
    } else {
      rm();
    }
  }
} : {};
var platformModules = [attrs, klass, events, domProps, style, transition];
var modules = platformModules.concat(baseModules);
var patch = createPatchFunction({ nodeOps, modules });
if (isIE9) {
  document.addEventListener("selectionchange", function() {
    var el = document.activeElement;
    if (el && el.vmodel) {
      trigger(el, "input");
    }
  });
}
var directive = {
  inserted: function(el, binding, vnode, oldVnode) {
    if (vnode.tag === "select") {
      if (oldVnode.elm && !oldVnode.elm._vOptions) {
        mergeVNodeHook(vnode, "postpatch", function() {
          directive.componentUpdated(el, binding, vnode);
        });
      } else {
        setSelected(el, binding, vnode.context);
      }
      el._vOptions = [].map.call(el.options, getValue$1);
    } else if (vnode.tag === "textarea" || isTextInputType(el.type)) {
      el._vModifiers = binding.modifiers;
      if (!binding.modifiers.lazy) {
        el.addEventListener("compositionstart", onCompositionStart);
        el.addEventListener("compositionend", onCompositionEnd);
        el.addEventListener("change", onCompositionEnd);
        if (isIE9) {
          el.vmodel = true;
        }
      }
    }
  },
  componentUpdated: function(el, binding, vnode) {
    if (vnode.tag === "select") {
      setSelected(el, binding, vnode.context);
      var prevOptions_1 = el._vOptions;
      var curOptions_1 = el._vOptions = [].map.call(el.options, getValue$1);
      if (curOptions_1.some(function(o2, i2) {
        return !looseEqual(o2, prevOptions_1[i2]);
      })) {
        var needReset = el.multiple ? binding.value.some(function(v2) {
          return hasNoMatchingOption(v2, curOptions_1);
        }) : binding.value !== binding.oldValue && hasNoMatchingOption(binding.value, curOptions_1);
        if (needReset) {
          trigger(el, "change");
        }
      }
    }
  }
};
function setSelected(el, binding, vm) {
  actuallySetSelected(el, binding);
  if (isIE$1 || isEdge) {
    setTimeout(function() {
      actuallySetSelected(el, binding);
    }, 0);
  }
}
function actuallySetSelected(el, binding, vm) {
  var value3 = binding.value;
  var isMultiple = el.multiple;
  if (isMultiple && !Array.isArray(value3)) {
    return;
  }
  var selected, option;
  for (var i2 = 0, l2 = el.options.length; i2 < l2; i2++) {
    option = el.options[i2];
    if (isMultiple) {
      selected = looseIndexOf(value3, getValue$1(option)) > -1;
      if (option.selected !== selected) {
        option.selected = selected;
      }
    } else {
      if (looseEqual(getValue$1(option), value3)) {
        if (el.selectedIndex !== i2) {
          el.selectedIndex = i2;
        }
        return;
      }
    }
  }
  if (!isMultiple) {
    el.selectedIndex = -1;
  }
}
function hasNoMatchingOption(value3, options2) {
  return options2.every(function(o2) {
    return !looseEqual(o2, value3);
  });
}
function getValue$1(option) {
  return "_value" in option ? option._value : option.value;
}
function onCompositionStart(e2) {
  e2.target.composing = true;
}
function onCompositionEnd(e2) {
  if (!e2.target.composing)
    return;
  e2.target.composing = false;
  trigger(e2.target, "input");
}
function trigger(el, type) {
  var e2 = document.createEvent("HTMLEvents");
  e2.initEvent(type, true, true);
  el.dispatchEvent(e2);
}
function locateNode(vnode) {
  return vnode.componentInstance && (!vnode.data || !vnode.data.transition) ? locateNode(vnode.componentInstance._vnode) : vnode;
}
var show = {
  bind: function(el, _a2, vnode) {
    var value3 = _a2.value;
    vnode = locateNode(vnode);
    var transition2 = vnode.data && vnode.data.transition;
    var originalDisplay = el.__vOriginalDisplay = el.style.display === "none" ? "" : el.style.display;
    if (value3 && transition2) {
      vnode.data.show = true;
      enter(vnode, function() {
        el.style.display = originalDisplay;
      });
    } else {
      el.style.display = value3 ? originalDisplay : "none";
    }
  },
  update: function(el, _a2, vnode) {
    var value3 = _a2.value, oldValue = _a2.oldValue;
    if (!value3 === !oldValue)
      return;
    vnode = locateNode(vnode);
    var transition2 = vnode.data && vnode.data.transition;
    if (transition2) {
      vnode.data.show = true;
      if (value3) {
        enter(vnode, function() {
          el.style.display = el.__vOriginalDisplay;
        });
      } else {
        leave(vnode, function() {
          el.style.display = "none";
        });
      }
    } else {
      el.style.display = value3 ? el.__vOriginalDisplay : "none";
    }
  },
  unbind: function(el, binding, vnode, oldVnode, isDestroy) {
    if (!isDestroy) {
      el.style.display = el.__vOriginalDisplay;
    }
  }
};
var platformDirectives = {
  model: directive,
  show
};
var transitionProps = {
  name: String,
  appear: Boolean,
  css: Boolean,
  mode: String,
  type: String,
  enterClass: String,
  leaveClass: String,
  enterToClass: String,
  leaveToClass: String,
  enterActiveClass: String,
  leaveActiveClass: String,
  appearClass: String,
  appearActiveClass: String,
  appearToClass: String,
  duration: [Number, String, Object]
};
function getRealChild(vnode) {
  var compOptions = vnode && vnode.componentOptions;
  if (compOptions && compOptions.Ctor.options.abstract) {
    return getRealChild(getFirstComponentChild(compOptions.children));
  } else {
    return vnode;
  }
}
function extractTransitionData(comp) {
  var data12 = {};
  var options2 = comp.$options;
  for (var key in options2.propsData) {
    data12[key] = comp[key];
  }
  var listeners = options2._parentListeners;
  for (var key in listeners) {
    data12[camelize(key)] = listeners[key];
  }
  return data12;
}
function placeholder(h22, rawChild) {
  if (/\d-keep-alive$/.test(rawChild.tag)) {
    return h22("keep-alive", {
      props: rawChild.componentOptions.propsData
    });
  }
}
function hasParentTransition(vnode) {
  while (vnode = vnode.parent) {
    if (vnode.data.transition) {
      return true;
    }
  }
}
function isSameChild(child, oldChild) {
  return oldChild.key === child.key && oldChild.tag === child.tag;
}
var isNotTextNode = function(c2) {
  return c2.tag || isAsyncPlaceholder(c2);
};
var isVShowDirective = function(d3) {
  return d3.name === "show";
};
var Transition = {
  name: "transition",
  props: transitionProps,
  abstract: true,
  render: function(h22) {
    var _this = this;
    var children = this.$slots.default;
    if (!children) {
      return;
    }
    children = children.filter(isNotTextNode);
    if (!children.length) {
      return;
    }
    var mode = this.mode;
    var rawChild = children[0];
    if (hasParentTransition(this.$vnode)) {
      return rawChild;
    }
    var child = getRealChild(rawChild);
    if (!child) {
      return rawChild;
    }
    if (this._leaving) {
      return placeholder(h22, rawChild);
    }
    var id2 = "__transition-".concat(this._uid, "-");
    child.key = child.key == null ? child.isComment ? id2 + "comment" : id2 + child.tag : isPrimitive(child.key) ? String(child.key).indexOf(id2) === 0 ? child.key : id2 + child.key : child.key;
    var data12 = (child.data || (child.data = {})).transition = extractTransitionData(this);
    var oldRawChild = this._vnode;
    var oldChild = getRealChild(oldRawChild);
    if (child.data.directives && child.data.directives.some(isVShowDirective)) {
      child.data.show = true;
    }
    if (oldChild && oldChild.data && !isSameChild(child, oldChild) && !isAsyncPlaceholder(oldChild) && // #6687 component root is a comment node
    !(oldChild.componentInstance && oldChild.componentInstance._vnode.isComment)) {
      var oldData = oldChild.data.transition = extend$2({}, data12);
      if (mode === "out-in") {
        this._leaving = true;
        mergeVNodeHook(oldData, "afterLeave", function() {
          _this._leaving = false;
          _this.$forceUpdate();
        });
        return placeholder(h22, rawChild);
      } else if (mode === "in-out") {
        if (isAsyncPlaceholder(child)) {
          return oldRawChild;
        }
        var delayedLeave_1;
        var performLeave = function() {
          delayedLeave_1();
        };
        mergeVNodeHook(data12, "afterEnter", performLeave);
        mergeVNodeHook(data12, "enterCancelled", performLeave);
        mergeVNodeHook(oldData, "delayLeave", function(leave2) {
          delayedLeave_1 = leave2;
        });
      }
    }
    return rawChild;
  }
};
var props = extend$2({
  tag: String,
  moveClass: String
}, transitionProps);
delete props.mode;
var TransitionGroup = {
  props,
  beforeMount: function() {
    var _this = this;
    var update = this._update;
    this._update = function(vnode, hydrating) {
      var restoreActiveInstance = setActiveInstance(_this);
      _this.__patch__(
        _this._vnode,
        _this.kept,
        false,
        // hydrating
        true
        // removeOnly (!important, avoids unnecessary moves)
      );
      _this._vnode = _this.kept;
      restoreActiveInstance();
      update.call(_this, vnode, hydrating);
    };
  },
  render: function(h22) {
    var tag = this.tag || this.$vnode.data.tag || "span";
    var map = /* @__PURE__ */ Object.create(null);
    var prevChildren = this.prevChildren = this.children;
    var rawChildren = this.$slots.default || [];
    var children = this.children = [];
    var transitionData = extractTransitionData(this);
    for (var i2 = 0; i2 < rawChildren.length; i2++) {
      var c2 = rawChildren[i2];
      if (c2.tag) {
        if (c2.key != null && String(c2.key).indexOf("__vlist") !== 0) {
          children.push(c2);
          map[c2.key] = c2;
          (c2.data || (c2.data = {})).transition = transitionData;
        }
      }
    }
    if (prevChildren) {
      var kept = [];
      var removed = [];
      for (var i2 = 0; i2 < prevChildren.length; i2++) {
        var c2 = prevChildren[i2];
        c2.data.transition = transitionData;
        c2.data.pos = c2.elm.getBoundingClientRect();
        if (map[c2.key]) {
          kept.push(c2);
        } else {
          removed.push(c2);
        }
      }
      this.kept = h22(tag, null, kept);
      this.removed = removed;
    }
    return h22(tag, null, children);
  },
  updated: function() {
    var children = this.prevChildren;
    var moveClass = this.moveClass || (this.name || "v") + "-move";
    if (!children.length || !this.hasMove(children[0].elm, moveClass)) {
      return;
    }
    children.forEach(callPendingCbs);
    children.forEach(recordPosition);
    children.forEach(applyTranslation);
    this._reflow = document.body.offsetHeight;
    children.forEach(function(c2) {
      if (c2.data.moved) {
        var el_1 = c2.elm;
        var s3 = el_1.style;
        addTransitionClass(el_1, moveClass);
        s3.transform = s3.WebkitTransform = s3.transitionDuration = "";
        el_1.addEventListener(transitionEndEvent, el_1._moveCb = function cb(e2) {
          if (e2 && e2.target !== el_1) {
            return;
          }
          if (!e2 || /transform$/.test(e2.propertyName)) {
            el_1.removeEventListener(transitionEndEvent, cb);
            el_1._moveCb = null;
            removeTransitionClass(el_1, moveClass);
          }
        });
      }
    });
  },
  methods: {
    hasMove: function(el, moveClass) {
      if (!hasTransition) {
        return false;
      }
      if (this._hasMove) {
        return this._hasMove;
      }
      var clone2 = el.cloneNode();
      if (el._transitionClasses) {
        el._transitionClasses.forEach(function(cls) {
          removeClass(clone2, cls);
        });
      }
      addClass(clone2, moveClass);
      clone2.style.display = "none";
      this.$el.appendChild(clone2);
      var info = getTransitionInfo(clone2);
      this.$el.removeChild(clone2);
      return this._hasMove = info.hasTransform;
    }
  }
};
function callPendingCbs(c2) {
  if (c2.elm._moveCb) {
    c2.elm._moveCb();
  }
  if (c2.elm._enterCb) {
    c2.elm._enterCb();
  }
}
function recordPosition(c2) {
  c2.data.newPos = c2.elm.getBoundingClientRect();
}
function applyTranslation(c2) {
  var oldPos = c2.data.pos;
  var newPos = c2.data.newPos;
  var dx = oldPos.left - newPos.left;
  var dy = oldPos.top - newPos.top;
  if (dx || dy) {
    c2.data.moved = true;
    var s3 = c2.elm.style;
    s3.transform = s3.WebkitTransform = "translate(".concat(dx, "px,").concat(dy, "px)");
    s3.transitionDuration = "0s";
  }
}
var platformComponents = {
  Transition,
  TransitionGroup
};
Vue.config.mustUseProp = mustUseProp;
Vue.config.isReservedTag = isReservedTag;
Vue.config.isReservedAttr = isReservedAttr;
Vue.config.getTagNamespace = getTagNamespace;
Vue.config.isUnknownElement = isUnknownElement;
extend$2(Vue.options.directives, platformDirectives);
extend$2(Vue.options.components, platformComponents);
Vue.prototype.__patch__ = inBrowser$1 ? patch : noop$6;
Vue.prototype.$mount = function(el, hydrating) {
  el = el && inBrowser$1 ? query(el) : void 0;
  return mountComponent(this, el, hydrating);
};
if (inBrowser$1) {
  setTimeout(function() {
    if (config$2.devtools) {
      if (devtools) {
        devtools.emit("init", Vue);
      }
    }
  }, 0);
}
const scriptRel = "modulepreload";
const assetsURL = function(dep, importerUrl) {
  return new URL(dep, importerUrl).href;
};
const seen = {};
const __vitePreload = function preload(baseModule, deps, importerUrl) {
  let promise = Promise.resolve();
  if (deps && deps.length > 0) {
    const links = document.getElementsByTagName("link");
    const cspNonceMeta = document.querySelector(
      "meta[property=csp-nonce]"
    );
    const cspNonce = cspNonceMeta?.nonce || cspNonceMeta?.getAttribute("nonce");
    promise = Promise.all(
      deps.map((dep) => {
        dep = assetsURL(dep, importerUrl);
        if (dep in seen) return;
        seen[dep] = true;
        const isCss = dep.endsWith(".css");
        const cssSelector = isCss ? '[rel="stylesheet"]' : "";
        const isBaseRelative = !!importerUrl;
        if (isBaseRelative) {
          for (let i2 = links.length - 1; i2 >= 0; i2--) {
            const link2 = links[i2];
            if (link2.href === dep && (!isCss || link2.rel === "stylesheet")) {
              return;
            }
          }
        } else if (document.querySelector(`link[href="${dep}"]${cssSelector}`)) {
          return;
        }
        const link = document.createElement("link");
        link.rel = isCss ? "stylesheet" : scriptRel;
        if (!isCss) {
          link.as = "script";
        }
        link.crossOrigin = "";
        link.href = dep;
        if (cspNonce) {
          link.setAttribute("nonce", cspNonce);
        }
        document.head.appendChild(link);
        if (isCss) {
          return new Promise((res, rej) => {
            link.addEventListener("load", res);
            link.addEventListener(
              "error",
              () => rej(new Error(`Unable to preload CSS for ${dep}`))
            );
          });
        }
      })
    );
  }
  return promise.then(() => baseModule()).catch((err) => {
    const e2 = new Event("vite:preloadError", {
      cancelable: true
    });
    e2.payload = err;
    window.dispatchEvent(e2);
    if (!e2.defaultPrevented) {
      throw err;
    }
  });
};
function getDefaultExportFromCjs$1(x3) {
  return x3 && x3.__esModule && Object.prototype.hasOwnProperty.call(x3, "default") ? x3["default"] : x3;
}
var browser = { exports: {} };
var process$1 = browser.exports = {};
var cachedSetTimeout;
var cachedClearTimeout;
function defaultSetTimout() {
  throw new Error("setTimeout has not been defined");
}
function defaultClearTimeout() {
  throw new Error("clearTimeout has not been defined");
}
(function() {
  try {
    if (typeof setTimeout === "function") {
      cachedSetTimeout = setTimeout;
    } else {
      cachedSetTimeout = defaultSetTimout;
    }
  } catch (e2) {
    cachedSetTimeout = defaultSetTimout;
  }
  try {
    if (typeof clearTimeout === "function") {
      cachedClearTimeout = clearTimeout;
    } else {
      cachedClearTimeout = defaultClearTimeout;
    }
  } catch (e2) {
    cachedClearTimeout = defaultClearTimeout;
  }
})();
function runTimeout(fun) {
  if (cachedSetTimeout === setTimeout) {
    return setTimeout(fun, 0);
  }
  if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
    cachedSetTimeout = setTimeout;
    return setTimeout(fun, 0);
  }
  try {
    return cachedSetTimeout(fun, 0);
  } catch (e2) {
    try {
      return cachedSetTimeout.call(null, fun, 0);
    } catch (e22) {
      return cachedSetTimeout.call(this, fun, 0);
    }
  }
}
function runClearTimeout(marker) {
  if (cachedClearTimeout === clearTimeout) {
    return clearTimeout(marker);
  }
  if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
    cachedClearTimeout = clearTimeout;
    return clearTimeout(marker);
  }
  try {
    return cachedClearTimeout(marker);
  } catch (e2) {
    try {
      return cachedClearTimeout.call(null, marker);
    } catch (e22) {
      return cachedClearTimeout.call(this, marker);
    }
  }
}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;
function cleanUpNextTick() {
  if (!draining || !currentQueue) {
    return;
  }
  draining = false;
  if (currentQueue.length) {
    queue = currentQueue.concat(queue);
  } else {
    queueIndex = -1;
  }
  if (queue.length) {
    drainQueue();
  }
}
function drainQueue() {
  if (draining) {
    return;
  }
  var timeout = runTimeout(cleanUpNextTick);
  draining = true;
  var len = queue.length;
  while (len) {
    currentQueue = queue;
    queue = [];
    while (++queueIndex < len) {
      if (currentQueue) {
        currentQueue[queueIndex].run();
      }
    }
    queueIndex = -1;
    len = queue.length;
  }
  currentQueue = null;
  draining = false;
  runClearTimeout(timeout);
}
process$1.nextTick = function(fun) {
  var args = new Array(arguments.length - 1);
  if (arguments.length > 1) {
    for (var i2 = 1; i2 < arguments.length; i2++) {
      args[i2 - 1] = arguments[i2];
    }
  }
  queue.push(new Item(fun, args));
  if (queue.length === 1 && !draining) {
    runTimeout(drainQueue);
  }
};
function Item(fun, array) {
  this.fun = fun;
  this.array = array;
}
Item.prototype.run = function() {
  this.fun.apply(null, this.array);
};
process$1.title = "browser";
process$1.browser = true;
process$1.env = {};
process$1.argv = [];
process$1.version = "";
process$1.versions = {};
function noop$5() {
}
process$1.on = noop$5;
process$1.addListener = noop$5;
process$1.once = noop$5;
process$1.off = noop$5;
process$1.removeListener = noop$5;
process$1.removeAllListeners = noop$5;
process$1.emit = noop$5;
process$1.prependListener = noop$5;
process$1.prependOnceListener = noop$5;
process$1.listeners = function(name) {
  return [];
};
process$1.binding = function(name) {
  throw new Error("process.binding is not supported");
};
process$1.cwd = function() {
  return "/";
};
process$1.chdir = function(dir) {
  throw new Error("process.chdir is not supported");
};
process$1.umask = function() {
  return 0;
};
var browserExports = browser.exports;
const process$1$1 = /* @__PURE__ */ getDefaultExportFromCjs$1(browserExports);
function bind$3(fn, thisArg) {
  return function wrap2() {
    return fn.apply(thisArg, arguments);
  };
}
const { toString: toString$e } = Object.prototype;
const { getPrototypeOf: getPrototypeOf$3 } = Object;
const kindOf = /* @__PURE__ */ ((cache) => (thing) => {
  const str = toString$e.call(thing);
  return cache[str] || (cache[str] = str.slice(8, -1).toLowerCase());
})(/* @__PURE__ */ Object.create(null));
const kindOfTest = (type) => {
  type = type.toLowerCase();
  return (thing) => kindOf(thing) === type;
};
const typeOfTest = (type) => (thing) => typeof thing === type;
const { isArray: isArray$4 } = Array;
const isUndefined = typeOfTest("undefined");
function isBuffer$1(val2) {
  return val2 !== null && !isUndefined(val2) && val2.constructor !== null && !isUndefined(val2.constructor) && isFunction$1(val2.constructor.isBuffer) && val2.constructor.isBuffer(val2);
}
const isArrayBuffer = kindOfTest("ArrayBuffer");
function isArrayBufferView(val2) {
  let result;
  if (typeof ArrayBuffer !== "undefined" && ArrayBuffer.isView) {
    result = ArrayBuffer.isView(val2);
  } else {
    result = val2 && val2.buffer && isArrayBuffer(val2.buffer);
  }
  return result;
}
const isString = typeOfTest("string");
const isFunction$1 = typeOfTest("function");
const isNumber$2 = typeOfTest("number");
const isObject$e = (thing) => thing !== null && typeof thing === "object";
const isBoolean = (thing) => thing === true || thing === false;
const isPlainObject = (val2) => {
  if (kindOf(val2) !== "object") {
    return false;
  }
  const prototype2 = getPrototypeOf$3(val2);
  return (prototype2 === null || prototype2 === Object.prototype || Object.getPrototypeOf(prototype2) === null) && !(Symbol.toStringTag in val2) && !(Symbol.iterator in val2);
};
const isDate$1 = kindOfTest("Date");
const isFile = kindOfTest("File");
const isBlob = kindOfTest("Blob");
const isFileList = kindOfTest("FileList");
const isStream = (val2) => isObject$e(val2) && isFunction$1(val2.pipe);
const isFormData = (thing) => {
  let kind;
  return thing && (typeof FormData === "function" && thing instanceof FormData || isFunction$1(thing.append) && ((kind = kindOf(thing)) === "formdata" || // detect form-data instance
  kind === "object" && isFunction$1(thing.toString) && thing.toString() === "[object FormData]"));
};
const isURLSearchParams = kindOfTest("URLSearchParams");
const [isReadableStream, isRequest, isResponse, isHeaders] = ["ReadableStream", "Request", "Response", "Headers"].map(kindOfTest);
const trim$1 = (str) => str.trim ? str.trim() : str.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, "");
function forEach(obj, fn, { allOwnKeys = false } = {}) {
  if (obj === null || typeof obj === "undefined") {
    return;
  }
  let i2;
  let l2;
  if (typeof obj !== "object") {
    obj = [obj];
  }
  if (isArray$4(obj)) {
    for (i2 = 0, l2 = obj.length; i2 < l2; i2++) {
      fn.call(null, obj[i2], i2, obj);
    }
  } else {
    const keys3 = allOwnKeys ? Object.getOwnPropertyNames(obj) : Object.keys(obj);
    const len = keys3.length;
    let key;
    for (i2 = 0; i2 < len; i2++) {
      key = keys3[i2];
      fn.call(null, obj[key], key, obj);
    }
  }
}
function findKey(obj, key) {
  key = key.toLowerCase();
  const keys3 = Object.keys(obj);
  let i2 = keys3.length;
  let _key2;
  while (i2-- > 0) {
    _key2 = keys3[i2];
    if (key === _key2.toLowerCase()) {
      return _key2;
    }
  }
  return null;
}
const _global = (() => {
  if (typeof globalThis !== "undefined") return globalThis;
  return typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : global$j;
})();
const isContextDefined = (context) => !isUndefined(context) && context !== _global;
function merge() {
  const { caseless } = isContextDefined(this) && this || {};
  const result = {};
  const assignValue = (val2, key) => {
    const targetKey = caseless && findKey(result, key) || key;
    if (isPlainObject(result[targetKey]) && isPlainObject(val2)) {
      result[targetKey] = merge(result[targetKey], val2);
    } else if (isPlainObject(val2)) {
      result[targetKey] = merge({}, val2);
    } else if (isArray$4(val2)) {
      result[targetKey] = val2.slice();
    } else {
      result[targetKey] = val2;
    }
  };
  for (let i2 = 0, l2 = arguments.length; i2 < l2; i2++) {
    arguments[i2] && forEach(arguments[i2], assignValue);
  }
  return result;
}
const extend$1 = (a3, b2, thisArg, { allOwnKeys } = {}) => {
  forEach(b2, (val2, key) => {
    if (thisArg && isFunction$1(val2)) {
      a3[key] = bind$3(val2, thisArg);
    } else {
      a3[key] = val2;
    }
  }, { allOwnKeys });
  return a3;
};
const stripBOM = (content) => {
  if (content.charCodeAt(0) === 65279) {
    content = content.slice(1);
  }
  return content;
};
const inherits = (constructor, superConstructor, props2, descriptors2) => {
  constructor.prototype = Object.create(superConstructor.prototype, descriptors2);
  constructor.prototype.constructor = constructor;
  Object.defineProperty(constructor, "super", {
    value: superConstructor.prototype
  });
  props2 && Object.assign(constructor.prototype, props2);
};
const toFlatObject = (sourceObj, destObj, filter2, propFilter) => {
  let props2;
  let i2;
  let prop;
  const merged = {};
  destObj = destObj || {};
  if (sourceObj == null) return destObj;
  do {
    props2 = Object.getOwnPropertyNames(sourceObj);
    i2 = props2.length;
    while (i2-- > 0) {
      prop = props2[i2];
      if ((!propFilter || propFilter(prop, sourceObj, destObj)) && !merged[prop]) {
        destObj[prop] = sourceObj[prop];
        merged[prop] = true;
      }
    }
    sourceObj = filter2 !== false && getPrototypeOf$3(sourceObj);
  } while (sourceObj && (!filter2 || filter2(sourceObj, destObj)) && sourceObj !== Object.prototype);
  return destObj;
};
const endsWith = (str, searchString, position) => {
  str = String(str);
  if (position === void 0 || position > str.length) {
    position = str.length;
  }
  position -= searchString.length;
  const lastIndex = str.indexOf(searchString, position);
  return lastIndex !== -1 && lastIndex === position;
};
const toArray = (thing) => {
  if (!thing) return null;
  if (isArray$4(thing)) return thing;
  let i2 = thing.length;
  if (!isNumber$2(i2)) return null;
  const arr = new Array(i2);
  while (i2-- > 0) {
    arr[i2] = thing[i2];
  }
  return arr;
};
const isTypedArray = /* @__PURE__ */ ((TypedArray) => {
  return (thing) => {
    return TypedArray && thing instanceof TypedArray;
  };
})(typeof Uint8Array !== "undefined" && getPrototypeOf$3(Uint8Array));
const forEachEntry = (obj, fn) => {
  const generator = obj && obj[Symbol.iterator];
  const iterator = generator.call(obj);
  let result;
  while ((result = iterator.next()) && !result.done) {
    const pair = result.value;
    fn.call(obj, pair[0], pair[1]);
  }
};
const matchAll = (regExp, str) => {
  let matches2;
  const arr = [];
  while ((matches2 = regExp.exec(str)) !== null) {
    arr.push(matches2);
  }
  return arr;
};
const isHTMLForm = kindOfTest("HTMLFormElement");
const toCamelCase = (str) => {
  return str.toLowerCase().replace(
    /[-_\s]([a-z\d])(\w*)/g,
    function replacer2(m3, p1, p2) {
      return p1.toUpperCase() + p2;
    }
  );
};
const hasOwnProperty$3 = (({ hasOwnProperty: hasOwnProperty2 }) => (obj, prop) => hasOwnProperty2.call(obj, prop))(Object.prototype);
const isRegExp = kindOfTest("RegExp");
const reduceDescriptors = (obj, reducer) => {
  const descriptors2 = Object.getOwnPropertyDescriptors(obj);
  const reducedDescriptors = {};
  forEach(descriptors2, (descriptor, name) => {
    let ret;
    if ((ret = reducer(descriptor, name, obj)) !== false) {
      reducedDescriptors[name] = ret || descriptor;
    }
  });
  Object.defineProperties(obj, reducedDescriptors);
};
const freezeMethods = (obj) => {
  reduceDescriptors(obj, (descriptor, name) => {
    if (isFunction$1(obj) && ["arguments", "caller", "callee"].indexOf(name) !== -1) {
      return false;
    }
    const value3 = obj[name];
    if (!isFunction$1(value3)) return;
    descriptor.enumerable = false;
    if ("writable" in descriptor) {
      descriptor.writable = false;
      return;
    }
    if (!descriptor.set) {
      descriptor.set = () => {
        throw Error("Can not rewrite read-only method '" + name + "'");
      };
    }
  });
};
const toObjectSet = (arrayOrString, delimiter) => {
  const obj = {};
  const define = (arr) => {
    arr.forEach((value3) => {
      obj[value3] = true;
    });
  };
  isArray$4(arrayOrString) ? define(arrayOrString) : define(String(arrayOrString).split(delimiter));
  return obj;
};
const noop$4 = () => {
};
const toFiniteNumber = (value3, defaultValue) => {
  return value3 != null && Number.isFinite(value3 = +value3) ? value3 : defaultValue;
};
const ALPHA = "abcdefghijklmnopqrstuvwxyz";
const DIGIT$1 = "0123456789";
const ALPHABET = {
  DIGIT: DIGIT$1,
  ALPHA,
  ALPHA_DIGIT: ALPHA + ALPHA.toUpperCase() + DIGIT$1
};
const generateString = (size2 = 16, alphabet = ALPHABET.ALPHA_DIGIT) => {
  let str = "";
  const { length } = alphabet;
  while (size2--) {
    str += alphabet[Math.random() * length | 0];
  }
  return str;
};
function isSpecCompliantForm(thing) {
  return !!(thing && isFunction$1(thing.append) && thing[Symbol.toStringTag] === "FormData" && thing[Symbol.iterator]);
}
const toJSONObject = (obj) => {
  const stack = new Array(10);
  const visit = (source, i2) => {
    if (isObject$e(source)) {
      if (stack.indexOf(source) >= 0) {
        return;
      }
      if (!("toJSON" in source)) {
        stack[i2] = source;
        const target2 = isArray$4(source) ? [] : {};
        forEach(source, (value3, key) => {
          const reducedValue = visit(value3, i2 + 1);
          !isUndefined(reducedValue) && (target2[key] = reducedValue);
        });
        stack[i2] = void 0;
        return target2;
      }
    }
    return source;
  };
  return visit(obj, 0);
};
const isAsyncFn = kindOfTest("AsyncFunction");
const isThenable = (thing) => thing && (isObject$e(thing) || isFunction$1(thing)) && isFunction$1(thing.then) && isFunction$1(thing.catch);
const _setImmediate = ((setImmediateSupported, postMessageSupported) => {
  if (setImmediateSupported) {
    return setImmediate;
  }
  return postMessageSupported ? ((token2, callbacks2) => {
    _global.addEventListener("message", ({ source, data: data12 }) => {
      if (source === _global && data12 === token2) {
        callbacks2.length && callbacks2.shift()();
      }
    }, false);
    return (cb) => {
      callbacks2.push(cb);
      _global.postMessage(token2, "*");
    };
  })(`axios@${Math.random()}`, []) : (cb) => setTimeout(cb);
})(
  typeof setImmediate === "function",
  isFunction$1(_global.postMessage)
);
const asap = typeof queueMicrotask !== "undefined" ? queueMicrotask.bind(_global) : typeof process$1$1 !== "undefined" && process$1$1.nextTick || _setImmediate;
const utils$1 = {
  isArray: isArray$4,
  isArrayBuffer,
  isBuffer: isBuffer$1,
  isFormData,
  isArrayBufferView,
  isString,
  isNumber: isNumber$2,
  isBoolean,
  isObject: isObject$e,
  isPlainObject,
  isReadableStream,
  isRequest,
  isResponse,
  isHeaders,
  isUndefined,
  isDate: isDate$1,
  isFile,
  isBlob,
  isRegExp,
  isFunction: isFunction$1,
  isStream,
  isURLSearchParams,
  isTypedArray,
  isFileList,
  forEach,
  merge,
  extend: extend$1,
  trim: trim$1,
  stripBOM,
  inherits,
  toFlatObject,
  kindOf,
  kindOfTest,
  endsWith,
  toArray,
  forEachEntry,
  matchAll,
  isHTMLForm,
  hasOwnProperty: hasOwnProperty$3,
  hasOwnProp: hasOwnProperty$3,
  // an alias to avoid ESLint no-prototype-builtins detection
  reduceDescriptors,
  freezeMethods,
  toObjectSet,
  toCamelCase,
  noop: noop$4,
  toFiniteNumber,
  findKey,
  global: _global,
  isContextDefined,
  ALPHABET,
  generateString,
  isSpecCompliantForm,
  toJSONObject,
  isAsyncFn,
  isThenable,
  setImmediate: _setImmediate,
  asap
};
var buffer = {};
var base64Js = {};
base64Js.byteLength = byteLength;
base64Js.toByteArray = toByteArray;
base64Js.fromByteArray = fromByteArray;
var lookup = [];
var revLookup = [];
var Arr = typeof Uint8Array !== "undefined" ? Uint8Array : Array;
var code = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
for (var i$2 = 0, len = code.length; i$2 < len; ++i$2) {
  lookup[i$2] = code[i$2];
  revLookup[code.charCodeAt(i$2)] = i$2;
}
revLookup["-".charCodeAt(0)] = 62;
revLookup["_".charCodeAt(0)] = 63;
function getLens(b64) {
  var len = b64.length;
  if (len % 4 > 0) {
    throw new Error("Invalid string. Length must be a multiple of 4");
  }
  var validLen = b64.indexOf("=");
  if (validLen === -1) validLen = len;
  var placeHoldersLen = validLen === len ? 0 : 4 - validLen % 4;
  return [validLen, placeHoldersLen];
}
function byteLength(b64) {
  var lens = getLens(b64);
  var validLen = lens[0];
  var placeHoldersLen = lens[1];
  return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
}
function _byteLength(b64, validLen, placeHoldersLen) {
  return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
}
function toByteArray(b64) {
  var tmp;
  var lens = getLens(b64);
  var validLen = lens[0];
  var placeHoldersLen = lens[1];
  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen));
  var curByte = 0;
  var len = placeHoldersLen > 0 ? validLen - 4 : validLen;
  var i2;
  for (i2 = 0; i2 < len; i2 += 4) {
    tmp = revLookup[b64.charCodeAt(i2)] << 18 | revLookup[b64.charCodeAt(i2 + 1)] << 12 | revLookup[b64.charCodeAt(i2 + 2)] << 6 | revLookup[b64.charCodeAt(i2 + 3)];
    arr[curByte++] = tmp >> 16 & 255;
    arr[curByte++] = tmp >> 8 & 255;
    arr[curByte++] = tmp & 255;
  }
  if (placeHoldersLen === 2) {
    tmp = revLookup[b64.charCodeAt(i2)] << 2 | revLookup[b64.charCodeAt(i2 + 1)] >> 4;
    arr[curByte++] = tmp & 255;
  }
  if (placeHoldersLen === 1) {
    tmp = revLookup[b64.charCodeAt(i2)] << 10 | revLookup[b64.charCodeAt(i2 + 1)] << 4 | revLookup[b64.charCodeAt(i2 + 2)] >> 2;
    arr[curByte++] = tmp >> 8 & 255;
    arr[curByte++] = tmp & 255;
  }
  return arr;
}
function tripletToBase64(num) {
  return lookup[num >> 18 & 63] + lookup[num >> 12 & 63] + lookup[num >> 6 & 63] + lookup[num & 63];
}
function encodeChunk(uint8, start, end) {
  var tmp;
  var output = [];
  for (var i2 = start; i2 < end; i2 += 3) {
    tmp = (uint8[i2] << 16 & 16711680) + (uint8[i2 + 1] << 8 & 65280) + (uint8[i2 + 2] & 255);
    output.push(tripletToBase64(tmp));
  }
  return output.join("");
}
function fromByteArray(uint8) {
  var tmp;
  var len = uint8.length;
  var extraBytes = len % 3;
  var parts = [];
  var maxChunkLength = 16383;
  for (var i2 = 0, len2 = len - extraBytes; i2 < len2; i2 += maxChunkLength) {
    parts.push(encodeChunk(uint8, i2, i2 + maxChunkLength > len2 ? len2 : i2 + maxChunkLength));
  }
  if (extraBytes === 1) {
    tmp = uint8[len - 1];
    parts.push(
      lookup[tmp >> 2] + lookup[tmp << 4 & 63] + "=="
    );
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + uint8[len - 1];
    parts.push(
      lookup[tmp >> 10] + lookup[tmp >> 4 & 63] + lookup[tmp << 2 & 63] + "="
    );
  }
  return parts.join("");
}
var ieee754 = {};
/*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */
ieee754.read = function(buffer2, offset2, isLE, mLen, nBytes) {
  var e2, m3;
  var eLen = nBytes * 8 - mLen - 1;
  var eMax = (1 << eLen) - 1;
  var eBias = eMax >> 1;
  var nBits = -7;
  var i2 = isLE ? nBytes - 1 : 0;
  var d3 = isLE ? -1 : 1;
  var s3 = buffer2[offset2 + i2];
  i2 += d3;
  e2 = s3 & (1 << -nBits) - 1;
  s3 >>= -nBits;
  nBits += eLen;
  for (; nBits > 0; e2 = e2 * 256 + buffer2[offset2 + i2], i2 += d3, nBits -= 8) {
  }
  m3 = e2 & (1 << -nBits) - 1;
  e2 >>= -nBits;
  nBits += mLen;
  for (; nBits > 0; m3 = m3 * 256 + buffer2[offset2 + i2], i2 += d3, nBits -= 8) {
  }
  if (e2 === 0) {
    e2 = 1 - eBias;
  } else if (e2 === eMax) {
    return m3 ? NaN : (s3 ? -1 : 1) * Infinity;
  } else {
    m3 = m3 + Math.pow(2, mLen);
    e2 = e2 - eBias;
  }
  return (s3 ? -1 : 1) * m3 * Math.pow(2, e2 - mLen);
};
ieee754.write = function(buffer2, value3, offset2, isLE, mLen, nBytes) {
  var e2, m3, c2;
  var eLen = nBytes * 8 - mLen - 1;
  var eMax = (1 << eLen) - 1;
  var eBias = eMax >> 1;
  var rt2 = mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0;
  var i2 = isLE ? 0 : nBytes - 1;
  var d3 = isLE ? 1 : -1;
  var s3 = value3 < 0 || value3 === 0 && 1 / value3 < 0 ? 1 : 0;
  value3 = Math.abs(value3);
  if (isNaN(value3) || value3 === Infinity) {
    m3 = isNaN(value3) ? 1 : 0;
    e2 = eMax;
  } else {
    e2 = Math.floor(Math.log(value3) / Math.LN2);
    if (value3 * (c2 = Math.pow(2, -e2)) < 1) {
      e2--;
      c2 *= 2;
    }
    if (e2 + eBias >= 1) {
      value3 += rt2 / c2;
    } else {
      value3 += rt2 * Math.pow(2, 1 - eBias);
    }
    if (value3 * c2 >= 2) {
      e2++;
      c2 /= 2;
    }
    if (e2 + eBias >= eMax) {
      m3 = 0;
      e2 = eMax;
    } else if (e2 + eBias >= 1) {
      m3 = (value3 * c2 - 1) * Math.pow(2, mLen);
      e2 = e2 + eBias;
    } else {
      m3 = value3 * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
      e2 = 0;
    }
  }
  for (; mLen >= 8; buffer2[offset2 + i2] = m3 & 255, i2 += d3, m3 /= 256, mLen -= 8) {
  }
  e2 = e2 << mLen | m3;
  eLen += mLen;
  for (; eLen > 0; buffer2[offset2 + i2] = e2 & 255, i2 += d3, e2 /= 256, eLen -= 8) {
  }
  buffer2[offset2 + i2 - d3] |= s3 * 128;
};
/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */
(function(exports) {
  const base64 = base64Js;
  const ieee754$1 = ieee754;
  const customInspectSymbol = typeof Symbol === "function" && typeof Symbol["for"] === "function" ? Symbol["for"]("nodejs.util.inspect.custom") : null;
  exports.Buffer = Buffer2;
  exports.SlowBuffer = SlowBuffer;
  exports.INSPECT_MAX_BYTES = 50;
  const K_MAX_LENGTH = 2147483647;
  exports.kMaxLength = K_MAX_LENGTH;
  const { Uint8Array: GlobalUint8Array, ArrayBuffer: GlobalArrayBuffer, SharedArrayBuffer: GlobalSharedArrayBuffer } = globalThis;
  Buffer2.TYPED_ARRAY_SUPPORT = typedArraySupport();
  if (!Buffer2.TYPED_ARRAY_SUPPORT && typeof console !== "undefined" && typeof console.error === "function") {
    console.error(
      "This browser lacks typed array (Uint8Array) support which is required by `buffer` v5.x. Use `buffer` v4.x if you require old browser support."
    );
  }
  function typedArraySupport() {
    try {
      const arr = new GlobalUint8Array(1);
      const proto = { foo: function() {
        return 42;
      } };
      Object.setPrototypeOf(proto, GlobalUint8Array.prototype);
      Object.setPrototypeOf(arr, proto);
      return arr.foo() === 42;
    } catch (e2) {
      return false;
    }
  }
  Object.defineProperty(Buffer2.prototype, "parent", {
    enumerable: true,
    get: function() {
      if (!Buffer2.isBuffer(this)) return void 0;
      return this.buffer;
    }
  });
  Object.defineProperty(Buffer2.prototype, "offset", {
    enumerable: true,
    get: function() {
      if (!Buffer2.isBuffer(this)) return void 0;
      return this.byteOffset;
    }
  });
  function createBuffer(length) {
    if (length > K_MAX_LENGTH) {
      throw new RangeError('The value "' + length + '" is invalid for option "size"');
    }
    const buf = new GlobalUint8Array(length);
    Object.setPrototypeOf(buf, Buffer2.prototype);
    return buf;
  }
  function Buffer2(arg, encodingOrOffset, length) {
    if (typeof arg === "number") {
      if (typeof encodingOrOffset === "string") {
        throw new TypeError(
          'The "string" argument must be of type string. Received type number'
        );
      }
      return allocUnsafe(arg);
    }
    return from(arg, encodingOrOffset, length);
  }
  Buffer2.poolSize = 8192;
  function from(value3, encodingOrOffset, length) {
    if (typeof value3 === "string") {
      return fromString(value3, encodingOrOffset);
    }
    if (GlobalArrayBuffer.isView(value3)) {
      return fromArrayView(value3);
    }
    if (value3 == null) {
      throw new TypeError(
        "The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type " + typeof value3
      );
    }
    if (isInstance(value3, GlobalArrayBuffer) || value3 && isInstance(value3.buffer, GlobalArrayBuffer)) {
      return fromArrayBuffer(value3, encodingOrOffset, length);
    }
    if (typeof GlobalSharedArrayBuffer !== "undefined" && (isInstance(value3, GlobalSharedArrayBuffer) || value3 && isInstance(value3.buffer, GlobalSharedArrayBuffer))) {
      return fromArrayBuffer(value3, encodingOrOffset, length);
    }
    if (typeof value3 === "number") {
      throw new TypeError(
        'The "value" argument must not be of type number. Received type number'
      );
    }
    const valueOf = value3.valueOf && value3.valueOf();
    if (valueOf != null && valueOf !== value3) {
      return Buffer2.from(valueOf, encodingOrOffset, length);
    }
    const b2 = fromObject(value3);
    if (b2) return b2;
    if (typeof Symbol !== "undefined" && Symbol.toPrimitive != null && typeof value3[Symbol.toPrimitive] === "function") {
      return Buffer2.from(value3[Symbol.toPrimitive]("string"), encodingOrOffset, length);
    }
    throw new TypeError(
      "The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type " + typeof value3
    );
  }
  Buffer2.from = function(value3, encodingOrOffset, length) {
    return from(value3, encodingOrOffset, length);
  };
  Object.setPrototypeOf(Buffer2.prototype, GlobalUint8Array.prototype);
  Object.setPrototypeOf(Buffer2, GlobalUint8Array);
  function assertSize(size2) {
    if (typeof size2 !== "number") {
      throw new TypeError('"size" argument must be of type number');
    } else if (size2 < 0) {
      throw new RangeError('The value "' + size2 + '" is invalid for option "size"');
    }
  }
  function alloc(size2, fill, encoding) {
    assertSize(size2);
    if (size2 <= 0) {
      return createBuffer(size2);
    }
    if (fill !== void 0) {
      return typeof encoding === "string" ? createBuffer(size2).fill(fill, encoding) : createBuffer(size2).fill(fill);
    }
    return createBuffer(size2);
  }
  Buffer2.alloc = function(size2, fill, encoding) {
    return alloc(size2, fill, encoding);
  };
  function allocUnsafe(size2) {
    assertSize(size2);
    return createBuffer(size2 < 0 ? 0 : checked(size2) | 0);
  }
  Buffer2.allocUnsafe = function(size2) {
    return allocUnsafe(size2);
  };
  Buffer2.allocUnsafeSlow = function(size2) {
    return allocUnsafe(size2);
  };
  function fromString(string, encoding) {
    if (typeof encoding !== "string" || encoding === "") {
      encoding = "utf8";
    }
    if (!Buffer2.isEncoding(encoding)) {
      throw new TypeError("Unknown encoding: " + encoding);
    }
    const length = byteLength2(string, encoding) | 0;
    let buf = createBuffer(length);
    const actual = buf.write(string, encoding);
    if (actual !== length) {
      buf = buf.slice(0, actual);
    }
    return buf;
  }
  function fromArrayLike(array) {
    const length = array.length < 0 ? 0 : checked(array.length) | 0;
    const buf = createBuffer(length);
    for (let i2 = 0; i2 < length; i2 += 1) {
      buf[i2] = array[i2] & 255;
    }
    return buf;
  }
  function fromArrayView(arrayView) {
    if (isInstance(arrayView, GlobalUint8Array)) {
      const copy = new GlobalUint8Array(arrayView);
      return fromArrayBuffer(copy.buffer, copy.byteOffset, copy.byteLength);
    }
    return fromArrayLike(arrayView);
  }
  function fromArrayBuffer(array, byteOffset, length) {
    if (byteOffset < 0 || array.byteLength < byteOffset) {
      throw new RangeError('"offset" is outside of buffer bounds');
    }
    if (array.byteLength < byteOffset + (length || 0)) {
      throw new RangeError('"length" is outside of buffer bounds');
    }
    let buf;
    if (byteOffset === void 0 && length === void 0) {
      buf = new GlobalUint8Array(array);
    } else if (length === void 0) {
      buf = new GlobalUint8Array(array, byteOffset);
    } else {
      buf = new GlobalUint8Array(array, byteOffset, length);
    }
    Object.setPrototypeOf(buf, Buffer2.prototype);
    return buf;
  }
  function fromObject(obj) {
    if (Buffer2.isBuffer(obj)) {
      const len = checked(obj.length) | 0;
      const buf = createBuffer(len);
      if (buf.length === 0) {
        return buf;
      }
      obj.copy(buf, 0, 0, len);
      return buf;
    }
    if (obj.length !== void 0) {
      if (typeof obj.length !== "number" || numberIsNaN(obj.length)) {
        return createBuffer(0);
      }
      return fromArrayLike(obj);
    }
    if (obj.type === "Buffer" && Array.isArray(obj.data)) {
      return fromArrayLike(obj.data);
    }
  }
  function checked(length) {
    if (length >= K_MAX_LENGTH) {
      throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x" + K_MAX_LENGTH.toString(16) + " bytes");
    }
    return length | 0;
  }
  function SlowBuffer(length) {
    if (+length != length) {
      length = 0;
    }
    return Buffer2.alloc(+length);
  }
  Buffer2.isBuffer = function isBuffer2(b2) {
    return b2 != null && b2._isBuffer === true && b2 !== Buffer2.prototype;
  };
  Buffer2.compare = function compare(a3, b2) {
    if (isInstance(a3, GlobalUint8Array)) a3 = Buffer2.from(a3, a3.offset, a3.byteLength);
    if (isInstance(b2, GlobalUint8Array)) b2 = Buffer2.from(b2, b2.offset, b2.byteLength);
    if (!Buffer2.isBuffer(a3) || !Buffer2.isBuffer(b2)) {
      throw new TypeError(
        'The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array'
      );
    }
    if (a3 === b2) return 0;
    let x3 = a3.length;
    let y2 = b2.length;
    for (let i2 = 0, len = Math.min(x3, y2); i2 < len; ++i2) {
      if (a3[i2] !== b2[i2]) {
        x3 = a3[i2];
        y2 = b2[i2];
        break;
      }
    }
    if (x3 < y2) return -1;
    if (y2 < x3) return 1;
    return 0;
  };
  Buffer2.isEncoding = function isEncoding(encoding) {
    switch (String(encoding).toLowerCase()) {
      case "hex":
      case "utf8":
      case "utf-8":
      case "ascii":
      case "latin1":
      case "binary":
      case "base64":
      case "ucs2":
      case "ucs-2":
      case "utf16le":
      case "utf-16le":
        return true;
      default:
        return false;
    }
  };
  Buffer2.concat = function concat2(list2, length) {
    if (!Array.isArray(list2)) {
      throw new TypeError('"list" argument must be an Array of Buffers');
    }
    if (list2.length === 0) {
      return Buffer2.alloc(0);
    }
    let i2;
    if (length === void 0) {
      length = 0;
      for (i2 = 0; i2 < list2.length; ++i2) {
        length += list2[i2].length;
      }
    }
    const buffer2 = Buffer2.allocUnsafe(length);
    let pos = 0;
    for (i2 = 0; i2 < list2.length; ++i2) {
      let buf = list2[i2];
      if (isInstance(buf, GlobalUint8Array)) {
        if (pos + buf.length > buffer2.length) {
          if (!Buffer2.isBuffer(buf)) buf = Buffer2.from(buf);
          buf.copy(buffer2, pos);
        } else {
          GlobalUint8Array.prototype.set.call(
            buffer2,
            buf,
            pos
          );
        }
      } else if (!Buffer2.isBuffer(buf)) {
        throw new TypeError('"list" argument must be an Array of Buffers');
      } else {
        buf.copy(buffer2, pos);
      }
      pos += buf.length;
    }
    return buffer2;
  };
  function byteLength2(string, encoding) {
    if (Buffer2.isBuffer(string)) {
      return string.length;
    }
    if (GlobalArrayBuffer.isView(string) || isInstance(string, GlobalArrayBuffer)) {
      return string.byteLength;
    }
    if (typeof string !== "string") {
      throw new TypeError(
        'The "string" argument must be one of type string, Buffer, or ArrayBuffer. Received type ' + typeof string
      );
    }
    const len = string.length;
    const mustMatch = arguments.length > 2 && arguments[2] === true;
    if (!mustMatch && len === 0) return 0;
    let loweredCase = false;
    for (; ; ) {
      switch (encoding) {
        case "ascii":
        case "latin1":
        case "binary":
          return len;
        case "utf8":
        case "utf-8":
          return utf8ToBytes(string).length;
        case "ucs2":
        case "ucs-2":
        case "utf16le":
        case "utf-16le":
          return len * 2;
        case "hex":
          return len >>> 1;
        case "base64":
          return base64ToBytes(string).length;
        default:
          if (loweredCase) {
            return mustMatch ? -1 : utf8ToBytes(string).length;
          }
          encoding = ("" + encoding).toLowerCase();
          loweredCase = true;
      }
    }
  }
  Buffer2.byteLength = byteLength2;
  function slowToString(encoding, start, end) {
    let loweredCase = false;
    if (start === void 0 || start < 0) {
      start = 0;
    }
    if (start > this.length) {
      return "";
    }
    if (end === void 0 || end > this.length) {
      end = this.length;
    }
    if (end <= 0) {
      return "";
    }
    end >>>= 0;
    start >>>= 0;
    if (end <= start) {
      return "";
    }
    if (!encoding) encoding = "utf8";
    while (true) {
      switch (encoding) {
        case "hex":
          return hexSlice(this, start, end);
        case "utf8":
        case "utf-8":
          return utf8Slice(this, start, end);
        case "ascii":
          return asciiSlice(this, start, end);
        case "latin1":
        case "binary":
          return latin1Slice(this, start, end);
        case "base64":
          return base64Slice(this, start, end);
        case "ucs2":
        case "ucs-2":
        case "utf16le":
        case "utf-16le":
          return utf16leSlice(this, start, end);
        default:
          if (loweredCase) throw new TypeError("Unknown encoding: " + encoding);
          encoding = (encoding + "").toLowerCase();
          loweredCase = true;
      }
    }
  }
  Buffer2.prototype._isBuffer = true;
  function swap(b2, n2, m3) {
    const i2 = b2[n2];
    b2[n2] = b2[m3];
    b2[m3] = i2;
  }
  Buffer2.prototype.swap16 = function swap16() {
    const len = this.length;
    if (len % 2 !== 0) {
      throw new RangeError("Buffer size must be a multiple of 16-bits");
    }
    for (let i2 = 0; i2 < len; i2 += 2) {
      swap(this, i2, i2 + 1);
    }
    return this;
  };
  Buffer2.prototype.swap32 = function swap32() {
    const len = this.length;
    if (len % 4 !== 0) {
      throw new RangeError("Buffer size must be a multiple of 32-bits");
    }
    for (let i2 = 0; i2 < len; i2 += 4) {
      swap(this, i2, i2 + 3);
      swap(this, i2 + 1, i2 + 2);
    }
    return this;
  };
  Buffer2.prototype.swap64 = function swap64() {
    const len = this.length;
    if (len % 8 !== 0) {
      throw new RangeError("Buffer size must be a multiple of 64-bits");
    }
    for (let i2 = 0; i2 < len; i2 += 8) {
      swap(this, i2, i2 + 7);
      swap(this, i2 + 1, i2 + 6);
      swap(this, i2 + 2, i2 + 5);
      swap(this, i2 + 3, i2 + 4);
    }
    return this;
  };
  Buffer2.prototype.toString = function toString5() {
    const length = this.length;
    if (length === 0) return "";
    if (arguments.length === 0) return utf8Slice(this, 0, length);
    return slowToString.apply(this, arguments);
  };
  Buffer2.prototype.toLocaleString = Buffer2.prototype.toString;
  Buffer2.prototype.equals = function equals(b2) {
    if (!Buffer2.isBuffer(b2)) throw new TypeError("Argument must be a Buffer");
    if (this === b2) return true;
    return Buffer2.compare(this, b2) === 0;
  };
  Buffer2.prototype.inspect = function inspect() {
    let str = "";
    const max2 = exports.INSPECT_MAX_BYTES;
    str = this.toString("hex", 0, max2).replace(/(.{2})/g, "$1 ").trim();
    if (this.length > max2) str += " ... ";
    return "<Buffer " + str + ">";
  };
  if (customInspectSymbol) {
    Buffer2.prototype[customInspectSymbol] = Buffer2.prototype.inspect;
  }
  Buffer2.prototype.compare = function compare(target2, start, end, thisStart, thisEnd) {
    if (isInstance(target2, GlobalUint8Array)) {
      target2 = Buffer2.from(target2, target2.offset, target2.byteLength);
    }
    if (!Buffer2.isBuffer(target2)) {
      throw new TypeError(
        'The "target" argument must be one of type Buffer or Uint8Array. Received type ' + typeof target2
      );
    }
    if (start === void 0) {
      start = 0;
    }
    if (end === void 0) {
      end = target2 ? target2.length : 0;
    }
    if (thisStart === void 0) {
      thisStart = 0;
    }
    if (thisEnd === void 0) {
      thisEnd = this.length;
    }
    if (start < 0 || end > target2.length || thisStart < 0 || thisEnd > this.length) {
      throw new RangeError("out of range index");
    }
    if (thisStart >= thisEnd && start >= end) {
      return 0;
    }
    if (thisStart >= thisEnd) {
      return -1;
    }
    if (start >= end) {
      return 1;
    }
    start >>>= 0;
    end >>>= 0;
    thisStart >>>= 0;
    thisEnd >>>= 0;
    if (this === target2) return 0;
    let x3 = thisEnd - thisStart;
    let y2 = end - start;
    const len = Math.min(x3, y2);
    const thisCopy = this.slice(thisStart, thisEnd);
    const targetCopy = target2.slice(start, end);
    for (let i2 = 0; i2 < len; ++i2) {
      if (thisCopy[i2] !== targetCopy[i2]) {
        x3 = thisCopy[i2];
        y2 = targetCopy[i2];
        break;
      }
    }
    if (x3 < y2) return -1;
    if (y2 < x3) return 1;
    return 0;
  };
  function bidirectionalIndexOf(buffer2, val2, byteOffset, encoding, dir) {
    if (buffer2.length === 0) return -1;
    if (typeof byteOffset === "string") {
      encoding = byteOffset;
      byteOffset = 0;
    } else if (byteOffset > 2147483647) {
      byteOffset = 2147483647;
    } else if (byteOffset < -2147483648) {
      byteOffset = -2147483648;
    }
    byteOffset = +byteOffset;
    if (numberIsNaN(byteOffset)) {
      byteOffset = dir ? 0 : buffer2.length - 1;
    }
    if (byteOffset < 0) byteOffset = buffer2.length + byteOffset;
    if (byteOffset >= buffer2.length) {
      if (dir) return -1;
      else byteOffset = buffer2.length - 1;
    } else if (byteOffset < 0) {
      if (dir) byteOffset = 0;
      else return -1;
    }
    if (typeof val2 === "string") {
      val2 = Buffer2.from(val2, encoding);
    }
    if (Buffer2.isBuffer(val2)) {
      if (val2.length === 0) {
        return -1;
      }
      return arrayIndexOf(buffer2, val2, byteOffset, encoding, dir);
    } else if (typeof val2 === "number") {
      val2 = val2 & 255;
      if (typeof GlobalUint8Array.prototype.indexOf === "function") {
        if (dir) {
          return GlobalUint8Array.prototype.indexOf.call(buffer2, val2, byteOffset);
        } else {
          return GlobalUint8Array.prototype.lastIndexOf.call(buffer2, val2, byteOffset);
        }
      }
      return arrayIndexOf(buffer2, [val2], byteOffset, encoding, dir);
    }
    throw new TypeError("val must be string, number or Buffer");
  }
  function arrayIndexOf(arr, val2, byteOffset, encoding, dir) {
    let indexSize = 1;
    let arrLength = arr.length;
    let valLength = val2.length;
    if (encoding !== void 0) {
      encoding = String(encoding).toLowerCase();
      if (encoding === "ucs2" || encoding === "ucs-2" || encoding === "utf16le" || encoding === "utf-16le") {
        if (arr.length < 2 || val2.length < 2) {
          return -1;
        }
        indexSize = 2;
        arrLength /= 2;
        valLength /= 2;
        byteOffset /= 2;
      }
    }
    function read(buf, i3) {
      if (indexSize === 1) {
        return buf[i3];
      } else {
        return buf.readUInt16BE(i3 * indexSize);
      }
    }
    let i2;
    if (dir) {
      let foundIndex = -1;
      for (i2 = byteOffset; i2 < arrLength; i2++) {
        if (read(arr, i2) === read(val2, foundIndex === -1 ? 0 : i2 - foundIndex)) {
          if (foundIndex === -1) foundIndex = i2;
          if (i2 - foundIndex + 1 === valLength) return foundIndex * indexSize;
        } else {
          if (foundIndex !== -1) i2 -= i2 - foundIndex;
          foundIndex = -1;
        }
      }
    } else {
      if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;
      for (i2 = byteOffset; i2 >= 0; i2--) {
        let found = true;
        for (let j2 = 0; j2 < valLength; j2++) {
          if (read(arr, i2 + j2) !== read(val2, j2)) {
            found = false;
            break;
          }
        }
        if (found) return i2;
      }
    }
    return -1;
  }
  Buffer2.prototype.includes = function includes(val2, byteOffset, encoding) {
    return this.indexOf(val2, byteOffset, encoding) !== -1;
  };
  Buffer2.prototype.indexOf = function indexOf2(val2, byteOffset, encoding) {
    return bidirectionalIndexOf(this, val2, byteOffset, encoding, true);
  };
  Buffer2.prototype.lastIndexOf = function lastIndexOf(val2, byteOffset, encoding) {
    return bidirectionalIndexOf(this, val2, byteOffset, encoding, false);
  };
  function hexWrite(buf, string, offset2, length) {
    offset2 = Number(offset2) || 0;
    const remaining = buf.length - offset2;
    if (!length) {
      length = remaining;
    } else {
      length = Number(length);
      if (length > remaining) {
        length = remaining;
      }
    }
    const strLen = string.length;
    if (length > strLen / 2) {
      length = strLen / 2;
    }
    let i2;
    for (i2 = 0; i2 < length; ++i2) {
      const parsed = parseInt(string.substr(i2 * 2, 2), 16);
      if (numberIsNaN(parsed)) return i2;
      buf[offset2 + i2] = parsed;
    }
    return i2;
  }
  function utf8Write(buf, string, offset2, length) {
    return blitBuffer(utf8ToBytes(string, buf.length - offset2), buf, offset2, length);
  }
  function asciiWrite(buf, string, offset2, length) {
    return blitBuffer(asciiToBytes(string), buf, offset2, length);
  }
  function base64Write(buf, string, offset2, length) {
    return blitBuffer(base64ToBytes(string), buf, offset2, length);
  }
  function ucs2Write(buf, string, offset2, length) {
    return blitBuffer(utf16leToBytes(string, buf.length - offset2), buf, offset2, length);
  }
  Buffer2.prototype.write = function write(string, offset2, length, encoding) {
    if (offset2 === void 0) {
      encoding = "utf8";
      length = this.length;
      offset2 = 0;
    } else if (length === void 0 && typeof offset2 === "string") {
      encoding = offset2;
      length = this.length;
      offset2 = 0;
    } else if (isFinite(offset2)) {
      offset2 = offset2 >>> 0;
      if (isFinite(length)) {
        length = length >>> 0;
        if (encoding === void 0) encoding = "utf8";
      } else {
        encoding = length;
        length = void 0;
      }
    } else {
      throw new Error(
        "Buffer.write(string, encoding, offset[, length]) is no longer supported"
      );
    }
    const remaining = this.length - offset2;
    if (length === void 0 || length > remaining) length = remaining;
    if (string.length > 0 && (length < 0 || offset2 < 0) || offset2 > this.length) {
      throw new RangeError("Attempt to write outside buffer bounds");
    }
    if (!encoding) encoding = "utf8";
    let loweredCase = false;
    for (; ; ) {
      switch (encoding) {
        case "hex":
          return hexWrite(this, string, offset2, length);
        case "utf8":
        case "utf-8":
          return utf8Write(this, string, offset2, length);
        case "ascii":
        case "latin1":
        case "binary":
          return asciiWrite(this, string, offset2, length);
        case "base64":
          return base64Write(this, string, offset2, length);
        case "ucs2":
        case "ucs-2":
        case "utf16le":
        case "utf-16le":
          return ucs2Write(this, string, offset2, length);
        default:
          if (loweredCase) throw new TypeError("Unknown encoding: " + encoding);
          encoding = ("" + encoding).toLowerCase();
          loweredCase = true;
      }
    }
  };
  Buffer2.prototype.toJSON = function toJSON2() {
    return {
      type: "Buffer",
      data: Array.prototype.slice.call(this._arr || this, 0)
    };
  };
  function base64Slice(buf, start, end) {
    if (start === 0 && end === buf.length) {
      return base64.fromByteArray(buf);
    } else {
      return base64.fromByteArray(buf.slice(start, end));
    }
  }
  function utf8Slice(buf, start, end) {
    end = Math.min(buf.length, end);
    const res = [];
    let i2 = start;
    while (i2 < end) {
      const firstByte = buf[i2];
      let codePoint = null;
      let bytesPerSequence = firstByte > 239 ? 4 : firstByte > 223 ? 3 : firstByte > 191 ? 2 : 1;
      if (i2 + bytesPerSequence <= end) {
        let secondByte, thirdByte, fourthByte, tempCodePoint;
        switch (bytesPerSequence) {
          case 1:
            if (firstByte < 128) {
              codePoint = firstByte;
            }
            break;
          case 2:
            secondByte = buf[i2 + 1];
            if ((secondByte & 192) === 128) {
              tempCodePoint = (firstByte & 31) << 6 | secondByte & 63;
              if (tempCodePoint > 127) {
                codePoint = tempCodePoint;
              }
            }
            break;
          case 3:
            secondByte = buf[i2 + 1];
            thirdByte = buf[i2 + 2];
            if ((secondByte & 192) === 128 && (thirdByte & 192) === 128) {
              tempCodePoint = (firstByte & 15) << 12 | (secondByte & 63) << 6 | thirdByte & 63;
              if (tempCodePoint > 2047 && (tempCodePoint < 55296 || tempCodePoint > 57343)) {
                codePoint = tempCodePoint;
              }
            }
            break;
          case 4:
            secondByte = buf[i2 + 1];
            thirdByte = buf[i2 + 2];
            fourthByte = buf[i2 + 3];
            if ((secondByte & 192) === 128 && (thirdByte & 192) === 128 && (fourthByte & 192) === 128) {
              tempCodePoint = (firstByte & 15) << 18 | (secondByte & 63) << 12 | (thirdByte & 63) << 6 | fourthByte & 63;
              if (tempCodePoint > 65535 && tempCodePoint < 1114112) {
                codePoint = tempCodePoint;
              }
            }
        }
      }
      if (codePoint === null) {
        codePoint = 65533;
        bytesPerSequence = 1;
      } else if (codePoint > 65535) {
        codePoint -= 65536;
        res.push(codePoint >>> 10 & 1023 | 55296);
        codePoint = 56320 | codePoint & 1023;
      }
      res.push(codePoint);
      i2 += bytesPerSequence;
    }
    return decodeCodePointsArray(res);
  }
  const MAX_ARGUMENTS_LENGTH = 4096;
  function decodeCodePointsArray(codePoints) {
    const len = codePoints.length;
    if (len <= MAX_ARGUMENTS_LENGTH) {
      return String.fromCharCode.apply(String, codePoints);
    }
    let res = "";
    let i2 = 0;
    while (i2 < len) {
      res += String.fromCharCode.apply(
        String,
        codePoints.slice(i2, i2 += MAX_ARGUMENTS_LENGTH)
      );
    }
    return res;
  }
  function asciiSlice(buf, start, end) {
    let ret = "";
    end = Math.min(buf.length, end);
    for (let i2 = start; i2 < end; ++i2) {
      ret += String.fromCharCode(buf[i2] & 127);
    }
    return ret;
  }
  function latin1Slice(buf, start, end) {
    let ret = "";
    end = Math.min(buf.length, end);
    for (let i2 = start; i2 < end; ++i2) {
      ret += String.fromCharCode(buf[i2]);
    }
    return ret;
  }
  function hexSlice(buf, start, end) {
    const len = buf.length;
    if (!start || start < 0) start = 0;
    if (!end || end < 0 || end > len) end = len;
    let out = "";
    for (let i2 = start; i2 < end; ++i2) {
      out += hexSliceLookupTable[buf[i2]];
    }
    return out;
  }
  function utf16leSlice(buf, start, end) {
    const bytes = buf.slice(start, end);
    let res = "";
    for (let i2 = 0; i2 < bytes.length - 1; i2 += 2) {
      res += String.fromCharCode(bytes[i2] + bytes[i2 + 1] * 256);
    }
    return res;
  }
  Buffer2.prototype.slice = function slice(start, end) {
    const len = this.length;
    start = ~~start;
    end = end === void 0 ? len : ~~end;
    if (start < 0) {
      start += len;
      if (start < 0) start = 0;
    } else if (start > len) {
      start = len;
    }
    if (end < 0) {
      end += len;
      if (end < 0) end = 0;
    } else if (end > len) {
      end = len;
    }
    if (end < start) end = start;
    const newBuf = this.subarray(start, end);
    Object.setPrototypeOf(newBuf, Buffer2.prototype);
    return newBuf;
  };
  function checkOffset(offset2, ext, length) {
    if (offset2 % 1 !== 0 || offset2 < 0) throw new RangeError("offset is not uint");
    if (offset2 + ext > length) throw new RangeError("Trying to access beyond buffer length");
  }
  Buffer2.prototype.readUintLE = Buffer2.prototype.readUIntLE = function readUIntLE(offset2, byteLength3, noAssert) {
    offset2 = offset2 >>> 0;
    byteLength3 = byteLength3 >>> 0;
    if (!noAssert) checkOffset(offset2, byteLength3, this.length);
    let val2 = this[offset2];
    let mul = 1;
    let i2 = 0;
    while (++i2 < byteLength3 && (mul *= 256)) {
      val2 += this[offset2 + i2] * mul;
    }
    return val2;
  };
  Buffer2.prototype.readUintBE = Buffer2.prototype.readUIntBE = function readUIntBE(offset2, byteLength3, noAssert) {
    offset2 = offset2 >>> 0;
    byteLength3 = byteLength3 >>> 0;
    if (!noAssert) {
      checkOffset(offset2, byteLength3, this.length);
    }
    let val2 = this[offset2 + --byteLength3];
    let mul = 1;
    while (byteLength3 > 0 && (mul *= 256)) {
      val2 += this[offset2 + --byteLength3] * mul;
    }
    return val2;
  };
  Buffer2.prototype.readUint8 = Buffer2.prototype.readUInt8 = function readUInt8(offset2, noAssert) {
    offset2 = offset2 >>> 0;
    if (!noAssert) checkOffset(offset2, 1, this.length);
    return this[offset2];
  };
  Buffer2.prototype.readUint16LE = Buffer2.prototype.readUInt16LE = function readUInt16LE(offset2, noAssert) {
    offset2 = offset2 >>> 0;
    if (!noAssert) checkOffset(offset2, 2, this.length);
    return this[offset2] | this[offset2 + 1] << 8;
  };
  Buffer2.prototype.readUint16BE = Buffer2.prototype.readUInt16BE = function readUInt16BE(offset2, noAssert) {
    offset2 = offset2 >>> 0;
    if (!noAssert) checkOffset(offset2, 2, this.length);
    return this[offset2] << 8 | this[offset2 + 1];
  };
  Buffer2.prototype.readUint32LE = Buffer2.prototype.readUInt32LE = function readUInt32LE(offset2, noAssert) {
    offset2 = offset2 >>> 0;
    if (!noAssert) checkOffset(offset2, 4, this.length);
    return (this[offset2] | this[offset2 + 1] << 8 | this[offset2 + 2] << 16) + this[offset2 + 3] * 16777216;
  };
  Buffer2.prototype.readUint32BE = Buffer2.prototype.readUInt32BE = function readUInt32BE(offset2, noAssert) {
    offset2 = offset2 >>> 0;
    if (!noAssert) checkOffset(offset2, 4, this.length);
    return this[offset2] * 16777216 + (this[offset2 + 1] << 16 | this[offset2 + 2] << 8 | this[offset2 + 3]);
  };
  Buffer2.prototype.readBigUInt64LE = defineBigIntMethod(function readBigUInt64LE(offset2) {
    offset2 = offset2 >>> 0;
    validateNumber(offset2, "offset");
    const first = this[offset2];
    const last = this[offset2 + 7];
    if (first === void 0 || last === void 0) {
      boundsError(offset2, this.length - 8);
    }
    const lo = first + this[++offset2] * 2 ** 8 + this[++offset2] * 2 ** 16 + this[++offset2] * 2 ** 24;
    const hi2 = this[++offset2] + this[++offset2] * 2 ** 8 + this[++offset2] * 2 ** 16 + last * 2 ** 24;
    return BigInt(lo) + (BigInt(hi2) << BigInt(32));
  });
  Buffer2.prototype.readBigUInt64BE = defineBigIntMethod(function readBigUInt64BE(offset2) {
    offset2 = offset2 >>> 0;
    validateNumber(offset2, "offset");
    const first = this[offset2];
    const last = this[offset2 + 7];
    if (first === void 0 || last === void 0) {
      boundsError(offset2, this.length - 8);
    }
    const hi2 = first * 2 ** 24 + this[++offset2] * 2 ** 16 + this[++offset2] * 2 ** 8 + this[++offset2];
    const lo = this[++offset2] * 2 ** 24 + this[++offset2] * 2 ** 16 + this[++offset2] * 2 ** 8 + last;
    return (BigInt(hi2) << BigInt(32)) + BigInt(lo);
  });
  Buffer2.prototype.readIntLE = function readIntLE(offset2, byteLength3, noAssert) {
    offset2 = offset2 >>> 0;
    byteLength3 = byteLength3 >>> 0;
    if (!noAssert) checkOffset(offset2, byteLength3, this.length);
    let val2 = this[offset2];
    let mul = 1;
    let i2 = 0;
    while (++i2 < byteLength3 && (mul *= 256)) {
      val2 += this[offset2 + i2] * mul;
    }
    mul *= 128;
    if (val2 >= mul) val2 -= Math.pow(2, 8 * byteLength3);
    return val2;
  };
  Buffer2.prototype.readIntBE = function readIntBE(offset2, byteLength3, noAssert) {
    offset2 = offset2 >>> 0;
    byteLength3 = byteLength3 >>> 0;
    if (!noAssert) checkOffset(offset2, byteLength3, this.length);
    let i2 = byteLength3;
    let mul = 1;
    let val2 = this[offset2 + --i2];
    while (i2 > 0 && (mul *= 256)) {
      val2 += this[offset2 + --i2] * mul;
    }
    mul *= 128;
    if (val2 >= mul) val2 -= Math.pow(2, 8 * byteLength3);
    return val2;
  };
  Buffer2.prototype.readInt8 = function readInt8(offset2, noAssert) {
    offset2 = offset2 >>> 0;
    if (!noAssert) checkOffset(offset2, 1, this.length);
    if (!(this[offset2] & 128)) return this[offset2];
    return (255 - this[offset2] + 1) * -1;
  };
  Buffer2.prototype.readInt16LE = function readInt16LE(offset2, noAssert) {
    offset2 = offset2 >>> 0;
    if (!noAssert) checkOffset(offset2, 2, this.length);
    const val2 = this[offset2] | this[offset2 + 1] << 8;
    return val2 & 32768 ? val2 | 4294901760 : val2;
  };
  Buffer2.prototype.readInt16BE = function readInt16BE(offset2, noAssert) {
    offset2 = offset2 >>> 0;
    if (!noAssert) checkOffset(offset2, 2, this.length);
    const val2 = this[offset2 + 1] | this[offset2] << 8;
    return val2 & 32768 ? val2 | 4294901760 : val2;
  };
  Buffer2.prototype.readInt32LE = function readInt32LE(offset2, noAssert) {
    offset2 = offset2 >>> 0;
    if (!noAssert) checkOffset(offset2, 4, this.length);
    return this[offset2] | this[offset2 + 1] << 8 | this[offset2 + 2] << 16 | this[offset2 + 3] << 24;
  };
  Buffer2.prototype.readInt32BE = function readInt32BE(offset2, noAssert) {
    offset2 = offset2 >>> 0;
    if (!noAssert) checkOffset(offset2, 4, this.length);
    return this[offset2] << 24 | this[offset2 + 1] << 16 | this[offset2 + 2] << 8 | this[offset2 + 3];
  };
  Buffer2.prototype.readBigInt64LE = defineBigIntMethod(function readBigInt64LE(offset2) {
    offset2 = offset2 >>> 0;
    validateNumber(offset2, "offset");
    const first = this[offset2];
    const last = this[offset2 + 7];
    if (first === void 0 || last === void 0) {
      boundsError(offset2, this.length - 8);
    }
    const val2 = this[offset2 + 4] + this[offset2 + 5] * 2 ** 8 + this[offset2 + 6] * 2 ** 16 + (last << 24);
    return (BigInt(val2) << BigInt(32)) + BigInt(first + this[++offset2] * 2 ** 8 + this[++offset2] * 2 ** 16 + this[++offset2] * 2 ** 24);
  });
  Buffer2.prototype.readBigInt64BE = defineBigIntMethod(function readBigInt64BE(offset2) {
    offset2 = offset2 >>> 0;
    validateNumber(offset2, "offset");
    const first = this[offset2];
    const last = this[offset2 + 7];
    if (first === void 0 || last === void 0) {
      boundsError(offset2, this.length - 8);
    }
    const val2 = (first << 24) + // Overflow
    this[++offset2] * 2 ** 16 + this[++offset2] * 2 ** 8 + this[++offset2];
    return (BigInt(val2) << BigInt(32)) + BigInt(this[++offset2] * 2 ** 24 + this[++offset2] * 2 ** 16 + this[++offset2] * 2 ** 8 + last);
  });
  Buffer2.prototype.readFloatLE = function readFloatLE(offset2, noAssert) {
    offset2 = offset2 >>> 0;
    if (!noAssert) checkOffset(offset2, 4, this.length);
    return ieee754$1.read(this, offset2, true, 23, 4);
  };
  Buffer2.prototype.readFloatBE = function readFloatBE(offset2, noAssert) {
    offset2 = offset2 >>> 0;
    if (!noAssert) checkOffset(offset2, 4, this.length);
    return ieee754$1.read(this, offset2, false, 23, 4);
  };
  Buffer2.prototype.readDoubleLE = function readDoubleLE(offset2, noAssert) {
    offset2 = offset2 >>> 0;
    if (!noAssert) checkOffset(offset2, 8, this.length);
    return ieee754$1.read(this, offset2, true, 52, 8);
  };
  Buffer2.prototype.readDoubleBE = function readDoubleBE(offset2, noAssert) {
    offset2 = offset2 >>> 0;
    if (!noAssert) checkOffset(offset2, 8, this.length);
    return ieee754$1.read(this, offset2, false, 52, 8);
  };
  function checkInt(buf, value3, offset2, ext, max2, min2) {
    if (!Buffer2.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance');
    if (value3 > max2 || value3 < min2) throw new RangeError('"value" argument is out of bounds');
    if (offset2 + ext > buf.length) throw new RangeError("Index out of range");
  }
  Buffer2.prototype.writeUintLE = Buffer2.prototype.writeUIntLE = function writeUIntLE(value3, offset2, byteLength3, noAssert) {
    value3 = +value3;
    offset2 = offset2 >>> 0;
    byteLength3 = byteLength3 >>> 0;
    if (!noAssert) {
      const maxBytes = Math.pow(2, 8 * byteLength3) - 1;
      checkInt(this, value3, offset2, byteLength3, maxBytes, 0);
    }
    let mul = 1;
    let i2 = 0;
    this[offset2] = value3 & 255;
    while (++i2 < byteLength3 && (mul *= 256)) {
      this[offset2 + i2] = value3 / mul & 255;
    }
    return offset2 + byteLength3;
  };
  Buffer2.prototype.writeUintBE = Buffer2.prototype.writeUIntBE = function writeUIntBE(value3, offset2, byteLength3, noAssert) {
    value3 = +value3;
    offset2 = offset2 >>> 0;
    byteLength3 = byteLength3 >>> 0;
    if (!noAssert) {
      const maxBytes = Math.pow(2, 8 * byteLength3) - 1;
      checkInt(this, value3, offset2, byteLength3, maxBytes, 0);
    }
    let i2 = byteLength3 - 1;
    let mul = 1;
    this[offset2 + i2] = value3 & 255;
    while (--i2 >= 0 && (mul *= 256)) {
      this[offset2 + i2] = value3 / mul & 255;
    }
    return offset2 + byteLength3;
  };
  Buffer2.prototype.writeUint8 = Buffer2.prototype.writeUInt8 = function writeUInt8(value3, offset2, noAssert) {
    value3 = +value3;
    offset2 = offset2 >>> 0;
    if (!noAssert) checkInt(this, value3, offset2, 1, 255, 0);
    this[offset2] = value3 & 255;
    return offset2 + 1;
  };
  Buffer2.prototype.writeUint16LE = Buffer2.prototype.writeUInt16LE = function writeUInt16LE(value3, offset2, noAssert) {
    value3 = +value3;
    offset2 = offset2 >>> 0;
    if (!noAssert) checkInt(this, value3, offset2, 2, 65535, 0);
    this[offset2] = value3 & 255;
    this[offset2 + 1] = value3 >>> 8;
    return offset2 + 2;
  };
  Buffer2.prototype.writeUint16BE = Buffer2.prototype.writeUInt16BE = function writeUInt16BE(value3, offset2, noAssert) {
    value3 = +value3;
    offset2 = offset2 >>> 0;
    if (!noAssert) checkInt(this, value3, offset2, 2, 65535, 0);
    this[offset2] = value3 >>> 8;
    this[offset2 + 1] = value3 & 255;
    return offset2 + 2;
  };
  Buffer2.prototype.writeUint32LE = Buffer2.prototype.writeUInt32LE = function writeUInt32LE(value3, offset2, noAssert) {
    value3 = +value3;
    offset2 = offset2 >>> 0;
    if (!noAssert) checkInt(this, value3, offset2, 4, 4294967295, 0);
    this[offset2 + 3] = value3 >>> 24;
    this[offset2 + 2] = value3 >>> 16;
    this[offset2 + 1] = value3 >>> 8;
    this[offset2] = value3 & 255;
    return offset2 + 4;
  };
  Buffer2.prototype.writeUint32BE = Buffer2.prototype.writeUInt32BE = function writeUInt32BE(value3, offset2, noAssert) {
    value3 = +value3;
    offset2 = offset2 >>> 0;
    if (!noAssert) checkInt(this, value3, offset2, 4, 4294967295, 0);
    this[offset2] = value3 >>> 24;
    this[offset2 + 1] = value3 >>> 16;
    this[offset2 + 2] = value3 >>> 8;
    this[offset2 + 3] = value3 & 255;
    return offset2 + 4;
  };
  function wrtBigUInt64LE(buf, value3, offset2, min2, max2) {
    checkIntBI(value3, min2, max2, buf, offset2, 7);
    let lo = Number(value3 & BigInt(4294967295));
    buf[offset2++] = lo;
    lo = lo >> 8;
    buf[offset2++] = lo;
    lo = lo >> 8;
    buf[offset2++] = lo;
    lo = lo >> 8;
    buf[offset2++] = lo;
    let hi2 = Number(value3 >> BigInt(32) & BigInt(4294967295));
    buf[offset2++] = hi2;
    hi2 = hi2 >> 8;
    buf[offset2++] = hi2;
    hi2 = hi2 >> 8;
    buf[offset2++] = hi2;
    hi2 = hi2 >> 8;
    buf[offset2++] = hi2;
    return offset2;
  }
  function wrtBigUInt64BE(buf, value3, offset2, min2, max2) {
    checkIntBI(value3, min2, max2, buf, offset2, 7);
    let lo = Number(value3 & BigInt(4294967295));
    buf[offset2 + 7] = lo;
    lo = lo >> 8;
    buf[offset2 + 6] = lo;
    lo = lo >> 8;
    buf[offset2 + 5] = lo;
    lo = lo >> 8;
    buf[offset2 + 4] = lo;
    let hi2 = Number(value3 >> BigInt(32) & BigInt(4294967295));
    buf[offset2 + 3] = hi2;
    hi2 = hi2 >> 8;
    buf[offset2 + 2] = hi2;
    hi2 = hi2 >> 8;
    buf[offset2 + 1] = hi2;
    hi2 = hi2 >> 8;
    buf[offset2] = hi2;
    return offset2 + 8;
  }
  Buffer2.prototype.writeBigUInt64LE = defineBigIntMethod(function writeBigUInt64LE(value3, offset2 = 0) {
    return wrtBigUInt64LE(this, value3, offset2, BigInt(0), BigInt("0xffffffffffffffff"));
  });
  Buffer2.prototype.writeBigUInt64BE = defineBigIntMethod(function writeBigUInt64BE(value3, offset2 = 0) {
    return wrtBigUInt64BE(this, value3, offset2, BigInt(0), BigInt("0xffffffffffffffff"));
  });
  Buffer2.prototype.writeIntLE = function writeIntLE(value3, offset2, byteLength3, noAssert) {
    value3 = +value3;
    offset2 = offset2 >>> 0;
    if (!noAssert) {
      const limit = Math.pow(2, 8 * byteLength3 - 1);
      checkInt(this, value3, offset2, byteLength3, limit - 1, -limit);
    }
    let i2 = 0;
    let mul = 1;
    let sub = 0;
    this[offset2] = value3 & 255;
    while (++i2 < byteLength3 && (mul *= 256)) {
      if (value3 < 0 && sub === 0 && this[offset2 + i2 - 1] !== 0) {
        sub = 1;
      }
      this[offset2 + i2] = (value3 / mul >> 0) - sub & 255;
    }
    return offset2 + byteLength3;
  };
  Buffer2.prototype.writeIntBE = function writeIntBE(value3, offset2, byteLength3, noAssert) {
    value3 = +value3;
    offset2 = offset2 >>> 0;
    if (!noAssert) {
      const limit = Math.pow(2, 8 * byteLength3 - 1);
      checkInt(this, value3, offset2, byteLength3, limit - 1, -limit);
    }
    let i2 = byteLength3 - 1;
    let mul = 1;
    let sub = 0;
    this[offset2 + i2] = value3 & 255;
    while (--i2 >= 0 && (mul *= 256)) {
      if (value3 < 0 && sub === 0 && this[offset2 + i2 + 1] !== 0) {
        sub = 1;
      }
      this[offset2 + i2] = (value3 / mul >> 0) - sub & 255;
    }
    return offset2 + byteLength3;
  };
  Buffer2.prototype.writeInt8 = function writeInt8(value3, offset2, noAssert) {
    value3 = +value3;
    offset2 = offset2 >>> 0;
    if (!noAssert) checkInt(this, value3, offset2, 1, 127, -128);
    if (value3 < 0) value3 = 255 + value3 + 1;
    this[offset2] = value3 & 255;
    return offset2 + 1;
  };
  Buffer2.prototype.writeInt16LE = function writeInt16LE(value3, offset2, noAssert) {
    value3 = +value3;
    offset2 = offset2 >>> 0;
    if (!noAssert) checkInt(this, value3, offset2, 2, 32767, -32768);
    this[offset2] = value3 & 255;
    this[offset2 + 1] = value3 >>> 8;
    return offset2 + 2;
  };
  Buffer2.prototype.writeInt16BE = function writeInt16BE(value3, offset2, noAssert) {
    value3 = +value3;
    offset2 = offset2 >>> 0;
    if (!noAssert) checkInt(this, value3, offset2, 2, 32767, -32768);
    this[offset2] = value3 >>> 8;
    this[offset2 + 1] = value3 & 255;
    return offset2 + 2;
  };
  Buffer2.prototype.writeInt32LE = function writeInt32LE(value3, offset2, noAssert) {
    value3 = +value3;
    offset2 = offset2 >>> 0;
    if (!noAssert) checkInt(this, value3, offset2, 4, 2147483647, -2147483648);
    this[offset2] = value3 & 255;
    this[offset2 + 1] = value3 >>> 8;
    this[offset2 + 2] = value3 >>> 16;
    this[offset2 + 3] = value3 >>> 24;
    return offset2 + 4;
  };
  Buffer2.prototype.writeInt32BE = function writeInt32BE(value3, offset2, noAssert) {
    value3 = +value3;
    offset2 = offset2 >>> 0;
    if (!noAssert) checkInt(this, value3, offset2, 4, 2147483647, -2147483648);
    if (value3 < 0) value3 = 4294967295 + value3 + 1;
    this[offset2] = value3 >>> 24;
    this[offset2 + 1] = value3 >>> 16;
    this[offset2 + 2] = value3 >>> 8;
    this[offset2 + 3] = value3 & 255;
    return offset2 + 4;
  };
  Buffer2.prototype.writeBigInt64LE = defineBigIntMethod(function writeBigInt64LE(value3, offset2 = 0) {
    return wrtBigUInt64LE(this, value3, offset2, -BigInt("0x8000000000000000"), BigInt("0x7fffffffffffffff"));
  });
  Buffer2.prototype.writeBigInt64BE = defineBigIntMethod(function writeBigInt64BE(value3, offset2 = 0) {
    return wrtBigUInt64BE(this, value3, offset2, -BigInt("0x8000000000000000"), BigInt("0x7fffffffffffffff"));
  });
  function checkIEEE754(buf, value3, offset2, ext, max2, min2) {
    if (offset2 + ext > buf.length) throw new RangeError("Index out of range");
    if (offset2 < 0) throw new RangeError("Index out of range");
  }
  function writeFloat(buf, value3, offset2, littleEndian, noAssert) {
    value3 = +value3;
    offset2 = offset2 >>> 0;
    if (!noAssert) {
      checkIEEE754(buf, value3, offset2, 4);
    }
    ieee754$1.write(buf, value3, offset2, littleEndian, 23, 4);
    return offset2 + 4;
  }
  Buffer2.prototype.writeFloatLE = function writeFloatLE(value3, offset2, noAssert) {
    return writeFloat(this, value3, offset2, true, noAssert);
  };
  Buffer2.prototype.writeFloatBE = function writeFloatBE(value3, offset2, noAssert) {
    return writeFloat(this, value3, offset2, false, noAssert);
  };
  function writeDouble(buf, value3, offset2, littleEndian, noAssert) {
    value3 = +value3;
    offset2 = offset2 >>> 0;
    if (!noAssert) {
      checkIEEE754(buf, value3, offset2, 8);
    }
    ieee754$1.write(buf, value3, offset2, littleEndian, 52, 8);
    return offset2 + 8;
  }
  Buffer2.prototype.writeDoubleLE = function writeDoubleLE(value3, offset2, noAssert) {
    return writeDouble(this, value3, offset2, true, noAssert);
  };
  Buffer2.prototype.writeDoubleBE = function writeDoubleBE(value3, offset2, noAssert) {
    return writeDouble(this, value3, offset2, false, noAssert);
  };
  Buffer2.prototype.copy = function copy(target2, targetStart, start, end) {
    if (!Buffer2.isBuffer(target2)) throw new TypeError("argument should be a Buffer");
    if (!start) start = 0;
    if (!end && end !== 0) end = this.length;
    if (targetStart >= target2.length) targetStart = target2.length;
    if (!targetStart) targetStart = 0;
    if (end > 0 && end < start) end = start;
    if (end === start) return 0;
    if (target2.length === 0 || this.length === 0) return 0;
    if (targetStart < 0) {
      throw new RangeError("targetStart out of bounds");
    }
    if (start < 0 || start >= this.length) throw new RangeError("Index out of range");
    if (end < 0) throw new RangeError("sourceEnd out of bounds");
    if (end > this.length) end = this.length;
    if (target2.length - targetStart < end - start) {
      end = target2.length - targetStart + start;
    }
    const len = end - start;
    if (this === target2 && typeof GlobalUint8Array.prototype.copyWithin === "function") {
      this.copyWithin(targetStart, start, end);
    } else {
      GlobalUint8Array.prototype.set.call(
        target2,
        this.subarray(start, end),
        targetStart
      );
    }
    return len;
  };
  Buffer2.prototype.fill = function fill(val2, start, end, encoding) {
    if (typeof val2 === "string") {
      if (typeof start === "string") {
        encoding = start;
        start = 0;
        end = this.length;
      } else if (typeof end === "string") {
        encoding = end;
        end = this.length;
      }
      if (encoding !== void 0 && typeof encoding !== "string") {
        throw new TypeError("encoding must be a string");
      }
      if (typeof encoding === "string" && !Buffer2.isEncoding(encoding)) {
        throw new TypeError("Unknown encoding: " + encoding);
      }
      if (val2.length === 1) {
        const code2 = val2.charCodeAt(0);
        if (encoding === "utf8" && code2 < 128 || encoding === "latin1") {
          val2 = code2;
        }
      }
    } else if (typeof val2 === "number") {
      val2 = val2 & 255;
    } else if (typeof val2 === "boolean") {
      val2 = Number(val2);
    }
    if (start < 0 || this.length < start || this.length < end) {
      throw new RangeError("Out of range index");
    }
    if (end <= start) {
      return this;
    }
    start = start >>> 0;
    end = end === void 0 ? this.length : end >>> 0;
    if (!val2) val2 = 0;
    let i2;
    if (typeof val2 === "number") {
      for (i2 = start; i2 < end; ++i2) {
        this[i2] = val2;
      }
    } else {
      const bytes = Buffer2.isBuffer(val2) ? val2 : Buffer2.from(val2, encoding);
      const len = bytes.length;
      if (len === 0) {
        throw new TypeError('The value "' + val2 + '" is invalid for argument "value"');
      }
      for (i2 = 0; i2 < end - start; ++i2) {
        this[i2 + start] = bytes[i2 % len];
      }
    }
    return this;
  };
  const errors = {};
  function E2(sym, getMessage, Base) {
    errors[sym] = class NodeError extends Base {
      constructor() {
        super();
        Object.defineProperty(this, "message", {
          value: getMessage.apply(this, arguments),
          writable: true,
          configurable: true
        });
        this.name = `${this.name} [${sym}]`;
        this.stack;
        delete this.name;
      }
      get code() {
        return sym;
      }
      set code(value3) {
        Object.defineProperty(this, "code", {
          configurable: true,
          enumerable: true,
          value: value3,
          writable: true
        });
      }
      toString() {
        return `${this.name} [${sym}]: ${this.message}`;
      }
    };
  }
  E2(
    "ERR_BUFFER_OUT_OF_BOUNDS",
    function(name) {
      if (name) {
        return `${name} is outside of buffer bounds`;
      }
      return "Attempt to access memory outside buffer bounds";
    },
    RangeError
  );
  E2(
    "ERR_INVALID_ARG_TYPE",
    function(name, actual) {
      return `The "${name}" argument must be of type number. Received type ${typeof actual}`;
    },
    TypeError
  );
  E2(
    "ERR_OUT_OF_RANGE",
    function(str, range, input) {
      let msg = `The value of "${str}" is out of range.`;
      let received = input;
      if (Number.isInteger(input) && Math.abs(input) > 2 ** 32) {
        received = addNumericalSeparator(String(input));
      } else if (typeof input === "bigint") {
        received = String(input);
        if (input > BigInt(2) ** BigInt(32) || input < -(BigInt(2) ** BigInt(32))) {
          received = addNumericalSeparator(received);
        }
        received += "n";
      }
      msg += ` It must be ${range}. Received ${received}`;
      return msg;
    },
    RangeError
  );
  function addNumericalSeparator(val2) {
    let res = "";
    let i2 = val2.length;
    const start = val2[0] === "-" ? 1 : 0;
    for (; i2 >= start + 4; i2 -= 3) {
      res = `_${val2.slice(i2 - 3, i2)}${res}`;
    }
    return `${val2.slice(0, i2)}${res}`;
  }
  function checkBounds(buf, offset2, byteLength3) {
    validateNumber(offset2, "offset");
    if (buf[offset2] === void 0 || buf[offset2 + byteLength3] === void 0) {
      boundsError(offset2, buf.length - (byteLength3 + 1));
    }
  }
  function checkIntBI(value3, min2, max2, buf, offset2, byteLength3) {
    if (value3 > max2 || value3 < min2) {
      const n2 = typeof min2 === "bigint" ? "n" : "";
      let range;
      {
        if (min2 === 0 || min2 === BigInt(0)) {
          range = `>= 0${n2} and < 2${n2} ** ${(byteLength3 + 1) * 8}${n2}`;
        } else {
          range = `>= -(2${n2} ** ${(byteLength3 + 1) * 8 - 1}${n2}) and < 2 ** ${(byteLength3 + 1) * 8 - 1}${n2}`;
        }
      }
      throw new errors.ERR_OUT_OF_RANGE("value", range, value3);
    }
    checkBounds(buf, offset2, byteLength3);
  }
  function validateNumber(value3, name) {
    if (typeof value3 !== "number") {
      throw new errors.ERR_INVALID_ARG_TYPE(name, "number", value3);
    }
  }
  function boundsError(value3, length, type) {
    if (Math.floor(value3) !== value3) {
      validateNumber(value3, type);
      throw new errors.ERR_OUT_OF_RANGE("offset", "an integer", value3);
    }
    if (length < 0) {
      throw new errors.ERR_BUFFER_OUT_OF_BOUNDS();
    }
    throw new errors.ERR_OUT_OF_RANGE(
      "offset",
      `>= ${0} and <= ${length}`,
      value3
    );
  }
  const INVALID_BASE64_RE = /[^+/0-9A-Za-z-_]/g;
  function base64clean(str) {
    str = str.split("=")[0];
    str = str.trim().replace(INVALID_BASE64_RE, "");
    if (str.length < 2) return "";
    while (str.length % 4 !== 0) {
      str = str + "=";
    }
    return str;
  }
  function utf8ToBytes(string, units) {
    units = units || Infinity;
    let codePoint;
    const length = string.length;
    let leadSurrogate = null;
    const bytes = [];
    for (let i2 = 0; i2 < length; ++i2) {
      codePoint = string.charCodeAt(i2);
      if (codePoint > 55295 && codePoint < 57344) {
        if (!leadSurrogate) {
          if (codePoint > 56319) {
            if ((units -= 3) > -1) bytes.push(239, 191, 189);
            continue;
          } else if (i2 + 1 === length) {
            if ((units -= 3) > -1) bytes.push(239, 191, 189);
            continue;
          }
          leadSurrogate = codePoint;
          continue;
        }
        if (codePoint < 56320) {
          if ((units -= 3) > -1) bytes.push(239, 191, 189);
          leadSurrogate = codePoint;
          continue;
        }
        codePoint = (leadSurrogate - 55296 << 10 | codePoint - 56320) + 65536;
      } else if (leadSurrogate) {
        if ((units -= 3) > -1) bytes.push(239, 191, 189);
      }
      leadSurrogate = null;
      if (codePoint < 128) {
        if ((units -= 1) < 0) break;
        bytes.push(codePoint);
      } else if (codePoint < 2048) {
        if ((units -= 2) < 0) break;
        bytes.push(
          codePoint >> 6 | 192,
          codePoint & 63 | 128
        );
      } else if (codePoint < 65536) {
        if ((units -= 3) < 0) break;
        bytes.push(
          codePoint >> 12 | 224,
          codePoint >> 6 & 63 | 128,
          codePoint & 63 | 128
        );
      } else if (codePoint < 1114112) {
        if ((units -= 4) < 0) break;
        bytes.push(
          codePoint >> 18 | 240,
          codePoint >> 12 & 63 | 128,
          codePoint >> 6 & 63 | 128,
          codePoint & 63 | 128
        );
      } else {
        throw new Error("Invalid code point");
      }
    }
    return bytes;
  }
  function asciiToBytes(str) {
    const byteArray = [];
    for (let i2 = 0; i2 < str.length; ++i2) {
      byteArray.push(str.charCodeAt(i2) & 255);
    }
    return byteArray;
  }
  function utf16leToBytes(str, units) {
    let c2, hi2, lo;
    const byteArray = [];
    for (let i2 = 0; i2 < str.length; ++i2) {
      if ((units -= 2) < 0) break;
      c2 = str.charCodeAt(i2);
      hi2 = c2 >> 8;
      lo = c2 % 256;
      byteArray.push(lo);
      byteArray.push(hi2);
    }
    return byteArray;
  }
  function base64ToBytes(str) {
    return base64.toByteArray(base64clean(str));
  }
  function blitBuffer(src, dst, offset2, length) {
    let i2;
    for (i2 = 0; i2 < length; ++i2) {
      if (i2 + offset2 >= dst.length || i2 >= src.length) break;
      dst[i2 + offset2] = src[i2];
    }
    return i2;
  }
  function isInstance(obj, type) {
    return obj instanceof type || obj != null && obj.constructor != null && obj.constructor.name != null && obj.constructor.name === type.name;
  }
  function numberIsNaN(obj) {
    return obj !== obj;
  }
  const hexSliceLookupTable = function() {
    const alphabet = "0123456789abcdef";
    const table = new Array(256);
    for (let i2 = 0; i2 < 16; ++i2) {
      const i16 = i2 * 16;
      for (let j2 = 0; j2 < 16; ++j2) {
        table[i16 + j2] = alphabet[i2] + alphabet[j2];
      }
    }
    return table;
  }();
  function defineBigIntMethod(fn) {
    return typeof BigInt === "undefined" ? BufferBigIntNotDefined : fn;
  }
  function BufferBigIntNotDefined() {
    throw new Error("BigInt not supported");
  }
})(buffer);
const Buffer = buffer.Buffer;
function AxiosError(message, code2, config2, request, response) {
  Error.call(this);
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, this.constructor);
  } else {
    this.stack = new Error().stack;
  }
  this.message = message;
  this.name = "AxiosError";
  code2 && (this.code = code2);
  config2 && (this.config = config2);
  request && (this.request = request);
  if (response) {
    this.response = response;
    this.status = response.status ? response.status : null;
  }
}
utils$1.inherits(AxiosError, Error, {
  toJSON: function toJSON() {
    return {
      // Standard
      message: this.message,
      name: this.name,
      // Microsoft
      description: this.description,
      number: this.number,
      // Mozilla
      fileName: this.fileName,
      lineNumber: this.lineNumber,
      columnNumber: this.columnNumber,
      stack: this.stack,
      // Axios
      config: utils$1.toJSONObject(this.config),
      code: this.code,
      status: this.status
    };
  }
});
const prototype$1 = AxiosError.prototype;
const descriptors$1 = {};
[
  "ERR_BAD_OPTION_VALUE",
  "ERR_BAD_OPTION",
  "ECONNABORTED",
  "ETIMEDOUT",
  "ERR_NETWORK",
  "ERR_FR_TOO_MANY_REDIRECTS",
  "ERR_DEPRECATED",
  "ERR_BAD_RESPONSE",
  "ERR_BAD_REQUEST",
  "ERR_CANCELED",
  "ERR_NOT_SUPPORT",
  "ERR_INVALID_URL"
  // eslint-disable-next-line func-names
].forEach((code2) => {
  descriptors$1[code2] = { value: code2 };
});
Object.defineProperties(AxiosError, descriptors$1);
Object.defineProperty(prototype$1, "isAxiosError", { value: true });
AxiosError.from = (error, code2, config2, request, response, customProps) => {
  const axiosError = Object.create(prototype$1);
  utils$1.toFlatObject(error, axiosError, function filter2(obj) {
    return obj !== Error.prototype;
  }, (prop) => {
    return prop !== "isAxiosError";
  });
  AxiosError.call(axiosError, error.message, code2, config2, request, response);
  axiosError.cause = error;
  axiosError.name = error.name;
  customProps && Object.assign(axiosError, customProps);
  return axiosError;
};
const httpAdapter = null;
function isVisitable(thing) {
  return utils$1.isPlainObject(thing) || utils$1.isArray(thing);
}
function removeBrackets(key) {
  return utils$1.endsWith(key, "[]") ? key.slice(0, -2) : key;
}
function renderKey(path2, key, dots) {
  if (!path2) return key;
  return path2.concat(key).map(function each(token2, i2) {
    token2 = removeBrackets(token2);
    return !dots && i2 ? "[" + token2 + "]" : token2;
  }).join(dots ? "." : "");
}
function isFlatArray(arr) {
  return utils$1.isArray(arr) && !arr.some(isVisitable);
}
const predicates = utils$1.toFlatObject(utils$1, {}, null, function filter(prop) {
  return /^is[A-Z]/.test(prop);
});
function toFormData(obj, formData, options2) {
  if (!utils$1.isObject(obj)) {
    throw new TypeError("target must be an object");
  }
  formData = formData || new FormData();
  options2 = utils$1.toFlatObject(options2, {
    metaTokens: true,
    dots: false,
    indexes: false
  }, false, function defined(option, source) {
    return !utils$1.isUndefined(source[option]);
  });
  const metaTokens = options2.metaTokens;
  const visitor = options2.visitor || defaultVisitor;
  const dots = options2.dots;
  const indexes = options2.indexes;
  const _Blob = options2.Blob || typeof Blob !== "undefined" && Blob;
  const useBlob = _Blob && utils$1.isSpecCompliantForm(formData);
  if (!utils$1.isFunction(visitor)) {
    throw new TypeError("visitor must be a function");
  }
  function convertValue(value3) {
    if (value3 === null) return "";
    if (utils$1.isDate(value3)) {
      return value3.toISOString();
    }
    if (!useBlob && utils$1.isBlob(value3)) {
      throw new AxiosError("Blob is not supported. Use a Buffer instead.");
    }
    if (utils$1.isArrayBuffer(value3) || utils$1.isTypedArray(value3)) {
      return useBlob && typeof Blob === "function" ? new Blob([value3]) : Buffer.from(value3);
    }
    return value3;
  }
  function defaultVisitor(value3, key, path2) {
    let arr = value3;
    if (value3 && !path2 && typeof value3 === "object") {
      if (utils$1.endsWith(key, "{}")) {
        key = metaTokens ? key : key.slice(0, -2);
        value3 = JSON.stringify(value3);
      } else if (utils$1.isArray(value3) && isFlatArray(value3) || (utils$1.isFileList(value3) || utils$1.endsWith(key, "[]")) && (arr = utils$1.toArray(value3))) {
        key = removeBrackets(key);
        arr.forEach(function each(el, index2) {
          !(utils$1.isUndefined(el) || el === null) && formData.append(
            // eslint-disable-next-line no-nested-ternary
            indexes === true ? renderKey([key], index2, dots) : indexes === null ? key : key + "[]",
            convertValue(el)
          );
        });
        return false;
      }
    }
    if (isVisitable(value3)) {
      return true;
    }
    formData.append(renderKey(path2, key, dots), convertValue(value3));
    return false;
  }
  const stack = [];
  const exposedHelpers = Object.assign(predicates, {
    defaultVisitor,
    convertValue,
    isVisitable
  });
  function build(value3, path2) {
    if (utils$1.isUndefined(value3)) return;
    if (stack.indexOf(value3) !== -1) {
      throw Error("Circular reference detected in " + path2.join("."));
    }
    stack.push(value3);
    utils$1.forEach(value3, function each(el, key) {
      const result = !(utils$1.isUndefined(el) || el === null) && visitor.call(
        formData,
        el,
        utils$1.isString(key) ? key.trim() : key,
        path2,
        exposedHelpers
      );
      if (result === true) {
        build(el, path2 ? path2.concat(key) : [key]);
      }
    });
    stack.pop();
  }
  if (!utils$1.isObject(obj)) {
    throw new TypeError("data must be an object");
  }
  build(obj);
  return formData;
}
function encode$2(str) {
  const charMap = {
    "!": "%21",
    "'": "%27",
    "(": "%28",
    ")": "%29",
    "~": "%7E",
    "%20": "+",
    "%00": "\0"
  };
  return encodeURIComponent(str).replace(/[!'()~]|%20|%00/g, function replacer2(match6) {
    return charMap[match6];
  });
}
function AxiosURLSearchParams(params, options2) {
  this._pairs = [];
  params && toFormData(params, this, options2);
}
const prototype = AxiosURLSearchParams.prototype;
prototype.append = function append(name, value3) {
  this._pairs.push([name, value3]);
};
prototype.toString = function toString(encoder) {
  const _encode = encoder ? function(value3) {
    return encoder.call(this, value3, encode$2);
  } : encode$2;
  return this._pairs.map(function each(pair) {
    return _encode(pair[0]) + "=" + _encode(pair[1]);
  }, "").join("&");
};
function encode$1(val2) {
  return encodeURIComponent(val2).replace(/%3A/gi, ":").replace(/%24/g, "$").replace(/%2C/gi, ",").replace(/%20/g, "+").replace(/%5B/gi, "[").replace(/%5D/gi, "]");
}
function buildURL(url, params, options2) {
  if (!params) {
    return url;
  }
  const _encode = options2 && options2.encode || encode$1;
  const serializeFn = options2 && options2.serialize;
  let serializedParams;
  if (serializeFn) {
    serializedParams = serializeFn(params, options2);
  } else {
    serializedParams = utils$1.isURLSearchParams(params) ? params.toString() : new AxiosURLSearchParams(params, options2).toString(_encode);
  }
  if (serializedParams) {
    const hashmarkIndex = url.indexOf("#");
    if (hashmarkIndex !== -1) {
      url = url.slice(0, hashmarkIndex);
    }
    url += (url.indexOf("?") === -1 ? "?" : "&") + serializedParams;
  }
  return url;
}
class InterceptorManager {
  constructor() {
    this.handlers = [];
  }
  /**
   * Add a new interceptor to the stack
   *
   * @param {Function} fulfilled The function to handle `then` for a `Promise`
   * @param {Function} rejected The function to handle `reject` for a `Promise`
   *
   * @return {Number} An ID used to remove interceptor later
   */
  use(fulfilled, rejected, options2) {
    this.handlers.push({
      fulfilled,
      rejected,
      synchronous: options2 ? options2.synchronous : false,
      runWhen: options2 ? options2.runWhen : null
    });
    return this.handlers.length - 1;
  }
  /**
   * Remove an interceptor from the stack
   *
   * @param {Number} id The ID that was returned by `use`
   *
   * @returns {Boolean} `true` if the interceptor was removed, `false` otherwise
   */
  eject(id2) {
    if (this.handlers[id2]) {
      this.handlers[id2] = null;
    }
  }
  /**
   * Clear all interceptors from the stack
   *
   * @returns {void}
   */
  clear() {
    if (this.handlers) {
      this.handlers = [];
    }
  }
  /**
   * Iterate over all the registered interceptors
   *
   * This method is particularly useful for skipping over any
   * interceptors that may have become `null` calling `eject`.
   *
   * @param {Function} fn The function to call for each interceptor
   *
   * @returns {void}
   */
  forEach(fn) {
    utils$1.forEach(this.handlers, function forEachHandler(h3) {
      if (h3 !== null) {
        fn(h3);
      }
    });
  }
}
const transitionalDefaults = {
  silentJSONParsing: true,
  forcedJSONParsing: true,
  clarifyTimeoutError: false
};
const URLSearchParams$1 = typeof URLSearchParams !== "undefined" ? URLSearchParams : AxiosURLSearchParams;
const FormData$1 = typeof FormData !== "undefined" ? FormData : null;
const Blob$1 = typeof Blob !== "undefined" ? Blob : null;
const platform$3 = {
  isBrowser: true,
  classes: {
    URLSearchParams: URLSearchParams$1,
    FormData: FormData$1,
    Blob: Blob$1
  },
  protocols: ["http", "https", "file", "blob", "url", "data"]
};
const hasBrowserEnv = typeof window !== "undefined" && typeof document !== "undefined";
const _navigator = typeof navigator === "object" && navigator || void 0;
const hasStandardBrowserEnv = hasBrowserEnv && (!_navigator || ["ReactNative", "NativeScript", "NS"].indexOf(_navigator.product) < 0);
const hasStandardBrowserWebWorkerEnv = (() => {
  return typeof WorkerGlobalScope !== "undefined" && // eslint-disable-next-line no-undef
  self instanceof WorkerGlobalScope && typeof self.importScripts === "function";
})();
const origin = hasBrowserEnv && window.location.href || "http://localhost";
const utils = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  hasBrowserEnv,
  hasStandardBrowserEnv,
  hasStandardBrowserWebWorkerEnv,
  navigator: _navigator,
  origin
}, Symbol.toStringTag, { value: "Module" }));
const platform$2 = {
  ...utils,
  ...platform$3
};
function toURLEncodedForm(data12, options2) {
  return toFormData(data12, new platform$2.classes.URLSearchParams(), Object.assign({
    visitor: function(value3, key, path2, helpers) {
      if (platform$2.isNode && utils$1.isBuffer(value3)) {
        this.append(key, value3.toString("base64"));
        return false;
      }
      return helpers.defaultVisitor.apply(this, arguments);
    }
  }, options2));
}
function parsePropPath(name) {
  return utils$1.matchAll(/\w+|\[(\w*)]/g, name).map((match6) => {
    return match6[0] === "[]" ? "" : match6[1] || match6[0];
  });
}
function arrayToObject(arr) {
  const obj = {};
  const keys3 = Object.keys(arr);
  let i2;
  const len = keys3.length;
  let key;
  for (i2 = 0; i2 < len; i2++) {
    key = keys3[i2];
    obj[key] = arr[key];
  }
  return obj;
}
function formDataToJSON(formData) {
  function buildPath(path2, value3, target2, index2) {
    let name = path2[index2++];
    if (name === "__proto__") return true;
    const isNumericKey = Number.isFinite(+name);
    const isLast = index2 >= path2.length;
    name = !name && utils$1.isArray(target2) ? target2.length : name;
    if (isLast) {
      if (utils$1.hasOwnProp(target2, name)) {
        target2[name] = [target2[name], value3];
      } else {
        target2[name] = value3;
      }
      return !isNumericKey;
    }
    if (!target2[name] || !utils$1.isObject(target2[name])) {
      target2[name] = [];
    }
    const result = buildPath(path2, value3, target2[name], index2);
    if (result && utils$1.isArray(target2[name])) {
      target2[name] = arrayToObject(target2[name]);
    }
    return !isNumericKey;
  }
  if (utils$1.isFormData(formData) && utils$1.isFunction(formData.entries)) {
    const obj = {};
    utils$1.forEachEntry(formData, (name, value3) => {
      buildPath(parsePropPath(name), value3, obj, 0);
    });
    return obj;
  }
  return null;
}
function stringifySafely(rawValue, parser, encoder) {
  if (utils$1.isString(rawValue)) {
    try {
      (parser || JSON.parse)(rawValue);
      return utils$1.trim(rawValue);
    } catch (e2) {
      if (e2.name !== "SyntaxError") {
        throw e2;
      }
    }
  }
  return (encoder || JSON.stringify)(rawValue);
}
const defaults$1 = {
  transitional: transitionalDefaults,
  adapter: ["xhr", "http", "fetch"],
  transformRequest: [function transformRequest(data12, headers) {
    const contentType = headers.getContentType() || "";
    const hasJSONContentType = contentType.indexOf("application/json") > -1;
    const isObjectPayload = utils$1.isObject(data12);
    if (isObjectPayload && utils$1.isHTMLForm(data12)) {
      data12 = new FormData(data12);
    }
    const isFormData2 = utils$1.isFormData(data12);
    if (isFormData2) {
      return hasJSONContentType ? JSON.stringify(formDataToJSON(data12)) : data12;
    }
    if (utils$1.isArrayBuffer(data12) || utils$1.isBuffer(data12) || utils$1.isStream(data12) || utils$1.isFile(data12) || utils$1.isBlob(data12) || utils$1.isReadableStream(data12)) {
      return data12;
    }
    if (utils$1.isArrayBufferView(data12)) {
      return data12.buffer;
    }
    if (utils$1.isURLSearchParams(data12)) {
      headers.setContentType("application/x-www-form-urlencoded;charset=utf-8", false);
      return data12.toString();
    }
    let isFileList2;
    if (isObjectPayload) {
      if (contentType.indexOf("application/x-www-form-urlencoded") > -1) {
        return toURLEncodedForm(data12, this.formSerializer).toString();
      }
      if ((isFileList2 = utils$1.isFileList(data12)) || contentType.indexOf("multipart/form-data") > -1) {
        const _FormData = this.env && this.env.FormData;
        return toFormData(
          isFileList2 ? { "files[]": data12 } : data12,
          _FormData && new _FormData(),
          this.formSerializer
        );
      }
    }
    if (isObjectPayload || hasJSONContentType) {
      headers.setContentType("application/json", false);
      return stringifySafely(data12);
    }
    return data12;
  }],
  transformResponse: [function transformResponse(data12) {
    const transitional2 = this.transitional || defaults$1.transitional;
    const forcedJSONParsing = transitional2 && transitional2.forcedJSONParsing;
    const JSONRequested = this.responseType === "json";
    if (utils$1.isResponse(data12) || utils$1.isReadableStream(data12)) {
      return data12;
    }
    if (data12 && utils$1.isString(data12) && (forcedJSONParsing && !this.responseType || JSONRequested)) {
      const silentJSONParsing = transitional2 && transitional2.silentJSONParsing;
      const strictJSONParsing = !silentJSONParsing && JSONRequested;
      try {
        return JSON.parse(data12);
      } catch (e2) {
        if (strictJSONParsing) {
          if (e2.name === "SyntaxError") {
            throw AxiosError.from(e2, AxiosError.ERR_BAD_RESPONSE, this, null, this.response);
          }
          throw e2;
        }
      }
    }
    return data12;
  }],
  /**
   * A timeout in milliseconds to abort a request. If set to 0 (default) a
   * timeout is not created.
   */
  timeout: 0,
  xsrfCookieName: "XSRF-TOKEN",
  xsrfHeaderName: "X-XSRF-TOKEN",
  maxContentLength: -1,
  maxBodyLength: -1,
  env: {
    FormData: platform$2.classes.FormData,
    Blob: platform$2.classes.Blob
  },
  validateStatus: function validateStatus(status) {
    return status >= 200 && status < 300;
  },
  headers: {
    common: {
      "Accept": "application/json, text/plain, */*",
      "Content-Type": void 0
    }
  }
};
utils$1.forEach(["delete", "get", "head", "post", "put", "patch"], (method) => {
  defaults$1.headers[method] = {};
});
const ignoreDuplicateOf = utils$1.toObjectSet([
  "age",
  "authorization",
  "content-length",
  "content-type",
  "etag",
  "expires",
  "from",
  "host",
  "if-modified-since",
  "if-unmodified-since",
  "last-modified",
  "location",
  "max-forwards",
  "proxy-authorization",
  "referer",
  "retry-after",
  "user-agent"
]);
const parseHeaders = (rawHeaders) => {
  const parsed = {};
  let key;
  let val2;
  let i2;
  rawHeaders && rawHeaders.split("\n").forEach(function parser(line) {
    i2 = line.indexOf(":");
    key = line.substring(0, i2).trim().toLowerCase();
    val2 = line.substring(i2 + 1).trim();
    if (!key || parsed[key] && ignoreDuplicateOf[key]) {
      return;
    }
    if (key === "set-cookie") {
      if (parsed[key]) {
        parsed[key].push(val2);
      } else {
        parsed[key] = [val2];
      }
    } else {
      parsed[key] = parsed[key] ? parsed[key] + ", " + val2 : val2;
    }
  });
  return parsed;
};
const $internals = Symbol("internals");
function normalizeHeader(header) {
  return header && String(header).trim().toLowerCase();
}
function normalizeValue(value3) {
  if (value3 === false || value3 == null) {
    return value3;
  }
  return utils$1.isArray(value3) ? value3.map(normalizeValue) : String(value3);
}
function parseTokens(str) {
  const tokens = /* @__PURE__ */ Object.create(null);
  const tokensRE = /([^\s,;=]+)\s*(?:=\s*([^,;]+))?/g;
  let match6;
  while (match6 = tokensRE.exec(str)) {
    tokens[match6[1]] = match6[2];
  }
  return tokens;
}
const isValidHeaderName = (str) => /^[-_a-zA-Z0-9^`|~,!#$%&'*+.]+$/.test(str.trim());
function matchHeaderValue(context, value3, header, filter2, isHeaderNameFilter) {
  if (utils$1.isFunction(filter2)) {
    return filter2.call(this, value3, header);
  }
  if (isHeaderNameFilter) {
    value3 = header;
  }
  if (!utils$1.isString(value3)) return;
  if (utils$1.isString(filter2)) {
    return value3.indexOf(filter2) !== -1;
  }
  if (utils$1.isRegExp(filter2)) {
    return filter2.test(value3);
  }
}
function formatHeader(header) {
  return header.trim().toLowerCase().replace(/([a-z\d])(\w*)/g, (w3, char, str) => {
    return char.toUpperCase() + str;
  });
}
function buildAccessors(obj, header) {
  const accessorName = utils$1.toCamelCase(" " + header);
  ["get", "set", "has"].forEach((methodName) => {
    Object.defineProperty(obj, methodName + accessorName, {
      value: function(arg1, arg2, arg3) {
        return this[methodName].call(this, header, arg1, arg2, arg3);
      },
      configurable: true
    });
  });
}
class AxiosHeaders {
  constructor(headers) {
    headers && this.set(headers);
  }
  set(header, valueOrRewrite, rewrite) {
    const self2 = this;
    function setHeader(_value, _header, _rewrite) {
      const lHeader = normalizeHeader(_header);
      if (!lHeader) {
        throw new Error("header name must be a non-empty string");
      }
      const key = utils$1.findKey(self2, lHeader);
      if (!key || self2[key] === void 0 || _rewrite === true || _rewrite === void 0 && self2[key] !== false) {
        self2[key || _header] = normalizeValue(_value);
      }
    }
    const setHeaders = (headers, _rewrite) => utils$1.forEach(headers, (_value, _header) => setHeader(_value, _header, _rewrite));
    if (utils$1.isPlainObject(header) || header instanceof this.constructor) {
      setHeaders(header, valueOrRewrite);
    } else if (utils$1.isString(header) && (header = header.trim()) && !isValidHeaderName(header)) {
      setHeaders(parseHeaders(header), valueOrRewrite);
    } else if (utils$1.isHeaders(header)) {
      for (const [key, value3] of header.entries()) {
        setHeader(value3, key, rewrite);
      }
    } else {
      header != null && setHeader(valueOrRewrite, header, rewrite);
    }
    return this;
  }
  get(header, parser) {
    header = normalizeHeader(header);
    if (header) {
      const key = utils$1.findKey(this, header);
      if (key) {
        const value3 = this[key];
        if (!parser) {
          return value3;
        }
        if (parser === true) {
          return parseTokens(value3);
        }
        if (utils$1.isFunction(parser)) {
          return parser.call(this, value3, key);
        }
        if (utils$1.isRegExp(parser)) {
          return parser.exec(value3);
        }
        throw new TypeError("parser must be boolean|regexp|function");
      }
    }
  }
  has(header, matcher) {
    header = normalizeHeader(header);
    if (header) {
      const key = utils$1.findKey(this, header);
      return !!(key && this[key] !== void 0 && (!matcher || matchHeaderValue(this, this[key], key, matcher)));
    }
    return false;
  }
  delete(header, matcher) {
    const self2 = this;
    let deleted = false;
    function deleteHeader(_header) {
      _header = normalizeHeader(_header);
      if (_header) {
        const key = utils$1.findKey(self2, _header);
        if (key && (!matcher || matchHeaderValue(self2, self2[key], key, matcher))) {
          delete self2[key];
          deleted = true;
        }
      }
    }
    if (utils$1.isArray(header)) {
      header.forEach(deleteHeader);
    } else {
      deleteHeader(header);
    }
    return deleted;
  }
  clear(matcher) {
    const keys3 = Object.keys(this);
    let i2 = keys3.length;
    let deleted = false;
    while (i2--) {
      const key = keys3[i2];
      if (!matcher || matchHeaderValue(this, this[key], key, matcher, true)) {
        delete this[key];
        deleted = true;
      }
    }
    return deleted;
  }
  normalize(format3) {
    const self2 = this;
    const headers = {};
    utils$1.forEach(this, (value3, header) => {
      const key = utils$1.findKey(headers, header);
      if (key) {
        self2[key] = normalizeValue(value3);
        delete self2[header];
        return;
      }
      const normalized = format3 ? formatHeader(header) : String(header).trim();
      if (normalized !== header) {
        delete self2[header];
      }
      self2[normalized] = normalizeValue(value3);
      headers[normalized] = true;
    });
    return this;
  }
  concat(...targets) {
    return this.constructor.concat(this, ...targets);
  }
  toJSON(asStrings) {
    const obj = /* @__PURE__ */ Object.create(null);
    utils$1.forEach(this, (value3, header) => {
      value3 != null && value3 !== false && (obj[header] = asStrings && utils$1.isArray(value3) ? value3.join(", ") : value3);
    });
    return obj;
  }
  [Symbol.iterator]() {
    return Object.entries(this.toJSON())[Symbol.iterator]();
  }
  toString() {
    return Object.entries(this.toJSON()).map(([header, value3]) => header + ": " + value3).join("\n");
  }
  get [Symbol.toStringTag]() {
    return "AxiosHeaders";
  }
  static from(thing) {
    return thing instanceof this ? thing : new this(thing);
  }
  static concat(first, ...targets) {
    const computed2 = new this(first);
    targets.forEach((target2) => computed2.set(target2));
    return computed2;
  }
  static accessor(header) {
    const internals = this[$internals] = this[$internals] = {
      accessors: {}
    };
    const accessors = internals.accessors;
    const prototype2 = this.prototype;
    function defineAccessor(_header) {
      const lHeader = normalizeHeader(_header);
      if (!accessors[lHeader]) {
        buildAccessors(prototype2, _header);
        accessors[lHeader] = true;
      }
    }
    utils$1.isArray(header) ? header.forEach(defineAccessor) : defineAccessor(header);
    return this;
  }
}
AxiosHeaders.accessor(["Content-Type", "Content-Length", "Accept", "Accept-Encoding", "User-Agent", "Authorization"]);
utils$1.reduceDescriptors(AxiosHeaders.prototype, ({ value: value3 }, key) => {
  let mapped = key[0].toUpperCase() + key.slice(1);
  return {
    get: () => value3,
    set(headerValue) {
      this[mapped] = headerValue;
    }
  };
});
utils$1.freezeMethods(AxiosHeaders);
function transformData(fns, response) {
  const config2 = this || defaults$1;
  const context = response || config2;
  const headers = AxiosHeaders.from(context.headers);
  let data12 = context.data;
  utils$1.forEach(fns, function transform(fn) {
    data12 = fn.call(config2, data12, headers.normalize(), response ? response.status : void 0);
  });
  headers.normalize();
  return data12;
}
function isCancel(value3) {
  return !!(value3 && value3.__CANCEL__);
}
function CanceledError(message, config2, request) {
  AxiosError.call(this, message == null ? "canceled" : message, AxiosError.ERR_CANCELED, config2, request);
  this.name = "CanceledError";
}
utils$1.inherits(CanceledError, AxiosError, {
  __CANCEL__: true
});
function settle(resolve4, reject2, response) {
  const validateStatus2 = response.config.validateStatus;
  if (!response.status || !validateStatus2 || validateStatus2(response.status)) {
    resolve4(response);
  } else {
    reject2(new AxiosError(
      "Request failed with status code " + response.status,
      [AxiosError.ERR_BAD_REQUEST, AxiosError.ERR_BAD_RESPONSE][Math.floor(response.status / 100) - 4],
      response.config,
      response.request,
      response
    ));
  }
}
function parseProtocol(url) {
  const match6 = /^([-+\w]{1,25})(:?\/\/|:)/.exec(url);
  return match6 && match6[1] || "";
}
function speedometer(samplesCount, min2) {
  samplesCount = samplesCount || 10;
  const bytes = new Array(samplesCount);
  const timestamps = new Array(samplesCount);
  let head = 0;
  let tail = 0;
  let firstSampleTS;
  min2 = min2 !== void 0 ? min2 : 1e3;
  return function push3(chunkLength) {
    const now = Date.now();
    const startedAt = timestamps[tail];
    if (!firstSampleTS) {
      firstSampleTS = now;
    }
    bytes[head] = chunkLength;
    timestamps[head] = now;
    let i2 = tail;
    let bytesCount = 0;
    while (i2 !== head) {
      bytesCount += bytes[i2++];
      i2 = i2 % samplesCount;
    }
    head = (head + 1) % samplesCount;
    if (head === tail) {
      tail = (tail + 1) % samplesCount;
    }
    if (now - firstSampleTS < min2) {
      return;
    }
    const passed = startedAt && now - startedAt;
    return passed ? Math.round(bytesCount * 1e3 / passed) : void 0;
  };
}
function throttle(fn, freq) {
  let timestamp = 0;
  let threshold = 1e3 / freq;
  let lastArgs;
  let timer2;
  const invoke = (args, now = Date.now()) => {
    timestamp = now;
    lastArgs = null;
    if (timer2) {
      clearTimeout(timer2);
      timer2 = null;
    }
    fn.apply(null, args);
  };
  const throttled = (...args) => {
    const now = Date.now();
    const passed = now - timestamp;
    if (passed >= threshold) {
      invoke(args, now);
    } else {
      lastArgs = args;
      if (!timer2) {
        timer2 = setTimeout(() => {
          timer2 = null;
          invoke(lastArgs);
        }, threshold - passed);
      }
    }
  };
  const flush = () => lastArgs && invoke(lastArgs);
  return [throttled, flush];
}
const progressEventReducer = (listener, isDownloadStream, freq = 3) => {
  let bytesNotified = 0;
  const _speedometer = speedometer(50, 250);
  return throttle((e2) => {
    const loaded = e2.loaded;
    const total = e2.lengthComputable ? e2.total : void 0;
    const progressBytes = loaded - bytesNotified;
    const rate = _speedometer(progressBytes);
    const inRange = loaded <= total;
    bytesNotified = loaded;
    const data12 = {
      loaded,
      total,
      progress: total ? loaded / total : void 0,
      bytes: progressBytes,
      rate: rate ? rate : void 0,
      estimated: rate && total && inRange ? (total - loaded) / rate : void 0,
      event: e2,
      lengthComputable: total != null,
      [isDownloadStream ? "download" : "upload"]: true
    };
    listener(data12);
  }, freq);
};
const progressEventDecorator = (total, throttled) => {
  const lengthComputable = total != null;
  return [(loaded) => throttled[0]({
    lengthComputable,
    total,
    loaded
  }), throttled[1]];
};
const asyncDecorator = (fn) => (...args) => utils$1.asap(() => fn(...args));
const isURLSameOrigin = platform$2.hasStandardBrowserEnv ? (
  // Standard browser envs have full support of the APIs needed to test
  // whether the request URL is of the same origin as current location.
  function standardBrowserEnv() {
    const msie = platform$2.navigator && /(msie|trident)/i.test(platform$2.navigator.userAgent);
    const urlParsingNode = document.createElement("a");
    let originURL;
    function resolveURL(url) {
      let href = url;
      if (msie) {
        urlParsingNode.setAttribute("href", href);
        href = urlParsingNode.href;
      }
      urlParsingNode.setAttribute("href", href);
      return {
        href: urlParsingNode.href,
        protocol: urlParsingNode.protocol ? urlParsingNode.protocol.replace(/:$/, "") : "",
        host: urlParsingNode.host,
        search: urlParsingNode.search ? urlParsingNode.search.replace(/^\?/, "") : "",
        hash: urlParsingNode.hash ? urlParsingNode.hash.replace(/^#/, "") : "",
        hostname: urlParsingNode.hostname,
        port: urlParsingNode.port,
        pathname: urlParsingNode.pathname.charAt(0) === "/" ? urlParsingNode.pathname : "/" + urlParsingNode.pathname
      };
    }
    originURL = resolveURL(window.location.href);
    return function isURLSameOrigin2(requestURL) {
      const parsed = utils$1.isString(requestURL) ? resolveURL(requestURL) : requestURL;
      return parsed.protocol === originURL.protocol && parsed.host === originURL.host;
    };
  }()
) : (
  // Non standard browser envs (web workers, react-native) lack needed support.
  /* @__PURE__ */ function nonStandardBrowserEnv() {
    return function isURLSameOrigin2() {
      return true;
    };
  }()
);
const cookies = platform$2.hasStandardBrowserEnv ? (
  // Standard browser envs support document.cookie
  {
    write(name, value3, expires, path2, domain2, secure) {
      const cookie = [name + "=" + encodeURIComponent(value3)];
      utils$1.isNumber(expires) && cookie.push("expires=" + new Date(expires).toGMTString());
      utils$1.isString(path2) && cookie.push("path=" + path2);
      utils$1.isString(domain2) && cookie.push("domain=" + domain2);
      secure === true && cookie.push("secure");
      document.cookie = cookie.join("; ");
    },
    read(name) {
      const match6 = document.cookie.match(new RegExp("(^|;\\s*)(" + name + ")=([^;]*)"));
      return match6 ? decodeURIComponent(match6[3]) : null;
    },
    remove(name) {
      this.write(name, "", Date.now() - 864e5);
    }
  }
) : (
  // Non-standard browser env (web workers, react-native) lack needed support.
  {
    write() {
    },
    read() {
      return null;
    },
    remove() {
    }
  }
);
function isAbsoluteURL(url) {
  return /^([a-z][a-z\d+\-.]*:)?\/\//i.test(url);
}
function combineURLs(baseURL, relativeURL) {
  return relativeURL ? baseURL.replace(/\/?\/$/, "") + "/" + relativeURL.replace(/^\/+/, "") : baseURL;
}
function buildFullPath(baseURL, requestedURL) {
  if (baseURL && !isAbsoluteURL(requestedURL)) {
    return combineURLs(baseURL, requestedURL);
  }
  return requestedURL;
}
const headersToObject = (thing) => thing instanceof AxiosHeaders ? { ...thing } : thing;
function mergeConfig(config1, config2) {
  config2 = config2 || {};
  const config3 = {};
  function getMergedValue(target2, source, caseless) {
    if (utils$1.isPlainObject(target2) && utils$1.isPlainObject(source)) {
      return utils$1.merge.call({ caseless }, target2, source);
    } else if (utils$1.isPlainObject(source)) {
      return utils$1.merge({}, source);
    } else if (utils$1.isArray(source)) {
      return source.slice();
    }
    return source;
  }
  function mergeDeepProperties(a3, b2, caseless) {
    if (!utils$1.isUndefined(b2)) {
      return getMergedValue(a3, b2, caseless);
    } else if (!utils$1.isUndefined(a3)) {
      return getMergedValue(void 0, a3, caseless);
    }
  }
  function valueFromConfig2(a3, b2) {
    if (!utils$1.isUndefined(b2)) {
      return getMergedValue(void 0, b2);
    }
  }
  function defaultToConfig2(a3, b2) {
    if (!utils$1.isUndefined(b2)) {
      return getMergedValue(void 0, b2);
    } else if (!utils$1.isUndefined(a3)) {
      return getMergedValue(void 0, a3);
    }
  }
  function mergeDirectKeys(a3, b2, prop) {
    if (prop in config2) {
      return getMergedValue(a3, b2);
    } else if (prop in config1) {
      return getMergedValue(void 0, a3);
    }
  }
  const mergeMap = {
    url: valueFromConfig2,
    method: valueFromConfig2,
    data: valueFromConfig2,
    baseURL: defaultToConfig2,
    transformRequest: defaultToConfig2,
    transformResponse: defaultToConfig2,
    paramsSerializer: defaultToConfig2,
    timeout: defaultToConfig2,
    timeoutMessage: defaultToConfig2,
    withCredentials: defaultToConfig2,
    withXSRFToken: defaultToConfig2,
    adapter: defaultToConfig2,
    responseType: defaultToConfig2,
    xsrfCookieName: defaultToConfig2,
    xsrfHeaderName: defaultToConfig2,
    onUploadProgress: defaultToConfig2,
    onDownloadProgress: defaultToConfig2,
    decompress: defaultToConfig2,
    maxContentLength: defaultToConfig2,
    maxBodyLength: defaultToConfig2,
    beforeRedirect: defaultToConfig2,
    transport: defaultToConfig2,
    httpAgent: defaultToConfig2,
    httpsAgent: defaultToConfig2,
    cancelToken: defaultToConfig2,
    socketPath: defaultToConfig2,
    responseEncoding: defaultToConfig2,
    validateStatus: mergeDirectKeys,
    headers: (a3, b2) => mergeDeepProperties(headersToObject(a3), headersToObject(b2), true)
  };
  utils$1.forEach(Object.keys(Object.assign({}, config1, config2)), function computeConfigValue(prop) {
    const merge2 = mergeMap[prop] || mergeDeepProperties;
    const configValue = merge2(config1[prop], config2[prop], prop);
    utils$1.isUndefined(configValue) && merge2 !== mergeDirectKeys || (config3[prop] = configValue);
  });
  return config3;
}
const resolveConfig = (config2) => {
  const newConfig = mergeConfig({}, config2);
  let { data: data12, withXSRFToken, xsrfHeaderName, xsrfCookieName, headers, auth } = newConfig;
  newConfig.headers = headers = AxiosHeaders.from(headers);
  newConfig.url = buildURL(buildFullPath(newConfig.baseURL, newConfig.url), config2.params, config2.paramsSerializer);
  if (auth) {
    headers.set(
      "Authorization",
      "Basic " + btoa((auth.username || "") + ":" + (auth.password ? unescape(encodeURIComponent(auth.password)) : ""))
    );
  }
  let contentType;
  if (utils$1.isFormData(data12)) {
    if (platform$2.hasStandardBrowserEnv || platform$2.hasStandardBrowserWebWorkerEnv) {
      headers.setContentType(void 0);
    } else if ((contentType = headers.getContentType()) !== false) {
      const [type, ...tokens] = contentType ? contentType.split(";").map((token2) => token2.trim()).filter(Boolean) : [];
      headers.setContentType([type || "multipart/form-data", ...tokens].join("; "));
    }
  }
  if (platform$2.hasStandardBrowserEnv) {
    withXSRFToken && utils$1.isFunction(withXSRFToken) && (withXSRFToken = withXSRFToken(newConfig));
    if (withXSRFToken || withXSRFToken !== false && isURLSameOrigin(newConfig.url)) {
      const xsrfValue = xsrfHeaderName && xsrfCookieName && cookies.read(xsrfCookieName);
      if (xsrfValue) {
        headers.set(xsrfHeaderName, xsrfValue);
      }
    }
  }
  return newConfig;
};
const isXHRAdapterSupported = typeof XMLHttpRequest !== "undefined";
const xhrAdapter = isXHRAdapterSupported && function(config2) {
  return new Promise(function dispatchXhrRequest(resolve4, reject2) {
    const _config = resolveConfig(config2);
    let requestData = _config.data;
    const requestHeaders = AxiosHeaders.from(_config.headers).normalize();
    let { responseType, onUploadProgress, onDownloadProgress } = _config;
    let onCanceled;
    let uploadThrottled, downloadThrottled;
    let flushUpload, flushDownload;
    function done() {
      flushUpload && flushUpload();
      flushDownload && flushDownload();
      _config.cancelToken && _config.cancelToken.unsubscribe(onCanceled);
      _config.signal && _config.signal.removeEventListener("abort", onCanceled);
    }
    let request = new XMLHttpRequest();
    request.open(_config.method.toUpperCase(), _config.url, true);
    request.timeout = _config.timeout;
    function onloadend() {
      if (!request) {
        return;
      }
      const responseHeaders = AxiosHeaders.from(
        "getAllResponseHeaders" in request && request.getAllResponseHeaders()
      );
      const responseData = !responseType || responseType === "text" || responseType === "json" ? request.responseText : request.response;
      const response = {
        data: responseData,
        status: request.status,
        statusText: request.statusText,
        headers: responseHeaders,
        config: config2,
        request
      };
      settle(function _resolve(value3) {
        resolve4(value3);
        done();
      }, function _reject(err) {
        reject2(err);
        done();
      }, response);
      request = null;
    }
    if ("onloadend" in request) {
      request.onloadend = onloadend;
    } else {
      request.onreadystatechange = function handleLoad() {
        if (!request || request.readyState !== 4) {
          return;
        }
        if (request.status === 0 && !(request.responseURL && request.responseURL.indexOf("file:") === 0)) {
          return;
        }
        setTimeout(onloadend);
      };
    }
    request.onabort = function handleAbort() {
      if (!request) {
        return;
      }
      reject2(new AxiosError("Request aborted", AxiosError.ECONNABORTED, config2, request));
      request = null;
    };
    request.onerror = function handleError2() {
      reject2(new AxiosError("Network Error", AxiosError.ERR_NETWORK, config2, request));
      request = null;
    };
    request.ontimeout = function handleTimeout() {
      let timeoutErrorMessage = _config.timeout ? "timeout of " + _config.timeout + "ms exceeded" : "timeout exceeded";
      const transitional2 = _config.transitional || transitionalDefaults;
      if (_config.timeoutErrorMessage) {
        timeoutErrorMessage = _config.timeoutErrorMessage;
      }
      reject2(new AxiosError(
        timeoutErrorMessage,
        transitional2.clarifyTimeoutError ? AxiosError.ETIMEDOUT : AxiosError.ECONNABORTED,
        config2,
        request
      ));
      request = null;
    };
    requestData === void 0 && requestHeaders.setContentType(null);
    if ("setRequestHeader" in request) {
      utils$1.forEach(requestHeaders.toJSON(), function setRequestHeader(val2, key) {
        request.setRequestHeader(key, val2);
      });
    }
    if (!utils$1.isUndefined(_config.withCredentials)) {
      request.withCredentials = !!_config.withCredentials;
    }
    if (responseType && responseType !== "json") {
      request.responseType = _config.responseType;
    }
    if (onDownloadProgress) {
      [downloadThrottled, flushDownload] = progressEventReducer(onDownloadProgress, true);
      request.addEventListener("progress", downloadThrottled);
    }
    if (onUploadProgress && request.upload) {
      [uploadThrottled, flushUpload] = progressEventReducer(onUploadProgress);
      request.upload.addEventListener("progress", uploadThrottled);
      request.upload.addEventListener("loadend", flushUpload);
    }
    if (_config.cancelToken || _config.signal) {
      onCanceled = (cancel) => {
        if (!request) {
          return;
        }
        reject2(!cancel || cancel.type ? new CanceledError(null, config2, request) : cancel);
        request.abort();
        request = null;
      };
      _config.cancelToken && _config.cancelToken.subscribe(onCanceled);
      if (_config.signal) {
        _config.signal.aborted ? onCanceled() : _config.signal.addEventListener("abort", onCanceled);
      }
    }
    const protocol = parseProtocol(_config.url);
    if (protocol && platform$2.protocols.indexOf(protocol) === -1) {
      reject2(new AxiosError("Unsupported protocol " + protocol + ":", AxiosError.ERR_BAD_REQUEST, config2));
      return;
    }
    request.send(requestData || null);
  });
};
const composeSignals = (signals, timeout) => {
  const { length } = signals = signals ? signals.filter(Boolean) : [];
  if (timeout || length) {
    let controller = new AbortController();
    let aborted;
    const onabort = function(reason) {
      if (!aborted) {
        aborted = true;
        unsubscribe2();
        const err = reason instanceof Error ? reason : this.reason;
        controller.abort(err instanceof AxiosError ? err : new CanceledError(err instanceof Error ? err.message : err));
      }
    };
    let timer2 = timeout && setTimeout(() => {
      timer2 = null;
      onabort(new AxiosError(`timeout ${timeout} of ms exceeded`, AxiosError.ETIMEDOUT));
    }, timeout);
    const unsubscribe2 = () => {
      if (signals) {
        timer2 && clearTimeout(timer2);
        timer2 = null;
        signals.forEach((signal2) => {
          signal2.unsubscribe ? signal2.unsubscribe(onabort) : signal2.removeEventListener("abort", onabort);
        });
        signals = null;
      }
    };
    signals.forEach((signal2) => signal2.addEventListener("abort", onabort));
    const { signal } = controller;
    signal.unsubscribe = () => utils$1.asap(unsubscribe2);
    return signal;
  }
};
const streamChunk = function* (chunk2, chunkSize) {
  let len = chunk2.byteLength;
  if (!chunkSize || len < chunkSize) {
    yield chunk2;
    return;
  }
  let pos = 0;
  let end;
  while (pos < len) {
    end = pos + chunkSize;
    yield chunk2.slice(pos, end);
    pos = end;
  }
};
const readBytes = async function* (iterable, chunkSize) {
  for await (const chunk2 of readStream(iterable)) {
    yield* streamChunk(chunk2, chunkSize);
  }
};
const readStream = async function* (stream) {
  if (stream[Symbol.asyncIterator]) {
    yield* stream;
    return;
  }
  const reader = stream.getReader();
  try {
    for (; ; ) {
      const { done, value: value3 } = await reader.read();
      if (done) {
        break;
      }
      yield value3;
    }
  } finally {
    await reader.cancel();
  }
};
const trackStream = (stream, chunkSize, onProgress, onFinish) => {
  const iterator = readBytes(stream, chunkSize);
  let bytes = 0;
  let done;
  let _onFinish = (e2) => {
    if (!done) {
      done = true;
      onFinish && onFinish(e2);
    }
  };
  return new ReadableStream({
    async pull(controller) {
      try {
        const { done: done2, value: value3 } = await iterator.next();
        if (done2) {
          _onFinish();
          controller.close();
          return;
        }
        let len = value3.byteLength;
        if (onProgress) {
          let loadedBytes = bytes += len;
          onProgress(loadedBytes);
        }
        controller.enqueue(new Uint8Array(value3));
      } catch (err) {
        _onFinish(err);
        throw err;
      }
    },
    cancel(reason) {
      _onFinish(reason);
      return iterator.return();
    }
  }, {
    highWaterMark: 2
  });
};
const isFetchSupported = typeof fetch === "function" && typeof Request === "function" && typeof Response === "function";
const isReadableStreamSupported = isFetchSupported && typeof ReadableStream === "function";
const encodeText = isFetchSupported && (typeof TextEncoder === "function" ? /* @__PURE__ */ ((encoder) => (str) => encoder.encode(str))(new TextEncoder()) : async (str) => new Uint8Array(await new Response(str).arrayBuffer()));
const test$1 = (fn, ...args) => {
  try {
    return !!fn(...args);
  } catch (e2) {
    return false;
  }
};
const supportsRequestStream = isReadableStreamSupported && test$1(() => {
  let duplexAccessed = false;
  const hasContentType = new Request(platform$2.origin, {
    body: new ReadableStream(),
    method: "POST",
    get duplex() {
      duplexAccessed = true;
      return "half";
    }
  }).headers.has("Content-Type");
  return duplexAccessed && !hasContentType;
});
const DEFAULT_CHUNK_SIZE = 64 * 1024;
const supportsResponseStream = isReadableStreamSupported && test$1(() => utils$1.isReadableStream(new Response("").body));
const resolvers = {
  stream: supportsResponseStream && ((res) => res.body)
};
isFetchSupported && ((res) => {
  ["text", "arrayBuffer", "blob", "formData", "stream"].forEach((type) => {
    !resolvers[type] && (resolvers[type] = utils$1.isFunction(res[type]) ? (res2) => res2[type]() : (_2, config2) => {
      throw new AxiosError(`Response type '${type}' is not supported`, AxiosError.ERR_NOT_SUPPORT, config2);
    });
  });
})(new Response());
const getBodyLength = async (body) => {
  if (body == null) {
    return 0;
  }
  if (utils$1.isBlob(body)) {
    return body.size;
  }
  if (utils$1.isSpecCompliantForm(body)) {
    const _request = new Request(platform$2.origin, {
      method: "POST",
      body
    });
    return (await _request.arrayBuffer()).byteLength;
  }
  if (utils$1.isArrayBufferView(body) || utils$1.isArrayBuffer(body)) {
    return body.byteLength;
  }
  if (utils$1.isURLSearchParams(body)) {
    body = body + "";
  }
  if (utils$1.isString(body)) {
    return (await encodeText(body)).byteLength;
  }
};
const resolveBodyLength = async (headers, body) => {
  const length = utils$1.toFiniteNumber(headers.getContentLength());
  return length == null ? getBodyLength(body) : length;
};
const fetchAdapter = isFetchSupported && (async (config2) => {
  let {
    url,
    method,
    data: data12,
    signal,
    cancelToken,
    timeout,
    onDownloadProgress,
    onUploadProgress,
    responseType,
    headers,
    withCredentials = "same-origin",
    fetchOptions
  } = resolveConfig(config2);
  responseType = responseType ? (responseType + "").toLowerCase() : "text";
  let composedSignal = composeSignals([signal, cancelToken && cancelToken.toAbortSignal()], timeout);
  let request;
  const unsubscribe2 = composedSignal && composedSignal.unsubscribe && (() => {
    composedSignal.unsubscribe();
  });
  let requestContentLength;
  try {
    if (onUploadProgress && supportsRequestStream && method !== "get" && method !== "head" && (requestContentLength = await resolveBodyLength(headers, data12)) !== 0) {
      let _request = new Request(url, {
        method: "POST",
        body: data12,
        duplex: "half"
      });
      let contentTypeHeader;
      if (utils$1.isFormData(data12) && (contentTypeHeader = _request.headers.get("content-type"))) {
        headers.setContentType(contentTypeHeader);
      }
      if (_request.body) {
        const [onProgress, flush] = progressEventDecorator(
          requestContentLength,
          progressEventReducer(asyncDecorator(onUploadProgress))
        );
        data12 = trackStream(_request.body, DEFAULT_CHUNK_SIZE, onProgress, flush);
      }
    }
    if (!utils$1.isString(withCredentials)) {
      withCredentials = withCredentials ? "include" : "omit";
    }
    const isCredentialsSupported = "credentials" in Request.prototype;
    request = new Request(url, {
      ...fetchOptions,
      signal: composedSignal,
      method: method.toUpperCase(),
      headers: headers.normalize().toJSON(),
      body: data12,
      duplex: "half",
      credentials: isCredentialsSupported ? withCredentials : void 0
    });
    let response = await fetch(request);
    const isStreamResponse = supportsResponseStream && (responseType === "stream" || responseType === "response");
    if (supportsResponseStream && (onDownloadProgress || isStreamResponse && unsubscribe2)) {
      const options2 = {};
      ["status", "statusText", "headers"].forEach((prop) => {
        options2[prop] = response[prop];
      });
      const responseContentLength = utils$1.toFiniteNumber(response.headers.get("content-length"));
      const [onProgress, flush] = onDownloadProgress && progressEventDecorator(
        responseContentLength,
        progressEventReducer(asyncDecorator(onDownloadProgress), true)
      ) || [];
      response = new Response(
        trackStream(response.body, DEFAULT_CHUNK_SIZE, onProgress, () => {
          flush && flush();
          unsubscribe2 && unsubscribe2();
        }),
        options2
      );
    }
    responseType = responseType || "text";
    let responseData = await resolvers[utils$1.findKey(resolvers, responseType) || "text"](response, config2);
    !isStreamResponse && unsubscribe2 && unsubscribe2();
    return await new Promise((resolve4, reject2) => {
      settle(resolve4, reject2, {
        data: responseData,
        headers: AxiosHeaders.from(response.headers),
        status: response.status,
        statusText: response.statusText,
        config: config2,
        request
      });
    });
  } catch (err) {
    unsubscribe2 && unsubscribe2();
    if (err && err.name === "TypeError" && /fetch/i.test(err.message)) {
      throw Object.assign(
        new AxiosError("Network Error", AxiosError.ERR_NETWORK, config2, request),
        {
          cause: err.cause || err
        }
      );
    }
    throw AxiosError.from(err, err && err.code, config2, request);
  }
});
const knownAdapters = {
  http: httpAdapter,
  xhr: xhrAdapter,
  fetch: fetchAdapter
};
utils$1.forEach(knownAdapters, (fn, value3) => {
  if (fn) {
    try {
      Object.defineProperty(fn, "name", { value: value3 });
    } catch (e2) {
    }
    Object.defineProperty(fn, "adapterName", { value: value3 });
  }
});
const renderReason = (reason) => `- ${reason}`;
const isResolvedHandle = (adapter) => utils$1.isFunction(adapter) || adapter === null || adapter === false;
const adapters = {
  getAdapter: (adapters2) => {
    adapters2 = utils$1.isArray(adapters2) ? adapters2 : [adapters2];
    const { length } = adapters2;
    let nameOrAdapter;
    let adapter;
    const rejectedReasons = {};
    for (let i2 = 0; i2 < length; i2++) {
      nameOrAdapter = adapters2[i2];
      let id2;
      adapter = nameOrAdapter;
      if (!isResolvedHandle(nameOrAdapter)) {
        adapter = knownAdapters[(id2 = String(nameOrAdapter)).toLowerCase()];
        if (adapter === void 0) {
          throw new AxiosError(`Unknown adapter '${id2}'`);
        }
      }
      if (adapter) {
        break;
      }
      rejectedReasons[id2 || "#" + i2] = adapter;
    }
    if (!adapter) {
      const reasons = Object.entries(rejectedReasons).map(
        ([id2, state]) => `adapter ${id2} ` + (state === false ? "is not supported by the environment" : "is not available in the build")
      );
      let s3 = length ? reasons.length > 1 ? "since :\n" + reasons.map(renderReason).join("\n") : " " + renderReason(reasons[0]) : "as no adapter specified";
      throw new AxiosError(
        `There is no suitable adapter to dispatch the request ` + s3,
        "ERR_NOT_SUPPORT"
      );
    }
    return adapter;
  },
  adapters: knownAdapters
};
function throwIfCancellationRequested(config2) {
  if (config2.cancelToken) {
    config2.cancelToken.throwIfRequested();
  }
  if (config2.signal && config2.signal.aborted) {
    throw new CanceledError(null, config2);
  }
}
function dispatchRequest(config2) {
  throwIfCancellationRequested(config2);
  config2.headers = AxiosHeaders.from(config2.headers);
  config2.data = transformData.call(
    config2,
    config2.transformRequest
  );
  if (["post", "put", "patch"].indexOf(config2.method) !== -1) {
    config2.headers.setContentType("application/x-www-form-urlencoded", false);
  }
  const adapter = adapters.getAdapter(config2.adapter || defaults$1.adapter);
  return adapter(config2).then(function onAdapterResolution(response) {
    throwIfCancellationRequested(config2);
    response.data = transformData.call(
      config2,
      config2.transformResponse,
      response
    );
    response.headers = AxiosHeaders.from(response.headers);
    return response;
  }, function onAdapterRejection(reason) {
    if (!isCancel(reason)) {
      throwIfCancellationRequested(config2);
      if (reason && reason.response) {
        reason.response.data = transformData.call(
          config2,
          config2.transformResponse,
          reason.response
        );
        reason.response.headers = AxiosHeaders.from(reason.response.headers);
      }
    }
    return Promise.reject(reason);
  });
}
const VERSION = "1.7.7";
const validators$1 = {};
["object", "boolean", "number", "function", "string", "symbol"].forEach((type, i2) => {
  validators$1[type] = function validator3(thing) {
    return typeof thing === type || "a" + (i2 < 1 ? "n " : " ") + type;
  };
});
const deprecatedWarnings = {};
validators$1.transitional = function transitional(validator3, version2, message) {
  function formatMessage(opt, desc) {
    return "[Axios v" + VERSION + "] Transitional option '" + opt + "'" + desc + (message ? ". " + message : "");
  }
  return (value3, opt, opts) => {
    if (validator3 === false) {
      throw new AxiosError(
        formatMessage(opt, " has been removed" + (version2 ? " in " + version2 : "")),
        AxiosError.ERR_DEPRECATED
      );
    }
    if (version2 && !deprecatedWarnings[opt]) {
      deprecatedWarnings[opt] = true;
      console.warn(
        formatMessage(
          opt,
          " has been deprecated since v" + version2 + " and will be removed in the near future"
        )
      );
    }
    return validator3 ? validator3(value3, opt, opts) : true;
  };
};
function assertOptions(options2, schema, allowUnknown) {
  if (typeof options2 !== "object") {
    throw new AxiosError("options must be an object", AxiosError.ERR_BAD_OPTION_VALUE);
  }
  const keys3 = Object.keys(options2);
  let i2 = keys3.length;
  while (i2-- > 0) {
    const opt = keys3[i2];
    const validator3 = schema[opt];
    if (validator3) {
      const value3 = options2[opt];
      const result = value3 === void 0 || validator3(value3, opt, options2);
      if (result !== true) {
        throw new AxiosError("option " + opt + " must be " + result, AxiosError.ERR_BAD_OPTION_VALUE);
      }
      continue;
    }
    if (allowUnknown !== true) {
      throw new AxiosError("Unknown option " + opt, AxiosError.ERR_BAD_OPTION);
    }
  }
}
const validator = {
  assertOptions,
  validators: validators$1
};
const validators = validator.validators;
class Axios {
  constructor(instanceConfig) {
    this.defaults = instanceConfig;
    this.interceptors = {
      request: new InterceptorManager(),
      response: new InterceptorManager()
    };
  }
  /**
   * Dispatch a request
   *
   * @param {String|Object} configOrUrl The config specific for this request (merged with this.defaults)
   * @param {?Object} config
   *
   * @returns {Promise} The Promise to be fulfilled
   */
  async request(configOrUrl, config2) {
    try {
      return await this._request(configOrUrl, config2);
    } catch (err) {
      if (err instanceof Error) {
        let dummy;
        Error.captureStackTrace ? Error.captureStackTrace(dummy = {}) : dummy = new Error();
        const stack = dummy.stack ? dummy.stack.replace(/^.+\n/, "") : "";
        try {
          if (!err.stack) {
            err.stack = stack;
          } else if (stack && !String(err.stack).endsWith(stack.replace(/^.+\n.+\n/, ""))) {
            err.stack += "\n" + stack;
          }
        } catch (e2) {
        }
      }
      throw err;
    }
  }
  _request(configOrUrl, config2) {
    if (typeof configOrUrl === "string") {
      config2 = config2 || {};
      config2.url = configOrUrl;
    } else {
      config2 = configOrUrl || {};
    }
    config2 = mergeConfig(this.defaults, config2);
    const { transitional: transitional2, paramsSerializer, headers } = config2;
    if (transitional2 !== void 0) {
      validator.assertOptions(transitional2, {
        silentJSONParsing: validators.transitional(validators.boolean),
        forcedJSONParsing: validators.transitional(validators.boolean),
        clarifyTimeoutError: validators.transitional(validators.boolean)
      }, false);
    }
    if (paramsSerializer != null) {
      if (utils$1.isFunction(paramsSerializer)) {
        config2.paramsSerializer = {
          serialize: paramsSerializer
        };
      } else {
        validator.assertOptions(paramsSerializer, {
          encode: validators.function,
          serialize: validators.function
        }, true);
      }
    }
    config2.method = (config2.method || this.defaults.method || "get").toLowerCase();
    let contextHeaders = headers && utils$1.merge(
      headers.common,
      headers[config2.method]
    );
    headers && utils$1.forEach(
      ["delete", "get", "head", "post", "put", "patch", "common"],
      (method) => {
        delete headers[method];
      }
    );
    config2.headers = AxiosHeaders.concat(contextHeaders, headers);
    const requestInterceptorChain = [];
    let synchronousRequestInterceptors = true;
    this.interceptors.request.forEach(function unshiftRequestInterceptors(interceptor) {
      if (typeof interceptor.runWhen === "function" && interceptor.runWhen(config2) === false) {
        return;
      }
      synchronousRequestInterceptors = synchronousRequestInterceptors && interceptor.synchronous;
      requestInterceptorChain.unshift(interceptor.fulfilled, interceptor.rejected);
    });
    const responseInterceptorChain = [];
    this.interceptors.response.forEach(function pushResponseInterceptors(interceptor) {
      responseInterceptorChain.push(interceptor.fulfilled, interceptor.rejected);
    });
    let promise;
    let i2 = 0;
    let len;
    if (!synchronousRequestInterceptors) {
      const chain = [dispatchRequest.bind(this), void 0];
      chain.unshift.apply(chain, requestInterceptorChain);
      chain.push.apply(chain, responseInterceptorChain);
      len = chain.length;
      promise = Promise.resolve(config2);
      while (i2 < len) {
        promise = promise.then(chain[i2++], chain[i2++]);
      }
      return promise;
    }
    len = requestInterceptorChain.length;
    let newConfig = config2;
    i2 = 0;
    while (i2 < len) {
      const onFulfilled = requestInterceptorChain[i2++];
      const onRejected = requestInterceptorChain[i2++];
      try {
        newConfig = onFulfilled(newConfig);
      } catch (error) {
        onRejected.call(this, error);
        break;
      }
    }
    try {
      promise = dispatchRequest.call(this, newConfig);
    } catch (error) {
      return Promise.reject(error);
    }
    i2 = 0;
    len = responseInterceptorChain.length;
    while (i2 < len) {
      promise = promise.then(responseInterceptorChain[i2++], responseInterceptorChain[i2++]);
    }
    return promise;
  }
  getUri(config2) {
    config2 = mergeConfig(this.defaults, config2);
    const fullPath = buildFullPath(config2.baseURL, config2.url);
    return buildURL(fullPath, config2.params, config2.paramsSerializer);
  }
}
utils$1.forEach(["delete", "get", "head", "options"], function forEachMethodNoData(method) {
  Axios.prototype[method] = function(url, config2) {
    return this.request(mergeConfig(config2 || {}, {
      method,
      url,
      data: (config2 || {}).data
    }));
  };
});
utils$1.forEach(["post", "put", "patch"], function forEachMethodWithData(method) {
  function generateHTTPMethod(isForm) {
    return function httpMethod(url, data12, config2) {
      return this.request(mergeConfig(config2 || {}, {
        method,
        headers: isForm ? {
          "Content-Type": "multipart/form-data"
        } : {},
        url,
        data: data12
      }));
    };
  }
  Axios.prototype[method] = generateHTTPMethod();
  Axios.prototype[method + "Form"] = generateHTTPMethod(true);
});
class CancelToken {
  constructor(executor) {
    if (typeof executor !== "function") {
      throw new TypeError("executor must be a function.");
    }
    let resolvePromise;
    this.promise = new Promise(function promiseExecutor(resolve4) {
      resolvePromise = resolve4;
    });
    const token2 = this;
    this.promise.then((cancel) => {
      if (!token2._listeners) return;
      let i2 = token2._listeners.length;
      while (i2-- > 0) {
        token2._listeners[i2](cancel);
      }
      token2._listeners = null;
    });
    this.promise.then = (onfulfilled) => {
      let _resolve;
      const promise = new Promise((resolve4) => {
        token2.subscribe(resolve4);
        _resolve = resolve4;
      }).then(onfulfilled);
      promise.cancel = function reject2() {
        token2.unsubscribe(_resolve);
      };
      return promise;
    };
    executor(function cancel(message, config2, request) {
      if (token2.reason) {
        return;
      }
      token2.reason = new CanceledError(message, config2, request);
      resolvePromise(token2.reason);
    });
  }
  /**
   * Throws a `CanceledError` if cancellation has been requested.
   */
  throwIfRequested() {
    if (this.reason) {
      throw this.reason;
    }
  }
  /**
   * Subscribe to the cancel signal
   */
  subscribe(listener) {
    if (this.reason) {
      listener(this.reason);
      return;
    }
    if (this._listeners) {
      this._listeners.push(listener);
    } else {
      this._listeners = [listener];
    }
  }
  /**
   * Unsubscribe from the cancel signal
   */
  unsubscribe(listener) {
    if (!this._listeners) {
      return;
    }
    const index2 = this._listeners.indexOf(listener);
    if (index2 !== -1) {
      this._listeners.splice(index2, 1);
    }
  }
  toAbortSignal() {
    const controller = new AbortController();
    const abort = (err) => {
      controller.abort(err);
    };
    this.subscribe(abort);
    controller.signal.unsubscribe = () => this.unsubscribe(abort);
    return controller.signal;
  }
  /**
   * Returns an object that contains a new `CancelToken` and a function that, when called,
   * cancels the `CancelToken`.
   */
  static source() {
    let cancel;
    const token2 = new CancelToken(function executor(c2) {
      cancel = c2;
    });
    return {
      token: token2,
      cancel
    };
  }
}
function spread(callback) {
  return function wrap2(arr) {
    return callback.apply(null, arr);
  };
}
function isAxiosError(payload) {
  return utils$1.isObject(payload) && payload.isAxiosError === true;
}
const HttpStatusCode = {
  Continue: 100,
  SwitchingProtocols: 101,
  Processing: 102,
  EarlyHints: 103,
  Ok: 200,
  Created: 201,
  Accepted: 202,
  NonAuthoritativeInformation: 203,
  NoContent: 204,
  ResetContent: 205,
  PartialContent: 206,
  MultiStatus: 207,
  AlreadyReported: 208,
  ImUsed: 226,
  MultipleChoices: 300,
  MovedPermanently: 301,
  Found: 302,
  SeeOther: 303,
  NotModified: 304,
  UseProxy: 305,
  Unused: 306,
  TemporaryRedirect: 307,
  PermanentRedirect: 308,
  BadRequest: 400,
  Unauthorized: 401,
  PaymentRequired: 402,
  Forbidden: 403,
  NotFound: 404,
  MethodNotAllowed: 405,
  NotAcceptable: 406,
  ProxyAuthenticationRequired: 407,
  RequestTimeout: 408,
  Conflict: 409,
  Gone: 410,
  LengthRequired: 411,
  PreconditionFailed: 412,
  PayloadTooLarge: 413,
  UriTooLong: 414,
  UnsupportedMediaType: 415,
  RangeNotSatisfiable: 416,
  ExpectationFailed: 417,
  ImATeapot: 418,
  MisdirectedRequest: 421,
  UnprocessableEntity: 422,
  Locked: 423,
  FailedDependency: 424,
  TooEarly: 425,
  UpgradeRequired: 426,
  PreconditionRequired: 428,
  TooManyRequests: 429,
  RequestHeaderFieldsTooLarge: 431,
  UnavailableForLegalReasons: 451,
  InternalServerError: 500,
  NotImplemented: 501,
  BadGateway: 502,
  ServiceUnavailable: 503,
  GatewayTimeout: 504,
  HttpVersionNotSupported: 505,
  VariantAlsoNegotiates: 506,
  InsufficientStorage: 507,
  LoopDetected: 508,
  NotExtended: 510,
  NetworkAuthenticationRequired: 511
};
Object.entries(HttpStatusCode).forEach(([key, value3]) => {
  HttpStatusCode[value3] = key;
});
function createInstance(defaultConfig) {
  const context = new Axios(defaultConfig);
  const instance = bind$3(Axios.prototype.request, context);
  utils$1.extend(instance, Axios.prototype, context, { allOwnKeys: true });
  utils$1.extend(instance, context, null, { allOwnKeys: true });
  instance.create = function create4(instanceConfig) {
    return createInstance(mergeConfig(defaultConfig, instanceConfig));
  };
  return instance;
}
const axios = createInstance(defaults$1);
axios.Axios = Axios;
axios.CanceledError = CanceledError;
axios.CancelToken = CancelToken;
axios.isCancel = isCancel;
axios.VERSION = VERSION;
axios.toFormData = toFormData;
axios.AxiosError = AxiosError;
axios.Cancel = axios.CanceledError;
axios.all = function all(promises) {
  return Promise.all(promises);
};
axios.spread = spread;
axios.isAxiosError = isAxiosError;
axios.mergeConfig = mergeConfig;
axios.AxiosHeaders = AxiosHeaders;
axios.formToJSON = (thing) => formDataToJSON(utils$1.isHTMLForm(thing) ? new FormData(thing) : thing);
axios.getAdapter = adapters.getAdapter;
axios.HttpStatusCode = HttpStatusCode;
axios.default = axios;
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function getDefaultExportFromCjs(x3) {
  return x3 && x3.__esModule && Object.prototype.hasOwnProperty.call(x3, "default") ? x3["default"] : x3;
}
function getAugmentedNamespace(n2) {
  if (n2.__esModule) return n2;
  var f2 = n2.default;
  if (typeof f2 == "function") {
    var a3 = function a4() {
      if (this instanceof a4) {
        return Reflect.construct(f2, arguments, this.constructor);
      }
      return f2.apply(this, arguments);
    };
    a3.prototype = f2.prototype;
  } else a3 = {};
  Object.defineProperty(a3, "__esModule", { value: true });
  Object.keys(n2).forEach(function(k2) {
    var d3 = Object.getOwnPropertyDescriptor(n2, k2);
    Object.defineProperty(a3, k2, d3.get ? d3 : {
      enumerable: true,
      get: function() {
        return n2[k2];
      }
    });
  });
  return a3;
}
var define_process_env_default$2 = {};
const debug$2 = typeof process$1$1 === "object" && define_process_env_default$2 && define_process_env_default$2.NODE_DEBUG && /\bsemver\b/i.test(define_process_env_default$2.NODE_DEBUG) ? (...args) => console.error("SEMVER", ...args) : () => {
};
var debug_1$1 = debug$2;
const SEMVER_SPEC_VERSION$1 = "2.0.0";
const MAX_LENGTH$2 = 256;
const MAX_SAFE_INTEGER$2 = Number.MAX_SAFE_INTEGER || /* istanbul ignore next */
9007199254740991;
const MAX_SAFE_COMPONENT_LENGTH$1 = 16;
const MAX_SAFE_BUILD_LENGTH$1 = MAX_LENGTH$2 - 6;
const RELEASE_TYPES$1 = [
  "major",
  "premajor",
  "minor",
  "preminor",
  "patch",
  "prepatch",
  "prerelease"
];
var constants$1 = {
  MAX_LENGTH: MAX_LENGTH$2,
  MAX_SAFE_COMPONENT_LENGTH: MAX_SAFE_COMPONENT_LENGTH$1,
  MAX_SAFE_BUILD_LENGTH: MAX_SAFE_BUILD_LENGTH$1,
  MAX_SAFE_INTEGER: MAX_SAFE_INTEGER$2,
  RELEASE_TYPES: RELEASE_TYPES$1,
  SEMVER_SPEC_VERSION: SEMVER_SPEC_VERSION$1,
  FLAG_INCLUDE_PRERELEASE: 1,
  FLAG_LOOSE: 2
};
var re$3 = { exports: {} };
(function(module, exports) {
  const {
    MAX_SAFE_COMPONENT_LENGTH: MAX_SAFE_COMPONENT_LENGTH2,
    MAX_SAFE_BUILD_LENGTH: MAX_SAFE_BUILD_LENGTH2,
    MAX_LENGTH: MAX_LENGTH2
  } = constants$1;
  const debug2 = debug_1$1;
  exports = module.exports = {};
  const re2 = exports.re = [];
  const safeRe = exports.safeRe = [];
  const src = exports.src = [];
  const t50 = exports.t = {};
  let R2 = 0;
  const LETTERDASHNUMBER = "[a-zA-Z0-9-]";
  const safeRegexReplacements = [
    ["\\s", 1],
    ["\\d", MAX_LENGTH2],
    [LETTERDASHNUMBER, MAX_SAFE_BUILD_LENGTH2]
  ];
  const makeSafeRegex = (value3) => {
    for (const [token2, max2] of safeRegexReplacements) {
      value3 = value3.split(`${token2}*`).join(`${token2}{0,${max2}}`).split(`${token2}+`).join(`${token2}{1,${max2}}`);
    }
    return value3;
  };
  const createToken = (name, value3, isGlobal) => {
    const safe = makeSafeRegex(value3);
    const index2 = R2++;
    debug2(name, index2, value3);
    t50[name] = index2;
    src[index2] = value3;
    re2[index2] = new RegExp(value3, isGlobal ? "g" : void 0);
    safeRe[index2] = new RegExp(safe, isGlobal ? "g" : void 0);
  };
  createToken("NUMERICIDENTIFIER", "0|[1-9]\\d*");
  createToken("NUMERICIDENTIFIERLOOSE", "\\d+");
  createToken("NONNUMERICIDENTIFIER", `\\d*[a-zA-Z-]${LETTERDASHNUMBER}*`);
  createToken("MAINVERSION", `(${src[t50.NUMERICIDENTIFIER]})\\.(${src[t50.NUMERICIDENTIFIER]})\\.(${src[t50.NUMERICIDENTIFIER]})`);
  createToken("MAINVERSIONLOOSE", `(${src[t50.NUMERICIDENTIFIERLOOSE]})\\.(${src[t50.NUMERICIDENTIFIERLOOSE]})\\.(${src[t50.NUMERICIDENTIFIERLOOSE]})`);
  createToken("PRERELEASEIDENTIFIER", `(?:${src[t50.NUMERICIDENTIFIER]}|${src[t50.NONNUMERICIDENTIFIER]})`);
  createToken("PRERELEASEIDENTIFIERLOOSE", `(?:${src[t50.NUMERICIDENTIFIERLOOSE]}|${src[t50.NONNUMERICIDENTIFIER]})`);
  createToken("PRERELEASE", `(?:-(${src[t50.PRERELEASEIDENTIFIER]}(?:\\.${src[t50.PRERELEASEIDENTIFIER]})*))`);
  createToken("PRERELEASELOOSE", `(?:-?(${src[t50.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${src[t50.PRERELEASEIDENTIFIERLOOSE]})*))`);
  createToken("BUILDIDENTIFIER", `${LETTERDASHNUMBER}+`);
  createToken("BUILD", `(?:\\+(${src[t50.BUILDIDENTIFIER]}(?:\\.${src[t50.BUILDIDENTIFIER]})*))`);
  createToken("FULLPLAIN", `v?${src[t50.MAINVERSION]}${src[t50.PRERELEASE]}?${src[t50.BUILD]}?`);
  createToken("FULL", `^${src[t50.FULLPLAIN]}$`);
  createToken("LOOSEPLAIN", `[v=\\s]*${src[t50.MAINVERSIONLOOSE]}${src[t50.PRERELEASELOOSE]}?${src[t50.BUILD]}?`);
  createToken("LOOSE", `^${src[t50.LOOSEPLAIN]}$`);
  createToken("GTLT", "((?:<|>)?=?)");
  createToken("XRANGEIDENTIFIERLOOSE", `${src[t50.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`);
  createToken("XRANGEIDENTIFIER", `${src[t50.NUMERICIDENTIFIER]}|x|X|\\*`);
  createToken("XRANGEPLAIN", `[v=\\s]*(${src[t50.XRANGEIDENTIFIER]})(?:\\.(${src[t50.XRANGEIDENTIFIER]})(?:\\.(${src[t50.XRANGEIDENTIFIER]})(?:${src[t50.PRERELEASE]})?${src[t50.BUILD]}?)?)?`);
  createToken("XRANGEPLAINLOOSE", `[v=\\s]*(${src[t50.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t50.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t50.XRANGEIDENTIFIERLOOSE]})(?:${src[t50.PRERELEASELOOSE]})?${src[t50.BUILD]}?)?)?`);
  createToken("XRANGE", `^${src[t50.GTLT]}\\s*${src[t50.XRANGEPLAIN]}$`);
  createToken("XRANGELOOSE", `^${src[t50.GTLT]}\\s*${src[t50.XRANGEPLAINLOOSE]}$`);
  createToken("COERCEPLAIN", `${"(^|[^\\d])(\\d{1,"}${MAX_SAFE_COMPONENT_LENGTH2}})(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH2}}))?(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH2}}))?`);
  createToken("COERCE", `${src[t50.COERCEPLAIN]}(?:$|[^\\d])`);
  createToken("COERCEFULL", src[t50.COERCEPLAIN] + `(?:${src[t50.PRERELEASE]})?(?:${src[t50.BUILD]})?(?:$|[^\\d])`);
  createToken("COERCERTL", src[t50.COERCE], true);
  createToken("COERCERTLFULL", src[t50.COERCEFULL], true);
  createToken("LONETILDE", "(?:~>?)");
  createToken("TILDETRIM", `(\\s*)${src[t50.LONETILDE]}\\s+`, true);
  exports.tildeTrimReplace = "$1~";
  createToken("TILDE", `^${src[t50.LONETILDE]}${src[t50.XRANGEPLAIN]}$`);
  createToken("TILDELOOSE", `^${src[t50.LONETILDE]}${src[t50.XRANGEPLAINLOOSE]}$`);
  createToken("LONECARET", "(?:\\^)");
  createToken("CARETTRIM", `(\\s*)${src[t50.LONECARET]}\\s+`, true);
  exports.caretTrimReplace = "$1^";
  createToken("CARET", `^${src[t50.LONECARET]}${src[t50.XRANGEPLAIN]}$`);
  createToken("CARETLOOSE", `^${src[t50.LONECARET]}${src[t50.XRANGEPLAINLOOSE]}$`);
  createToken("COMPARATORLOOSE", `^${src[t50.GTLT]}\\s*(${src[t50.LOOSEPLAIN]})$|^$`);
  createToken("COMPARATOR", `^${src[t50.GTLT]}\\s*(${src[t50.FULLPLAIN]})$|^$`);
  createToken("COMPARATORTRIM", `(\\s*)${src[t50.GTLT]}\\s*(${src[t50.LOOSEPLAIN]}|${src[t50.XRANGEPLAIN]})`, true);
  exports.comparatorTrimReplace = "$1$2$3";
  createToken("HYPHENRANGE", `^\\s*(${src[t50.XRANGEPLAIN]})\\s+-\\s+(${src[t50.XRANGEPLAIN]})\\s*$`);
  createToken("HYPHENRANGELOOSE", `^\\s*(${src[t50.XRANGEPLAINLOOSE]})\\s+-\\s+(${src[t50.XRANGEPLAINLOOSE]})\\s*$`);
  createToken("STAR", "(<|>)?=?\\s*\\*");
  createToken("GTE0", "^\\s*>=\\s*0\\.0\\.0\\s*$");
  createToken("GTE0PRE", "^\\s*>=\\s*0\\.0\\.0-0\\s*$");
})(re$3, re$3.exports);
var reExports = re$3.exports;
const looseOption = Object.freeze({ loose: true });
const emptyOpts = Object.freeze({});
const parseOptions$1 = (options2) => {
  if (!options2) {
    return emptyOpts;
  }
  if (typeof options2 !== "object") {
    return looseOption;
  }
  return options2;
};
var parseOptions_1 = parseOptions$1;
const numeric$1 = /^[0-9]+$/;
const compareIdentifiers$1 = (a3, b2) => {
  const anum = numeric$1.test(a3);
  const bnum = numeric$1.test(b2);
  if (anum && bnum) {
    a3 = +a3;
    b2 = +b2;
  }
  return a3 === b2 ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a3 < b2 ? -1 : 1;
};
const rcompareIdentifiers = (a3, b2) => compareIdentifiers$1(b2, a3);
var identifiers = {
  compareIdentifiers: compareIdentifiers$1,
  rcompareIdentifiers
};
const debug = debug_1$1;
const { MAX_LENGTH, MAX_SAFE_INTEGER } = constants$1;
const { safeRe: re$2, t: t$4 } = reExports;
const parseOptions = parseOptions_1;
const { compareIdentifiers } = identifiers;
let SemVer$2 = class SemVer {
  constructor(version2, options2) {
    options2 = parseOptions(options2);
    if (version2 instanceof SemVer) {
      if (version2.loose === !!options2.loose && version2.includePrerelease === !!options2.includePrerelease) {
        return version2;
      } else {
        version2 = version2.version;
      }
    } else if (typeof version2 !== "string") {
      throw new TypeError(`Invalid version. Must be a string. Got type "${typeof version2}".`);
    }
    if (version2.length > MAX_LENGTH) {
      throw new TypeError(
        `version is longer than ${MAX_LENGTH} characters`
      );
    }
    debug("SemVer", version2, options2);
    this.options = options2;
    this.loose = !!options2.loose;
    this.includePrerelease = !!options2.includePrerelease;
    const m3 = version2.trim().match(options2.loose ? re$2[t$4.LOOSE] : re$2[t$4.FULL]);
    if (!m3) {
      throw new TypeError(`Invalid Version: ${version2}`);
    }
    this.raw = version2;
    this.major = +m3[1];
    this.minor = +m3[2];
    this.patch = +m3[3];
    if (this.major > MAX_SAFE_INTEGER || this.major < 0) {
      throw new TypeError("Invalid major version");
    }
    if (this.minor > MAX_SAFE_INTEGER || this.minor < 0) {
      throw new TypeError("Invalid minor version");
    }
    if (this.patch > MAX_SAFE_INTEGER || this.patch < 0) {
      throw new TypeError("Invalid patch version");
    }
    if (!m3[4]) {
      this.prerelease = [];
    } else {
      this.prerelease = m3[4].split(".").map((id2) => {
        if (/^[0-9]+$/.test(id2)) {
          const num = +id2;
          if (num >= 0 && num < MAX_SAFE_INTEGER) {
            return num;
          }
        }
        return id2;
      });
    }
    this.build = m3[5] ? m3[5].split(".") : [];
    this.format();
  }
  format() {
    this.version = `${this.major}.${this.minor}.${this.patch}`;
    if (this.prerelease.length) {
      this.version += `-${this.prerelease.join(".")}`;
    }
    return this.version;
  }
  toString() {
    return this.version;
  }
  compare(other) {
    debug("SemVer.compare", this.version, this.options, other);
    if (!(other instanceof SemVer)) {
      if (typeof other === "string" && other === this.version) {
        return 0;
      }
      other = new SemVer(other, this.options);
    }
    if (other.version === this.version) {
      return 0;
    }
    return this.compareMain(other) || this.comparePre(other);
  }
  compareMain(other) {
    if (!(other instanceof SemVer)) {
      other = new SemVer(other, this.options);
    }
    return compareIdentifiers(this.major, other.major) || compareIdentifiers(this.minor, other.minor) || compareIdentifiers(this.patch, other.patch);
  }
  comparePre(other) {
    if (!(other instanceof SemVer)) {
      other = new SemVer(other, this.options);
    }
    if (this.prerelease.length && !other.prerelease.length) {
      return -1;
    } else if (!this.prerelease.length && other.prerelease.length) {
      return 1;
    } else if (!this.prerelease.length && !other.prerelease.length) {
      return 0;
    }
    let i2 = 0;
    do {
      const a3 = this.prerelease[i2];
      const b2 = other.prerelease[i2];
      debug("prerelease compare", i2, a3, b2);
      if (a3 === void 0 && b2 === void 0) {
        return 0;
      } else if (b2 === void 0) {
        return 1;
      } else if (a3 === void 0) {
        return -1;
      } else if (a3 === b2) {
        continue;
      } else {
        return compareIdentifiers(a3, b2);
      }
    } while (++i2);
  }
  compareBuild(other) {
    if (!(other instanceof SemVer)) {
      other = new SemVer(other, this.options);
    }
    let i2 = 0;
    do {
      const a3 = this.build[i2];
      const b2 = other.build[i2];
      debug("build compare", i2, a3, b2);
      if (a3 === void 0 && b2 === void 0) {
        return 0;
      } else if (b2 === void 0) {
        return 1;
      } else if (a3 === void 0) {
        return -1;
      } else if (a3 === b2) {
        continue;
      } else {
        return compareIdentifiers(a3, b2);
      }
    } while (++i2);
  }
  // preminor will bump the version up to the next minor release, and immediately
  // down to pre-release. premajor and prepatch work the same way.
  inc(release, identifier, identifierBase) {
    switch (release) {
      case "premajor":
        this.prerelease.length = 0;
        this.patch = 0;
        this.minor = 0;
        this.major++;
        this.inc("pre", identifier, identifierBase);
        break;
      case "preminor":
        this.prerelease.length = 0;
        this.patch = 0;
        this.minor++;
        this.inc("pre", identifier, identifierBase);
        break;
      case "prepatch":
        this.prerelease.length = 0;
        this.inc("patch", identifier, identifierBase);
        this.inc("pre", identifier, identifierBase);
        break;
      case "prerelease":
        if (this.prerelease.length === 0) {
          this.inc("patch", identifier, identifierBase);
        }
        this.inc("pre", identifier, identifierBase);
        break;
      case "major":
        if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
          this.major++;
        }
        this.minor = 0;
        this.patch = 0;
        this.prerelease = [];
        break;
      case "minor":
        if (this.patch !== 0 || this.prerelease.length === 0) {
          this.minor++;
        }
        this.patch = 0;
        this.prerelease = [];
        break;
      case "patch":
        if (this.prerelease.length === 0) {
          this.patch++;
        }
        this.prerelease = [];
        break;
      case "pre": {
        const base = Number(identifierBase) ? 1 : 0;
        if (!identifier && identifierBase === false) {
          throw new Error("invalid increment argument: identifier is empty");
        }
        if (this.prerelease.length === 0) {
          this.prerelease = [base];
        } else {
          let i2 = this.prerelease.length;
          while (--i2 >= 0) {
            if (typeof this.prerelease[i2] === "number") {
              this.prerelease[i2]++;
              i2 = -2;
            }
          }
          if (i2 === -1) {
            if (identifier === this.prerelease.join(".") && identifierBase === false) {
              throw new Error("invalid increment argument: identifier already exists");
            }
            this.prerelease.push(base);
          }
        }
        if (identifier) {
          let prerelease = [identifier, base];
          if (identifierBase === false) {
            prerelease = [identifier];
          }
          if (compareIdentifiers(this.prerelease[0], identifier) === 0) {
            if (isNaN(this.prerelease[1])) {
              this.prerelease = prerelease;
            }
          } else {
            this.prerelease = prerelease;
          }
        }
        break;
      }
      default:
        throw new Error(`invalid increment argument: ${release}`);
    }
    this.raw = this.format();
    if (this.build.length) {
      this.raw += `+${this.build.join(".")}`;
    }
    return this;
  }
};
var semver = SemVer$2;
const SemVer$1 = semver;
const parse$3 = (version2, options2, throwErrors = false) => {
  if (version2 instanceof SemVer$1) {
    return version2;
  }
  try {
    return new SemVer$1(version2, options2);
  } catch (er) {
    if (!throwErrors) {
      return null;
    }
    throw er;
  }
};
var parse_1$1 = parse$3;
const parse$2 = parse_1$1;
const valid = (version2, options2) => {
  const v2 = parse$2(version2, options2);
  return v2 ? v2.version : null;
};
var valid_1 = valid;
const valid$1 = /* @__PURE__ */ getDefaultExportFromCjs(valid_1);
const SemVer2 = semver;
const major = (a3, loose) => new SemVer2(a3, loose).major;
var major_1 = major;
const major$1 = /* @__PURE__ */ getDefaultExportFromCjs(major_1);
class ProxyBus {
  bus;
  constructor(bus2) {
    if (typeof bus2.getVersion !== "function" || !valid$1(bus2.getVersion())) {
      console.warn("Proxying an event bus with an unknown or invalid version");
    } else if (major$1(bus2.getVersion()) !== major$1(this.getVersion())) {
      console.warn(
        "Proxying an event bus of version " + bus2.getVersion() + " with " + this.getVersion()
      );
    }
    this.bus = bus2;
  }
  getVersion() {
    return "3.3.1";
  }
  subscribe(name, handler9) {
    this.bus.subscribe(name, handler9);
  }
  unsubscribe(name, handler9) {
    this.bus.unsubscribe(name, handler9);
  }
  emit(name, event) {
    this.bus.emit(name, event);
  }
}
class SimpleBus {
  handlers = /* @__PURE__ */ new Map();
  getVersion() {
    return "3.3.1";
  }
  subscribe(name, handler9) {
    this.handlers.set(
      name,
      (this.handlers.get(name) || []).concat(
        handler9
      )
    );
  }
  unsubscribe(name, handler9) {
    this.handlers.set(
      name,
      (this.handlers.get(name) || []).filter((h3) => h3 !== handler9)
    );
  }
  emit(name, event) {
    (this.handlers.get(name) || []).forEach((h3) => {
      try {
        h3(event);
      } catch (e2) {
        console.error("could not invoke event listener", e2);
      }
    });
  }
}
let bus = null;
function getBus() {
  if (bus !== null) {
    return bus;
  }
  if (typeof window === "undefined") {
    return new Proxy({}, {
      get: () => {
        return () => console.error(
          "Window not available, EventBus can not be established!"
        );
      }
    });
  }
  if (window.OC?._eventBus && typeof window._nc_event_bus === "undefined") {
    console.warn(
      "found old event bus instance at OC._eventBus. Update your version!"
    );
    window._nc_event_bus = window.OC._eventBus;
  }
  if (typeof window?._nc_event_bus !== "undefined") {
    bus = new ProxyBus(window._nc_event_bus);
  } else {
    bus = window._nc_event_bus = new SimpleBus();
  }
  return bus;
}
function subscribe(name, handler9) {
  getBus().subscribe(name, handler9);
}
function unsubscribe(name, handler9) {
  getBus().unsubscribe(name, handler9);
}
function emit(name, event) {
  getBus().emit(name, event);
}
var dist$3 = {};
var storagebuilder = {};
var scopedstorage = {};
Object.defineProperty(scopedstorage, "__esModule", {
  value: true
});
scopedstorage.default = void 0;
function _defineProperty$7(obj, key, value3) {
  key = _toPropertyKey$4(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value: value3, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value3;
  }
  return obj;
}
function _toPropertyKey$4(t50) {
  var i2 = _toPrimitive$4(t50, "string");
  return "symbol" == typeof i2 ? i2 : i2 + "";
}
function _toPrimitive$4(t50, r2) {
  if ("object" != typeof t50 || !t50) return t50;
  var e2 = t50[Symbol.toPrimitive];
  if (void 0 !== e2) {
    var i2 = e2.call(t50, r2 || "default");
    if ("object" != typeof i2) return i2;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return ("string" === r2 ? String : Number)(t50);
}
class ScopedStorage {
  constructor(scope, wrapped, persistent) {
    _defineProperty$7(this, "scope", void 0);
    _defineProperty$7(this, "wrapped", void 0);
    this.scope = "".concat(persistent ? ScopedStorage.GLOBAL_SCOPE_PERSISTENT : ScopedStorage.GLOBAL_SCOPE_VOLATILE, "_").concat(btoa(scope), "_");
    this.wrapped = wrapped;
  }
  scopeKey(key) {
    return "".concat(this.scope).concat(key);
  }
  setItem(key, value3) {
    this.wrapped.setItem(this.scopeKey(key), value3);
  }
  getItem(key) {
    return this.wrapped.getItem(this.scopeKey(key));
  }
  removeItem(key) {
    this.wrapped.removeItem(this.scopeKey(key));
  }
  clear() {
    Object.keys(this.wrapped).filter((key) => key.startsWith(this.scope)).map(this.wrapped.removeItem.bind(this.wrapped));
  }
}
scopedstorage.default = ScopedStorage;
_defineProperty$7(ScopedStorage, "GLOBAL_SCOPE_VOLATILE", "nextcloud_vol");
_defineProperty$7(ScopedStorage, "GLOBAL_SCOPE_PERSISTENT", "nextcloud_per");
Object.defineProperty(storagebuilder, "__esModule", {
  value: true
});
storagebuilder.default = void 0;
var _scopedstorage$1 = _interopRequireDefault$1(scopedstorage);
function _interopRequireDefault$1(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}
function _defineProperty$6(obj, key, value3) {
  key = _toPropertyKey$3(key);
  if (key in obj) {
    Object.defineProperty(obj, key, { value: value3, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value3;
  }
  return obj;
}
function _toPropertyKey$3(t50) {
  var i2 = _toPrimitive$3(t50, "string");
  return "symbol" == typeof i2 ? i2 : i2 + "";
}
function _toPrimitive$3(t50, r2) {
  if ("object" != typeof t50 || !t50) return t50;
  var e2 = t50[Symbol.toPrimitive];
  if (void 0 !== e2) {
    var i2 = e2.call(t50, r2 || "default");
    if ("object" != typeof i2) return i2;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return ("string" === r2 ? String : Number)(t50);
}
class StorageBuilder {
  constructor(appId) {
    _defineProperty$6(this, "appId", void 0);
    _defineProperty$6(this, "persisted", false);
    _defineProperty$6(this, "clearedOnLogout", false);
    this.appId = appId;
  }
  persist() {
    let persist = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : true;
    this.persisted = persist;
    return this;
  }
  clearOnLogout() {
    let clear2 = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : true;
    this.clearedOnLogout = clear2;
    return this;
  }
  build() {
    return new _scopedstorage$1.default(this.appId, this.persisted ? window.localStorage : window.sessionStorage, !this.clearedOnLogout);
  }
}
storagebuilder.default = StorageBuilder;
Object.defineProperty(dist$3, "__esModule", {
  value: true
});
dist$3.clearAll = clearAll;
dist$3.clearNonPersistent = clearNonPersistent;
var getBuilder_1 = dist$3.getBuilder = getBuilder;
var _storagebuilder = _interopRequireDefault(storagebuilder);
var _scopedstorage = _interopRequireDefault(scopedstorage);
function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}
function getBuilder(appId) {
  return new _storagebuilder.default(appId);
}
function clearStorage(storage2, pred) {
  Object.keys(storage2).filter((k2) => pred ? pred(k2) : true).map(storage2.removeItem.bind(storage2));
}
function clearAll() {
  const storages = [window.sessionStorage, window.localStorage];
  storages.map((s3) => clearStorage(s3));
}
function clearNonPersistent() {
  const storages = [window.sessionStorage, window.localStorage];
  storages.map((s3) => clearStorage(s3, (k2) => !k2.startsWith(_scopedstorage.default.GLOBAL_SCOPE_PERSISTENT)));
}
let token;
const observers = [];
function getRequestToken() {
  if (token === void 0) {
    token = document.head.dataset.requesttoken ?? null;
  }
  return token;
}
function onRequestTokenUpdate(observer) {
  observers.push(observer);
}
subscribe("csrf-token-update", (e2) => {
  token = e2.token;
  observers.forEach((observer) => {
    try {
      observer(token);
    } catch (e22) {
      console.error("Error updating CSRF token observer", e22);
    }
  });
});
function getCSPNonce() {
  const meta = document?.querySelector('meta[name="csp-nonce"]');
  if (!meta) {
    const token2 = getRequestToken();
    return token2 ? btoa(token2) : void 0;
  }
  return meta.nonce;
}
const browserStorage$1 = getBuilder_1("public").persist().build();
function getGuestNickname() {
  return browserStorage$1.getItem("guestNickname");
}
function setGuestNickname(nickname) {
  browserStorage$1.setItem("guestNickname", nickname);
}
let currentUser;
const getAttribute = (el, attribute) => {
  if (el) {
    return el.getAttribute(attribute);
  }
  return null;
};
function getCurrentUser() {
  if (currentUser !== void 0) {
    return currentUser;
  }
  const head = document?.getElementsByTagName("head")[0];
  if (!head) {
    return null;
  }
  const uid2 = getAttribute(head, "data-user");
  if (uid2 === null) {
    currentUser = null;
    return currentUser;
  }
  currentUser = {
    uid: uid2,
    displayName: getAttribute(head, "data-user-displayname"),
    isAdmin: !!window._oc_isadmin
  };
  return currentUser;
}
const dist$2 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  getCSPNonce,
  getCurrentUser,
  getGuestNickname,
  getRequestToken,
  onRequestTokenUpdate,
  setGuestNickname
}, Symbol.toStringTag, { value: "Module" }));
const g$2 = (n2) => "/remote.php/" + n2, U$2 = (n2, e2) => {
  var o2;
  return ((o2 = void 0) != null ? o2 : w$2()) + g$2(n2);
}, v$2 = (n2, e2, o2) => {
  var c2;
  const i2 = Object.assign({
    ocsVersion: 2
  }, {}).ocsVersion === 1 ? 1 : 2;
  return ((c2 = void 0) != null ? c2 : w$2()) + "/ocs/v" + i2 + ".php" + u$2(n2, e2);
}, u$2 = (n2, e2, o2) => {
  const c2 = Object.assign({
    escape: true
  }, {}), r2 = function(i2, s3) {
    return s3 = s3 || {}, i2.replace(
      /{([^{}]*)}/g,
      function(l2, t50) {
        const a3 = s3[t50];
        return c2.escape ? encodeURIComponent(typeof a3 == "string" || typeof a3 == "number" ? a3.toString() : l2) : typeof a3 == "string" || typeof a3 == "number" ? a3.toString() : l2;
      }
    );
  };
  return n2.charAt(0) !== "/" && (n2 = "/" + n2), r2(n2, e2 || {});
}, _$2 = (n2, e2, o2) => {
  var c2, r2, i2;
  const s3 = Object.assign({
    noRewrite: false
  }, {}), l2 = (c2 = void 0) != null ? c2 : f$2();
  return ((i2 = (r2 = window == null ? void 0 : window.OC) == null ? void 0 : r2.config) == null ? void 0 : i2.modRewriteWorking) === true && !s3.noRewrite ? l2 + u$2(n2, e2) : l2 + "/index.php" + u$2(n2, e2);
}, h$2 = (n2, e2) => e2.includes(".") ? d$2(n2, "img", e2) : d$2(n2, "img", "".concat(e2, ".svg")), d$2 = (n2, e2, o2) => {
  var c2, r2, i2;
  const s3 = (i2 = (r2 = (c2 = window == null ? void 0 : window.OC) == null ? void 0 : c2.coreApps) == null ? void 0 : r2.includes(n2)) != null ? i2 : false, l2 = o2.slice(-3) === "php";
  let t50 = f$2();
  return l2 && !s3 ? (t50 += "/index.php/apps/".concat(n2), t50 += "/".concat(encodeURI(e2)), o2 !== "index.php" && (t50 += "/".concat(o2))) : !l2 && !s3 ? (t50 = b$2(n2), t50 += "/".concat(e2, "/"), t50.at(-1) !== "/" && (t50 += "/"), t50 += o2) : ((n2 === "settings" || n2 === "core" || n2 === "search") && e2 === "ajax" && (t50 += "/index.php"), n2 && (t50 += "/".concat(n2)), t50 += "/".concat(e2), t50 += "/".concat(o2)), t50;
}, w$2 = () => window.location.protocol + "//" + window.location.host + f$2();
function f$2() {
  let n2 = window._oc_webroot;
  if (typeof n2 > "u") {
    n2 = location.pathname;
    const e2 = n2.indexOf("/index.php/");
    if (e2 !== -1)
      n2 = n2.slice(0, e2);
    else {
      const o2 = n2.indexOf("/", 1);
      n2 = n2.slice(0, o2 > 0 ? o2 : void 0);
    }
  }
  return n2;
}
function b$2(n2) {
  var e2, o2;
  return (o2 = ((e2 = window._oc_appswebroots) != null ? e2 : {})[n2]) != null ? o2 : "";
}
const RETRY_KEY = Symbol("csrf-retry");
const onError$2 = (axios2) => async (error) => {
  var _a2;
  const { config: config2, response, request } = error;
  const responseURL = request == null ? void 0 : request.responseURL;
  const status = response == null ? void 0 : response.status;
  if (status === 412 && ((_a2 = response == null ? void 0 : response.data) == null ? void 0 : _a2.message) === "CSRF check failed" && config2[RETRY_KEY] === void 0) {
    console.warn("Request to ".concat(responseURL, " failed because of a CSRF mismatch. Fetching a new token"));
    const { data: { token: token2 } } = await axios2.get(_$2("/csrftoken"));
    console.debug("New request token ".concat(token2, " fetched"));
    axios2.defaults.headers.requesttoken = token2;
    return axios2({
      ...config2,
      headers: {
        ...config2.headers,
        requesttoken: token2
      },
      [RETRY_KEY]: true
    });
  }
  return Promise.reject(error);
};
const RETRY_DELAY_KEY = Symbol("retryDelay");
const onError$1 = (axios2) => async (error) => {
  var _a2;
  const { config: config2, response, request } = error;
  const responseURL = request == null ? void 0 : request.responseURL;
  const status = response == null ? void 0 : response.status;
  const headers = response == null ? void 0 : response.headers;
  if (status === 503 && headers["x-nextcloud-maintenance-mode"] === "1" && config2.retryIfMaintenanceMode && (!config2[RETRY_DELAY_KEY] || config2[RETRY_DELAY_KEY] <= 32)) {
    const retryDelay = ((_a2 = config2[RETRY_DELAY_KEY]) != null ? _a2 : 1) * 2;
    console.warn("Request to ".concat(responseURL, " failed because of maintenance mode. Retrying in ").concat(retryDelay, "s"));
    await new Promise((resolve4) => {
      setTimeout(resolve4, retryDelay * 1e3);
    });
    return axios2({
      ...config2,
      [RETRY_DELAY_KEY]: retryDelay
    });
  }
  return Promise.reject(error);
};
const onError = async (error) => {
  var _a2;
  const { config: config2, response, request } = error;
  const responseURL = request == null ? void 0 : request.responseURL;
  const status = response == null ? void 0 : response.status;
  if (status === 401 && ((_a2 = response == null ? void 0 : response.data) == null ? void 0 : _a2.message) === "Current user is not logged in" && config2.reloadExpiredSession && (window == null ? void 0 : window.location)) {
    console.error("Request to ".concat(responseURL, " failed because the user session expired. Reloading the page …"));
    window.location.reload();
  }
  return Promise.reject(error);
};
var _a$1;
const client = axios.create({
  headers: {
    requesttoken: (_a$1 = getRequestToken()) != null ? _a$1 : "",
    "X-Requested-With": "XMLHttpRequest"
  }
});
const cancelableClient = Object.assign(client, {
  CancelToken: axios.CancelToken,
  isCancel: axios.isCancel
});
cancelableClient.interceptors.response.use((r2) => r2, onError$2(cancelableClient));
cancelableClient.interceptors.response.use((r2) => r2, onError$1(cancelableClient));
cancelableClient.interceptors.response.use((r2) => r2, onError);
onRequestTokenUpdate((token2) => {
  client.defaults.headers.requesttoken = token2;
});
function assertPath(path2) {
  if (typeof path2 !== "string") {
    throw new TypeError("Path must be a string. Received " + JSON.stringify(path2));
  }
}
function normalizeStringPosix(path2, allowAboveRoot) {
  var res = "";
  var lastSegmentLength = 0;
  var lastSlash = -1;
  var dots = 0;
  var code2;
  for (var i2 = 0; i2 <= path2.length; ++i2) {
    if (i2 < path2.length)
      code2 = path2.charCodeAt(i2);
    else if (code2 === 47)
      break;
    else
      code2 = 47;
    if (code2 === 47) {
      if (lastSlash === i2 - 1 || dots === 1) ;
      else if (lastSlash !== i2 - 1 && dots === 2) {
        if (res.length < 2 || lastSegmentLength !== 2 || res.charCodeAt(res.length - 1) !== 46 || res.charCodeAt(res.length - 2) !== 46) {
          if (res.length > 2) {
            var lastSlashIndex = res.lastIndexOf("/");
            if (lastSlashIndex !== res.length - 1) {
              if (lastSlashIndex === -1) {
                res = "";
                lastSegmentLength = 0;
              } else {
                res = res.slice(0, lastSlashIndex);
                lastSegmentLength = res.length - 1 - res.lastIndexOf("/");
              }
              lastSlash = i2;
              dots = 0;
              continue;
            }
          } else if (res.length === 2 || res.length === 1) {
            res = "";
            lastSegmentLength = 0;
            lastSlash = i2;
            dots = 0;
            continue;
          }
        }
        if (allowAboveRoot) {
          if (res.length > 0)
            res += "/..";
          else
            res = "..";
          lastSegmentLength = 2;
        }
      } else {
        if (res.length > 0)
          res += "/" + path2.slice(lastSlash + 1, i2);
        else
          res = path2.slice(lastSlash + 1, i2);
        lastSegmentLength = i2 - lastSlash - 1;
      }
      lastSlash = i2;
      dots = 0;
    } else if (code2 === 46 && dots !== -1) {
      ++dots;
    } else {
      dots = -1;
    }
  }
  return res;
}
function _format(sep, pathObject) {
  var dir = pathObject.dir || pathObject.root;
  var base = pathObject.base || (pathObject.name || "") + (pathObject.ext || "");
  if (!dir) {
    return base;
  }
  if (dir === pathObject.root) {
    return dir + base;
  }
  return dir + sep + base;
}
var posix$1 = {
  // path.resolve([from ...], to)
  resolve: function resolve() {
    var resolvedPath = "";
    var resolvedAbsolute = false;
    var cwd;
    for (var i2 = arguments.length - 1; i2 >= -1 && !resolvedAbsolute; i2--) {
      var path2;
      if (i2 >= 0)
        path2 = arguments[i2];
      else {
        if (cwd === void 0)
          cwd = process$1$1.cwd();
        path2 = cwd;
      }
      assertPath(path2);
      if (path2.length === 0) {
        continue;
      }
      resolvedPath = path2 + "/" + resolvedPath;
      resolvedAbsolute = path2.charCodeAt(0) === 47;
    }
    resolvedPath = normalizeStringPosix(resolvedPath, !resolvedAbsolute);
    if (resolvedAbsolute) {
      if (resolvedPath.length > 0)
        return "/" + resolvedPath;
      else
        return "/";
    } else if (resolvedPath.length > 0) {
      return resolvedPath;
    } else {
      return ".";
    }
  },
  normalize: function normalize(path2) {
    assertPath(path2);
    if (path2.length === 0) return ".";
    var isAbsolute2 = path2.charCodeAt(0) === 47;
    var trailingSeparator = path2.charCodeAt(path2.length - 1) === 47;
    path2 = normalizeStringPosix(path2, !isAbsolute2);
    if (path2.length === 0 && !isAbsolute2) path2 = ".";
    if (path2.length > 0 && trailingSeparator) path2 += "/";
    if (isAbsolute2) return "/" + path2;
    return path2;
  },
  isAbsolute: function isAbsolute(path2) {
    assertPath(path2);
    return path2.length > 0 && path2.charCodeAt(0) === 47;
  },
  join: function join() {
    if (arguments.length === 0)
      return ".";
    var joined;
    for (var i2 = 0; i2 < arguments.length; ++i2) {
      var arg = arguments[i2];
      assertPath(arg);
      if (arg.length > 0) {
        if (joined === void 0)
          joined = arg;
        else
          joined += "/" + arg;
      }
    }
    if (joined === void 0)
      return ".";
    return posix$1.normalize(joined);
  },
  relative: function relative(from, to) {
    assertPath(from);
    assertPath(to);
    if (from === to) return "";
    from = posix$1.resolve(from);
    to = posix$1.resolve(to);
    if (from === to) return "";
    var fromStart = 1;
    for (; fromStart < from.length; ++fromStart) {
      if (from.charCodeAt(fromStart) !== 47)
        break;
    }
    var fromEnd = from.length;
    var fromLen = fromEnd - fromStart;
    var toStart = 1;
    for (; toStart < to.length; ++toStart) {
      if (to.charCodeAt(toStart) !== 47)
        break;
    }
    var toEnd = to.length;
    var toLen = toEnd - toStart;
    var length = fromLen < toLen ? fromLen : toLen;
    var lastCommonSep = -1;
    var i2 = 0;
    for (; i2 <= length; ++i2) {
      if (i2 === length) {
        if (toLen > length) {
          if (to.charCodeAt(toStart + i2) === 47) {
            return to.slice(toStart + i2 + 1);
          } else if (i2 === 0) {
            return to.slice(toStart + i2);
          }
        } else if (fromLen > length) {
          if (from.charCodeAt(fromStart + i2) === 47) {
            lastCommonSep = i2;
          } else if (i2 === 0) {
            lastCommonSep = 0;
          }
        }
        break;
      }
      var fromCode = from.charCodeAt(fromStart + i2);
      var toCode = to.charCodeAt(toStart + i2);
      if (fromCode !== toCode)
        break;
      else if (fromCode === 47)
        lastCommonSep = i2;
    }
    var out = "";
    for (i2 = fromStart + lastCommonSep + 1; i2 <= fromEnd; ++i2) {
      if (i2 === fromEnd || from.charCodeAt(i2) === 47) {
        if (out.length === 0)
          out += "..";
        else
          out += "/..";
      }
    }
    if (out.length > 0)
      return out + to.slice(toStart + lastCommonSep);
    else {
      toStart += lastCommonSep;
      if (to.charCodeAt(toStart) === 47)
        ++toStart;
      return to.slice(toStart);
    }
  },
  _makeLong: function _makeLong(path2) {
    return path2;
  },
  dirname: function dirname(path2) {
    assertPath(path2);
    if (path2.length === 0) return ".";
    var code2 = path2.charCodeAt(0);
    var hasRoot = code2 === 47;
    var end = -1;
    var matchedSlash = true;
    for (var i2 = path2.length - 1; i2 >= 1; --i2) {
      code2 = path2.charCodeAt(i2);
      if (code2 === 47) {
        if (!matchedSlash) {
          end = i2;
          break;
        }
      } else {
        matchedSlash = false;
      }
    }
    if (end === -1) return hasRoot ? "/" : ".";
    if (hasRoot && end === 1) return "//";
    return path2.slice(0, end);
  },
  basename: function basename(path2, ext) {
    if (ext !== void 0 && typeof ext !== "string") throw new TypeError('"ext" argument must be a string');
    assertPath(path2);
    var start = 0;
    var end = -1;
    var matchedSlash = true;
    var i2;
    if (ext !== void 0 && ext.length > 0 && ext.length <= path2.length) {
      if (ext.length === path2.length && ext === path2) return "";
      var extIdx = ext.length - 1;
      var firstNonSlashEnd = -1;
      for (i2 = path2.length - 1; i2 >= 0; --i2) {
        var code2 = path2.charCodeAt(i2);
        if (code2 === 47) {
          if (!matchedSlash) {
            start = i2 + 1;
            break;
          }
        } else {
          if (firstNonSlashEnd === -1) {
            matchedSlash = false;
            firstNonSlashEnd = i2 + 1;
          }
          if (extIdx >= 0) {
            if (code2 === ext.charCodeAt(extIdx)) {
              if (--extIdx === -1) {
                end = i2;
              }
            } else {
              extIdx = -1;
              end = firstNonSlashEnd;
            }
          }
        }
      }
      if (start === end) end = firstNonSlashEnd;
      else if (end === -1) end = path2.length;
      return path2.slice(start, end);
    } else {
      for (i2 = path2.length - 1; i2 >= 0; --i2) {
        if (path2.charCodeAt(i2) === 47) {
          if (!matchedSlash) {
            start = i2 + 1;
            break;
          }
        } else if (end === -1) {
          matchedSlash = false;
          end = i2 + 1;
        }
      }
      if (end === -1) return "";
      return path2.slice(start, end);
    }
  },
  extname: function extname(path2) {
    assertPath(path2);
    var startDot = -1;
    var startPart = 0;
    var end = -1;
    var matchedSlash = true;
    var preDotState = 0;
    for (var i2 = path2.length - 1; i2 >= 0; --i2) {
      var code2 = path2.charCodeAt(i2);
      if (code2 === 47) {
        if (!matchedSlash) {
          startPart = i2 + 1;
          break;
        }
        continue;
      }
      if (end === -1) {
        matchedSlash = false;
        end = i2 + 1;
      }
      if (code2 === 46) {
        if (startDot === -1)
          startDot = i2;
        else if (preDotState !== 1)
          preDotState = 1;
      } else if (startDot !== -1) {
        preDotState = -1;
      }
    }
    if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
    preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
    preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
      return "";
    }
    return path2.slice(startDot, end);
  },
  format: function format(pathObject) {
    if (pathObject === null || typeof pathObject !== "object") {
      throw new TypeError('The "pathObject" argument must be of type Object. Received type ' + typeof pathObject);
    }
    return _format("/", pathObject);
  },
  parse: function parse(path2) {
    assertPath(path2);
    var ret = { root: "", dir: "", base: "", ext: "", name: "" };
    if (path2.length === 0) return ret;
    var code2 = path2.charCodeAt(0);
    var isAbsolute2 = code2 === 47;
    var start;
    if (isAbsolute2) {
      ret.root = "/";
      start = 1;
    } else {
      start = 0;
    }
    var startDot = -1;
    var startPart = 0;
    var end = -1;
    var matchedSlash = true;
    var i2 = path2.length - 1;
    var preDotState = 0;
    for (; i2 >= start; --i2) {
      code2 = path2.charCodeAt(i2);
      if (code2 === 47) {
        if (!matchedSlash) {
          startPart = i2 + 1;
          break;
        }
        continue;
      }
      if (end === -1) {
        matchedSlash = false;
        end = i2 + 1;
      }
      if (code2 === 46) {
        if (startDot === -1) startDot = i2;
        else if (preDotState !== 1) preDotState = 1;
      } else if (startDot !== -1) {
        preDotState = -1;
      }
    }
    if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
    preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
    preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
      if (end !== -1) {
        if (startPart === 0 && isAbsolute2) ret.base = ret.name = path2.slice(1, end);
        else ret.base = ret.name = path2.slice(startPart, end);
      }
    } else {
      if (startPart === 0 && isAbsolute2) {
        ret.name = path2.slice(1, startDot);
        ret.base = path2.slice(1, end);
      } else {
        ret.name = path2.slice(startPart, startDot);
        ret.base = path2.slice(startPart, end);
      }
      ret.ext = path2.slice(startDot, end);
    }
    if (startPart > 0) ret.dir = path2.slice(0, startPart - 1);
    else if (isAbsolute2) ret.dir = "/";
    return ret;
  },
  sep: "/",
  delimiter: ":",
  win32: null,
  posix: null
};
posix$1.posix = posix$1;
var pathBrowserify = posix$1;
var toastify = { exports: {} };
/*!
 * Toastify js 1.12.0
 * https://github.com/apvarun/toastify-js
 * @license MIT licensed
 *
 * Copyright (C) 2018 Varun A P
 */
(function(module) {
  (function(root2, factory) {
    if (module.exports) {
      module.exports = factory();
    } else {
      root2.Toastify = factory();
    }
  })(commonjsGlobal, function(global2) {
    var Toastify2 = function(options2) {
      return new Toastify2.lib.init(options2);
    }, version2 = "1.12.0";
    Toastify2.defaults = {
      oldestFirst: true,
      text: "Toastify is awesome!",
      node: void 0,
      duration: 3e3,
      selector: void 0,
      callback: function() {
      },
      destination: void 0,
      newWindow: false,
      close: false,
      gravity: "toastify-top",
      positionLeft: false,
      position: "",
      backgroundColor: "",
      avatar: "",
      className: "",
      stopOnFocus: true,
      onClick: function() {
      },
      offset: { x: 0, y: 0 },
      escapeMarkup: true,
      ariaLive: "polite",
      style: { background: "" }
    };
    Toastify2.lib = Toastify2.prototype = {
      toastify: version2,
      constructor: Toastify2,
      // Initializing the object with required parameters
      init: function(options2) {
        if (!options2) {
          options2 = {};
        }
        this.options = {};
        this.toastElement = null;
        this.options.text = options2.text || Toastify2.defaults.text;
        this.options.node = options2.node || Toastify2.defaults.node;
        this.options.duration = options2.duration === 0 ? 0 : options2.duration || Toastify2.defaults.duration;
        this.options.selector = options2.selector || Toastify2.defaults.selector;
        this.options.callback = options2.callback || Toastify2.defaults.callback;
        this.options.destination = options2.destination || Toastify2.defaults.destination;
        this.options.newWindow = options2.newWindow || Toastify2.defaults.newWindow;
        this.options.close = options2.close || Toastify2.defaults.close;
        this.options.gravity = options2.gravity === "bottom" ? "toastify-bottom" : Toastify2.defaults.gravity;
        this.options.positionLeft = options2.positionLeft || Toastify2.defaults.positionLeft;
        this.options.position = options2.position || Toastify2.defaults.position;
        this.options.backgroundColor = options2.backgroundColor || Toastify2.defaults.backgroundColor;
        this.options.avatar = options2.avatar || Toastify2.defaults.avatar;
        this.options.className = options2.className || Toastify2.defaults.className;
        this.options.stopOnFocus = options2.stopOnFocus === void 0 ? Toastify2.defaults.stopOnFocus : options2.stopOnFocus;
        this.options.onClick = options2.onClick || Toastify2.defaults.onClick;
        this.options.offset = options2.offset || Toastify2.defaults.offset;
        this.options.escapeMarkup = options2.escapeMarkup !== void 0 ? options2.escapeMarkup : Toastify2.defaults.escapeMarkup;
        this.options.ariaLive = options2.ariaLive || Toastify2.defaults.ariaLive;
        this.options.style = options2.style || Toastify2.defaults.style;
        if (options2.backgroundColor) {
          this.options.style.background = options2.backgroundColor;
        }
        return this;
      },
      // Building the DOM element
      buildToast: function() {
        if (!this.options) {
          throw "Toastify is not initialized";
        }
        var divElement = document.createElement("div");
        divElement.className = "toastify on " + this.options.className;
        if (!!this.options.position) {
          divElement.className += " toastify-" + this.options.position;
        } else {
          if (this.options.positionLeft === true) {
            divElement.className += " toastify-left";
            console.warn("Property `positionLeft` will be depreciated in further versions. Please use `position` instead.");
          } else {
            divElement.className += " toastify-right";
          }
        }
        divElement.className += " " + this.options.gravity;
        if (this.options.backgroundColor) {
          console.warn('DEPRECATION NOTICE: "backgroundColor" is being deprecated. Please use the "style.background" property.');
        }
        for (var property in this.options.style) {
          divElement.style[property] = this.options.style[property];
        }
        if (this.options.ariaLive) {
          divElement.setAttribute("aria-live", this.options.ariaLive);
        }
        if (this.options.node && this.options.node.nodeType === Node.ELEMENT_NODE) {
          divElement.appendChild(this.options.node);
        } else {
          if (this.options.escapeMarkup) {
            divElement.innerText = this.options.text;
          } else {
            divElement.innerHTML = this.options.text;
          }
          if (this.options.avatar !== "") {
            var avatarElement = document.createElement("img");
            avatarElement.src = this.options.avatar;
            avatarElement.className = "toastify-avatar";
            if (this.options.position == "left" || this.options.positionLeft === true) {
              divElement.appendChild(avatarElement);
            } else {
              divElement.insertAdjacentElement("afterbegin", avatarElement);
            }
          }
        }
        if (this.options.close === true) {
          var closeElement = document.createElement("button");
          closeElement.type = "button";
          closeElement.setAttribute("aria-label", "Close");
          closeElement.className = "toast-close";
          closeElement.innerHTML = "&#10006;";
          closeElement.addEventListener(
            "click",
            function(event) {
              event.stopPropagation();
              this.removeElement(this.toastElement);
              window.clearTimeout(this.toastElement.timeOutValue);
            }.bind(this)
          );
          var width = window.innerWidth > 0 ? window.innerWidth : screen.width;
          if ((this.options.position == "left" || this.options.positionLeft === true) && width > 360) {
            divElement.insertAdjacentElement("afterbegin", closeElement);
          } else {
            divElement.appendChild(closeElement);
          }
        }
        if (this.options.stopOnFocus && this.options.duration > 0) {
          var self2 = this;
          divElement.addEventListener(
            "mouseover",
            function(event) {
              window.clearTimeout(divElement.timeOutValue);
            }
          );
          divElement.addEventListener(
            "mouseleave",
            function() {
              divElement.timeOutValue = window.setTimeout(
                function() {
                  self2.removeElement(divElement);
                },
                self2.options.duration
              );
            }
          );
        }
        if (typeof this.options.destination !== "undefined") {
          divElement.addEventListener(
            "click",
            function(event) {
              event.stopPropagation();
              if (this.options.newWindow === true) {
                window.open(this.options.destination, "_blank");
              } else {
                window.location = this.options.destination;
              }
            }.bind(this)
          );
        }
        if (typeof this.options.onClick === "function" && typeof this.options.destination === "undefined") {
          divElement.addEventListener(
            "click",
            function(event) {
              event.stopPropagation();
              this.options.onClick();
            }.bind(this)
          );
        }
        if (typeof this.options.offset === "object") {
          var x3 = getAxisOffsetAValue("x", this.options);
          var y2 = getAxisOffsetAValue("y", this.options);
          var xOffset = this.options.position == "left" ? x3 : "-" + x3;
          var yOffset = this.options.gravity == "toastify-top" ? y2 : "-" + y2;
          divElement.style.transform = "translate(" + xOffset + "," + yOffset + ")";
        }
        return divElement;
      },
      // Displaying the toast
      showToast: function() {
        this.toastElement = this.buildToast();
        var rootElement;
        if (typeof this.options.selector === "string") {
          rootElement = document.getElementById(this.options.selector);
        } else if (this.options.selector instanceof HTMLElement || typeof ShadowRoot !== "undefined" && this.options.selector instanceof ShadowRoot) {
          rootElement = this.options.selector;
        } else {
          rootElement = document.body;
        }
        if (!rootElement) {
          throw "Root element is not defined";
        }
        var elementToInsert = Toastify2.defaults.oldestFirst ? rootElement.firstChild : rootElement.lastChild;
        rootElement.insertBefore(this.toastElement, elementToInsert);
        Toastify2.reposition();
        if (this.options.duration > 0) {
          this.toastElement.timeOutValue = window.setTimeout(
            function() {
              this.removeElement(this.toastElement);
            }.bind(this),
            this.options.duration
          );
        }
        return this;
      },
      hideToast: function() {
        if (this.toastElement.timeOutValue) {
          clearTimeout(this.toastElement.timeOutValue);
        }
        this.removeElement(this.toastElement);
      },
      // Removing the element from the DOM
      removeElement: function(toastElement) {
        toastElement.className = toastElement.className.replace(" on", "");
        window.setTimeout(
          function() {
            if (this.options.node && this.options.node.parentNode) {
              this.options.node.parentNode.removeChild(this.options.node);
            }
            if (toastElement.parentNode) {
              toastElement.parentNode.removeChild(toastElement);
            }
            this.options.callback.call(toastElement);
            Toastify2.reposition();
          }.bind(this),
          400
        );
      }
    };
    Toastify2.reposition = function() {
      var topLeftOffsetSize = {
        top: 15,
        bottom: 15
      };
      var topRightOffsetSize = {
        top: 15,
        bottom: 15
      };
      var offsetSize = {
        top: 15,
        bottom: 15
      };
      var allToasts = document.getElementsByClassName("toastify");
      var classUsed;
      for (var i2 = 0; i2 < allToasts.length; i2++) {
        if (containsClass(allToasts[i2], "toastify-top") === true) {
          classUsed = "toastify-top";
        } else {
          classUsed = "toastify-bottom";
        }
        var height = allToasts[i2].offsetHeight;
        classUsed = classUsed.substr(9, classUsed.length - 1);
        var offset2 = 15;
        var width = window.innerWidth > 0 ? window.innerWidth : screen.width;
        if (width <= 360) {
          allToasts[i2].style[classUsed] = offsetSize[classUsed] + "px";
          offsetSize[classUsed] += height + offset2;
        } else {
          if (containsClass(allToasts[i2], "toastify-left") === true) {
            allToasts[i2].style[classUsed] = topLeftOffsetSize[classUsed] + "px";
            topLeftOffsetSize[classUsed] += height + offset2;
          } else {
            allToasts[i2].style[classUsed] = topRightOffsetSize[classUsed] + "px";
            topRightOffsetSize[classUsed] += height + offset2;
          }
        }
      }
      return this;
    };
    function getAxisOffsetAValue(axis, options2) {
      if (options2.offset[axis]) {
        if (isNaN(options2.offset[axis])) {
          return options2.offset[axis];
        } else {
          return options2.offset[axis] + "px";
        }
      }
      return "0px";
    }
    function containsClass(elem, yourClass) {
      if (!elem || typeof yourClass !== "string") {
        return false;
      } else if (elem.className && elem.className.trim().split(/\s+/gi).indexOf(yourClass) > -1) {
        return true;
      } else {
        return false;
      }
    }
    Toastify2.lib.init.prototype = Toastify2.lib;
    return Toastify2;
  });
})(toastify);
var toastifyExports = toastify.exports;
const Toastify = /* @__PURE__ */ getDefaultExportFromCjs(toastifyExports);
var FUNC_ERROR_TEXT = "Expected a function";
var HASH_UNDEFINED = "__lodash_hash_undefined__";
var INFINITY = 1 / 0;
var funcTag = "[object Function]", genTag = "[object GeneratorFunction]", symbolTag = "[object Symbol]";
var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp = /^\w*$/, reLeadingDot = /^\./, rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
var reEscapeChar = /\\(\\)?/g;
var reIsHostCtor = /^\[object .+?Constructor\]$/;
var freeGlobal = typeof commonjsGlobal == "object" && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
var freeSelf = typeof self == "object" && self && self.Object === Object && self;
var root = freeGlobal || freeSelf || Function("return this")();
function getValue(object, key) {
  return object == null ? void 0 : object[key];
}
function isHostObject(value3) {
  var result = false;
  if (value3 != null && typeof value3.toString != "function") {
    try {
      result = !!(value3 + "");
    } catch (e2) {
    }
  }
  return result;
}
var arrayProto = Array.prototype, funcProto = Function.prototype, objectProto = Object.prototype;
var coreJsData = root["__core-js_shared__"];
var maskSrcKey = function() {
  var uid2 = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || "");
  return uid2 ? "Symbol(src)_1." + uid2 : "";
}();
var funcToString = funcProto.toString;
var hasOwnProperty$2 = objectProto.hasOwnProperty;
var objectToString$1 = objectProto.toString;
var reIsNative = RegExp(
  "^" + funcToString.call(hasOwnProperty$2).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
);
var Symbol$2 = root.Symbol, splice = arrayProto.splice;
var Map$1 = getNative(root, "Map"), nativeCreate = getNative(Object, "create");
var symbolProto = Symbol$2 ? Symbol$2.prototype : void 0, symbolToString = symbolProto ? symbolProto.toString : void 0;
function Hash(entries2) {
  var index2 = -1, length = entries2 ? entries2.length : 0;
  this.clear();
  while (++index2 < length) {
    var entry = entries2[index2];
    this.set(entry[0], entry[1]);
  }
}
function hashClear() {
  this.__data__ = nativeCreate ? nativeCreate(null) : {};
}
function hashDelete(key) {
  return this.has(key) && delete this.__data__[key];
}
function hashGet(key) {
  var data12 = this.__data__;
  if (nativeCreate) {
    var result = data12[key];
    return result === HASH_UNDEFINED ? void 0 : result;
  }
  return hasOwnProperty$2.call(data12, key) ? data12[key] : void 0;
}
function hashHas(key) {
  var data12 = this.__data__;
  return nativeCreate ? data12[key] !== void 0 : hasOwnProperty$2.call(data12, key);
}
function hashSet(key, value3) {
  var data12 = this.__data__;
  data12[key] = nativeCreate && value3 === void 0 ? HASH_UNDEFINED : value3;
  return this;
}
Hash.prototype.clear = hashClear;
Hash.prototype["delete"] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;
function ListCache(entries2) {
  var index2 = -1, length = entries2 ? entries2.length : 0;
  this.clear();
  while (++index2 < length) {
    var entry = entries2[index2];
    this.set(entry[0], entry[1]);
  }
}
function listCacheClear() {
  this.__data__ = [];
}
function listCacheDelete(key) {
  var data12 = this.__data__, index2 = assocIndexOf(data12, key);
  if (index2 < 0) {
    return false;
  }
  var lastIndex = data12.length - 1;
  if (index2 == lastIndex) {
    data12.pop();
  } else {
    splice.call(data12, index2, 1);
  }
  return true;
}
function listCacheGet(key) {
  var data12 = this.__data__, index2 = assocIndexOf(data12, key);
  return index2 < 0 ? void 0 : data12[index2][1];
}
function listCacheHas(key) {
  return assocIndexOf(this.__data__, key) > -1;
}
function listCacheSet(key, value3) {
  var data12 = this.__data__, index2 = assocIndexOf(data12, key);
  if (index2 < 0) {
    data12.push([key, value3]);
  } else {
    data12[index2][1] = value3;
  }
  return this;
}
ListCache.prototype.clear = listCacheClear;
ListCache.prototype["delete"] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;
function MapCache(entries2) {
  var index2 = -1, length = entries2 ? entries2.length : 0;
  this.clear();
  while (++index2 < length) {
    var entry = entries2[index2];
    this.set(entry[0], entry[1]);
  }
}
function mapCacheClear() {
  this.__data__ = {
    "hash": new Hash(),
    "map": new (Map$1 || ListCache)(),
    "string": new Hash()
  };
}
function mapCacheDelete(key) {
  return getMapData(this, key)["delete"](key);
}
function mapCacheGet(key) {
  return getMapData(this, key).get(key);
}
function mapCacheHas(key) {
  return getMapData(this, key).has(key);
}
function mapCacheSet(key, value3) {
  getMapData(this, key).set(key, value3);
  return this;
}
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype["delete"] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}
function baseGet(object, path2) {
  path2 = isKey(path2, object) ? [path2] : castPath(path2);
  var index2 = 0, length = path2.length;
  while (object != null && index2 < length) {
    object = object[toKey(path2[index2++])];
  }
  return index2 && index2 == length ? object : void 0;
}
function baseIsNative(value3) {
  if (!isObject$d(value3) || isMasked(value3)) {
    return false;
  }
  var pattern = isFunction(value3) || isHostObject(value3) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value3));
}
function baseToString(value3) {
  if (typeof value3 == "string") {
    return value3;
  }
  if (isSymbol$6(value3)) {
    return symbolToString ? symbolToString.call(value3) : "";
  }
  var result = value3 + "";
  return result == "0" && 1 / value3 == -INFINITY ? "-0" : result;
}
function castPath(value3) {
  return isArray$3(value3) ? value3 : stringToPath(value3);
}
function getMapData(map, key) {
  var data12 = map.__data__;
  return isKeyable(key) ? data12[typeof key == "string" ? "string" : "hash"] : data12.map;
}
function getNative(object, key) {
  var value3 = getValue(object, key);
  return baseIsNative(value3) ? value3 : void 0;
}
function isKey(value3, object) {
  if (isArray$3(value3)) {
    return false;
  }
  var type = typeof value3;
  if (type == "number" || type == "symbol" || type == "boolean" || value3 == null || isSymbol$6(value3)) {
    return true;
  }
  return reIsPlainProp.test(value3) || !reIsDeepProp.test(value3) || object != null && value3 in Object(object);
}
function isKeyable(value3) {
  var type = typeof value3;
  return type == "string" || type == "number" || type == "symbol" || type == "boolean" ? value3 !== "__proto__" : value3 === null;
}
function isMasked(func) {
  return !!maskSrcKey && maskSrcKey in func;
}
var stringToPath = memoize(function(string) {
  string = toString$d(string);
  var result = [];
  if (reLeadingDot.test(string)) {
    result.push("");
  }
  string.replace(rePropName, function(match6, number, quote, string2) {
    result.push(quote ? string2.replace(reEscapeChar, "$1") : number || match6);
  });
  return result;
});
function toKey(value3) {
  if (typeof value3 == "string" || isSymbol$6(value3)) {
    return value3;
  }
  var result = value3 + "";
  return result == "0" && 1 / value3 == -INFINITY ? "-0" : result;
}
function toSource(func) {
  if (func != null) {
    try {
      return funcToString.call(func);
    } catch (e2) {
    }
    try {
      return func + "";
    } catch (e2) {
    }
  }
  return "";
}
function memoize(func, resolver) {
  if (typeof func != "function" || resolver && typeof resolver != "function") {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  var memoized = function() {
    var args = arguments, key = resolver ? resolver.apply(this, args) : args[0], cache = memoized.cache;
    if (cache.has(key)) {
      return cache.get(key);
    }
    var result = func.apply(this, args);
    memoized.cache = cache.set(key, result);
    return result;
  };
  memoized.cache = new (memoize.Cache || MapCache)();
  return memoized;
}
memoize.Cache = MapCache;
function eq(value3, other) {
  return value3 === other || value3 !== value3 && other !== other;
}
var isArray$3 = Array.isArray;
function isFunction(value3) {
  var tag = isObject$d(value3) ? objectToString$1.call(value3) : "";
  return tag == funcTag || tag == genTag;
}
function isObject$d(value3) {
  var type = typeof value3;
  return !!value3 && (type == "object" || type == "function");
}
function isObjectLike(value3) {
  return !!value3 && typeof value3 == "object";
}
function isSymbol$6(value3) {
  return typeof value3 == "symbol" || isObjectLike(value3) && objectToString$1.call(value3) == symbolTag;
}
function toString$d(value3) {
  return value3 == null ? "" : baseToString(value3);
}
function get$2(object, path2, defaultValue) {
  var result = object == null ? void 0 : baseGet(object, path2);
  return result === void 0 ? defaultValue : result;
}
var lodash_get = get$2;
var plurals$1 = {
  ach: {
    name: "Acholi",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n > 1)",
    pluralsFunc: function(n2) {
      return n2 > 1;
    }
  },
  af: {
    name: "Afrikaans",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  ak: {
    name: "Akan",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n > 1)",
    pluralsFunc: function(n2) {
      return n2 > 1;
    }
  },
  am: {
    name: "Amharic",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n > 1)",
    pluralsFunc: function(n2) {
      return n2 > 1;
    }
  },
  an: {
    name: "Aragonese",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  ar: {
    name: "Arabic",
    examples: [{
      plural: 0,
      sample: 0
    }, {
      plural: 1,
      sample: 1
    }, {
      plural: 2,
      sample: 2
    }, {
      plural: 3,
      sample: 3
    }, {
      plural: 4,
      sample: 11
    }, {
      plural: 5,
      sample: 100
    }],
    nplurals: 6,
    pluralsText: "nplurals = 6; plural = (n === 0 ? 0 : n === 1 ? 1 : n === 2 ? 2 : n % 100 >= 3 && n % 100 <= 10 ? 3 : n % 100 >= 11 ? 4 : 5)",
    pluralsFunc: function(n2) {
      return n2 === 0 ? 0 : n2 === 1 ? 1 : n2 === 2 ? 2 : n2 % 100 >= 3 && n2 % 100 <= 10 ? 3 : n2 % 100 >= 11 ? 4 : 5;
    }
  },
  arn: {
    name: "Mapudungun",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n > 1)",
    pluralsFunc: function(n2) {
      return n2 > 1;
    }
  },
  ast: {
    name: "Asturian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  ay: {
    name: "Aymará",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  az: {
    name: "Azerbaijani",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  be: {
    name: "Belarusian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }, {
      plural: 2,
      sample: 5
    }],
    nplurals: 3,
    pluralsText: "nplurals = 3; plural = (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)",
    pluralsFunc: function(n2) {
      return n2 % 10 === 1 && n2 % 100 !== 11 ? 0 : n2 % 10 >= 2 && n2 % 10 <= 4 && (n2 % 100 < 10 || n2 % 100 >= 20) ? 1 : 2;
    }
  },
  bg: {
    name: "Bulgarian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  bn: {
    name: "Bengali",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  bo: {
    name: "Tibetan",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  br: {
    name: "Breton",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n > 1)",
    pluralsFunc: function(n2) {
      return n2 > 1;
    }
  },
  brx: {
    name: "Bodo",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  bs: {
    name: "Bosnian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }, {
      plural: 2,
      sample: 5
    }],
    nplurals: 3,
    pluralsText: "nplurals = 3; plural = (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)",
    pluralsFunc: function(n2) {
      return n2 % 10 === 1 && n2 % 100 !== 11 ? 0 : n2 % 10 >= 2 && n2 % 10 <= 4 && (n2 % 100 < 10 || n2 % 100 >= 20) ? 1 : 2;
    }
  },
  ca: {
    name: "Catalan",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  cgg: {
    name: "Chiga",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  cs: {
    name: "Czech",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }, {
      plural: 2,
      sample: 5
    }],
    nplurals: 3,
    pluralsText: "nplurals = 3; plural = (n === 1 ? 0 : (n >= 2 && n <= 4) ? 1 : 2)",
    pluralsFunc: function(n2) {
      return n2 === 1 ? 0 : n2 >= 2 && n2 <= 4 ? 1 : 2;
    }
  },
  csb: {
    name: "Kashubian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }, {
      plural: 2,
      sample: 5
    }],
    nplurals: 3,
    pluralsText: "nplurals = 3; plural = (n === 1 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)",
    pluralsFunc: function(n2) {
      return n2 === 1 ? 0 : n2 % 10 >= 2 && n2 % 10 <= 4 && (n2 % 100 < 10 || n2 % 100 >= 20) ? 1 : 2;
    }
  },
  cy: {
    name: "Welsh",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }, {
      plural: 2,
      sample: 3
    }, {
      plural: 3,
      sample: 8
    }],
    nplurals: 4,
    pluralsText: "nplurals = 4; plural = (n === 1 ? 0 : n === 2 ? 1 : (n !== 8 && n !== 11) ? 2 : 3)",
    pluralsFunc: function(n2) {
      return n2 === 1 ? 0 : n2 === 2 ? 1 : n2 !== 8 && n2 !== 11 ? 2 : 3;
    }
  },
  da: {
    name: "Danish",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  de: {
    name: "German",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  doi: {
    name: "Dogri",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  dz: {
    name: "Dzongkha",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  el: {
    name: "Greek",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  en: {
    name: "English",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  eo: {
    name: "Esperanto",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  es: {
    name: "Spanish",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  et: {
    name: "Estonian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  eu: {
    name: "Basque",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  fa: {
    name: "Persian",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  ff: {
    name: "Fulah",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  fi: {
    name: "Finnish",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  fil: {
    name: "Filipino",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n > 1)",
    pluralsFunc: function(n2) {
      return n2 > 1;
    }
  },
  fo: {
    name: "Faroese",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  fr: {
    name: "French",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n > 1)",
    pluralsFunc: function(n2) {
      return n2 > 1;
    }
  },
  fur: {
    name: "Friulian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  fy: {
    name: "Frisian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  ga: {
    name: "Irish",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }, {
      plural: 2,
      sample: 3
    }, {
      plural: 3,
      sample: 7
    }, {
      plural: 4,
      sample: 11
    }],
    nplurals: 5,
    pluralsText: "nplurals = 5; plural = (n === 1 ? 0 : n === 2 ? 1 : n < 7 ? 2 : n < 11 ? 3 : 4)",
    pluralsFunc: function(n2) {
      return n2 === 1 ? 0 : n2 === 2 ? 1 : n2 < 7 ? 2 : n2 < 11 ? 3 : 4;
    }
  },
  gd: {
    name: "Scottish Gaelic",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }, {
      plural: 2,
      sample: 3
    }, {
      plural: 3,
      sample: 20
    }],
    nplurals: 4,
    pluralsText: "nplurals = 4; plural = ((n === 1 || n === 11) ? 0 : (n === 2 || n === 12) ? 1 : (n > 2 && n < 20) ? 2 : 3)",
    pluralsFunc: function(n2) {
      return n2 === 1 || n2 === 11 ? 0 : n2 === 2 || n2 === 12 ? 1 : n2 > 2 && n2 < 20 ? 2 : 3;
    }
  },
  gl: {
    name: "Galician",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  gu: {
    name: "Gujarati",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  gun: {
    name: "Gun",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n > 1)",
    pluralsFunc: function(n2) {
      return n2 > 1;
    }
  },
  ha: {
    name: "Hausa",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  he: {
    name: "Hebrew",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  hi: {
    name: "Hindi",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  hne: {
    name: "Chhattisgarhi",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  hr: {
    name: "Croatian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }, {
      plural: 2,
      sample: 5
    }],
    nplurals: 3,
    pluralsText: "nplurals = 3; plural = (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)",
    pluralsFunc: function(n2) {
      return n2 % 10 === 1 && n2 % 100 !== 11 ? 0 : n2 % 10 >= 2 && n2 % 10 <= 4 && (n2 % 100 < 10 || n2 % 100 >= 20) ? 1 : 2;
    }
  },
  hu: {
    name: "Hungarian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  hy: {
    name: "Armenian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  id: {
    name: "Indonesian",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  is: {
    name: "Icelandic",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n % 10 !== 1 || n % 100 === 11)",
    pluralsFunc: function(n2) {
      return n2 % 10 !== 1 || n2 % 100 === 11;
    }
  },
  it: {
    name: "Italian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  ja: {
    name: "Japanese",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  jbo: {
    name: "Lojban",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  jv: {
    name: "Javanese",
    examples: [{
      plural: 0,
      sample: 0
    }, {
      plural: 1,
      sample: 1
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 0)",
    pluralsFunc: function(n2) {
      return n2 !== 0;
    }
  },
  ka: {
    name: "Georgian",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  kk: {
    name: "Kazakh",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  km: {
    name: "Khmer",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  kn: {
    name: "Kannada",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  ko: {
    name: "Korean",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  ku: {
    name: "Kurdish",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  kw: {
    name: "Cornish",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }, {
      plural: 2,
      sample: 3
    }, {
      plural: 3,
      sample: 4
    }],
    nplurals: 4,
    pluralsText: "nplurals = 4; plural = (n === 1 ? 0 : n === 2 ? 1 : n === 3 ? 2 : 3)",
    pluralsFunc: function(n2) {
      return n2 === 1 ? 0 : n2 === 2 ? 1 : n2 === 3 ? 2 : 3;
    }
  },
  ky: {
    name: "Kyrgyz",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  lb: {
    name: "Letzeburgesch",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  ln: {
    name: "Lingala",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n > 1)",
    pluralsFunc: function(n2) {
      return n2 > 1;
    }
  },
  lo: {
    name: "Lao",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  lt: {
    name: "Lithuanian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }, {
      plural: 2,
      sample: 10
    }],
    nplurals: 3,
    pluralsText: "nplurals = 3; plural = (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)",
    pluralsFunc: function(n2) {
      return n2 % 10 === 1 && n2 % 100 !== 11 ? 0 : n2 % 10 >= 2 && (n2 % 100 < 10 || n2 % 100 >= 20) ? 1 : 2;
    }
  },
  lv: {
    name: "Latvian",
    examples: [{
      plural: 2,
      sample: 0
    }, {
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 3,
    pluralsText: "nplurals = 3; plural = (n % 10 === 1 && n % 100 !== 11 ? 0 : n !== 0 ? 1 : 2)",
    pluralsFunc: function(n2) {
      return n2 % 10 === 1 && n2 % 100 !== 11 ? 0 : n2 !== 0 ? 1 : 2;
    }
  },
  mai: {
    name: "Maithili",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  mfe: {
    name: "Mauritian Creole",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n > 1)",
    pluralsFunc: function(n2) {
      return n2 > 1;
    }
  },
  mg: {
    name: "Malagasy",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n > 1)",
    pluralsFunc: function(n2) {
      return n2 > 1;
    }
  },
  mi: {
    name: "Maori",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n > 1)",
    pluralsFunc: function(n2) {
      return n2 > 1;
    }
  },
  mk: {
    name: "Macedonian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n === 1 || n % 10 === 1 ? 0 : 1)",
    pluralsFunc: function(n2) {
      return n2 === 1 || n2 % 10 === 1 ? 0 : 1;
    }
  },
  ml: {
    name: "Malayalam",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  mn: {
    name: "Mongolian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  mni: {
    name: "Manipuri",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  mnk: {
    name: "Mandinka",
    examples: [{
      plural: 0,
      sample: 0
    }, {
      plural: 1,
      sample: 1
    }, {
      plural: 2,
      sample: 2
    }],
    nplurals: 3,
    pluralsText: "nplurals = 3; plural = (n === 0 ? 0 : n === 1 ? 1 : 2)",
    pluralsFunc: function(n2) {
      return n2 === 0 ? 0 : n2 === 1 ? 1 : 2;
    }
  },
  mr: {
    name: "Marathi",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  ms: {
    name: "Malay",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  mt: {
    name: "Maltese",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }, {
      plural: 2,
      sample: 11
    }, {
      plural: 3,
      sample: 20
    }],
    nplurals: 4,
    pluralsText: "nplurals = 4; plural = (n === 1 ? 0 : n === 0 || ( n % 100 > 1 && n % 100 < 11) ? 1 : (n % 100 > 10 && n % 100 < 20 ) ? 2 : 3)",
    pluralsFunc: function(n2) {
      return n2 === 1 ? 0 : n2 === 0 || n2 % 100 > 1 && n2 % 100 < 11 ? 1 : n2 % 100 > 10 && n2 % 100 < 20 ? 2 : 3;
    }
  },
  my: {
    name: "Burmese",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  nah: {
    name: "Nahuatl",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  nap: {
    name: "Neapolitan",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  nb: {
    name: "Norwegian Bokmal",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  ne: {
    name: "Nepali",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  nl: {
    name: "Dutch",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  nn: {
    name: "Norwegian Nynorsk",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  no: {
    name: "Norwegian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  nso: {
    name: "Northern Sotho",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  oc: {
    name: "Occitan",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n > 1)",
    pluralsFunc: function(n2) {
      return n2 > 1;
    }
  },
  or: {
    name: "Oriya",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  pa: {
    name: "Punjabi",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  pap: {
    name: "Papiamento",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  pl: {
    name: "Polish",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }, {
      plural: 2,
      sample: 5
    }],
    nplurals: 3,
    pluralsText: "nplurals = 3; plural = (n === 1 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)",
    pluralsFunc: function(n2) {
      return n2 === 1 ? 0 : n2 % 10 >= 2 && n2 % 10 <= 4 && (n2 % 100 < 10 || n2 % 100 >= 20) ? 1 : 2;
    }
  },
  pms: {
    name: "Piemontese",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  ps: {
    name: "Pashto",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  pt: {
    name: "Portuguese",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  rm: {
    name: "Romansh",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  ro: {
    name: "Romanian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }, {
      plural: 2,
      sample: 20
    }],
    nplurals: 3,
    pluralsText: "nplurals = 3; plural = (n === 1 ? 0 : (n === 0 || (n % 100 > 0 && n % 100 < 20)) ? 1 : 2)",
    pluralsFunc: function(n2) {
      return n2 === 1 ? 0 : n2 === 0 || n2 % 100 > 0 && n2 % 100 < 20 ? 1 : 2;
    }
  },
  ru: {
    name: "Russian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }, {
      plural: 2,
      sample: 5
    }],
    nplurals: 3,
    pluralsText: "nplurals = 3; plural = (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)",
    pluralsFunc: function(n2) {
      return n2 % 10 === 1 && n2 % 100 !== 11 ? 0 : n2 % 10 >= 2 && n2 % 10 <= 4 && (n2 % 100 < 10 || n2 % 100 >= 20) ? 1 : 2;
    }
  },
  rw: {
    name: "Kinyarwanda",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  sah: {
    name: "Yakut",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  sat: {
    name: "Santali",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  sco: {
    name: "Scots",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  sd: {
    name: "Sindhi",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  se: {
    name: "Northern Sami",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  si: {
    name: "Sinhala",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  sk: {
    name: "Slovak",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }, {
      plural: 2,
      sample: 5
    }],
    nplurals: 3,
    pluralsText: "nplurals = 3; plural = (n === 1 ? 0 : (n >= 2 && n <= 4) ? 1 : 2)",
    pluralsFunc: function(n2) {
      return n2 === 1 ? 0 : n2 >= 2 && n2 <= 4 ? 1 : 2;
    }
  },
  sl: {
    name: "Slovenian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }, {
      plural: 2,
      sample: 3
    }, {
      plural: 3,
      sample: 5
    }],
    nplurals: 4,
    pluralsText: "nplurals = 4; plural = (n % 100 === 1 ? 0 : n % 100 === 2 ? 1 : n % 100 === 3 || n % 100 === 4 ? 2 : 3)",
    pluralsFunc: function(n2) {
      return n2 % 100 === 1 ? 0 : n2 % 100 === 2 ? 1 : n2 % 100 === 3 || n2 % 100 === 4 ? 2 : 3;
    }
  },
  so: {
    name: "Somali",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  son: {
    name: "Songhay",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  sq: {
    name: "Albanian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  sr: {
    name: "Serbian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }, {
      plural: 2,
      sample: 5
    }],
    nplurals: 3,
    pluralsText: "nplurals = 3; plural = (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)",
    pluralsFunc: function(n2) {
      return n2 % 10 === 1 && n2 % 100 !== 11 ? 0 : n2 % 10 >= 2 && n2 % 10 <= 4 && (n2 % 100 < 10 || n2 % 100 >= 20) ? 1 : 2;
    }
  },
  su: {
    name: "Sundanese",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  sv: {
    name: "Swedish",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  sw: {
    name: "Swahili",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  ta: {
    name: "Tamil",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  te: {
    name: "Telugu",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  tg: {
    name: "Tajik",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n > 1)",
    pluralsFunc: function(n2) {
      return n2 > 1;
    }
  },
  th: {
    name: "Thai",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  ti: {
    name: "Tigrinya",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n > 1)",
    pluralsFunc: function(n2) {
      return n2 > 1;
    }
  },
  tk: {
    name: "Turkmen",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  tr: {
    name: "Turkish",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n > 1)",
    pluralsFunc: function(n2) {
      return n2 > 1;
    }
  },
  tt: {
    name: "Tatar",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  ug: {
    name: "Uyghur",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  uk: {
    name: "Ukrainian",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }, {
      plural: 2,
      sample: 5
    }],
    nplurals: 3,
    pluralsText: "nplurals = 3; plural = (n % 10 === 1 && n % 100 !== 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2)",
    pluralsFunc: function(n2) {
      return n2 % 10 === 1 && n2 % 100 !== 11 ? 0 : n2 % 10 >= 2 && n2 % 10 <= 4 && (n2 % 100 < 10 || n2 % 100 >= 20) ? 1 : 2;
    }
  },
  ur: {
    name: "Urdu",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  uz: {
    name: "Uzbek",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n > 1)",
    pluralsFunc: function(n2) {
      return n2 > 1;
    }
  },
  vi: {
    name: "Vietnamese",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  wa: {
    name: "Walloon",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n > 1)",
    pluralsFunc: function(n2) {
      return n2 > 1;
    }
  },
  wo: {
    name: "Wolof",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  },
  yo: {
    name: "Yoruba",
    examples: [{
      plural: 0,
      sample: 1
    }, {
      plural: 1,
      sample: 2
    }],
    nplurals: 2,
    pluralsText: "nplurals = 2; plural = (n !== 1)",
    pluralsFunc: function(n2) {
      return n2 !== 1;
    }
  },
  zh: {
    name: "Chinese",
    examples: [{
      plural: 0,
      sample: 1
    }],
    nplurals: 1,
    pluralsText: "nplurals = 1; plural = 0",
    pluralsFunc: function() {
      return 0;
    }
  }
};
var get$1 = lodash_get;
var plurals = plurals$1;
var gettext$1 = Gettext;
function Gettext(options2) {
  options2 = options2 || {};
  this.catalogs = {};
  this.locale = "";
  this.domain = "messages";
  this.listeners = [];
  this.sourceLocale = "";
  if (options2.sourceLocale) {
    if (typeof options2.sourceLocale === "string") {
      this.sourceLocale = options2.sourceLocale;
    } else {
      this.warn("The `sourceLocale` option should be a string");
    }
  }
  this.debug = "debug" in options2 && options2.debug === true;
}
Gettext.prototype.on = function(eventName, callback) {
  this.listeners.push({
    eventName,
    callback
  });
};
Gettext.prototype.off = function(eventName, callback) {
  this.listeners = this.listeners.filter(function(listener) {
    return (listener.eventName === eventName && listener.callback === callback) === false;
  });
};
Gettext.prototype.emit = function(eventName, eventData) {
  for (var i2 = 0; i2 < this.listeners.length; i2++) {
    var listener = this.listeners[i2];
    if (listener.eventName === eventName) {
      listener.callback(eventData);
    }
  }
};
Gettext.prototype.warn = function(message) {
  if (this.debug) {
    console.warn(message);
  }
  this.emit("error", new Error(message));
};
Gettext.prototype.addTranslations = function(locale3, domain2, translations2) {
  if (!this.catalogs[locale3]) {
    this.catalogs[locale3] = {};
  }
  this.catalogs[locale3][domain2] = translations2;
};
Gettext.prototype.setLocale = function(locale3) {
  if (typeof locale3 !== "string") {
    this.warn(
      "You called setLocale() with an argument of type " + typeof locale3 + ". The locale must be a string."
    );
    return;
  }
  if (locale3.trim() === "") {
    this.warn("You called setLocale() with an empty value, which makes little sense.");
  }
  if (locale3 !== this.sourceLocale && !this.catalogs[locale3]) {
    this.warn('You called setLocale() with "' + locale3 + '", but no translations for that locale has been added.');
  }
  this.locale = locale3;
};
Gettext.prototype.setTextDomain = function(domain2) {
  if (typeof domain2 !== "string") {
    this.warn(
      "You called setTextDomain() with an argument of type " + typeof domain2 + ". The domain must be a string."
    );
    return;
  }
  if (domain2.trim() === "") {
    this.warn("You called setTextDomain() with an empty `domain` value.");
  }
  this.domain = domain2;
};
Gettext.prototype.gettext = function(msgid) {
  return this.dnpgettext(this.domain, "", msgid);
};
Gettext.prototype.dgettext = function(domain2, msgid) {
  return this.dnpgettext(domain2, "", msgid);
};
Gettext.prototype.ngettext = function(msgid, msgidPlural, count) {
  return this.dnpgettext(this.domain, "", msgid, msgidPlural, count);
};
Gettext.prototype.dngettext = function(domain2, msgid, msgidPlural, count) {
  return this.dnpgettext(domain2, "", msgid, msgidPlural, count);
};
Gettext.prototype.pgettext = function(msgctxt, msgid) {
  return this.dnpgettext(this.domain, msgctxt, msgid);
};
Gettext.prototype.dpgettext = function(domain2, msgctxt, msgid) {
  return this.dnpgettext(domain2, msgctxt, msgid);
};
Gettext.prototype.npgettext = function(msgctxt, msgid, msgidPlural, count) {
  return this.dnpgettext(this.domain, msgctxt, msgid, msgidPlural, count);
};
Gettext.prototype.dnpgettext = function(domain2, msgctxt, msgid, msgidPlural, count) {
  var defaultTranslation = msgid;
  var translation;
  var index2;
  msgctxt = msgctxt || "";
  if (!isNaN(count) && count !== 1) {
    defaultTranslation = msgidPlural || msgid;
  }
  translation = this._getTranslation(domain2, msgctxt, msgid);
  if (translation) {
    if (typeof count === "number") {
      var pluralsFunc = plurals[Gettext.getLanguageCode(this.locale)].pluralsFunc;
      index2 = pluralsFunc(count);
      if (typeof index2 === "boolean") {
        index2 = index2 ? 1 : 0;
      }
    } else {
      index2 = 0;
    }
    return translation.msgstr[index2] || defaultTranslation;
  } else if (!this.sourceLocale || this.locale !== this.sourceLocale) {
    this.warn('No translation was found for msgid "' + msgid + '" in msgctxt "' + msgctxt + '" and domain "' + domain2 + '"');
  }
  return defaultTranslation;
};
Gettext.prototype.getComment = function(domain2, msgctxt, msgid) {
  var translation;
  translation = this._getTranslation(domain2, msgctxt, msgid);
  if (translation) {
    return translation.comments || {};
  }
  return {};
};
Gettext.prototype._getTranslation = function(domain2, msgctxt, msgid) {
  msgctxt = msgctxt || "";
  return get$1(this.catalogs, [this.locale, domain2, "translations", msgctxt, msgid]);
};
Gettext.getLanguageCode = function(locale3) {
  return locale3.split(/[\-_]/)[0].toLowerCase();
};
Gettext.prototype.textdomain = function(domain2) {
  if (this.debug) {
    console.warn("textdomain(domain) was used to set locales in node-gettext v1. Make sure you are using it for domains, and switch to setLocale(locale) if you are not.\n\n To read more about the migration from node-gettext v1 to v2, see https://github.com/alexanderwallin/node-gettext/#migrating-from-1x-to-2x\n\nThis warning will be removed in the final 2.0.0");
  }
  this.setTextDomain(domain2);
};
Gettext.prototype.setlocale = function(locale3) {
  this.setLocale(locale3);
};
Gettext.prototype.addTextdomain = function() {
  console.error("addTextdomain() is deprecated.\n\n* To add translations, use addTranslations()\n* To set the default domain, use setTextDomain() (or its alias textdomain())\n\nTo read more about the migration from node-gettext v1 to v2, see https://github.com/alexanderwallin/node-gettext/#migrating-from-1x-to-2x");
};
const GetText = /* @__PURE__ */ getDefaultExportFromCjs(gettext$1);
function getLanguage$1() {
  return document.documentElement.lang || "en";
}
/*! @license DOMPurify 3.1.6 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/3.1.6/LICENSE */
const {
  entries,
  setPrototypeOf: setPrototypeOf$2,
  isFrozen,
  getPrototypeOf: getPrototypeOf$2,
  getOwnPropertyDescriptor: getOwnPropertyDescriptor$3
} = Object;
let {
  freeze,
  seal,
  create: create$3
} = Object;
let {
  apply: apply$3,
  construct: construct$1
} = typeof Reflect !== "undefined" && Reflect;
if (!freeze) {
  freeze = function freeze2(x3) {
    return x3;
  };
}
if (!seal) {
  seal = function seal2(x3) {
    return x3;
  };
}
if (!apply$3) {
  apply$3 = function apply2(fun, thisValue, args) {
    return fun.apply(thisValue, args);
  };
}
if (!construct$1) {
  construct$1 = function construct2(Func, args) {
    return new Func(...args);
  };
}
const arrayForEach = unapply(Array.prototype.forEach);
const arrayPop = unapply(Array.prototype.pop);
const arrayPush = unapply(Array.prototype.push);
const stringToLowerCase = unapply(String.prototype.toLowerCase);
const stringToString = unapply(String.prototype.toString);
const stringMatch = unapply(String.prototype.match);
const stringReplace = unapply(String.prototype.replace);
const stringIndexOf$1 = unapply(String.prototype.indexOf);
const stringTrim$1 = unapply(String.prototype.trim);
const objectHasOwnProperty = unapply(Object.prototype.hasOwnProperty);
const regExpTest = unapply(RegExp.prototype.test);
const typeErrorCreate = unconstruct(TypeError);
function unapply(func) {
  return function(thisArg) {
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key2 = 1; _key2 < _len; _key2++) {
      args[_key2 - 1] = arguments[_key2];
    }
    return apply$3(func, thisArg, args);
  };
}
function unconstruct(func) {
  return function() {
    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }
    return construct$1(func, args);
  };
}
function addToSet(set2, array) {
  let transformCaseFunc = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : stringToLowerCase;
  if (setPrototypeOf$2) {
    setPrototypeOf$2(set2, null);
  }
  let l2 = array.length;
  while (l2--) {
    let element = array[l2];
    if (typeof element === "string") {
      const lcElement = transformCaseFunc(element);
      if (lcElement !== element) {
        if (!isFrozen(array)) {
          array[l2] = lcElement;
        }
        element = lcElement;
      }
    }
    set2[element] = true;
  }
  return set2;
}
function cleanArray(array) {
  for (let index2 = 0; index2 < array.length; index2++) {
    const isPropertyExist = objectHasOwnProperty(array, index2);
    if (!isPropertyExist) {
      array[index2] = null;
    }
  }
  return array;
}
function clone$1(object) {
  const newObject = create$3(null);
  for (const [property, value3] of entries(object)) {
    const isPropertyExist = objectHasOwnProperty(object, property);
    if (isPropertyExist) {
      if (Array.isArray(value3)) {
        newObject[property] = cleanArray(value3);
      } else if (value3 && typeof value3 === "object" && value3.constructor === Object) {
        newObject[property] = clone$1(value3);
      } else {
        newObject[property] = value3;
      }
    }
  }
  return newObject;
}
function lookupGetter(object, prop) {
  while (object !== null) {
    const desc = getOwnPropertyDescriptor$3(object, prop);
    if (desc) {
      if (desc.get) {
        return unapply(desc.get);
      }
      if (typeof desc.value === "function") {
        return unapply(desc.value);
      }
    }
    object = getPrototypeOf$2(object);
  }
  function fallbackValue() {
    return null;
  }
  return fallbackValue;
}
const html$1$1 = freeze(["a", "abbr", "acronym", "address", "area", "article", "aside", "audio", "b", "bdi", "bdo", "big", "blink", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "content", "data", "datalist", "dd", "decorator", "del", "details", "dfn", "dialog", "dir", "div", "dl", "dt", "element", "em", "fieldset", "figcaption", "figure", "font", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "img", "input", "ins", "kbd", "label", "legend", "li", "main", "map", "mark", "marquee", "menu", "menuitem", "meter", "nav", "nobr", "ol", "optgroup", "option", "output", "p", "picture", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "section", "select", "shadow", "small", "source", "spacer", "span", "strike", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "template", "textarea", "tfoot", "th", "thead", "time", "tr", "track", "tt", "u", "ul", "var", "video", "wbr"]);
const svg$1 = freeze(["svg", "a", "altglyph", "altglyphdef", "altglyphitem", "animatecolor", "animatemotion", "animatetransform", "circle", "clippath", "defs", "desc", "ellipse", "filter", "font", "g", "glyph", "glyphref", "hkern", "image", "line", "lineargradient", "marker", "mask", "metadata", "mpath", "path", "pattern", "polygon", "polyline", "radialgradient", "rect", "stop", "style", "switch", "symbol", "text", "textpath", "title", "tref", "tspan", "view", "vkern"]);
const svgFilters = freeze(["feBlend", "feColorMatrix", "feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feDistantLight", "feDropShadow", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "fePointLight", "feSpecularLighting", "feSpotLight", "feTile", "feTurbulence"]);
const svgDisallowed = freeze(["animate", "color-profile", "cursor", "discard", "font-face", "font-face-format", "font-face-name", "font-face-src", "font-face-uri", "foreignobject", "hatch", "hatchpath", "mesh", "meshgradient", "meshpatch", "meshrow", "missing-glyph", "script", "set", "solidcolor", "unknown", "use"]);
const mathMl$1 = freeze(["math", "menclose", "merror", "mfenced", "mfrac", "mglyph", "mi", "mlabeledtr", "mmultiscripts", "mn", "mo", "mover", "mpadded", "mphantom", "mroot", "mrow", "ms", "mspace", "msqrt", "mstyle", "msub", "msup", "msubsup", "mtable", "mtd", "mtext", "mtr", "munder", "munderover", "mprescripts"]);
const mathMlDisallowed = freeze(["maction", "maligngroup", "malignmark", "mlongdiv", "mscarries", "mscarry", "msgroup", "mstack", "msline", "msrow", "semantics", "annotation", "annotation-xml", "mprescripts", "none"]);
const text = freeze(["#text"]);
const html$2 = freeze(["accept", "action", "align", "alt", "autocapitalize", "autocomplete", "autopictureinpicture", "autoplay", "background", "bgcolor", "border", "capture", "cellpadding", "cellspacing", "checked", "cite", "class", "clear", "color", "cols", "colspan", "controls", "controlslist", "coords", "crossorigin", "datetime", "decoding", "default", "dir", "disabled", "disablepictureinpicture", "disableremoteplayback", "download", "draggable", "enctype", "enterkeyhint", "face", "for", "headers", "height", "hidden", "high", "href", "hreflang", "id", "inputmode", "integrity", "ismap", "kind", "label", "lang", "list", "loading", "loop", "low", "max", "maxlength", "media", "method", "min", "minlength", "multiple", "muted", "name", "nonce", "noshade", "novalidate", "nowrap", "open", "optimum", "pattern", "placeholder", "playsinline", "popover", "popovertarget", "popovertargetaction", "poster", "preload", "pubdate", "radiogroup", "readonly", "rel", "required", "rev", "reversed", "role", "rows", "rowspan", "spellcheck", "scope", "selected", "shape", "size", "sizes", "span", "srclang", "start", "src", "srcset", "step", "style", "summary", "tabindex", "title", "translate", "type", "usemap", "valign", "value", "width", "wrap", "xmlns", "slot"]);
const svg = freeze(["accent-height", "accumulate", "additive", "alignment-baseline", "ascent", "attributename", "attributetype", "azimuth", "basefrequency", "baseline-shift", "begin", "bias", "by", "class", "clip", "clippathunits", "clip-path", "clip-rule", "color", "color-interpolation", "color-interpolation-filters", "color-profile", "color-rendering", "cx", "cy", "d", "dx", "dy", "diffuseconstant", "direction", "display", "divisor", "dur", "edgemode", "elevation", "end", "fill", "fill-opacity", "fill-rule", "filter", "filterunits", "flood-color", "flood-opacity", "font-family", "font-size", "font-size-adjust", "font-stretch", "font-style", "font-variant", "font-weight", "fx", "fy", "g1", "g2", "glyph-name", "glyphref", "gradientunits", "gradienttransform", "height", "href", "id", "image-rendering", "in", "in2", "k", "k1", "k2", "k3", "k4", "kerning", "keypoints", "keysplines", "keytimes", "lang", "lengthadjust", "letter-spacing", "kernelmatrix", "kernelunitlength", "lighting-color", "local", "marker-end", "marker-mid", "marker-start", "markerheight", "markerunits", "markerwidth", "maskcontentunits", "maskunits", "max", "mask", "media", "method", "mode", "min", "name", "numoctaves", "offset", "operator", "opacity", "order", "orient", "orientation", "origin", "overflow", "paint-order", "path", "pathlength", "patterncontentunits", "patterntransform", "patternunits", "points", "preservealpha", "preserveaspectratio", "primitiveunits", "r", "rx", "ry", "radius", "refx", "refy", "repeatcount", "repeatdur", "restart", "result", "rotate", "scale", "seed", "shape-rendering", "specularconstant", "specularexponent", "spreadmethod", "startoffset", "stddeviation", "stitchtiles", "stop-color", "stop-opacity", "stroke-dasharray", "stroke-dashoffset", "stroke-linecap", "stroke-linejoin", "stroke-miterlimit", "stroke-opacity", "stroke", "stroke-width", "style", "surfacescale", "systemlanguage", "tabindex", "targetx", "targety", "transform", "transform-origin", "text-anchor", "text-decoration", "text-rendering", "textlength", "type", "u1", "u2", "unicode", "values", "viewbox", "visibility", "version", "vert-adv-y", "vert-origin-x", "vert-origin-y", "width", "word-spacing", "wrap", "writing-mode", "xchannelselector", "ychannelselector", "x", "x1", "x2", "xmlns", "y", "y1", "y2", "z", "zoomandpan"]);
const mathMl = freeze(["accent", "accentunder", "align", "bevelled", "close", "columnsalign", "columnlines", "columnspan", "denomalign", "depth", "dir", "display", "displaystyle", "encoding", "fence", "frame", "height", "href", "id", "largeop", "length", "linethickness", "lspace", "lquote", "mathbackground", "mathcolor", "mathsize", "mathvariant", "maxsize", "minsize", "movablelimits", "notation", "numalign", "open", "rowalign", "rowlines", "rowspacing", "rowspan", "rspace", "rquote", "scriptlevel", "scriptminsize", "scriptsizemultiplier", "selection", "separator", "separators", "stretchy", "subscriptshift", "supscriptshift", "symmetric", "voffset", "width", "xmlns"]);
const xml = freeze(["xlink:href", "xml:id", "xlink:title", "xml:space", "xmlns:xlink"]);
const MUSTACHE_EXPR = seal(/\{\{[\w\W]*|[\w\W]*\}\}/gm);
const ERB_EXPR = seal(/<%[\w\W]*|[\w\W]*%>/gm);
const TMPLIT_EXPR = seal(/\${[\w\W]*}/gm);
const DATA_ATTR = seal(/^data-[\-\w.\u00B7-\uFFFF]/);
const ARIA_ATTR = seal(/^aria-[\-\w]+$/);
const IS_ALLOWED_URI = seal(
  /^(?:(?:(?:f|ht)tps?|mailto|tel|callto|sms|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i
  // eslint-disable-line no-useless-escape
);
const IS_SCRIPT_OR_DATA = seal(/^(?:\w+script|data):/i);
const ATTR_WHITESPACE = seal(
  /[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g
  // eslint-disable-line no-control-regex
);
const DOCTYPE_NAME = seal(/^html$/i);
const CUSTOM_ELEMENT = seal(/^[a-z][.\w]*(-[.\w]+)+$/i);
var EXPRESSIONS = /* @__PURE__ */ Object.freeze({
  __proto__: null,
  MUSTACHE_EXPR,
  ERB_EXPR,
  TMPLIT_EXPR,
  DATA_ATTR,
  ARIA_ATTR,
  IS_ALLOWED_URI,
  IS_SCRIPT_OR_DATA,
  ATTR_WHITESPACE,
  DOCTYPE_NAME,
  CUSTOM_ELEMENT
});
const NODE_TYPE = {
  element: 1,
  attribute: 2,
  text: 3,
  cdataSection: 4,
  entityReference: 5,
  // Deprecated
  entityNode: 6,
  // Deprecated
  progressingInstruction: 7,
  comment: 8,
  document: 9,
  documentType: 10,
  documentFragment: 11,
  notation: 12
  // Deprecated
};
const getGlobal = function getGlobal2() {
  return typeof window === "undefined" ? null : window;
};
const _createTrustedTypesPolicy = function _createTrustedTypesPolicy2(trustedTypes, purifyHostElement) {
  if (typeof trustedTypes !== "object" || typeof trustedTypes.createPolicy !== "function") {
    return null;
  }
  let suffix = null;
  const ATTR_NAME = "data-tt-policy-suffix";
  if (purifyHostElement && purifyHostElement.hasAttribute(ATTR_NAME)) {
    suffix = purifyHostElement.getAttribute(ATTR_NAME);
  }
  const policyName = "dompurify" + (suffix ? "#" + suffix : "");
  try {
    return trustedTypes.createPolicy(policyName, {
      createHTML(html2) {
        return html2;
      },
      createScriptURL(scriptUrl) {
        return scriptUrl;
      }
    });
  } catch (_2) {
    console.warn("TrustedTypes policy " + policyName + " could not be created.");
    return null;
  }
};
function createDOMPurify() {
  let window2 = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : getGlobal();
  const DOMPurify = (root2) => createDOMPurify(root2);
  DOMPurify.version = "3.1.6";
  DOMPurify.removed = [];
  if (!window2 || !window2.document || window2.document.nodeType !== NODE_TYPE.document) {
    DOMPurify.isSupported = false;
    return DOMPurify;
  }
  let {
    document: document2
  } = window2;
  const originalDocument = document2;
  const currentScript = originalDocument.currentScript;
  const {
    DocumentFragment,
    HTMLTemplateElement,
    Node: Node3,
    Element: Element2,
    NodeFilter,
    NamedNodeMap = window2.NamedNodeMap || window2.MozNamedAttrMap,
    HTMLFormElement,
    DOMParser: DOMParser2,
    trustedTypes
  } = window2;
  const ElementPrototype = Element2.prototype;
  const cloneNode = lookupGetter(ElementPrototype, "cloneNode");
  const remove2 = lookupGetter(ElementPrototype, "remove");
  const getNextSibling = lookupGetter(ElementPrototype, "nextSibling");
  const getChildNodes = lookupGetter(ElementPrototype, "childNodes");
  const getParentNode2 = lookupGetter(ElementPrototype, "parentNode");
  if (typeof HTMLTemplateElement === "function") {
    const template = document2.createElement("template");
    if (template.content && template.content.ownerDocument) {
      document2 = template.content.ownerDocument;
    }
  }
  let trustedTypesPolicy;
  let emptyHTML = "";
  const {
    implementation,
    createNodeIterator,
    createDocumentFragment,
    getElementsByTagName
  } = document2;
  const {
    importNode
  } = originalDocument;
  let hooks2 = {};
  DOMPurify.isSupported = typeof entries === "function" && typeof getParentNode2 === "function" && implementation && implementation.createHTMLDocument !== void 0;
  const {
    MUSTACHE_EXPR: MUSTACHE_EXPR2,
    ERB_EXPR: ERB_EXPR2,
    TMPLIT_EXPR: TMPLIT_EXPR2,
    DATA_ATTR: DATA_ATTR2,
    ARIA_ATTR: ARIA_ATTR2,
    IS_SCRIPT_OR_DATA: IS_SCRIPT_OR_DATA2,
    ATTR_WHITESPACE: ATTR_WHITESPACE2,
    CUSTOM_ELEMENT: CUSTOM_ELEMENT2
  } = EXPRESSIONS;
  let {
    IS_ALLOWED_URI: IS_ALLOWED_URI$1
  } = EXPRESSIONS;
  let ALLOWED_TAGS = null;
  const DEFAULT_ALLOWED_TAGS = addToSet({}, [...html$1$1, ...svg$1, ...svgFilters, ...mathMl$1, ...text]);
  let ALLOWED_ATTR = null;
  const DEFAULT_ALLOWED_ATTR = addToSet({}, [...html$2, ...svg, ...mathMl, ...xml]);
  let CUSTOM_ELEMENT_HANDLING = Object.seal(create$3(null, {
    tagNameCheck: {
      writable: true,
      configurable: false,
      enumerable: true,
      value: null
    },
    attributeNameCheck: {
      writable: true,
      configurable: false,
      enumerable: true,
      value: null
    },
    allowCustomizedBuiltInElements: {
      writable: true,
      configurable: false,
      enumerable: true,
      value: false
    }
  }));
  let FORBID_TAGS = null;
  let FORBID_ATTR = null;
  let ALLOW_ARIA_ATTR = true;
  let ALLOW_DATA_ATTR = true;
  let ALLOW_UNKNOWN_PROTOCOLS = false;
  let ALLOW_SELF_CLOSE_IN_ATTR = true;
  let SAFE_FOR_TEMPLATES = false;
  let SAFE_FOR_XML = true;
  let WHOLE_DOCUMENT = false;
  let SET_CONFIG = false;
  let FORCE_BODY = false;
  let RETURN_DOM = false;
  let RETURN_DOM_FRAGMENT = false;
  let RETURN_TRUSTED_TYPE = false;
  let SANITIZE_DOM = true;
  let SANITIZE_NAMED_PROPS = false;
  const SANITIZE_NAMED_PROPS_PREFIX = "user-content-";
  let KEEP_CONTENT = true;
  let IN_PLACE = false;
  let USE_PROFILES = {};
  let FORBID_CONTENTS = null;
  const DEFAULT_FORBID_CONTENTS = addToSet({}, ["annotation-xml", "audio", "colgroup", "desc", "foreignobject", "head", "iframe", "math", "mi", "mn", "mo", "ms", "mtext", "noembed", "noframes", "noscript", "plaintext", "script", "style", "svg", "template", "thead", "title", "video", "xmp"]);
  let DATA_URI_TAGS = null;
  const DEFAULT_DATA_URI_TAGS = addToSet({}, ["audio", "video", "img", "source", "image", "track"]);
  let URI_SAFE_ATTRIBUTES = null;
  const DEFAULT_URI_SAFE_ATTRIBUTES = addToSet({}, ["alt", "class", "for", "id", "label", "name", "pattern", "placeholder", "role", "summary", "title", "value", "style", "xmlns"]);
  const MATHML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
  const SVG_NAMESPACE = "http://www.w3.org/2000/svg";
  const HTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
  let NAMESPACE = HTML_NAMESPACE;
  let IS_EMPTY_INPUT = false;
  let ALLOWED_NAMESPACES = null;
  const DEFAULT_ALLOWED_NAMESPACES = addToSet({}, [MATHML_NAMESPACE, SVG_NAMESPACE, HTML_NAMESPACE], stringToString);
  let PARSER_MEDIA_TYPE = null;
  const SUPPORTED_PARSER_MEDIA_TYPES = ["application/xhtml+xml", "text/html"];
  const DEFAULT_PARSER_MEDIA_TYPE = "text/html";
  let transformCaseFunc = null;
  let CONFIG = null;
  const formElement = document2.createElement("form");
  const isRegexOrFunction = function isRegexOrFunction2(testValue) {
    return testValue instanceof RegExp || testValue instanceof Function;
  };
  const _parseConfig = function _parseConfig2() {
    let cfg = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    if (CONFIG && CONFIG === cfg) {
      return;
    }
    if (!cfg || typeof cfg !== "object") {
      cfg = {};
    }
    cfg = clone$1(cfg);
    PARSER_MEDIA_TYPE = // eslint-disable-next-line unicorn/prefer-includes
    SUPPORTED_PARSER_MEDIA_TYPES.indexOf(cfg.PARSER_MEDIA_TYPE) === -1 ? DEFAULT_PARSER_MEDIA_TYPE : cfg.PARSER_MEDIA_TYPE;
    transformCaseFunc = PARSER_MEDIA_TYPE === "application/xhtml+xml" ? stringToString : stringToLowerCase;
    ALLOWED_TAGS = objectHasOwnProperty(cfg, "ALLOWED_TAGS") ? addToSet({}, cfg.ALLOWED_TAGS, transformCaseFunc) : DEFAULT_ALLOWED_TAGS;
    ALLOWED_ATTR = objectHasOwnProperty(cfg, "ALLOWED_ATTR") ? addToSet({}, cfg.ALLOWED_ATTR, transformCaseFunc) : DEFAULT_ALLOWED_ATTR;
    ALLOWED_NAMESPACES = objectHasOwnProperty(cfg, "ALLOWED_NAMESPACES") ? addToSet({}, cfg.ALLOWED_NAMESPACES, stringToString) : DEFAULT_ALLOWED_NAMESPACES;
    URI_SAFE_ATTRIBUTES = objectHasOwnProperty(cfg, "ADD_URI_SAFE_ATTR") ? addToSet(
      clone$1(DEFAULT_URI_SAFE_ATTRIBUTES),
      // eslint-disable-line indent
      cfg.ADD_URI_SAFE_ATTR,
      // eslint-disable-line indent
      transformCaseFunc
      // eslint-disable-line indent
    ) : DEFAULT_URI_SAFE_ATTRIBUTES;
    DATA_URI_TAGS = objectHasOwnProperty(cfg, "ADD_DATA_URI_TAGS") ? addToSet(
      clone$1(DEFAULT_DATA_URI_TAGS),
      // eslint-disable-line indent
      cfg.ADD_DATA_URI_TAGS,
      // eslint-disable-line indent
      transformCaseFunc
      // eslint-disable-line indent
    ) : DEFAULT_DATA_URI_TAGS;
    FORBID_CONTENTS = objectHasOwnProperty(cfg, "FORBID_CONTENTS") ? addToSet({}, cfg.FORBID_CONTENTS, transformCaseFunc) : DEFAULT_FORBID_CONTENTS;
    FORBID_TAGS = objectHasOwnProperty(cfg, "FORBID_TAGS") ? addToSet({}, cfg.FORBID_TAGS, transformCaseFunc) : {};
    FORBID_ATTR = objectHasOwnProperty(cfg, "FORBID_ATTR") ? addToSet({}, cfg.FORBID_ATTR, transformCaseFunc) : {};
    USE_PROFILES = objectHasOwnProperty(cfg, "USE_PROFILES") ? cfg.USE_PROFILES : false;
    ALLOW_ARIA_ATTR = cfg.ALLOW_ARIA_ATTR !== false;
    ALLOW_DATA_ATTR = cfg.ALLOW_DATA_ATTR !== false;
    ALLOW_UNKNOWN_PROTOCOLS = cfg.ALLOW_UNKNOWN_PROTOCOLS || false;
    ALLOW_SELF_CLOSE_IN_ATTR = cfg.ALLOW_SELF_CLOSE_IN_ATTR !== false;
    SAFE_FOR_TEMPLATES = cfg.SAFE_FOR_TEMPLATES || false;
    SAFE_FOR_XML = cfg.SAFE_FOR_XML !== false;
    WHOLE_DOCUMENT = cfg.WHOLE_DOCUMENT || false;
    RETURN_DOM = cfg.RETURN_DOM || false;
    RETURN_DOM_FRAGMENT = cfg.RETURN_DOM_FRAGMENT || false;
    RETURN_TRUSTED_TYPE = cfg.RETURN_TRUSTED_TYPE || false;
    FORCE_BODY = cfg.FORCE_BODY || false;
    SANITIZE_DOM = cfg.SANITIZE_DOM !== false;
    SANITIZE_NAMED_PROPS = cfg.SANITIZE_NAMED_PROPS || false;
    KEEP_CONTENT = cfg.KEEP_CONTENT !== false;
    IN_PLACE = cfg.IN_PLACE || false;
    IS_ALLOWED_URI$1 = cfg.ALLOWED_URI_REGEXP || IS_ALLOWED_URI;
    NAMESPACE = cfg.NAMESPACE || HTML_NAMESPACE;
    CUSTOM_ELEMENT_HANDLING = cfg.CUSTOM_ELEMENT_HANDLING || {};
    if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck)) {
      CUSTOM_ELEMENT_HANDLING.tagNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck;
    }
    if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)) {
      CUSTOM_ELEMENT_HANDLING.attributeNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck;
    }
    if (cfg.CUSTOM_ELEMENT_HANDLING && typeof cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements === "boolean") {
      CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements = cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements;
    }
    if (SAFE_FOR_TEMPLATES) {
      ALLOW_DATA_ATTR = false;
    }
    if (RETURN_DOM_FRAGMENT) {
      RETURN_DOM = true;
    }
    if (USE_PROFILES) {
      ALLOWED_TAGS = addToSet({}, text);
      ALLOWED_ATTR = [];
      if (USE_PROFILES.html === true) {
        addToSet(ALLOWED_TAGS, html$1$1);
        addToSet(ALLOWED_ATTR, html$2);
      }
      if (USE_PROFILES.svg === true) {
        addToSet(ALLOWED_TAGS, svg$1);
        addToSet(ALLOWED_ATTR, svg);
        addToSet(ALLOWED_ATTR, xml);
      }
      if (USE_PROFILES.svgFilters === true) {
        addToSet(ALLOWED_TAGS, svgFilters);
        addToSet(ALLOWED_ATTR, svg);
        addToSet(ALLOWED_ATTR, xml);
      }
      if (USE_PROFILES.mathMl === true) {
        addToSet(ALLOWED_TAGS, mathMl$1);
        addToSet(ALLOWED_ATTR, mathMl);
        addToSet(ALLOWED_ATTR, xml);
      }
    }
    if (cfg.ADD_TAGS) {
      if (ALLOWED_TAGS === DEFAULT_ALLOWED_TAGS) {
        ALLOWED_TAGS = clone$1(ALLOWED_TAGS);
      }
      addToSet(ALLOWED_TAGS, cfg.ADD_TAGS, transformCaseFunc);
    }
    if (cfg.ADD_ATTR) {
      if (ALLOWED_ATTR === DEFAULT_ALLOWED_ATTR) {
        ALLOWED_ATTR = clone$1(ALLOWED_ATTR);
      }
      addToSet(ALLOWED_ATTR, cfg.ADD_ATTR, transformCaseFunc);
    }
    if (cfg.ADD_URI_SAFE_ATTR) {
      addToSet(URI_SAFE_ATTRIBUTES, cfg.ADD_URI_SAFE_ATTR, transformCaseFunc);
    }
    if (cfg.FORBID_CONTENTS) {
      if (FORBID_CONTENTS === DEFAULT_FORBID_CONTENTS) {
        FORBID_CONTENTS = clone$1(FORBID_CONTENTS);
      }
      addToSet(FORBID_CONTENTS, cfg.FORBID_CONTENTS, transformCaseFunc);
    }
    if (KEEP_CONTENT) {
      ALLOWED_TAGS["#text"] = true;
    }
    if (WHOLE_DOCUMENT) {
      addToSet(ALLOWED_TAGS, ["html", "head", "body"]);
    }
    if (ALLOWED_TAGS.table) {
      addToSet(ALLOWED_TAGS, ["tbody"]);
      delete FORBID_TAGS.tbody;
    }
    if (cfg.TRUSTED_TYPES_POLICY) {
      if (typeof cfg.TRUSTED_TYPES_POLICY.createHTML !== "function") {
        throw typeErrorCreate('TRUSTED_TYPES_POLICY configuration option must provide a "createHTML" hook.');
      }
      if (typeof cfg.TRUSTED_TYPES_POLICY.createScriptURL !== "function") {
        throw typeErrorCreate('TRUSTED_TYPES_POLICY configuration option must provide a "createScriptURL" hook.');
      }
      trustedTypesPolicy = cfg.TRUSTED_TYPES_POLICY;
      emptyHTML = trustedTypesPolicy.createHTML("");
    } else {
      if (trustedTypesPolicy === void 0) {
        trustedTypesPolicy = _createTrustedTypesPolicy(trustedTypes, currentScript);
      }
      if (trustedTypesPolicy !== null && typeof emptyHTML === "string") {
        emptyHTML = trustedTypesPolicy.createHTML("");
      }
    }
    if (freeze) {
      freeze(cfg);
    }
    CONFIG = cfg;
  };
  const MATHML_TEXT_INTEGRATION_POINTS = addToSet({}, ["mi", "mo", "mn", "ms", "mtext"]);
  const HTML_INTEGRATION_POINTS = addToSet({}, ["foreignobject", "annotation-xml"]);
  const COMMON_SVG_AND_HTML_ELEMENTS = addToSet({}, ["title", "style", "font", "a", "script"]);
  const ALL_SVG_TAGS = addToSet({}, [...svg$1, ...svgFilters, ...svgDisallowed]);
  const ALL_MATHML_TAGS = addToSet({}, [...mathMl$1, ...mathMlDisallowed]);
  const _checkValidNamespace = function _checkValidNamespace2(element) {
    let parent = getParentNode2(element);
    if (!parent || !parent.tagName) {
      parent = {
        namespaceURI: NAMESPACE,
        tagName: "template"
      };
    }
    const tagName2 = stringToLowerCase(element.tagName);
    const parentTagName = stringToLowerCase(parent.tagName);
    if (!ALLOWED_NAMESPACES[element.namespaceURI]) {
      return false;
    }
    if (element.namespaceURI === SVG_NAMESPACE) {
      if (parent.namespaceURI === HTML_NAMESPACE) {
        return tagName2 === "svg";
      }
      if (parent.namespaceURI === MATHML_NAMESPACE) {
        return tagName2 === "svg" && (parentTagName === "annotation-xml" || MATHML_TEXT_INTEGRATION_POINTS[parentTagName]);
      }
      return Boolean(ALL_SVG_TAGS[tagName2]);
    }
    if (element.namespaceURI === MATHML_NAMESPACE) {
      if (parent.namespaceURI === HTML_NAMESPACE) {
        return tagName2 === "math";
      }
      if (parent.namespaceURI === SVG_NAMESPACE) {
        return tagName2 === "math" && HTML_INTEGRATION_POINTS[parentTagName];
      }
      return Boolean(ALL_MATHML_TAGS[tagName2]);
    }
    if (element.namespaceURI === HTML_NAMESPACE) {
      if (parent.namespaceURI === SVG_NAMESPACE && !HTML_INTEGRATION_POINTS[parentTagName]) {
        return false;
      }
      if (parent.namespaceURI === MATHML_NAMESPACE && !MATHML_TEXT_INTEGRATION_POINTS[parentTagName]) {
        return false;
      }
      return !ALL_MATHML_TAGS[tagName2] && (COMMON_SVG_AND_HTML_ELEMENTS[tagName2] || !ALL_SVG_TAGS[tagName2]);
    }
    if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && ALLOWED_NAMESPACES[element.namespaceURI]) {
      return true;
    }
    return false;
  };
  const _forceRemove = function _forceRemove2(node) {
    arrayPush(DOMPurify.removed, {
      element: node
    });
    try {
      getParentNode2(node).removeChild(node);
    } catch (_2) {
      remove2(node);
    }
  };
  const _removeAttribute = function _removeAttribute2(name, node) {
    try {
      arrayPush(DOMPurify.removed, {
        attribute: node.getAttributeNode(name),
        from: node
      });
    } catch (_2) {
      arrayPush(DOMPurify.removed, {
        attribute: null,
        from: node
      });
    }
    node.removeAttribute(name);
    if (name === "is" && !ALLOWED_ATTR[name]) {
      if (RETURN_DOM || RETURN_DOM_FRAGMENT) {
        try {
          _forceRemove(node);
        } catch (_2) {
        }
      } else {
        try {
          node.setAttribute(name, "");
        } catch (_2) {
        }
      }
    }
  };
  const _initDocument = function _initDocument2(dirty) {
    let doc = null;
    let leadingWhitespace = null;
    if (FORCE_BODY) {
      dirty = "<remove></remove>" + dirty;
    } else {
      const matches2 = stringMatch(dirty, /^[\r\n\t ]+/);
      leadingWhitespace = matches2 && matches2[0];
    }
    if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && NAMESPACE === HTML_NAMESPACE) {
      dirty = '<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>' + dirty + "</body></html>";
    }
    const dirtyPayload = trustedTypesPolicy ? trustedTypesPolicy.createHTML(dirty) : dirty;
    if (NAMESPACE === HTML_NAMESPACE) {
      try {
        doc = new DOMParser2().parseFromString(dirtyPayload, PARSER_MEDIA_TYPE);
      } catch (_2) {
      }
    }
    if (!doc || !doc.documentElement) {
      doc = implementation.createDocument(NAMESPACE, "template", null);
      try {
        doc.documentElement.innerHTML = IS_EMPTY_INPUT ? emptyHTML : dirtyPayload;
      } catch (_2) {
      }
    }
    const body = doc.body || doc.documentElement;
    if (dirty && leadingWhitespace) {
      body.insertBefore(document2.createTextNode(leadingWhitespace), body.childNodes[0] || null);
    }
    if (NAMESPACE === HTML_NAMESPACE) {
      return getElementsByTagName.call(doc, WHOLE_DOCUMENT ? "html" : "body")[0];
    }
    return WHOLE_DOCUMENT ? doc.documentElement : body;
  };
  const _createNodeIterator = function _createNodeIterator2(root2) {
    return createNodeIterator.call(
      root2.ownerDocument || root2,
      root2,
      // eslint-disable-next-line no-bitwise
      NodeFilter.SHOW_ELEMENT | NodeFilter.SHOW_COMMENT | NodeFilter.SHOW_TEXT | NodeFilter.SHOW_PROCESSING_INSTRUCTION | NodeFilter.SHOW_CDATA_SECTION,
      null
    );
  };
  const _isClobbered = function _isClobbered2(elm) {
    return elm instanceof HTMLFormElement && (typeof elm.nodeName !== "string" || typeof elm.textContent !== "string" || typeof elm.removeChild !== "function" || !(elm.attributes instanceof NamedNodeMap) || typeof elm.removeAttribute !== "function" || typeof elm.setAttribute !== "function" || typeof elm.namespaceURI !== "string" || typeof elm.insertBefore !== "function" || typeof elm.hasChildNodes !== "function");
  };
  const _isNode = function _isNode2(object) {
    return typeof Node3 === "function" && object instanceof Node3;
  };
  const _executeHook = function _executeHook2(entryPoint, currentNode, data12) {
    if (!hooks2[entryPoint]) {
      return;
    }
    arrayForEach(hooks2[entryPoint], (hook) => {
      hook.call(DOMPurify, currentNode, data12, CONFIG);
    });
  };
  const _sanitizeElements = function _sanitizeElements2(currentNode) {
    let content = null;
    _executeHook("beforeSanitizeElements", currentNode, null);
    if (_isClobbered(currentNode)) {
      _forceRemove(currentNode);
      return true;
    }
    const tagName2 = transformCaseFunc(currentNode.nodeName);
    _executeHook("uponSanitizeElement", currentNode, {
      tagName: tagName2,
      allowedTags: ALLOWED_TAGS
    });
    if (currentNode.hasChildNodes() && !_isNode(currentNode.firstElementChild) && regExpTest(/<[/\w]/g, currentNode.innerHTML) && regExpTest(/<[/\w]/g, currentNode.textContent)) {
      _forceRemove(currentNode);
      return true;
    }
    if (currentNode.nodeType === NODE_TYPE.progressingInstruction) {
      _forceRemove(currentNode);
      return true;
    }
    if (SAFE_FOR_XML && currentNode.nodeType === NODE_TYPE.comment && regExpTest(/<[/\w]/g, currentNode.data)) {
      _forceRemove(currentNode);
      return true;
    }
    if (!ALLOWED_TAGS[tagName2] || FORBID_TAGS[tagName2]) {
      if (!FORBID_TAGS[tagName2] && _isBasicCustomElement(tagName2)) {
        if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, tagName2)) {
          return false;
        }
        if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(tagName2)) {
          return false;
        }
      }
      if (KEEP_CONTENT && !FORBID_CONTENTS[tagName2]) {
        const parentNode2 = getParentNode2(currentNode) || currentNode.parentNode;
        const childNodes = getChildNodes(currentNode) || currentNode.childNodes;
        if (childNodes && parentNode2) {
          const childCount = childNodes.length;
          for (let i2 = childCount - 1; i2 >= 0; --i2) {
            const childClone = cloneNode(childNodes[i2], true);
            childClone.__removalCount = (currentNode.__removalCount || 0) + 1;
            parentNode2.insertBefore(childClone, getNextSibling(currentNode));
          }
        }
      }
      _forceRemove(currentNode);
      return true;
    }
    if (currentNode instanceof Element2 && !_checkValidNamespace(currentNode)) {
      _forceRemove(currentNode);
      return true;
    }
    if ((tagName2 === "noscript" || tagName2 === "noembed" || tagName2 === "noframes") && regExpTest(/<\/no(script|embed|frames)/i, currentNode.innerHTML)) {
      _forceRemove(currentNode);
      return true;
    }
    if (SAFE_FOR_TEMPLATES && currentNode.nodeType === NODE_TYPE.text) {
      content = currentNode.textContent;
      arrayForEach([MUSTACHE_EXPR2, ERB_EXPR2, TMPLIT_EXPR2], (expr) => {
        content = stringReplace(content, expr, " ");
      });
      if (currentNode.textContent !== content) {
        arrayPush(DOMPurify.removed, {
          element: currentNode.cloneNode()
        });
        currentNode.textContent = content;
      }
    }
    _executeHook("afterSanitizeElements", currentNode, null);
    return false;
  };
  const _isValidAttribute = function _isValidAttribute2(lcTag, lcName, value3) {
    if (SANITIZE_DOM && (lcName === "id" || lcName === "name") && (value3 in document2 || value3 in formElement)) {
      return false;
    }
    if (ALLOW_DATA_ATTR && !FORBID_ATTR[lcName] && regExpTest(DATA_ATTR2, lcName)) ;
    else if (ALLOW_ARIA_ATTR && regExpTest(ARIA_ATTR2, lcName)) ;
    else if (!ALLOWED_ATTR[lcName] || FORBID_ATTR[lcName]) {
      if (
        // First condition does a very basic check if a) it's basically a valid custom element tagname AND
        // b) if the tagName passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
        // and c) if the attribute name passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.attributeNameCheck
        _isBasicCustomElement(lcTag) && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, lcTag) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(lcTag)) && (CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.attributeNameCheck, lcName) || CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.attributeNameCheck(lcName)) || // Alternative, second condition checks if it's an `is`-attribute, AND
        // the value passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
        lcName === "is" && CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, value3) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(value3))
      ) ;
      else {
        return false;
      }
    } else if (URI_SAFE_ATTRIBUTES[lcName]) ;
    else if (regExpTest(IS_ALLOWED_URI$1, stringReplace(value3, ATTR_WHITESPACE2, ""))) ;
    else if ((lcName === "src" || lcName === "xlink:href" || lcName === "href") && lcTag !== "script" && stringIndexOf$1(value3, "data:") === 0 && DATA_URI_TAGS[lcTag]) ;
    else if (ALLOW_UNKNOWN_PROTOCOLS && !regExpTest(IS_SCRIPT_OR_DATA2, stringReplace(value3, ATTR_WHITESPACE2, ""))) ;
    else if (value3) {
      return false;
    } else ;
    return true;
  };
  const _isBasicCustomElement = function _isBasicCustomElement2(tagName2) {
    return tagName2 !== "annotation-xml" && stringMatch(tagName2, CUSTOM_ELEMENT2);
  };
  const _sanitizeAttributes = function _sanitizeAttributes2(currentNode) {
    _executeHook("beforeSanitizeAttributes", currentNode, null);
    const {
      attributes
    } = currentNode;
    if (!attributes) {
      return;
    }
    const hookEvent = {
      attrName: "",
      attrValue: "",
      keepAttr: true,
      allowedAttributes: ALLOWED_ATTR
    };
    let l2 = attributes.length;
    while (l2--) {
      const attr = attributes[l2];
      const {
        name,
        namespaceURI,
        value: attrValue
      } = attr;
      const lcName = transformCaseFunc(name);
      let value3 = name === "value" ? attrValue : stringTrim$1(attrValue);
      hookEvent.attrName = lcName;
      hookEvent.attrValue = value3;
      hookEvent.keepAttr = true;
      hookEvent.forceKeepAttr = void 0;
      _executeHook("uponSanitizeAttribute", currentNode, hookEvent);
      value3 = hookEvent.attrValue;
      if (SAFE_FOR_XML && regExpTest(/((--!?|])>)|<\/(style|title)/i, value3)) {
        _removeAttribute(name, currentNode);
        continue;
      }
      if (hookEvent.forceKeepAttr) {
        continue;
      }
      _removeAttribute(name, currentNode);
      if (!hookEvent.keepAttr) {
        continue;
      }
      if (!ALLOW_SELF_CLOSE_IN_ATTR && regExpTest(/\/>/i, value3)) {
        _removeAttribute(name, currentNode);
        continue;
      }
      if (SAFE_FOR_TEMPLATES) {
        arrayForEach([MUSTACHE_EXPR2, ERB_EXPR2, TMPLIT_EXPR2], (expr) => {
          value3 = stringReplace(value3, expr, " ");
        });
      }
      const lcTag = transformCaseFunc(currentNode.nodeName);
      if (!_isValidAttribute(lcTag, lcName, value3)) {
        continue;
      }
      if (SANITIZE_NAMED_PROPS && (lcName === "id" || lcName === "name")) {
        _removeAttribute(name, currentNode);
        value3 = SANITIZE_NAMED_PROPS_PREFIX + value3;
      }
      if (trustedTypesPolicy && typeof trustedTypes === "object" && typeof trustedTypes.getAttributeType === "function") {
        if (namespaceURI) ;
        else {
          switch (trustedTypes.getAttributeType(lcTag, lcName)) {
            case "TrustedHTML": {
              value3 = trustedTypesPolicy.createHTML(value3);
              break;
            }
            case "TrustedScriptURL": {
              value3 = trustedTypesPolicy.createScriptURL(value3);
              break;
            }
          }
        }
      }
      try {
        if (namespaceURI) {
          currentNode.setAttributeNS(namespaceURI, name, value3);
        } else {
          currentNode.setAttribute(name, value3);
        }
        if (_isClobbered(currentNode)) {
          _forceRemove(currentNode);
        } else {
          arrayPop(DOMPurify.removed);
        }
      } catch (_2) {
      }
    }
    _executeHook("afterSanitizeAttributes", currentNode, null);
  };
  const _sanitizeShadowDOM = function _sanitizeShadowDOM2(fragment) {
    let shadowNode = null;
    const shadowIterator = _createNodeIterator(fragment);
    _executeHook("beforeSanitizeShadowDOM", fragment, null);
    while (shadowNode = shadowIterator.nextNode()) {
      _executeHook("uponSanitizeShadowNode", shadowNode, null);
      if (_sanitizeElements(shadowNode)) {
        continue;
      }
      if (shadowNode.content instanceof DocumentFragment) {
        _sanitizeShadowDOM2(shadowNode.content);
      }
      _sanitizeAttributes(shadowNode);
    }
    _executeHook("afterSanitizeShadowDOM", fragment, null);
  };
  DOMPurify.sanitize = function(dirty) {
    let cfg = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    let body = null;
    let importedNode = null;
    let currentNode = null;
    let returnNode = null;
    IS_EMPTY_INPUT = !dirty;
    if (IS_EMPTY_INPUT) {
      dirty = "<!-->";
    }
    if (typeof dirty !== "string" && !_isNode(dirty)) {
      if (typeof dirty.toString === "function") {
        dirty = dirty.toString();
        if (typeof dirty !== "string") {
          throw typeErrorCreate("dirty is not a string, aborting");
        }
      } else {
        throw typeErrorCreate("toString is not a function");
      }
    }
    if (!DOMPurify.isSupported) {
      return dirty;
    }
    if (!SET_CONFIG) {
      _parseConfig(cfg);
    }
    DOMPurify.removed = [];
    if (typeof dirty === "string") {
      IN_PLACE = false;
    }
    if (IN_PLACE) {
      if (dirty.nodeName) {
        const tagName2 = transformCaseFunc(dirty.nodeName);
        if (!ALLOWED_TAGS[tagName2] || FORBID_TAGS[tagName2]) {
          throw typeErrorCreate("root node is forbidden and cannot be sanitized in-place");
        }
      }
    } else if (dirty instanceof Node3) {
      body = _initDocument("<!---->");
      importedNode = body.ownerDocument.importNode(dirty, true);
      if (importedNode.nodeType === NODE_TYPE.element && importedNode.nodeName === "BODY") {
        body = importedNode;
      } else if (importedNode.nodeName === "HTML") {
        body = importedNode;
      } else {
        body.appendChild(importedNode);
      }
    } else {
      if (!RETURN_DOM && !SAFE_FOR_TEMPLATES && !WHOLE_DOCUMENT && // eslint-disable-next-line unicorn/prefer-includes
      dirty.indexOf("<") === -1) {
        return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(dirty) : dirty;
      }
      body = _initDocument(dirty);
      if (!body) {
        return RETURN_DOM ? null : RETURN_TRUSTED_TYPE ? emptyHTML : "";
      }
    }
    if (body && FORCE_BODY) {
      _forceRemove(body.firstChild);
    }
    const nodeIterator = _createNodeIterator(IN_PLACE ? dirty : body);
    while (currentNode = nodeIterator.nextNode()) {
      if (_sanitizeElements(currentNode)) {
        continue;
      }
      if (currentNode.content instanceof DocumentFragment) {
        _sanitizeShadowDOM(currentNode.content);
      }
      _sanitizeAttributes(currentNode);
    }
    if (IN_PLACE) {
      return dirty;
    }
    if (RETURN_DOM) {
      if (RETURN_DOM_FRAGMENT) {
        returnNode = createDocumentFragment.call(body.ownerDocument);
        while (body.firstChild) {
          returnNode.appendChild(body.firstChild);
        }
      } else {
        returnNode = body;
      }
      if (ALLOWED_ATTR.shadowroot || ALLOWED_ATTR.shadowrootmode) {
        returnNode = importNode.call(originalDocument, returnNode, true);
      }
      return returnNode;
    }
    let serializedHTML = WHOLE_DOCUMENT ? body.outerHTML : body.innerHTML;
    if (WHOLE_DOCUMENT && ALLOWED_TAGS["!doctype"] && body.ownerDocument && body.ownerDocument.doctype && body.ownerDocument.doctype.name && regExpTest(DOCTYPE_NAME, body.ownerDocument.doctype.name)) {
      serializedHTML = "<!DOCTYPE " + body.ownerDocument.doctype.name + ">\n" + serializedHTML;
    }
    if (SAFE_FOR_TEMPLATES) {
      arrayForEach([MUSTACHE_EXPR2, ERB_EXPR2, TMPLIT_EXPR2], (expr) => {
        serializedHTML = stringReplace(serializedHTML, expr, " ");
      });
    }
    return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(serializedHTML) : serializedHTML;
  };
  DOMPurify.setConfig = function() {
    let cfg = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    _parseConfig(cfg);
    SET_CONFIG = true;
  };
  DOMPurify.clearConfig = function() {
    CONFIG = null;
    SET_CONFIG = false;
  };
  DOMPurify.isValidAttribute = function(tag, attr, value3) {
    if (!CONFIG) {
      _parseConfig({});
    }
    const lcTag = transformCaseFunc(tag);
    const lcName = transformCaseFunc(attr);
    return _isValidAttribute(lcTag, lcName, value3);
  };
  DOMPurify.addHook = function(entryPoint, hookFunction) {
    if (typeof hookFunction !== "function") {
      return;
    }
    hooks2[entryPoint] = hooks2[entryPoint] || [];
    arrayPush(hooks2[entryPoint], hookFunction);
  };
  DOMPurify.removeHook = function(entryPoint) {
    if (hooks2[entryPoint]) {
      return arrayPop(hooks2[entryPoint]);
    }
  };
  DOMPurify.removeHooks = function(entryPoint) {
    if (hooks2[entryPoint]) {
      hooks2[entryPoint] = [];
    }
  };
  DOMPurify.removeAllHooks = function() {
    hooks2 = {};
  };
  return DOMPurify;
}
var purify = createDOMPurify();
/*!
 * escape-html
 * Copyright(c) 2012-2013 TJ Holowaychuk
 * Copyright(c) 2015 Andreas Lubbe
 * Copyright(c) 2015 Tiancheng "Timothy" Gu
 * MIT Licensed
 */
var matchHtmlRegExp = /["'&<>]/;
var escapeHtml_1 = escapeHtml;
function escapeHtml(string) {
  var str = "" + string;
  var match6 = matchHtmlRegExp.exec(str);
  if (!match6) {
    return str;
  }
  var escape2;
  var html2 = "";
  var index2 = 0;
  var lastIndex = 0;
  for (index2 = match6.index; index2 < str.length; index2++) {
    switch (str.charCodeAt(index2)) {
      case 34:
        escape2 = "&quot;";
        break;
      case 38:
        escape2 = "&amp;";
        break;
      case 39:
        escape2 = "&#39;";
        break;
      case 60:
        escape2 = "&lt;";
        break;
      case 62:
        escape2 = "&gt;";
        break;
      default:
        continue;
    }
    if (lastIndex !== index2) {
      html2 += str.substring(lastIndex, index2);
    }
    lastIndex = index2 + 1;
    html2 += escape2;
  }
  return lastIndex !== index2 ? html2 + str.substring(lastIndex, index2) : html2;
}
const escapeHtml$1 = /* @__PURE__ */ getDefaultExportFromCjs(escapeHtml_1);
var __defProp$5 = Object.defineProperty;
var __defNormalProp$5 = (obj, key, value3) => key in obj ? __defProp$5(obj, key, { enumerable: true, configurable: true, writable: true, value: value3 }) : obj[key] = value3;
var __publicField$4 = (obj, key, value3) => {
  __defNormalProp$5(obj, typeof key !== "symbol" ? key + "" : key, value3);
  return value3;
};
let GettextBuilder$1 = class GettextBuilder {
  constructor() {
    __publicField$4(this, "locale");
    __publicField$4(this, "translations", {});
    __publicField$4(this, "debug", false);
  }
  setLanguage(language) {
    this.locale = language;
    return this;
  }
  /** Try to detect locale from context with `en` as fallback value */
  detectLocale() {
    return this.setLanguage(getLanguage$1().replace("-", "_"));
  }
  addTranslation(language, data12) {
    this.translations[language] = data12;
    return this;
  }
  enableDebugMode() {
    this.debug = true;
    return this;
  }
  build() {
    return new GettextWrapper$1(this.locale || "en", this.translations, this.debug);
  }
};
let GettextWrapper$1 = class GettextWrapper {
  constructor(locale3, data12, debug2) {
    __publicField$4(this, "gt");
    this.gt = new GetText({
      debug: debug2,
      sourceLocale: "en"
    });
    for (const key in data12) {
      this.gt.addTranslations(key, "messages", data12[key]);
    }
    this.gt.setLocale(locale3);
  }
  subtitudePlaceholders(translated, vars) {
    return translated.replace(/{([^{}]*)}/g, (a3, b2) => {
      const r2 = vars[b2];
      if (typeof r2 === "string" || typeof r2 === "number") {
        return r2.toString();
      } else {
        return a3;
      }
    });
  }
  /**
   * Get translated string (singular form), optionally with placeholders
   *
   * @param original original string to translate
   * @param placeholders map of placeholder key to value
   */
  gettext(original, placeholders = {}) {
    return this.subtitudePlaceholders(
      this.gt.gettext(original),
      placeholders
    );
  }
  /**
   * Get translated string with plural forms
   *
   * @param singular Singular text form
   * @param plural Plural text form to be used if `count` requires it
   * @param count The number to insert into the text
   * @param placeholders optional map of placeholder key to value
   */
  ngettext(singular, plural, count, placeholders = {}) {
    return this.subtitudePlaceholders(
      this.gt.ngettext(singular, plural, count).replace(/%n/g, count.toString()),
      placeholders
    );
  }
};
function getGettextBuilder$1() {
  return new GettextBuilder$1();
}
const gtBuilder = getGettextBuilder$1().detectLocale();
[{ "locale": "af", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Afrikaans (https://app.transifex.com/nextcloud/teams/64236/af/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "af", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Afrikaans (https://app.transifex.com/nextcloud/teams/64236/af/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: af\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "ar", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Ali <alimahwer@yahoo.com>, 2024", "Language-Team": "Arabic (https://app.transifex.com/nextcloud/teams/64236/ar/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "ar", "Plural-Forms": "nplurals=6; plural=n==0 ? 0 : n==1 ? 1 : n==2 ? 2 : n%100>=3 && n%100<=10 ? 3 : n%100>=11 && n%100<=99 ? 4 : 5;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nAli <alimahwer@yahoo.com>, 2024\n" }, "msgstr": ["Last-Translator: Ali <alimahwer@yahoo.com>, 2024\nLanguage-Team: Arabic (https://app.transifex.com/nextcloud/teams/64236/ar/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: ar\nPlural-Forms: nplurals=6; plural=n==0 ? 0 : n==1 ? 1 : n==2 ? 2 : n%100>=3 && n%100<=10 ? 3 : n%100>=11 && n%100<=99 ? 4 : 5;\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" لا يصلح كاسم مجلد.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" غير مسموح به كاسم مجلد'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" غير مسموح به داخل اسم مجلد.'] }, "All files": { "msgid": "All files", "msgstr": ["كل الملفات"] }, "Choose": { "msgid": "Choose", "msgstr": ["إختَر"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["إختَر {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["إختَر %n ملف", "إختَر %n ملف", "إختَر %n ملف", "إختَر %n ملفات", "إختَر %n ملف", "إختَر %n ملف"] }, "Copy": { "msgid": "Copy", "msgstr": ["نسخ"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["نسخٌ إلى {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["تعذّر إنشاء المجلد الجديد"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["يتعذّر تحميل إعدادات الملفات"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["يتعذّر تحميل مناظير views الملفات"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["أنشِيءْ مجلّداً"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["مُنتقِي المنظور الحالي"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["المُفضَّلة"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["الملفات و المجلدات التي تُميِّزُها كمٌفضَّلة ستظهر هنا."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["الملفات و المجلدات التي قمت مؤخراً بتعديلها سوف تظهر هنا."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["فلترة قائمة الملفات"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["اسم المجلد لا يمكن أن يكون فارغاً."] }, "Home": { "msgid": "Home", "msgstr": ["البداية"] }, "Modified": { "msgid": "Modified", "msgstr": ["مُعدَّل"] }, "Move": { "msgid": "Move", "msgstr": ["أُنقُل"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["أُنقُل إلى {target}"] }, "Name": { "msgid": "Name", "msgstr": ["الاسم"] }, "New": { "msgid": "New", "msgstr": ["جديد"] }, "New folder": { "msgid": "New folder", "msgstr": ["مٌجلّد جديد"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["اسم المجلد الجديد"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["لا توجد ملفات هنا"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["لا توجد ملفات تتطابق مع الفلتر الذي وضعته"] }, "No matching files": { "msgid": "No matching files", "msgstr": ["لا توجد ملفات مُطابِقة"] }, "Recent": { "msgid": "Recent", "msgstr": ["الحالي"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["حدِّد كل المداخل"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["إختَر المدخل"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["إختر سطر الـ {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["الحجم"] }, "Undo": { "msgid": "Undo", "msgstr": ["تراجع"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["قُم برفع محتوىً أو قُم بمزامنة أجهزتك!"] } } } } }, { "locale": "ast", "json": { "charset": "utf-8", "headers": { "Last-Translator": "enolp <enolp@softastur.org>, 2024", "Language-Team": "Asturian (https://app.transifex.com/nextcloud/teams/64236/ast/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "ast", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nenolp <enolp@softastur.org>, 2024\n" }, "msgstr": ["Last-Translator: enolp <enolp@softastur.org>, 2024\nLanguage-Team: Asturian (https://app.transifex.com/nextcloud/teams/64236/ast/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: ast\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ["«{name}» ye un nome de carpeta inválidu."] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ["«{name}» ye un nome de carpeta inválidu"] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ["Nun se permite'l caráuter «/» dientro'l nome de les carpetes."] }, "All files": { "msgid": "All files", "msgstr": ["Tolos ficheros"] }, "Choose": { "msgid": "Choose", "msgstr": ["Escoyer"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Escoyer «{ficheru}»"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Escoyer %n ficheru", "Escoyer %n ficheros"] }, "Copy": { "msgid": "Copy", "msgstr": ["Copiar"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Copiar en: {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Nun se pudo crear la carpeta"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Nun se pudo cargar la configuración de los ficheros"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Nun se pudieron cargar les vistes de los ficheros"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Crear un direutoriu"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Selector de la vista actual"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Favoritos"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Equí apaecen los ficheros y les carpetes que metas en Favoritos."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Equí apaecen los fichero y les carpetes que modificares apocayá."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Peñerar la llista de ficheros"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["El nome de la carpeta nun pue tar baleru."] }, "Home": { "msgid": "Home", "msgstr": ["Aniciu"] }, "Modified": { "msgid": "Modified", "msgstr": ["Modificóse"] }, "Move": { "msgid": "Move", "msgstr": ["Mover"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Mover a {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Nome"] }, "New": { "msgid": "New", "msgstr": ["Nuevu"] }, "New folder": { "msgid": "New folder", "msgstr": ["Carpeta nueva"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Nome de carpeta nuevu"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Equí nun hai nengún ficheru"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Nun s'atopó nengún ficheru que concasare cola peñera."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Nun hai nengún ficheru que concase"] }, "Recent": { "msgid": "Recent", "msgstr": ["De recién"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Seleicionar toles entraes"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Seleicionar la entrada"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Seleicionar la filera de: {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Tamañu"] }, "Undo": { "msgid": "Undo", "msgstr": ["Desfacer"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["¡Xubi dalgún elementu o sincroniza colos tos preseos!"] } } } } }, { "locale": "az", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Azerbaijani (https://app.transifex.com/nextcloud/teams/64236/az/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "az", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Azerbaijani (https://app.transifex.com/nextcloud/teams/64236/az/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: az\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "be", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Belarusian (https://app.transifex.com/nextcloud/teams/64236/be/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "be", "Plural-Forms": "nplurals=4; plural=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<12 || n%100>14) ? 1 : n%10==0 || (n%10>=5 && n%10<=9) || (n%100>=11 && n%100<=14)? 2 : 3);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Belarusian (https://app.transifex.com/nextcloud/teams/64236/be/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: be\nPlural-Forms: nplurals=4; plural=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<12 || n%100>14) ? 1 : n%10==0 || (n%10>=5 && n%10<=9) || (n%100>=11 && n%100<=14)? 2 : 3);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "bg_BG", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Bulgarian (Bulgaria) (https://app.transifex.com/nextcloud/teams/64236/bg_BG/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "bg_BG", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Bulgarian (Bulgaria) (https://app.transifex.com/nextcloud/teams/64236/bg_BG/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: bg_BG\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "bn_BD", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Bengali (Bangladesh) (https://app.transifex.com/nextcloud/teams/64236/bn_BD/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "bn_BD", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Bengali (Bangladesh) (https://app.transifex.com/nextcloud/teams/64236/bn_BD/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: bn_BD\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "br", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Breton (https://app.transifex.com/nextcloud/teams/64236/br/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "br", "Plural-Forms": "nplurals=5; plural=((n%10 == 1) && (n%100 != 11) && (n%100 !=71) && (n%100 !=91) ? 0 :(n%10 == 2) && (n%100 != 12) && (n%100 !=72) && (n%100 !=92) ? 1 :(n%10 ==3 || n%10==4 || n%10==9) && (n%100 < 10 || n% 100 > 19) && (n%100 < 70 || n%100 > 79) && (n%100 < 90 || n%100 > 99) ? 2 :(n != 0 && n % 1000000 == 0) ? 3 : 4);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Breton (https://app.transifex.com/nextcloud/teams/64236/br/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: br\nPlural-Forms: nplurals=5; plural=((n%10 == 1) && (n%100 != 11) && (n%100 !=71) && (n%100 !=91) ? 0 :(n%10 == 2) && (n%100 != 12) && (n%100 !=72) && (n%100 !=92) ? 1 :(n%10 ==3 || n%10==4 || n%10==9) && (n%100 < 10 || n% 100 > 19) && (n%100 < 70 || n%100 > 79) && (n%100 < 90 || n%100 > 99) ? 2 :(n != 0 && n % 1000000 == 0) ? 3 : 4);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["Disober"] } } } } }, { "locale": "bs", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Bosnian (https://app.transifex.com/nextcloud/teams/64236/bs/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "bs", "Plural-Forms": "nplurals=3; plural=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Bosnian (https://app.transifex.com/nextcloud/teams/64236/bs/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: bs\nPlural-Forms: nplurals=3; plural=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "ca", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Sergi Font, 2024", "Language-Team": "Catalan (https://app.transifex.com/nextcloud/teams/64236/ca/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "ca", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nv v <e670006006@gmail.com>, 2024\nMarc Riera <marcriera@softcatala.org>, 2024\nSergi Font, 2024\n" }, "msgstr": ["Last-Translator: Sergi Font, 2024\nLanguage-Team: Catalan (https://app.transifex.com/nextcloud/teams/64236/ca/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: ca\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" és un nom de carpeta no vàlid.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" no és permès en el nom de carpeta'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" no és permès en el nom de carpeta.'] }, "All files": { "msgid": "All files", "msgstr": ["Tots els fitxers"] }, "Choose": { "msgid": "Choose", "msgstr": ["Tria"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Tria {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Tria %n fitxer", "Tria %n fitxers"] }, "Copy": { "msgid": "Copy", "msgstr": ["Copia"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Copia a {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["No s'ha pogut crear la carpeta nova"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["No es poden carregar fitxers de configuració"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["No es poden carregar fitxers de vistes"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Crear directori"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Selector de visualització actual"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Preferits"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Els fitxers i les carpetes que marqueu com a favorits es mostraran aquí."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Els fitxers i les carpetes recentment modificats es mostraran aquí."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Filtrar llistat de fitxers"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["El nom de la carpeta no pot estar buit."] }, "Home": { "msgid": "Home", "msgstr": ["Inici"] }, "Modified": { "msgid": "Modified", "msgstr": ["Data de modificació"] }, "Move": { "msgid": "Move", "msgstr": ["Desplaça"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Desplaça a {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Nom"] }, "New": { "msgid": "New", "msgstr": ["Crea"] }, "New folder": { "msgid": "New folder", "msgstr": ["Carpeta nova"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Nom de la carpeta nova"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["No hi ha cap fitxer"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["No s'ha trobat cap fitxer que coincideixi amb el filtre."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["No hi ha cap fitxer que coincideixi"] }, "Recent": { "msgid": "Recent", "msgstr": ["Recents"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Selecciona totes les entrades"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Selecciona l'entrada"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Selecciona la fila per a {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Mida"] }, "Undo": { "msgid": "Undo", "msgstr": ["Desfés"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Pugeu contingut o sincronitzeu-lo amb els vostres dispositius!"] } } } } }, { "locale": "cs", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Pavel Borecki <pavel.borecki@gmail.com>, 2020", "Language-Team": "Czech (https://www.transifex.com/nextcloud/teams/64236/cs/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "cs", "Plural-Forms": "nplurals=4; plural=(n == 1 && n % 1 == 0) ? 0 : (n >= 2 && n <= 4 && n % 1 == 0) ? 1: (n % 1 != 0 ) ? 2 : 3;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nPavel Borecki <pavel.borecki@gmail.com>, 2020\n" }, "msgstr": ["Last-Translator: Pavel Borecki <pavel.borecki@gmail.com>, 2020\nLanguage-Team: Czech (https://www.transifex.com/nextcloud/teams/64236/cs/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: cs\nPlural-Forms: nplurals=4; plural=(n == 1 && n % 1 == 0) ? 0 : (n >= 2 && n <= 4 && n % 1 == 0) ? 1: (n % 1 != 0 ) ? 2 : 3;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:187" }, "msgstr": ["Zpět"] } } } } }, { "locale": "cs_CZ", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Pavel Borecki <pavel.borecki@gmail.com>, 2024", "Language-Team": "Czech (Czech Republic) (https://app.transifex.com/nextcloud/teams/64236/cs_CZ/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "cs_CZ", "Plural-Forms": "nplurals=4; plural=(n == 1 && n % 1 == 0) ? 0 : (n >= 2 && n <= 4 && n % 1 == 0) ? 1: (n % 1 != 0 ) ? 2 : 3;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nPavel Borecki <pavel.borecki@gmail.com>, 2024\n" }, "msgstr": ["Last-Translator: Pavel Borecki <pavel.borecki@gmail.com>, 2024\nLanguage-Team: Czech (Czech Republic) (https://app.transifex.com/nextcloud/teams/64236/cs_CZ/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: cs_CZ\nPlural-Forms: nplurals=4; plural=(n == 1 && n % 1 == 0) ? 0 : (n >= 2 && n <= 4 && n % 1 == 0) ? 1: (n % 1 != 0 ) ? 2 : 3;\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ["„{name}“ není platný název složky."] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ["„{name}“ není povolený název složky."] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ["znak „/“ (dopředné lomítko) není možné použít v názvu složky."] }, "All files": { "msgid": "All files", "msgstr": ["Veškeré soubory"] }, "Choose": { "msgid": "Choose", "msgstr": ["Zvolit"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Zvolit {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Zvolte %n soubor", "Zvolte %n soubory", "Zvolte %n souborů", "Zvolte %n soubory"] }, "Copy": { "msgid": "Copy", "msgstr": ["Zkopírovat"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Zkopírovat do {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Novou složku se nepodařilo vytvořit"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Nepodařilo se načíst nastavení pro soubory"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Nepodařilo se načíst pohledy souborů"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Vytvořit složku"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Výběr stávajícího zobrazení"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Oblíbené"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Zde se zobrazí soubory a složky, které označíte jako oblíbené."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Zde se zobrazí soubory a složky, které jste nedávno pozměnili."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Filtrovat seznam souborů"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Složku je třeba nějak nazvat."] }, "Home": { "msgid": "Home", "msgstr": ["Domů"] }, "Modified": { "msgid": "Modified", "msgstr": ["Změněno"] }, "Move": { "msgid": "Move", "msgstr": ["Přesounout"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Přesunout do {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Název"] }, "New": { "msgid": "New", "msgstr": ["Nové"] }, "New folder": { "msgid": "New folder", "msgstr": ["Nová složka"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Název pro novou složku"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Nejsou zde žádné soubory"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Nenalezeny žádné soubory odpovídající vašemu filtru"] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Žádné odpovídající soubory"] }, "Recent": { "msgid": "Recent", "msgstr": ["Nedávné"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Vybrat všechny položky"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Vybrat položku"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Vybrat řádek pro {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Velikost"] }, "Undo": { "msgid": "Undo", "msgstr": ["Zpět"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Nahrajte nějaký obsah nebo proveďte synchronizaci se svými zařízeními!"] } } } } }, { "locale": "cy_GB", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Welsh (United Kingdom) (https://app.transifex.com/nextcloud/teams/64236/cy_GB/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "cy_GB", "Plural-Forms": "nplurals=4; plural=(n==1) ? 0 : (n==2) ? 1 : (n != 8 && n != 11) ? 2 : 3;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Welsh (United Kingdom) (https://app.transifex.com/nextcloud/teams/64236/cy_GB/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: cy_GB\nPlural-Forms: nplurals=4; plural=(n==1) ? 0 : (n==2) ? 1 : (n != 8 && n != 11) ? 2 : 3;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "da", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Martin Bonde <Martin@maboni.dk>, 2024", "Language-Team": "Danish (https://app.transifex.com/nextcloud/teams/64236/da/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "da", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nMartin Bonde <Martin@maboni.dk>, 2024\n" }, "msgstr": ["Last-Translator: Martin Bonde <Martin@maboni.dk>, 2024\nLanguage-Team: Danish (https://app.transifex.com/nextcloud/teams/64236/da/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: da\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" er et ugyldigt mappenavn.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" er ikke et tilladt mappenavn'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" er ikke tilladt i et mappenavn.'] }, "All files": { "msgid": "All files", "msgstr": ["Alle filer"] }, "Choose": { "msgid": "Choose", "msgstr": ["Vælg"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Vælg {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Vælg %n fil", "Vælg %n filer"] }, "Copy": { "msgid": "Copy", "msgstr": ["Kopier"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Kopier til {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Kunne ikke oprette den nye mappe"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Filindstillingerne kunne ikke indlæses"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Kunne ikke indlæse filvisninger"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Opret mappe"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Aktuel visningsvælger"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Favoritter"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Filer og mapper, du markerer som foretrukne, vises her."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Filer og mapper, du for nylig har ændret, vises her."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Filtrer fil liste"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Mappenavnet må ikke være tomt."] }, "Home": { "msgid": "Home", "msgstr": ["Hjem"] }, "Modified": { "msgid": "Modified", "msgstr": ["Ændret"] }, "Move": { "msgid": "Move", "msgstr": ["Flyt"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Flyt til {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Navn"] }, "New": { "msgid": "New", "msgstr": ["Ny"] }, "New folder": { "msgid": "New folder", "msgstr": ["Ny mappe"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Ny mappe navn"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Ingen filer here"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Der blev ikke fundet nogen filer, der matcher dit filter."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Ingen matchende filer"] }, "Recent": { "msgid": "Recent", "msgstr": ["Seneste"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Vælg alle poster"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Vælg post"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Vælg rækken for {nodenavn}"] }, "Size": { "msgid": "Size", "msgstr": ["Størelse"] }, "Undo": { "msgid": "Undo", "msgstr": ["Fortryd"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Upload noget indhold eller synkroniser med dine enheder!"] } } } } }, { "locale": "de", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Ettore Atalan <atalanttore@googlemail.com>, 2024", "Language-Team": "German (https://app.transifex.com/nextcloud/teams/64236/de/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "de", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nMario Siegmann <mario_siegmann@web.de>, 2023\nMarkus Eckstein, 2023\nAndy Scherzinger <info@andy-scherzinger.de>, 2023\nJoachim Sokolowski, 2023\nEttore Atalan <atalanttore@googlemail.com>, 2024\n" }, "msgstr": ["Last-Translator: Ettore Atalan <atalanttore@googlemail.com>, 2024\nLanguage-Team: German (https://app.transifex.com/nextcloud/teams/64236/de/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: de\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" ist ein ungültiger Ordnername.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" ist kein zulässiger Ordnername'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" ist innerhalb eines Ordnernamens nicht zulässig.'] }, "All files": { "msgid": "All files", "msgstr": ["Alle Dateien"] }, "Choose": { "msgid": "Choose", "msgstr": ["Auswählen"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["{file} auswählen"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["%n Datei auswählen", "%n Dateien auswählen"] }, "Copy": { "msgid": "Copy", "msgstr": ["Kopieren"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Nach {target} kopieren"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Der neue Ordner konnte nicht erstellt werden."] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Dateieinstellungen konnten nicht geladen werden"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Dateiansichten konnten nicht geladen werden"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Verzeichnis erstellen"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Aktuelle Ansichtsauswahl"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Favoriten"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Dateien und Ordner, die du als Favorit markierst, werden hier angezeigt."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Dateien und Ordner, die du kürzlich geändert hast, werden hier angezeigt."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Dateiliste filtern"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Der Ordnername darf nicht leer sein."] }, "Home": { "msgid": "Home", "msgstr": ["Startseite"] }, "Modified": { "msgid": "Modified", "msgstr": ["Geändert"] }, "Move": { "msgid": "Move", "msgstr": ["Verschieben"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Nach {target} verschieben"] }, "Name": { "msgid": "Name", "msgstr": ["Name"] }, "New": { "msgid": "New", "msgstr": ["Neu"] }, "New folder": { "msgid": "New folder", "msgstr": ["Neuer Ordner"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Neuer Ordnername"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Keine Dateien vorhanden"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Es wurden keine Dateien gefunden, die deinem Filter entsprechen."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Keine passenden Dateien"] }, "Recent": { "msgid": "Recent", "msgstr": ["Jüngste"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Alle Einträge auswählen"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Eintrag auswählen"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Die Zeile für {nodename} auswählen."] }, "Size": { "msgid": "Size", "msgstr": ["Größe"] }, "Undo": { "msgid": "Undo", "msgstr": ["Rückgängig"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Lade Inhalte hoch oder synchronisieren diese mit deinen Geräten!"] } } } } }, { "locale": "de_DE", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Mario Siegmann <mario_siegmann@web.de>, 2024", "Language-Team": "German (Germany) (https://app.transifex.com/nextcloud/teams/64236/de_DE/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "de_DE", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nMark Ziegler <mark.ziegler@rakekniven.de>, 2023\nMario Siegmann <mario_siegmann@web.de>, 2024\n" }, "msgstr": ["Last-Translator: Mario Siegmann <mario_siegmann@web.de>, 2024\nLanguage-Team: German (Germany) (https://app.transifex.com/nextcloud/teams/64236/de_DE/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: de_DE\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" ist ein ungültiger Ordnername.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" ist kein zulässiger Ordnername'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" ist innerhalb eines Ordnernamens nicht zulässig.'] }, "All files": { "msgid": "All files", "msgstr": ["Alle Dateien"] }, "Choose": { "msgid": "Choose", "msgstr": ["Auswählen"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["{file} auswählen"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["%n Datei auswählen", "%n Dateien auswählen"] }, "Copy": { "msgid": "Copy", "msgstr": ["Kopieren"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Nach {target} kopieren"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Der neue Ordner konnte nicht erstellt werden"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Dateieinstellungen konnten nicht geladen werden"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Dateiansichten konnten nicht geladen werden"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Verzeichnis erstellen"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Aktuelle Ansichtsauswahl"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Favoriten"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Dateien und Ordner, die Sie als Favorit markieren, werden hier angezeigt."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Dateien und Ordner, die Sie kürzlich geändert haben, werden hier angezeigt."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Dateiliste filtern"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Der Ordnername darf nicht leer sein."] }, "Home": { "msgid": "Home", "msgstr": ["Home"] }, "Modified": { "msgid": "Modified", "msgstr": ["Geändert"] }, "Move": { "msgid": "Move", "msgstr": ["Verschieben"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Nach {target} verschieben"] }, "Name": { "msgid": "Name", "msgstr": ["Name"] }, "New": { "msgid": "New", "msgstr": ["Neu"] }, "New folder": { "msgid": "New folder", "msgstr": ["Neuer Ordner"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Neuer Ordnername"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Hier sind keine Dateien"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Es wurden keine Dateien gefunden, die Ihrem Filter entsprechen."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Keine passenden Dateien"] }, "Recent": { "msgid": "Recent", "msgstr": ["Neueste"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Alle Einträge auswählen"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Eintrag auswählen"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Die Zeile für {nodename} auswählen."] }, "Size": { "msgid": "Size", "msgstr": ["Größe"] }, "Undo": { "msgid": "Undo", "msgstr": ["Rückgängig machen"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Laden Sie Inhalte hoch oder synchronisieren Sie diese mit Ihren Geräten!"] } } } } }, { "locale": "el", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Greek (https://app.transifex.com/nextcloud/teams/64236/el/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "el", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Greek (https://app.transifex.com/nextcloud/teams/64236/el/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: el\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["Αναίρεση"] } } } } }, { "locale": "en_GB", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Andi Chandler <andi@gowling.com>, 2024", "Language-Team": "English (United Kingdom) (https://app.transifex.com/nextcloud/teams/64236/en_GB/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "en_GB", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nCafé Tango, 2023\nAndi Chandler <andi@gowling.com>, 2024\n" }, "msgstr": ["Last-Translator: Andi Chandler <andi@gowling.com>, 2024\nLanguage-Team: English (United Kingdom) (https://app.transifex.com/nextcloud/teams/64236/en_GB/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: en_GB\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" is an invalid folder name.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" is not an allowed folder name'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" is not allowed inside a folder name.'] }, "All files": { "msgid": "All files", "msgstr": ["All files"] }, "Choose": { "msgid": "Choose", "msgstr": ["Choose"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Choose {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Choose %n file", "Choose %n files"] }, "Copy": { "msgid": "Copy", "msgstr": ["Copy"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Copy to {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Could not create the new folder"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Could not load files settings"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Could not load files views"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Create directory"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Current view selector"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Favourites"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Files and folders you mark as favourite will show up here."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Files and folders you recently modified will show up here."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Filter file list"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Folder name cannot be empty."] }, "Home": { "msgid": "Home", "msgstr": ["Home"] }, "Modified": { "msgid": "Modified", "msgstr": ["Modified"] }, "Move": { "msgid": "Move", "msgstr": ["Move"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Move to {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Name"] }, "New": { "msgid": "New", "msgstr": ["New"] }, "New folder": { "msgid": "New folder", "msgstr": ["New folder"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["New folder name"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["No files in here"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["No files matching your filter were found."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["No matching files"] }, "Recent": { "msgid": "Recent", "msgstr": ["Recent"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Select all entries"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Select entry"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Select the row for {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Size"] }, "Undo": { "msgid": "Undo", "msgstr": ["Undo"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Upload some content or sync with your devices!"] } } } } }, { "locale": "eo", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Esperanto (https://app.transifex.com/nextcloud/teams/64236/eo/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "eo", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Esperanto (https://app.transifex.com/nextcloud/teams/64236/eo/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: eo\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["Malfari"] } } } } }, { "locale": "es", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Julio C. Ortega, 2024", "Language-Team": "Spanish (https://app.transifex.com/nextcloud/teams/64236/es/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "es", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nFranciscoFJ <dev-ooo@satel-sa.com>, 2023\nMark Ziegler <mark.ziegler@rakekniven.de>, 2024\nJulio C. Ortega, 2024\n" }, "msgstr": ["Last-Translator: Julio C. Ortega, 2024\nLanguage-Team: Spanish (https://app.transifex.com/nextcloud/teams/64236/es/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: es\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" es un nombre de carpeta no válido.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" no es un nombre de carpeta permitido'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" no está permitido dentro del nombre de una carpeta.'] }, "All files": { "msgid": "All files", "msgstr": ["Todos los archivos"] }, "Choose": { "msgid": "Choose", "msgstr": ["Seleccionar"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Seleccionar {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Elige %n archivo", "Elige %n archivos", "Seleccione %n archivos"] }, "Copy": { "msgid": "Copy", "msgstr": ["Copiar"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Copiar a {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["No se pudo crear la nueva carpeta"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["No se pudieron cargar los ajustes de archivos"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["No se pudieron cargar las vistas de los archivos"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Crear directorio"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Selector de vista actual"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Favoritos"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Los archivos y carpetas que marque como favoritos aparecerán aquí."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Los archivos y carpetas que modificó recientemente aparecerán aquí."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Filtrar lista de archivos"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["El nombre de la carpeta no puede estar vacío."] }, "Home": { "msgid": "Home", "msgstr": ["Inicio"] }, "Modified": { "msgid": "Modified", "msgstr": ["Modificado"] }, "Move": { "msgid": "Move", "msgstr": ["Mover"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Mover a {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Nombre"] }, "New": { "msgid": "New", "msgstr": ["Nuevo"] }, "New folder": { "msgid": "New folder", "msgstr": [" Nueva carpeta"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Nuevo nombre de carpeta"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["No hay archivos aquí"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["No se encontraron archivos que coincidiesen con su filtro."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["No hay archivos coincidentes"] }, "Recent": { "msgid": "Recent", "msgstr": ["Reciente"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Seleccionar todas las entradas"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Seleccionar entrada"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Seleccione la fila para {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Tamaño"] }, "Undo": { "msgid": "Undo", "msgstr": ["Deshacer"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["¡Cargue algún contenido o sincronice con sus dispositivos!"] } } } } }, { "locale": "es_419", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Spanish (Latin America) (https://app.transifex.com/nextcloud/teams/64236/es_419/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "es_419", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Spanish (Latin America) (https://app.transifex.com/nextcloud/teams/64236/es_419/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: es_419\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "es_AR", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Matías Campo Hoet <matiascampo@gmail.com>, 2024", "Language-Team": "Spanish (Argentina) (https://app.transifex.com/nextcloud/teams/64236/es_AR/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "es_AR", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nMatías Campo Hoet <matiascampo@gmail.com>, 2024\n" }, "msgstr": ["Last-Translator: Matías Campo Hoet <matiascampo@gmail.com>, 2024\nLanguage-Team: Spanish (Argentina) (https://app.transifex.com/nextcloud/teams/64236/es_AR/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: es_AR\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" es un nombre de carpeta inválido.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" no es un nombre de carpeta permitido'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" no está permitido en el nombre de una carpeta.'] }, "All files": { "msgid": "All files", "msgstr": ["Todos los archivos"] }, "Choose": { "msgid": "Choose", "msgstr": ["Elegir"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Elija {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Elija %n archivo", "Elija %n archivos", "Elija %n archivos"] }, "Copy": { "msgid": "Copy", "msgstr": ["Copiar"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Copiar a {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["No se pudo crear la nueva carpeta"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["No se pudo cargar la configuración de archivos"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["No se pudieron cargar las vistas de los archivos"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Crear directorio"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Selector de vista actual"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Favoritos"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Los archivos y carpetas que marque como favoritos aparecerán aquí."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Los archivos y carpetas que modificó recientemente aparecerán aquí."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Filtrar lista de archivos"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["El nombre de la carpeta no puede estar vacío."] }, "Home": { "msgid": "Home", "msgstr": ["Inicio"] }, "Modified": { "msgid": "Modified", "msgstr": ["Modificado"] }, "Move": { "msgid": "Move", "msgstr": ["Mover"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Mover a {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Nombre"] }, "New": { "msgid": "New", "msgstr": ["Nuevo"] }, "New folder": { "msgid": "New folder", "msgstr": ["Nueva carpeta"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Nombre de nueva carpeta"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["No hay archivos aquí"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["No se encontraron archivos que coincidan con su filtro."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["No hay archivos coincidentes"] }, "Recent": { "msgid": "Recent", "msgstr": ["Reciente"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Seleccionar todas las entradas"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Seleccionar entrada"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Seleccione la fila para {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Tamaño"] }, "Undo": { "msgid": "Undo", "msgstr": ["Deshacer"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["¡Cargue algún contenido o sincronice con sus dispositivos!"] } } } } }, { "locale": "es_CL", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Spanish (Chile) (https://app.transifex.com/nextcloud/teams/64236/es_CL/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "es_CL", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Spanish (Chile) (https://app.transifex.com/nextcloud/teams/64236/es_CL/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: es_CL\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "es_CO", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Spanish (Colombia) (https://app.transifex.com/nextcloud/teams/64236/es_CO/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "es_CO", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Spanish (Colombia) (https://app.transifex.com/nextcloud/teams/64236/es_CO/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: es_CO\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "es_CR", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Spanish (Costa Rica) (https://app.transifex.com/nextcloud/teams/64236/es_CR/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "es_CR", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Spanish (Costa Rica) (https://app.transifex.com/nextcloud/teams/64236/es_CR/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: es_CR\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "es_DO", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Spanish (Dominican Republic) (https://app.transifex.com/nextcloud/teams/64236/es_DO/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "es_DO", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Spanish (Dominican Republic) (https://app.transifex.com/nextcloud/teams/64236/es_DO/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: es_DO\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "es_EC", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Spanish (Ecuador) (https://app.transifex.com/nextcloud/teams/64236/es_EC/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "es_EC", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Spanish (Ecuador) (https://app.transifex.com/nextcloud/teams/64236/es_EC/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: es_EC\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "es_GT", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Spanish (Guatemala) (https://app.transifex.com/nextcloud/teams/64236/es_GT/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "es_GT", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Spanish (Guatemala) (https://app.transifex.com/nextcloud/teams/64236/es_GT/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: es_GT\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "es_HN", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Spanish (Honduras) (https://app.transifex.com/nextcloud/teams/64236/es_HN/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "es_HN", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Spanish (Honduras) (https://app.transifex.com/nextcloud/teams/64236/es_HN/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: es_HN\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "es_MX", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Jehu Marcos Herrera Puentes, 2024", "Language-Team": "Spanish (Mexico) (https://app.transifex.com/nextcloud/teams/64236/es_MX/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "es_MX", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nJehu Marcos Herrera Puentes, 2024\n" }, "msgstr": ["Last-Translator: Jehu Marcos Herrera Puentes, 2024\nLanguage-Team: Spanish (Mexico) (https://app.transifex.com/nextcloud/teams/64236/es_MX/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: es_MX\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" es un nombre de carpeta inválido.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" no es un nombre de carpeta permitido.'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" no está permitido en el nombre de la carpeta.'] }, "All files": { "msgid": "All files", "msgstr": ["Todos los archivos"] }, "Choose": { "msgid": "Choose", "msgstr": ["Seleccionar"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Seleccionar {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Seleccionar %n archivo", "Seleccionar %n archivos", "Seleccionar %n archivos"] }, "Copy": { "msgid": "Copy", "msgstr": ["Copiar"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Copiar a {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["No se pudo crear la nueva carpeta"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["No se pudo cargar la configuración de archivos"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["No se pudieron cargar las vistas de los archivos"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Crear carpeta"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Selector de vista actual"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Favoritos"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Los archivos y carpetas que marque como favoritos aparecerán aquí."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Los archivos y carpetas que modificó recientemente aparecerán aquí."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Filtrar lista de archivos"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["El nombre de la carpeta no puede estar vacío."] }, "Home": { "msgid": "Home", "msgstr": ["Inicio"] }, "Modified": { "msgid": "Modified", "msgstr": ["Modificado"] }, "Move": { "msgid": "Move", "msgstr": ["Mover"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Mover a {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Nombre"] }, "New": { "msgid": "New", "msgstr": ["Nuevo"] }, "New folder": { "msgid": "New folder", "msgstr": ["Nueva carpeta"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Nombre de nueva carpeta"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["No hay archivos aquí"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["No se encontraron archivos que coincidan con su filtro."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["No hay archivos coincidentes"] }, "Recent": { "msgid": "Recent", "msgstr": ["Reciente"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Seleccionar todas las entradas"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Seleccionar entrada"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Seleccione la fila para {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Tamaño"] }, "Undo": { "msgid": "Undo", "msgstr": ["Deshacer"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["¡Suba algún contenido o sincronice con sus dispositivos!"] } } } } }, { "locale": "es_NI", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Spanish (Nicaragua) (https://app.transifex.com/nextcloud/teams/64236/es_NI/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "es_NI", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Spanish (Nicaragua) (https://app.transifex.com/nextcloud/teams/64236/es_NI/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: es_NI\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "es_PA", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Spanish (Panama) (https://app.transifex.com/nextcloud/teams/64236/es_PA/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "es_PA", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Spanish (Panama) (https://app.transifex.com/nextcloud/teams/64236/es_PA/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: es_PA\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "es_PE", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Spanish (Peru) (https://app.transifex.com/nextcloud/teams/64236/es_PE/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "es_PE", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Spanish (Peru) (https://app.transifex.com/nextcloud/teams/64236/es_PE/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: es_PE\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "es_PR", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Spanish (Puerto Rico) (https://app.transifex.com/nextcloud/teams/64236/es_PR/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "es_PR", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Spanish (Puerto Rico) (https://app.transifex.com/nextcloud/teams/64236/es_PR/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: es_PR\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "es_PY", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Spanish (Paraguay) (https://app.transifex.com/nextcloud/teams/64236/es_PY/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "es_PY", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Spanish (Paraguay) (https://app.transifex.com/nextcloud/teams/64236/es_PY/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: es_PY\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "es_SV", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Spanish (El Salvador) (https://app.transifex.com/nextcloud/teams/64236/es_SV/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "es_SV", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Spanish (El Salvador) (https://app.transifex.com/nextcloud/teams/64236/es_SV/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: es_SV\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "es_UY", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Spanish (Uruguay) (https://app.transifex.com/nextcloud/teams/64236/es_UY/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "es_UY", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Spanish (Uruguay) (https://app.transifex.com/nextcloud/teams/64236/es_UY/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: es_UY\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "et_EE", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Estonian (Estonia) (https://app.transifex.com/nextcloud/teams/64236/et_EE/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "et_EE", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Estonian (Estonia) (https://app.transifex.com/nextcloud/teams/64236/et_EE/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: et_EE\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "eu", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Basque (https://app.transifex.com/nextcloud/teams/64236/eu/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "eu", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Basque (https://app.transifex.com/nextcloud/teams/64236/eu/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: eu\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["Desegin"] } } } } }, { "locale": "fa", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Persian (https://app.transifex.com/nextcloud/teams/64236/fa/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "fa", "Plural-Forms": "nplurals=2; plural=(n > 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Persian (https://app.transifex.com/nextcloud/teams/64236/fa/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: fa\nPlural-Forms: nplurals=2; plural=(n > 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["بازگردانی"] } } } } }, { "locale": "fi_FI", "json": { "charset": "utf-8", "headers": { "Last-Translator": "thingumy, 2024", "Language-Team": "Finnish (Finland) (https://app.transifex.com/nextcloud/teams/64236/fi_FI/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "fi_FI", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nJiri Grönroos <jiri.gronroos@iki.fi>, 2024\nthingumy, 2024\n" }, "msgstr": ["Last-Translator: thingumy, 2024\nLanguage-Team: Finnish (Finland) (https://app.transifex.com/nextcloud/teams/64236/fi_FI/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: fi_FI\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" on virheellinen kansion nimi.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" ei ole sallittu kansion nimi'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" ei ole sallittu kansion nimessä.'] }, "All files": { "msgid": "All files", "msgstr": ["Kaikki tiedostot"] }, "Choose": { "msgid": "Choose", "msgstr": ["Valitse"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Valitse {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Valitse %n tiedosto", "Valitse %n tiedostoa"] }, "Copy": { "msgid": "Copy", "msgstr": ["Kopioi"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Kopioi sijaintiin {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Uutta kansiota ei voitu luoda"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Tiedoston asetuksia ei saa ladattua"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Tiedoston näkymiä ei saa ladattua"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Luo kansio"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Nykyisen näkymän valinta"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Suosikit"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Tiedostot ja kansiot, jotka merkitset suosikkeihisi, näkyvät täällä."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Tiedostot ja kansiot, joita muokkasit äskettäin, näkyvät täällä."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Suodata tiedostolistaa"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Kansion nimi ei voi olla tyhjä."] }, "Home": { "msgid": "Home", "msgstr": ["Koti"] }, "Modified": { "msgid": "Modified", "msgstr": ["Muokattu"] }, "Move": { "msgid": "Move", "msgstr": ["Siirrä"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Siirrä sijaintiin {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Nimi"] }, "New": { "msgid": "New", "msgstr": ["Uusi"] }, "New folder": { "msgid": "New folder", "msgstr": ["Uusi kansio"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Uuden kansion nimi"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Täällä ei ole tiedostoja"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Suodatinta vastaavia tiedostoja ei löytynyt."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Ei vastaavia tiedostoja"] }, "Recent": { "msgid": "Recent", "msgstr": ["Viimeisimmät"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Valitse kaikki tietueet"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Valitse tietue"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Valitse rivi {nodename}:lle"] }, "Size": { "msgid": "Size", "msgstr": ["Koko"] }, "Undo": { "msgid": "Undo", "msgstr": ["Kumoa"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Lähetä jotain sisältöä tai synkronoi laitteidesi kanssa!"] } } } } }, { "locale": "fo", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Faroese (https://app.transifex.com/nextcloud/teams/64236/fo/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "fo", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Faroese (https://app.transifex.com/nextcloud/teams/64236/fo/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: fo\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "fr", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Benoit Pruneau, 2024", "Language-Team": "French (https://app.transifex.com/nextcloud/teams/64236/fr/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "fr", "Plural-Forms": "nplurals=3; plural=(n == 0 || n == 1) ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nRémi LEBLOND, 2023\nMordecai, 2023\nfleopaulD, 2023\nFrançois Ch., 2024\nJérôme HERBINET, 2024\nBenoit Pruneau, 2024\n" }, "msgstr": ["Last-Translator: Benoit Pruneau, 2024\nLanguage-Team: French (https://app.transifex.com/nextcloud/teams/64236/fr/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: fr\nPlural-Forms: nplurals=3; plural=(n == 0 || n == 1) ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ["« {name} » n'est pas un nom de dossier valide."] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ["« {name} » n'est pas un nom de dossier autorisé."] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ["Le caractère « / » n'est pas autorisé dans un nom de dossier."] }, "All files": { "msgid": "All files", "msgstr": ["Tous les fichiers"] }, "Choose": { "msgid": "Choose", "msgstr": ["Choisir"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Choisir {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Choisir %n fichier", "Choisir %n fichiers", "Choisir %n fichiers "] }, "Copy": { "msgid": "Copy", "msgstr": ["Copier"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Copier vers {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Impossible de créer le nouveau dossier"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Les paramètres des fichiers n'ont pas pu être chargés"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Les aperçus des fichiers n'ont pas pu être chargés"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Créer un répertoire"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Sélecteur de vue courante"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Favoris"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Les fichiers et répertoires marqués en favoris apparaîtront ici."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Les fichiers et répertoires modifiés récemment apparaîtront ici."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Filtrer la liste des fichiers"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Le nom du dossier ne peut pas être vide."] }, "Home": { "msgid": "Home", "msgstr": ["Accueil"] }, "Modified": { "msgid": "Modified", "msgstr": ["Modifié"] }, "Move": { "msgid": "Move", "msgstr": ["Déplacer"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Déplacer vers {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Nom"] }, "New": { "msgid": "New", "msgstr": ["Nouveau"] }, "New folder": { "msgid": "New folder", "msgstr": ["Nouveau répertoire"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Nom du nouveau répertoire"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Aucun fichier ici"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Aucun fichier trouvé correspondant à votre filtre."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Aucun fichier trouvé"] }, "Recent": { "msgid": "Recent", "msgstr": ["Récents"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Tous sélectionner"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Sélectionner une entrée"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Sélectionner l'enregistrement pour {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Taille"] }, "Undo": { "msgid": "Undo", "msgstr": ["Rétablir"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Charger du contenu ou synchroniser avec vos équipements !"] } } } } }, { "locale": "ga", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Aindriú Mac Giolla Eoin, 2024", "Language-Team": "Irish (https://app.transifex.com/nextcloud/teams/64236/ga/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "ga", "Plural-Forms": "nplurals=5; plural=(n==1 ? 0 : n==2 ? 1 : n<7 ? 2 : n<11 ? 3 : 4);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nAindriú Mac Giolla Eoin, 2024\n" }, "msgstr": ["Last-Translator: Aindriú Mac Giolla Eoin, 2024\nLanguage-Team: Irish (https://app.transifex.com/nextcloud/teams/64236/ga/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: ga\nPlural-Forms: nplurals=5; plural=(n==1 ? 0 : n==2 ? 1 : n<7 ? 2 : n<11 ? 3 : 4);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['Is ainm fillteáin neamhbhailí é "{name}".'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['Ní ainm fillteáin ceadaithe é "{name}".'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": [`Ní cheadaítear "/" taobh istigh d'ainm fillteáin.`] }, "All files": { "msgid": "All files", "msgstr": ["Gach comhad"] }, "Choose": { "msgid": "Choose", "msgstr": ["Roghnaigh"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Roghnaigh {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Roghnaigh %n comhad", "Roghnaigh %n comhaid", "Roghnaigh %n comhaid", "Roghnaigh %n comhaid", "Roghnaigh %n comhaid"] }, "Copy": { "msgid": "Copy", "msgstr": ["Cóip"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Cóipeáil chuig {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Níorbh fhéidir an fillteán nua a chruthú"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Níorbh fhéidir socruithe comhaid a lódáil"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Níorbh fhéidir radhairc comhad a lódáil"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Cruthaigh eolaire"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Roghnóir amhairc reatha"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Ceanáin"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Taispeánfar comhaid agus fillteáin a mharcálann tú mar is fearr leat anseo."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Taispeánfar comhaid agus fillteáin a d'athraigh tú le déanaí anseo."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Scag liosta comhad"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Ní féidir ainm fillteáin a bheith folamh."] }, "Home": { "msgid": "Home", "msgstr": ["Baile"] }, "Modified": { "msgid": "Modified", "msgstr": ["Athraithe"] }, "Move": { "msgid": "Move", "msgstr": ["Bog"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Bog go{target}"] }, "Name": { "msgid": "Name", "msgstr": ["Ainm"] }, "New": { "msgid": "New", "msgstr": ["Nua"] }, "New folder": { "msgid": "New folder", "msgstr": ["Fillteán nua"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Ainm fillteáin nua"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Níl aon chomhaid istigh anseo"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Níor aimsíodh aon chomhad a tháinig le do scagaire."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Gan comhaid meaitseála"] }, "Recent": { "msgid": "Recent", "msgstr": ["le déanaí"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Roghnaigh gach iontráil"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Roghnaigh iontráil"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Roghnaigh an ró do {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Méid"] }, "Undo": { "msgid": "Undo", "msgstr": ["Cealaigh"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Uaslódáil roinnt ábhair nó sioncronaigh le do ghléasanna!"] } } } } }, { "locale": "gd", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Gaelic, Scottish (https://app.transifex.com/nextcloud/teams/64236/gd/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "gd", "Plural-Forms": "nplurals=4; plural=(n==1 || n==11) ? 0 : (n==2 || n==12) ? 1 : (n > 2 && n < 20) ? 2 : 3;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Gaelic, Scottish (https://app.transifex.com/nextcloud/teams/64236/gd/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: gd\nPlural-Forms: nplurals=4; plural=(n==1 || n==11) ? 0 : (n==2 || n==12) ? 1 : (n > 2 && n < 20) ? 2 : 3;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "gl", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Miguel Anxo Bouzada <mbouzada@gmail.com>, 2024", "Language-Team": "Galician (https://app.transifex.com/nextcloud/teams/64236/gl/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "gl", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nMiguel Anxo Bouzada <mbouzada@gmail.com>, 2024\n" }, "msgstr": ["Last-Translator: Miguel Anxo Bouzada <mbouzada@gmail.com>, 2024\nLanguage-Team: Galician (https://app.transifex.com/nextcloud/teams/64236/gl/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: gl\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ["«{name}» non é un nome de cartafol válido."] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ["«{name}» non é un nome de cartafol permitido"] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ["A «/» non está permitida no nome dun cartafol."] }, "All files": { "msgid": "All files", "msgstr": ["Todos os ficheiros"] }, "Choose": { "msgid": "Choose", "msgstr": ["Escoller"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Escoller {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Escoller %n ficheiro", "Escoller %n ficheiros"] }, "Copy": { "msgid": "Copy", "msgstr": ["Copiar"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Copiar en  {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Non foi posíbel crear o novo cartafol"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Non foi posíbel cargar os axustes dos ficheiros"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Non foi posíbel cargar as vistas dos ficheiros"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Crear un directorio"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Selector de vista actual"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Favoritos"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Os ficheiros e cartafoles que marque como favoritos aparecerán aquí."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Os ficheiros e cartafoles que modificou recentemente aparecerán aquí."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Filtrar a lista de ficheiros"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["O nome do cartafol non pode estar baleiro."] }, "Home": { "msgid": "Home", "msgstr": ["Inicio"] }, "Modified": { "msgid": "Modified", "msgstr": ["Modificado"] }, "Move": { "msgid": "Move", "msgstr": ["Mover"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Mover cara a {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Nome"] }, "New": { "msgid": "New", "msgstr": ["Novo"] }, "New folder": { "msgid": "New folder", "msgstr": ["Novo cartafol"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Novo nome do cartafol"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Aquí non hai ficheiros"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Non se atopou ningún ficheiro que coincida co filtro."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Non hai ficheiros coincidentes"] }, "Recent": { "msgid": "Recent", "msgstr": ["Recente"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Seleccionar todas as entradas"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Seleccionar a entrada"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Seleccionar a fila para {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Tamaño"] }, "Undo": { "msgid": "Undo", "msgstr": ["Desfacer"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Enviar algún contido ou sincronizalo cos seus dispositivos!"] } } } } }, { "locale": "he", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Hebrew (https://app.transifex.com/nextcloud/teams/64236/he/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "he", "Plural-Forms": "nplurals=4; plural=(n == 1 && n % 1 == 0) ? 0 : (n == 2 && n % 1 == 0) ? 1: (n % 10 == 0 && n % 1 == 0 && n > 10) ? 2 : 3;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Hebrew (https://app.transifex.com/nextcloud/teams/64236/he/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: he\nPlural-Forms: nplurals=4; plural=(n == 1 && n % 1 == 0) ? 0 : (n == 2 && n % 1 == 0) ? 1: (n % 10 == 0 && n % 1 == 0 && n > 10) ? 2 : 3;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["ביטול"] } } } } }, { "locale": "hi_IN", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Hindi (India) (https://app.transifex.com/nextcloud/teams/64236/hi_IN/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "hi_IN", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Hindi (India) (https://app.transifex.com/nextcloud/teams/64236/hi_IN/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: hi_IN\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "hr", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Croatian (https://app.transifex.com/nextcloud/teams/64236/hr/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "hr", "Plural-Forms": "nplurals=3; plural=n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Croatian (https://app.transifex.com/nextcloud/teams/64236/hr/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: hr\nPlural-Forms: nplurals=3; plural=n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "hsb", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Upper Sorbian (https://app.transifex.com/nextcloud/teams/64236/hsb/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "hsb", "Plural-Forms": "nplurals=4; plural=(n%100==1 ? 0 : n%100==2 ? 1 : n%100==3 || n%100==4 ? 2 : 3);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Upper Sorbian (https://app.transifex.com/nextcloud/teams/64236/hsb/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: hsb\nPlural-Forms: nplurals=4; plural=(n%100==1 ? 0 : n%100==2 ? 1 : n%100==3 || n%100==4 ? 2 : 3);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "hu_HU", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Hungarian (Hungary) (https://app.transifex.com/nextcloud/teams/64236/hu_HU/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "hu_HU", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Hungarian (Hungary) (https://app.transifex.com/nextcloud/teams/64236/hu_HU/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: hu_HU\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["Visszavonás"] } } } } }, { "locale": "hy", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Armenian (https://app.transifex.com/nextcloud/teams/64236/hy/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "hy", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Armenian (https://app.transifex.com/nextcloud/teams/64236/hy/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: hy\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "ia", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Interlingua (https://app.transifex.com/nextcloud/teams/64236/ia/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "ia", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Interlingua (https://app.transifex.com/nextcloud/teams/64236/ia/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: ia\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "id", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Lun May, 2024", "Language-Team": "Indonesian (https://app.transifex.com/nextcloud/teams/64236/id/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "id", "Plural-Forms": "nplurals=1; plural=0;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nLinerly <linerly@proton.me>, 2023\nLun May, 2024\n" }, "msgstr": ["Last-Translator: Lun May, 2024\nLanguage-Team: Indonesian (https://app.transifex.com/nextcloud/teams/64236/id/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: id\nPlural-Forms: nplurals=1; plural=0;\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" bukan nama folder yang valid.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" merupakan nama folder yang tidak diperbolehkan'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" tidak diperbolehkan di dalam nama folder.'] }, "All files": { "msgid": "All files", "msgstr": ["Semua berkas"] }, "Choose": { "msgid": "Choose", "msgstr": ["Pilih"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Pilih {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Pilih %n file"] }, "Copy": { "msgid": "Copy", "msgstr": ["Salin"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Salin ke {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Tidak dapat membuat folder baru"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Tidak dapat memuat pengaturan file"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Tidak dapat memuat tampilan file"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Buat direktori"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Pemilih tampilan saat ini"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Favorit"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Berkas dan folder yang Anda tandai sebagai favorit akan muncul di sini."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Berkas dan folder yang Anda ubah baru-baru ini akan muncul di sini."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Saring daftar berkas"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Name berkas tidak boleh kosong."] }, "Home": { "msgid": "Home", "msgstr": ["Beranda"] }, "Modified": { "msgid": "Modified", "msgstr": ["Diubah"] }, "Move": { "msgid": "Move", "msgstr": ["Pindahkan"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Pindahkan ke {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Nama"] }, "New": { "msgid": "New", "msgstr": ["Baru"] }, "New folder": { "msgid": "New folder", "msgstr": ["Folder baru"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Nama folder baru"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Tidak ada berkas di sini"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Tidak ada berkas yang cocok dengan penyaringan Anda."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Tidak ada berkas yang cocok"] }, "Recent": { "msgid": "Recent", "msgstr": ["Terkini"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Pilih semua entri"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Pilih entri"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Pilih baris untuk {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Ukuran"] }, "Undo": { "msgid": "Undo", "msgstr": ["Tidak jadi"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Unggah beberapa konten atau sinkronkan dengan perangkat Anda!"] } } } } }, { "locale": "ig", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Igbo (https://app.transifex.com/nextcloud/teams/64236/ig/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "ig", "Plural-Forms": "nplurals=1; plural=0;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Igbo (https://app.transifex.com/nextcloud/teams/64236/ig/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: ig\nPlural-Forms: nplurals=1; plural=0;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "is", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Sveinn í Felli <sv1@fellsnet.is>, 2023", "Language-Team": "Icelandic (https://app.transifex.com/nextcloud/teams/64236/is/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "is", "Plural-Forms": "nplurals=2; plural=(n % 10 != 1 || n % 100 == 11);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nSveinn í Felli <sv1@fellsnet.is>, 2023\n" }, "msgstr": ["Last-Translator: Sveinn í Felli <sv1@fellsnet.is>, 2023\nLanguage-Team: Icelandic (https://app.transifex.com/nextcloud/teams/64236/is/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: is\nPlural-Forms: nplurals=2; plural=(n % 10 != 1 || n % 100 == 11);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" er ógilt möppuheiti.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" er ekki leyfilegt möppuheiti'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" er er ekki leyfilegt innan í skráarheiti.'] }, "All files": { "msgid": "All files", "msgstr": ["Allar skrár"] }, "Choose": { "msgid": "Choose", "msgstr": ["Veldu"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Veldu {file}"] }, "Copy": { "msgid": "Copy", "msgstr": ["Afrita"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Afrita í {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Get ekki búið til nýju möppuna"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Búa til möppu"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Núverandi val sýnar"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Eftirlæti"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Skrár og möppur sem þú merkir sem eftirlæti birtast hér."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Skrár og möppur sem þú breyttir nýlega birtast hér."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Sía skráalista"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Möppuheiti má ekki vera tómt."] }, "Home": { "msgid": "Home", "msgstr": ["Heim"] }, "Modified": { "msgid": "Modified", "msgstr": ["Breytt"] }, "Move": { "msgid": "Move", "msgstr": ["Færa"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Færa í {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Heiti"] }, "New": { "msgid": "New", "msgstr": ["Nýtt"] }, "New folder": { "msgid": "New folder", "msgstr": ["Ný mappa"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Heiti nýrrar möppu"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Engar skrár hér"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Engar skrár fundust sem passa við síuna."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Engar samsvarandi skrár"] }, "Recent": { "msgid": "Recent", "msgstr": ["Nýlegt"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Velja allar færslur"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Velja færslu"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Veldu röðina fyrir {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Stærð"] }, "Undo": { "msgid": "Undo", "msgstr": ["Afturkalla"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Sendu inn eitthvað efni eða samstilltu við tækin þín!"] } } } } }, { "locale": "it", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Sebastiano Furlan, 2024", "Language-Team": "Italian (https://app.transifex.com/nextcloud/teams/64236/it/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "it", "Plural-Forms": "nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nClaudio Scandella, 2023\nRaffaele Silano <raffaelone@gmail.com>, 2024\nSebastiano Furlan, 2024\n" }, "msgstr": ["Last-Translator: Sebastiano Furlan, 2024\nLanguage-Team: Italian (https://app.transifex.com/nextcloud/teams/64236/it/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: it\nPlural-Forms: nplurals=3; plural=n == 1 ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" non è un nome di cartella valido.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}"  non è un nome di cartella ammesso'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": [`"/" non è ammesso all'interno del nome di una cartella.`] }, "All files": { "msgid": "All files", "msgstr": ["Tutti i file"] }, "Choose": { "msgid": "Choose", "msgstr": ["Scegli"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Scegli {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Seleziona %n file", "Seleziona %n file", "Seleziona %n file"] }, "Copy": { "msgid": "Copy", "msgstr": ["Copia"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Copia in {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Impossibile creare la nuova cartella"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Impossibile caricare le impostazioni dei file"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Impossibile caricare le visualizzazioni dei file"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Crea directory"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Selettore della vista corrente"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Preferiti"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["I file e le cartelle contrassegnate come preferite saranno mostrate qui."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["I file e le cartelle che hai modificato di recente saranno mostrate qui."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Filtra elenco file"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Il nome della cartella non può essere vuoto."] }, "Home": { "msgid": "Home", "msgstr": ["Home"] }, "Modified": { "msgid": "Modified", "msgstr": ["Modificato"] }, "Move": { "msgid": "Move", "msgstr": ["Sposta"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Sposta in {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Nome"] }, "New": { "msgid": "New", "msgstr": ["Nuovo"] }, "New folder": { "msgid": "New folder", "msgstr": ["Nuova cartella"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Nuovo nome cartella"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Nessun file qui"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Nessun file che corrisponde al tuo filtro è stato trovato."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Nessun file corrispondente"] }, "Recent": { "msgid": "Recent", "msgstr": ["Recente"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Scegli tutte le voci"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Seleziona la voce"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Seleziona la riga per {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Taglia/dimensioni"] }, "Undo": { "msgid": "Undo", "msgstr": ["Annulla"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Carica qualche contenuto o sincronizza con i tuoi dispositivi!"] } } } } }, { "locale": "ja_JP", "json": { "charset": "utf-8", "headers": { "Last-Translator": "devi, 2024", "Language-Team": "Japanese (Japan) (https://app.transifex.com/nextcloud/teams/64236/ja_JP/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "ja_JP", "Plural-Forms": "nplurals=1; plural=0;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nUchiyama Takuya <uchiyama@j-wmc.com>, 2023\ntakehito kondo, 2023\nkojima.imamura, 2024\nTakafumi AKAMATSU, 2024\ndevi, 2024\n" }, "msgstr": ["Last-Translator: devi, 2024\nLanguage-Team: Japanese (Japan) (https://app.transifex.com/nextcloud/teams/64236/ja_JP/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: ja_JP\nPlural-Forms: nplurals=1; plural=0;\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" はフォルダー名に使用できません。'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}"は許可されたフォルダー名ではありません'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ["フォルダー名に「/（スラッシュ）」は使用できません。"] }, "All files": { "msgid": "All files", "msgstr": ["すべてのファイル"] }, "Choose": { "msgid": "Choose", "msgstr": ["選択"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["{file} を選択"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["%n 個のファイルを選択"] }, "Copy": { "msgid": "Copy", "msgstr": ["コピー"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["{target} にコピー"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["新しいフォルダーを作成できませんでした"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["ファイル設定を読み込めませんでした"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["ファイルビューを読み込めませんでした"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["ディレクトリを作成"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["現在のビューセレクタ"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["お気に入り"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["お気に入りとしてマークしたファイルとフォルダがここに表示されます。"] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["最近変更したファイルとフォルダがここに表示されます。"] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["ファイルリストをフィルタ"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["フォルダ名は空にできません。"] }, "Home": { "msgid": "Home", "msgstr": ["ホーム"] }, "Modified": { "msgid": "Modified", "msgstr": ["変更済み"] }, "Move": { "msgid": "Move", "msgstr": ["移動"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["{target} に移動"] }, "Name": { "msgid": "Name", "msgstr": ["名前"] }, "New": { "msgid": "New", "msgstr": ["新規作成"] }, "New folder": { "msgid": "New folder", "msgstr": ["新しいフォルダー"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["新しいフォルダーの名前"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["ファイルがありません"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["フィルタに一致するファイルは見つかりませんでした。"] }, "No matching files": { "msgid": "No matching files", "msgstr": ["一致するファイルはありません"] }, "Recent": { "msgid": "Recent", "msgstr": ["最近"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["すべてのエントリを選択"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["エントリを選択"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["{nodename} の行を選択"] }, "Size": { "msgid": "Size", "msgstr": ["サイズ"] }, "Undo": { "msgid": "Undo", "msgstr": ["元に戻す"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["コンテンツをアップロードするか、デバイスと同期してください！"] } } } } }, { "locale": "ka", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Georgian (https://app.transifex.com/nextcloud/teams/64236/ka/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "ka", "Plural-Forms": "nplurals=2; plural=(n!=1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Georgian (https://app.transifex.com/nextcloud/teams/64236/ka/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: ka\nPlural-Forms: nplurals=2; plural=(n!=1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "ka_GE", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Georgian (Georgia) (https://app.transifex.com/nextcloud/teams/64236/ka_GE/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "ka_GE", "Plural-Forms": "nplurals=2; plural=(n!=1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Georgian (Georgia) (https://app.transifex.com/nextcloud/teams/64236/ka_GE/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: ka_GE\nPlural-Forms: nplurals=2; plural=(n!=1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "kab", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Kabyle (https://app.transifex.com/nextcloud/teams/64236/kab/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "kab", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Kabyle (https://app.transifex.com/nextcloud/teams/64236/kab/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: kab\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["Sefsex"] } } } } }, { "locale": "kk", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Kazakh (https://app.transifex.com/nextcloud/teams/64236/kk/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "kk", "Plural-Forms": "nplurals=2; plural=(n!=1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Kazakh (https://app.transifex.com/nextcloud/teams/64236/kk/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: kk\nPlural-Forms: nplurals=2; plural=(n!=1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "km", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Khmer (https://app.transifex.com/nextcloud/teams/64236/km/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "km", "Plural-Forms": "nplurals=1; plural=0;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Khmer (https://app.transifex.com/nextcloud/teams/64236/km/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: km\nPlural-Forms: nplurals=1; plural=0;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "kn", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Kannada (https://app.transifex.com/nextcloud/teams/64236/kn/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "kn", "Plural-Forms": "nplurals=2; plural=(n > 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Kannada (https://app.transifex.com/nextcloud/teams/64236/kn/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: kn\nPlural-Forms: nplurals=2; plural=(n > 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "ko", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Korean (https://app.transifex.com/nextcloud/teams/64236/ko/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "ko", "Plural-Forms": "nplurals=1; plural=0;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Korean (https://app.transifex.com/nextcloud/teams/64236/ko/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: ko\nPlural-Forms: nplurals=1; plural=0;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["되돌리기"] } } } } }, { "locale": "la", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Latin (https://app.transifex.com/nextcloud/teams/64236/la/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "la", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Latin (https://app.transifex.com/nextcloud/teams/64236/la/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: la\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "lb", "json": { "charset": "utf-8", "headers": { "Last-Translator": "VoXaN24ch, 2024", "Language-Team": "Luxembourgish (https://app.transifex.com/nextcloud/teams/64236/lb/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "lb", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nVoXaN24ch, 2024\n" }, "msgstr": ["Last-Translator: VoXaN24ch, 2024\nLanguage-Team: Luxembourgish (https://app.transifex.com/nextcloud/teams/64236/lb/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: lb\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ["{name} ass en ongëlteg Dossier"] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ["{name} ass net en erlaabten Dossiernumm"] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" ass net an engem Dossier Numm erlaabt'] }, "All files": { "msgid": "All files", "msgstr": ["All Dateien"] }, "Choose": { "msgid": "Choose", "msgstr": ["Wielt"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Wielt {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Wielt %n Fichieren", "Wielt %n Fichier"] }, "Copy": { "msgid": "Copy", "msgstr": ["Kopie"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Kopie op {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Konnt den neien Dossier net erstellen"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Konnt d'Dateienastellungen net lueden"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Konnt d'Dateien net lueden"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Erstellt Verzeechnes"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Aktuell Vue selector"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Favoritten"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Dateien an Ordner, déi Dir als Favorit markéiert, ginn hei gewisen"] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Dateien an Ordner déi Dir viru kuerzem geännert hutt ginn hei op"] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Filter Datei Lëscht"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Dossier Numm kann net eidel sinn"] }, "Home": { "msgid": "Home", "msgstr": ["Wëllkomm"] }, "Modified": { "msgid": "Modified", "msgstr": ["Geännert"] }, "Move": { "msgid": "Move", "msgstr": ["Plënne"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Plënneren {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Numm"] }, "New": { "msgid": "New", "msgstr": ["Nei"] }, "New folder": { "msgid": "New folder", "msgstr": ["Neien dossier"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Neien dossier numm"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Kee fichier hei"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Kee fichier deen äre filter passt gouf fonnt"] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Keng passende dateien"] }, "Recent": { "msgid": "Recent", "msgstr": ["Rezent"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Wielt all entréen"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Wielt entrée"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Wielt d'zeil fir {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Gréisst"] }, "Undo": { "msgid": "Undo", "msgstr": ["Undoen"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Luet en inhalt erop oder synchroniséiert mat ären apparater"] } } } } }, { "locale": "lo", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Lao (https://app.transifex.com/nextcloud/teams/64236/lo/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "lo", "Plural-Forms": "nplurals=1; plural=0;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Lao (https://app.transifex.com/nextcloud/teams/64236/lo/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: lo\nPlural-Forms: nplurals=1; plural=0;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "lt_LT", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Lithuanian (Lithuania) (https://app.transifex.com/nextcloud/teams/64236/lt_LT/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "lt_LT", "Plural-Forms": "nplurals=4; plural=(n % 10 == 1 && (n % 100 > 19 || n % 100 < 11) ? 0 : (n % 10 >= 2 && n % 10 <=9) && (n % 100 > 19 || n % 100 < 11) ? 1 : n % 1 != 0 ? 2: 3);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Lithuanian (Lithuania) (https://app.transifex.com/nextcloud/teams/64236/lt_LT/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: lt_LT\nPlural-Forms: nplurals=4; plural=(n % 10 == 1 && (n % 100 > 19 || n % 100 < 11) ? 0 : (n % 10 >= 2 && n % 10 <=9) && (n % 100 > 19 || n % 100 < 11) ? 1 : n % 1 != 0 ? 2: 3);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["Atšaukti"] } } } } }, { "locale": "lv", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Latvian (https://app.transifex.com/nextcloud/teams/64236/lv/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "lv", "Plural-Forms": "nplurals=3; plural=(n%10==1 && n%100!=11 ? 0 : n != 0 ? 1 : 2);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Latvian (https://app.transifex.com/nextcloud/teams/64236/lv/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: lv\nPlural-Forms: nplurals=3; plural=(n%10==1 && n%100!=11 ? 0 : n != 0 ? 1 : 2);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "mk", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Macedonian (https://app.transifex.com/nextcloud/teams/64236/mk/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "mk", "Plural-Forms": "nplurals=2; plural=(n % 10 == 1 && n % 100 != 11) ? 0 : 1;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Macedonian (https://app.transifex.com/nextcloud/teams/64236/mk/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: mk\nPlural-Forms: nplurals=2; plural=(n % 10 == 1 && n % 100 != 11) ? 0 : 1;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["Врати"] } } } } }, { "locale": "mn", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Mongolian (https://app.transifex.com/nextcloud/teams/64236/mn/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "mn", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Mongolian (https://app.transifex.com/nextcloud/teams/64236/mn/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: mn\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["Буцаах"] } } } } }, { "locale": "mr", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Marathi (https://app.transifex.com/nextcloud/teams/64236/mr/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "mr", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Marathi (https://app.transifex.com/nextcloud/teams/64236/mr/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: mr\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["पूर्ववत करा"] } } } } }, { "locale": "ms_MY", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Malay (Malaysia) (https://app.transifex.com/nextcloud/teams/64236/ms_MY/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "ms_MY", "Plural-Forms": "nplurals=1; plural=0;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Malay (Malaysia) (https://app.transifex.com/nextcloud/teams/64236/ms_MY/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: ms_MY\nPlural-Forms: nplurals=1; plural=0;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "my", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Burmese (https://app.transifex.com/nextcloud/teams/64236/my/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "my", "Plural-Forms": "nplurals=1; plural=0;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Burmese (https://app.transifex.com/nextcloud/teams/64236/my/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: my\nPlural-Forms: nplurals=1; plural=0;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["နဂိုအတိုင်းပြန်ထားရန်"] } } } } }, { "locale": "nb_NO", "json": { "charset": "utf-8", "headers": { "Last-Translator": "armandg <geirawsm@pm.me>, 2024", "Language-Team": "Norwegian Bokmål (Norway) (https://app.transifex.com/nextcloud/teams/64236/nb_NO/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "nb_NO", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nD PE, 2023\nSyvert Fossdal, 2024\narmandg <geirawsm@pm.me>, 2024\n" }, "msgstr": ["Last-Translator: armandg <geirawsm@pm.me>, 2024\nLanguage-Team: Norwegian Bokmål (Norway) (https://app.transifex.com/nextcloud/teams/64236/nb_NO/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: nb_NO\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" er et ugyldig mappenavn.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" er ikke et tillatt mappenavn.'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" er ikke tillatt inne i et mappenavn.'] }, "All files": { "msgid": "All files", "msgstr": ["Alle filer"] }, "Choose": { "msgid": "Choose", "msgstr": ["Velg"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Velg {fil}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Velg %n fil", "Velg %n filer"] }, "Copy": { "msgid": "Copy", "msgstr": ["Kopier"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Kopier til {destinasjon}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Kunne ikke opprette den nye mappen"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Kunne ikke laste filinnstillinger"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Kunne ikke laste filvisninger"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Opprett mappe"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Nåværende visningsvelger"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Favoritter"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Filer og mapper du markerer som favoritter vil vises her."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Filer og mapper du nylig har endret, vil vises her."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Filtrer filliste"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Mappenavn kan ikke være tomt."] }, "Home": { "msgid": "Home", "msgstr": ["Hjem"] }, "Modified": { "msgid": "Modified", "msgstr": ["Modifisert"] }, "Move": { "msgid": "Move", "msgstr": ["Flytt"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Flytt til {destinasjon}"] }, "Name": { "msgid": "Name", "msgstr": ["Navn"] }, "New": { "msgid": "New", "msgstr": ["Ny"] }, "New folder": { "msgid": "New folder", "msgstr": ["Ny mappe"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Nytt mappenavn"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Ingen filer her"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Ingen filer funnet med ditt filter."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Ingen treffende filer"] }, "Recent": { "msgid": "Recent", "msgstr": ["Nylig"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Velg alle oppføringer"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Velg oppføring"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Velg raden for {nodenavn}"] }, "Size": { "msgid": "Size", "msgstr": ["Størrelse"] }, "Undo": { "msgid": "Undo", "msgstr": ["Angre"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Last opp innhold eller synkroniser med enhetene dine!"] } } } } }, { "locale": "ne", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Nepali (https://app.transifex.com/nextcloud/teams/64236/ne/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "ne", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Nepali (https://app.transifex.com/nextcloud/teams/64236/ne/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: ne\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "nl", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Casper <casper@vrije-mens.org>, 2024", "Language-Team": "Dutch (https://app.transifex.com/nextcloud/teams/64236/nl/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "nl", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nJoost <joho500@hotmail.com>, 2023\nJeroen Gui, 2023\nCasper <casper@vrije-mens.org>, 2024\n" }, "msgstr": ["Last-Translator: Casper <casper@vrije-mens.org>, 2024\nLanguage-Team: Dutch (https://app.transifex.com/nextcloud/teams/64236/nl/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: nl\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" is een ongeldige mapnaam.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" is geen toegestane mapnaam'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" is niet toegestaan binnen een bestandsnaam'] }, "All files": { "msgid": "All files", "msgstr": ["Alle bestanden"] }, "Choose": { "msgid": "Choose", "msgstr": ["Kies"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Kies {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Kies %n bestand", "Kies %n bestanden"] }, "Copy": { "msgid": "Copy", "msgstr": ["Kopieer"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Kopieer naar {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Kon de nieuwe map niet maken"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Kon de bestandsinstellingen niet laden"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Kon de bestandsweergaves niet laden"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Maak map"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Huidige weergave keuze"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Favorieten"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Bestanden en mappen die je favoriet maakt, worden hier getoond."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Bestanden en mappen die je recent hebt gewijzigd, worden hier getoond."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Filter bestandslijst"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Mapnaam mag niet leeg zijn."] }, "Home": { "msgid": "Home", "msgstr": ["Home"] }, "Modified": { "msgid": "Modified", "msgstr": ["Gewijzigd"] }, "Move": { "msgid": "Move", "msgstr": ["Verplaatsen"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Verplaats naar {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Naam"] }, "New": { "msgid": "New", "msgstr": ["Nieuw"] }, "New folder": { "msgid": "New folder", "msgstr": ["Nieuwe map"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Nieuwe mapnaam"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Geen bestanden hier"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Geen bestanden gevonden die voldoen aan je filter."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Geen gevonden bestanden"] }, "Recent": { "msgid": "Recent", "msgstr": ["Recent"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Selecteer alle invoer"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Selecteer invoer"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Selecteer de rij voor {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Grootte"] }, "Undo": { "msgid": "Undo", "msgstr": ["Ongedaan maken"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Upload inhoud of synchroniseer met je apparaten!"] } } } } }, { "locale": "nn_NO", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Norwegian Nynorsk (Norway) (https://app.transifex.com/nextcloud/teams/64236/nn_NO/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "nn_NO", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Norwegian Nynorsk (Norway) (https://app.transifex.com/nextcloud/teams/64236/nn_NO/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: nn_NO\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "oc", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Occitan (post 1500) (https://app.transifex.com/nextcloud/teams/64236/oc/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "oc", "Plural-Forms": "nplurals=2; plural=(n > 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Occitan (post 1500) (https://app.transifex.com/nextcloud/teams/64236/oc/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: oc\nPlural-Forms: nplurals=2; plural=(n > 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["Anullar"] } } } } }, { "locale": "pl", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Valdnet, 2024", "Language-Team": "Polish (https://app.transifex.com/nextcloud/teams/64236/pl/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "pl", "Plural-Forms": "nplurals=4; plural=(n==1 ? 0 : (n%10>=2 && n%10<=4) && (n%100<12 || n%100>14) ? 1 : n!=1 && (n%10>=0 && n%10<=1) || (n%10>=5 && n%10<=9) || (n%100>=12 && n%100<=14) ? 2 : 3);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nJUJER wtf, 2023\nM H <haincu@o2.pl>, 2023\nValdnet, 2024\n" }, "msgstr": ["Last-Translator: Valdnet, 2024\nLanguage-Team: Polish (https://app.transifex.com/nextcloud/teams/64236/pl/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: pl\nPlural-Forms: nplurals=4; plural=(n==1 ? 0 : (n%10>=2 && n%10<=4) && (n%100<12 || n%100>14) ? 1 : n!=1 && (n%10>=0 && n%10<=1) || (n%10>=5 && n%10<=9) || (n%100>=12 && n%100<=14) ? 2 : 3);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" jest nieprawidłową nazwą folderu'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" nie jest dozwoloną nazwą folderu'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['Znak "/" nie jest dozwolony w nazwie folderu'] }, "All files": { "msgid": "All files", "msgstr": ["Wszystkie pliki"] }, "Choose": { "msgid": "Choose", "msgstr": ["Wybierz"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Wybierz {file}"] }, "Copy": { "msgid": "Copy", "msgstr": ["Kopiuj"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Skopiuj do {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Nie można utworzyć nowego folderu"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Utwórz katalog"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Bieżący selektor widoku"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Ulubione"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Pliki i foldery które oznaczysz jako ulubione będą wyświetlały się tutaj"] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Pliki i foldery które ostatnio modyfikowałeś będą wyświetlały się tutaj"] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Filtruj listę plików"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Nazwa folderu nie może być pusta"] }, "Home": { "msgid": "Home", "msgstr": ["Strona główna"] }, "Modified": { "msgid": "Modified", "msgstr": ["Zmodyfikowano"] }, "Move": { "msgid": "Move", "msgstr": ["Przenieś"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Przejdź do {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Nazwa"] }, "New": { "msgid": "New", "msgstr": ["Nowy"] }, "New folder": { "msgid": "New folder", "msgstr": ["Nowy folder"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Nowa nazwa folderu"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Brak plików"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Nie znaleziono plików spełniających warunki filtru"] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Brak pasujących plików"] }, "Recent": { "msgid": "Recent", "msgstr": ["Ostatni"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Wybierz wszystkie wpisy"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Wybierz wpis"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Wybierz wiersz dla {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Rozmiar"] }, "Undo": { "msgid": "Undo", "msgstr": ["Cofnij"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Wyślij zawartość lub zsynchronizuj ze swoimi urządzeniami!"] } } } } }, { "locale": "ps", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Pashto (https://app.transifex.com/nextcloud/teams/64236/ps/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "ps", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Pashto (https://app.transifex.com/nextcloud/teams/64236/ps/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: ps\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "pt_BR", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Cauan Henrique Zorzenon <cauanzorzenon@gmail.com>, 2024", "Language-Team": "Portuguese (Brazil) (https://app.transifex.com/nextcloud/teams/64236/pt_BR/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "pt_BR", "Plural-Forms": "nplurals=3; plural=(n == 0 || n == 1) ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nFlávio Veras <flaviove@gmail.com>, 2023\nCauan Henrique Zorzenon <cauanzorzenon@gmail.com>, 2024\n" }, "msgstr": ["Last-Translator: Cauan Henrique Zorzenon <cauanzorzenon@gmail.com>, 2024\nLanguage-Team: Portuguese (Brazil) (https://app.transifex.com/nextcloud/teams/64236/pt_BR/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: pt_BR\nPlural-Forms: nplurals=3; plural=(n == 0 || n == 1) ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" é um nome de pasta inválido.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" não é um nome de pasta permitido'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" não é permitido dentro de um nome de pasta.'] }, "All files": { "msgid": "All files", "msgstr": ["Todos os arquivos"] }, "Choose": { "msgid": "Choose", "msgstr": ["Escolher"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Escolher arquivo}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Escolher %n arquivo", "Escolher %n arquivos", "Escolher %n arquivos"] }, "Copy": { "msgid": "Copy", "msgstr": ["Copiar"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Copiar para {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Não foi possível criar a nova pasta"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Não foi possível carregar configurações de arquivos"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Não foi possível carregar exibições de arquivos"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Criar diretório"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Seletor de visualização atual"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Favoritos"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Os arquivos e pastas marcados como favoritos aparecerão aqui."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Arquivos e pastas que você modificou recentemente aparecerão aqui."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Filtrar lista de arquivos"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["O nome da pasta não pode ficar vazio."] }, "Home": { "msgid": "Home", "msgstr": ["Home"] }, "Modified": { "msgid": "Modified", "msgstr": ["Modificado"] }, "Move": { "msgid": "Move", "msgstr": ["Mover"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Mover para {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Nome"] }, "New": { "msgid": "New", "msgstr": ["Novo"] }, "New folder": { "msgid": "New folder", "msgstr": ["Nova pasta"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Novo nome de pasta"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Nenhum arquivo aqui"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Nenhum arquivo correspondente ao seu filtro foi encontrado."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Nenhum arquivo correspondente"] }, "Recent": { "msgid": "Recent", "msgstr": ["Recente"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Selecione todas as entradas"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Selecione a entrada"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Selecione a linha para {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Tamanho"] }, "Undo": { "msgid": "Undo", "msgstr": ["Desfazer"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Carregue algum conteúdo ou sincronize com seus dispositivos!"] } } } } }, { "locale": "pt_PT", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Portuguese (Portugal) (https://app.transifex.com/nextcloud/teams/64236/pt_PT/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "pt_PT", "Plural-Forms": "nplurals=3; plural=(n == 0 || n == 1) ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Portuguese (Portugal) (https://app.transifex.com/nextcloud/teams/64236/pt_PT/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: pt_PT\nPlural-Forms: nplurals=3; plural=(n == 0 || n == 1) ? 0 : n != 0 && n % 1000000 == 0 ? 1 : 2;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["Anular"] } } } } }, { "locale": "ro", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Daniel MD <dmihaidumitru@gmail.com>, 2023", "Language-Team": "Romanian (https://app.transifex.com/nextcloud/teams/64236/ro/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "ro", "Plural-Forms": "nplurals=3; plural=(n==1?0:(((n%100>19)||((n%100==0)&&(n!=0)))?2:1));" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nDaniel MD <dmihaidumitru@gmail.com>, 2023\n" }, "msgstr": ["Last-Translator: Daniel MD <dmihaidumitru@gmail.com>, 2023\nLanguage-Team: Romanian (https://app.transifex.com/nextcloud/teams/64236/ro/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: ro\nPlural-Forms: nplurals=3; plural=(n==1?0:(((n%100>19)||((n%100==0)&&(n!=0)))?2:1));\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" este un nume de director invalid.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" nu este un nume de director permis'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" nu este permis în numele unui director.'] }, "All files": { "msgid": "All files", "msgstr": ["Toate fișierele"] }, "Choose": { "msgid": "Choose", "msgstr": ["Alege"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Alege {file}"] }, "Copy": { "msgid": "Copy", "msgstr": ["Copiază"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Copiază în {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Nu s-a putut crea noul director"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Creează director"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Selectorul curent al vizualizării"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Favorite"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Fișiere și directoare pe care le marcați ca favorite vor apărea aici."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Fișiere și directoare pe care le-ați modificat recent vor apărea aici."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Filtrează lista de fișiere"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Numele de director nu poate fi necompletat."] }, "Home": { "msgid": "Home", "msgstr": ["Acasă"] }, "Modified": { "msgid": "Modified", "msgstr": ["Modificat"] }, "Move": { "msgid": "Move", "msgstr": ["Mută"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Mută către {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Nume"] }, "New": { "msgid": "New", "msgstr": ["Nou"] }, "New folder": { "msgid": "New folder", "msgstr": ["Director nou"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Numele noului director"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Nu există fișiere"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Nu există fișiere potrivite pentru filtrul selectat"] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Nu există fișiere potrivite"] }, "Recent": { "msgid": "Recent", "msgstr": ["Recente"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Selectează toate înregistrările"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Selectează înregistrarea"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Selectează rândul pentru {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Mărime"] }, "Undo": { "msgid": "Undo", "msgstr": ["Anulează"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Încărcați conținut sau sincronizați cu dispozitivele dumneavoastră!"] } } } } }, { "locale": "ru", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Влад, 2024", "Language-Team": "Russian (https://app.transifex.com/nextcloud/teams/64236/ru/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "ru", "Plural-Forms": "nplurals=4; plural=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<12 || n%100>14) ? 1 : n%10==0 || (n%10>=5 && n%10<=9) || (n%100>=11 && n%100<=14)? 2 : 3);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nMax Smith <sevinfolds@gmail.com>, 2023\nashed <craysy@gmail.com>, 2023\nAlex <kekcuha@gmail.com>, 2024\nR4SAS, 2024\nВлад, 2024\n" }, "msgstr": ["Last-Translator: Влад, 2024\nLanguage-Team: Russian (https://app.transifex.com/nextcloud/teams/64236/ru/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: ru\nPlural-Forms: nplurals=4; plural=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<12 || n%100>14) ? 1 : n%10==0 || (n%10>=5 && n%10<=9) || (n%100>=11 && n%100<=14)? 2 : 3);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ["«{name}» — недопустимое имя папки."] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ["«{name}» не является разрешенным именем папки"] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ["Символ «/» не допускается внутри имени папки."] }, "All files": { "msgid": "All files", "msgstr": ["Все файлы"] }, "Choose": { "msgid": "Choose", "msgstr": ["Выбрать"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Выбрать {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Выбрать %n файл", "Выбрать %n файла", "Выбрать %n файлов", "Выбрать %n файлов"] }, "Copy": { "msgid": "Copy", "msgstr": ["Копировать"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Копировать в «{target}»"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Не удалось создать новую папку"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Не удалось загрузить настройки файлов"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Не удалось загрузить файлы просмотров"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Создать папку"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Переключатель текущего вида"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Избранное"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Здесь появятся файлы и папки, которые вы пометили как избранные."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Здесь будут отображаться файлы и папки, которые вы недавно изменили."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Фильтровать список файлов"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Имя папки не может быть пустым."] }, "Home": { "msgid": "Home", "msgstr": ["Home"] }, "Modified": { "msgid": "Modified", "msgstr": ["Модифицированный"] }, "Move": { "msgid": "Move", "msgstr": ["Переместить"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Перейти к {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Имя"] }, "New": { "msgid": "New", "msgstr": ["Новый"] }, "New folder": { "msgid": "New folder", "msgstr": ["Новая папка"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Новое имя папки"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Здесь нет файлов"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Файлы, соответствующие вашему фильтру, не найдены."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Нет подходящих файлов"] }, "Recent": { "msgid": "Recent", "msgstr": ["Недавний"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Выбрать все записи"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Выберите запись"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Выберите строку для {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Размер"] }, "Undo": { "msgid": "Undo", "msgstr": ["Отменить"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Загрузите контент или синхронизируйте его со своими устройствами!"] } } } } }, { "locale": "sc", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Sardinian (https://app.transifex.com/nextcloud/teams/64236/sc/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "sc", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Sardinian (https://app.transifex.com/nextcloud/teams/64236/sc/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: sc\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "si", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Sinhala (https://app.transifex.com/nextcloud/teams/64236/si/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "si", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Sinhala (https://app.transifex.com/nextcloud/teams/64236/si/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: si\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["පෙරසේ"] } } } } }, { "locale": "sk_SK", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Tomas Rusnak <linkermail@gmail.com>, 2024", "Language-Team": "Slovak (Slovakia) (https://app.transifex.com/nextcloud/teams/64236/sk_SK/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "sk_SK", "Plural-Forms": "nplurals=4; plural=(n % 1 == 0 && n == 1 ? 0 : n % 1 == 0 && n >= 2 && n <= 4 ? 1 : n % 1 != 0 ? 2: 3);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nStanislav Prekop <prekop3@gmail.com>, 2024\nTomas Rusnak <linkermail@gmail.com>, 2024\n" }, "msgstr": ["Last-Translator: Tomas Rusnak <linkermail@gmail.com>, 2024\nLanguage-Team: Slovak (Slovakia) (https://app.transifex.com/nextcloud/teams/64236/sk_SK/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: sk_SK\nPlural-Forms: nplurals=4; plural=(n % 1 == 0 && n == 1 ? 0 : n % 1 == 0 && n >= 2 && n <= 4 ? 1 : n % 1 != 0 ? 2: 3);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" je neplatný názov pričinka.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" nie je povolený názov priečinka.'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" nie je povolené v názve priečinka.'] }, "All files": { "msgid": "All files", "msgstr": ["Všetky súbory"] }, "Choose": { "msgid": "Choose", "msgstr": ["Vybrať"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Vybrať {súbor}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Vybraný %n súbor", "Vybrané %n súbory", "Vybraných %n súborov", "Vybraných %n súborov"] }, "Copy": { "msgid": "Copy", "msgstr": ["Kopírovať"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Kopírovať do {umiestnenia}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Nepodarilo sa vytvoriť nový priečinok"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Nepodarilo sa načítať nastavenia súborov"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Nepodarilo sa načítať pohľady súborov"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Vytvoriť adresár"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Výber aktuálneho zobrazenia"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Obľúbené"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Tu sa zobrazia súbory a priečinky, ktoré označíte ako obľúbené."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Tu sa zobrazia súbory a priečinky, ktoré ste nedávno upravili."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Filtrovať zoznam súborov"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Názov priečinka nemôže byť prázdny."] }, "Home": { "msgid": "Home", "msgstr": ["Domov"] }, "Modified": { "msgid": "Modified", "msgstr": ["Upravené"] }, "Move": { "msgid": "Move", "msgstr": ["Prejsť"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Prejsť na {umiestnenie}"] }, "Name": { "msgid": "Name", "msgstr": ["Názov"] }, "New": { "msgid": "New", "msgstr": ["Pridať"] }, "New folder": { "msgid": "New folder", "msgstr": ["Pridať priečinok"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Pridať názov priečinka"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Nie sú tu žiadne súbory"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Nenašli sa žiadne súbory zodpovedajúce vášmu filtru."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Žiadne zodpovedajúce súbory"] }, "Recent": { "msgid": "Recent", "msgstr": ["Nedávne"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Vybrať všetky položky"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Vybrať položku"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Vyberte riadok pre {názov uzla}"] }, "Size": { "msgid": "Size", "msgstr": ["Veľkosť"] }, "Undo": { "msgid": "Undo", "msgstr": ["Späť"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Nahrajte nejaký obsah alebo synchronizujte so svojimi zariadeniami!"] } } } } }, { "locale": "sl", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Slovenian (https://app.transifex.com/nextcloud/teams/64236/sl/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "sl", "Plural-Forms": "nplurals=4; plural=(n%100==1 ? 0 : n%100==2 ? 1 : n%100==3 || n%100==4 ? 2 : 3);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Slovenian (https://app.transifex.com/nextcloud/teams/64236/sl/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: sl\nPlural-Forms: nplurals=4; plural=(n%100==1 ? 0 : n%100==2 ? 1 : n%100==3 || n%100==4 ? 2 : 3);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["Razveljavi"] } } } } }, { "locale": "sq", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Albanian (https://app.transifex.com/nextcloud/teams/64236/sq/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "sq", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Albanian (https://app.transifex.com/nextcloud/teams/64236/sq/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: sq\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "sr", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Иван Пешић, 2024", "Language-Team": "Serbian (https://app.transifex.com/nextcloud/teams/64236/sr/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "sr", "Plural-Forms": "nplurals=3; plural=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nИван Пешић, 2024\n" }, "msgstr": ["Last-Translator: Иван Пешић, 2024\nLanguage-Team: Serbian (https://app.transifex.com/nextcloud/teams/64236/sr/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: sr\nPlural-Forms: nplurals=3; plural=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ["„{name}” није исправно име фолдера."] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ["„{name}” није дозвољено име за фолдер."] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ["„/” није дозвољено унутар имена фолдера."] }, "All files": { "msgid": "All files", "msgstr": ["Сви фајлови"] }, "Choose": { "msgid": "Choose", "msgstr": ["Изаберите"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Изаберите {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Изаберите %n фајл", "Изаберите %n фајла", "Изаберите %n фајлова"] }, "Copy": { "msgid": "Copy", "msgstr": ["Копирај"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Копирај у {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Није могао да се креира нови фолдер"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Не могу да се учитају подешавања фајлова"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Не могу да се учитају прикази фајлова"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Креирај директоријум"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Бирач тренутног приказа"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Омиљено"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Овде ће се појавити фајлови и фолдери које сте означили као омиљене."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Овде ће се појавити фајлови и фолдери који се се недавно изменили."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Фитрирање листе фајлова"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Име фолдера не може бити празно."] }, "Home": { "msgid": "Home", "msgstr": ["Почетак"] }, "Modified": { "msgid": "Modified", "msgstr": ["Измењено"] }, "Move": { "msgid": "Move", "msgstr": ["Премести"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Премести у {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Име"] }, "New": { "msgid": "New", "msgstr": ["Ново"] }, "New folder": { "msgid": "New folder", "msgstr": ["Нови фолдер"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Име новог фолдера"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Овде нема фајлова"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Није пронађен ниједан фајл који задовољава ваш филтер."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Нема таквих фајлова"] }, "Recent": { "msgid": "Recent", "msgstr": ["Скорашње"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Изаберите све ставке"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Изаберите ставку"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Изаберите ред за {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Величина"] }, "Undo": { "msgid": "Undo", "msgstr": ["Поништи"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Отпремите нешто или синхронизујте са својим уређајима!"] } } } } }, { "locale": "sr@latin", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Bogdan Vuković, 2024", "Language-Team": "Serbian (Latin) (https://app.transifex.com/nextcloud/teams/64236/sr@latin/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "sr@latin", "Plural-Forms": "nplurals=3; plural=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nBogdan Vuković, 2024\n" }, "msgstr": ["Last-Translator: Bogdan Vuković, 2024\nLanguage-Team: Serbian (Latin) (https://app.transifex.com/nextcloud/teams/64236/sr@latin/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: sr@latin\nPlural-Forms: nplurals=3; plural=(n%10==1 && n%100!=11 ? 0 : n%10>=2 && n%10<=4 && (n%100<10 || n%100>=20) ? 1 : 2);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ["„{name}” je neispravan naziv foldera."] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ["„{name}” je nedozvoljen naziv foldera."] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ["„/” se ne može koristiti unutar naziva foldera."] }, "All files": { "msgid": "All files", "msgstr": ["Svi fajlovi"] }, "Choose": { "msgid": "Choose", "msgstr": ["Izaberite"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Izaberite {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Izaberite %n fajl", "Izaberite %n fajla", "Izaberite %n fajlova"] }, "Copy": { "msgid": "Copy", "msgstr": ["Kopiraj"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Kopiraj u {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Neuspešno kreiranje novog foldera"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Neuspešno učitavanje podešavanja fajlova"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Neuspešno učitavanje prikaza fajlova"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Kreiraj direktorijum"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Birač trenutnog prikaza"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Omiljeno"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Lista omiljenih fajlova i foldera."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Lista fajlova i foldera sa skorašnjim izmenama."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Fitriranje liste fajlova"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Naziv foldera ne može biti prazan."] }, "Home": { "msgid": "Home", "msgstr": ["Početak"] }, "Modified": { "msgid": "Modified", "msgstr": ["Izmenjeno"] }, "Move": { "msgid": "Move", "msgstr": ["Premesti"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Premesti u {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Naziv"] }, "New": { "msgid": "New", "msgstr": ["Novo"] }, "New folder": { "msgid": "New folder", "msgstr": ["Novi folder"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Naziv novog foldera"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Bez fajlova"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Nema fajlova koji zadovoljavaju uslove filtera."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Nema takvih fajlova"] }, "Recent": { "msgid": "Recent", "msgstr": ["Skorašnje"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Izaberite sve stavke"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Izaberite stavku"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Izaberite red za {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Veličina"] }, "Undo": { "msgid": "Undo", "msgstr": ["Vrati"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Otpremite sadržaj ili sinhronizujte sa svojim uređajima!"] } } } } }, { "locale": "sv", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Magnus Höglund, 2024", "Language-Team": "Swedish (https://app.transifex.com/nextcloud/teams/64236/sv/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "sv", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nMagnus Höglund, 2024\n" }, "msgstr": ["Last-Translator: Magnus Höglund, 2024\nLanguage-Team: Swedish (https://app.transifex.com/nextcloud/teams/64236/sv/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: sv\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" är ett ogiltigt mappnamn.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" är inte ett tillåtet mappnamn'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" är inte tillåtet i ett mappnamn.'] }, "All files": { "msgid": "All files", "msgstr": ["Alla filer"] }, "Choose": { "msgid": "Choose", "msgstr": ["Välj"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Välj {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Välj %n fil", "Välj %n filer"] }, "Copy": { "msgid": "Copy", "msgstr": ["Kopiera"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Kopiera till {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Kunde inte skapa den nya mappen"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Kunde inte ladda filinställningar"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Kunde inte ladda läsa in filvyer"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Skapa katalog"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Aktuell vyväljare"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Favoriter"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Filer och mappar som du markerar som favorit kommer att visas här."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Filer och mappar som du nyligen ändrat kommer att visas här."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Filtrera fillistan"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Mappnamnet får inte vara tomt."] }, "Home": { "msgid": "Home", "msgstr": ["Hem"] }, "Modified": { "msgid": "Modified", "msgstr": ["Ändrad"] }, "Move": { "msgid": "Move", "msgstr": ["Flytta"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Flytta till {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Namn"] }, "New": { "msgid": "New", "msgstr": ["Ny"] }, "New folder": { "msgid": "New folder", "msgstr": ["Ny mapp"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Nytt mappnamn"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Inga filer här"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Inga filer som matchar ditt filter hittades."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Inga matchande filer"] }, "Recent": { "msgid": "Recent", "msgstr": ["Nyligen"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Välj alla poster"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Välj post"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Välj raden för {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Storlek"] }, "Undo": { "msgid": "Undo", "msgstr": ["Ångra"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Ladda upp lite innehåll eller synkronisera med dina enheter!"] } } } } }, { "locale": "sw", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Swahili (https://app.transifex.com/nextcloud/teams/64236/sw/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "sw", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Swahili (https://app.transifex.com/nextcloud/teams/64236/sw/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: sw\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "ta", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Tamil (https://app.transifex.com/nextcloud/teams/64236/ta/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "ta", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Tamil (https://app.transifex.com/nextcloud/teams/64236/ta/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: ta\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["செயல்தவிர்"] } } } } }, { "locale": "th_TH", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Thai (Thailand) (https://app.transifex.com/nextcloud/teams/64236/th_TH/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "th_TH", "Plural-Forms": "nplurals=1; plural=0;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Thai (Thailand) (https://app.transifex.com/nextcloud/teams/64236/th_TH/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: th_TH\nPlural-Forms: nplurals=1; plural=0;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["เลิกทำ"] } } } } }, { "locale": "tk", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Turkmen (https://app.transifex.com/nextcloud/teams/64236/tk/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "tk", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Turkmen (https://app.transifex.com/nextcloud/teams/64236/tk/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: tk\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "tr", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Kaya Zeren <kayazeren@gmail.com>, 2024", "Language-Team": "Turkish (https://app.transifex.com/nextcloud/teams/64236/tr/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "tr", "Plural-Forms": "nplurals=2; plural=(n > 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nKaya Zeren <kayazeren@gmail.com>, 2024\n" }, "msgstr": ["Last-Translator: Kaya Zeren <kayazeren@gmail.com>, 2024\nLanguage-Team: Turkish (https://app.transifex.com/nextcloud/teams/64236/tr/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: tr\nPlural-Forms: nplurals=2; plural=(n > 1);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" geçersiz bir klasör adı.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" izin verilen bir klasör adı değil'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" karakteri klasör adında kullanılamaz.'] }, "All files": { "msgid": "All files", "msgstr": ["Tüm dosyalar"] }, "Choose": { "msgid": "Choose", "msgstr": ["Seçin"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["{file} seçin"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["%n dosya seçin", "%n dosya seçin"] }, "Copy": { "msgid": "Copy", "msgstr": ["Kopyala"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["{target} üzerine kopyala"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Yeni klasör oluşturulamadı"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Dosyalar uygulamasının ayarları yüklenemedi"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Dosyalar uygulamasının görünümleri yüklenemedi"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Klasör oluştur"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Geçerli görünüm seçici"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Sık kullanılanlar"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Sık kullanılan olarak seçtiğiniz dosyalar burada görüntülenir."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Son zamanlarda değiştirdiğiniz dosya ve klasörler burada görüntülenir."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Dosya listesini süz"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Klasör adı boş olamaz."] }, "Home": { "msgid": "Home", "msgstr": ["Giriş"] }, "Modified": { "msgid": "Modified", "msgstr": ["Değiştirilme"] }, "Move": { "msgid": "Move", "msgstr": ["Taşı"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["{target} üzerine taşı"] }, "Name": { "msgid": "Name", "msgstr": ["Ad"] }, "New": { "msgid": "New", "msgstr": ["Yeni"] }, "New folder": { "msgid": "New folder", "msgstr": ["Yeni klasör"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Yeni klasör adı"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Burada herhangi bir dosya yok"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Süzgece uyan bir dosya bulunamadı."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Eşleşen bir dosya yok"] }, "Recent": { "msgid": "Recent", "msgstr": ["Son kullanılanlar"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Tüm kayıtları seç"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Kaydı seç"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["{nodename} satırını seçin"] }, "Size": { "msgid": "Size", "msgstr": ["Boyut"] }, "Undo": { "msgid": "Undo", "msgstr": ["Geri al"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Bazı içerikler yükleyin ya da aygıtlarınızla eşitleyin!"] } } } } }, { "locale": "ug", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Uyghur (https://app.transifex.com/nextcloud/teams/64236/ug/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "ug", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Uyghur (https://app.transifex.com/nextcloud/teams/64236/ug/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: ug\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "uk", "json": { "charset": "utf-8", "headers": { "Last-Translator": "O St <oleksiy.stasevych@gmail.com>, 2024", "Language-Team": "Ukrainian (https://app.transifex.com/nextcloud/teams/64236/uk/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "uk", "Plural-Forms": "nplurals=4; plural=(n % 1 == 0 && n % 10 == 1 && n % 100 != 11 ? 0 : n % 1 == 0 && n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 12 || n % 100 > 14) ? 1 : n % 1 == 0 && (n % 10 ==0 || (n % 10 >=5 && n % 10 <=9) || (n % 100 >=11 && n % 100 <=14 )) ? 2: 3);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nO St <oleksiy.stasevych@gmail.com>, 2024\n" }, "msgstr": ["Last-Translator: O St <oleksiy.stasevych@gmail.com>, 2024\nLanguage-Team: Ukrainian (https://app.transifex.com/nextcloud/teams/64236/uk/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: uk\nPlural-Forms: nplurals=4; plural=(n % 1 == 0 && n % 10 == 1 && n % 100 != 11 ? 0 : n % 1 == 0 && n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 12 || n % 100 > 14) ? 1 : n % 1 == 0 && (n % 10 ==0 || (n % 10 >=5 && n % 10 <=9) || (n % 100 >=11 && n % 100 <=14 )) ? 2: 3);\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ['"{name}" є недійсною назвою для каталогу.'] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ['"{name}" не є дозволеною назвою для каталогу.'] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['"/" не дозволено у назві каталогу.'] }, "All files": { "msgid": "All files", "msgstr": ["Всі файли"] }, "Choose": { "msgid": "Choose", "msgstr": ["Вибрати"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["Вибрати {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["Вибрати %n файл", "Вибрати %n файли", "Вибрати %n файлів", "Вибрати %n файлів"] }, "Copy": { "msgid": "Copy", "msgstr": ["Копіювати"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["Копіювати до {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["Не вдалося створити новий каталог"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["Не вдалося завантажити налаштування файлів"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["Не вдалося завантажити подання файлів"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["Створити каталог"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["Вибір подання"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["Із зірочкою"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["Тут показуватимуться файли та каталоги, які ви позначите зірочкою."] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["Тут показуватимуться файли та каталоги, які було нещодавно змінено."] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["Фільтрувати список файлів"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["Ім'я каталогу не може бути порожнім."] }, "Home": { "msgid": "Home", "msgstr": ["Домівка"] }, "Modified": { "msgid": "Modified", "msgstr": ["Змінено"] }, "Move": { "msgid": "Move", "msgstr": ["Перемістити"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["Перемістити до {target}"] }, "Name": { "msgid": "Name", "msgstr": ["Ім'я"] }, "New": { "msgid": "New", "msgstr": ["Новий"] }, "New folder": { "msgid": "New folder", "msgstr": ["Новий каталог"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["Ім'я нового каталогу"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["Тут відсутні файли"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["Відсутні збіги за фільтром."] }, "No matching files": { "msgid": "No matching files", "msgstr": ["Відсутні збіги файлів."] }, "Recent": { "msgid": "Recent", "msgstr": ["Останні"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["Вибрати всі записи"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["Вибрати запис"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["Вибрати рядок для {nodename}"] }, "Size": { "msgid": "Size", "msgstr": ["Розмір"] }, "Undo": { "msgid": "Undo", "msgstr": ["Повернути"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["Завантажте вміст або синхронізуйте з вашим пристроєм!"] } } } } }, { "locale": "ur_PK", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Urdu (Pakistan) (https://app.transifex.com/nextcloud/teams/64236/ur_PK/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "ur_PK", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Urdu (Pakistan) (https://app.transifex.com/nextcloud/teams/64236/ur_PK/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: ur_PK\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "uz", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Uzbek (https://app.transifex.com/nextcloud/teams/64236/uz/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "uz", "Plural-Forms": "nplurals=1; plural=0;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Uzbek (https://app.transifex.com/nextcloud/teams/64236/uz/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: uz\nPlural-Forms: nplurals=1; plural=0;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }, { "locale": "vi", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Joas Schilling, 2023", "Language-Team": "Vietnamese (https://app.transifex.com/nextcloud/teams/64236/vi/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "vi", "Plural-Forms": "nplurals=1; plural=0;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJoas Schilling, 2023\n" }, "msgstr": ["Last-Translator: Joas Schilling, 2023\nLanguage-Team: Vietnamese (https://app.transifex.com/nextcloud/teams/64236/vi/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: vi\nPlural-Forms: nplurals=1; plural=0;\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": ["Hoàn tác"] } } } } }, { "locale": "zh_CN", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Eric, 2023", "Language-Team": "Chinese (China) (https://app.transifex.com/nextcloud/teams/64236/zh_CN/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "zh_CN", "Plural-Forms": "nplurals=1; plural=0;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nken, 2023\nEric, 2023\n" }, "msgstr": ["Last-Translator: Eric, 2023\nLanguage-Team: Chinese (China) (https://app.transifex.com/nextcloud/teams/64236/zh_CN/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: zh_CN\nPlural-Forms: nplurals=1; plural=0;\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ["“{name}”是无效的文件夹名称。"] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ["“{name}”不是允许的文件夹名称"] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ["文件夹名称中不允许包含“/”。"] }, "All files": { "msgid": "All files", "msgstr": ["所有文件"] }, "Choose": { "msgid": "Choose", "msgstr": ["选择"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["选择 {file}"] }, "Copy": { "msgid": "Copy", "msgstr": ["复制"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["复制到 {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["无法创建新文件夹"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["创建目录"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["当前视图选择器"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["最爱"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["您标记为最爱的文件与文件夹会显示在这里"] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["您最近修改的文件与文件夹会显示在这里"] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["过滤文件列表"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["文件夹名称不能为空。"] }, "Home": { "msgid": "Home", "msgstr": ["主目录"] }, "Modified": { "msgid": "Modified", "msgstr": ["已修改"] }, "Move": { "msgid": "Move", "msgstr": ["移动"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["移动至 {target}"] }, "Name": { "msgid": "Name", "msgstr": ["名称"] }, "New": { "msgid": "New", "msgstr": ["新"] }, "New folder": { "msgid": "New folder", "msgstr": ["新文件夹"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["新文件夹名称"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["此处无文件"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["找不到符合您过滤条件的文件"] }, "No matching files": { "msgid": "No matching files", "msgstr": ["无符合的文件"] }, "Recent": { "msgid": "Recent", "msgstr": ["最近"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["选择所有条目"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["选择条目"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["选择 {nodename} 的列"] }, "Size": { "msgid": "Size", "msgstr": ["大小"] }, "Undo": { "msgid": "Undo", "msgstr": [" 撤消"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["上传一些项目或与您的设备同步！"] } } } } }, { "locale": "zh_HK", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Café Tango, 2024", "Language-Team": "Chinese (Hong Kong) (https://app.transifex.com/nextcloud/teams/64236/zh_HK/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "zh_HK", "Plural-Forms": "nplurals=1; plural=0;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\nCafé Tango, 2024\n" }, "msgstr": ["Last-Translator: Café Tango, 2024\nLanguage-Team: Chinese (Hong Kong) (https://app.transifex.com/nextcloud/teams/64236/zh_HK/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: zh_HK\nPlural-Forms: nplurals=1; plural=0;\n"] }, '"{name}" is an invalid folder name.': { "msgid": '"{name}" is an invalid folder name.', "msgstr": ["「{name}」是無效的資料夾名稱。"] }, '"{name}" is not an allowed folder name': { "msgid": '"{name}" is not an allowed folder name', "msgstr": ["「{name}」是無效的資料夾名稱。"] }, '"/" is not allowed inside a folder name.': { "msgid": '"/" is not allowed inside a folder name.', "msgstr": ['資料夾名稱中不允許使用 "/"。'] }, "All files": { "msgid": "All files", "msgstr": ["所有檔案"] }, "Choose": { "msgid": "Choose", "msgstr": ["選擇"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["選擇 {file}"] }, "Choose %n file": { "msgid": "Choose %n file", "msgid_plural": "Choose %n files", "msgstr": ["選擇 %n 個檔案"] }, "Copy": { "msgid": "Copy", "msgstr": ["複製"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["複製到 {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["無法建立新資料夾"] }, "Could not load files settings": { "msgid": "Could not load files settings", "msgstr": ["無法載入檔案設定"] }, "Could not load files views": { "msgid": "Could not load files views", "msgstr": ["無法載入文件視圖"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["建立目錄"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["目前檢視選取器"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["最愛"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["您標記為最愛的檔案與資料夾將會顯示在此處。"] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["您最近修改的檔案與資料夾將會顯示在此處。"] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["過濾檔案清單"] }, "Folder name cannot be empty.": { "msgid": "Folder name cannot be empty.", "msgstr": ["資料夾名稱不能為空。"] }, "Home": { "msgid": "Home", "msgstr": ["首頁"] }, "Modified": { "msgid": "Modified", "msgstr": ["已修改"] }, "Move": { "msgid": "Move", "msgstr": ["移動"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["移動至 {target}"] }, "Name": { "msgid": "Name", "msgstr": ["名稱"] }, "New": { "msgid": "New", "msgstr": ["新"] }, "New folder": { "msgid": "New folder", "msgstr": ["新資料夾"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["新資料夾名稱"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["此處無檔案"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["找不到符合您過濾條件的檔案。"] }, "No matching files": { "msgid": "No matching files", "msgstr": ["無符合的檔案"] }, "Recent": { "msgid": "Recent", "msgstr": ["最近"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["選取所有條目"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["選取條目"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["選取 {nodename} 的列"] }, "Size": { "msgid": "Size", "msgstr": ["大小"] }, "Undo": { "msgid": "Undo", "msgstr": ["還原"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["上傳一些內容或與您的裝置同步"] } } } } }, { "locale": "zh_TW", "json": { "charset": "utf-8", "headers": { "Last-Translator": "黃柏諺 <s8321414@gmail.com>, 2023", "Language-Team": "Chinese (Taiwan) (https://app.transifex.com/nextcloud/teams/64236/zh_TW/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "zh_TW", "Plural-Forms": "nplurals=1; plural=0;" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nJohn Molakvoæ <skjnldsv@protonmail.com>, 2023\n黃柏諺 <s8321414@gmail.com>, 2023\n" }, "msgstr": ["Last-Translator: 黃柏諺 <s8321414@gmail.com>, 2023\nLanguage-Team: Chinese (Taiwan) (https://app.transifex.com/nextcloud/teams/64236/zh_TW/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: zh_TW\nPlural-Forms: nplurals=1; plural=0;\n"] }, '"{name}" is an invalid file name.': { "msgid": '"{name}" is an invalid file name.', "msgstr": ["「{name}」是無效的檔案名稱。"] }, '"{name}" is not an allowed filetype': { "msgid": '"{name}" is not an allowed filetype', "msgstr": ["「{name}」並非允許的檔案類型"] }, '"/" is not allowed inside a file name.': { "msgid": '"/" is not allowed inside a file name.', "msgstr": ["檔案名稱中不允許使用「/」。"] }, "All files": { "msgid": "All files", "msgstr": ["所有檔案"] }, "Choose": { "msgid": "Choose", "msgstr": ["選擇"] }, "Choose {file}": { "msgid": "Choose {file}", "msgstr": ["選擇 {file}"] }, "Copy": { "msgid": "Copy", "msgstr": ["複製"] }, "Copy to {target}": { "msgid": "Copy to {target}", "msgstr": ["複製到 {target}"] }, "Could not create the new folder": { "msgid": "Could not create the new folder", "msgstr": ["無法建立新資料夾"] }, "Create directory": { "msgid": "Create directory", "msgstr": ["建立目錄"] }, "Current view selector": { "msgid": "Current view selector", "msgstr": ["目前檢視選取器"] }, "Favorites": { "msgid": "Favorites", "msgstr": ["最愛"] }, "File name cannot be empty.": { "msgid": "File name cannot be empty.", "msgstr": ["檔案名稱不能為空。"] }, "Filepicker sections": { "msgid": "Filepicker sections", "msgstr": ["檔案挑選器選取"] }, "Files and folders you mark as favorite will show up here.": { "msgid": "Files and folders you mark as favorite will show up here.", "msgstr": ["您標記為最愛的檔案與資料夾將會顯示在此處。"] }, "Files and folders you recently modified will show up here.": { "msgid": "Files and folders you recently modified will show up here.", "msgstr": ["您最近修改的檔案與資料夾將會顯示在此處。"] }, "Filter file list": { "msgid": "Filter file list", "msgstr": ["過濾檔案清單"] }, "Home": { "msgid": "Home", "msgstr": ["家"] }, "Mime type {mime}": { "msgid": "Mime type {mime}", "msgstr": ["Mime type {mime}"] }, "Modified": { "msgid": "Modified", "msgstr": ["已修改"] }, "Move": { "msgid": "Move", "msgstr": ["移動"] }, "Move to {target}": { "msgid": "Move to {target}", "msgstr": ["移動至 {target}"] }, "Name": { "msgid": "Name", "msgstr": ["名稱"] }, "New": { "msgid": "New", "msgstr": ["新"] }, "New folder": { "msgid": "New folder", "msgstr": ["新資料夾"] }, "New folder name": { "msgid": "New folder name", "msgstr": ["新資料夾名稱"] }, "No files in here": { "msgid": "No files in here", "msgstr": ["此處無檔案"] }, "No files matching your filter were found.": { "msgid": "No files matching your filter were found.", "msgstr": ["找不到符合您過濾條件的檔案。"] }, "No matching files": { "msgid": "No matching files", "msgstr": ["無符合的檔案"] }, "Recent": { "msgid": "Recent", "msgstr": ["最近"] }, "Select all entries": { "msgid": "Select all entries", "msgstr": ["選取所有條目"] }, "Select entry": { "msgid": "Select entry", "msgstr": ["選取條目"] }, "Select the row for {nodename}": { "msgid": "Select the row for {nodename}", "msgstr": ["選取 {nodename} 的列"] }, "Size": { "msgid": "Size", "msgstr": ["大小"] }, "Undo": { "msgid": "Undo", "msgstr": ["復原"] }, "unknown": { "msgid": "unknown", "msgstr": ["未知"] }, "Upload some content or sync with your devices!": { "msgid": "Upload some content or sync with your devices!", "msgstr": ["上傳一些內容或與您的裝置同步"] } } } } }, { "locale": "zu_ZA", "json": { "charset": "utf-8", "headers": { "Last-Translator": "Transifex Bot <>, 2023", "Language-Team": "Zulu (South Africa) (https://app.transifex.com/nextcloud/teams/64236/zu_ZA/)", "Content-Type": "text/plain; charset=UTF-8", "Language": "zu_ZA", "Plural-Forms": "nplurals=2; plural=(n != 1);" }, "translations": { "": { "": { "msgid": "", "comments": { "translator": "\nTranslators:\nTransifex Bot <>, 2023\n" }, "msgstr": ["Last-Translator: Transifex Bot <>, 2023\nLanguage-Team: Zulu (South Africa) (https://app.transifex.com/nextcloud/teams/64236/zu_ZA/)\nContent-Type: text/plain; charset=UTF-8\nLanguage: zu_ZA\nPlural-Forms: nplurals=2; plural=(n != 1);\n"] }, "Undo": { "msgid": "Undo", "comments": { "reference": "lib/toast.ts:223" }, "msgstr": [""] } } } } }].map((data12) => gtBuilder.addTranslation(data12.locale, data12.json));
const gt$2 = gtBuilder.build();
gt$2.ngettext.bind(gt$2);
gt$2.gettext.bind(gt$2);
const TOAST_ARIA_LIVE_OFF = "off";
const TOAST_ARIA_LIVE_POLITE = "polite";
const TOAST_ARIA_LIVE_ASSERTIVE = "assertive";
var ToastAriaLive = /* @__PURE__ */ ((ToastAriaLive2) => {
  ToastAriaLive2[ToastAriaLive2["OFF"] = TOAST_ARIA_LIVE_OFF] = "OFF";
  ToastAriaLive2[ToastAriaLive2["POLITE"] = TOAST_ARIA_LIVE_POLITE] = "POLITE";
  ToastAriaLive2[ToastAriaLive2["ASSERTIVE"] = TOAST_ARIA_LIVE_ASSERTIVE] = "ASSERTIVE";
  return ToastAriaLive2;
})(ToastAriaLive || {});
const TOAST_DEFAULT_TIMEOUT = 7e3;
function showMessage(data12, options2) {
  var _a2;
  options2 = Object.assign({
    timeout: TOAST_DEFAULT_TIMEOUT,
    isHTML: false,
    type: void 0,
    // An undefined selector defaults to the body element
    selector: void 0,
    onRemove: () => {
    },
    onClick: void 0,
    close: true
  }, options2);
  if (typeof data12 === "string" && !options2.isHTML) {
    const element = document.createElement("div");
    element.innerHTML = data12;
    data12 = element.innerText;
  }
  let classes = (_a2 = options2.type) != null ? _a2 : "";
  if (typeof options2.onClick === "function") {
    classes += " toast-with-click ";
  }
  const isNode2 = data12 instanceof Node;
  let ariaLive = ToastAriaLive.POLITE;
  if (options2.ariaLive) {
    ariaLive = options2.ariaLive;
  } else if (options2.type === "toast-error" || options2.type === "toast-undo") {
    ariaLive = ToastAriaLive.ASSERTIVE;
  }
  const toast = Toastify({
    [!isNode2 ? "text" : "node"]: data12,
    duration: options2.timeout,
    callback: options2.onRemove,
    onClick: options2.onClick,
    close: options2.close,
    gravity: "top",
    selector: options2.selector,
    position: "right",
    backgroundColor: "",
    className: "dialogs " + classes,
    escapeMarkup: !options2.isHTML,
    ariaLive
  });
  toast.showToast();
  return toast;
}
function showError(text3, options2) {
  return showMessage(text3, {
    ...options2,
    type: "toast-error"
    /* ERROR */
  });
}
function showSuccess(text3, options2) {
  return showMessage(text3, {
    ...options2,
    type: "toast-success"
    /* SUCCESS */
  });
}
Vue.util.warn;
function tryOnScopeDispose(fn) {
  if (getCurrentScope()) {
    onScopeDispose(fn);
    return true;
  }
  return false;
}
function toValue(r2) {
  return typeof r2 === "function" ? r2() : unref(r2);
}
const isClient = typeof window !== "undefined" && typeof document !== "undefined";
typeof WorkerGlobalScope !== "undefined" && globalThis instanceof WorkerGlobalScope;
const notNullish = (val2) => val2 != null;
const toString$c = Object.prototype.toString;
const isObject$c = (val2) => toString$c.call(val2) === "[object Object]";
const noop$3 = () => {
};
const isIOS$1 = /* @__PURE__ */ getIsIOS();
function getIsIOS() {
  var _a2, _b2;
  return isClient && ((_a2 = window == null ? void 0 : window.navigator) == null ? void 0 : _a2.userAgent) && (/iP(?:ad|hone|od)/.test(window.navigator.userAgent) || ((_b2 = window == null ? void 0 : window.navigator) == null ? void 0 : _b2.maxTouchPoints) > 2 && /iPad|Macintosh/.test(window == null ? void 0 : window.navigator.userAgent));
}
const directiveHooks = {
  mounted: "inserted",
  updated: "componentUpdated",
  unmounted: "unbind"
};
function getLifeCycleTarget(target2) {
  return getCurrentInstance();
}
function toRef(...args) {
  if (args.length !== 1)
    return toRef$1(...args);
  const r2 = args[0];
  return typeof r2 === "function" ? readonly(customRef(() => ({ get: r2, set: noop$3 }))) : ref$1(r2);
}
function tryOnMounted(fn, sync = true, target2) {
  const instance = getLifeCycleTarget();
  if (instance)
    onMounted(fn, target2);
  else if (sync)
    fn();
  else
    nextTick(fn);
}
Vue.util.warn;
function unrefElement$1(elRef) {
  var _a2;
  const plain = toValue(elRef);
  return (_a2 = plain == null ? void 0 : plain.$el) != null ? _a2 : plain;
}
const defaultWindow$1 = isClient ? window : void 0;
function useEventListener$1(...args) {
  let target2;
  let events2;
  let listeners;
  let options2;
  if (typeof args[0] === "string" || Array.isArray(args[0])) {
    [events2, listeners, options2] = args;
    target2 = defaultWindow$1;
  } else {
    [target2, events2, listeners, options2] = args;
  }
  if (!target2)
    return noop$3;
  if (!Array.isArray(events2))
    events2 = [events2];
  if (!Array.isArray(listeners))
    listeners = [listeners];
  const cleanups = [];
  const cleanup = () => {
    cleanups.forEach((fn) => fn());
    cleanups.length = 0;
  };
  const register2 = (el, event, listener, options22) => {
    el.addEventListener(event, listener, options22);
    return () => el.removeEventListener(event, listener, options22);
  };
  const stopWatch = watch(
    () => [unrefElement$1(target2), toValue(options2)],
    ([el, options22]) => {
      cleanup();
      if (!el)
        return;
      const optionsClone = isObject$c(options22) ? { ...options22 } : options22;
      cleanups.push(
        ...events2.flatMap((event) => {
          return listeners.map((listener) => register2(el, event, listener, optionsClone));
        })
      );
    },
    { immediate: true, flush: "post" }
  );
  const stop = () => {
    stopWatch();
    cleanup();
  };
  tryOnScopeDispose(stop);
  return stop;
}
function useMounted() {
  const isMounted = ref$1(false);
  const instance = getCurrentInstance();
  if (instance) {
    onMounted(() => {
      isMounted.value = true;
    }, void 0);
  }
  return isMounted;
}
function useSupported(callback) {
  const isMounted = useMounted();
  return computed(() => {
    isMounted.value;
    return Boolean(callback());
  });
}
function useMutationObserver(target2, callback, options2 = {}) {
  const { window: window2 = defaultWindow$1, ...mutationOptions } = options2;
  let observer;
  const isSupported = useSupported(() => window2 && "MutationObserver" in window2);
  const cleanup = () => {
    if (observer) {
      observer.disconnect();
      observer = void 0;
    }
  };
  const targets = computed(() => {
    const value3 = toValue(target2);
    const items = (Array.isArray(value3) ? value3 : [value3]).map(unrefElement$1).filter(notNullish);
    return new Set(items);
  });
  const stopWatch = watch(
    () => targets.value,
    (targets2) => {
      cleanup();
      if (isSupported.value && targets2.size) {
        observer = new MutationObserver(callback);
        targets2.forEach((el) => observer.observe(el, mutationOptions));
      }
    },
    { immediate: true, flush: "post" }
  );
  const takeRecords = () => {
    return observer == null ? void 0 : observer.takeRecords();
  };
  const stop = () => {
    stopWatch();
    cleanup();
  };
  tryOnScopeDispose(stop);
  return {
    isSupported,
    stop,
    takeRecords
  };
}
function useActiveElement(options2 = {}) {
  var _a2;
  const {
    window: window2 = defaultWindow$1,
    deep = true,
    triggerOnRemoval = false
  } = options2;
  const document2 = (_a2 = options2.document) != null ? _a2 : window2 == null ? void 0 : window2.document;
  const getDeepActiveElement = () => {
    var _a22;
    let element = document2 == null ? void 0 : document2.activeElement;
    if (deep) {
      while (element == null ? void 0 : element.shadowRoot)
        element = (_a22 = element == null ? void 0 : element.shadowRoot) == null ? void 0 : _a22.activeElement;
    }
    return element;
  };
  const activeElement = ref$1();
  const trigger2 = () => {
    activeElement.value = getDeepActiveElement();
  };
  if (window2) {
    useEventListener$1(window2, "blur", (event) => {
      if (event.relatedTarget !== null)
        return;
      trigger2();
    }, true);
    useEventListener$1(window2, "focus", trigger2, true);
  }
  if (triggerOnRemoval) {
    useMutationObserver(document2, (mutations) => {
      mutations.filter((m3) => m3.removedNodes.length).map((n2) => Array.from(n2.removedNodes)).flat().forEach((node) => {
        if (node === activeElement.value)
          trigger2();
      });
    }, {
      childList: true,
      subtree: true
    });
  }
  trigger2();
  return activeElement;
}
function useMediaQuery(query2, options2 = {}) {
  const { window: window2 = defaultWindow$1 } = options2;
  const isSupported = useSupported(() => window2 && "matchMedia" in window2 && typeof window2.matchMedia === "function");
  let mediaQuery;
  const matches2 = ref$1(false);
  const handler9 = (event) => {
    matches2.value = event.matches;
  };
  const cleanup = () => {
    if (!mediaQuery)
      return;
    if ("removeEventListener" in mediaQuery)
      mediaQuery.removeEventListener("change", handler9);
    else
      mediaQuery.removeListener(handler9);
  };
  const stopWatch = watchEffect(() => {
    if (!isSupported.value)
      return;
    cleanup();
    mediaQuery = window2.matchMedia(toValue(query2));
    if ("addEventListener" in mediaQuery)
      mediaQuery.addEventListener("change", handler9);
    else
      mediaQuery.addListener(handler9);
    matches2.value = mediaQuery.matches;
  });
  tryOnScopeDispose(() => {
    stopWatch();
    cleanup();
    mediaQuery = void 0;
  });
  return matches2;
}
function useResizeObserver(target2, callback, options2 = {}) {
  const { window: window2 = defaultWindow$1, ...observerOptions } = options2;
  let observer;
  const isSupported = useSupported(() => window2 && "ResizeObserver" in window2);
  const cleanup = () => {
    if (observer) {
      observer.disconnect();
      observer = void 0;
    }
  };
  const targets = computed(() => {
    const _targets = toValue(target2);
    return Array.isArray(_targets) ? _targets.map((el) => unrefElement$1(el)) : [unrefElement$1(_targets)];
  });
  const stopWatch = watch(
    targets,
    (els) => {
      cleanup();
      if (isSupported.value && window2) {
        observer = new ResizeObserver(callback);
        for (const _el of els) {
          if (_el)
            observer.observe(_el, observerOptions);
        }
      }
    },
    { immediate: true, flush: "post" }
  );
  const stop = () => {
    cleanup();
    stopWatch();
  };
  tryOnScopeDispose(stop);
  return {
    isSupported,
    stop
  };
}
function useElementBounding(target2, options2 = {}) {
  const {
    reset = true,
    windowResize = true,
    windowScroll = true,
    immediate = true,
    updateTiming = "sync"
  } = options2;
  const height = ref$1(0);
  const bottom = ref$1(0);
  const left = ref$1(0);
  const right = ref$1(0);
  const top = ref$1(0);
  const width = ref$1(0);
  const x3 = ref$1(0);
  const y2 = ref$1(0);
  function recalculate() {
    const el = unrefElement$1(target2);
    if (!el) {
      if (reset) {
        height.value = 0;
        bottom.value = 0;
        left.value = 0;
        right.value = 0;
        top.value = 0;
        width.value = 0;
        x3.value = 0;
        y2.value = 0;
      }
      return;
    }
    const rect = el.getBoundingClientRect();
    height.value = rect.height;
    bottom.value = rect.bottom;
    left.value = rect.left;
    right.value = rect.right;
    top.value = rect.top;
    width.value = rect.width;
    x3.value = rect.x;
    y2.value = rect.y;
  }
  function update() {
    if (updateTiming === "sync")
      recalculate();
    else if (updateTiming === "next-frame")
      requestAnimationFrame(() => recalculate());
  }
  useResizeObserver(target2, update);
  watch(() => unrefElement$1(target2), (ele) => !ele && update());
  useMutationObserver(target2, update, {
    attributeFilter: ["style", "class"]
  });
  if (windowScroll)
    useEventListener$1("scroll", update, { capture: true, passive: true });
  if (windowResize)
    useEventListener$1("resize", update, { passive: true });
  tryOnMounted(() => {
    if (immediate)
      update();
  });
  return {
    height,
    bottom,
    left,
    right,
    top,
    width,
    x: x3,
    y: y2,
    update
  };
}
function useElementSize(target2, initialSize = { width: 0, height: 0 }, options2 = {}) {
  const { window: window2 = defaultWindow$1, box = "content-box" } = options2;
  const isSVG2 = computed(() => {
    var _a2, _b2;
    return (_b2 = (_a2 = unrefElement$1(target2)) == null ? void 0 : _a2.namespaceURI) == null ? void 0 : _b2.includes("svg");
  });
  const width = ref$1(initialSize.width);
  const height = ref$1(initialSize.height);
  const { stop: stop1 } = useResizeObserver(
    target2,
    ([entry]) => {
      const boxSize = box === "border-box" ? entry.borderBoxSize : box === "content-box" ? entry.contentBoxSize : entry.devicePixelContentBoxSize;
      if (window2 && isSVG2.value) {
        const $elem = unrefElement$1(target2);
        if ($elem) {
          const rect = $elem.getBoundingClientRect();
          width.value = rect.width;
          height.value = rect.height;
        }
      } else {
        if (boxSize) {
          const formatBoxSize = Array.isArray(boxSize) ? boxSize : [boxSize];
          width.value = formatBoxSize.reduce((acc, { inlineSize }) => acc + inlineSize, 0);
          height.value = formatBoxSize.reduce((acc, { blockSize }) => acc + blockSize, 0);
        } else {
          width.value = entry.contentRect.width;
          height.value = entry.contentRect.height;
        }
      }
    },
    options2
  );
  tryOnMounted(() => {
    const ele = unrefElement$1(target2);
    if (ele) {
      width.value = "offsetWidth" in ele ? ele.offsetWidth : initialSize.width;
      height.value = "offsetHeight" in ele ? ele.offsetHeight : initialSize.height;
    }
  });
  const stop2 = watch(
    () => unrefElement$1(target2),
    (ele) => {
      width.value = ele ? initialSize.width : 0;
      height.value = ele ? initialSize.height : 0;
    }
  );
  function stop() {
    stop1();
    stop2();
  }
  return {
    width,
    height,
    stop
  };
}
function useIntersectionObserver(target2, callback, options2 = {}) {
  const {
    root: root2,
    rootMargin = "0px",
    threshold = 0,
    window: window2 = defaultWindow$1,
    immediate = true
  } = options2;
  const isSupported = useSupported(() => window2 && "IntersectionObserver" in window2);
  const targets = computed(() => {
    const _target = toValue(target2);
    return (Array.isArray(_target) ? _target : [_target]).map(unrefElement$1).filter(notNullish);
  });
  let cleanup = noop$3;
  const isActive = ref$1(immediate);
  const stopWatch = isSupported.value ? watch(
    () => [targets.value, unrefElement$1(root2), isActive.value],
    ([targets2, root22]) => {
      cleanup();
      if (!isActive.value)
        return;
      if (!targets2.length)
        return;
      const observer = new IntersectionObserver(
        callback,
        {
          root: unrefElement$1(root22),
          rootMargin,
          threshold
        }
      );
      targets2.forEach((el) => el && observer.observe(el));
      cleanup = () => {
        observer.disconnect();
        cleanup = noop$3;
      };
    },
    { immediate, flush: "post" }
  ) : noop$3;
  const stop = () => {
    cleanup();
    stopWatch();
    isActive.value = false;
  };
  tryOnScopeDispose(stop);
  return {
    isSupported,
    isActive,
    pause() {
      cleanup();
      isActive.value = false;
    },
    resume() {
      isActive.value = true;
    },
    stop
  };
}
function useFocusWithin(target2, options2 = {}) {
  const activeElement = useActiveElement(options2);
  const targetElement = computed(() => unrefElement$1(target2));
  const focused = computed(() => targetElement.value && activeElement.value ? targetElement.value.contains(activeElement.value) : false);
  return { focused };
}
function useSwipe(target2, options2 = {}) {
  const {
    threshold = 50,
    onSwipe,
    onSwipeEnd,
    onSwipeStart,
    passive = true,
    window: window2 = defaultWindow$1
  } = options2;
  const coordsStart = reactive({ x: 0, y: 0 });
  const coordsEnd = reactive({ x: 0, y: 0 });
  const diffX = computed(() => coordsStart.x - coordsEnd.x);
  const diffY = computed(() => coordsStart.y - coordsEnd.y);
  const { max: max2, abs } = Math;
  const isThresholdExceeded = computed(() => max2(abs(diffX.value), abs(diffY.value)) >= threshold);
  const isSwiping = ref$1(false);
  const direction = computed(() => {
    if (!isThresholdExceeded.value)
      return "none";
    if (abs(diffX.value) > abs(diffY.value)) {
      return diffX.value > 0 ? "left" : "right";
    } else {
      return diffY.value > 0 ? "up" : "down";
    }
  });
  const getTouchEventCoords = (e2) => [e2.touches[0].clientX, e2.touches[0].clientY];
  const updateCoordsStart = (x3, y2) => {
    coordsStart.x = x3;
    coordsStart.y = y2;
  };
  const updateCoordsEnd = (x3, y2) => {
    coordsEnd.x = x3;
    coordsEnd.y = y2;
  };
  let listenerOptions;
  const isPassiveEventSupported = checkPassiveEventSupport(window2 == null ? void 0 : window2.document);
  if (!passive)
    listenerOptions = isPassiveEventSupported ? { passive: false, capture: true } : { capture: true };
  else
    listenerOptions = isPassiveEventSupported ? { passive: true } : { capture: false };
  const onTouchEnd2 = (e2) => {
    if (isSwiping.value)
      onSwipeEnd == null ? void 0 : onSwipeEnd(e2, direction.value);
    isSwiping.value = false;
  };
  const stops = [
    useEventListener$1(target2, "touchstart", (e2) => {
      if (e2.touches.length !== 1)
        return;
      if (listenerOptions.capture && !listenerOptions.passive)
        e2.preventDefault();
      const [x3, y2] = getTouchEventCoords(e2);
      updateCoordsStart(x3, y2);
      updateCoordsEnd(x3, y2);
      onSwipeStart == null ? void 0 : onSwipeStart(e2);
    }, listenerOptions),
    useEventListener$1(target2, "touchmove", (e2) => {
      if (e2.touches.length !== 1)
        return;
      const [x3, y2] = getTouchEventCoords(e2);
      updateCoordsEnd(x3, y2);
      if (!isSwiping.value && isThresholdExceeded.value)
        isSwiping.value = true;
      if (isSwiping.value)
        onSwipe == null ? void 0 : onSwipe(e2);
    }, listenerOptions),
    useEventListener$1(target2, ["touchend", "touchcancel"], onTouchEnd2, listenerOptions)
  ];
  const stop = () => stops.forEach((s3) => s3());
  return {
    isPassiveEventSupported,
    isSwiping,
    direction,
    coordsStart,
    coordsEnd,
    lengthX: diffX,
    lengthY: diffY,
    stop
  };
}
function checkPassiveEventSupport(document2) {
  if (!document2)
    return false;
  let supportsPassive2 = false;
  const optionsBlock = {
    get passive() {
      supportsPassive2 = true;
      return false;
    }
  };
  document2.addEventListener("x", noop$3, optionsBlock);
  document2.removeEventListener("x", noop$3);
  return supportsPassive2;
}
function useWindowSize(options2 = {}) {
  const {
    window: window2 = defaultWindow$1,
    initialWidth = Number.POSITIVE_INFINITY,
    initialHeight = Number.POSITIVE_INFINITY,
    listenOrientation = true,
    includeScrollbar = true,
    type = "inner"
  } = options2;
  const width = ref$1(initialWidth);
  const height = ref$1(initialHeight);
  const update = () => {
    if (window2) {
      if (type === "outer") {
        width.value = window2.outerWidth;
        height.value = window2.outerHeight;
      } else if (includeScrollbar) {
        width.value = window2.innerWidth;
        height.value = window2.innerHeight;
      } else {
        width.value = window2.document.documentElement.clientWidth;
        height.value = window2.document.documentElement.clientHeight;
      }
    }
  };
  update();
  tryOnMounted(update);
  useEventListener$1("resize", update, { passive: true });
  if (listenOrientation) {
    const matches2 = useMediaQuery("(orientation: portrait)");
    watch(matches2, () => update());
  }
  return { width, height };
}
const ScopeComponent = (Component) => {
  if (!Component.mounted) {
    Component.mounted = [];
  } else if (!Array.isArray(Component.mounted)) {
    Component.mounted = [Component.mounted];
  }
  Component.mounted.push(function() {
    this.$el.setAttribute("data-v-".concat("ac203b9"), "");
  });
};
/*!
* tabbable 6.2.0
* @license MIT, https://github.com/focus-trap/tabbable/blob/master/LICENSE
*/
var candidateSelectors = ["input:not([inert])", "select:not([inert])", "textarea:not([inert])", "a[href]:not([inert])", "button:not([inert])", "[tabindex]:not(slot):not([inert])", "audio[controls]:not([inert])", "video[controls]:not([inert])", '[contenteditable]:not([contenteditable="false"]):not([inert])', "details>summary:first-of-type:not([inert])", "details:not([inert])"];
var candidateSelector = /* @__PURE__ */ candidateSelectors.join(",");
var NoElement = typeof Element === "undefined";
var matches = NoElement ? function() {
} : Element.prototype.matches || Element.prototype.msMatchesSelector || Element.prototype.webkitMatchesSelector;
var getRootNode = !NoElement && Element.prototype.getRootNode ? function(element) {
  var _element$getRootNode;
  return element === null || element === void 0 ? void 0 : (_element$getRootNode = element.getRootNode) === null || _element$getRootNode === void 0 ? void 0 : _element$getRootNode.call(element);
} : function(element) {
  return element === null || element === void 0 ? void 0 : element.ownerDocument;
};
var isInert = function isInert2(node, lookUp) {
  var _node$getAttribute;
  if (lookUp === void 0) {
    lookUp = true;
  }
  var inertAtt = node === null || node === void 0 ? void 0 : (_node$getAttribute = node.getAttribute) === null || _node$getAttribute === void 0 ? void 0 : _node$getAttribute.call(node, "inert");
  var inert = inertAtt === "" || inertAtt === "true";
  var result = inert || lookUp && node && isInert2(node.parentNode);
  return result;
};
var isContentEditable = function isContentEditable2(node) {
  var _node$getAttribute2;
  var attValue = node === null || node === void 0 ? void 0 : (_node$getAttribute2 = node.getAttribute) === null || _node$getAttribute2 === void 0 ? void 0 : _node$getAttribute2.call(node, "contenteditable");
  return attValue === "" || attValue === "true";
};
var getCandidates = function getCandidates2(el, includeContainer, filter2) {
  if (isInert(el)) {
    return [];
  }
  var candidates = Array.prototype.slice.apply(el.querySelectorAll(candidateSelector));
  if (includeContainer && matches.call(el, candidateSelector)) {
    candidates.unshift(el);
  }
  candidates = candidates.filter(filter2);
  return candidates;
};
var getCandidatesIteratively = function getCandidatesIteratively2(elements, includeContainer, options2) {
  var candidates = [];
  var elementsToCheck = Array.from(elements);
  while (elementsToCheck.length) {
    var element = elementsToCheck.shift();
    if (isInert(element, false)) {
      continue;
    }
    if (element.tagName === "SLOT") {
      var assigned = element.assignedElements();
      var content = assigned.length ? assigned : element.children;
      var nestedCandidates = getCandidatesIteratively2(content, true, options2);
      if (options2.flatten) {
        candidates.push.apply(candidates, nestedCandidates);
      } else {
        candidates.push({
          scopeParent: element,
          candidates: nestedCandidates
        });
      }
    } else {
      var validCandidate = matches.call(element, candidateSelector);
      if (validCandidate && options2.filter(element) && (includeContainer || !elements.includes(element))) {
        candidates.push(element);
      }
      var shadowRoot = element.shadowRoot || // check for an undisclosed shadow
      typeof options2.getShadowRoot === "function" && options2.getShadowRoot(element);
      var validShadowRoot = !isInert(shadowRoot, false) && (!options2.shadowRootFilter || options2.shadowRootFilter(element));
      if (shadowRoot && validShadowRoot) {
        var _nestedCandidates = getCandidatesIteratively2(shadowRoot === true ? element.children : shadowRoot.children, true, options2);
        if (options2.flatten) {
          candidates.push.apply(candidates, _nestedCandidates);
        } else {
          candidates.push({
            scopeParent: element,
            candidates: _nestedCandidates
          });
        }
      } else {
        elementsToCheck.unshift.apply(elementsToCheck, element.children);
      }
    }
  }
  return candidates;
};
var hasTabIndex = function hasTabIndex2(node) {
  return !isNaN(parseInt(node.getAttribute("tabindex"), 10));
};
var getTabIndex = function getTabIndex2(node) {
  if (!node) {
    throw new Error("No node provided");
  }
  if (node.tabIndex < 0) {
    if ((/^(AUDIO|VIDEO|DETAILS)$/.test(node.tagName) || isContentEditable(node)) && !hasTabIndex(node)) {
      return 0;
    }
  }
  return node.tabIndex;
};
var getSortOrderTabIndex = function getSortOrderTabIndex2(node, isScope) {
  var tabIndex = getTabIndex(node);
  if (tabIndex < 0 && isScope && !hasTabIndex(node)) {
    return 0;
  }
  return tabIndex;
};
var sortOrderedTabbables = function sortOrderedTabbables2(a3, b2) {
  return a3.tabIndex === b2.tabIndex ? a3.documentOrder - b2.documentOrder : a3.tabIndex - b2.tabIndex;
};
var isInput = function isInput2(node) {
  return node.tagName === "INPUT";
};
var isHiddenInput = function isHiddenInput2(node) {
  return isInput(node) && node.type === "hidden";
};
var isDetailsWithSummary = function isDetailsWithSummary2(node) {
  var r2 = node.tagName === "DETAILS" && Array.prototype.slice.apply(node.children).some(function(child) {
    return child.tagName === "SUMMARY";
  });
  return r2;
};
var getCheckedRadio = function getCheckedRadio2(nodes, form) {
  for (var i2 = 0; i2 < nodes.length; i2++) {
    if (nodes[i2].checked && nodes[i2].form === form) {
      return nodes[i2];
    }
  }
};
var isTabbableRadio = function isTabbableRadio2(node) {
  if (!node.name) {
    return true;
  }
  var radioScope = node.form || getRootNode(node);
  var queryRadios = function queryRadios2(name) {
    return radioScope.querySelectorAll('input[type="radio"][name="' + name + '"]');
  };
  var radioSet;
  if (typeof window !== "undefined" && typeof window.CSS !== "undefined" && typeof window.CSS.escape === "function") {
    radioSet = queryRadios(window.CSS.escape(node.name));
  } else {
    try {
      radioSet = queryRadios(node.name);
    } catch (err) {
      console.error("Looks like you have a radio button with a name attribute containing invalid CSS selector characters and need the CSS.escape polyfill: %s", err.message);
      return false;
    }
  }
  var checked = getCheckedRadio(radioSet, node.form);
  return !checked || checked === node;
};
var isRadio = function isRadio2(node) {
  return isInput(node) && node.type === "radio";
};
var isNonTabbableRadio = function isNonTabbableRadio2(node) {
  return isRadio(node) && !isTabbableRadio(node);
};
var isNodeAttached = function isNodeAttached2(node) {
  var _nodeRoot;
  var nodeRoot = node && getRootNode(node);
  var nodeRootHost = (_nodeRoot = nodeRoot) === null || _nodeRoot === void 0 ? void 0 : _nodeRoot.host;
  var attached = false;
  if (nodeRoot && nodeRoot !== node) {
    var _nodeRootHost, _nodeRootHost$ownerDo, _node$ownerDocument;
    attached = !!((_nodeRootHost = nodeRootHost) !== null && _nodeRootHost !== void 0 && (_nodeRootHost$ownerDo = _nodeRootHost.ownerDocument) !== null && _nodeRootHost$ownerDo !== void 0 && _nodeRootHost$ownerDo.contains(nodeRootHost) || node !== null && node !== void 0 && (_node$ownerDocument = node.ownerDocument) !== null && _node$ownerDocument !== void 0 && _node$ownerDocument.contains(node));
    while (!attached && nodeRootHost) {
      var _nodeRoot2, _nodeRootHost2, _nodeRootHost2$ownerD;
      nodeRoot = getRootNode(nodeRootHost);
      nodeRootHost = (_nodeRoot2 = nodeRoot) === null || _nodeRoot2 === void 0 ? void 0 : _nodeRoot2.host;
      attached = !!((_nodeRootHost2 = nodeRootHost) !== null && _nodeRootHost2 !== void 0 && (_nodeRootHost2$ownerD = _nodeRootHost2.ownerDocument) !== null && _nodeRootHost2$ownerD !== void 0 && _nodeRootHost2$ownerD.contains(nodeRootHost));
    }
  }
  return attached;
};
var isZeroArea = function isZeroArea2(node) {
  var _node$getBoundingClie = node.getBoundingClientRect(), width = _node$getBoundingClie.width, height = _node$getBoundingClie.height;
  return width === 0 && height === 0;
};
var isHidden = function isHidden2(node, _ref) {
  var displayCheck = _ref.displayCheck, getShadowRoot = _ref.getShadowRoot;
  if (getComputedStyle(node).visibility === "hidden") {
    return true;
  }
  var isDirectSummary = matches.call(node, "details>summary:first-of-type");
  var nodeUnderDetails = isDirectSummary ? node.parentElement : node;
  if (matches.call(nodeUnderDetails, "details:not([open]) *")) {
    return true;
  }
  if (!displayCheck || displayCheck === "full" || displayCheck === "legacy-full") {
    if (typeof getShadowRoot === "function") {
      var originalNode = node;
      while (node) {
        var parentElement = node.parentElement;
        var rootNode = getRootNode(node);
        if (parentElement && !parentElement.shadowRoot && getShadowRoot(parentElement) === true) {
          return isZeroArea(node);
        } else if (node.assignedSlot) {
          node = node.assignedSlot;
        } else if (!parentElement && rootNode !== node.ownerDocument) {
          node = rootNode.host;
        } else {
          node = parentElement;
        }
      }
      node = originalNode;
    }
    if (isNodeAttached(node)) {
      return !node.getClientRects().length;
    }
    if (displayCheck !== "legacy-full") {
      return true;
    }
  } else if (displayCheck === "non-zero-area") {
    return isZeroArea(node);
  }
  return false;
};
var isDisabledFromFieldset = function isDisabledFromFieldset2(node) {
  if (/^(INPUT|BUTTON|SELECT|TEXTAREA)$/.test(node.tagName)) {
    var parentNode2 = node.parentElement;
    while (parentNode2) {
      if (parentNode2.tagName === "FIELDSET" && parentNode2.disabled) {
        for (var i2 = 0; i2 < parentNode2.children.length; i2++) {
          var child = parentNode2.children.item(i2);
          if (child.tagName === "LEGEND") {
            return matches.call(parentNode2, "fieldset[disabled] *") ? true : !child.contains(node);
          }
        }
        return true;
      }
      parentNode2 = parentNode2.parentElement;
    }
  }
  return false;
};
var isNodeMatchingSelectorFocusable = function isNodeMatchingSelectorFocusable2(options2, node) {
  if (node.disabled || // we must do an inert look up to filter out any elements inside an inert ancestor
  //  because we're limited in the type of selectors we can use in JSDom (see related
  //  note related to `candidateSelectors`)
  isInert(node) || isHiddenInput(node) || isHidden(node, options2) || // For a details element with a summary, the summary element gets the focus
  isDetailsWithSummary(node) || isDisabledFromFieldset(node)) {
    return false;
  }
  return true;
};
var isNodeMatchingSelectorTabbable = function isNodeMatchingSelectorTabbable2(options2, node) {
  if (isNonTabbableRadio(node) || getTabIndex(node) < 0 || !isNodeMatchingSelectorFocusable(options2, node)) {
    return false;
  }
  return true;
};
var isValidShadowRootTabbable = function isValidShadowRootTabbable2(shadowHostNode) {
  var tabIndex = parseInt(shadowHostNode.getAttribute("tabindex"), 10);
  if (isNaN(tabIndex) || tabIndex >= 0) {
    return true;
  }
  return false;
};
var sortByOrder = function sortByOrder2(candidates) {
  var regularTabbables = [];
  var orderedTabbables = [];
  candidates.forEach(function(item, i2) {
    var isScope = !!item.scopeParent;
    var element = isScope ? item.scopeParent : item;
    var candidateTabindex = getSortOrderTabIndex(element, isScope);
    var elements = isScope ? sortByOrder2(item.candidates) : element;
    if (candidateTabindex === 0) {
      isScope ? regularTabbables.push.apply(regularTabbables, elements) : regularTabbables.push(element);
    } else {
      orderedTabbables.push({
        documentOrder: i2,
        tabIndex: candidateTabindex,
        item,
        isScope,
        content: elements
      });
    }
  });
  return orderedTabbables.sort(sortOrderedTabbables).reduce(function(acc, sortable) {
    sortable.isScope ? acc.push.apply(acc, sortable.content) : acc.push(sortable.content);
    return acc;
  }, []).concat(regularTabbables);
};
var tabbable = function tabbable2(container, options2) {
  options2 = options2 || {};
  var candidates;
  if (options2.getShadowRoot) {
    candidates = getCandidatesIteratively([container], options2.includeContainer, {
      filter: isNodeMatchingSelectorTabbable.bind(null, options2),
      flatten: false,
      getShadowRoot: options2.getShadowRoot,
      shadowRootFilter: isValidShadowRootTabbable
    });
  } else {
    candidates = getCandidates(container, options2.includeContainer, isNodeMatchingSelectorTabbable.bind(null, options2));
  }
  return sortByOrder(candidates);
};
var focusable = function focusable2(container, options2) {
  options2 = options2 || {};
  var candidates;
  if (options2.getShadowRoot) {
    candidates = getCandidatesIteratively([container], options2.includeContainer, {
      filter: isNodeMatchingSelectorFocusable.bind(null, options2),
      flatten: true,
      getShadowRoot: options2.getShadowRoot
    });
  } else {
    candidates = getCandidates(container, options2.includeContainer, isNodeMatchingSelectorFocusable.bind(null, options2));
  }
  return candidates;
};
var isTabbable = function isTabbable2(node, options2) {
  options2 = options2 || {};
  if (!node) {
    throw new Error("No node provided");
  }
  if (matches.call(node, candidateSelector) === false) {
    return false;
  }
  return isNodeMatchingSelectorTabbable(options2, node);
};
var focusableCandidateSelector = /* @__PURE__ */ candidateSelectors.concat("iframe").join(",");
var isFocusable = function isFocusable2(node, options2) {
  options2 = options2 || {};
  if (!node) {
    throw new Error("No node provided");
  }
  if (matches.call(node, focusableCandidateSelector) === false) {
    return false;
  }
  return isNodeMatchingSelectorFocusable(options2, node);
};
/*!
* focus-trap 7.5.4
* @license MIT, https://github.com/focus-trap/focus-trap/blob/master/LICENSE
*/
function ownKeys$4(e2, r2) {
  var t50 = Object.keys(e2);
  if (Object.getOwnPropertySymbols) {
    var o2 = Object.getOwnPropertySymbols(e2);
    r2 && (o2 = o2.filter(function(r3) {
      return Object.getOwnPropertyDescriptor(e2, r3).enumerable;
    })), t50.push.apply(t50, o2);
  }
  return t50;
}
function _objectSpread2$1(e2) {
  for (var r2 = 1; r2 < arguments.length; r2++) {
    var t50 = null != arguments[r2] ? arguments[r2] : {};
    r2 % 2 ? ownKeys$4(Object(t50), true).forEach(function(r3) {
      _defineProperty$5(e2, r3, t50[r3]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e2, Object.getOwnPropertyDescriptors(t50)) : ownKeys$4(Object(t50)).forEach(function(r3) {
      Object.defineProperty(e2, r3, Object.getOwnPropertyDescriptor(t50, r3));
    });
  }
  return e2;
}
function _defineProperty$5(obj, key, value3) {
  key = _toPropertyKey$2(key);
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value3,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value3;
  }
  return obj;
}
function _toPrimitive$2(input, hint) {
  if (typeof input !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (typeof res !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _toPropertyKey$2(arg) {
  var key = _toPrimitive$2(arg, "string");
  return typeof key === "symbol" ? key : String(key);
}
var activeFocusTraps = {
  activateTrap: function activateTrap(trapStack, trap) {
    if (trapStack.length > 0) {
      var activeTrap = trapStack[trapStack.length - 1];
      if (activeTrap !== trap) {
        activeTrap.pause();
      }
    }
    var trapIndex = trapStack.indexOf(trap);
    if (trapIndex === -1) {
      trapStack.push(trap);
    } else {
      trapStack.splice(trapIndex, 1);
      trapStack.push(trap);
    }
  },
  deactivateTrap: function deactivateTrap(trapStack, trap) {
    var trapIndex = trapStack.indexOf(trap);
    if (trapIndex !== -1) {
      trapStack.splice(trapIndex, 1);
    }
    if (trapStack.length > 0) {
      trapStack[trapStack.length - 1].unpause();
    }
  }
};
var isSelectableInput = function isSelectableInput2(node) {
  return node.tagName && node.tagName.toLowerCase() === "input" && typeof node.select === "function";
};
var isEscapeEvent = function isEscapeEvent2(e2) {
  return (e2 === null || e2 === void 0 ? void 0 : e2.key) === "Escape" || (e2 === null || e2 === void 0 ? void 0 : e2.key) === "Esc" || (e2 === null || e2 === void 0 ? void 0 : e2.keyCode) === 27;
};
var isTabEvent = function isTabEvent2(e2) {
  return (e2 === null || e2 === void 0 ? void 0 : e2.key) === "Tab" || (e2 === null || e2 === void 0 ? void 0 : e2.keyCode) === 9;
};
var isKeyForward = function isKeyForward2(e2) {
  return isTabEvent(e2) && !e2.shiftKey;
};
var isKeyBackward = function isKeyBackward2(e2) {
  return isTabEvent(e2) && e2.shiftKey;
};
var delay$1 = function delay(fn) {
  return setTimeout(fn, 0);
};
var findIndex = function findIndex2(arr, fn) {
  var idx = -1;
  arr.every(function(value3, i2) {
    if (fn(value3)) {
      idx = i2;
      return false;
    }
    return true;
  });
  return idx;
};
var valueOrHandler = function valueOrHandler2(value3) {
  for (var _len = arguments.length, params = new Array(_len > 1 ? _len - 1 : 0), _key2 = 1; _key2 < _len; _key2++) {
    params[_key2 - 1] = arguments[_key2];
  }
  return typeof value3 === "function" ? value3.apply(void 0, params) : value3;
};
var getActualTarget = function getActualTarget2(event) {
  return event.target.shadowRoot && typeof event.composedPath === "function" ? event.composedPath()[0] : event.target;
};
var internalTrapStack = [];
var createFocusTrap = function createFocusTrap2(elements, userOptions) {
  var doc = (userOptions === null || userOptions === void 0 ? void 0 : userOptions.document) || document;
  var trapStack = (userOptions === null || userOptions === void 0 ? void 0 : userOptions.trapStack) || internalTrapStack;
  var config2 = _objectSpread2$1({
    returnFocusOnDeactivate: true,
    escapeDeactivates: true,
    delayInitialFocus: true,
    isKeyForward,
    isKeyBackward
  }, userOptions);
  var state = {
    // containers given to createFocusTrap()
    // @type {Array<HTMLElement>}
    containers: [],
    // list of objects identifying tabbable nodes in `containers` in the trap
    // NOTE: it's possible that a group has no tabbable nodes if nodes get removed while the trap
    //  is active, but the trap should never get to a state where there isn't at least one group
    //  with at least one tabbable node in it (that would lead to an error condition that would
    //  result in an error being thrown)
    // @type {Array<{
    //   container: HTMLElement,
    //   tabbableNodes: Array<HTMLElement>, // empty if none
    //   focusableNodes: Array<HTMLElement>, // empty if none
    //   posTabIndexesFound: boolean,
    //   firstTabbableNode: HTMLElement|undefined,
    //   lastTabbableNode: HTMLElement|undefined,
    //   firstDomTabbableNode: HTMLElement|undefined,
    //   lastDomTabbableNode: HTMLElement|undefined,
    //   nextTabbableNode: (node: HTMLElement, forward: boolean) => HTMLElement|undefined
    // }>}
    containerGroups: [],
    // same order/length as `containers` list
    // references to objects in `containerGroups`, but only those that actually have
    //  tabbable nodes in them
    // NOTE: same order as `containers` and `containerGroups`, but __not necessarily__
    //  the same length
    tabbableGroups: [],
    nodeFocusedBeforeActivation: null,
    mostRecentlyFocusedNode: null,
    active: false,
    paused: false,
    // timer ID for when delayInitialFocus is true and initial focus in this trap
    //  has been delayed during activation
    delayInitialFocusTimer: void 0,
    // the most recent KeyboardEvent for the configured nav key (typically [SHIFT+]TAB), if any
    recentNavEvent: void 0
  };
  var trap;
  var getOption = function getOption2(configOverrideOptions, optionName, configOptionName) {
    return configOverrideOptions && configOverrideOptions[optionName] !== void 0 ? configOverrideOptions[optionName] : config2[configOptionName || optionName];
  };
  var findContainerIndex = function findContainerIndex2(element, event) {
    var composedPath = typeof (event === null || event === void 0 ? void 0 : event.composedPath) === "function" ? event.composedPath() : void 0;
    return state.containerGroups.findIndex(function(_ref) {
      var container = _ref.container, tabbableNodes = _ref.tabbableNodes;
      return container.contains(element) || // fall back to explicit tabbable search which will take into consideration any
      //  web components if the `tabbableOptions.getShadowRoot` option was used for
      //  the trap, enabling shadow DOM support in tabbable (`Node.contains()` doesn't
      //  look inside web components even if open)
      (composedPath === null || composedPath === void 0 ? void 0 : composedPath.includes(container)) || tabbableNodes.find(function(node) {
        return node === element;
      });
    });
  };
  var getNodeForOption = function getNodeForOption2(optionName) {
    var optionValue = config2[optionName];
    if (typeof optionValue === "function") {
      for (var _len2 = arguments.length, params = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        params[_key2 - 1] = arguments[_key2];
      }
      optionValue = optionValue.apply(void 0, params);
    }
    if (optionValue === true) {
      optionValue = void 0;
    }
    if (!optionValue) {
      if (optionValue === void 0 || optionValue === false) {
        return optionValue;
      }
      throw new Error("`".concat(optionName, "` was specified but was not a node, or did not return a node"));
    }
    var node = optionValue;
    if (typeof optionValue === "string") {
      node = doc.querySelector(optionValue);
      if (!node) {
        throw new Error("`".concat(optionName, "` as selector refers to no known node"));
      }
    }
    return node;
  };
  var getInitialFocusNode = function getInitialFocusNode2() {
    var node = getNodeForOption("initialFocus");
    if (node === false) {
      return false;
    }
    if (node === void 0 || !isFocusable(node, config2.tabbableOptions)) {
      if (findContainerIndex(doc.activeElement) >= 0) {
        node = doc.activeElement;
      } else {
        var firstTabbableGroup = state.tabbableGroups[0];
        var firstTabbableNode = firstTabbableGroup && firstTabbableGroup.firstTabbableNode;
        node = firstTabbableNode || getNodeForOption("fallbackFocus");
      }
    }
    if (!node) {
      throw new Error("Your focus-trap needs to have at least one focusable element");
    }
    return node;
  };
  var updateTabbableNodes = function updateTabbableNodes2() {
    state.containerGroups = state.containers.map(function(container) {
      var tabbableNodes = tabbable(container, config2.tabbableOptions);
      var focusableNodes = focusable(container, config2.tabbableOptions);
      var firstTabbableNode = tabbableNodes.length > 0 ? tabbableNodes[0] : void 0;
      var lastTabbableNode = tabbableNodes.length > 0 ? tabbableNodes[tabbableNodes.length - 1] : void 0;
      var firstDomTabbableNode = focusableNodes.find(function(node) {
        return isTabbable(node);
      });
      var lastDomTabbableNode = focusableNodes.slice().reverse().find(function(node) {
        return isTabbable(node);
      });
      var posTabIndexesFound = !!tabbableNodes.find(function(node) {
        return getTabIndex(node) > 0;
      });
      return {
        container,
        tabbableNodes,
        focusableNodes,
        /** True if at least one node with positive `tabindex` was found in this container. */
        posTabIndexesFound,
        /** First tabbable node in container, __tabindex__ order; `undefined` if none. */
        firstTabbableNode,
        /** Last tabbable node in container, __tabindex__ order; `undefined` if none. */
        lastTabbableNode,
        // NOTE: DOM order is NOT NECESSARILY "document position" order, but figuring that out
        //  would require more than just https://developer.mozilla.org/en-US/docs/Web/API/Node/compareDocumentPosition
        //  because that API doesn't work with Shadow DOM as well as it should (@see
        //  https://github.com/whatwg/dom/issues/320) and since this first/last is only needed, so far,
        //  to address an edge case related to positive tabindex support, this seems like a much easier,
        //  "close enough most of the time" alternative for positive tabindexes which should generally
        //  be avoided anyway...
        /** First tabbable node in container, __DOM__ order; `undefined` if none. */
        firstDomTabbableNode,
        /** Last tabbable node in container, __DOM__ order; `undefined` if none. */
        lastDomTabbableNode,
        /**
         * Finds the __tabbable__ node that follows the given node in the specified direction,
         *  in this container, if any.
         * @param {HTMLElement} node
         * @param {boolean} [forward] True if going in forward tab order; false if going
         *  in reverse.
         * @returns {HTMLElement|undefined} The next tabbable node, if any.
         */
        nextTabbableNode: function nextTabbableNode(node) {
          var forward2 = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : true;
          var nodeIdx = tabbableNodes.indexOf(node);
          if (nodeIdx < 0) {
            if (forward2) {
              return focusableNodes.slice(focusableNodes.indexOf(node) + 1).find(function(el) {
                return isTabbable(el);
              });
            }
            return focusableNodes.slice(0, focusableNodes.indexOf(node)).reverse().find(function(el) {
              return isTabbable(el);
            });
          }
          return tabbableNodes[nodeIdx + (forward2 ? 1 : -1)];
        }
      };
    });
    state.tabbableGroups = state.containerGroups.filter(function(group) {
      return group.tabbableNodes.length > 0;
    });
    if (state.tabbableGroups.length <= 0 && !getNodeForOption("fallbackFocus")) {
      throw new Error("Your focus-trap must have at least one container with at least one tabbable node in it at all times");
    }
    if (state.containerGroups.find(function(g2) {
      return g2.posTabIndexesFound;
    }) && state.containerGroups.length > 1) {
      throw new Error("At least one node with a positive tabindex was found in one of your focus-trap's multiple containers. Positive tabindexes are only supported in single-container focus-traps.");
    }
  };
  var getActiveElement = function getActiveElement2(el) {
    var activeElement = el.activeElement;
    if (!activeElement) {
      return;
    }
    if (activeElement.shadowRoot && activeElement.shadowRoot.activeElement !== null) {
      return getActiveElement2(activeElement.shadowRoot);
    }
    return activeElement;
  };
  var tryFocus = function tryFocus2(node) {
    if (node === false) {
      return;
    }
    if (node === getActiveElement(document)) {
      return;
    }
    if (!node || !node.focus) {
      tryFocus2(getInitialFocusNode());
      return;
    }
    node.focus({
      preventScroll: !!config2.preventScroll
    });
    state.mostRecentlyFocusedNode = node;
    if (isSelectableInput(node)) {
      node.select();
    }
  };
  var getReturnFocusNode = function getReturnFocusNode2(previousActiveElement) {
    var node = getNodeForOption("setReturnFocus", previousActiveElement);
    return node ? node : node === false ? false : previousActiveElement;
  };
  var findNextNavNode = function findNextNavNode2(_ref2) {
    var target2 = _ref2.target, event = _ref2.event, _ref2$isBackward = _ref2.isBackward, isBackward = _ref2$isBackward === void 0 ? false : _ref2$isBackward;
    target2 = target2 || getActualTarget(event);
    updateTabbableNodes();
    var destinationNode = null;
    if (state.tabbableGroups.length > 0) {
      var containerIndex = findContainerIndex(target2, event);
      var containerGroup = containerIndex >= 0 ? state.containerGroups[containerIndex] : void 0;
      if (containerIndex < 0) {
        if (isBackward) {
          destinationNode = state.tabbableGroups[state.tabbableGroups.length - 1].lastTabbableNode;
        } else {
          destinationNode = state.tabbableGroups[0].firstTabbableNode;
        }
      } else if (isBackward) {
        var startOfGroupIndex = findIndex(state.tabbableGroups, function(_ref3) {
          var firstTabbableNode = _ref3.firstTabbableNode;
          return target2 === firstTabbableNode;
        });
        if (startOfGroupIndex < 0 && (containerGroup.container === target2 || isFocusable(target2, config2.tabbableOptions) && !isTabbable(target2, config2.tabbableOptions) && !containerGroup.nextTabbableNode(target2, false))) {
          startOfGroupIndex = containerIndex;
        }
        if (startOfGroupIndex >= 0) {
          var destinationGroupIndex = startOfGroupIndex === 0 ? state.tabbableGroups.length - 1 : startOfGroupIndex - 1;
          var destinationGroup = state.tabbableGroups[destinationGroupIndex];
          destinationNode = getTabIndex(target2) >= 0 ? destinationGroup.lastTabbableNode : destinationGroup.lastDomTabbableNode;
        } else if (!isTabEvent(event)) {
          destinationNode = containerGroup.nextTabbableNode(target2, false);
        }
      } else {
        var lastOfGroupIndex = findIndex(state.tabbableGroups, function(_ref4) {
          var lastTabbableNode = _ref4.lastTabbableNode;
          return target2 === lastTabbableNode;
        });
        if (lastOfGroupIndex < 0 && (containerGroup.container === target2 || isFocusable(target2, config2.tabbableOptions) && !isTabbable(target2, config2.tabbableOptions) && !containerGroup.nextTabbableNode(target2))) {
          lastOfGroupIndex = containerIndex;
        }
        if (lastOfGroupIndex >= 0) {
          var _destinationGroupIndex = lastOfGroupIndex === state.tabbableGroups.length - 1 ? 0 : lastOfGroupIndex + 1;
          var _destinationGroup = state.tabbableGroups[_destinationGroupIndex];
          destinationNode = getTabIndex(target2) >= 0 ? _destinationGroup.firstTabbableNode : _destinationGroup.firstDomTabbableNode;
        } else if (!isTabEvent(event)) {
          destinationNode = containerGroup.nextTabbableNode(target2);
        }
      }
    } else {
      destinationNode = getNodeForOption("fallbackFocus");
    }
    return destinationNode;
  };
  var checkPointerDown = function checkPointerDown2(e2) {
    var target2 = getActualTarget(e2);
    if (findContainerIndex(target2, e2) >= 0) {
      return;
    }
    if (valueOrHandler(config2.clickOutsideDeactivates, e2)) {
      trap.deactivate({
        // NOTE: by setting `returnFocus: false`, deactivate() will do nothing,
        //  which will result in the outside click setting focus to the node
        //  that was clicked (and if not focusable, to "nothing"); by setting
        //  `returnFocus: true`, we'll attempt to re-focus the node originally-focused
        //  on activation (or the configured `setReturnFocus` node), whether the
        //  outside click was on a focusable node or not
        returnFocus: config2.returnFocusOnDeactivate
      });
      return;
    }
    if (valueOrHandler(config2.allowOutsideClick, e2)) {
      return;
    }
    e2.preventDefault();
  };
  var checkFocusIn = function checkFocusIn2(event) {
    var target2 = getActualTarget(event);
    var targetContained = findContainerIndex(target2, event) >= 0;
    if (targetContained || target2 instanceof Document) {
      if (targetContained) {
        state.mostRecentlyFocusedNode = target2;
      }
    } else {
      event.stopImmediatePropagation();
      var nextNode;
      var navAcrossContainers = true;
      if (state.mostRecentlyFocusedNode) {
        if (getTabIndex(state.mostRecentlyFocusedNode) > 0) {
          var mruContainerIdx = findContainerIndex(state.mostRecentlyFocusedNode);
          var tabbableNodes = state.containerGroups[mruContainerIdx].tabbableNodes;
          if (tabbableNodes.length > 0) {
            var mruTabIdx = tabbableNodes.findIndex(function(node) {
              return node === state.mostRecentlyFocusedNode;
            });
            if (mruTabIdx >= 0) {
              if (config2.isKeyForward(state.recentNavEvent)) {
                if (mruTabIdx + 1 < tabbableNodes.length) {
                  nextNode = tabbableNodes[mruTabIdx + 1];
                  navAcrossContainers = false;
                }
              } else {
                if (mruTabIdx - 1 >= 0) {
                  nextNode = tabbableNodes[mruTabIdx - 1];
                  navAcrossContainers = false;
                }
              }
            }
          }
        } else {
          if (!state.containerGroups.some(function(g2) {
            return g2.tabbableNodes.some(function(n2) {
              return getTabIndex(n2) > 0;
            });
          })) {
            navAcrossContainers = false;
          }
        }
      } else {
        navAcrossContainers = false;
      }
      if (navAcrossContainers) {
        nextNode = findNextNavNode({
          // move FROM the MRU node, not event-related node (which will be the node that is
          //  outside the trap causing the focus escape we're trying to fix)
          target: state.mostRecentlyFocusedNode,
          isBackward: config2.isKeyBackward(state.recentNavEvent)
        });
      }
      if (nextNode) {
        tryFocus(nextNode);
      } else {
        tryFocus(state.mostRecentlyFocusedNode || getInitialFocusNode());
      }
    }
    state.recentNavEvent = void 0;
  };
  var checkKeyNav = function checkKeyNav2(event) {
    var isBackward = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : false;
    state.recentNavEvent = event;
    var destinationNode = findNextNavNode({
      event,
      isBackward
    });
    if (destinationNode) {
      if (isTabEvent(event)) {
        event.preventDefault();
      }
      tryFocus(destinationNode);
    }
  };
  var checkKey = function checkKey2(event) {
    if (isEscapeEvent(event) && valueOrHandler(config2.escapeDeactivates, event) !== false) {
      event.preventDefault();
      trap.deactivate();
      return;
    }
    if (config2.isKeyForward(event) || config2.isKeyBackward(event)) {
      checkKeyNav(event, config2.isKeyBackward(event));
    }
  };
  var checkClick = function checkClick2(e2) {
    var target2 = getActualTarget(e2);
    if (findContainerIndex(target2, e2) >= 0) {
      return;
    }
    if (valueOrHandler(config2.clickOutsideDeactivates, e2)) {
      return;
    }
    if (valueOrHandler(config2.allowOutsideClick, e2)) {
      return;
    }
    e2.preventDefault();
    e2.stopImmediatePropagation();
  };
  var addListeners2 = function addListeners3() {
    if (!state.active) {
      return;
    }
    activeFocusTraps.activateTrap(trapStack, trap);
    state.delayInitialFocusTimer = config2.delayInitialFocus ? delay$1(function() {
      tryFocus(getInitialFocusNode());
    }) : tryFocus(getInitialFocusNode());
    doc.addEventListener("focusin", checkFocusIn, true);
    doc.addEventListener("mousedown", checkPointerDown, {
      capture: true,
      passive: false
    });
    doc.addEventListener("touchstart", checkPointerDown, {
      capture: true,
      passive: false
    });
    doc.addEventListener("click", checkClick, {
      capture: true,
      passive: false
    });
    doc.addEventListener("keydown", checkKey, {
      capture: true,
      passive: false
    });
    return trap;
  };
  var removeListeners2 = function removeListeners3() {
    if (!state.active) {
      return;
    }
    doc.removeEventListener("focusin", checkFocusIn, true);
    doc.removeEventListener("mousedown", checkPointerDown, true);
    doc.removeEventListener("touchstart", checkPointerDown, true);
    doc.removeEventListener("click", checkClick, true);
    doc.removeEventListener("keydown", checkKey, true);
    return trap;
  };
  var checkDomRemoval = function checkDomRemoval2(mutations) {
    var isFocusedNodeRemoved = mutations.some(function(mutation) {
      var removedNodes = Array.from(mutation.removedNodes);
      return removedNodes.some(function(node) {
        return node === state.mostRecentlyFocusedNode;
      });
    });
    if (isFocusedNodeRemoved) {
      tryFocus(getInitialFocusNode());
    }
  };
  var mutationObserver = typeof window !== "undefined" && "MutationObserver" in window ? new MutationObserver(checkDomRemoval) : void 0;
  var updateObservedNodes = function updateObservedNodes2() {
    if (!mutationObserver) {
      return;
    }
    mutationObserver.disconnect();
    if (state.active && !state.paused) {
      state.containers.map(function(container) {
        mutationObserver.observe(container, {
          subtree: true,
          childList: true
        });
      });
    }
  };
  trap = {
    get active() {
      return state.active;
    },
    get paused() {
      return state.paused;
    },
    activate: function activate(activateOptions) {
      if (state.active) {
        return this;
      }
      var onActivate = getOption(activateOptions, "onActivate");
      var onPostActivate = getOption(activateOptions, "onPostActivate");
      var checkCanFocusTrap = getOption(activateOptions, "checkCanFocusTrap");
      if (!checkCanFocusTrap) {
        updateTabbableNodes();
      }
      state.active = true;
      state.paused = false;
      state.nodeFocusedBeforeActivation = doc.activeElement;
      onActivate === null || onActivate === void 0 || onActivate();
      var finishActivation = function finishActivation2() {
        if (checkCanFocusTrap) {
          updateTabbableNodes();
        }
        addListeners2();
        updateObservedNodes();
        onPostActivate === null || onPostActivate === void 0 || onPostActivate();
      };
      if (checkCanFocusTrap) {
        checkCanFocusTrap(state.containers.concat()).then(finishActivation, finishActivation);
        return this;
      }
      finishActivation();
      return this;
    },
    deactivate: function deactivate(deactivateOptions) {
      if (!state.active) {
        return this;
      }
      var options2 = _objectSpread2$1({
        onDeactivate: config2.onDeactivate,
        onPostDeactivate: config2.onPostDeactivate,
        checkCanReturnFocus: config2.checkCanReturnFocus
      }, deactivateOptions);
      clearTimeout(state.delayInitialFocusTimer);
      state.delayInitialFocusTimer = void 0;
      removeListeners2();
      state.active = false;
      state.paused = false;
      updateObservedNodes();
      activeFocusTraps.deactivateTrap(trapStack, trap);
      var onDeactivate = getOption(options2, "onDeactivate");
      var onPostDeactivate = getOption(options2, "onPostDeactivate");
      var checkCanReturnFocus = getOption(options2, "checkCanReturnFocus");
      var returnFocus = getOption(options2, "returnFocus", "returnFocusOnDeactivate");
      onDeactivate === null || onDeactivate === void 0 || onDeactivate();
      var finishDeactivation = function finishDeactivation2() {
        delay$1(function() {
          if (returnFocus) {
            tryFocus(getReturnFocusNode(state.nodeFocusedBeforeActivation));
          }
          onPostDeactivate === null || onPostDeactivate === void 0 || onPostDeactivate();
        });
      };
      if (returnFocus && checkCanReturnFocus) {
        checkCanReturnFocus(getReturnFocusNode(state.nodeFocusedBeforeActivation)).then(finishDeactivation, finishDeactivation);
        return this;
      }
      finishDeactivation();
      return this;
    },
    pause: function pause(pauseOptions) {
      if (state.paused || !state.active) {
        return this;
      }
      var onPause = getOption(pauseOptions, "onPause");
      var onPostPause = getOption(pauseOptions, "onPostPause");
      state.paused = true;
      onPause === null || onPause === void 0 || onPause();
      removeListeners2();
      updateObservedNodes();
      onPostPause === null || onPostPause === void 0 || onPostPause();
      return this;
    },
    unpause: function unpause(unpauseOptions) {
      if (!state.paused || !state.active) {
        return this;
      }
      var onUnpause = getOption(unpauseOptions, "onUnpause");
      var onPostUnpause = getOption(unpauseOptions, "onPostUnpause");
      state.paused = false;
      onUnpause === null || onUnpause === void 0 || onUnpause();
      updateTabbableNodes();
      addListeners2();
      updateObservedNodes();
      onPostUnpause === null || onPostUnpause === void 0 || onPostUnpause();
      return this;
    },
    updateContainerElements: function updateContainerElements(containerElements) {
      var elementsAsArray = [].concat(containerElements).filter(Boolean);
      state.containers = elementsAsArray.map(function(element) {
        return typeof element === "string" ? doc.querySelector(element) : element;
      });
      if (state.active) {
        updateTabbableNodes();
      }
      updateObservedNodes();
      return this;
    }
  };
  trap.updateContainerElements(elements);
  return trap;
};
const getTrapStack = function() {
  Object.assign(window, { _nc_focus_trap: window._nc_focus_trap || [] });
  return window._nc_focus_trap;
};
function getLanguage() {
  return document.documentElement.lang || "en";
}
var __defProp$4 = Object.defineProperty;
var __defNormalProp$4 = (obj, key, value3) => key in obj ? __defProp$4(obj, key, { enumerable: true, configurable: true, writable: true, value: value3 }) : obj[key] = value3;
var __publicField$3 = (obj, key, value3) => {
  __defNormalProp$4(obj, typeof key !== "symbol" ? key + "" : key, value3);
  return value3;
};
class GettextBuilder2 {
  constructor() {
    __publicField$3(this, "locale");
    __publicField$3(this, "translations", {});
    __publicField$3(this, "debug", false);
  }
  setLanguage(language) {
    this.locale = language;
    return this;
  }
  /** Try to detect locale from context with `en` as fallback value */
  detectLocale() {
    return this.setLanguage(getLanguage().replace("-", "_"));
  }
  addTranslation(language, data12) {
    this.translations[language] = data12;
    return this;
  }
  enableDebugMode() {
    this.debug = true;
    return this;
  }
  build() {
    return new GettextWrapper2(this.locale || "en", this.translations, this.debug);
  }
}
class GettextWrapper2 {
  constructor(locale3, data12, debug2) {
    __publicField$3(this, "gt");
    this.gt = new GetText({
      debug: debug2,
      sourceLocale: "en"
    });
    for (const key in data12) {
      this.gt.addTranslations(key, "messages", data12[key]);
    }
    this.gt.setLocale(locale3);
  }
  subtitudePlaceholders(translated, vars) {
    return translated.replace(/{([^{}]*)}/g, (a3, b2) => {
      const r2 = vars[b2];
      if (typeof r2 === "string" || typeof r2 === "number") {
        return r2.toString();
      } else {
        return a3;
      }
    });
  }
  /**
   * Get translated string (singular form), optionally with placeholders
   *
   * @param original original string to translate
   * @param placeholders map of placeholder key to value
   */
  gettext(original, placeholders = {}) {
    return this.subtitudePlaceholders(
      this.gt.gettext(original),
      placeholders
    );
  }
  /**
   * Get translated string with plural forms
   *
   * @param singular Singular text form
   * @param plural Plural text form to be used if `count` requires it
   * @param count The number to insert into the text
   * @param placeholders optional map of placeholder key to value
   */
  ngettext(singular, plural, count, placeholders = {}) {
    return this.subtitudePlaceholders(
      this.gt.ngettext(singular, plural, count).replace(/%n/g, count.toString()),
      placeholders
    );
  }
}
function getGettextBuilder() {
  return new GettextBuilder2();
}
const gettext = getGettextBuilder().detectLocale().build();
gettext.ngettext.bind(gettext);
const t$3 = gettext.gettext.bind(gettext);
const register = (...chunks) => {
  chunks.forEach((chunk2) => {
    if (!chunk2.registered) {
      chunk2.forEach(({ l: locale3, t: translations2 }) => {
        const decompressed = Object.fromEntries(
          Object.entries(translations2).map(([id2, value3]) => [
            id2,
            {
              msgid: id2,
              msgid_plural: value3.p,
              msgstr: value3.v
            }
          ])
        );
        if (!gettext.gt.catalogs[locale3]) {
          gettext.gt.catalogs[locale3] = { messages: { translations: {} } };
        }
        gettext.gt.catalogs[locale3].messages.translations[""] = { ...gettext.gt.catalogs[locale3].messages.translations[""], ...decompressed };
      });
      chunk2.registered = true;
    }
  });
};
const t0 = [{ "l": "af", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "ar", "t": { "{tag} (restricted)": { "v": ["{tag} (مُقيّد)"] }, "Select a tag": { "v": ["إختَر سِمَةً tag"] } } }, { "l": "ast", "t": { "{tag} (restricted)": { "v": ["{tag} (restrinxóse)"] }, "Select a tag": { "v": ["Seleicionar una etiqueta"] } } }, { "l": "az", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "be", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "bg", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "bn_BD", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "br", "t": { "{tag} (restricted)": { "v": ["{tag} (bevennet)"] }, "Select a tag": { "v": ["Choaz ur c'hlav"] } } }, { "l": "bs", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "ca", "t": { "{tag} (restricted)": { "v": ["{tag} (restringit)"] }, "Select a tag": { "v": ["Seleccioneu una etiqueta"] } } }, { "l": "cs", "t": { "{tag} (restricted)": { "v": ["{tag} (omezené)"] }, "Select a tag": { "v": ["Vybrat štítek"] } } }, { "l": "cs_CZ", "t": { "{tag} (restricted)": { "v": ["{tag} (omezené)"] }, "Select a tag": { "v": ["Vybrat štítek"] } } }, { "l": "cy_GB", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "da", "t": { "{tag} (restricted)": { "v": ["{tag} (begrænset)"] }, "Select a tag": { "v": ["Vælg et mærke"] } } }, { "l": "de", "t": { "{tag} (restricted)": { "v": ["{tag} (eingeschränkt)"] }, "Select a tag": { "v": ["Schlagwort auswählen"] } } }, { "l": "de_DE", "t": { "{tag} (restricted)": { "v": ["{tag} (eingeschränkt)"] }, "Select a tag": { "v": ["Schlagwort auswählen"] } } }, { "l": "el", "t": { "{tag} (restricted)": { "v": ["{tag} (περιορισμένο)"] }, "Select a tag": { "v": ["Επιλογή ετικέτας"] } } }, { "l": "en_GB", "t": { "{tag} (restricted)": { "v": ["{tag} (restricted)"] }, "Select a tag": { "v": ["Select a tag"] } } }, { "l": "eo", "t": { "{tag} (restricted)": { "v": ["{tag} (limigita)"] }, "Select a tag": { "v": ["Elektu etikedon"] } } }, { "l": "es", "t": { "{tag} (restricted)": { "v": ["{tag} (restringido)"] }, "Select a tag": { "v": ["Seleccione una etiqueta"] } } }, { "l": "es_419", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "es_AR", "t": { "{tag} (restricted)": { "v": ["{tag} (restringido)"] }, "Select a tag": { "v": ["Elija una etiqueta"] } } }, { "l": "es_CL", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "es_CO", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "es_CR", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "es_DO", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "es_EC", "t": { "{tag} (restricted)": { "v": ["{tag} (restricted)"] }, "Select a tag": { "v": ["Seleccionar una etiqueta"] } } }, { "l": "es_GT", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "es_HN", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "es_MX", "t": { "{tag} (restricted)": { "v": ["{tag} (restringido)"] }, "Select a tag": { "v": ["Seleccionar una etiqueta"] } } }, { "l": "es_NI", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "es_PA", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "es_PE", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "es_PR", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "es_PY", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "es_SV", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "es_UY", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "et_EE", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "eu", "t": { "{tag} (restricted)": { "v": ["{tag} (mugatua)"] }, "Select a tag": { "v": ["Hautatu etiketa bat"] } } }, { "l": "fa", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "fi", "t": { "{tag} (restricted)": { "v": ["{tag} (rajoitettu)"] }, "Select a tag": { "v": ["Valitse tagi"] } } }, { "l": "fo", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "fr", "t": { "{tag} (restricted)": { "v": ["{tag} (restreint)"] }, "Select a tag": { "v": ["Sélectionnez une balise"] } } }, { "l": "ga", "t": { "{tag} (restricted)": { "v": ["{tag} (srianta)"] }, "Select a tag": { "v": ["Roghnaigh clib"] } } }, { "l": "gd", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "gl", "t": { "{tag} (restricted)": { "v": ["{tag} (restrinxido)"] }, "Select a tag": { "v": ["Seleccione unha etiqueta"] } } }, { "l": "he", "t": { "{tag} (restricted)": { "v": ["{tag} (מוגבל)"] }, "Select a tag": { "v": ["בחירת תגית"] } } }, { "l": "hi_IN", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "hr", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "hsb", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "hu", "t": { "{tag} (restricted)": { "v": ["{tag} (korlátozott)"] }, "Select a tag": { "v": ["Válasszon címkét"] } } }, { "l": "hy", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "ia", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "id", "t": { "{tag} (restricted)": { "v": ["{tag} (dibatasi)"] }, "Select a tag": { "v": ["Pilih tag"] } } }, { "l": "ig", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "is", "t": { "{tag} (restricted)": { "v": ["{tag} (takmarkað)"] }, "Select a tag": { "v": ["Veldu merki"] } } }, { "l": "it", "t": { "{tag} (restricted)": { "v": ["{tag} (limitato)"] }, "Select a tag": { "v": ["Seleziona un'etichetta"] } } }, { "l": "ja", "t": { "{tag} (restricted)": { "v": ["{tag} (制限付)"] }, "Select a tag": { "v": ["タグを選択"] } } }, { "l": "ja_JP", "t": { "{tag} (restricted)": { "v": ["{tag} (制限付)"] }, "Select a tag": { "v": ["タグを選択"] } } }, { "l": "ka", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "ka_GE", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "kab", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "kk", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "km", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "kn", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "ko", "t": { "{tag} (restricted)": { "v": ["{tag}(제한)"] }, "Select a tag": { "v": [""] } } }, { "l": "la", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "lb", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "lo", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "lt_LT", "t": { "{tag} (restricted)": { "v": ["{tag} (apribota)"] }, "Select a tag": { "v": ["Pasirinkti žymę"] } } }, { "l": "lv", "t": { "{tag} (restricted)": { "v": ["{tag} (ierobežots)"] }, "Select a tag": { "v": ["Izvēlēties birku"] } } }, { "l": "mk", "t": { "{tag} (restricted)": { "v": ["{tag} (ограничено)"] }, "Select a tag": { "v": ["Избери ознака"] } } }, { "l": "mn", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "mr", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "ms_MY", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "my", "t": { "{tag} (restricted)": { "v": ["{tag} (ကန့်သတ်)"] }, "Select a tag": { "v": ["tag ရွေးချယ်ရန်"] } } }, { "l": "nb", "t": { "{tag} (restricted)": { "v": ["{tag} (beskyttet)"] }, "Select a tag": { "v": ["Velg en merkelapp"] } } }, { "l": "ne", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "nl", "t": { "{tag} (restricted)": { "v": ["{tag} (beperkt)"] }, "Select a tag": { "v": ["Selecteer een label"] } } }, { "l": "nn_NO", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "oc", "t": { "{tag} (restricted)": { "v": ["{tag} (limit)"] }, "Select a tag": { "v": ["Seleccionar una etiqueta"] } } }, { "l": "pl", "t": { "{tag} (restricted)": { "v": ["{tag} (ograniczona)"] }, "Select a tag": { "v": ["Wybierz etykietę"] } } }, { "l": "ps", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "pt_BR", "t": { "{tag} (restricted)": { "v": ["{tag} (restrito) "] }, "Select a tag": { "v": ["Selecionar uma tag"] } } }, { "l": "pt_PT", "t": { "{tag} (restricted)": { "v": ["{tag} (restrito)"] }, "Select a tag": { "v": ["Selecionar uma etiqueta"] } } }, { "l": "ro", "t": { "{tag} (restricted)": { "v": ["{tag} (restricționat)"] }, "Select a tag": { "v": ["Selectați o etichetă"] } } }, { "l": "ru", "t": { "{tag} (restricted)": { "v": ["{tag} (ограниченное)"] }, "Select a tag": { "v": ["Выберите метку"] } } }, { "l": "sc", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "si", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "sk", "t": { "{tag} (restricted)": { "v": ["{tag} (obmedzený)"] }, "Select a tag": { "v": ["Vybrať štítok"] } } }, { "l": "sl", "t": { "{tag} (restricted)": { "v": ["{tag} (omejeno)"] }, "Select a tag": { "v": ["Izbor oznake"] } } }, { "l": "sq", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "sr", "t": { "{tag} (restricted)": { "v": ["{tag} (ограничено)"] }, "Select a tag": { "v": ["Изаберите ознаку"] } } }, { "l": "sr@latin", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "sv", "t": { "{tag} (restricted)": { "v": ["{tag} (begränsad)"] }, "Select a tag": { "v": ["Välj en tag"] } } }, { "l": "sw", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "ta", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "th", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "tk", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "tr", "t": { "{tag} (restricted)": { "v": ["{tag} (kısıtlı)"] }, "Select a tag": { "v": ["Bir etiket seçin"] } } }, { "l": "ug", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "uk", "t": { "{tag} (restricted)": { "v": ["{tag} (обмежений)"] }, "Select a tag": { "v": ["Виберіть позначку"] } } }, { "l": "ur_PK", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "uz", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "vi", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }, { "l": "zh_CN", "t": { "{tag} (restricted)": { "v": ["{tag} （受限）"] }, "Select a tag": { "v": ["选择一个标签"] } } }, { "l": "zh_HK", "t": { "{tag} (restricted)": { "v": ["{tag} (受限)"] }, "Select a tag": { "v": ["選擇標籤"] } } }, { "l": "zh_TW", "t": { "{tag} (restricted)": { "v": ["{tag}（受限）"] }, "Select a tag": { "v": ["選擇標籤"] } } }, { "l": "zu_ZA", "t": { "{tag} (restricted)": { "v": [""] }, "Select a tag": { "v": [""] } } }];
const t1 = [{ "l": "af", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "ar", "t": { "A color with a HEX value {hex}": { "v": ["لون بالقيمة الست عشرية {hex}"] }, "Back": { "v": ["عودة"] }, "Choose": { "v": ["إختَر"] }, "Color picker": { "v": ["لاقط الألوان"] }, "More options": { "v": ["خيارات أخرى ..."] } } }, { "l": "ast", "t": { "A color with a HEX value {hex}": { "v": ["Un color con un valor HEX {hex}"] }, "Back": { "v": ["Atrás"] }, "Choose": { "v": ["Escoyer"] }, "Color picker": { "v": ["Selector de colores"] }, "More options": { "v": ["Más opciones"] } } }, { "l": "az", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "be", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "bg", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "bn_BD", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "br", "t": { "Back": { "v": [""] }, "Choose": { "v": ["Dibab"] }, "More options": { "v": [""] } } }, { "l": "bs", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "ca", "t": { "Back": { "v": [""] }, "Choose": { "v": ["Tria"] }, "More options": { "v": [""] } } }, { "l": "cs", "t": { "A color with a HEX value {hex}": { "v": ["Barva vyjádřená HEX hodnotou {hex}"] }, "Back": { "v": ["Zpět"] }, "Choose": { "v": ["Zvolit"] }, "Color picker": { "v": ["Výběr barev"] }, "More options": { "v": ["Další volby"] } } }, { "l": "cs_CZ", "t": { "A color with a HEX value {hex}": { "v": ["Barva vyjádřená HEX hodnotou {hex}"] }, "Back": { "v": ["Zpět"] }, "Choose": { "v": ["Zvolit"] }, "Color picker": { "v": ["Výběr barev"] }, "More options": { "v": ["Další volby"] } } }, { "l": "cy_GB", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "da", "t": { "A color with a HEX value {hex}": { "v": ["En farve med en HEX-værdi {hex}"] }, "Back": { "v": ["Tilbage"] }, "Choose": { "v": ["Vælg"] }, "Color picker": { "v": ["Farvevælger"] }, "More options": { "v": ["Flere muligheder"] } } }, { "l": "de", "t": { "A color with a HEX value {hex}": { "v": ["Eine Farbe mit einem HEX-Wert {hex}"] }, "Back": { "v": ["Zurück"] }, "Choose": { "v": ["Auswählen"] }, "Color picker": { "v": ["Farbauswahl"] }, "More options": { "v": ["Weitere Optionen"] } } }, { "l": "de_DE", "t": { "A color with a HEX value {hex}": { "v": ["Eine Farbe mit einem HEX-Wert {hex}"] }, "Back": { "v": ["Zurück"] }, "Choose": { "v": ["Auswählen"] }, "Color picker": { "v": ["Farbauswahl"] }, "More options": { "v": ["Mehr Optionen"] } } }, { "l": "el", "t": { "Back": { "v": [""] }, "Choose": { "v": ["Επιλογή"] }, "More options": { "v": [""] } } }, { "l": "en_GB", "t": { "A color with a HEX value {hex}": { "v": ["A colour with a HEX value {hex}"] }, "Back": { "v": ["Back"] }, "Choose": { "v": ["Choose"] }, "Color picker": { "v": ["Colour picker"] }, "More options": { "v": ["More options"] } } }, { "l": "eo", "t": { "Back": { "v": [""] }, "Choose": { "v": ["Elektu"] }, "More options": { "v": [""] } } }, { "l": "es", "t": { "A color with a HEX value {hex}": { "v": ["Un color con un valor HEX {hex}"] }, "Back": { "v": ["Atrás"] }, "Choose": { "v": ["Escoger"] }, "Color picker": { "v": ["Selector de color"] }, "More options": { "v": ["Más opciones"] } } }, { "l": "es_419", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "es_AR", "t": { "A color with a HEX value {hex}": { "v": ["Un color con valor HEX {hex}"] }, "Back": { "v": ["Atrás"] }, "Choose": { "v": ["Elegir"] }, "Color picker": { "v": ["Selector de color"] }, "More options": { "v": ["Más opciones"] } } }, { "l": "es_CL", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "es_CO", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "es_CR", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "es_DO", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "es_EC", "t": { "Back": { "v": ["Atrás"] }, "Choose": { "v": ["Elegir"] }, "More options": { "v": ["Más opciones"] } } }, { "l": "es_GT", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "es_HN", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "es_MX", "t": { "A color with a HEX value {hex}": { "v": ["Un color con valor HEX {hex}"] }, "Back": { "v": ["Atrás"] }, "Choose": { "v": ["Elegir"] }, "Color picker": { "v": ["Selector de color"] }, "More options": { "v": ["Más opciones"] } } }, { "l": "es_NI", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "es_PA", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "es_PE", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "es_PR", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "es_PY", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "es_SV", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "es_UY", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "et_EE", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "eu", "t": { "Back": { "v": ["Atzera"] }, "Choose": { "v": ["Aukeratu"] }, "More options": { "v": ["Aukera gehiago"] } } }, { "l": "fa", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "fi", "t": { "Back": { "v": [""] }, "Choose": { "v": ["Valitse"] }, "More options": { "v": [""] } } }, { "l": "fo", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "fr", "t": { "A color with a HEX value {hex}": { "v": ["Une couleur de valeur HEX {hex}"] }, "Back": { "v": ["Retour"] }, "Choose": { "v": ["Choisir"] }, "More options": { "v": ["Plus d'options"] } } }, { "l": "ga", "t": { "A color with a HEX value {hex}": { "v": ["Dath le luach HEX {hex}"] }, "Back": { "v": ["Ar ais"] }, "Choose": { "v": ["Roghnaigh"] }, "Color picker": { "v": ["Roghnóir dathanna"] }, "More options": { "v": ["Tuilleadh roghanna"] } } }, { "l": "gd", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "gl", "t": { "A color with a HEX value {hex}": { "v": ["Unha cor cun valor HEX {hex}"] }, "Back": { "v": ["Atrás"] }, "Choose": { "v": ["Escoller"] }, "Color picker": { "v": ["Selector de cores"] }, "More options": { "v": ["Máis opcións"] } } }, { "l": "he", "t": { "Back": { "v": ["חזרה"] }, "Choose": { "v": ["בחירה"] }, "More options": { "v": ["אפשרויות נוספות"] } } }, { "l": "hi_IN", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "hr", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "hsb", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "hu", "t": { "Back": { "v": [""] }, "Choose": { "v": ["Válassszon"] }, "More options": { "v": [""] } } }, { "l": "hy", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "ia", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "id", "t": { "A color with a HEX value {hex}": { "v": ["Warna dengan nilai HEX {hex}"] }, "Back": { "v": ["Kembali"] }, "Choose": { "v": ["Pilih"] }, "More options": { "v": ["Opsi lainnya"] } } }, { "l": "ig", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "is", "t": { "A color with a HEX value {hex}": { "v": ["Litur með HEX-gildi {hex}"] }, "Back": { "v": ["Til baka"] }, "Choose": { "v": ["Velja"] }, "More options": { "v": ["Fleiri valkostir"] } } }, { "l": "it", "t": { "A color with a HEX value {hex}": { "v": ["Un colore con un valore HEX {hex}"] }, "Back": { "v": ["Indietro"] }, "Choose": { "v": ["Scegli"] }, "More options": { "v": ["Altre opzioni"] } } }, { "l": "ja", "t": { "A color with a HEX value {hex}": { "v": [" HEX値 {hex} を持つ色"] }, "Back": { "v": ["戻る"] }, "Choose": { "v": ["選択"] }, "Color picker": { "v": ["カラーピッカー"] }, "More options": { "v": ["他のオプション"] } } }, { "l": "ja_JP", "t": { "A color with a HEX value {hex}": { "v": [" HEX値 {hex} を持つ色"] }, "Back": { "v": ["戻る"] }, "Choose": { "v": ["選択"] }, "Color picker": { "v": ["カラーピッカー"] }, "More options": { "v": ["他のオプション"] } } }, { "l": "ka", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "ka_GE", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "kab", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "kk", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "km", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "kn", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "ko", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "la", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "lb", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "lo", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "lt_LT", "t": { "Back": { "v": [""] }, "Choose": { "v": ["Pasirinkti"] }, "More options": { "v": [""] } } }, { "l": "lv", "t": { "Back": { "v": [""] }, "Choose": { "v": ["Izvēlēties"] }, "More options": { "v": [""] } } }, { "l": "mk", "t": { "Back": { "v": [""] }, "Choose": { "v": ["Избери"] }, "More options": { "v": [""] } } }, { "l": "mn", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "mr", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "ms_MY", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "my", "t": { "Back": { "v": [""] }, "Choose": { "v": ["ရွေးချယ်ရန်"] }, "More options": { "v": [""] } } }, { "l": "nb", "t": { "A color with a HEX value {hex}": { "v": ["En farge med en HEX-verdi {hex}"] }, "Back": { "v": ["Tilbake"] }, "Choose": { "v": ["Velg"] }, "Color picker": { "v": ["Fargevelger"] }, "More options": { "v": ["Flere alternativer"] } } }, { "l": "ne", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "nl", "t": { "A color with a HEX value {hex}": { "v": ["Een kleur met een HEX-waarde {hex}"] }, "Back": { "v": ["Terug"] }, "Choose": { "v": ["Kies"] }, "Color picker": { "v": ["Kleurkiezer"] }, "More options": { "v": ["Meer opties"] } } }, { "l": "nn_NO", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "oc", "t": { "Back": { "v": [""] }, "Choose": { "v": ["Causir"] }, "More options": { "v": [""] } } }, { "l": "pl", "t": { "A color with a HEX value {hex}": { "v": ["Kolor o wartości HEX {hex}"] }, "Back": { "v": ["Wstecz"] }, "Choose": { "v": ["Wybierz"] }, "Color picker": { "v": ["Wybierz kolor"] }, "More options": { "v": ["Więcej opcji"] } } }, { "l": "ps", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "pt_BR", "t": { "A color with a HEX value {hex}": { "v": ["Uma cor com valor HEX {hex}"] }, "Back": { "v": ["Voltar"] }, "Choose": { "v": ["Escolher"] }, "Color picker": { "v": ["Seletor de cores"] }, "More options": { "v": ["Mais opções"] } } }, { "l": "pt_PT", "t": { "Back": { "v": ["Voltar atrás"] }, "Choose": { "v": ["Escolher"] }, "More options": { "v": ["Mais opções"] } } }, { "l": "ro", "t": { "A color with a HEX value {hex}": { "v": ["O culoare în HEX value {hex}"] }, "Back": { "v": ["Înapoi"] }, "Choose": { "v": ["Alegeți"] }, "More options": { "v": ["Mai multe opțiuni"] } } }, { "l": "ru", "t": { "Back": { "v": ["Назад"] }, "Choose": { "v": ["Выберите"] }, "More options": { "v": ["Больше опций"] } } }, { "l": "sc", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "si", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "sk", "t": { "Back": { "v": [""] }, "Choose": { "v": ["Vybrať"] }, "More options": { "v": [""] } } }, { "l": "sl", "t": { "Back": { "v": [""] }, "Choose": { "v": ["Izbor"] }, "More options": { "v": [""] } } }, { "l": "sq", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "sr", "t": { "A color with a HEX value {hex}": { "v": ["Боја са HEX вредности {hex}"] }, "Back": { "v": ["Назад"] }, "Choose": { "v": ["Изаберите"] }, "Color picker": { "v": ["Бирач боје"] }, "More options": { "v": ["Још опција"] } } }, { "l": "sr@latin", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "sv", "t": { "A color with a HEX value {hex}": { "v": ["En färg med ett HEX-värde {hex}"] }, "Back": { "v": ["Tillbaka"] }, "Choose": { "v": ["Välj"] }, "Color picker": { "v": ["Färgväljare"] }, "More options": { "v": ["Fler alternativ"] } } }, { "l": "sw", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "ta", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "th", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "tk", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "tr", "t": { "A color with a HEX value {hex}": { "v": ["{hex} onaltılık değeri ile bir renk "] }, "Back": { "v": ["Geri"] }, "Choose": { "v": ["Seçin"] }, "Color picker": { "v": ["Renk seçici"] }, "More options": { "v": ["Diğer seçenekler"] } } }, { "l": "ug", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "uk", "t": { "A color with a HEX value {hex}": { "v": ["Колір у форматі HEX {hex}"] }, "Back": { "v": ["Назад"] }, "Choose": { "v": ["Виберіть"] }, "Color picker": { "v": ["Вибір кольору"] }, "More options": { "v": ["Більше об'єктів"] } } }, { "l": "ur_PK", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "uz", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "vi", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }, { "l": "zh_CN", "t": { "Back": { "v": [""] }, "Choose": { "v": ["选择"] }, "More options": { "v": [""] } } }, { "l": "zh_HK", "t": { "Back": { "v": ["返回"] }, "Choose": { "v": ["選擇"] }, "More options": { "v": ["更多選項"] } } }, { "l": "zh_TW", "t": { "Back": { "v": ["返回"] }, "Choose": { "v": ["選擇"] }, "More options": { "v": ["更多選項"] } } }, { "l": "zu_ZA", "t": { "Back": { "v": [""] }, "Choose": { "v": [""] }, "More options": { "v": [""] } } }];
const t2 = [{ "l": "af", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "ar", "t": { "a few seconds ago": { "v": ["منذ عدة ثوانٍ"] }, "sec. ago": { "v": ["ثانية مضت"] }, "seconds ago": { "v": ["ثوانٍ مضت"] } } }, { "l": "ast", "t": { "a few seconds ago": { "v": ["hai unos segundos"] }, "sec. ago": { "v": ["hai segs"] }, "seconds ago": { "v": ["hai segundos"] } } }, { "l": "az", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "be", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "bg", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "bn_BD", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "br", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "bs", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "ca", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "cs", "t": { "a few seconds ago": { "v": ["před několika sekundami"] }, "sec. ago": { "v": ["sek. před"] }, "seconds ago": { "v": ["sekund předtím"] } } }, { "l": "cs_CZ", "t": { "a few seconds ago": { "v": ["před několika sekundami"] }, "sec. ago": { "v": ["sek. před"] }, "seconds ago": { "v": ["sekund předtím"] } } }, { "l": "cy_GB", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "da", "t": { "a few seconds ago": { "v": ["et par sekunder siden"] }, "sec. ago": { "v": ["sek. siden"] }, "seconds ago": { "v": ["sekunder siden"] } } }, { "l": "de", "t": { "a few seconds ago": { "v": ["vor ein paar Sekunden"] }, "sec. ago": { "v": ["Sek. zuvor"] }, "seconds ago": { "v": ["Sekunden zuvor"] } } }, { "l": "de_DE", "t": { "a few seconds ago": { "v": ["vor ein paar Sekunden"] }, "sec. ago": { "v": ["Sek. zuvor"] }, "seconds ago": { "v": ["Sekunden zuvor"] } } }, { "l": "el", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "en_GB", "t": { "a few seconds ago": { "v": ["a few seconds ago"] }, "sec. ago": { "v": ["sec. ago"] }, "seconds ago": { "v": ["seconds ago"] } } }, { "l": "eo", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "es", "t": { "a few seconds ago": { "v": ["hace unos pocos segundos"] }, "sec. ago": { "v": ["hace segundos"] }, "seconds ago": { "v": ["segundos atrás"] } } }, { "l": "es_419", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "es_AR", "t": { "a few seconds ago": { "v": ["hace unos segundos"] }, "sec. ago": { "v": ["seg. atrás"] }, "seconds ago": { "v": ["segundos atrás"] } } }, { "l": "es_CL", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "es_CO", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "es_CR", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "es_DO", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "es_EC", "t": { "a few seconds ago": { "v": ["hace unos segundos"] }, "sec. ago": { "v": ["hace segundos"] }, "seconds ago": { "v": ["Segundos atrás"] } } }, { "l": "es_GT", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "es_HN", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "es_MX", "t": { "a few seconds ago": { "v": ["hace unos segundos"] }, "sec. ago": { "v": ["seg. atrás"] }, "seconds ago": { "v": ["segundos atrás"] } } }, { "l": "es_NI", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "es_PA", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "es_PE", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "es_PR", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "es_PY", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "es_SV", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "es_UY", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "et_EE", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "eu", "t": { "a few seconds ago": { "v": ["duela segundo batzuk"] }, "sec. ago": { "v": ["duela seg."] }, "seconds ago": { "v": ["duela segundo"] } } }, { "l": "fa", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "fi", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "fo", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "fr", "t": { "a few seconds ago": { "v": ["il y a quelques instants"] }, "sec. ago": { "v": ["il y a sec."] }, "seconds ago": { "v": ["il y a secondes"] } } }, { "l": "ga", "t": { "a few seconds ago": { "v": ["cúpla soicind ó shin"] }, "sec. ago": { "v": ["soic. ó shin"] }, "seconds ago": { "v": ["soicind ó shin"] } } }, { "l": "gd", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "gl", "t": { "a few seconds ago": { "v": ["hai uns segundos"] }, "sec. ago": { "v": ["segs. atrás"] }, "seconds ago": { "v": ["segundos atrás"] } } }, { "l": "he", "t": { "a few seconds ago": { "v": ["לפני מספר שניות"] }, "sec. ago": { "v": ["לפני מספר שניות"] }, "seconds ago": { "v": ["לפני מס׳ שניות"] } } }, { "l": "hi_IN", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "hr", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "hsb", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "hu", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "hy", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "ia", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "id", "t": { "a few seconds ago": { "v": ["beberapa detik yang lalu"] }, "sec. ago": { "v": ["dtk. yang lalu"] }, "seconds ago": { "v": ["beberapa detik lalu"] } } }, { "l": "ig", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "is", "t": { "a few seconds ago": { "v": ["fyrir örfáum sekúndum síðan"] }, "sec. ago": { "v": ["sek. síðan"] }, "seconds ago": { "v": ["sekúndum síðan"] } } }, { "l": "it", "t": { "a few seconds ago": { "v": ["pochi secondi fa"] }, "sec. ago": { "v": ["sec. fa"] }, "seconds ago": { "v": ["secondi fa"] } } }, { "l": "ja", "t": { "a few seconds ago": { "v": ["数秒前"] }, "sec. ago": { "v": ["秒前"] }, "seconds ago": { "v": ["数秒前"] } } }, { "l": "ja_JP", "t": { "a few seconds ago": { "v": ["数秒前"] }, "sec. ago": { "v": ["秒前"] }, "seconds ago": { "v": ["数秒前"] } } }, { "l": "ka", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "ka_GE", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "kab", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "kk", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "km", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "kn", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "ko", "t": { "a few seconds ago": { "v": ["방금 전"] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "la", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "lb", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "lo", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "lt_LT", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "lv", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "mk", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "mn", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "mr", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "ms_MY", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "my", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "nb", "t": { "a few seconds ago": { "v": ["noen få sekunder siden"] }, "sec. ago": { "v": ["sek. siden"] }, "seconds ago": { "v": ["sekunder siden"] } } }, { "l": "ne", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "nl", "t": { "a few seconds ago": { "v": ["enkele seconden terug"] }, "sec. ago": { "v": ["sec. geleden"] }, "seconds ago": { "v": ["seconden geleden"] } } }, { "l": "nn_NO", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "oc", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "pl", "t": { "a few seconds ago": { "v": ["kilka sekund temu"] }, "sec. ago": { "v": ["sek. temu"] }, "seconds ago": { "v": ["sekund temu"] } } }, { "l": "ps", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "pt_BR", "t": { "a few seconds ago": { "v": ["Alguns segundos atrás"] }, "sec. ago": { "v": ["seg. atrás"] }, "seconds ago": { "v": ["segundos atrás"] } } }, { "l": "pt_PT", "t": { "a few seconds ago": { "v": ["alguns segundos atrás"] }, "sec. ago": { "v": ["seg. atrás"] }, "seconds ago": { "v": ["segundos atrás"] } } }, { "l": "ro", "t": { "a few seconds ago": { "v": ["acum câteva secunde"] }, "sec. ago": { "v": ["sec. în urmă"] }, "seconds ago": { "v": ["secunde în urmă"] } } }, { "l": "ru", "t": { "a few seconds ago": { "v": ["несколько секунд назад"] }, "sec. ago": { "v": ["сек. назад"] }, "seconds ago": { "v": ["секунд назад"] } } }, { "l": "sc", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "si", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "sk", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "sl", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "sq", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "sr", "t": { "a few seconds ago": { "v": ["пре неколико секунди"] }, "sec. ago": { "v": ["сек. раније"] }, "seconds ago": { "v": ["секунди раније"] } } }, { "l": "sr@latin", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "sv", "t": { "a few seconds ago": { "v": ["några sekunder sedan"] }, "sec. ago": { "v": ["sek. sedan"] }, "seconds ago": { "v": ["sekunder sedan"] } } }, { "l": "sw", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "ta", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "th", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "tk", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "tr", "t": { "a few seconds ago": { "v": ["birkaç saniye önce"] }, "sec. ago": { "v": ["sn. önce"] }, "seconds ago": { "v": ["saniye önce"] } } }, { "l": "ug", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "uk", "t": { "a few seconds ago": { "v": ["декілька секунд тому"] }, "sec. ago": { "v": ["с тому"] }, "seconds ago": { "v": ["с тому"] } } }, { "l": "ur_PK", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "uz", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "vi", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "zh_CN", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }, { "l": "zh_HK", "t": { "a few seconds ago": { "v": ["幾秒前"] }, "sec. ago": { "v": ["秒前"] }, "seconds ago": { "v": ["秒前"] } } }, { "l": "zh_TW", "t": { "a few seconds ago": { "v": ["幾秒前"] }, "sec. ago": { "v": ["秒前"] }, "seconds ago": { "v": ["秒前"] } } }, { "l": "zu_ZA", "t": { "a few seconds ago": { "v": [""] }, "sec. ago": { "v": [""] }, "seconds ago": { "v": [""] } } }];
const t3 = [{ "l": "af", "t": {} }, { "l": "ar", "t": { "Acapulco": { "v": ["بازلائي مطفي"] }, "Blue Violet": { "v": ["بنفسجي مشعشع"] }, "Boston Blue": { "v": ["سماوي مطفي"] }, "Deluge": { "v": ["بنفسجي مطفي"] }, "Feldspar": { "v": ["وردي صخري"] }, "Gold": { "v": ["ذهبي"] }, "Mariner": { "v": ["أزرق بحري"] }, "Nextcloud blue": { "v": ["أزرق نكست كلاود"] }, "Olivine": { "v": ["زيتي"] }, "Purple": { "v": ["بنفسجي"] }, "Rosy brown": { "v": ["بُنِّي زهري"] }, "Whiskey": { "v": ["نبيذي"] } } }, { "l": "ast", "t": { "Acapulco": { "v": ["Acapulcu"] }, "Blue Violet": { "v": ["Viola azulao"] }, "Boston Blue": { "v": ["Azul Boston"] }, "Deluge": { "v": ["Deluge"] }, "Feldspar": { "v": ["Feldspar"] }, "Gold": { "v": ["Oru"] }, "Mariner": { "v": ["Marineru"] }, "Nextcloud blue": { "v": ["Nextcloud azul"] }, "Olivine": { "v": ["Olivina"] }, "Purple": { "v": ["Moráu"] }, "Rosy brown": { "v": ["Marrón arrosao"] }, "Whiskey": { "v": ["Whiskey"] } } }, { "l": "az", "t": {} }, { "l": "be", "t": {} }, { "l": "bg", "t": {} }, { "l": "bn_BD", "t": {} }, { "l": "br", "t": {} }, { "l": "bs", "t": {} }, { "l": "ca", "t": {} }, { "l": "cs", "t": { "Acapulco": { "v": ["Akapulko"] }, "Blue Violet": { "v": ["Modrofialová"] }, "Boston Blue": { "v": ["Bostonská modrá"] }, "Deluge": { "v": ["Deluge"] }, "Feldspar": { "v": ["Živicová"] }, "Gold": { "v": ["Zlatá"] }, "Mariner": { "v": ["Námořnická"] }, "Nextcloud blue": { "v": ["Nextcloud modrá"] }, "Olivine": { "v": ["Olivínová"] }, "Purple": { "v": ["Fialová"] }, "Rosy brown": { "v": ["Růžovohnědá"] }, "Whiskey": { "v": ["Whisky"] } } }, { "l": "cs_CZ", "t": { "Acapulco": { "v": ["Akapulko"] }, "Blue Violet": { "v": ["Modrofialová"] }, "Boston Blue": { "v": ["Bostonská modrá"] }, "Deluge": { "v": ["Deluge"] }, "Feldspar": { "v": ["Živicová"] }, "Gold": { "v": ["Zlatá"] }, "Mariner": { "v": ["Námořnická"] }, "Nextcloud blue": { "v": ["Nextcloud modrá"] }, "Olivine": { "v": ["Olivínová"] }, "Purple": { "v": ["Fialová"] }, "Rosy brown": { "v": ["Růžovohnědá"] }, "Whiskey": { "v": ["Whisky"] } } }, { "l": "cy_GB", "t": {} }, { "l": "da", "t": { "Acapulco": { "v": ["Acapulco"] }, "Blue Violet": { "v": ["Blue Violet"] }, "Boston Blue": { "v": ["Boston Blue"] }, "Deluge": { "v": ["Deluge"] }, "Feldspar": { "v": ["Feldspar"] }, "Gold": { "v": ["Guld"] }, "Mariner": { "v": ["Mariner"] }, "Nextcloud blue": { "v": ["Nextcloud blue"] }, "Olivine": { "v": ["Olivine"] }, "Purple": { "v": ["Lilla"] }, "Rosy brown": { "v": ["Rosy brown"] }, "Whiskey": { "v": ["Whiskey"] } } }, { "l": "de", "t": { "Acapulco": { "v": ["Acapulco"] }, "Blue Violet": { "v": ["Blau Violett"] }, "Boston Blue": { "v": ["Boston-Blau"] }, "Deluge": { "v": ["Sintflut"] }, "Feldspar": { "v": ["Feldspat"] }, "Gold": { "v": ["Gold"] }, "Mariner": { "v": ["Seemann"] }, "Nextcloud blue": { "v": ["Nextcloud Blau"] }, "Olivine": { "v": ["Olivin"] }, "Purple": { "v": ["Lila"] }, "Rosy brown": { "v": ["Rosiges Braun"] }, "Whiskey": { "v": ["Whiskey"] } } }, { "l": "de_DE", "t": { "Acapulco": { "v": ["Acapulco"] }, "Blue Violet": { "v": ["Blau Violett"] }, "Boston Blue": { "v": ["Boston-Blau"] }, "Deluge": { "v": ["Sintflut"] }, "Feldspar": { "v": ["Feldspat"] }, "Gold": { "v": ["Gold"] }, "Mariner": { "v": ["Seemann"] }, "Nextcloud blue": { "v": ["Nextcloud Blau"] }, "Olivine": { "v": ["Olivin"] }, "Purple": { "v": ["Lila"] }, "Rosy brown": { "v": ["Rosiges Braun"] }, "Whiskey": { "v": ["Whiskey"] } } }, { "l": "el", "t": {} }, { "l": "en_GB", "t": { "Acapulco": { "v": ["Acapulco"] }, "Blue Violet": { "v": ["Blue Violet"] }, "Boston Blue": { "v": ["Boston Blue"] }, "Deluge": { "v": ["Deluge"] }, "Feldspar": { "v": ["Feldspar"] }, "Gold": { "v": ["Gold"] }, "Mariner": { "v": ["Mariner"] }, "Nextcloud blue": { "v": ["Nextcloud blue"] }, "Olivine": { "v": ["Olivine"] }, "Purple": { "v": ["Purple"] }, "Rosy brown": { "v": ["Rosy brown"] }, "Whiskey": { "v": ["Whiskey"] } } }, { "l": "eo", "t": {} }, { "l": "es", "t": { "Acapulco": { "v": ["Acapulco"] }, "Blue Violet": { "v": ["Violeta Azul"] }, "Boston Blue": { "v": ["Azul Boston"] }, "Deluge": { "v": ["Diluvio"] }, "Feldspar": { "v": ["Feldespato"] }, "Gold": { "v": ["Oro"] }, "Mariner": { "v": ["Marinero"] }, "Nextcloud blue": { "v": ["Azul Nextcloud"] }, "Olivine": { "v": ["Olivino"] }, "Purple": { "v": ["Púrpura"] }, "Rosy brown": { "v": ["Marrón rosáceo"] }, "Whiskey": { "v": ["Whiskey"] } } }, { "l": "es_419", "t": {} }, { "l": "es_AR", "t": { "Acapulco": { "v": ["Acapulco"] }, "Blue Violet": { "v": ["Violeta Azul"] }, "Boston Blue": { "v": ["Azul Boston"] }, "Deluge": { "v": ["Diluvio"] }, "Feldspar": { "v": ["Feldespato"] }, "Gold": { "v": ["Oro"] }, "Mariner": { "v": ["Marinero"] }, "Nextcloud blue": { "v": ["Azul Nextcloud"] }, "Olivine": { "v": ["Olivino"] }, "Purple": { "v": ["Púrpura"] }, "Rosy brown": { "v": ["Marrón rosáceo"] }, "Whiskey": { "v": ["Whiskey"] } } }, { "l": "es_CL", "t": {} }, { "l": "es_CO", "t": {} }, { "l": "es_CR", "t": {} }, { "l": "es_DO", "t": {} }, { "l": "es_EC", "t": {} }, { "l": "es_GT", "t": {} }, { "l": "es_HN", "t": {} }, { "l": "es_MX", "t": { "Acapulco": { "v": ["Acapulco"] }, "Blue Violet": { "v": ["Violeta Azul"] }, "Boston Blue": { "v": ["Azul Boston"] }, "Deluge": { "v": ["Diluvio"] }, "Feldspar": { "v": ["Feldespato"] }, "Gold": { "v": ["Oro"] }, "Mariner": { "v": ["Marinero"] }, "Nextcloud blue": { "v": ["Azul Nextcloud"] }, "Olivine": { "v": ["Olivino"] }, "Purple": { "v": ["Púrpura"] }, "Rosy brown": { "v": ["Marrón rosáceo"] }, "Whiskey": { "v": ["Whiskey"] } } }, { "l": "es_NI", "t": {} }, { "l": "es_PA", "t": {} }, { "l": "es_PE", "t": {} }, { "l": "es_PR", "t": {} }, { "l": "es_PY", "t": {} }, { "l": "es_SV", "t": {} }, { "l": "es_UY", "t": {} }, { "l": "et_EE", "t": {} }, { "l": "eu", "t": {} }, { "l": "fa", "t": {} }, { "l": "fi", "t": {} }, { "l": "fo", "t": {} }, { "l": "fr", "t": { "Gold": { "v": ["Doré"] }, "Nextcloud blue": { "v": ["Bleu Nextcloud"] }, "Purple": { "v": ["Violet"] } } }, { "l": "ga", "t": { "Acapulco": { "v": ["Acapulco"] }, "Blue Violet": { "v": ["Gorm Violet"] }, "Boston Blue": { "v": ["Bostún Gorm"] }, "Deluge": { "v": ["Díle"] }, "Feldspar": { "v": ["Feldspar"] }, "Gold": { "v": ["Óir"] }, "Mariner": { "v": ["Mairnéalach"] }, "Nextcloud blue": { "v": ["Nextcloud gorm"] }, "Olivine": { "v": ["Olaivín"] }, "Purple": { "v": ["Corcra"] }, "Rosy brown": { "v": ["Rosach donn"] }, "Whiskey": { "v": ["Fuisce"] } } }, { "l": "gd", "t": {} }, { "l": "gl", "t": { "Acapulco": { "v": ["Acapulco"] }, "Blue Violet": { "v": ["Azul violeta"] }, "Boston Blue": { "v": ["Azul Boston"] }, "Deluge": { "v": ["Diluvio"] }, "Feldspar": { "v": ["Feldespato"] }, "Gold": { "v": ["Ouro"] }, "Mariner": { "v": ["Marino"] }, "Nextcloud blue": { "v": ["Nextcloud azul"] }, "Olivine": { "v": ["Olivina"] }, "Purple": { "v": ["Púrpura"] }, "Rosy brown": { "v": ["Pardo rosado"] }, "Whiskey": { "v": ["Whisky"] } } }, { "l": "he", "t": {} }, { "l": "hi_IN", "t": {} }, { "l": "hr", "t": {} }, { "l": "hsb", "t": {} }, { "l": "hu", "t": {} }, { "l": "hy", "t": {} }, { "l": "ia", "t": {} }, { "l": "id", "t": { "Gold": { "v": ["Emas"] }, "Nextcloud blue": { "v": ["Biru Nextcloud"] }, "Purple": { "v": ["Ungu"] } } }, { "l": "ig", "t": {} }, { "l": "is", "t": { "Gold": { "v": ["Gull"] }, "Nextcloud blue": { "v": ["Nextcloud blátt"] }, "Purple": { "v": ["Purpurablátt"] } } }, { "l": "it", "t": { "Gold": { "v": ["Oro"] }, "Nextcloud blue": { "v": ["Nextcloud blue"] }, "Purple": { "v": ["Viola"] } } }, { "l": "ja", "t": { "Acapulco": { "v": ["アカプルコ"] }, "Blue Violet": { "v": ["ブルーバイオレット"] }, "Boston Blue": { "v": ["ボストンブルー"] }, "Deluge": { "v": ["豪雨"] }, "Feldspar": { "v": ["長石"] }, "Gold": { "v": ["黄金"] }, "Mariner": { "v": ["船乗り"] }, "Nextcloud blue": { "v": ["ネクストクラウド・ブルー"] }, "Olivine": { "v": ["カンラン石"] }, "Purple": { "v": ["紫色"] }, "Rosy brown": { "v": ["バラ色"] }, "Whiskey": { "v": ["ウイスキー"] } } }, { "l": "ja_JP", "t": { "Acapulco": { "v": ["アカプルコ"] }, "Blue Violet": { "v": ["ブルーバイオレット"] }, "Boston Blue": { "v": ["ボストンブルー"] }, "Deluge": { "v": ["豪雨"] }, "Feldspar": { "v": ["長石"] }, "Gold": { "v": ["黄金"] }, "Mariner": { "v": ["船乗り"] }, "Nextcloud blue": { "v": ["ネクストクラウド・ブルー"] }, "Olivine": { "v": ["カンラン石"] }, "Purple": { "v": ["紫色"] }, "Rosy brown": { "v": ["バラ色"] }, "Whiskey": { "v": ["ウイスキー"] } } }, { "l": "ka", "t": {} }, { "l": "ka_GE", "t": {} }, { "l": "kab", "t": {} }, { "l": "kk", "t": {} }, { "l": "km", "t": {} }, { "l": "kn", "t": {} }, { "l": "ko", "t": {} }, { "l": "la", "t": {} }, { "l": "lb", "t": {} }, { "l": "lo", "t": {} }, { "l": "lt_LT", "t": {} }, { "l": "lv", "t": {} }, { "l": "mk", "t": {} }, { "l": "mn", "t": {} }, { "l": "mr", "t": {} }, { "l": "ms_MY", "t": {} }, { "l": "my", "t": {} }, { "l": "nb", "t": { "Acapulco": { "v": ["Acapulco"] }, "Blue Violet": { "v": ["Blå fiolett"] }, "Boston Blue": { "v": ["Boston blå"] }, "Deluge": { "v": ["Syndflod"] }, "Feldspar": { "v": ["Feltspat"] }, "Gold": { "v": ["Gull"] }, "Mariner": { "v": ["Mariner"] }, "Nextcloud blue": { "v": ["Nextcloud-blå"] }, "Olivine": { "v": ["Olivin"] }, "Purple": { "v": ["Lilla"] }, "Rosy brown": { "v": ["Rosenrød brun"] }, "Whiskey": { "v": ["Whiskey"] } } }, { "l": "ne", "t": {} }, { "l": "nl", "t": { "Acapulco": { "v": ["Acapulco"] }, "Blue Violet": { "v": ["Blauw Paars"] }, "Boston Blue": { "v": ["Boston Blauw"] }, "Deluge": { "v": ["Deluge"] }, "Feldspar": { "v": ["Veldspaat"] }, "Gold": { "v": ["Goud"] }, "Mariner": { "v": ["Marine blauw"] }, "Nextcloud blue": { "v": ["Nextcloud blauw"] }, "Olivine": { "v": ["Olivijn"] }, "Purple": { "v": ["Paars"] }, "Rosy brown": { "v": ["Rozig bruin"] }, "Whiskey": { "v": ["Whiskey"] } } }, { "l": "nn_NO", "t": {} }, { "l": "oc", "t": {} }, { "l": "pl", "t": { "Acapulco": { "v": ["Acapulco"] }, "Blue Violet": { "v": ["Niebieski fiolet"] }, "Boston Blue": { "v": ["Błękit Bostonu"] }, "Deluge": { "v": ["Potop"] }, "Feldspar": { "v": ["Skaleń"] }, "Gold": { "v": ["Złote"] }, "Mariner": { "v": ["Marynarz"] }, "Nextcloud blue": { "v": ["Niebieskie Nextcloud"] }, "Olivine": { "v": ["Oliwin"] }, "Purple": { "v": ["Fioletowy"] }, "Rosy brown": { "v": ["Różowy brąz"] }, "Whiskey": { "v": ["Whisky"] } } }, { "l": "ps", "t": {} }, { "l": "pt_BR", "t": { "Acapulco": { "v": ["Acapulco"] }, "Blue Violet": { "v": ["Violeta Azul"] }, "Boston Blue": { "v": ["Violeta Azul"] }, "Deluge": { "v": ["Dilúvio"] }, "Feldspar": { "v": ["Feldspato"] }, "Gold": { "v": ["Ouro"] }, "Mariner": { "v": ["Marinheiro"] }, "Nextcloud blue": { "v": ["Nextcloud azul"] }, "Olivine": { "v": ["Olivina"] }, "Purple": { "v": ["Roxo"] }, "Rosy brown": { "v": ["Castanho rosado"] }, "Whiskey": { "v": ["Uísque"] } } }, { "l": "pt_PT", "t": {} }, { "l": "ro", "t": { "Gold": { "v": ["Aur"] }, "Nextcloud blue": { "v": ["Nextcloud albastru"] }, "Purple": { "v": ["Purpuriu"] } } }, { "l": "ru", "t": {} }, { "l": "sc", "t": {} }, { "l": "si", "t": {} }, { "l": "sk", "t": {} }, { "l": "sl", "t": {} }, { "l": "sq", "t": {} }, { "l": "sr", "t": { "Acapulco": { "v": ["Акапулко"] }, "Blue Violet": { "v": ["Плаво љубичаста"] }, "Boston Blue": { "v": ["Бостон плава"] }, "Deluge": { "v": ["Поплава"] }, "Feldspar": { "v": ["Фелдспар"] }, "Gold": { "v": ["Злато"] }, "Mariner": { "v": ["Морнар"] }, "Nextcloud blue": { "v": ["Nextcloud плава"] }, "Olivine": { "v": ["Маслинаста"] }, "Purple": { "v": ["Пурпурна"] }, "Rosy brown": { "v": ["Роси браон"] }, "Whiskey": { "v": ["Виски"] } } }, { "l": "sr@latin", "t": {} }, { "l": "sv", "t": { "Acapulco": { "v": ["Acapulco"] }, "Blue Violet": { "v": ["Blåviolett"] }, "Boston Blue": { "v": ["Bostonblå"] }, "Deluge": { "v": ["Skyfallsblå"] }, "Feldspar": { "v": ["Feldspat"] }, "Gold": { "v": ["Guld"] }, "Mariner": { "v": ["Marinblå"] }, "Nextcloud blue": { "v": ["Nextcloud-blå"] }, "Olivine": { "v": ["Olivin"] }, "Purple": { "v": ["Lila"] }, "Rosy brown": { "v": ["Rosabrun"] }, "Whiskey": { "v": ["Whisky"] } } }, { "l": "sw", "t": {} }, { "l": "ta", "t": {} }, { "l": "th", "t": {} }, { "l": "tk", "t": {} }, { "l": "tr", "t": { "Acapulco": { "v": ["Akapulko"] }, "Blue Violet": { "v": ["Mavi mor"] }, "Boston Blue": { "v": ["Boston mavisi"] }, "Deluge": { "v": ["Sel"] }, "Feldspar": { "v": ["Feldispat"] }, "Gold": { "v": ["Altın"] }, "Mariner": { "v": ["Denizci"] }, "Nextcloud blue": { "v": ["Nextcloud mavi"] }, "Olivine": { "v": ["Zeytinlik"] }, "Purple": { "v": ["Mor"] }, "Rosy brown": { "v": ["Kırmızımsı kahverengi"] }, "Whiskey": { "v": ["Viski"] } } }, { "l": "ug", "t": {} }, { "l": "uk", "t": { "Acapulco": { "v": ["Акапулько"] }, "Blue Violet": { "v": ["Блакитна фіалка"] }, "Boston Blue": { "v": ["Бостонський синій"] }, "Deluge": { "v": ["Злива"] }, "Feldspar": { "v": ["Польові шпати"] }, "Gold": { "v": ["Золотий"] }, "Mariner": { "v": ["Морський"] }, "Nextcloud blue": { "v": ["Блакитний Nextcloud"] }, "Olivine": { "v": ["Олива"] }, "Purple": { "v": ["Фіолетовий"] }, "Rosy brown": { "v": ["Темно-рожевий"] }, "Whiskey": { "v": ["Кола"] } } }, { "l": "ur_PK", "t": {} }, { "l": "uz", "t": {} }, { "l": "vi", "t": {} }, { "l": "zh_CN", "t": {} }, { "l": "zh_HK", "t": {} }, { "l": "zh_TW", "t": {} }, { "l": "zu_ZA", "t": {} }];
const t4 = [{ "l": "af", "t": { "Actions": { "v": [""] } } }, { "l": "ar", "t": { "Actions": { "v": ["إجراءات"] } } }, { "l": "ast", "t": { "Actions": { "v": ["Aiciones"] } } }, { "l": "az", "t": { "Actions": { "v": [""] } } }, { "l": "be", "t": { "Actions": { "v": [""] } } }, { "l": "bg", "t": { "Actions": { "v": [""] } } }, { "l": "bn_BD", "t": { "Actions": { "v": [""] } } }, { "l": "br", "t": { "Actions": { "v": ["Oberioù"] } } }, { "l": "bs", "t": { "Actions": { "v": [""] } } }, { "l": "ca", "t": { "Actions": { "v": ["Accions"] } } }, { "l": "cs", "t": { "Actions": { "v": ["Akce"] } } }, { "l": "cs_CZ", "t": { "Actions": { "v": ["Akce"] } } }, { "l": "cy_GB", "t": { "Actions": { "v": [""] } } }, { "l": "da", "t": { "Actions": { "v": ["Handlinger"] } } }, { "l": "de", "t": { "Actions": { "v": ["Aktionen"] } } }, { "l": "de_DE", "t": { "Actions": { "v": ["Aktionen"] } } }, { "l": "el", "t": { "Actions": { "v": ["Ενέργειες"] } } }, { "l": "en_GB", "t": { "Actions": { "v": ["Actions"] } } }, { "l": "eo", "t": { "Actions": { "v": ["Agoj"] } } }, { "l": "es", "t": { "Actions": { "v": ["Acciones"] } } }, { "l": "es_419", "t": { "Actions": { "v": [""] } } }, { "l": "es_AR", "t": { "Actions": { "v": ["Acciones"] } } }, { "l": "es_CL", "t": { "Actions": { "v": [""] } } }, { "l": "es_CO", "t": { "Actions": { "v": [""] } } }, { "l": "es_CR", "t": { "Actions": { "v": [""] } } }, { "l": "es_DO", "t": { "Actions": { "v": [""] } } }, { "l": "es_EC", "t": { "Actions": { "v": ["Acciones"] } } }, { "l": "es_GT", "t": { "Actions": { "v": [""] } } }, { "l": "es_HN", "t": { "Actions": { "v": [""] } } }, { "l": "es_MX", "t": { "Actions": { "v": ["Acciones"] } } }, { "l": "es_NI", "t": { "Actions": { "v": [""] } } }, { "l": "es_PA", "t": { "Actions": { "v": [""] } } }, { "l": "es_PE", "t": { "Actions": { "v": [""] } } }, { "l": "es_PR", "t": { "Actions": { "v": [""] } } }, { "l": "es_PY", "t": { "Actions": { "v": [""] } } }, { "l": "es_SV", "t": { "Actions": { "v": [""] } } }, { "l": "es_UY", "t": { "Actions": { "v": [""] } } }, { "l": "et_EE", "t": { "Actions": { "v": [""] } } }, { "l": "eu", "t": { "Actions": { "v": ["Ekintzak"] } } }, { "l": "fa", "t": { "Actions": { "v": [""] } } }, { "l": "fi", "t": { "Actions": { "v": ["Toiminnot"] } } }, { "l": "fo", "t": { "Actions": { "v": [""] } } }, { "l": "fr", "t": { "Actions": { "v": ["Actions"] } } }, { "l": "ga", "t": { "Actions": { "v": ["Gníomhartha"] } } }, { "l": "gd", "t": { "Actions": { "v": [""] } } }, { "l": "gl", "t": { "Actions": { "v": ["Accións"] } } }, { "l": "he", "t": { "Actions": { "v": ["פעולות"] } } }, { "l": "hi_IN", "t": { "Actions": { "v": [""] } } }, { "l": "hr", "t": { "Actions": { "v": [""] } } }, { "l": "hsb", "t": { "Actions": { "v": [""] } } }, { "l": "hu", "t": { "Actions": { "v": ["Műveletek"] } } }, { "l": "hy", "t": { "Actions": { "v": [""] } } }, { "l": "ia", "t": { "Actions": { "v": [""] } } }, { "l": "id", "t": { "Actions": { "v": ["Tindakan"] } } }, { "l": "ig", "t": { "Actions": { "v": [""] } } }, { "l": "is", "t": { "Actions": { "v": ["Aðgerðir"] } } }, { "l": "it", "t": { "Actions": { "v": ["Azioni"] } } }, { "l": "ja", "t": { "Actions": { "v": ["操作"] } } }, { "l": "ja_JP", "t": { "Actions": { "v": ["操作"] } } }, { "l": "ka", "t": { "Actions": { "v": [""] } } }, { "l": "ka_GE", "t": { "Actions": { "v": [""] } } }, { "l": "kab", "t": { "Actions": { "v": [""] } } }, { "l": "kk", "t": { "Actions": { "v": [""] } } }, { "l": "km", "t": { "Actions": { "v": [""] } } }, { "l": "kn", "t": { "Actions": { "v": [""] } } }, { "l": "ko", "t": { "Actions": { "v": [""] } } }, { "l": "la", "t": { "Actions": { "v": [""] } } }, { "l": "lb", "t": { "Actions": { "v": [""] } } }, { "l": "lo", "t": { "Actions": { "v": [""] } } }, { "l": "lt_LT", "t": { "Actions": { "v": ["Veiksmai"] } } }, { "l": "lv", "t": { "Actions": { "v": [""] } } }, { "l": "mk", "t": { "Actions": { "v": ["Акции"] } } }, { "l": "mn", "t": { "Actions": { "v": [""] } } }, { "l": "mr", "t": { "Actions": { "v": [""] } } }, { "l": "ms_MY", "t": { "Actions": { "v": [""] } } }, { "l": "my", "t": { "Actions": { "v": ["လုပ်ဆောင်ချက်များ"] } } }, { "l": "nb", "t": { "Actions": { "v": ["Handlinger"] } } }, { "l": "ne", "t": { "Actions": { "v": [""] } } }, { "l": "nl", "t": { "Actions": { "v": ["Acties"] } } }, { "l": "nn_NO", "t": { "Actions": { "v": [""] } } }, { "l": "oc", "t": { "Actions": { "v": ["Accions"] } } }, { "l": "pl", "t": { "Actions": { "v": ["Działania"] } } }, { "l": "ps", "t": { "Actions": { "v": [""] } } }, { "l": "pt_BR", "t": { "Actions": { "v": ["Ações"] } } }, { "l": "pt_PT", "t": { "Actions": { "v": ["Ações"] } } }, { "l": "ro", "t": { "Actions": { "v": ["Acțiuni"] } } }, { "l": "ru", "t": { "Actions": { "v": ["Действия "] } } }, { "l": "sc", "t": { "Actions": { "v": [""] } } }, { "l": "si", "t": { "Actions": { "v": [""] } } }, { "l": "sk", "t": { "Actions": { "v": ["Akcie"] } } }, { "l": "sl", "t": { "Actions": { "v": ["Dejanja"] } } }, { "l": "sq", "t": { "Actions": { "v": [""] } } }, { "l": "sr", "t": { "Actions": { "v": ["Радње"] } } }, { "l": "sr@latin", "t": { "Actions": { "v": [""] } } }, { "l": "sv", "t": { "Actions": { "v": ["Åtgärder"] } } }, { "l": "sw", "t": { "Actions": { "v": [""] } } }, { "l": "ta", "t": { "Actions": { "v": [""] } } }, { "l": "th", "t": { "Actions": { "v": [""] } } }, { "l": "tk", "t": { "Actions": { "v": [""] } } }, { "l": "tr", "t": { "Actions": { "v": ["İşlemler"] } } }, { "l": "ug", "t": { "Actions": { "v": [""] } } }, { "l": "uk", "t": { "Actions": { "v": ["Дії"] } } }, { "l": "ur_PK", "t": { "Actions": { "v": [""] } } }, { "l": "uz", "t": { "Actions": { "v": [""] } } }, { "l": "vi", "t": { "Actions": { "v": [""] } } }, { "l": "zh_CN", "t": { "Actions": { "v": ["行为"] } } }, { "l": "zh_HK", "t": { "Actions": { "v": ["動作"] } } }, { "l": "zh_TW", "t": { "Actions": { "v": ["動作"] } } }, { "l": "zu_ZA", "t": { "Actions": { "v": [""] } } }];
const t5 = [{ "l": "af", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "ar", "t": { 'Actions for item with name "{name}"': { "v": ['إجراءات على العنصر المُسمَّى "{name}"'] } } }, { "l": "ast", "t": { 'Actions for item with name "{name}"': { "v": ["Aiciones pal elementu col nome «{name}»"] } } }, { "l": "az", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "be", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "bg", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "bn_BD", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "br", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "bs", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "ca", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "cs", "t": { 'Actions for item with name "{name}"': { "v": ["Akce pro položku s názvem „{name}“"] } } }, { "l": "cs_CZ", "t": { 'Actions for item with name "{name}"': { "v": ["Akce pro položku s názvem „{name}“"] } } }, { "l": "cy_GB", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "da", "t": { 'Actions for item with name "{name}"': { "v": ['Handlinger for element med navnet "{name}"'] } } }, { "l": "de", "t": { 'Actions for item with name "{name}"': { "v": ['Aktionen für das Element "{name}“'] } } }, { "l": "de_DE", "t": { 'Actions for item with name "{name}"': { "v": ['Aktionen für Element mit dem Namen "{name}“'] } } }, { "l": "el", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "en_GB", "t": { 'Actions for item with name "{name}"': { "v": ['Actions for item with name "{name}"'] } } }, { "l": "eo", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "es", "t": { 'Actions for item with name "{name}"': { "v": ['Acciones para el ítem con nombre "{name}"'] } } }, { "l": "es_419", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "es_AR", "t": { 'Actions for item with name "{name}"': { "v": ['Acciones para el elemento con nombre "{name}"'] } } }, { "l": "es_CL", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "es_CO", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "es_CR", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "es_DO", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "es_EC", "t": { 'Actions for item with name "{name}"': { "v": ['Acciones para el elemento con nombre "{name}"'] } } }, { "l": "es_GT", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "es_HN", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "es_MX", "t": { 'Actions for item with name "{name}"': { "v": ['Acciones para el elemento con nombre "{name}"'] } } }, { "l": "es_NI", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "es_PA", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "es_PE", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "es_PR", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "es_PY", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "es_SV", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "es_UY", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "et_EE", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "eu", "t": { 'Actions for item with name "{name}"': { "v": ['"{name}" izeneko elementuaren ekintzak'] } } }, { "l": "fa", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "fi", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "fo", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "fr", "t": { 'Actions for item with name "{name}"': { "v": [`Actions de l'entrée avec le nom "{name}"`] } } }, { "l": "ga", "t": { 'Actions for item with name "{name}"': { "v": ['Gníomhartha le haghaidh míre leis an ainm "{name}"'] } } }, { "l": "gd", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "gl", "t": { 'Actions for item with name "{name}"': { "v": ["Accións para o elemento co nome «{name}»"] } } }, { "l": "he", "t": { 'Actions for item with name "{name}"': { "v": ["פעולות לפריט בשם „{name}”"] } } }, { "l": "hi_IN", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "hr", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "hsb", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "hu", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "hy", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "ia", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "id", "t": { 'Actions for item with name "{name}"': { "v": ['Tindakan untuk item dengan nama "{name}"'] } } }, { "l": "ig", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "is", "t": { 'Actions for item with name "{name}"': { "v": ['Aðgerð fyrir atriði með heitið "{name}"'] } } }, { "l": "it", "t": { 'Actions for item with name "{name}"': { "v": [`Azioni per l'elemento con il nome "{nome}"`] } } }, { "l": "ja", "t": { 'Actions for item with name "{name}"': { "v": ['名前 "{name}" を持つアイテムのアクション'] } } }, { "l": "ja_JP", "t": { 'Actions for item with name "{name}"': { "v": ['名前 "{name}" を持つアイテムのアクション'] } } }, { "l": "ka", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "ka_GE", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "kab", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "kk", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "km", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "kn", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "ko", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "la", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "lb", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "lo", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "lt_LT", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "lv", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "mk", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "mn", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "mr", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "ms_MY", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "my", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "nb", "t": { 'Actions for item with name "{name}"': { "v": ['Handlinger for element med navnet "{name}"'] } } }, { "l": "ne", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "nl", "t": { 'Actions for item with name "{name}"': { "v": ['Actie voor item met naam "{name}"'] } } }, { "l": "nn_NO", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "oc", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "pl", "t": { 'Actions for item with name "{name}"': { "v": ['Akcje dla elementu o nazwie "{name}"'] } } }, { "l": "ps", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "pt_BR", "t": { 'Actions for item with name "{name}"': { "v": ['Ações para item com nome "{name}"'] } } }, { "l": "pt_PT", "t": { 'Actions for item with name "{name}"': { "v": ['Ações para objeto com o nome "[name]"'] } } }, { "l": "ro", "t": { 'Actions for item with name "{name}"': { "v": ['Acțiuni pentru elementul cu numele "{name}"'] } } }, { "l": "ru", "t": { 'Actions for item with name "{name}"': { "v": ['Действия для элемента с названием "{name}"'] } } }, { "l": "sc", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "si", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "sk", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "sl", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "sq", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "sr", "t": { 'Actions for item with name "{name}"': { "v": ["Радње за ставку под називом „{name}”"] } } }, { "l": "sr@latin", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "sv", "t": { 'Actions for item with name "{name}"': { "v": ['Åtgärder för objekt med namn "{name}"'] } } }, { "l": "sw", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "ta", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "th", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "tk", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "tr", "t": { 'Actions for item with name "{name}"': { "v": ["{name} adındaki öge için işlemler"] } } }, { "l": "ug", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "uk", "t": { 'Actions for item with name "{name}"': { "v": [`Дії для об'єкту "{name}"`] } } }, { "l": "ur_PK", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "uz", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "vi", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "zh_CN", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }, { "l": "zh_HK", "t": { 'Actions for item with name "{name}"': { "v": ["名稱為「{name}」項目的操作"] } } }, { "l": "zh_TW", "t": { 'Actions for item with name "{name}"': { "v": ["名稱為「{name}」項目的動作"] } } }, { "l": "zu_ZA", "t": { 'Actions for item with name "{name}"': { "v": [""] } } }];
const t6 = [{ "l": "af", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "ar", "t": { "Activities": { "v": ["سجل الحركات"] }, "Animals & Nature": { "v": ["الحيوانات والطبيعة"] }, "Custom": { "v": ["مُخصَّص"] }, "Dark skin tone": { "v": ["أسمر البُشرة"] }, "Emoji picker": { "v": ["لاقط الإيموجي"] }, "Flags": { "v": ["الأعلام"] }, "Food & Drink": { "v": ["الطعام والشراب"] }, "Frequently used": { "v": ["شائعة الاستعمال"] }, "Light skin tone": { "v": ["فاتح البُشرة"] }, "Medium dark skin tone": { "v": ["بُشرة متوسطة الاسمرار"] }, "Medium light skin tone": { "v": ["بُشرة متوسطة البياض"] }, "Medium skin tone": { "v": ["بُشرة وسطية اللون"] }, "Neutral skin color": { "v": ["لون بُشرة طبيعي"] }, "Objects": { "v": ["أشياء"] }, "People & Body": { "v": ["أشخاص و أجسام"] }, "Pick an emoji": { "v": ["إختَر رمز إيموجي emoji"] }, "Search emoji": { "v": ["البحث عن إيموجي emoji"] }, "Search results": { "v": ["نتائج البحث"] }, "Selected": { "v": ["مُحدّدة"] }, "Skin tone": { "v": ["لون البُشرة"] }, "Smileys & Emotion": { "v": ["وجوهٌ ضاحكة و مشاعر"] }, "Symbols": { "v": ["رموز"] }, "Travel & Places": { "v": ["سفر و أماكن"] } } }, { "l": "ast", "t": { "Activities": { "v": ["Actividaes"] }, "Animals & Nature": { "v": ["Animales y natura"] }, "Custom": { "v": ["Personalizar"] }, "Dark skin tone": { "v": ["Tonu d'aspeutu escuru"] }, "Emoji picker": { "v": ["Selector de fustaxes"] }, "Flags": { "v": ["Banderes"] }, "Food & Drink": { "v": ["Cómida y bébora"] }, "Frequently used": { "v": ["D'usu frecuente"] }, "Light skin tone": { "v": ["Tonu d'aspeutu claru"] }, "Medium dark skin tone": { "v": ["Tonu d'aspeutu medio escuru"] }, "Medium light skin tone": { "v": ["Tonu d'aspeutu medio claru"] }, "Medium skin tone": { "v": ["Tonu d'aspeutu mediu"] }, "Neutral skin color": { "v": ["Color d'aspeutu neutral"] }, "Objects": { "v": ["Oxetos"] }, "People & Body": { "v": ["Persones y cuerpu"] }, "Pick an emoji": { "v": ["Escueyi un fustaxe"] }, "Search emoji": { "v": ["Buscar nos fustaxes"] }, "Search results": { "v": ["Resultaos de la busca"] }, "Selected": { "v": ["Na seleición"] }, "Skin tone": { "v": ["Tonu d'aspeutu"] }, "Smileys & Emotion": { "v": ["Sorrises y emociones"] }, "Symbols": { "v": ["Símbolos"] }, "Travel & Places": { "v": ["Viaxes y llugares"] } } }, { "l": "az", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "be", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "bg", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "bn_BD", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "br", "t": { "Activities": { "v": ["Oberiantizoù"] }, "Animals & Nature": { "v": ["Loened & Natur"] }, "Custom": { "v": ["Personelañ"] }, "Flags": { "v": ["Bannieloù"] }, "Food & Drink": { "v": ["Boued & Evajoù"] }, "Frequently used": { "v": ["Implijet alies"] }, "Objects": { "v": ["Traoù"] }, "People & Body": { "v": ["Tud & Korf"] }, "Pick an emoji": { "v": ["Choaz un emoji"] }, "Search emoji": { "v": [""] }, "Search results": { "v": ["Disoc'hoù an enklask"] }, "Smileys & Emotion": { "v": ["Smileyioù & Fromoù"] }, "Symbols": { "v": ["Arouezioù"] }, "Travel & Places": { "v": ["Beaj & Lec'hioù"] } } }, { "l": "bs", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "ca", "t": { "Activities": { "v": ["Activitats"] }, "Animals & Nature": { "v": ["Animals i natura"] }, "Custom": { "v": ["Personalitzat"] }, "Flags": { "v": ["Marques"] }, "Food & Drink": { "v": ["Menjar i begudes"] }, "Frequently used": { "v": ["Utilitzats recentment"] }, "Objects": { "v": ["Objectes"] }, "People & Body": { "v": ["Persones i cos"] }, "Pick an emoji": { "v": ["Trieu un emoji"] }, "Search emoji": { "v": [""] }, "Search results": { "v": ["Resultats de cerca"] }, "Smileys & Emotion": { "v": ["Cares i emocions"] }, "Symbols": { "v": ["Símbols"] }, "Travel & Places": { "v": ["Viatges i llocs"] } } }, { "l": "cs", "t": { "Activities": { "v": ["Aktivity"] }, "Animals & Nature": { "v": ["Zvířata a příroda"] }, "Custom": { "v": ["Uživatelsky určené"] }, "Dark skin tone": { "v": ["Tmavý tělový tón"] }, "Emoji picker": { "v": ["Výběr emotikon"] }, "Flags": { "v": ["Příznaky"] }, "Food & Drink": { "v": ["Jídlo a pití"] }, "Frequently used": { "v": ["Často používané"] }, "Light skin tone": { "v": ["Světlý tělový tón"] }, "Medium dark skin tone": { "v": ["Středně tmavý tělový tón"] }, "Medium light skin tone": { "v": ["Středně světlý tělový tón"] }, "Medium skin tone": { "v": ["Střední tělový tón"] }, "Neutral skin color": { "v": ["Neutřální tělová barva"] }, "Objects": { "v": ["Objekty"] }, "People & Body": { "v": ["Lidé a tělo"] }, "Pick an emoji": { "v": ["Vybrat emoji"] }, "Search emoji": { "v": ["Hledat emoji"] }, "Search results": { "v": ["Výsledky hledání"] }, "Selected": { "v": ["Vybráno"] }, "Skin tone": { "v": ["Tělový tón"] }, "Smileys & Emotion": { "v": ["Úsměvy a emoce"] }, "Symbols": { "v": ["Symboly"] }, "Travel & Places": { "v": ["Cestování a místa"] } } }, { "l": "cs_CZ", "t": { "Activities": { "v": ["Aktivity"] }, "Animals & Nature": { "v": ["Zvířata a příroda"] }, "Custom": { "v": ["Uživatelsky určené"] }, "Dark skin tone": { "v": ["Tmavý tělový tón"] }, "Emoji picker": { "v": ["Výběr emotikon"] }, "Flags": { "v": ["Příznaky"] }, "Food & Drink": { "v": ["Jídlo a pití"] }, "Frequently used": { "v": ["Často používané"] }, "Light skin tone": { "v": ["Světlý tělový tón"] }, "Medium dark skin tone": { "v": ["Středně tmavý tělový tón"] }, "Medium light skin tone": { "v": ["Středně světlý tělový tón"] }, "Medium skin tone": { "v": ["Střední tělový tón"] }, "Neutral skin color": { "v": ["Neutřální tělová barva"] }, "Objects": { "v": ["Objekty"] }, "People & Body": { "v": ["Lidé a tělo"] }, "Pick an emoji": { "v": ["Vybrat emoji"] }, "Search emoji": { "v": ["Hledat emoji"] }, "Search results": { "v": ["Výsledky hledání"] }, "Selected": { "v": ["Vybráno"] }, "Skin tone": { "v": ["Tělový tón"] }, "Smileys & Emotion": { "v": ["Úsměvy a emoce"] }, "Symbols": { "v": ["Symboly"] }, "Travel & Places": { "v": ["Cestování a místa"] } } }, { "l": "cy_GB", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "da", "t": { "Activities": { "v": ["Aktiviteter"] }, "Animals & Nature": { "v": ["Dyr & Natur"] }, "Custom": { "v": ["Brugerdefineret"] }, "Dark skin tone": { "v": ["Mørk skin tone"] }, "Emoji picker": { "v": ["Emoji vælger"] }, "Flags": { "v": ["Flag"] }, "Food & Drink": { "v": ["Mad & Drikke"] }, "Frequently used": { "v": ["Ofte brugt"] }, "Light skin tone": { "v": ["Lys skin tone"] }, "Medium dark skin tone": { "v": ["Medium mørk skin tone"] }, "Medium light skin tone": { "v": ["Medium lys skin tone"] }, "Medium skin tone": { "v": ["Medium skin tone"] }, "Neutral skin color": { "v": ["Neutral skin color"] }, "Objects": { "v": ["Objekter"] }, "People & Body": { "v": ["Mennesker & Menneskekroppen"] }, "Pick an emoji": { "v": ["Vælg en emoji"] }, "Search emoji": { "v": ["Søg emoji"] }, "Search results": { "v": ["Søgeresultater"] }, "Selected": { "v": ["Valgt"] }, "Skin tone": { "v": ["Skin tone"] }, "Smileys & Emotion": { "v": ["Smileys & Emotion"] }, "Symbols": { "v": ["Symboler"] }, "Travel & Places": { "v": ["Rejser & Rejsemål"] } } }, { "l": "de", "t": { "Activities": { "v": ["Aktivitäten"] }, "Animals & Nature": { "v": ["Tiere & Natur"] }, "Custom": { "v": ["Benutzerdefiniert"] }, "Dark skin tone": { "v": ["Dunkler Hautfarbton"] }, "Emoji picker": { "v": ["Emoji-Auswahl"] }, "Flags": { "v": ["Flaggen"] }, "Food & Drink": { "v": ["Essen & Trinken"] }, "Frequently used": { "v": ["Häufig verwendet"] }, "Light skin tone": { "v": ["Heller Hautfarbton"] }, "Medium dark skin tone": { "v": ["Mitteldunkler Hautfarbton"] }, "Medium light skin tone": { "v": ["Mittelheller Hautfarbton"] }, "Medium skin tone": { "v": ["Mittlerer Hautfarbton"] }, "Neutral skin color": { "v": ["Neutraler Hautfarbton"] }, "Objects": { "v": ["Gegenstände"] }, "People & Body": { "v": ["Menschen & Körper"] }, "Pick an emoji": { "v": ["Ein Emoji auswählen"] }, "Search emoji": { "v": ["Emoji suchen"] }, "Search results": { "v": ["Suchergebnisse"] }, "Selected": { "v": ["Ausgewählt"] }, "Skin tone": { "v": ["Hautfarbton"] }, "Smileys & Emotion": { "v": ["Smileys & Emotionen"] }, "Symbols": { "v": ["Symbole"] }, "Travel & Places": { "v": ["Reisen & Orte"] } } }, { "l": "de_DE", "t": { "Activities": { "v": ["Aktivitäten"] }, "Animals & Nature": { "v": ["Tiere & Natur"] }, "Custom": { "v": ["Benutzerdefiniert"] }, "Dark skin tone": { "v": ["Dunkler Hautfarbton"] }, "Emoji picker": { "v": ["Emoji-Auswahl"] }, "Flags": { "v": ["Flaggen"] }, "Food & Drink": { "v": ["Essen & Trinken"] }, "Frequently used": { "v": ["Häufig verwendet"] }, "Light skin tone": { "v": ["Heller Hautfarbton"] }, "Medium dark skin tone": { "v": ["Mitteldunkler Hautfarbton"] }, "Medium light skin tone": { "v": ["Mittelheller Hautfarbton"] }, "Medium skin tone": { "v": ["Mittlerer Hautfarbton"] }, "Neutral skin color": { "v": ["Neutraler Hautfarbton"] }, "Objects": { "v": ["Objekte"] }, "People & Body": { "v": ["Menschen & Körper"] }, "Pick an emoji": { "v": ["Ein Emoji auswählen"] }, "Search emoji": { "v": ["Emoji suchen"] }, "Search results": { "v": ["Suchergebnisse"] }, "Selected": { "v": ["Ausgewählt"] }, "Skin tone": { "v": ["Hautfarbton"] }, "Smileys & Emotion": { "v": ["Smileys & Emotionen"] }, "Symbols": { "v": ["Symbole"] }, "Travel & Places": { "v": ["Reisen & Orte"] } } }, { "l": "el", "t": { "Activities": { "v": ["Δραστηριότητες"] }, "Animals & Nature": { "v": ["Ζώα & Φύση"] }, "Custom": { "v": ["Προσαρμογή"] }, "Flags": { "v": ["Σημαίες"] }, "Food & Drink": { "v": ["Φαγητό & Ποτό"] }, "Frequently used": { "v": ["Συχνά χρησιμοποιούμενο"] }, "Objects": { "v": ["Αντικείμενα"] }, "People & Body": { "v": ["Άνθρωποι & Σώμα"] }, "Pick an emoji": { "v": ["Επιλέξτε ένα emoji"] }, "Search emoji": { "v": [""] }, "Search results": { "v": ["Αποτελέσματα αναζήτησης"] }, "Smileys & Emotion": { "v": ["Φατσούλες & Συναίσθημα"] }, "Symbols": { "v": ["Σύμβολα"] }, "Travel & Places": { "v": ["Ταξίδια & Τοποθεσίες"] } } }, { "l": "en_GB", "t": { "Activities": { "v": ["Activities"] }, "Animals & Nature": { "v": ["Animals & Nature"] }, "Custom": { "v": ["Custom"] }, "Dark skin tone": { "v": ["Dark skin tone"] }, "Emoji picker": { "v": ["Emoji picker"] }, "Flags": { "v": ["Flags"] }, "Food & Drink": { "v": ["Food & Drink"] }, "Frequently used": { "v": ["Frequently used"] }, "Light skin tone": { "v": ["Light skin tone"] }, "Medium dark skin tone": { "v": ["Medium dark skin tone"] }, "Medium light skin tone": { "v": ["Medium light skin tone"] }, "Medium skin tone": { "v": ["Medium skin tone"] }, "Neutral skin color": { "v": ["Neutral skin colour"] }, "Objects": { "v": ["Objects"] }, "People & Body": { "v": ["People & Body"] }, "Pick an emoji": { "v": ["Pick an emoji"] }, "Search emoji": { "v": ["Search emoji"] }, "Search results": { "v": ["Search results"] }, "Selected": { "v": ["Selected"] }, "Skin tone": { "v": ["Skin tone"] }, "Smileys & Emotion": { "v": ["Smileys & Emotion"] }, "Symbols": { "v": ["Symbols"] }, "Travel & Places": { "v": ["Travel & Places"] } } }, { "l": "eo", "t": { "Activities": { "v": ["Aktiveco"] }, "Animals & Nature": { "v": ["Bestoj & Naturo"] }, "Custom": { "v": ["Propra"] }, "Flags": { "v": ["Flagoj"] }, "Food & Drink": { "v": ["Manĝaĵo & Trinkaĵo"] }, "Frequently used": { "v": ["Ofte uzataj"] }, "Objects": { "v": ["Objektoj"] }, "People & Body": { "v": ["Homoj & Korpo"] }, "Pick an emoji": { "v": ["Elekti emoĝion "] }, "Search emoji": { "v": [""] }, "Search results": { "v": ["Serĉrezultoj"] }, "Smileys & Emotion": { "v": ["Ridoj kaj Emocioj"] }, "Symbols": { "v": ["Signoj"] }, "Travel & Places": { "v": ["Vojaĵoj & Lokoj"] } } }, { "l": "es", "t": { "Activities": { "v": ["Actividades"] }, "Animals & Nature": { "v": ["Animales y naturaleza"] }, "Custom": { "v": ["Personalizado"] }, "Dark skin tone": { "v": ["Tono de piel obscuro"] }, "Emoji picker": { "v": ["Selector de emojis"] }, "Flags": { "v": ["Banderas"] }, "Food & Drink": { "v": ["Comida y bebida"] }, "Frequently used": { "v": ["Usado con frecuencia"] }, "Light skin tone": { "v": ["Tono de piel claro"] }, "Medium dark skin tone": { "v": ["Tono de piel medio oscuro"] }, "Medium light skin tone": { "v": ["Tono de piel medio claro"] }, "Medium skin tone": { "v": ["Tono de piel medio"] }, "Neutral skin color": { "v": ["Color de piel neutral"] }, "Objects": { "v": ["Objetos"] }, "People & Body": { "v": ["Personas y Cuerpo"] }, "Pick an emoji": { "v": ["Elegir un emoji"] }, "Search emoji": { "v": ["Buscar emoji"] }, "Search results": { "v": ["Resultados de la búsqueda"] }, "Selected": { "v": ["Seleccionado"] }, "Skin tone": { "v": ["Tono de piel"] }, "Smileys & Emotion": { "v": ["Smileys y emoticonos"] }, "Symbols": { "v": ["Símbolos"] }, "Travel & Places": { "v": ["Viajes y lugares"] } } }, { "l": "es_419", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "es_AR", "t": { "Activities": { "v": ["Actividades"] }, "Animals & Nature": { "v": ["Animales y Naturaleza"] }, "Custom": { "v": ["Personalizado"] }, "Dark skin tone": { "v": ["Tono de piel oscuro"] }, "Emoji picker": { "v": ["Selector de emojis"] }, "Flags": { "v": ["Marcas"] }, "Food & Drink": { "v": ["Comida y Bebida"] }, "Frequently used": { "v": ["Usados frecuentemente"] }, "Light skin tone": { "v": ["Tono de piel claro"] }, "Medium dark skin tone": { "v": ["Tono de piel medio oscuro"] }, "Medium light skin tone": { "v": ["Tono de piel medio claro"] }, "Medium skin tone": { "v": ["Tono de piel medio"] }, "Neutral skin color": { "v": ["Color de piel neutral"] }, "Objects": { "v": ["Objetos"] }, "People & Body": { "v": ["Personas y Cuerpo"] }, "Pick an emoji": { "v": ["Elija un emoji"] }, "Search emoji": { "v": ["Buscar emoji"] }, "Search results": { "v": ["Resultados de la búsqueda"] }, "Selected": { "v": ["Seleccionado"] }, "Skin tone": { "v": ["Tono de piel"] }, "Smileys & Emotion": { "v": ["Caritas y Emociones"] }, "Symbols": { "v": ["Símbolos"] }, "Travel & Places": { "v": ["Viajes y Lugares"] } } }, { "l": "es_CL", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "es_CO", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "es_CR", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "es_DO", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "es_EC", "t": { "Activities": { "v": ["Actividades"] }, "Animals & Nature": { "v": ["Animales y Naturaleza"] }, "Custom": { "v": ["Personalizado"] }, "Flags": { "v": ["Marcas"] }, "Food & Drink": { "v": ["Comida y Bebida"] }, "Frequently used": { "v": ["Frecuentemente utilizado"] }, "Objects": { "v": ["Objetos"] }, "People & Body": { "v": ["Personas y Cuerpo"] }, "Pick an emoji": { "v": ["Seleccionar un emoji"] }, "Search emoji": { "v": ["Buscar emoji"] }, "Search results": { "v": ["Resultados de búsqueda"] }, "Selected": { "v": [""] }, "Smileys & Emotion": { "v": ["Caritas y Emociones"] }, "Symbols": { "v": ["Símbolos"] }, "Travel & Places": { "v": ["Viajes y Lugares"] } } }, { "l": "es_GT", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "es_HN", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "es_MX", "t": { "Activities": { "v": ["Actividades"] }, "Animals & Nature": { "v": ["Animales y naturaleza"] }, "Custom": { "v": ["Personalizado"] }, "Dark skin tone": { "v": ["Tono de piel oscuro"] }, "Emoji picker": { "v": ["Selector de emojis"] }, "Flags": { "v": ["Banderas"] }, "Food & Drink": { "v": ["Comida y Bebida"] }, "Frequently used": { "v": ["Usado frecuentemente"] }, "Light skin tone": { "v": ["Tono de piel claro"] }, "Medium dark skin tone": { "v": ["Tono de piel medio oscuro"] }, "Medium light skin tone": { "v": ["Tono de piel medio claro"] }, "Medium skin tone": { "v": ["Tono de piel medio"] }, "Neutral skin color": { "v": ["Color de piel neutral"] }, "Objects": { "v": ["Objetos"] }, "People & Body": { "v": ["Personas y cuerpos"] }, "Pick an emoji": { "v": ["Seleccionar un emoji"] }, "Search emoji": { "v": ["Buscar emoji"] }, "Search results": { "v": ["Resultados de la búsqueda"] }, "Selected": { "v": ["Seleccionado"] }, "Skin tone": { "v": ["Tono de piel"] }, "Smileys & Emotion": { "v": ["Caritas y Emociones"] }, "Symbols": { "v": ["Símbolos"] }, "Travel & Places": { "v": ["Viajes y lugares"] } } }, { "l": "es_NI", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "es_PA", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "es_PE", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "es_PR", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "es_PY", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "es_SV", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "es_UY", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "et_EE", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "eu", "t": { "Activities": { "v": ["Jarduerak"] }, "Animals & Nature": { "v": ["Animaliak eta Natura"] }, "Custom": { "v": ["Pertsonalizatua"] }, "Flags": { "v": ["Banderak"] }, "Food & Drink": { "v": ["Janaria eta edariak"] }, "Frequently used": { "v": ["Askotan erabilia"] }, "Objects": { "v": ["Objektuak"] }, "People & Body": { "v": ["Jendea eta gorputza"] }, "Pick an emoji": { "v": ["Hautatu emoji bat"] }, "Search emoji": { "v": ["Bilatu emojiak"] }, "Search results": { "v": ["Bilaketa emaitzak"] }, "Selected": { "v": ["Hautatuta"] }, "Smileys & Emotion": { "v": ["Smileyak eta emozioa"] }, "Symbols": { "v": ["Sinboloak"] }, "Travel & Places": { "v": ["Bidaiak eta lekuak"] } } }, { "l": "fa", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "fi", "t": { "Activities": { "v": ["Aktiviteetit"] }, "Animals & Nature": { "v": ["Eläimet & luonto"] }, "Custom": { "v": ["Mukautettu"] }, "Flags": { "v": ["Liput"] }, "Food & Drink": { "v": ["Ruoka & juoma"] }, "Frequently used": { "v": ["Usein käytetyt"] }, "Objects": { "v": ["Esineet & asiat"] }, "People & Body": { "v": ["Ihmiset & keho"] }, "Pick an emoji": { "v": ["Valitse emoji"] }, "Search emoji": { "v": [""] }, "Search results": { "v": ["Hakutulokset"] }, "Smileys & Emotion": { "v": ["Hymiöt & tunteet"] }, "Symbols": { "v": ["Symbolit"] }, "Travel & Places": { "v": ["Matkustus & kohteet"] } } }, { "l": "fo", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "fr", "t": { "Activities": { "v": ["Activités"] }, "Animals & Nature": { "v": ["Animaux & Nature"] }, "Custom": { "v": ["Personnalisé"] }, "Flags": { "v": ["Drapeaux"] }, "Food & Drink": { "v": ["Nourriture & Boissons"] }, "Frequently used": { "v": ["Utilisés fréquemment"] }, "Objects": { "v": ["Objets"] }, "People & Body": { "v": ["Personnes & Corps"] }, "Pick an emoji": { "v": ["Choisissez un émoji"] }, "Search emoji": { "v": ["Rechercher un emoji"] }, "Search results": { "v": ["Résultats de recherche"] }, "Selected": { "v": ["sélectionné"] }, "Smileys & Emotion": { "v": ["Smileys & Émotions"] }, "Symbols": { "v": ["Symboles"] }, "Travel & Places": { "v": ["Voyage & Lieux"] } } }, { "l": "ga", "t": { "Activities": { "v": ["Gníomhaíochtaí"] }, "Animals & Nature": { "v": ["Ainmhithe & Dúlra"] }, "Custom": { "v": ["Saincheaptha"] }, "Dark skin tone": { "v": ["Ton craiceann dorcha"] }, "Emoji picker": { "v": ["Roghnóir Emoji"] }, "Flags": { "v": ["Bratacha"] }, "Food & Drink": { "v": ["Bia & Deoch"] }, "Frequently used": { "v": ["Úsáidtear go minic"] }, "Light skin tone": { "v": ["Ton craiceann éadrom"] }, "Medium dark skin tone": { "v": ["Ton craiceann meánach dorcha"] }, "Medium light skin tone": { "v": ["Ton craiceann meánach éadrom"] }, "Medium skin tone": { "v": ["Ton craiceann meánach"] }, "Neutral skin color": { "v": ["Dath craiceann neodrach"] }, "Objects": { "v": ["Réada"] }, "People & Body": { "v": ["Daoine & Corp"] }, "Pick an emoji": { "v": ["Roghnaigh emoji"] }, "Search emoji": { "v": ["Cuardaigh emoji"] }, "Search results": { "v": ["Torthaí cuardaigh"] }, "Selected": { "v": ["Roghnaithe"] }, "Skin tone": { "v": ["Ton craicinn"] }, "Smileys & Emotion": { "v": ["Smileys & Mothúchán"] }, "Symbols": { "v": ["Siombailí"] }, "Travel & Places": { "v": ["Taisteal & Áiteanna"] } } }, { "l": "gd", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "gl", "t": { "Activities": { "v": ["Actividades"] }, "Animals & Nature": { "v": ["Animais e natureza"] }, "Custom": { "v": ["Personalizado"] }, "Dark skin tone": { "v": ["Ton de pel escuro"] }, "Emoji picker": { "v": ["Selector de «emojis»"] }, "Flags": { "v": ["Bandeiras"] }, "Food & Drink": { "v": ["Comida e bebida"] }, "Frequently used": { "v": ["Usado con frecuencia"] }, "Light skin tone": { "v": ["Ton de pel claro"] }, "Medium dark skin tone": { "v": ["Ton de pel medio escuro"] }, "Medium light skin tone": { "v": ["Ton de pel medio claro"] }, "Medium skin tone": { "v": ["Ton de pel medio"] }, "Neutral skin color": { "v": ["Cor de pel neutra"] }, "Objects": { "v": ["Obxectos"] }, "People & Body": { "v": ["Persoas e corpo"] }, "Pick an emoji": { "v": ["Escolla un «emoji»"] }, "Search emoji": { "v": ["Buscar «emoji»"] }, "Search results": { "v": ["Resultados da busca"] }, "Selected": { "v": ["Seleccionado"] }, "Skin tone": { "v": ["Ton de pel"] }, "Smileys & Emotion": { "v": ["Sorrisos e emocións"] }, "Symbols": { "v": ["Símbolos"] }, "Travel & Places": { "v": ["Viaxes e lugares"] } } }, { "l": "he", "t": { "Activities": { "v": ["פעילויות"] }, "Animals & Nature": { "v": ["חיות וטבע"] }, "Custom": { "v": ["בהתאמה אישית"] }, "Flags": { "v": ["דגלים"] }, "Food & Drink": { "v": ["מזון ומשקאות"] }, "Frequently used": { "v": ["בשימוש תדיר"] }, "Objects": { "v": ["חפצים"] }, "People & Body": { "v": ["אנשים וגוף"] }, "Pick an emoji": { "v": ["נא לבחור אמוג׳י"] }, "Search emoji": { "v": ["חיפוש אמוג׳י"] }, "Search results": { "v": ["תוצאות חיפוש"] }, "Selected": { "v": [""] }, "Smileys & Emotion": { "v": ["חייכנים ורגשונים"] }, "Symbols": { "v": ["סמלים"] }, "Travel & Places": { "v": ["טיולים ומקומות"] } } }, { "l": "hi_IN", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "hr", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "hsb", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "hu", "t": { "Activities": { "v": ["Tevékenységek"] }, "Animals & Nature": { "v": ["Állatok és természet"] }, "Custom": { "v": ["Egyéni"] }, "Flags": { "v": ["Zászlók"] }, "Food & Drink": { "v": ["Étel és ital"] }, "Frequently used": { "v": ["Gyakran használt"] }, "Objects": { "v": ["Tárgyak"] }, "People & Body": { "v": ["Emberek és test"] }, "Pick an emoji": { "v": ["Válasszon egy emodzsit"] }, "Search emoji": { "v": [""] }, "Search results": { "v": ["Találatok"] }, "Smileys & Emotion": { "v": ["Mosolyok és érzelmek"] }, "Symbols": { "v": ["Szimbólumok"] }, "Travel & Places": { "v": ["Utazás és helyek"] } } }, { "l": "hy", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "ia", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "id", "t": { "Activities": { "v": ["Aktivitas"] }, "Animals & Nature": { "v": ["Satwa dan Alam"] }, "Custom": { "v": ["Khusus"] }, "Flags": { "v": ["Tanda"] }, "Food & Drink": { "v": ["Makanan dan Minuman"] }, "Frequently used": { "v": ["Sering digunakan"] }, "Objects": { "v": ["Objek"] }, "People & Body": { "v": ["Orang & Badan"] }, "Pick an emoji": { "v": ["Pilih emoji"] }, "Search emoji": { "v": ["Cari emoji"] }, "Search results": { "v": ["Hasil pencarian"] }, "Selected": { "v": ["Dipilih"] }, "Smileys & Emotion": { "v": ["Senyuman & Perasaan"] }, "Symbols": { "v": ["Simbol"] }, "Travel & Places": { "v": ["Perjalanan & Tempat"] } } }, { "l": "ig", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "is", "t": { "Activities": { "v": ["Aðgerðir"] }, "Animals & Nature": { "v": ["Dýr og náttúra"] }, "Custom": { "v": ["Sérsniðið"] }, "Flags": { "v": ["Flögg"] }, "Food & Drink": { "v": ["Matur og drykkur"] }, "Frequently used": { "v": ["Oftast notað"] }, "Objects": { "v": ["Hlutir"] }, "People & Body": { "v": ["Fólk og líkami"] }, "Pick an emoji": { "v": ["Veldu tjáningartákn"] }, "Search emoji": { "v": ["Leita að tjáningartákni"] }, "Search results": { "v": ["Leitarniðurstöður"] }, "Selected": { "v": ["Valið"] }, "Smileys & Emotion": { "v": ["Broskallar og tilfinningar"] }, "Symbols": { "v": ["Tákn"] }, "Travel & Places": { "v": ["Staðir og ferðalög"] } } }, { "l": "it", "t": { "Activities": { "v": ["Attività"] }, "Animals & Nature": { "v": ["Animali e natura"] }, "Custom": { "v": ["Personalizzato"] }, "Flags": { "v": ["Bandiere"] }, "Food & Drink": { "v": ["Cibo e bevande"] }, "Frequently used": { "v": ["Usati di frequente"] }, "Objects": { "v": ["Oggetti"] }, "People & Body": { "v": ["Persone e corpo"] }, "Pick an emoji": { "v": ["Scegli un emoji"] }, "Search emoji": { "v": ["Ricerca emoji"] }, "Search results": { "v": ["Risultati di ricerca"] }, "Selected": { "v": ["Selezionato"] }, "Smileys & Emotion": { "v": ["Faccine ed emozioni"] }, "Symbols": { "v": ["Simboli"] }, "Travel & Places": { "v": ["Viaggi e luoghi"] } } }, { "l": "ja", "t": { "Activities": { "v": ["アクティビティ"] }, "Animals & Nature": { "v": ["動物と自然"] }, "Custom": { "v": ["カスタム"] }, "Dark skin tone": { "v": ["暗い肌のトーン"] }, "Emoji picker": { "v": ["絵文字ピッカー"] }, "Flags": { "v": ["国旗"] }, "Food & Drink": { "v": ["食べ物と飲み物"] }, "Frequently used": { "v": ["よく使うもの"] }, "Light skin tone": { "v": ["明るい肌のトーン"] }, "Medium dark skin tone": { "v": ["やや暗い肌のトーン"] }, "Medium light skin tone": { "v": ["やや明るい肌のトーン"] }, "Medium skin tone": { "v": ["中間の肌のトーン"] }, "Neutral skin color": { "v": ["ニュートラルな肌の色"] }, "Objects": { "v": ["物"] }, "People & Body": { "v": ["様々な人と体の部位"] }, "Pick an emoji": { "v": ["絵文字を選択"] }, "Search emoji": { "v": ["絵文字を検索"] }, "Search results": { "v": ["検索結果"] }, "Selected": { "v": ["選択済み"] }, "Skin tone": { "v": ["肌のトーン"] }, "Smileys & Emotion": { "v": ["感情表現"] }, "Symbols": { "v": ["記号"] }, "Travel & Places": { "v": ["旅行と場所"] } } }, { "l": "ja_JP", "t": { "Activities": { "v": ["アクティビティ"] }, "Animals & Nature": { "v": ["動物と自然"] }, "Custom": { "v": ["カスタム"] }, "Dark skin tone": { "v": ["暗い肌のトーン"] }, "Emoji picker": { "v": ["絵文字ピッカー"] }, "Flags": { "v": ["国旗"] }, "Food & Drink": { "v": ["食べ物と飲み物"] }, "Frequently used": { "v": ["よく使うもの"] }, "Light skin tone": { "v": ["明るい肌のトーン"] }, "Medium dark skin tone": { "v": ["やや暗い肌のトーン"] }, "Medium light skin tone": { "v": ["やや明るい肌のトーン"] }, "Medium skin tone": { "v": ["中間の肌のトーン"] }, "Neutral skin color": { "v": ["ニュートラルな肌の色"] }, "Objects": { "v": ["物"] }, "People & Body": { "v": ["様々な人と体の部位"] }, "Pick an emoji": { "v": ["絵文字を選択"] }, "Search emoji": { "v": ["絵文字を検索"] }, "Search results": { "v": ["検索結果"] }, "Selected": { "v": ["選択済み"] }, "Skin tone": { "v": ["肌のトーン"] }, "Smileys & Emotion": { "v": ["感情表現"] }, "Symbols": { "v": ["記号"] }, "Travel & Places": { "v": ["旅行と場所"] } } }, { "l": "ka", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "ka_GE", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "kab", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "kk", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "km", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "kn", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "ko", "t": { "Activities": { "v": ["활동"] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "la", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "lb", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "lo", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "lt_LT", "t": { "Activities": { "v": ["Veiklos"] }, "Animals & Nature": { "v": ["Gyvūnai ir gamta"] }, "Custom": { "v": ["Tinkinti"] }, "Flags": { "v": ["Vėliavos"] }, "Food & Drink": { "v": ["Maistas ir gėrimai"] }, "Frequently used": { "v": ["Dažniausiai naudoti"] }, "Objects": { "v": ["Objektai"] }, "People & Body": { "v": ["Žmonės ir kūnas"] }, "Pick an emoji": { "v": ["Pasirinkti jaustuką"] }, "Search emoji": { "v": [""] }, "Search results": { "v": ["Paieškos rezultatai"] }, "Smileys & Emotion": { "v": ["Šypsenos ir emocijos"] }, "Symbols": { "v": ["Simboliai"] }, "Travel & Places": { "v": ["Kelionės ir vietos"] } } }, { "l": "lv", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "mk", "t": { "Activities": { "v": ["Активности"] }, "Animals & Nature": { "v": ["Животни & Природа"] }, "Custom": { "v": ["Прилагодени"] }, "Flags": { "v": ["Знамиња"] }, "Food & Drink": { "v": ["Храна & Пијалоци"] }, "Frequently used": { "v": ["Најчесто користени"] }, "Objects": { "v": ["Објекти"] }, "People & Body": { "v": ["Луѓе & Тело"] }, "Pick an emoji": { "v": ["Избери емотикон"] }, "Search emoji": { "v": [""] }, "Search results": { "v": ["Резултати од барувањето"] }, "Smileys & Emotion": { "v": ["Смешковци & Емотикони"] }, "Symbols": { "v": ["Симболи"] }, "Travel & Places": { "v": ["Патувања & Места"] } } }, { "l": "mn", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "mr", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "ms_MY", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "my", "t": { "Activities": { "v": ["ပြုလုပ်ဆောင်တာများ"] }, "Animals & Nature": { "v": ["တိရစ္ဆာန်များနှင့် သဘာဝ"] }, "Custom": { "v": ["အလိုကျချိန်ညှိမှု"] }, "Flags": { "v": ["အလံများ"] }, "Food & Drink": { "v": ["အစားအသောက်"] }, "Frequently used": { "v": ["မကြာခဏအသုံးပြုသော"] }, "Objects": { "v": ["အရာဝတ္ထုများ"] }, "People & Body": { "v": ["လူပုဂ္ဂိုလ်များနှင့် ခန္ဓာကိုယ်"] }, "Pick an emoji": { "v": ["အီမိုဂျီရွေးရန်"] }, "Search emoji": { "v": [""] }, "Search results": { "v": ["ရှာဖွေမှု ရလဒ်များ"] }, "Smileys & Emotion": { "v": ["စမိုင်လီများနှင့် အီမိုရှင်း"] }, "Symbols": { "v": ["သင်္ကေတများ"] }, "Travel & Places": { "v": ["ခရီးသွားလာခြင်းနှင့် နေရာများ"] } } }, { "l": "nb", "t": { "Activities": { "v": ["Aktiviteter"] }, "Animals & Nature": { "v": ["Dyr og natur"] }, "Custom": { "v": ["Tilpasset"] }, "Dark skin tone": { "v": ["Mørk hudtone"] }, "Emoji picker": { "v": ["Emoji-velger"] }, "Flags": { "v": ["Flagg"] }, "Food & Drink": { "v": ["Mat og drikke"] }, "Frequently used": { "v": ["Ofte brukt"] }, "Light skin tone": { "v": ["Lys hudtone"] }, "Medium dark skin tone": { "v": ["Middels mørk hudtone"] }, "Medium light skin tone": { "v": ["Middels lys hudtone"] }, "Medium skin tone": { "v": ["Middels hudtone"] }, "Neutral skin color": { "v": ["Nøytral hudfarge"] }, "Objects": { "v": ["Objekter"] }, "People & Body": { "v": ["Mennesker og kropp"] }, "Pick an emoji": { "v": ["Velg en emoji"] }, "Search emoji": { "v": ["Søk emoji"] }, "Search results": { "v": ["Søkeresultater"] }, "Selected": { "v": ["Valgt"] }, "Skin tone": { "v": ["Hudtone"] }, "Smileys & Emotion": { "v": ["Smilefjes og følelser"] }, "Symbols": { "v": ["Symboler"] }, "Travel & Places": { "v": ["Reise og steder"] } } }, { "l": "ne", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "nl", "t": { "Activities": { "v": ["Activiteiten"] }, "Animals & Nature": { "v": ["Dieren & Natuur"] }, "Custom": { "v": ["Aangepast"] }, "Dark skin tone": { "v": ["Donkere tint"] }, "Emoji picker": { "v": ["Emoji-kiezer"] }, "Flags": { "v": ["Vlaggen"] }, "Food & Drink": { "v": ["Eten & Drinken"] }, "Frequently used": { "v": ["Vaak gebruikt"] }, "Light skin tone": { "v": ["Lichte tint"] }, "Medium dark skin tone": { "v": ["Gemiddelde donkere tint"] }, "Medium light skin tone": { "v": ["Gemiddeld lichte tint"] }, "Medium skin tone": { "v": ["Gemiddelde tint"] }, "Neutral skin color": { "v": ["Neutrale tint"] }, "Objects": { "v": ["Objecten"] }, "People & Body": { "v": ["Mensen & Lichaam"] }, "Pick an emoji": { "v": ["Kies een emoji"] }, "Search emoji": { "v": ["Zoek emoji"] }, "Search results": { "v": ["Zoekresultaten"] }, "Selected": { "v": ["Geselecteerd"] }, "Skin tone": { "v": ["Tint van de schil"] }, "Smileys & Emotion": { "v": ["Smileys & Emotie"] }, "Symbols": { "v": ["Symbolen"] }, "Travel & Places": { "v": ["Reizen & Plaatsen"] } } }, { "l": "nn_NO", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "oc", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "pl", "t": { "Activities": { "v": ["Aktywność"] }, "Animals & Nature": { "v": ["Zwierzęta i natura"] }, "Custom": { "v": ["Zwyczajne"] }, "Dark skin tone": { "v": ["Ciemna tonacja"] }, "Emoji picker": { "v": ["Wybierz Emoji"] }, "Flags": { "v": ["Flagi"] }, "Food & Drink": { "v": ["Jedzenie i picie"] }, "Frequently used": { "v": ["Często używane"] }, "Light skin tone": { "v": ["Jasny odcień skóry"] }, "Medium dark skin tone": { "v": ["Średnio ciemny odcień skóry"] }, "Medium light skin tone": { "v": ["Średnio jasny odcień skóry"] }, "Medium skin tone": { "v": ["Średni odcień skóry"] }, "Neutral skin color": { "v": ["Neutralny kolor skróry"] }, "Objects": { "v": ["Obiekty"] }, "People & Body": { "v": ["Ludzie i ciało"] }, "Pick an emoji": { "v": ["Wybierz emoji"] }, "Search emoji": { "v": ["Szukaj emoji"] }, "Search results": { "v": ["Wyniki wyszukiwania"] }, "Selected": { "v": ["Wybrane"] }, "Skin tone": { "v": ["Kolor skóry"] }, "Smileys & Emotion": { "v": ["Buźki i emotikony"] }, "Symbols": { "v": ["Symbole"] }, "Travel & Places": { "v": ["Podróże i miejsca"] } } }, { "l": "ps", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "pt_BR", "t": { "Activities": { "v": ["Atividades"] }, "Animals & Nature": { "v": ["Animais & Natureza"] }, "Custom": { "v": ["Personalizado"] }, "Dark skin tone": { "v": ["Tom de pele escuro"] }, "Emoji picker": { "v": ["Selecionar emoji"] }, "Flags": { "v": ["Bandeiras"] }, "Food & Drink": { "v": ["Comida & Bebida"] }, "Frequently used": { "v": ["Mais usados"] }, "Light skin tone": { "v": ["Tome de pele claro"] }, "Medium dark skin tone": { "v": ["Tom de pele meio escuro"] }, "Medium light skin tone": { "v": ["Tom de pele meio claro"] }, "Medium skin tone": { "v": ["Tom de pele médio"] }, "Neutral skin color": { "v": ["Tom de pele neutro"] }, "Objects": { "v": ["Objetos"] }, "People & Body": { "v": ["Pessoas & Corpo"] }, "Pick an emoji": { "v": ["Escolha um emoji"] }, "Search emoji": { "v": ["Pesquisar emoticons"] }, "Search results": { "v": ["Resultados da pesquisa"] }, "Selected": { "v": ["Selecionado"] }, "Skin tone": { "v": ["Tom de pele"] }, "Smileys & Emotion": { "v": ["Smiles & Emoções"] }, "Symbols": { "v": ["Símbolo"] }, "Travel & Places": { "v": ["Viagem & Lugares"] } } }, { "l": "pt_PT", "t": { "Activities": { "v": ["Atividades"] }, "Animals & Nature": { "v": ["Animais e Natureza"] }, "Custom": { "v": ["Personalizado"] }, "Flags": { "v": ["Bandeiras"] }, "Food & Drink": { "v": ["Comida e Bebida"] }, "Frequently used": { "v": ["Mais utilizados"] }, "Objects": { "v": ["Objetos"] }, "People & Body": { "v": ["Pessoas e Corpo"] }, "Pick an emoji": { "v": ["Escolha um emoji"] }, "Search emoji": { "v": ["Pesquisar emoji"] }, "Search results": { "v": ["Resultados da pesquisa"] }, "Selected": { "v": [""] }, "Smileys & Emotion": { "v": ["Sorrisos e Emoções"] }, "Symbols": { "v": ["Símbolos"] }, "Travel & Places": { "v": ["Viagem e Lugares"] } } }, { "l": "ro", "t": { "Activities": { "v": ["Activități"] }, "Animals & Nature": { "v": ["Animale și natură"] }, "Custom": { "v": ["Personalizat"] }, "Flags": { "v": ["Marcaje"] }, "Food & Drink": { "v": ["Alimente și băuturi"] }, "Frequently used": { "v": ["Utilizate frecvent"] }, "Objects": { "v": ["Obiecte"] }, "People & Body": { "v": ["Oameni și corp"] }, "Pick an emoji": { "v": ["Alege un emoji"] }, "Search emoji": { "v": ["Căutare emoji"] }, "Search results": { "v": ["Rezultatele căutării"] }, "Selected": { "v": ["Selectat"] }, "Smileys & Emotion": { "v": ["Zâmbete și emoții"] }, "Symbols": { "v": ["Simboluri"] }, "Travel & Places": { "v": ["Călătorii și locuri"] } } }, { "l": "ru", "t": { "Activities": { "v": ["События"] }, "Animals & Nature": { "v": ["Животные и природа "] }, "Custom": { "v": ["Пользовательское"] }, "Flags": { "v": ["Флаги"] }, "Food & Drink": { "v": ["Еда, напиток"] }, "Frequently used": { "v": ["Часто используемый"] }, "Objects": { "v": ["Объекты"] }, "People & Body": { "v": ["Люди и тело"] }, "Pick an emoji": { "v": ["Выберите эмодзи"] }, "Search emoji": { "v": ["Поиск эмодзи"] }, "Search results": { "v": ["Результаты поиска"] }, "Selected": { "v": ["Выбрано"] }, "Smileys & Emotion": { "v": ["Смайлики и эмоции"] }, "Symbols": { "v": ["Символы"] }, "Travel & Places": { "v": ["Путешествия и места"] } } }, { "l": "sc", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "si", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "sk", "t": { "Activities": { "v": ["Aktivity"] }, "Animals & Nature": { "v": ["Zvieratá a príroda"] }, "Custom": { "v": ["Zvyk"] }, "Flags": { "v": ["Vlajky"] }, "Food & Drink": { "v": ["Jedlo a nápoje"] }, "Frequently used": { "v": ["Často používané"] }, "Objects": { "v": ["Objekty"] }, "People & Body": { "v": ["Ľudia a telo"] }, "Pick an emoji": { "v": ["Vyberte si emodži"] }, "Search emoji": { "v": [""] }, "Search results": { "v": ["Výsledky vyhľadávania"] }, "Smileys & Emotion": { "v": ["Smajlíky a emócie"] }, "Symbols": { "v": ["Symboly"] }, "Travel & Places": { "v": ["Cestovanie a miesta"] } } }, { "l": "sl", "t": { "Activities": { "v": ["Dejavnosti"] }, "Animals & Nature": { "v": ["Živali in Narava"] }, "Custom": { "v": ["Po meri"] }, "Flags": { "v": ["Zastavice"] }, "Food & Drink": { "v": ["Hrana in Pijača"] }, "Frequently used": { "v": ["Pogostost uporabe"] }, "Objects": { "v": ["Predmeti"] }, "People & Body": { "v": ["Ljudje in Telo"] }, "Pick an emoji": { "v": ["Izbor izrazne ikone"] }, "Search emoji": { "v": [""] }, "Search results": { "v": ["Zadetki iskanja"] }, "Smileys & Emotion": { "v": ["Izrazne ikone"] }, "Symbols": { "v": ["Simboli"] }, "Travel & Places": { "v": ["Potovanja in Kraji"] } } }, { "l": "sq", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "sr", "t": { "Activities": { "v": ["Активности"] }, "Animals & Nature": { "v": ["Животиње и природа"] }, "Custom": { "v": ["Произвољно"] }, "Dark skin tone": { "v": ["Тамни тен коже"] }, "Emoji picker": { "v": ["Бирач емођија"] }, "Flags": { "v": ["Заставе"] }, "Food & Drink": { "v": ["Храна и пиће"] }, "Frequently used": { "v": ["Често коришћено"] }, "Light skin tone": { "v": ["Светли тен коже"] }, "Medium dark skin tone": { "v": ["Средње тамни тен коже"] }, "Medium light skin tone": { "v": ["Средње светли тен коже"] }, "Medium skin tone": { "v": ["Средњи тен коже"] }, "Neutral skin color": { "v": ["Неутрална боја коже"] }, "Objects": { "v": ["Предмети"] }, "People & Body": { "v": ["Људи и тело"] }, "Pick an emoji": { "v": ["Изаберите емођи"] }, "Search emoji": { "v": ["Претражи емођи"] }, "Search results": { "v": ["Резултати претраге"] }, "Selected": { "v": ["Изабрано"] }, "Skin tone": { "v": ["Тен коже"] }, "Smileys & Emotion": { "v": ["Смајлији и емоције"] }, "Symbols": { "v": ["Симболи"] }, "Travel & Places": { "v": ["Путовање и места"] } } }, { "l": "sr@latin", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "sv", "t": { "Activities": { "v": ["Aktiviteter"] }, "Animals & Nature": { "v": ["Djur & Natur"] }, "Custom": { "v": ["Anpassad"] }, "Dark skin tone": { "v": ["Mörk hudton"] }, "Emoji picker": { "v": ["Emoji-väljare"] }, "Flags": { "v": ["Flaggor"] }, "Food & Drink": { "v": ["Mat & Dryck"] }, "Frequently used": { "v": ["Används ofta"] }, "Light skin tone": { "v": ["Ljus hudton"] }, "Medium dark skin tone": { "v": ["Medium mörk hudton"] }, "Medium light skin tone": { "v": ["Medium ljus hudton"] }, "Medium skin tone": { "v": ["Medium hudton"] }, "Neutral skin color": { "v": ["Neutral hudfärg"] }, "Objects": { "v": ["Objekt"] }, "People & Body": { "v": ["Kropp & Själ"] }, "Pick an emoji": { "v": ["Välj en emoji"] }, "Search emoji": { "v": ["Sök emoji"] }, "Search results": { "v": ["Sökresultat"] }, "Selected": { "v": ["Vald"] }, "Skin tone": { "v": ["Hudton"] }, "Smileys & Emotion": { "v": ["Selfies & Känslor"] }, "Symbols": { "v": ["Symboler"] }, "Travel & Places": { "v": ["Resor & Sevärdigheter"] } } }, { "l": "sw", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "ta", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "th", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "tk", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "tr", "t": { "Activities": { "v": ["Etkinlikler"] }, "Animals & Nature": { "v": ["Hayvanlar ve Doğa"] }, "Custom": { "v": ["Özel"] }, "Dark skin tone": { "v": ["Koyu deri rengi"] }, "Emoji picker": { "v": ["Emoji seçici"] }, "Flags": { "v": ["Bayraklar"] }, "Food & Drink": { "v": ["Yeme ve içme"] }, "Frequently used": { "v": ["Sık kullanılanlar"] }, "Light skin tone": { "v": ["Açık deri rengi"] }, "Medium dark skin tone": { "v": ["Orta koyu deri rengi"] }, "Medium light skin tone": { "v": ["Orta açık deri rengi"] }, "Medium skin tone": { "v": ["Orta deri rengi"] }, "Neutral skin color": { "v": ["Nötr deri rengi"] }, "Objects": { "v": ["Nesneler"] }, "People & Body": { "v": ["İnsanlar ve beden"] }, "Pick an emoji": { "v": ["Bir emoji seçin"] }, "Search emoji": { "v": ["Emoji ara"] }, "Search results": { "v": ["Arama sonuçları"] }, "Selected": { "v": ["Seçilmiş"] }, "Skin tone": { "v": ["Deri rengi"] }, "Smileys & Emotion": { "v": ["İfadeler ve duygular"] }, "Symbols": { "v": ["Simgeler"] }, "Travel & Places": { "v": ["Gezi ve yerler"] } } }, { "l": "ug", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "uk", "t": { "Activities": { "v": ["Діяльність"] }, "Animals & Nature": { "v": ["Тварини та природа"] }, "Custom": { "v": ["Власне"] }, "Dark skin tone": { "v": ["Смаглявий"] }, "Emoji picker": { "v": ["Вибір емоційки"] }, "Flags": { "v": ["Прапори"] }, "Food & Drink": { "v": ["Їжа та напої"] }, "Frequently used": { "v": ["Найчастіші"] }, "Light skin tone": { "v": ["Світла шкіра"] }, "Medium dark skin tone": { "v": ["Какао"] }, "Medium light skin tone": { "v": ["Лате"] }, "Medium skin tone": { "v": ["Середній колір шкіри"] }, "Neutral skin color": { "v": ["Нейтральний колір шкіри"] }, "Objects": { "v": ["Об'єкти"] }, "People & Body": { "v": ["Люди та жести"] }, "Pick an emoji": { "v": ["Виберіть емоційку"] }, "Search emoji": { "v": ["Шукати емоційки"] }, "Search results": { "v": ["Результати пошуку"] }, "Selected": { "v": ["Вибрано"] }, "Skin tone": { "v": ["Колір шкіри"] }, "Smileys & Emotion": { "v": ["Смайли та емоції"] }, "Symbols": { "v": ["Символи"] }, "Travel & Places": { "v": ["Поїздки та місця"] } } }, { "l": "ur_PK", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "uz", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "vi", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }, { "l": "zh_CN", "t": { "Activities": { "v": ["活动"] }, "Animals & Nature": { "v": ["动物 & 自然"] }, "Custom": { "v": ["自定义"] }, "Flags": { "v": ["旗帜"] }, "Food & Drink": { "v": ["食物 & 饮品"] }, "Frequently used": { "v": ["经常使用"] }, "Objects": { "v": ["物体"] }, "People & Body": { "v": ["人 & 身体"] }, "Pick an emoji": { "v": ["选择一个表情"] }, "Search emoji": { "v": [""] }, "Search results": { "v": ["搜索结果"] }, "Smileys & Emotion": { "v": ["笑脸 & 情感"] }, "Symbols": { "v": ["符号"] }, "Travel & Places": { "v": ["旅游 & 地点"] } } }, { "l": "zh_HK", "t": { "Activities": { "v": ["活動"] }, "Animals & Nature": { "v": ["動物與自然"] }, "Custom": { "v": ["自定義"] }, "Flags": { "v": ["旗幟"] }, "Food & Drink": { "v": ["食物與飲料"] }, "Frequently used": { "v": ["經常使用"] }, "Objects": { "v": ["物件"] }, "People & Body": { "v": ["人物"] }, "Pick an emoji": { "v": ["選擇表情符號"] }, "Search emoji": { "v": ["搜尋表情符號"] }, "Search results": { "v": ["搜尋結果"] }, "Selected": { "v": ["已選"] }, "Smileys & Emotion": { "v": ["表情"] }, "Symbols": { "v": ["標誌"] }, "Travel & Places": { "v": ["旅遊與景點"] } } }, { "l": "zh_TW", "t": { "Activities": { "v": ["活動"] }, "Animals & Nature": { "v": ["動物與自然"] }, "Custom": { "v": ["自定義"] }, "Flags": { "v": ["旗幟"] }, "Food & Drink": { "v": ["食物與飲料"] }, "Frequently used": { "v": ["最近使用"] }, "Objects": { "v": ["物件"] }, "People & Body": { "v": ["人物"] }, "Pick an emoji": { "v": ["選擇表情符號"] }, "Search emoji": { "v": ["搜尋表情符號"] }, "Search results": { "v": ["搜尋結果"] }, "Selected": { "v": ["已選取"] }, "Smileys & Emotion": { "v": ["表情"] }, "Symbols": { "v": ["標誌"] }, "Travel & Places": { "v": ["旅遊與景點"] } } }, { "l": "zu_ZA", "t": { "Activities": { "v": [""] }, "Animals & Nature": { "v": [""] }, "Custom": { "v": [""] }, "Flags": { "v": [""] }, "Food & Drink": { "v": [""] }, "Frequently used": { "v": [""] }, "Objects": { "v": [""] }, "People & Body": { "v": [""] }, "Pick an emoji": { "v": [""] }, "Search emoji": { "v": [""] }, "Search results": { "v": [""] }, "Smileys & Emotion": { "v": [""] }, "Symbols": { "v": [""] }, "Travel & Places": { "v": [""] } } }];
const t7 = [{ "l": "af", "t": {} }, { "l": "ar", "t": { "Add to a project": { "v": ["أضف إلى مشروع"] }, "Connect items to a project to make them easier to find": { "v": ["ربط عناصر بمشروع لتسهيل العثور عليها"] }, "Failed to add the item to the project": { "v": ["تعذر ربط عنصر بمشروع"] }, "Failed to create a project": { "v": ["تعذر إنشاء مشروع"] }, "Failed to rename the project": { "v": ["تعذّر تغيير اسم المشروع"] }, "Type to search for existing projects": { "v": ["أكتُب للبحث في المشاريع الموجودة"] } } }, { "l": "ast", "t": {} }, { "l": "az", "t": {} }, { "l": "be", "t": {} }, { "l": "bg", "t": {} }, { "l": "bn_BD", "t": {} }, { "l": "br", "t": {} }, { "l": "bs", "t": {} }, { "l": "ca", "t": {} }, { "l": "cs", "t": { "Add to a project": { "v": ["Přidat do projektu"] }, "Connect items to a project to make them easier to find": { "v": ["Připojte položky k projektu, čímž budou snáze dohledatelné"] }, "Failed to add the item to the project": { "v": ["Položku se nepodařilo přidat do projektu"] }, "Failed to create a project": { "v": ["Projekt se nepodařilo vytvořit"] }, "Failed to rename the project": { "v": ["Projekt se nepodařilo přejmenovat"] }, "Type to search for existing projects": { "v": ["Psaním vyhledávejte existující projekty"] } } }, { "l": "cs_CZ", "t": {} }, { "l": "cy_GB", "t": {} }, { "l": "da", "t": { "Add to a project": { "v": ["Tilføj til et projekt"] }, "Connect items to a project to make them easier to find": { "v": ["Forbind elementer til et projekt for at gøre dem nemmere at finde"] }, "Failed to add the item to the project": { "v": ["Kunne ikke føje elementet til projektet"] }, "Failed to create a project": { "v": ["Kunne ikke oprette et projekt"] }, "Failed to rename the project": { "v": ["Projektet kunne ikke omdøbes"] }, "Type to search for existing projects": { "v": ["Skriv for at søge efter eksisterende projekter"] } } }, { "l": "de", "t": { "Add to a project": { "v": ["Einem Projekt hinzufügen"] }, "Connect items to a project to make them easier to find": { "v": ["Verbinden Sie Elemente mit einem Projekt, um sie leichter zu finden"] }, "Failed to add the item to the project": { "v": ["Das Element konnte nicht zum Projekt hinzugefügt werden"] }, "Failed to create a project": { "v": ["Fehler beim Erstellen eines Projektes"] }, "Failed to rename the project": { "v": ["Fehler beim Umbenennen eines Projektes"] }, "Type to search for existing projects": { "v": ["Tippen, um nach vorhandenen Projekten zu suchen"] } } }, { "l": "de_DE", "t": { "Add to a project": { "v": ["Einem Projekt hinzufügen"] }, "Connect items to a project to make them easier to find": { "v": ["Verbinden Sie Elemente mit einem Projekt, um sie leichter zu finden"] }, "Failed to add the item to the project": { "v": ["Das Element konnte nicht zum Projekt hinzugefügt werden"] }, "Failed to create a project": { "v": ["Fehler beim Erstellen eines Projektes"] }, "Failed to rename the project": { "v": ["Fehler beim Umbenennen eines Projektes"] }, "Type to search for existing projects": { "v": ["Tippen, um nach vorhandenen Projekten zu suchen"] } } }, { "l": "el", "t": {} }, { "l": "en_GB", "t": { "Add to a project": { "v": ["Add to a project"] }, "Connect items to a project to make them easier to find": { "v": ["Connect items to a project to make them easier to find"] }, "Failed to add the item to the project": { "v": ["Failed to add the item to the project"] }, "Failed to create a project": { "v": ["Failed to create a project"] }, "Failed to rename the project": { "v": ["Failed to rename the project"] }, "Type to search for existing projects": { "v": ["Type to search for existing projects"] } } }, { "l": "eo", "t": {} }, { "l": "es", "t": {} }, { "l": "es_419", "t": {} }, { "l": "es_AR", "t": { "Add to a project": { "v": ["Agregar a un proyecto"] }, "Connect items to a project to make them easier to find": { "v": ["Conecte items a un proyecto para hacerlos más fáciles de encontrar"] }, "Failed to add the item to the project": { "v": ["No se pudo agregar el elemento al proyecto"] }, "Failed to create a project": { "v": ["No se pudo crear un proyecto"] }, "Failed to rename the project": { "v": ["No se pudo renombrar el proyecto"] }, "Type to search for existing projects": { "v": ["Escriba para buscar proyectos existentes"] } } }, { "l": "es_CL", "t": {} }, { "l": "es_CO", "t": {} }, { "l": "es_CR", "t": {} }, { "l": "es_DO", "t": {} }, { "l": "es_EC", "t": {} }, { "l": "es_GT", "t": {} }, { "l": "es_HN", "t": {} }, { "l": "es_MX", "t": { "Add to a project": { "v": ["Agregar a un proyecto"] }, "Connect items to a project to make them easier to find": { "v": ["Conecte elementos a un proyecto para hacerlos más fáciles de encontrar"] }, "Failed to add the item to the project": { "v": ["No se pudo agregar el elemento al proyecto"] }, "Failed to create a project": { "v": ["No se pudo crear el proyecto"] }, "Failed to rename the project": { "v": ["No se pudo renombrar el proyecto"] }, "Type to search for existing projects": { "v": ["Escriba para buscar proyectos existentes"] } } }, { "l": "es_NI", "t": {} }, { "l": "es_PA", "t": {} }, { "l": "es_PE", "t": {} }, { "l": "es_PR", "t": {} }, { "l": "es_PY", "t": {} }, { "l": "es_SV", "t": {} }, { "l": "es_UY", "t": {} }, { "l": "et_EE", "t": {} }, { "l": "eu", "t": {} }, { "l": "fa", "t": {} }, { "l": "fi", "t": {} }, { "l": "fo", "t": {} }, { "l": "fr", "t": {} }, { "l": "ga", "t": { "Add to a project": { "v": ["Cuir le tionscadal"] }, "Connect items to a project to make them easier to find": { "v": ["Ceangail míreanna le tionscadal chun iad a dhéanamh níos éasca iad a aimsiú"] }, "Failed to add the item to the project": { "v": ["Theip ar an mír a chur leis an tionscadal"] }, "Failed to create a project": { "v": ["Theip ar thionscadal a chruthú"] }, "Failed to rename the project": { "v": ["Theip ar an tionscadal a athainmniú"] }, "Type to search for existing projects": { "v": ["Clóscríobh chun tionscadail atá ann cheana a chuardach"] } } }, { "l": "gd", "t": {} }, { "l": "gl", "t": { "Add to a project": { "v": ["Engadir a un proxecto"] }, "Connect items to a project to make them easier to find": { "v": ["Conectar elementos a un proxecto para facelos máis doados de atopar"] }, "Failed to add the item to the project": { "v": ["Produciuse un fallo ao engadir o elemento ao proxecto"] }, "Failed to create a project": { "v": ["Produciuse un fallo ao crear un proxecto"] }, "Failed to rename the project": { "v": ["Produciuse un fallo ao cambiarlle o nome ao proxecto"] }, "Type to search for existing projects": { "v": ["Escriba para buscar proxectos existentes"] } } }, { "l": "he", "t": {} }, { "l": "hi_IN", "t": {} }, { "l": "hr", "t": {} }, { "l": "hsb", "t": {} }, { "l": "hu", "t": {} }, { "l": "hy", "t": {} }, { "l": "ia", "t": {} }, { "l": "id", "t": {} }, { "l": "ig", "t": {} }, { "l": "is", "t": {} }, { "l": "it", "t": {} }, { "l": "ja", "t": { "Add to a project": { "v": ["プロジェクトに追加する"] }, "Connect items to a project to make them easier to find": { "v": ["項目をプロジェクトに接続して検索しやすくする"] }, "Failed to add the item to the project": { "v": ["プロジェクトへのアイテムの追加に失敗しました"] }, "Failed to create a project": { "v": ["プロジェクトの作成に失敗しました"] }, "Failed to rename the project": { "v": ["プロジェクトの名前変更に失敗しました"] }, "Type to search for existing projects": { "v": ["既存のプロジェクトを検索するために入力します"] } } }, { "l": "ja_JP", "t": {} }, { "l": "ka", "t": {} }, { "l": "ka_GE", "t": {} }, { "l": "kab", "t": {} }, { "l": "kk", "t": {} }, { "l": "km", "t": {} }, { "l": "kn", "t": {} }, { "l": "ko", "t": {} }, { "l": "la", "t": {} }, { "l": "lb", "t": {} }, { "l": "lo", "t": {} }, { "l": "lt_LT", "t": {} }, { "l": "lv", "t": {} }, { "l": "mk", "t": {} }, { "l": "mn", "t": {} }, { "l": "mr", "t": {} }, { "l": "ms_MY", "t": {} }, { "l": "my", "t": {} }, { "l": "nb", "t": { "Add to a project": { "v": ["Legge til i et prosjekt"] }, "Connect items to a project to make them easier to find": { "v": ["Koble elementer til et prosjekt for å gjøre det enklere å finne dem"] }, "Failed to add the item to the project": { "v": ["Kan ikke legge til elementet i prosjektet"] }, "Failed to create a project": { "v": ["Kan ikke opprette et prosjekt"] }, "Failed to rename the project": { "v": ["Kunne ikke gi prosjektet nytt navn"] }, "Type to search for existing projects": { "v": ["Skriv for å søke for eksisterende prosjekter"] } } }, { "l": "ne", "t": {} }, { "l": "nl", "t": {} }, { "l": "nn_NO", "t": {} }, { "l": "oc", "t": {} }, { "l": "pl", "t": {} }, { "l": "ps", "t": {} }, { "l": "pt_BR", "t": {} }, { "l": "pt_PT", "t": {} }, { "l": "ro", "t": {} }, { "l": "ru", "t": {} }, { "l": "sc", "t": {} }, { "l": "si", "t": {} }, { "l": "sk", "t": {} }, { "l": "sl", "t": {} }, { "l": "sq", "t": {} }, { "l": "sr", "t": {} }, { "l": "sr@latin", "t": {} }, { "l": "sv", "t": { "Add to a project": { "v": ["Lägg till i ett projekt"] }, "Connect items to a project to make them easier to find": { "v": ["Anslut objekt till ett projekt för att göra dem lättare att hitta"] }, "Failed to add the item to the project": { "v": ["Det gick inte att lägga till objektet i projektet"] }, "Failed to create a project": { "v": ["Det gick inte att skapa ett projekt"] }, "Failed to rename the project": { "v": ["Kunde inte byta namn på projektet"] }, "Type to search for existing projects": { "v": ["Skriv för att söka efter befintliga projekt"] } } }, { "l": "sw", "t": {} }, { "l": "ta", "t": {} }, { "l": "th", "t": {} }, { "l": "tk", "t": {} }, { "l": "tr", "t": { "Add to a project": { "v": ["Bir projeye ekle"] }, "Connect items to a project to make them easier to find": { "v": ["Ögeleri daha kolay bulmak için bir proje ile ilişkilendirin"] }, "Failed to add the item to the project": { "v": ["Öge projeye eklenemedi"] }, "Failed to create a project": { "v": ["Bir proje oluşturulamadı"] }, "Failed to rename the project": { "v": ["Proje yeniden adlandırılamadı"] }, "Type to search for existing projects": { "v": ["Var olan projeleri aramak için yazmaya başlayın"] } } }, { "l": "ug", "t": {} }, { "l": "uk", "t": { "Add to a project": { "v": ["Додати др проєкту"] }, "Connect items to a project to make them easier to find": { "v": ["Приєднайте ресурси до проєкту для швидшого  пошуку"] }, "Failed to add the item to the project": { "v": ["Не вдалося приєднати ресурс до проєкту"] }, "Failed to create a project": { "v": ["Не вдалося створити проєкт"] }, "Failed to rename the project": { "v": ["Не вдалося перейменувати проєкт"] }, "Type to search for existing projects": { "v": ["Почніть вводити, щоб знайти проєкт"] } } }, { "l": "ur_PK", "t": {} }, { "l": "uz", "t": {} }, { "l": "vi", "t": {} }, { "l": "zh_CN", "t": {} }, { "l": "zh_HK", "t": {} }, { "l": "zh_TW", "t": {} }, { "l": "zu_ZA", "t": {} }];
const t8 = [{ "l": "af", "t": { "Any link": { "v": [""] } } }, { "l": "ar", "t": { "Any link": { "v": ["أيَّ رابطٍ"] } } }, { "l": "ast", "t": { "Any link": { "v": ["Cualesquier enllaz"] } } }, { "l": "az", "t": { "Any link": { "v": [""] } } }, { "l": "be", "t": { "Any link": { "v": [""] } } }, { "l": "bg", "t": { "Any link": { "v": [""] } } }, { "l": "bn_BD", "t": { "Any link": { "v": [""] } } }, { "l": "br", "t": { "Any link": { "v": [""] } } }, { "l": "bs", "t": { "Any link": { "v": [""] } } }, { "l": "ca", "t": { "Any link": { "v": [""] } } }, { "l": "cs", "t": { "Any link": { "v": ["Jakýkoli odkaz"] } } }, { "l": "cs_CZ", "t": { "Any link": { "v": ["Jakýkoli odkaz"] } } }, { "l": "cy_GB", "t": { "Any link": { "v": [""] } } }, { "l": "da", "t": { "Any link": { "v": ["Ethvert link"] } } }, { "l": "de", "t": { "Any link": { "v": ["Irgendein Link"] } } }, { "l": "de_DE", "t": { "Any link": { "v": ["Irgendein Link"] } } }, { "l": "el", "t": { "Any link": { "v": [""] } } }, { "l": "en_GB", "t": { "Any link": { "v": ["Any link"] } } }, { "l": "eo", "t": { "Any link": { "v": [""] } } }, { "l": "es", "t": { "Any link": { "v": ["Cualquier enlace"] } } }, { "l": "es_419", "t": { "Any link": { "v": [""] } } }, { "l": "es_AR", "t": { "Any link": { "v": ["Cualquier enlace"] } } }, { "l": "es_CL", "t": { "Any link": { "v": [""] } } }, { "l": "es_CO", "t": { "Any link": { "v": [""] } } }, { "l": "es_CR", "t": { "Any link": { "v": [""] } } }, { "l": "es_DO", "t": { "Any link": { "v": [""] } } }, { "l": "es_EC", "t": { "Any link": { "v": ["Cualquier enlace"] } } }, { "l": "es_GT", "t": { "Any link": { "v": [""] } } }, { "l": "es_HN", "t": { "Any link": { "v": [""] } } }, { "l": "es_MX", "t": { "Any link": { "v": ["Cualquier enlace"] } } }, { "l": "es_NI", "t": { "Any link": { "v": [""] } } }, { "l": "es_PA", "t": { "Any link": { "v": [""] } } }, { "l": "es_PE", "t": { "Any link": { "v": [""] } } }, { "l": "es_PR", "t": { "Any link": { "v": [""] } } }, { "l": "es_PY", "t": { "Any link": { "v": [""] } } }, { "l": "es_SV", "t": { "Any link": { "v": [""] } } }, { "l": "es_UY", "t": { "Any link": { "v": [""] } } }, { "l": "et_EE", "t": { "Any link": { "v": [""] } } }, { "l": "eu", "t": { "Any link": { "v": ["Edozein esteka"] } } }, { "l": "fa", "t": { "Any link": { "v": [""] } } }, { "l": "fi", "t": { "Any link": { "v": [""] } } }, { "l": "fo", "t": { "Any link": { "v": [""] } } }, { "l": "fr", "t": { "Any link": { "v": ["N'importe quel lien"] } } }, { "l": "ga", "t": { "Any link": { "v": ["Aon nasc"] } } }, { "l": "gd", "t": { "Any link": { "v": [""] } } }, { "l": "gl", "t": { "Any link": { "v": ["Calquera ligazón"] } } }, { "l": "he", "t": { "Any link": { "v": ["קישור כלשהו"] } } }, { "l": "hi_IN", "t": { "Any link": { "v": [""] } } }, { "l": "hr", "t": { "Any link": { "v": [""] } } }, { "l": "hsb", "t": { "Any link": { "v": [""] } } }, { "l": "hu", "t": { "Any link": { "v": [""] } } }, { "l": "hy", "t": { "Any link": { "v": [""] } } }, { "l": "ia", "t": { "Any link": { "v": [""] } } }, { "l": "id", "t": { "Any link": { "v": ["Semua tautan"] } } }, { "l": "ig", "t": { "Any link": { "v": [""] } } }, { "l": "is", "t": { "Any link": { "v": ["Einhver tengill"] } } }, { "l": "it", "t": { "Any link": { "v": ["Qualsiasi link"] } } }, { "l": "ja", "t": { "Any link": { "v": ["任意のリンク"] } } }, { "l": "ja_JP", "t": { "Any link": { "v": ["任意のリンク"] } } }, { "l": "ka", "t": { "Any link": { "v": [""] } } }, { "l": "ka_GE", "t": { "Any link": { "v": [""] } } }, { "l": "kab", "t": { "Any link": { "v": [""] } } }, { "l": "kk", "t": { "Any link": { "v": [""] } } }, { "l": "km", "t": { "Any link": { "v": [""] } } }, { "l": "kn", "t": { "Any link": { "v": [""] } } }, { "l": "ko", "t": { "Any link": { "v": [""] } } }, { "l": "la", "t": { "Any link": { "v": [""] } } }, { "l": "lb", "t": { "Any link": { "v": [""] } } }, { "l": "lo", "t": { "Any link": { "v": [""] } } }, { "l": "lt_LT", "t": { "Any link": { "v": [""] } } }, { "l": "lv", "t": { "Any link": { "v": [""] } } }, { "l": "mk", "t": { "Any link": { "v": [""] } } }, { "l": "mn", "t": { "Any link": { "v": [""] } } }, { "l": "mr", "t": { "Any link": { "v": [""] } } }, { "l": "ms_MY", "t": { "Any link": { "v": [""] } } }, { "l": "my", "t": { "Any link": { "v": [""] } } }, { "l": "nb", "t": { "Any link": { "v": ["Enhver lenke"] } } }, { "l": "ne", "t": { "Any link": { "v": [""] } } }, { "l": "nl", "t": { "Any link": { "v": ["Elke link"] } } }, { "l": "nn_NO", "t": { "Any link": { "v": [""] } } }, { "l": "oc", "t": { "Any link": { "v": [""] } } }, { "l": "pl", "t": { "Any link": { "v": ["Dowolny link"] } } }, { "l": "ps", "t": { "Any link": { "v": [""] } } }, { "l": "pt_BR", "t": { "Any link": { "v": ["Qualquer link"] } } }, { "l": "pt_PT", "t": { "Any link": { "v": ["Qualquer link"] } } }, { "l": "ro", "t": { "Any link": { "v": ["Orice link"] } } }, { "l": "ru", "t": { "Any link": { "v": ["Любая ссылка"] } } }, { "l": "sc", "t": { "Any link": { "v": [""] } } }, { "l": "si", "t": { "Any link": { "v": [""] } } }, { "l": "sk", "t": { "Any link": { "v": [""] } } }, { "l": "sl", "t": { "Any link": { "v": [""] } } }, { "l": "sq", "t": { "Any link": { "v": [""] } } }, { "l": "sr", "t": { "Any link": { "v": ["Било који линк"] } } }, { "l": "sr@latin", "t": { "Any link": { "v": [""] } } }, { "l": "sv", "t": { "Any link": { "v": ["Vilken länk som helst"] } } }, { "l": "sw", "t": { "Any link": { "v": [""] } } }, { "l": "ta", "t": { "Any link": { "v": [""] } } }, { "l": "th", "t": { "Any link": { "v": [""] } } }, { "l": "tk", "t": { "Any link": { "v": [""] } } }, { "l": "tr", "t": { "Any link": { "v": ["Herhangi bir bağlantı"] } } }, { "l": "ug", "t": { "Any link": { "v": [""] } } }, { "l": "uk", "t": { "Any link": { "v": ["Будь-яке посилання"] } } }, { "l": "ur_PK", "t": { "Any link": { "v": [""] } } }, { "l": "uz", "t": { "Any link": { "v": [""] } } }, { "l": "vi", "t": { "Any link": { "v": [""] } } }, { "l": "zh_CN", "t": { "Any link": { "v": [""] } } }, { "l": "zh_HK", "t": { "Any link": { "v": ["任何連結"] } } }, { "l": "zh_TW", "t": { "Any link": { "v": ["任何連結"] } } }, { "l": "zu_ZA", "t": { "Any link": { "v": [""] } } }];
const t9 = [{ "l": "af", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "ar", "t": { "Anything shared with the same group of people will show up here": { "v": ["أيّ مادة تمت مشاركتها مع نفس المجموعة من الأشخاص سيتم عرضها هنا"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["خطأ في الحصول على الموارد ذات الصلة. يرجى الاتصال بمشرف النظام عندك إذا كان لديك أيّ أسئلة."] }, "Related resources": { "v": ["مصادر ذات صلة"] } } }, { "l": "ast", "t": { "Anything shared with the same group of people will show up here": { "v": ["Equí va apaecer tolo que compartas col mesmu grupu de persones"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Hebo un error al consiguir los recursos rellacionaos. Ponte en contautu col alministrador del sistema si tienes dalguna entruga."] }, "Related resources": { "v": ["Recursos rellacionao"] } } }, { "l": "az", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "be", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "bg", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "bn_BD", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "br", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "bs", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "ca", "t": { "Anything shared with the same group of people will show up here": { "v": ["Qualsevol cosa compartida amb el mateix grup de persones es mostrarà aquí"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": ["Recursos relacionats"] } } }, { "l": "cs", "t": { "Anything shared with the same group of people will show up here": { "v": ["Cokoli nasdíleného stejné skupině lidí se zobrazí zde"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Chyba při získávání souvisejících prostředků. Pokud máte jakékoli dotazy, obraťte se na správce vámi využívaného systému."] }, "Related resources": { "v": ["Související prostředky"] } } }, { "l": "cs_CZ", "t": { "Anything shared with the same group of people will show up here": { "v": ["Cokoli nasdíleného stejné skupině lidí se zobrazí zde"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Chyba při získávání souvisejících prostředků. Pokud máte jakékoli dotazy, obraťte se na správce vámi využívaného systému."] }, "Related resources": { "v": ["Související prostředky"] } } }, { "l": "cy_GB", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "da", "t": { "Anything shared with the same group of people will show up here": { "v": ["Alt der deles med samme gruppe af personer vil vises her"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Fejl ved hentning af relaterede ressourcer. Kontakt venligst din systemadministrator, hvis du har spørgsmål."] }, "Related resources": { "v": ["Relaterede emner"] } } }, { "l": "de", "t": { "Anything shared with the same group of people will show up here": { "v": ["Alles, das mit derselben Gruppe von Personen geteilt wird, wird hier angezeigt"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Fehler beim Abrufen verwandter Ressourcen. Bei Fragen wende dich bitte an deinen Systemadministrator."] }, "Related resources": { "v": ["Verwandte Ressourcen"] } } }, { "l": "de_DE", "t": { "Anything shared with the same group of people will show up here": { "v": ["Alles, das mit derselben Gruppe von Personen geteilt wird, wird hier angezeigt"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Fehler beim Abrufen verwandter Ressourcen. Bei Fragen wenden Sie sich bitte an Ihre Systemadministration."] }, "Related resources": { "v": ["Verwandte Ressourcen"] } } }, { "l": "el", "t": { "Anything shared with the same group of people will show up here": { "v": ["Οτιδήποτε μοιράζεται με την ίδια ομάδα ατόμων θα εμφανίζεται εδώ"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": ["Σχετικοί πόροι"] } } }, { "l": "en_GB", "t": { "Anything shared with the same group of people will show up here": { "v": ["Anything shared with the same group of people will show up here"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Error getting related resources. Please contact your system administrator if you have any questions."] }, "Related resources": { "v": ["Related resources"] } } }, { "l": "eo", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "es", "t": { "Anything shared with the same group of people will show up here": { "v": ["Cualquier cosa que esté compartida con el mismo grupo de personas se mostrará aquí"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Error al obtener recursos relacionados. Por favor, contacte a su administrador del sistema si tiene alguna pregunta."] }, "Related resources": { "v": ["Recursos relacionados"] } } }, { "l": "es_419", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "es_AR", "t": { "Anything shared with the same group of people will show up here": { "v": ["Cualquier cosa compartida con el mismo grupo de personas aparecerá aquí."] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Error al obtener recursos relacionados. Por favor, contacte a su administrador del sistema si tiene alguna pregunta."] }, "Related resources": { "v": ["Recursos relacionados"] } } }, { "l": "es_CL", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "es_CO", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "es_CR", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "es_DO", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "es_EC", "t": { "Anything shared with the same group of people will show up here": { "v": ["Cualquier cosa compartida con el mismo grupo de personas aparecerá aquí."] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Error al obtener recursos relacionados. Por favor, contacta a tu administrador del sistema si tienes alguna pregunta."] }, "Related resources": { "v": ["Recursos relacionados"] } } }, { "l": "es_GT", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "es_HN", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "es_MX", "t": { "Anything shared with the same group of people will show up here": { "v": ["Todo lo que se comparta con el mismo grupo de personas se mostrará aquí"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Error al obtener recursos relacionados. Por favor contacte al administrador si tiene alguna pregunta."] }, "Related resources": { "v": ["Recursos relacionados"] } } }, { "l": "es_NI", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "es_PA", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "es_PE", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "es_PR", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "es_PY", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "es_SV", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "es_UY", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "et_EE", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "eu", "t": { "Anything shared with the same group of people will show up here": { "v": ["Pertsona-talde berarekin partekatutako edozer agertuko da hemen"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Errore bat gertatu da erlazionatutako baliabideak eskuratzean. Jarri harremanetan zure sistemaren administratzailearekin galderarik baduzu."] }, "Related resources": { "v": ["Erlazionatutako baliabideak"] } } }, { "l": "fa", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "fi", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "fo", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "fr", "t": { "Anything shared with the same group of people will show up here": { "v": ["Tout ce qui est partagé avec le même groupe de personnes apparaîtra ici"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Erreur lors de la récupération des ressources liées. Contactez votre administrateur système pour répondre à vos éventuelles questions."] }, "Related resources": { "v": ["Ressources liées"] } } }, { "l": "ga", "t": { "Anything shared with the same group of people will show up here": { "v": ["Taispeánfar aon rud a roinntear leis an ngrúpa céanna daoine anseo"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Earráid agus acmhainní gaolmhara á bhfáil. Déan teagmháil le riarthóir do chórais má tá aon cheist agat."] }, "Related resources": { "v": ["Acmhainní gaolmhara"] } } }, { "l": "gd", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "gl", "t": { "Anything shared with the same group of people will show up here": { "v": ["Todo o que se comparta co mesmo grupo de persoas aparecerá aquí"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Produciuse un erro ao obter os recursos relacionados. Póñase en contacto coa administración do seu sistema se ten algunha dúbida."] }, "Related resources": { "v": ["Recursos relacionados"] } } }, { "l": "he", "t": { "Anything shared with the same group of people will show up here": { "v": ["כל מה שמשותף עם אותה קבוצת האנשים יופיע כאן"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["שגיאה בקבלת המשאבים הקשורים. נא ליצור קשר עם הנהלת המערכת אם יש לך שאלות."] }, "Related resources": { "v": ["משאבים קשורים"] } } }, { "l": "hi_IN", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "hr", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "hsb", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "hu", "t": { "Anything shared with the same group of people will show up here": { "v": ["Minden, amit ugyanazzal a csoporttal oszt meg, itt fog megjelenni"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": ["Kapcsolódó erőforrások"] } } }, { "l": "hy", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "ia", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "id", "t": { "Anything shared with the same group of people will show up here": { "v": ["Apa pun yang dibagikan dengan grup orang yang sama akan muncul di sini"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Kesalahan saat mengambil sumber daya terkait. Hubungi administrator sistem Anda jika ada pertanyaan."] }, "Related resources": { "v": ["Sumber daya terkait"] } } }, { "l": "ig", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "is", "t": { "Anything shared with the same group of people will show up here": { "v": ["Allt sem deilt er með sama hópi fólks mun birtast hér"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Villa við að sækja tengd tilföng. Hafðu samband við kerfisstjórann þinn ef þú ert með einhverjar spurningar."] }, "Related resources": { "v": ["Tengd tilföng"] } } }, { "l": "it", "t": { "Anything shared with the same group of people will show up here": { "v": ["Tutto ciò che è stato condiviso con lo stesso gruppo di persone viene visualizzato qui"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Errore nell'ottenere le risorse correlate. Per qualsiasi domanda, contattare l'amministratore di sistema."] }, "Related resources": { "v": ["Risorse correlate"] } } }, { "l": "ja", "t": { "Anything shared with the same group of people will show up here": { "v": ["同じグループで共有しているものは、全てここに表示されます"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["関連リソースの取得エラー。ご不明な点がございましたら、システム管理者にお問い合わせください。"] }, "Related resources": { "v": ["関連リソース"] } } }, { "l": "ja_JP", "t": { "Anything shared with the same group of people will show up here": { "v": ["同じグループで共有しているものは、全てここに表示されます"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["関連リソースの取得エラー。ご不明な点がございましたら、システム管理者にお問い合わせください。"] }, "Related resources": { "v": ["関連リソース"] } } }, { "l": "ka", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "ka_GE", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "kab", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "kk", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "km", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "kn", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "ko", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "la", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "lb", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "lo", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "lt_LT", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "lv", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "mk", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "mn", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "mr", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "ms_MY", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "my", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "nb", "t": { "Anything shared with the same group of people will show up here": { "v": ["Alt som er delt med den samme gruppen vil vises her"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Feil ved henting av relaterte ressurser. Kontakt systemansvarlig hvis du har spørsmål."] }, "Related resources": { "v": ["Relaterte ressurser"] } } }, { "l": "ne", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "nl", "t": { "Anything shared with the same group of people will show up here": { "v": ["Alles dat gedeeld is met dezelfde groep mensen zal hier getoond worden"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Fout bij het verkrijgen van resources. Neem a.u.b. contact op met uw systeembeheerder als u vragen heeft."] }, "Related resources": { "v": ["Gerelateerde bronnen"] } } }, { "l": "nn_NO", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "oc", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "pl", "t": { "Anything shared with the same group of people will show up here": { "v": ["Tutaj pojawi się wszystko, co zostało udostępnione tej samej grupie osób"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Błąd podczas pobierania powiązanych zasobów. Jeśli masz jakiekolwiek pytania, skontaktuj się z administratorem systemu."] }, "Related resources": { "v": ["Powiązane zasoby"] } } }, { "l": "ps", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "pt_BR", "t": { "Anything shared with the same group of people will show up here": { "v": ["Qualquer coisa compartilhada com o mesmo grupo de pessoas aparecerá aqui"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Erro ao obter recursos relacionados. Por favor entre em contato com o administrador do sistema se tiver alguma dúvida."] }, "Related resources": { "v": ["Recursos relacionados"] } } }, { "l": "pt_PT", "t": { "Anything shared with the same group of people will show up here": { "v": ["Qualquer coisa compartilhada com o mesmo grupo de pessoas aparecerá aqui"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Erro em obter info relacionadas. Por favor contacte o administrador do sistema para esclarecimentos adicionais."] }, "Related resources": { "v": ["Recursos relacionados"] } } }, { "l": "ro", "t": { "Anything shared with the same group of people will show up here": { "v": ["Tot ceea ce este partajat cu același grup de persoane va fi afișat aici"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Eroare la preluarea resurselor adiționale. Vă rugăm să contactați administratorul pentru întrebări."] }, "Related resources": { "v": ["Resurse legate"] } } }, { "l": "ru", "t": { "Anything shared with the same group of people will show up here": { "v": ["Всё, чем поделились с той же группой людей, будет отображаться здесь"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Ошибка при получении связанных ресурсов. Если у вас есть какие-либо вопросы, обратитесь к системному администратору."] }, "Related resources": { "v": ["Связанные ресурсы"] } } }, { "l": "sc", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "si", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "sk", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "sl", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": ["Povezani viri"] } } }, { "l": "sq", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "sr", "t": { "Anything shared with the same group of people will show up here": { "v": ["Све што се дели са истом групом људи ће се појавити овде"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Грешка код прибављања везаних ресурса. Молимо вас да се обратите администратору ако имате питања."] }, "Related resources": { "v": ["Повезани ресурси"] } } }, { "l": "sr@latin", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "sv", "t": { "Anything shared with the same group of people will show up here": { "v": ["Något som delats med samma grupp av personer kommer att visas här"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Det gick inte att hämta relaterade resurser. Kontakta din systemadministratör om du har några frågor."] }, "Related resources": { "v": ["Relaterade resurser"] } } }, { "l": "sw", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "ta", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "th", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "tk", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "tr", "t": { "Anything shared with the same group of people will show up here": { "v": ["Aynı kişi grubu ile paylaşılan herşey burada görüntülenir"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["İlgili kaynaklara ulaşılırken sorun çıktı. Herhangi bir sorunuz varsa lütfen sistem yöneticiniz ile görüşün "] }, "Related resources": { "v": ["İlgili kaynaklar"] } } }, { "l": "ug", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "uk", "t": { "Anything shared with the same group of people will show up here": { "v": ["Будь-що доступне для цієї же групи людей буде показано тут"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["Помилка під час отримання пов'язаних ресурсів. Будь ласка, сконтактуйте з системним адміністратором, якщо у вас виникли запитання."] }, "Related resources": { "v": ["Пов'язані ресурси"] } } }, { "l": "ur_PK", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "uz", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "vi", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }, { "l": "zh_CN", "t": { "Anything shared with the same group of people will show up here": { "v": ["与同组用户分享的所有内容都会显示于此"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": ["相关资源"] } } }, { "l": "zh_HK", "t": { "Anything shared with the same group of people will show up here": { "v": ["與同一組人共享的任何內容都會顯示在此處"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["取得相關資源時發生錯誤。如果有任何問題，請聯絡系統管理員。"] }, "Related resources": { "v": ["相關資源"] } } }, { "l": "zh_TW", "t": { "Anything shared with the same group of people will show up here": { "v": ["與相同群組分享的所有內容都會顯示於此"] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": ["取得相關資源時發生錯誤。如果有任何問題，請聯絡系統管理員。"] }, "Related resources": { "v": ["相關資源"] } } }, { "l": "zu_ZA", "t": { "Anything shared with the same group of people will show up here": { "v": [""] }, "Error getting related resources. Please contact your system administrator if you have any questions.": { "v": [""] }, "Related resources": { "v": [""] } } }];
const t10 = [{ "l": "af", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "ar", "t": { "Avatar of {displayName}": { "v": ["الرمز التجسيدي avatar لــ {displayName}  "] }, "Avatar of {displayName}, {status}": { "v": ["الرمز التجسيدي  avatar لــ {displayName}، {status}"] } } }, { "l": "ast", "t": { "Avatar of {displayName}": { "v": ["Avatar de: {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar de: {displayName}, {status}"] } } }, { "l": "az", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "be", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "bg", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "bn_BD", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "br", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "bs", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "ca", "t": { "Avatar of {displayName}": { "v": ["Avatar de {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar de {displayName}, {status}"] } } }, { "l": "cs", "t": { "Avatar of {displayName}": { "v": ["Zástupný obrázek uživatele {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Zástupný obrázek uživatele {displayName}, {status}"] } } }, { "l": "cs_CZ", "t": { "Avatar of {displayName}": { "v": ["Zástupný obrázek uživatele {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Zástupný obrázek uživatele {displayName}, {status}"] } } }, { "l": "cy_GB", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "da", "t": { "Avatar of {displayName}": { "v": ["Avatar af {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar af {displayName}, {status}"] } } }, { "l": "de", "t": { "Avatar of {displayName}": { "v": ["Avatar von {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar von {displayName}, {status}"] } } }, { "l": "de_DE", "t": { "Avatar of {displayName}": { "v": ["Avatar von {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar von {displayName}, {status}"] } } }, { "l": "el", "t": { "Avatar of {displayName}": { "v": ["Άβαταρ του {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Άβαταρ του {displayName}, {status}"] } } }, { "l": "en_GB", "t": { "Avatar of {displayName}": { "v": ["Avatar of {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar of {displayName}, {status}"] } } }, { "l": "eo", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "es", "t": { "Avatar of {displayName}": { "v": ["Avatar de {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar de {displayName}, {status}"] } } }, { "l": "es_419", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "es_AR", "t": { "Avatar of {displayName}": { "v": ["Avatar de {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar de {displayName}, {status}"] } } }, { "l": "es_CL", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "es_CO", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "es_CR", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "es_DO", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "es_EC", "t": { "Avatar of {displayName}": { "v": ["Avatar de {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar de {displayName}, {status}"] } } }, { "l": "es_GT", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "es_HN", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "es_MX", "t": { "Avatar of {displayName}": { "v": ["Avatar de {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar de {displayName}, {status}"] } } }, { "l": "es_NI", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "es_PA", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "es_PE", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "es_PR", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "es_PY", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "es_SV", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "es_UY", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "et_EE", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "eu", "t": { "Avatar of {displayName}": { "v": ["{displayName}-(e)n irudia"] }, "Avatar of {displayName}, {status}": { "v": ["{displayName} -(e)n irudia, {status}"] } } }, { "l": "fa", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "fi", "t": { "Avatar of {displayName}": { "v": ["Käyttäjän {displayName} avatar"] }, "Avatar of {displayName}, {status}": { "v": ["Käyttäjän {displayName} avatar, {status}"] } } }, { "l": "fo", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "fr", "t": { "Avatar of {displayName}": { "v": ["Avatar de {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar de {displayName}, {status}"] } } }, { "l": "ga", "t": { "Avatar of {displayName}": { "v": ["Avatar de {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar de {displayName}, {status}"] } } }, { "l": "gd", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "gl", "t": { "Avatar of {displayName}": { "v": ["Avatar de {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar de {displayName}, {status}"] } } }, { "l": "he", "t": { "Avatar of {displayName}": { "v": ["תמונה ייצוגית של {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["תמונה ייצוגית של {displayName}, {status}"] } } }, { "l": "hi_IN", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "hr", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "hsb", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "hu", "t": { "Avatar of {displayName}": { "v": ["{displayName} profilképe"] }, "Avatar of {displayName}, {status}": { "v": ["{displayName} profilképe, {status}"] } } }, { "l": "hy", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "ia", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "id", "t": { "Avatar of {displayName}": { "v": ["Avatar {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar {displayName}, {status}"] } } }, { "l": "ig", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "is", "t": { "Avatar of {displayName}": { "v": ["Auðkennismynd fyrir {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Auðkennismynd fyrir {displayName}, {status}"] } } }, { "l": "it", "t": { "Avatar of {displayName}": { "v": ["Avatar di {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar di {displayName}, {status}"] } } }, { "l": "ja", "t": { "Avatar of {displayName}": { "v": ["{displayName} のアバター"] }, "Avatar of {displayName}, {status}": { "v": ["{displayName}, {status} のアバター"] } } }, { "l": "ja_JP", "t": { "Avatar of {displayName}": { "v": ["{displayName} のアバター"] }, "Avatar of {displayName}, {status}": { "v": ["{displayName}, {status} のアバター"] } } }, { "l": "ka", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "ka_GE", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "kab", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "kk", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "km", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "kn", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "ko", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "la", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "lb", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "lo", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "lt_LT", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "lv", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "mk", "t": { "Avatar of {displayName}": { "v": ["Аватар на {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Аватар на {displayName}, {status}"] } } }, { "l": "mn", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "mr", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "ms_MY", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "my", "t": { "Avatar of {displayName}": { "v": ["{displayName} ၏ ကိုယ်ပွား"] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "nb", "t": { "Avatar of {displayName}": { "v": ["Avataren til {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["{displayName}'s avatar, {status}"] } } }, { "l": "ne", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "nl", "t": { "Avatar of {displayName}": { "v": ["Avatar van {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar van {displayName}, {status}"] } } }, { "l": "nn_NO", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "oc", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "pl", "t": { "Avatar of {displayName}": { "v": ["Awatar {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Awatar {displayName}, {status}"] } } }, { "l": "ps", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "pt_BR", "t": { "Avatar of {displayName}": { "v": ["Avatar de {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar de {displayName}, {status}"] } } }, { "l": "pt_PT", "t": { "Avatar of {displayName}": { "v": ["Avatar de {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar de {displayName}, {status}"] } } }, { "l": "ro", "t": { "Avatar of {displayName}": { "v": ["Avatarul lui {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatarul lui {displayName}, {status}"] } } }, { "l": "ru", "t": { "Avatar of {displayName}": { "v": ["Аватар {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Фотография {displayName}, {status}"] } } }, { "l": "sc", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "si", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "sk", "t": { "Avatar of {displayName}": { "v": ["Avatar {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar {displayName}, {status}"] } } }, { "l": "sl", "t": { "Avatar of {displayName}": { "v": ["Podoba {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Prikazna slika {displayName}, {status}"] } } }, { "l": "sq", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "sr", "t": { "Avatar of {displayName}": { "v": ["Аватар за {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Avatar za {displayName}, {status}"] } } }, { "l": "sr@latin", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "sv", "t": { "Avatar of {displayName}": { "v": ["{displayName}s avatar"] }, "Avatar of {displayName}, {status}": { "v": ["{displayName}s avatar, {status}"] } } }, { "l": "sw", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "ta", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "th", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "tk", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "tr", "t": { "Avatar of {displayName}": { "v": ["{displayName} avatarı"] }, "Avatar of {displayName}, {status}": { "v": ["{displayName}, {status} avatarı"] } } }, { "l": "ug", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "uk", "t": { "Avatar of {displayName}": { "v": ["Аватар {displayName}"] }, "Avatar of {displayName}, {status}": { "v": ["Аватар {displayName}, {status}"] } } }, { "l": "ur_PK", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "uz", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "vi", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }, { "l": "zh_CN", "t": { "Avatar of {displayName}": { "v": ["{displayName}的头像"] }, "Avatar of {displayName}, {status}": { "v": ["{displayName}的头像，{status}"] } } }, { "l": "zh_HK", "t": { "Avatar of {displayName}": { "v": ["{displayName} 的頭像"] }, "Avatar of {displayName}, {status}": { "v": ["{displayName} 的頭像，{status}"] } } }, { "l": "zh_TW", "t": { "Avatar of {displayName}": { "v": ["{displayName} 的大頭照"] }, "Avatar of {displayName}, {status}": { "v": ["{displayName}, {status} 的大頭照"] } } }, { "l": "zu_ZA", "t": { "Avatar of {displayName}": { "v": [""] }, "Avatar of {displayName}, {status}": { "v": [""] } } }];
const t11 = [{ "l": "af", "t": {} }, { "l": "ar", "t": { "away": { "v": ["غير موجود"] }, "busy": { "v": ["مشغول"] }, "do not disturb": { "v": ["يُرجى عدم الإزعاج"] }, "invisible": { "v": ["غير مرئي"] }, "offline": { "v": ["غير متصل"] }, "online": { "v": ["مُتّصِلٌ"] } } }, { "l": "ast", "t": { "away": { "v": ["ausente"] }, "busy": { "v": ["ocupáu"] }, "do not disturb": { "v": ["nun molestar"] }, "invisible": { "v": ["invisible"] }, "offline": { "v": ["desconectáu"] }, "online": { "v": ["en llinia"] } } }, { "l": "az", "t": {} }, { "l": "be", "t": {} }, { "l": "bg", "t": {} }, { "l": "bn_BD", "t": {} }, { "l": "br", "t": {} }, { "l": "bs", "t": {} }, { "l": "ca", "t": {} }, { "l": "cs", "t": { "away": { "v": ["pryč"] }, "busy": { "v": ["zaneprádněn(a)"] }, "do not disturb": { "v": ["nerušit"] }, "invisible": { "v": ["neviditelné"] }, "offline": { "v": ["offline"] }, "online": { "v": ["online"] } } }, { "l": "cs_CZ", "t": { "away": { "v": ["pryč"] }, "busy": { "v": ["zaneprádněn(a)"] }, "do not disturb": { "v": ["nerušit"] }, "invisible": { "v": ["neviditelné"] }, "offline": { "v": ["offline"] }, "online": { "v": ["online"] } } }, { "l": "cy_GB", "t": {} }, { "l": "da", "t": { "away": { "v": ["væk"] }, "busy": { "v": ["optaget"] }, "do not disturb": { "v": ["forstyr ikke"] }, "invisible": { "v": ["usynlig"] }, "offline": { "v": ["offline"] }, "online": { "v": ["online"] } } }, { "l": "de", "t": { "away": { "v": ["Abwesend"] }, "busy": { "v": ["Beschäftigt"] }, "do not disturb": { "v": ["Bitte nicht stören"] }, "invisible": { "v": ["Unsichtbar"] }, "offline": { "v": ["Offline"] }, "online": { "v": ["Online"] } } }, { "l": "de_DE", "t": { "away": { "v": ["Abwesend"] }, "busy": { "v": ["Beschäftigt"] }, "do not disturb": { "v": ["Bitte nicht stören"] }, "invisible": { "v": ["Unsichtbar"] }, "offline": { "v": ["Offline"] }, "online": { "v": ["Online"] } } }, { "l": "el", "t": {} }, { "l": "en_GB", "t": { "away": { "v": ["away"] }, "busy": { "v": ["busy"] }, "do not disturb": { "v": ["do not disturb"] }, "invisible": { "v": ["invisible"] }, "offline": { "v": ["offline"] }, "online": { "v": ["online"] } } }, { "l": "eo", "t": {} }, { "l": "es", "t": { "away": { "v": ["ausente"] }, "busy": { "v": ["ocupado"] }, "do not disturb": { "v": ["no molestar"] }, "invisible": { "v": ["invisible"] }, "offline": { "v": ["fuera de línea"] }, "online": { "v": ["en línea"] } } }, { "l": "es_419", "t": {} }, { "l": "es_AR", "t": { "away": { "v": ["ausente"] }, "busy": { "v": ["ocupado"] }, "do not disturb": { "v": ["no molestar"] }, "invisible": { "v": ["invisible"] }, "offline": { "v": ["desconectado"] }, "online": { "v": ["en línea"] } } }, { "l": "es_CL", "t": {} }, { "l": "es_CO", "t": {} }, { "l": "es_CR", "t": {} }, { "l": "es_DO", "t": {} }, { "l": "es_EC", "t": {} }, { "l": "es_GT", "t": {} }, { "l": "es_HN", "t": {} }, { "l": "es_MX", "t": { "away": { "v": ["ausente"] }, "busy": { "v": ["ocupado"] }, "do not disturb": { "v": ["no molestar"] }, "invisible": { "v": ["invisible"] }, "offline": { "v": ["fuera de línea"] }, "online": { "v": ["en línea"] } } }, { "l": "es_NI", "t": {} }, { "l": "es_PA", "t": {} }, { "l": "es_PE", "t": {} }, { "l": "es_PR", "t": {} }, { "l": "es_PY", "t": {} }, { "l": "es_SV", "t": {} }, { "l": "es_UY", "t": {} }, { "l": "et_EE", "t": {} }, { "l": "eu", "t": {} }, { "l": "fa", "t": {} }, { "l": "fi", "t": {} }, { "l": "fo", "t": {} }, { "l": "fr", "t": { "away": { "v": ["absent"] }, "do not disturb": { "v": ["ne pas déranger"] }, "offline": { "v": ["hors ligne"] }, "online": { "v": ["en ligne"] } } }, { "l": "ga", "t": { "away": { "v": ["ar shiúl"] }, "busy": { "v": ["gnóthach"] }, "do not disturb": { "v": ["ná cur as"] }, "invisible": { "v": ["dofheicthe"] }, "offline": { "v": ["as líne"] }, "online": { "v": ["ar líne"] } } }, { "l": "gd", "t": {} }, { "l": "gl", "t": { "away": { "v": ["ausente"] }, "busy": { "v": ["ocupado"] }, "do not disturb": { "v": ["non molestar"] }, "invisible": { "v": ["invisíbel"] }, "offline": { "v": ["desconectado"] }, "online": { "v": ["conectado"] } } }, { "l": "he", "t": {} }, { "l": "hi_IN", "t": {} }, { "l": "hr", "t": {} }, { "l": "hsb", "t": {} }, { "l": "hu", "t": {} }, { "l": "hy", "t": {} }, { "l": "ia", "t": {} }, { "l": "id", "t": { "away": { "v": ["tidak tersedia"] }, "do not disturb": { "v": ["jangan ganggu"] }, "offline": { "v": ["luring"] }, "online": { "v": ["daring"] } } }, { "l": "ig", "t": {} }, { "l": "is", "t": { "away": { "v": ["í burtu"] }, "do not disturb": { "v": ["ekki ónáða"] }, "offline": { "v": ["ónettengt"] }, "online": { "v": ["nettengt"] } } }, { "l": "it", "t": { "away": { "v": ["via"] }, "do not disturb": { "v": ["non disturbare"] }, "offline": { "v": ["offline"] }, "online": { "v": ["online"] } } }, { "l": "ja", "t": { "away": { "v": ["離れる"] }, "busy": { "v": ["ビジー"] }, "do not disturb": { "v": ["邪魔をしないでください"] }, "invisible": { "v": ["不可視"] }, "offline": { "v": ["オフライン"] }, "online": { "v": ["オンライン"] } } }, { "l": "ja_JP", "t": { "away": { "v": ["離れる"] }, "busy": { "v": ["ビジー"] }, "do not disturb": { "v": ["邪魔をしないでください"] }, "invisible": { "v": ["不可視"] }, "offline": { "v": ["オフライン"] }, "online": { "v": ["オンライン"] } } }, { "l": "ka", "t": {} }, { "l": "ka_GE", "t": {} }, { "l": "kab", "t": {} }, { "l": "kk", "t": {} }, { "l": "km", "t": {} }, { "l": "kn", "t": {} }, { "l": "ko", "t": {} }, { "l": "la", "t": {} }, { "l": "lb", "t": {} }, { "l": "lo", "t": {} }, { "l": "lt_LT", "t": {} }, { "l": "lv", "t": {} }, { "l": "mk", "t": {} }, { "l": "mn", "t": {} }, { "l": "mr", "t": {} }, { "l": "ms_MY", "t": {} }, { "l": "my", "t": {} }, { "l": "nb", "t": { "away": { "v": ["borte"] }, "busy": { "v": ["opptatt"] }, "do not disturb": { "v": ["ikke forstyrr"] }, "invisible": { "v": ["usynlig"] }, "offline": { "v": ["frakoblet"] }, "online": { "v": ["tilkoblet"] } } }, { "l": "ne", "t": {} }, { "l": "nl", "t": { "away": { "v": ["weg"] }, "busy": { "v": ["bezig"] }, "do not disturb": { "v": ["niet storen"] }, "invisible": { "v": ["Onzichtbaar"] }, "offline": { "v": ["offline"] }, "online": { "v": ["online"] } } }, { "l": "nn_NO", "t": {} }, { "l": "oc", "t": {} }, { "l": "pl", "t": { "away": { "v": ["stąd"] }, "busy": { "v": ["zajęty"] }, "do not disturb": { "v": ["nie przeszkadzać"] }, "invisible": { "v": ["niewidzialny"] }, "offline": { "v": ["offline"] }, "online": { "v": ["online"] } } }, { "l": "ps", "t": {} }, { "l": "pt_BR", "t": { "away": { "v": ["ausente"] }, "busy": { "v": ["ocupado"] }, "do not disturb": { "v": ["não perturbe"] }, "invisible": { "v": ["invisível"] }, "offline": { "v": ["desligada"] }, "online": { "v": ["ligado"] } } }, { "l": "pt_PT", "t": {} }, { "l": "ro", "t": { "away": { "v": ["plecat"] }, "do not disturb": { "v": ["nu deranjați"] }, "offline": { "v": ["deconectat"] }, "online": { "v": ["online"] } } }, { "l": "ru", "t": { "away": { "v": ["отсутствие"] }, "do not disturb": { "v": ["не беспокоить"] }, "offline": { "v": ["офлайн"] }, "online": { "v": ["онлайн"] } } }, { "l": "sc", "t": {} }, { "l": "si", "t": {} }, { "l": "sk", "t": {} }, { "l": "sl", "t": {} }, { "l": "sq", "t": {} }, { "l": "sr", "t": { "away": { "v": ["одсутан"] }, "busy": { "v": ["заузет"] }, "do not disturb": { "v": ["не узнемиравај"] }, "invisible": { "v": ["невидљиво"] }, "offline": { "v": ["ван мреже"] }, "online": { "v": ["на мрежи"] } } }, { "l": "sr@latin", "t": {} }, { "l": "sv", "t": { "away": { "v": ["borta"] }, "busy": { "v": ["upptagen"] }, "do not disturb": { "v": ["stör ej"] }, "invisible": { "v": ["osynlig"] }, "offline": { "v": ["offline"] }, "online": { "v": ["online"] } } }, { "l": "sw", "t": {} }, { "l": "ta", "t": {} }, { "l": "th", "t": {} }, { "l": "tk", "t": {} }, { "l": "tr", "t": { "away": { "v": ["Uzakta"] }, "busy": { "v": ["meşgul"] }, "do not disturb": { "v": ["Rahatsız etmeyin"] }, "invisible": { "v": ["görünmez"] }, "offline": { "v": ["Çevrim dışı"] }, "online": { "v": ["Çevrim içi"] } } }, { "l": "ug", "t": {} }, { "l": "uk", "t": { "away": { "v": ["відсутній"] }, "busy": { "v": ["зайнято"] }, "do not disturb": { "v": ["не турбувати"] }, "invisible": { "v": ["Невидимий"] }, "offline": { "v": ["не в мережі"] }, "online": { "v": ["в мережі"] } } }, { "l": "ur_PK", "t": {} }, { "l": "uz", "t": {} }, { "l": "vi", "t": {} }, { "l": "zh_CN", "t": {} }, { "l": "zh_HK", "t": { "away": { "v": ["離開"] }, "do not disturb": { "v": ["請勿打擾"] }, "offline": { "v": ["離線"] }, "online": { "v": ["在線"] } } }, { "l": "zh_TW", "t": {} }, { "l": "zu_ZA", "t": {} }];
const t12 = [{ "l": "af", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "ar", "t": { "Back to provider selection": { "v": ["عودة إلى اختيار المُزوِّد"] }, "Close Smart Picker": { "v": ["أغلِق Smart Picker"] }, "Smart Picker": { "v": ["اللاقط الذكي smart picker"] } } }, { "l": "ast", "t": { "Back to provider selection": { "v": ["Volver a la seleición de fornidores"] }, "Close Smart Picker": { "v": ["Zarrar la seleición intelixente"] }, "Smart Picker": { "v": ["Selector intelixente"] } } }, { "l": "az", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "be", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "bg", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "bn_BD", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "br", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "bs", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "ca", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "cs", "t": { "Back to provider selection": { "v": ["Zpět na výběr poskytovatele"] }, "Close Smart Picker": { "v": ["Zavřít inteligentní výběr"] }, "Smart Picker": { "v": ["Inteligentní výběr"] } } }, { "l": "cs_CZ", "t": { "Back to provider selection": { "v": ["Zpět na výběr poskytovatele"] }, "Close Smart Picker": { "v": ["Zavřít inteligentní výběr"] }, "Smart Picker": { "v": ["Inteligentní výběr"] } } }, { "l": "cy_GB", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "da", "t": { "Back to provider selection": { "v": ["Tilbage til udbydervalg"] }, "Close Smart Picker": { "v": ["Luk Smart Vælger"] }, "Smart Picker": { "v": ["Smart Vælger"] } } }, { "l": "de", "t": { "Back to provider selection": { "v": ["Zurück zur Anbieterauswahl"] }, "Close Smart Picker": { "v": ["Smart Picker schließen"] }, "Smart Picker": { "v": ["Smart Picker"] } } }, { "l": "de_DE", "t": { "Back to provider selection": { "v": ["Zurück zur Anbieterauswahl"] }, "Close Smart Picker": { "v": ["Smart Picker schließen"] }, "Smart Picker": { "v": ["Smart Picker"] } } }, { "l": "el", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "en_GB", "t": { "Back to provider selection": { "v": ["Back to provider selection"] }, "Close Smart Picker": { "v": ["Close Smart Picker"] }, "Smart Picker": { "v": ["Smart Picker"] } } }, { "l": "eo", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "es", "t": { "Back to provider selection": { "v": ["Volver a la selección de proveedor"] }, "Close Smart Picker": { "v": ["Cerrar selector inteligente"] }, "Smart Picker": { "v": ["Selector inteligente"] } } }, { "l": "es_419", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "es_AR", "t": { "Back to provider selection": { "v": ["Volver a la selección de proveedor"] }, "Close Smart Picker": { "v": ["Cerrar selector inteligente"] }, "Smart Picker": { "v": ["Selector inteligente"] } } }, { "l": "es_CL", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "es_CO", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "es_CR", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "es_DO", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "es_EC", "t": { "Back to provider selection": { "v": ["Volver a la selección de proveedor"] }, "Close Smart Picker": { "v": ["Cerrar selector inteligente"] }, "Smart Picker": { "v": ["Selector inteligente"] } } }, { "l": "es_GT", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "es_HN", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "es_MX", "t": { "Back to provider selection": { "v": ["Volver a la selección de proveedor"] }, "Close Smart Picker": { "v": ["Cerrar selector inteligente"] }, "Smart Picker": { "v": ["Selector inteligente"] } } }, { "l": "es_NI", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "es_PA", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "es_PE", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "es_PR", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "es_PY", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "es_SV", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "es_UY", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "et_EE", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "eu", "t": { "Back to provider selection": { "v": ["Itzuli hornitzaileen hautapenera"] }, "Close Smart Picker": { "v": ["Itxi hautatzaile adimenduna"] }, "Smart Picker": { "v": ["Hautatzaile adimenduna"] } } }, { "l": "fa", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "fi", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "fo", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "fr", "t": { "Back to provider selection": { "v": ["Revenir à la sélection du fournisseur"] }, "Close Smart Picker": { "v": ["Fermer le sélecteur intelligent"] }, "Smart Picker": { "v": ["Sélecteur intelligent"] } } }, { "l": "ga", "t": { "Back to provider selection": { "v": ["Ar ais go roghnú soláthróra"] }, "Close Smart Picker": { "v": ["Dún Piocálaí Cliste"] }, "Smart Picker": { "v": ["Roghnóir Cliste"] } } }, { "l": "gd", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "gl", "t": { "Back to provider selection": { "v": ["Volver á selección do provedor"] }, "Close Smart Picker": { "v": ["Pechar o Selector intelixente"] }, "Smart Picker": { "v": ["Selector intelixente"] } } }, { "l": "he", "t": { "Back to provider selection": { "v": ["חזרה לבחירת ספק"] }, "Close Smart Picker": { "v": ["סגירת הבורר החכם"] }, "Smart Picker": { "v": ["בורר חכם"] } } }, { "l": "hi_IN", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "hr", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "hsb", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "hu", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "hy", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "ia", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "id", "t": { "Back to provider selection": { "v": ["Kembali ke pemilihan penyedia"] }, "Close Smart Picker": { "v": ["Tutup Pemilih Cerdas"] }, "Smart Picker": { "v": ["Pemilih Cerdas"] } } }, { "l": "ig", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "is", "t": { "Back to provider selection": { "v": ["Til baka í val á þjónustuveitu"] }, "Close Smart Picker": { "v": ["Loka snjall-veljara"] }, "Smart Picker": { "v": ["Snjall-veljari"] } } }, { "l": "it", "t": { "Back to provider selection": { "v": ["Torna alla selezione del provider"] }, "Close Smart Picker": { "v": ["Chiudere lo Smart Picker"] }, "Smart Picker": { "v": ["Picker intelligente"] } } }, { "l": "ja", "t": { "Back to provider selection": { "v": ["プロバイダーの選択に戻る"] }, "Close Smart Picker": { "v": ["スマートピッカーを閉じる"] }, "Smart Picker": { "v": ["スマートピッカー"] } } }, { "l": "ja_JP", "t": { "Back to provider selection": { "v": ["プロバイダーの選択に戻る"] }, "Close Smart Picker": { "v": ["スマートピッカーを閉じる"] }, "Smart Picker": { "v": ["スマートピッカー"] } } }, { "l": "ka", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "ka_GE", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "kab", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "kk", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "km", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "kn", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "ko", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "la", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "lb", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "lo", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "lt_LT", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "lv", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "mk", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "mn", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "mr", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "ms_MY", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "my", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "nb", "t": { "Back to provider selection": { "v": ["Tilbake til leverandørvalg"] }, "Close Smart Picker": { "v": ["Lukk Smart Velger"] }, "Smart Picker": { "v": ["Smart Velger"] } } }, { "l": "ne", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "nl", "t": { "Back to provider selection": { "v": ["Terug naar provider selectie"] }, "Close Smart Picker": { "v": ["Sluit Slimme Kiezer"] }, "Smart Picker": { "v": ["Slimme Kiezer"] } } }, { "l": "nn_NO", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "oc", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "pl", "t": { "Back to provider selection": { "v": ["Powrót do wyboru dostawcy"] }, "Close Smart Picker": { "v": ["Zamknij inteligentny selektor"] }, "Smart Picker": { "v": ["Inteligentne wybieranie"] } } }, { "l": "ps", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "pt_BR", "t": { "Back to provider selection": { "v": ["Voltar para seleção de provedor"] }, "Close Smart Picker": { "v": ["Fechar Seletor Inteligente"] }, "Smart Picker": { "v": ["Seletor Inteligente"] } } }, { "l": "pt_PT", "t": { "Back to provider selection": { "v": ["Voltar à seleção de fornecedor"] }, "Close Smart Picker": { "v": ['Fechar "Smart Picker"'] }, "Smart Picker": { "v": ["Smart Picker"] } } }, { "l": "ro", "t": { "Back to provider selection": { "v": ["Înapoi la selecția providerului"] }, "Close Smart Picker": { "v": ["Închide Smart Picker"] }, "Smart Picker": { "v": ["Smart Picker"] } } }, { "l": "ru", "t": { "Back to provider selection": { "v": ["Вернуться к выбору провайдера"] }, "Close Smart Picker": { "v": ["Закрыть интеллектуальный выбор"] }, "Smart Picker": { "v": ["Умный выбор"] } } }, { "l": "sc", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "si", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "sk", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "sl", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "sq", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "sr", "t": { "Back to provider selection": { "v": ["Назад на избор пружаоца"] }, "Close Smart Picker": { "v": ["Затвори паметни бирач"] }, "Smart Picker": { "v": ["Паметни бирач"] } } }, { "l": "sr@latin", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "sv", "t": { "Back to provider selection": { "v": ["Tillbaka till leverantörsval"] }, "Close Smart Picker": { "v": ["Stäng Smart Picker"] }, "Smart Picker": { "v": ["Smart Picker"] } } }, { "l": "sw", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "ta", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "th", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "tk", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "tr", "t": { "Back to provider selection": { "v": ["Sağlayıcı seçimine dön"] }, "Close Smart Picker": { "v": ["Akıllı seçimi kapat"] }, "Smart Picker": { "v": ["Akıllı seçim"] } } }, { "l": "ug", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "uk", "t": { "Back to provider selection": { "v": ["Назад до вибору постачальника"] }, "Close Smart Picker": { "v": ["Закрити асистент вибору"] }, "Smart Picker": { "v": ["Асистент вибору"] } } }, { "l": "ur_PK", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "uz", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "vi", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "zh_CN", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }, { "l": "zh_HK", "t": { "Back to provider selection": { "v": ["回到提供者選擇"] }, "Close Smart Picker": { "v": ["關閉 Smart Picker"] }, "Smart Picker": { "v": ["Smart Picker"] } } }, { "l": "zh_TW", "t": { "Back to provider selection": { "v": ["回到提供者選擇"] }, "Close Smart Picker": { "v": ["關閉智慧型挑選器"] }, "Smart Picker": { "v": ["智慧型挑選器"] } } }, { "l": "zu_ZA", "t": { "Back to provider selection": { "v": [""] }, "Close Smart Picker": { "v": [""] }, "Smart Picker": { "v": [""] } } }];
const t13 = [{ "l": "af", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "ar", "t": { "Cancel changes": { "v": ["إلغاء التغييرات"] }, "Confirm changes": { "v": ["تأكيد التغييرات"] } } }, { "l": "ast", "t": { "Cancel changes": { "v": ["Encaboxar los cambeos"] }, "Confirm changes": { "v": ["Confirmar los cambeos"] } } }, { "l": "az", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "be", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "bg", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "bn_BD", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "br", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "bs", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "ca", "t": { "Cancel changes": { "v": ["Cancel·la els canvis"] }, "Confirm changes": { "v": ["Confirmeu els canvis"] } } }, { "l": "cs", "t": { "Cancel changes": { "v": ["Zrušit změny"] }, "Confirm changes": { "v": ["Potvrdit změny"] } } }, { "l": "cs_CZ", "t": { "Cancel changes": { "v": ["Zrušit změny"] }, "Confirm changes": { "v": ["Potvrdit změny"] } } }, { "l": "cy_GB", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "da", "t": { "Cancel changes": { "v": ["Annuller ændringer"] }, "Confirm changes": { "v": ["Bekræft ændringer"] } } }, { "l": "de", "t": { "Cancel changes": { "v": ["Änderungen verwerfen"] }, "Confirm changes": { "v": ["Änderungen bestätigen"] } } }, { "l": "de_DE", "t": { "Cancel changes": { "v": ["Änderungen verwerfen"] }, "Confirm changes": { "v": ["Änderungen bestätigen"] } } }, { "l": "el", "t": { "Cancel changes": { "v": ["Ακύρωση αλλαγών"] }, "Confirm changes": { "v": ["Επιβεβαίωση αλλαγών"] } } }, { "l": "en_GB", "t": { "Cancel changes": { "v": ["Cancel changes"] }, "Confirm changes": { "v": ["Confirm changes"] } } }, { "l": "eo", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "es", "t": { "Cancel changes": { "v": ["Cancelar cambios"] }, "Confirm changes": { "v": ["Confirmar cambios"] } } }, { "l": "es_419", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "es_AR", "t": { "Cancel changes": { "v": ["Cancelar cambios"] }, "Confirm changes": { "v": ["Confirmar cambios"] } } }, { "l": "es_CL", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "es_CO", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "es_CR", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "es_DO", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "es_EC", "t": { "Cancel changes": { "v": ["Cancelar cambios"] }, "Confirm changes": { "v": ["Confirmar cambios"] } } }, { "l": "es_GT", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "es_HN", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "es_MX", "t": { "Cancel changes": { "v": ["Cancelar cambios"] }, "Confirm changes": { "v": ["Confirmar cambios"] } } }, { "l": "es_NI", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "es_PA", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "es_PE", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "es_PR", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "es_PY", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "es_SV", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "es_UY", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "et_EE", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "eu", "t": { "Cancel changes": { "v": ["Ezeztatu aldaketak"] }, "Confirm changes": { "v": ["Baieztatu aldaketak"] } } }, { "l": "fa", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "fi", "t": { "Cancel changes": { "v": ["Peruuta muutokset"] }, "Confirm changes": { "v": ["Vahvista muutokset"] } } }, { "l": "fo", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "fr", "t": { "Cancel changes": { "v": ["Annuler les modifications"] }, "Confirm changes": { "v": ["Confirmer les modifications"] } } }, { "l": "ga", "t": { "Cancel changes": { "v": ["Cealaigh athruithe"] }, "Confirm changes": { "v": ["Deimhnigh na hathruithe"] } } }, { "l": "gd", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "gl", "t": { "Cancel changes": { "v": ["Cancelar os cambios"] }, "Confirm changes": { "v": ["Confirma os cambios"] } } }, { "l": "he", "t": { "Cancel changes": { "v": ["ביטול שינויים"] }, "Confirm changes": { "v": ["אישור השינויים"] } } }, { "l": "hi_IN", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "hr", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "hsb", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "hu", "t": { "Cancel changes": { "v": ["Változtatások elvetése"] }, "Confirm changes": { "v": ["Változtatások megerősítése"] } } }, { "l": "hy", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "ia", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "id", "t": { "Cancel changes": { "v": ["Batalkan perubahan"] }, "Confirm changes": { "v": ["Konfirmasikan perubahan"] } } }, { "l": "ig", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "is", "t": { "Cancel changes": { "v": ["Hætta við breytingar"] }, "Confirm changes": { "v": ["Staðfesta breytingar"] } } }, { "l": "it", "t": { "Cancel changes": { "v": ["Annulla modifiche"] }, "Confirm changes": { "v": ["Conferma modifiche"] } } }, { "l": "ja", "t": { "Cancel changes": { "v": ["変更をキャンセル"] }, "Confirm changes": { "v": ["変更を承認"] } } }, { "l": "ja_JP", "t": { "Cancel changes": { "v": ["変更をキャンセル"] }, "Confirm changes": { "v": ["変更を承認"] } } }, { "l": "ka", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "ka_GE", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "kab", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "kk", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "km", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "kn", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "ko", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "la", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "lb", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "lo", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "lt_LT", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "lv", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "mk", "t": { "Cancel changes": { "v": ["Откажи ги промените"] }, "Confirm changes": { "v": ["Потврди ги промените"] } } }, { "l": "mn", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "mr", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "ms_MY", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "my", "t": { "Cancel changes": { "v": ["ပြောင်းလဲမှုများ ပယ်ဖျက်ရန်"] }, "Confirm changes": { "v": ["ပြောင်းလဲမှုများ အတည်ပြုရန်"] } } }, { "l": "nb", "t": { "Cancel changes": { "v": ["Avbryt endringer"] }, "Confirm changes": { "v": ["Bekreft endringer"] } } }, { "l": "ne", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "nl", "t": { "Cancel changes": { "v": ["Wijzigingen annuleren"] }, "Confirm changes": { "v": ["Wijzigingen bevestigen"] } } }, { "l": "nn_NO", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "oc", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "pl", "t": { "Cancel changes": { "v": ["Anuluj zmiany"] }, "Confirm changes": { "v": ["Potwierdź zmiany"] } } }, { "l": "ps", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "pt_BR", "t": { "Cancel changes": { "v": ["Cancelar alterações"] }, "Confirm changes": { "v": ["Confirmar alterações"] } } }, { "l": "pt_PT", "t": { "Cancel changes": { "v": ["Cancelar alterações"] }, "Confirm changes": { "v": ["Confirmar alterações"] } } }, { "l": "ro", "t": { "Cancel changes": { "v": ["Anulează modificările"] }, "Confirm changes": { "v": ["Confirmați modificările"] } } }, { "l": "ru", "t": { "Cancel changes": { "v": ["Отменить изменения"] }, "Confirm changes": { "v": ["Подтвердить изменения"] } } }, { "l": "sc", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "si", "t": { "Cancel changes": { "v": [""] }, "Confirm changes": { "v": [""] } } }, { "l": "sk", "t": { "Cancel changes": { "v": ["Zrušiť zme