/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import java.util.List;
import org.wiztools.restclient.bean.HTTPAuthMethod;

public class AuthHelper {
    public static final String NONE = "None";
    public static final String BASIC = "BASIC";
    public static final String DIGEST = "DIGEST";
    public static final String NTLM = "NTLM";
    public static final String OAUTH2_BEARER = "OAuth2 Bearer";
    private static final String[] ALL = new String[]{"None", "BASIC", "DIGEST", "NTLM", "OAuth2 Bearer"};

    public static String[] getAll() {
        return ALL;
    }

    public static boolean isBasicOrDigest(List<HTTPAuthMethod> authMethods) {
        return authMethods.contains((Object)HTTPAuthMethod.BASIC) || authMethods.contains((Object)HTTPAuthMethod.DIGEST);
    }

    public static boolean isNtlm(List<HTTPAuthMethod> authMethods) {
        return authMethods.contains((Object)HTTPAuthMethod.NTLM);
    }

    public static boolean isBearer(List<HTTPAuthMethod> authMethods) {
        return authMethods.contains((Object)HTTPAuthMethod.OAUTH_20_BEARER);
    }

    public static boolean isNone(String input) {
        return NONE.equals(input);
    }

    public static boolean isBasicOrDigest(String input) {
        return AuthHelper.isBasic(input) || AuthHelper.isDigest(input);
    }

    public static boolean isBasic(String input) {
        return BASIC.equals(input);
    }

    public static boolean isDigest(String input) {
        return DIGEST.equals(input);
    }

    public static boolean isNtlm(String input) {
        return NTLM.equals(input);
    }

    public static boolean isBearer(String input) {
        return OAUTH2_BEARER.equals(input);
    }
}

