/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.upgrade;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.FileStatusResultParser;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandAdapter;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.upgrade.UpgradeClient;

public class CmdUpgradeClient
extends BaseSvnClient
implements UpgradeClient {
    private static final String STATUS = "\\s*(.+?)\\s*";
    private static final String PATH = "\\s*'(.*?)'\\s*";
    private static final Pattern CHANGED_PATH = Pattern.compile("\\s*(.+?)\\s*\\s*'(.*?)'\\s*");

    @Override
    public void upgrade(@NotNull File path, @NotNull WorkingCopyFormat format, @Nullable ProgressTracker handler) throws VcsException {
        if (path == null) {
            CmdUpgradeClient.$$$reportNull$$$0(0);
        }
        if (format == null) {
            CmdUpgradeClient.$$$reportNull$$$0(1);
        }
        this.validateFormat(format, this.getSupportedFormats());
        CmdUpgradeClient.callHandler(handler, CmdUpgradeClient.createEvent(path, EventAction.UPDATE_COMPLETED));
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, path);
        FileStatusResultParser parser = new FileStatusResultParser(CHANGED_PATH, handler, new UpgradeStatusConvertor());
        UpgradeLineCommandListener listener = new UpgradeLineCommandListener(parser);
        this.execute(this.myVcs, Target.on(path), SvnCommandName.upgrade, parameters, (LineCommandListener)listener);
        listener.throwIfException();
    }

    @Override
    public List<WorkingCopyFormat> getSupportedFormats() throws VcsException {
        ArrayList<WorkingCopyFormat> result = new ArrayList<WorkingCopyFormat>();
        result.add(WorkingCopyFormat.from(this.myFactory.createVersionClient().getVersion()));
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "path";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "format";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/svn/upgrade/CmdUpgradeClient";
        objectArray[2] = "upgrade";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class UpgradeLineCommandListener
    extends LineCommandAdapter {
        @NotNull
        private final FileStatusResultParser parser;
        @NotNull
        private final AtomicReference<VcsException> exception;

        private UpgradeLineCommandListener(@NotNull FileStatusResultParser parser) {
            if (parser == null) {
                UpgradeLineCommandListener.$$$reportNull$$$0(0);
            }
            this.parser = parser;
            this.exception = new AtomicReference();
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            if (ProcessOutputTypes.STDOUT.equals((Object)outputType)) {
                try {
                    this.parser.onLine(line);
                }
                catch (VcsException e) {
                    this.exception.set(e);
                }
            }
        }

        public void throwIfException() throws VcsException {
            VcsException e = this.exception.get();
            if (e != null) {
                throw e;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "org/jetbrains/idea/svn/upgrade/CmdUpgradeClient$UpgradeLineCommandListener", "<init>"));
        }
    }

    private static class UpgradeStatusConvertor
    implements Convertor<Matcher, ProgressEvent> {
        private UpgradeStatusConvertor() {
        }

        public ProgressEvent convert(@NotNull Matcher matcher) {
            if (matcher == null) {
                UpgradeStatusConvertor.$$$reportNull$$$0(0);
            }
            String statusMessage = matcher.group(1);
            String path = matcher.group(2);
            return CmdUpgradeClient.createEvent(new File(path), UpgradeStatusConvertor.createAction(statusMessage));
        }

        @Nullable
        public static EventAction createAction(@NotNull String code) {
            if (code == null) {
                UpgradeStatusConvertor.$$$reportNull$$$0(1);
            }
            EventAction result = null;
            if ("Upgraded".equals(code)) {
                result = EventAction.UPGRADED_PATH;
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/svn/upgrade/CmdUpgradeClient$UpgradeStatusConvertor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "convert";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

