/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLink;
import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.settings.DockerExtraHost;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerContainerSettings
implements PersistentStateComponent<DockerContainerSettings>,
Cloneable {
    public static final Key<DockerContainerSettings> KEY = Key.create((String)"DOCKER_RUN_CONTAINER_SETTINGS");
    public static final String BRIDGE_NETWORK_MODE = "bridge";
    public static final String DEFAULT_NETWORK_MODE = "bridge";
    public static final int VERSION_0 = 0;
    public static final int VERSION_1 = 1;
    private int myVersion = 0;
    private List<DockerPortBindingImpl> myPortBindings = ContainerUtil.newArrayList();
    private boolean myPublishAllPorts;
    private List<DockerLinkImpl> myLinks = ContainerUtil.newArrayList();
    private List<DockerVolumeBindingImpl> myVolumeBindings = ContainerUtil.newArrayList();
    private List<DockerEnvVarImpl> myEnvVars = ContainerUtil.newArrayList();
    private List<DockerExtraHost> myExtraHosts = ContainerUtil.newArrayList();
    private String myNetworkMode = "bridge";
    private boolean myNetworkDisabled;

    @NotNull
    public List<DockerPortBindingImpl> getPortBindings() {
        if (this.myPortBindings == null) {
            this.myPortBindings = ContainerUtil.newArrayList();
        }
        List<DockerPortBindingImpl> list = this.myPortBindings;
        if (list == null) {
            DockerContainerSettings.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void setPortBindings(List<DockerPortBindingImpl> portBindings) {
        this.myPortBindings = portBindings;
    }

    public boolean isPublishAllPorts() {
        return this.myPublishAllPorts;
    }

    public void setPublishAllPorts(boolean publishAllPorts) {
        this.myPublishAllPorts = publishAllPorts;
    }

    @NotNull
    public List<DockerLinkImpl> getLinks() {
        if (this.myLinks == null) {
            this.myLinks = ContainerUtil.newArrayList();
        }
        List<DockerLinkImpl> list = this.myLinks;
        if (list == null) {
            DockerContainerSettings.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void setLinks(List<DockerLinkImpl> links) {
        this.myLinks = links;
    }

    @NotNull
    public List<DockerVolumeBindingImpl> getVolumeBindings() {
        if (this.myVolumeBindings == null) {
            this.myVolumeBindings = ContainerUtil.newArrayList();
        }
        List<DockerVolumeBindingImpl> list = this.myVolumeBindings;
        if (list == null) {
            DockerContainerSettings.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void setVolumeBindings(List<DockerVolumeBindingImpl> volumeBindings) {
        this.myVolumeBindings = volumeBindings;
    }

    @NotNull
    public List<DockerEnvVarImpl> getEnvVars() {
        if (this.myEnvVars == null) {
            this.myEnvVars = ContainerUtil.newArrayList();
        }
        List<DockerEnvVarImpl> list = this.myEnvVars;
        if (list == null) {
            DockerContainerSettings.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setEnvVars(List<DockerEnvVarImpl> envVars) {
        this.myEnvVars = envVars;
    }

    public List<DockerExtraHost> getExtraHosts() {
        if (this.myExtraHosts == null) {
            this.myExtraHosts = ContainerUtil.newArrayList();
        }
        return this.myExtraHosts;
    }

    public void setExtraHosts(List<DockerExtraHost> extraHosts) {
        this.myExtraHosts = extraHosts;
    }

    @Nullable
    public String getNetworkMode() {
        return this.myNetworkMode;
    }

    public void setNetworkMode(@Nullable String networkMode) {
        this.myNetworkMode = networkMode;
    }

    public boolean isNetworkDisabled() {
        return this.myNetworkDisabled;
    }

    public void setNetworkDisabled(boolean networkDisabled) {
        this.myNetworkDisabled = networkDisabled;
    }

    public int getVersion() {
        return this.myVersion;
    }

    public void setVersion(int version) {
        this.myVersion = version;
    }

    public void copyTo(@NotNull DockerContainerSettings other) {
        if (other == null) {
            DockerContainerSettings.$$$reportNull$$$0(4);
        }
        other.setPortBindings(ContainerUtil.map(this.getPortBindings(), binding -> new DockerPortBindingImpl((DockerPortBinding)binding)));
        other.setPublishAllPorts(this.isPublishAllPorts());
        other.setLinks(ContainerUtil.map(this.getLinks(), link -> new DockerLinkImpl((DockerLink)link)));
        List mapped = ContainerUtil.map(this.getVolumeBindings(), binding -> new DockerVolumeBindingImpl((DockerVolumeBinding)binding));
        other.setVolumeBindings(mapped.isEmpty() ? ContainerUtil.newArrayList() : mapped);
        other.setNetworkMode(this.getNetworkMode());
        other.setNetworkDisabled(this.isNetworkDisabled());
        other.setEnvVars(ContainerUtil.map(this.getEnvVars(), var -> new DockerEnvVarImpl((DockerEnvVar)var)));
        other.setExtraHosts(ContainerUtil.map(this.getExtraHosts(), host -> new DockerExtraHost((DockerExtraHost)host)));
        other.setVersion(this.getVersion());
    }

    public DockerContainerSettings clone() {
        DockerContainerSettings copy = new DockerContainerSettings();
        this.copyTo(copy);
        return copy;
    }

    @Nullable
    public DockerContainerSettings getState() {
        return this;
    }

    public void loadState(@NotNull DockerContainerSettings state) {
        if (state == null) {
            DockerContainerSettings.$$$reportNull$$$0(5);
        }
        state.copyTo(this);
    }

    @NotNull
    public static String settingsToCli(@Nullable DockerContainerSettings settings) {
        if (settings == null) {
            if ("" == null) {
                DockerContainerSettings.$$$reportNull$$$0(6);
            }
            return "";
        }
        ImmutableList.Builder args = ImmutableList.builder();
        if (settings.isNetworkDisabled()) {
            args.add((Object)"--net=\"none\"");
        } else if (!"bridge".equals(settings.getNetworkMode())) {
            args.add((Object)("--net=\"" + settings.getNetworkMode() + "\""));
        }
        if (settings.isPublishAllPorts()) {
            args.add((Object)"--publish-all");
        } else {
            for (DockerPortBindingImpl binding : settings.getPortBindings()) {
                String qualifiedContainerPort = StringUtil.isNotEmpty((String)binding.getProtocol()) && !"tcp".equals(binding.getProtocol()) ? String.valueOf(binding.getContainerPort()) : binding.getContainerPort() + "/" + binding.getProtocol();
                args.add((Object)String.format("-p %s:%s:%s", StringUtil.defaultIfEmpty((String)binding.getHostIp(), (String)""), binding.getHostPort() == null ? "" : String.valueOf(binding.getHostPort()), qualifiedContainerPort));
            }
        }
        for (DockerLinkImpl link : settings.getLinks()) {
            if (StringUtil.isNotEmpty((String)link.getAlias())) {
                args.add((Object)String.format("--link %s:%s", link.getName(), link.getAlias()));
                continue;
            }
            args.add((Object)String.format("--link %s", link.getName()));
        }
        for (DockerExtraHost extraHost : settings.getExtraHosts()) {
            args.add((Object)String.format("--add-host %s:%s", extraHost.getHostname(), extraHost.getIP()));
        }
        for (DockerVolumeBindingImpl volumeBinding : settings.getVolumeBindings()) {
            if (StringUtil.isNotEmpty((String)volumeBinding.getHostPath())) {
                String accessQualifier = volumeBinding.isReadOnly() ? ":ro" : "";
                args.add((Object)String.format("-v %s:%s%s", volumeBinding.getHostPath(), volumeBinding.getContainerPath(), accessQualifier));
                continue;
            }
            args.add((Object)String.format("-v %s", volumeBinding.getContainerPath()));
        }
        for (DockerEnvVarImpl envVar : settings.getEnvVars()) {
            if (envVar.getValue() != null) {
                args.add((Object)String.format("-e %s=%s", envVar.getName(), envVar.getValue()));
                continue;
            }
            args.add((Object)String.format("-e %s", envVar.getName()));
        }
        String string = Joiner.on((String)" ").join((Iterable)args.build());
        if (string == null) {
            DockerContainerSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static DockerContainerSettings defaultSettings(@NotNull Project project) {
        if (project == null) {
            DockerContainerSettings.$$$reportNull$$$0(8);
        }
        DockerContainerSettings settings = new DockerContainerSettings();
        settings.getVolumeBindings().add(DockerContainerSettings.createDefaultBinding(project));
        settings.setVersion(1);
        DockerContainerSettings dockerContainerSettings = settings;
        if (dockerContainerSettings == null) {
            DockerContainerSettings.$$$reportNull$$$0(9);
        }
        return dockerContainerSettings;
    }

    @NotNull
    public static DockerContainerSettings upgradeSettings(@NotNull Project project, @NotNull DockerContainerSettings settings) {
        if (project == null) {
            DockerContainerSettings.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            DockerContainerSettings.$$$reportNull$$$0(11);
        }
        if (settings.getVersion() == 0) {
            ArrayList<DockerVolumeBindingImpl> bindings = new ArrayList<DockerVolumeBindingImpl>(settings.getVolumeBindings());
            bindings.add(0, DockerContainerSettings.createDefaultBinding(project));
            settings.setVolumeBindings(bindings);
            settings.setVersion(1);
        }
        DockerContainerSettings dockerContainerSettings = settings;
        if (dockerContainerSettings == null) {
            DockerContainerSettings.$$$reportNull$$$0(12);
        }
        return dockerContainerSettings;
    }

    @NotNull
    static DockerVolumeBindingImpl createDefaultBinding(@NotNull Project project) {
        if (project == null) {
            DockerContainerSettings.$$$reportNull$$$0(13);
        }
        DockerVolumeBindingImpl binding = new DockerVolumeBindingImpl();
        binding.setHostPath(project.getBasePath());
        binding.setContainerPath("/opt/project");
        DockerVolumeBindingImpl dockerVolumeBindingImpl = binding;
        if (dockerVolumeBindingImpl == null) {
            DockerContainerSettings.$$$reportNull$$$0(14);
        }
        return dockerVolumeBindingImpl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerContainerSettings settings = (DockerContainerSettings)o;
        if (this.myVersion != settings.myVersion) {
            return false;
        }
        if (this.myPublishAllPorts != settings.myPublishAllPorts) {
            return false;
        }
        if (this.myNetworkDisabled != settings.myNetworkDisabled) {
            return false;
        }
        if (this.myPortBindings != null ? !this.myPortBindings.equals(settings.myPortBindings) : settings.myPortBindings != null) {
            return false;
        }
        if (this.myLinks != null ? !this.myLinks.equals(settings.myLinks) : settings.myLinks != null) {
            return false;
        }
        if (this.myVolumeBindings != null ? !this.myVolumeBindings.equals(settings.myVolumeBindings) : settings.myVolumeBindings != null) {
            return false;
        }
        if (this.myEnvVars != null ? !this.myEnvVars.equals(settings.myEnvVars) : settings.myEnvVars != null) {
            return false;
        }
        if (this.myExtraHosts != null ? !this.myExtraHosts.equals(settings.myExtraHosts) : settings.myExtraHosts != null) {
            return false;
        }
        return !(this.myNetworkMode != null ? !this.myNetworkMode.equals(settings.myNetworkMode) : settings.myNetworkMode != null);
    }

    public int hashCode() {
        int result = this.myVersion;
        result = 31 * result + (this.myPortBindings != null ? this.myPortBindings.hashCode() : 0);
        result = 31 * result + (this.myPublishAllPorts ? 1 : 0);
        result = 31 * result + (this.myLinks != null ? this.myLinks.hashCode() : 0);
        result = 31 * result + (this.myVolumeBindings != null ? this.myVolumeBindings.hashCode() : 0);
        result = 31 * result + (this.myEnvVars != null ? this.myEnvVars.hashCode() : 0);
        result = 31 * result + (this.myExtraHosts != null ? this.myExtraHosts.hashCode() : 0);
        result = 31 * result + (this.myNetworkMode != null ? this.myNetworkMode.hashCode() : 0);
        result = 31 * result + (this.myNetworkDisabled ? 1 : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/DockerContainerSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPortBindings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinks";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVolumeBindings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvVars";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/DockerContainerSettings";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "settingsToCli";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultSettings";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "upgradeSettings";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultBinding";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "defaultSettings";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "upgradeSettings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBinding";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

