/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.CharPattern;
import com.intellij.patterns.CollectionPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.InitialPatternConditionPlus;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StringPattern;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardPatterns {
    private static final FalsePattern FALSE_PATTERN = new FalsePattern();

    @NotNull
    public static StringPattern string() {
        StringPattern stringPattern = StringPattern.STRING_PATTERN;
        if (stringPattern == null) {
            StandardPatterns.$$$reportNull$$$0(0);
        }
        return stringPattern;
    }

    @NotNull
    public static CharPattern character() {
        CharPattern charPattern = new CharPattern();
        if (charPattern == null) {
            StandardPatterns.$$$reportNull$$$0(1);
        }
        return charPattern;
    }

    @NotNull
    public static <T> ObjectPattern.Capture<T> instanceOf(Class<T> aClass) {
        ObjectPattern.Capture<T> capture = new ObjectPattern.Capture<T>(aClass);
        if (capture == null) {
            StandardPatterns.$$$reportNull$$$0(2);
        }
        return capture;
    }

    @SafeVarargs
    @NotNull
    public static <T> ElementPattern<T> instanceOf(Class<T> ... classes) {
        if (classes == null) {
            StandardPatterns.$$$reportNull$$$0(3);
        }
        ElementPattern[] patterns = (ElementPattern[])ContainerUtil.map((Object[])classes, StandardPatterns::instanceOf, (Object[])new ElementPattern[0]);
        ElementPattern elementPattern = StandardPatterns.or(patterns);
        if (elementPattern == null) {
            StandardPatterns.$$$reportNull$$$0(4);
        }
        return elementPattern;
    }

    @NotNull
    public static <T> ElementPattern save(final Key<T> key) {
        ObjectPattern.Capture capture = new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                context.put(key, o);
                return true;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    1.$$$reportNull$$$0(0);
                }
                builder.append("save(").append(key).append(")");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$1", "append"));
            }
        });
        if (capture == null) {
            StandardPatterns.$$$reportNull$$$0(5);
        }
        return capture;
    }

    @NotNull
    public static ObjectPattern.Capture<Object> object() {
        ObjectPattern.Capture<Object> capture = StandardPatterns.instanceOf(Object.class);
        if (capture == null) {
            StandardPatterns.$$$reportNull$$$0(6);
        }
        return capture;
    }

    @NotNull
    public static <T> ObjectPattern.Capture<T> object(@NotNull T value) {
        if (value == null) {
            StandardPatterns.$$$reportNull$$$0(7);
        }
        ObjectPattern.Capture capture = (ObjectPattern.Capture)StandardPatterns.instanceOf(value.getClass()).equalTo(value);
        if (capture == null) {
            StandardPatterns.$$$reportNull$$$0(8);
        }
        return capture;
    }

    @NotNull
    public static <T> CollectionPattern<T> collection(Class<T> aClass) {
        CollectionPattern collectionPattern = new CollectionPattern();
        if (collectionPattern == null) {
            StandardPatterns.$$$reportNull$$$0(9);
        }
        return collectionPattern;
    }

    @NotNull
    public static ElementPattern get(final @NotNull @NonNls String key) {
        if (key == null) {
            StandardPatterns.$$$reportNull$$$0(10);
        }
        ObjectPattern.Capture capture = new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return Comparing.equal((Object)o, (Object)context.get((Object)key));
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    2.$$$reportNull$$$0(0);
                }
                builder.append("get(").append(key).append(")");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$2", "append"));
            }
        });
        if (capture == null) {
            StandardPatterns.$$$reportNull$$$0(11);
        }
        return capture;
    }

    @NotNull
    public static <T> CollectionPattern<T> collection() {
        CollectionPattern collectionPattern = new CollectionPattern();
        if (collectionPattern == null) {
            StandardPatterns.$$$reportNull$$$0(12);
        }
        return collectionPattern;
    }

    @SafeVarargs
    @NotNull
    public static <E> ElementPattern<E> or(final ElementPattern<? extends E> ... patterns) {
        if (patterns == null) {
            StandardPatterns.$$$reportNull$$$0(13);
        }
        ObjectPattern.Capture capture = new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                for (ElementPattern pattern : patterns) {
                    if (!pattern.accepts(o, context)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    3.$$$reportNull$$$0(0);
                }
                boolean first = true;
                for (ElementPattern pattern : patterns) {
                    if (!first) {
                        builder.append("\n").append(indent);
                    }
                    first = false;
                    pattern.getCondition().append(builder, indent + "  ");
                }
            }

            @Override
            public List<ElementPattern<?>> getPatterns() {
                return Arrays.asList(patterns);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$3", "append"));
            }
        });
        if (capture == null) {
            StandardPatterns.$$$reportNull$$$0(14);
        }
        return capture;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    @NotNull
    public static <E> ElementPattern<E> and(ElementPattern<? extends E> ... patterns) {
        void var5_8;
        List initial = ContainerUtil.newSmartList();
        for (ElementPattern<E> elementPattern : patterns) {
            initial.add(elementPattern.getCondition().getInitialCondition());
        }
        ObjectPattern.Capture result2 = StandardPatterns.composeInitialConditions(initial);
        ElementPattern<? extends E>[] elementPatternArray = patterns;
        int n = elementPatternArray.length;
        boolean bl = false;
        while (var5_8 < n) {
            ElementPattern<E> elementPattern = elementPatternArray[var5_8];
            for (PatternCondition<? extends E> patternCondition : elementPattern.getCondition().getConditions()) {
                result2 = (ObjectPattern.Capture)result2.with(patternCondition);
            }
            ++var5_8;
        }
        ObjectPattern.Capture capture = result2;
        if (capture == null) {
            StandardPatterns.$$$reportNull$$$0(15);
        }
        return capture;
    }

    @NotNull
    private static <E> ObjectPattern.Capture<E> composeInitialConditions(final List<? extends InitialPatternCondition> initial) {
        ObjectPattern.Capture capture = new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                for (InitialPatternCondition pattern : initial) {
                    if (pattern.accepts(o, context)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    4.$$$reportNull$$$0(0);
                }
                boolean first = true;
                for (InitialPatternCondition pattern : initial) {
                    if (!first) {
                        builder.append("\n").append(indent);
                    }
                    first = false;
                    pattern.append(builder, indent + "  ");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$4", "append"));
            }
        });
        if (capture == null) {
            StandardPatterns.$$$reportNull$$$0(16);
        }
        return capture;
    }

    @NotNull
    public static <E> ObjectPattern.Capture<E> not(final ElementPattern<E> pattern) {
        ObjectPattern.Capture capture = new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return !pattern.accepts(o, context);
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    5.$$$reportNull$$$0(0);
                }
                pattern.getCondition().append(builder.append("not("), indent + "  ");
                builder.append(")");
            }

            @Override
            public List<ElementPattern<?>> getPatterns() {
                return Collections.singletonList(pattern);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$5", "append"));
            }
        });
        if (capture == null) {
            StandardPatterns.$$$reportNull$$$0(17);
        }
        return capture;
    }

    @NotNull
    public static <T> ObjectPattern.Capture<T> optional(final ElementPattern<T> pattern) {
        ObjectPattern.Capture capture = new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                pattern.accepts(o, context);
                return true;
            }
        });
        if (capture == null) {
            StandardPatterns.$$$reportNull$$$0(18);
        }
        return capture;
    }

    @NotNull
    public static <E> ElementPattern<E> alwaysFalse() {
        FalsePattern falsePattern = FALSE_PATTERN;
        if (falsePattern == null) {
            StandardPatterns.$$$reportNull$$$0(19);
        }
        return falsePattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/patterns/StandardPatterns";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "string";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "character";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "instanceOf";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/patterns/StandardPatterns";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "save";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "object";
                break;
            }
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collection";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "or";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "composeInitialConditions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "not";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "optional";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "alwaysFalse";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "instanceOf";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "object";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FalsePattern
    implements ElementPattern {
        private FalsePattern() {
        }

        @Override
        public boolean accepts(@Nullable Object o) {
            return false;
        }

        @Override
        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            return false;
        }

        public ElementPatternCondition getCondition() {
            return new ElementPatternCondition(new InitialPatternCondition(Object.class){

                @Override
                public boolean accepts(@Nullable Object o, ProcessingContext context) {
                    return false;
                }
            });
        }
    }
}

