/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonActionsPanel
extends JPanel {
    private final boolean myDecorateButtons;
    private final ActionToolbarPosition myPosition;
    private final ActionToolbar myToolbar;
    private final Map<Buttons, MyActionButton> myButtons = new HashMap<Buttons, MyActionButton>();
    private final AnActionButton[] myActions;
    private EnumMap<Buttons, ShortcutSet> myCustomShortcuts;

    CommonActionsPanel(ListenerFactory factory, @Nullable JComponent contextComponent, ActionToolbarPosition position, @Nullable AnActionButton[] additionalActions, @Nullable Comparator<AnActionButton> buttonComparator, String addName, String removeName, String moveUpName, String moveDownName, String editName, Icon addIcon, Buttons ... buttons) {
        super(new BorderLayout());
        int i;
        this.myPosition = position;
        Listener listener = factory.createListener(this);
        AnActionButton[] actions = new AnActionButton[buttons.length + (additionalActions == null ? 0 : additionalActions.length)];
        for (i = 0; i < buttons.length; ++i) {
            AnActionButton[] button = buttons[i];
            String name = null;
            switch (2.$SwitchMap$com$intellij$ui$CommonActionsPanel$Buttons[button.ordinal()]) {
                case 1: {
                    name = addName;
                    break;
                }
                case 2: {
                    name = editName;
                    break;
                }
                case 3: {
                    name = removeName;
                    break;
                }
                case 4: {
                    name = moveUpName;
                    break;
                }
                case 5: {
                    name = moveDownName;
                }
            }
            MyActionButton b = button.createButton(listener, name, button == Buttons.ADD && addIcon != null ? addIcon : button.getIcon());
            actions[i] = b;
            this.myButtons.put((Buttons)button, b);
        }
        if (additionalActions != null && additionalActions.length > 0) {
            i = buttons.length;
            for (AnActionButton button : additionalActions) {
                actions[i++] = button;
            }
        }
        this.myActions = actions;
        for (AnActionButton action : actions) {
            action.setContextComponent(contextComponent);
        }
        if (buttonComparator != null) {
            Arrays.sort(this.myActions, buttonComparator);
        }
        ArrayList toolbarActions = ContainerUtilRt.newArrayList((Object[])this.myActions);
        for (int i2 = 0; i2 < toolbarActions.size(); ++i2) {
            if (!(toolbarActions.get(i2) instanceof AnActionButton.CheckedAnActionButton)) continue;
            toolbarActions.set(i2, ((AnActionButton.CheckedAnActionButton)toolbarActions.get(i2)).getDelegate());
        }
        this.myDecorateButtons = UIUtil.isUnderAquaLookAndFeel() && position == ActionToolbarPosition.BOTTOM;
        ActionManagerEx mgr = (ActionManagerEx)ActionManager.getInstance();
        this.myToolbar = mgr.createActionToolbar("ToolbarDecorator", new DefaultActionGroup(toolbarActions.toArray(AnAction.EMPTY_ARRAY)), position == ActionToolbarPosition.BOTTOM || position == ActionToolbarPosition.TOP, this.myDecorateButtons);
        this.myToolbar.getComponent().setBorder(null);
        this.add((Component)this.myToolbar.getComponent(), "Center");
    }

    @NotNull
    public ActionToolbar getToolbar() {
        ActionToolbar actionToolbar = this.myToolbar;
        if (actionToolbar == null) {
            CommonActionsPanel.$$$reportNull$$$0(0);
        }
        return actionToolbar;
    }

    public void setToolbarLabel(JComponent label, ActionToolbarPosition position) {
        this.removeAll();
        this.add((Component)label, ToolbarDecorator.getPlacement(position));
        if (position == ActionToolbarPosition.LEFT) {
            this.add((Component)this.myToolbar.getComponent(), "East");
        } else if (position == ActionToolbarPosition.RIGHT) {
            this.add((Component)this.myToolbar.getComponent(), "West");
        } else {
            this.add((Component)this.myToolbar.getComponent(), "Center");
        }
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Graphics2D g = (Graphics2D)g2;
        if (this.myDecorateButtons) {
            this.myToolbar.getComponent().setOpaque(false);
            MacUIUtil.drawToolbarDecoratorBackground((Graphics)g, (int)this.getWidth(), (int)this.getHeight());
        } else {
            super.paintComponent(g);
        }
    }

    public AnActionButton getAnActionButton(Buttons button) {
        return this.myButtons.get((Object)button);
    }

    @Override
    public void addNotify() {
        if (this.getBackground() != null && !this.getBackground().equals(UIUtil.getPanelBackground())) {
            SwingUtilities.updateComponentTreeUI(this.getParent());
        }
        JRootPane pane = this.getRootPane();
        for (AnActionButton button : this.myActions) {
            ShortcutSet customShortCut;
            ShortcutSet shortcut = button.getShortcut();
            if (shortcut == null) continue;
            if (button instanceof MyActionButton && this.myCustomShortcuts != null && (customShortCut = this.myCustomShortcuts.get((Object)((MyActionButton)button).myButton)) != null) {
                shortcut = customShortCut;
            }
            if (button instanceof MyActionButton && ((MyActionButton)button).isAddButton() && UIUtil.isDialogRootPane((JRootPane)pane)) {
                button.registerCustomShortcutSet(shortcut, pane);
            } else {
                button.registerCustomShortcutSet(shortcut, button.getContextComponent());
            }
            if (!(button instanceof MyActionButton) || !((MyActionButton)button).isRemoveButton()) continue;
            CommonActionsPanel.registerDeleteHook((MyActionButton)button);
        }
        super.addNotify();
    }

    private static void registerDeleteHook(final MyActionButton removeButton) {
        new AnAction("Delete Hook"){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                removeButton.actionPerformed(e);
            }

            @Override
            public boolean isDumbAware() {
                return removeButton.isDumbAware();
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                JComponent contextComponent;
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((contextComponent = removeButton.getContextComponent()) instanceof JTable && ((JTable)contextComponent).isEditing()) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                SpeedSearchSupply supply = SpeedSearchSupply.getSupply(contextComponent);
                if (supply != null && supply.isPopupActive()) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                removeButton.update(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/ui/CommonActionsPanel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.registerCustomShortcutSet(CustomShortcutSet.fromString("DELETE", "BACK_SPACE"), removeButton.getContextComponent());
    }

    public void setEnabled(Buttons button, boolean enabled) {
        MyActionButton b = this.myButtons.get((Object)button);
        if (b != null) {
            b.setEnabled(enabled);
        }
    }

    public void setCustomShortcuts(@NotNull Buttons button, ShortcutSet ... shortcutSets) {
        if (button == null) {
            CommonActionsPanel.$$$reportNull$$$0(1);
        }
        if (shortcutSets != null) {
            if (this.myCustomShortcuts == null) {
                this.myCustomShortcuts = new EnumMap(Buttons.class);
            }
            this.myCustomShortcuts.put(button, new CompositeShortcutSet(shortcutSets));
        } else if (this.myCustomShortcuts != null) {
            this.myCustomShortcuts.remove((Object)button);
            if (this.myCustomShortcuts.isEmpty()) {
                this.myCustomShortcuts = null;
            }
        }
    }

    @NotNull
    public ActionToolbarPosition getPosition() {
        ActionToolbarPosition actionToolbarPosition = this.myPosition;
        if (actionToolbarPosition == null) {
            CommonActionsPanel.$$$reportNull$$$0(2);
        }
        return actionToolbarPosition;
    }

    @Contract(value="!null -> !null")
    public static ShortcutSet getCommonShortcut(Buttons button) {
        switch (button) {
            case ADD: {
                return CommonShortcuts.getNewForDialogs();
            }
            case EDIT: {
                return CustomShortcutSet.fromString("ENTER");
            }
            case REMOVE: {
                return CustomShortcutSet.fromString(SystemInfo.isMac ? "meta BACK_SPACE" : "alt DELETE");
            }
            case UP: {
                return CommonShortcuts.MOVE_UP;
            }
            case DOWN: {
                return CommonShortcuts.MOVE_DOWN;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/CommonActionsPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/CommonActionsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setCustomShortcuts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface ListenerFactory {
        public Listener createListener(CommonActionsPanel var1);
    }

    static class MyActionButton
    extends AnActionButton
    implements DumbAware {
        private final Buttons myButton;
        private final Listener myListener;

        MyActionButton(Buttons button, Listener listener, String name, Icon icon) {
            super(name, name, icon);
            this.myButton = button;
            this.myListener = listener;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyActionButton.$$$reportNull$$$0(0);
            }
            this.myButton.performAction(this.myListener);
        }

        @Override
        public ShortcutSet getShortcut() {
            return CommonActionsPanel.getCommonShortcut(this.myButton);
        }

        @Override
        public void updateButton(@NotNull AnActionEvent e) {
            if (e == null) {
                MyActionButton.$$$reportNull$$$0(1);
            }
            super.updateButton(e);
            if (!e.getPresentation().isEnabled()) {
                return;
            }
            JComponent c = this.getContextComponent();
            if (c instanceof JTable || c instanceof JList) {
                InputEvent inputEvent;
                if (this.myButton == Buttons.EDIT && (inputEvent = e.getInputEvent()) instanceof KeyEvent && c instanceof JTable && ((JTable)c).isEditing() && !(inputEvent.getComponent() instanceof ActionButtonComponent)) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                ListSelectionModel model = c instanceof JTable ? ((JTable)c).getSelectionModel() : ((JList)c).getSelectionModel();
                int size = c instanceof JTable ? ((JTable)c).getRowCount() : ((JList)c).getModel().getSize();
                int min = model.getMinSelectionIndex();
                int max = model.getMaxSelectionIndex();
                if (this.myButton == Buttons.UP && min < 1 || this.myButton == Buttons.DOWN && max == size - 1 || this.myButton != Buttons.ADD && size == 0 || this.myButton == Buttons.EDIT && (min != max || min == -1)) {
                    e.getPresentation().setEnabled(false);
                } else {
                    e.getPresentation().setEnabled(this.isEnabled());
                }
            }
        }

        boolean isAddButton() {
            return this.myButton == Buttons.ADD;
        }

        boolean isRemoveButton() {
            return this.myButton == Buttons.REMOVE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ui/CommonActionsPanel$MyActionButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateButton";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Listener {
        default public void doAdd() {
        }

        default public void doRemove() {
        }

        default public void doUp() {
        }

        default public void doDown() {
        }

        default public void doEdit() {
        }
    }

    public static enum Buttons {
        ADD,
        REMOVE,
        EDIT,
        UP,
        DOWN;

        public static final Buttons[] ALL;

        public Icon getIcon() {
            switch (this) {
                case ADD: {
                    return IconUtil.getAddIcon();
                }
                case EDIT: {
                    return IconUtil.getEditIcon();
                }
                case REMOVE: {
                    return IconUtil.getRemoveIcon();
                }
                case UP: {
                    return IconUtil.getMoveUpIcon();
                }
                case DOWN: {
                    return IconUtil.getMoveDownIcon();
                }
            }
            return null;
        }

        MyActionButton createButton(Listener listener, String name, Icon icon) {
            return new MyActionButton(this, listener, name == null ? StringUtil.capitalize((String)this.name().toLowerCase(Locale.ENGLISH)) : name, icon);
        }

        public String getText() {
            return StringUtil.capitalize((String)this.name().toLowerCase(Locale.ENGLISH));
        }

        public void performAction(Listener listener) {
            switch (this) {
                case ADD: {
                    listener.doAdd();
                    break;
                }
                case EDIT: {
                    listener.doEdit();
                    break;
                }
                case REMOVE: {
                    listener.doRemove();
                    break;
                }
                case UP: {
                    listener.doUp();
                    break;
                }
                case DOWN: {
                    listener.doDown();
                }
            }
        }

        static {
            ALL = new Buttons[]{ADD, REMOVE, EDIT, UP, DOWN};
        }
    }
}

