/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuiteListener;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;

public class CoverageViewSuiteListener
implements CoverageSuiteListener {
    private final CoverageDataManager a;
    private final Project b;

    public CoverageViewSuiteListener(CoverageDataManager dataManager, Project project) {
        this.a = dataManager;
        this.b = project;
    }

    @Override
    public void beforeSuiteChosen() {
        CoverageSuitesBundle coverageSuitesBundle = this.a.getCurrentSuitesBundle();
        if (coverageSuitesBundle != null) {
            CoverageViewManager.getInstance(this.b).closeView(CoverageViewManager.getDisplayName(coverageSuitesBundle));
        }
    }

    @Override
    public void afterSuiteChosen() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        CoverageSuitesBundle coverageSuitesBundle = this.a.getCurrentSuitesBundle();
        if (coverageSuitesBundle == null) {
            return;
        }
        CoverageViewManager coverageViewManager = CoverageViewManager.getInstance(this.b);
        if (coverageSuitesBundle.getCoverageEngine().createCoverageViewExtension(this.b, coverageSuitesBundle, coverageViewManager.getState()) != null) {
            coverageViewManager.createToolWindow(CoverageViewManager.getDisplayName(coverageSuitesBundle), CoverageViewSuiteListener.a(coverageSuitesBundle));
        }
    }

    private static boolean a(CoverageSuitesBundle coverageSuitesBundle) {
        CoverageSuite[] coverageSuiteArray;
        for (CoverageSuite coverageSuite : coverageSuiteArray = coverageSuitesBundle.getSuites()) {
            if (coverageSuite.getCoverageDataFileProvider() instanceof DefaultCoverageFileProvider) continue;
            return false;
        }
        return true;
    }
}

