/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.gem;

import b.h.la;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.Namespace;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemAdditionalInfo;
import org.jetbrains.plugins.ruby.gem.GemDataContext;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemSpecParser;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.GemsDataKeys;
import org.jetbrains.plugins.ruby.library.RubyLibraryKind;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

public class GemInfo {
    private static final Logger D;
    @NonNls
    public static final String GEM_LIBRARY_SUFFIX = "[gem]";
    @NonNls
    private static final String t = "[path]";
    @NonNls
    private static final String G = "[path][gem]";
    @NonNls
    private static final Pattern c;
    @NonNls
    private static final String F = "gem";
    @NonNls
    private static final String y = "url";
    @NonNls
    private static final String a = "version";
    @NonNls
    private static final String j = "name";
    @NonNls
    private static final String n = "timestamp";
    @NonNls
    private static final String o = "readme";
    @NonNls
    private static final String m = "parser_version";
    @NonNls
    private static final String p = "git";
    @NonNls
    private static final String s = "ref";
    @NonNls
    private static final String E = "require_path";
    @NonNls
    private static final String d = "value";
    @NonNls
    private static final String r = "space";
    @NonNls
    private static final String f = "preserve";
    private static final String[] B;
    private static final Pattern l;
    private static final GemDependency[] H;
    @NotNull
    private final String v;
    @Nullable
    private final String b;
    @NotNull
    private final String q;
    private String h;
    private boolean i;
    private final GemAdditionalInfo w;
    private final GemDependency[] g;
    @Nullable
    private final Sdk k;
    private final boolean C;
    private VirtualFile z;
    private final boolean x;
    @Nullable
    private final String e;
    private final boolean A;
    @NotNull
    private final List<String> u;
    private static final long K;

    protected GemInfo(@NotNull String name, @Nullable String version, @NotNull String url, String readme, Set<GemDependency> dependencies, @Nullable Sdk sdk, boolean remote, GemAdditionalInfo additionalInfo, boolean isGit, @Nullable String ref, boolean fromPath, @NotNull List<String> requirePaths) {
        if (name == null) {
            GemInfo.a(0);
        }
        if (url == null) {
            GemInfo.a(1);
        }
        if (requirePaths == null) {
            GemInfo.a(2);
        }
        this.v = name;
        this.b = version;
        this.q = url;
        this.h = readme;
        this.k = sdk;
        this.C = remote;
        this.x = isGit;
        this.e = ref;
        this.A = fromPath;
        this.g = dependencies != null ? dependencies.toArray(new GemDependency[0]) : H;
        this.w = additionalInfo;
        this.u = requirePaths;
        assert (this.C || this.A || this.k != null);
    }

    @NotNull
    public String getName() {
        String string = this.v;
        if (string == null) {
            GemInfo.a(3);
        }
        return string;
    }

    @NotNull
    public String getVersion() {
        long l2 = K ^ 0x8C0857DA99DL;
        String string = this.b != null ? this.b : StringUtil.notNullize((String)this.a(), (String)t);
        if (string == null) {
            GemInfo.a(4);
        }
        return string;
    }

    @Nullable
    private String a() {
        return this.e != null ? this.e.substring(0, Math.min(6, this.e.length())) : null;
    }

    @Nullable
    public String getRealVersion() {
        return this.b;
    }

    @NotNull
    public String getUrl() {
        String string = this.q;
        if (string == null) {
            GemInfo.a(5);
        }
        return string;
    }

    @Nullable
    public String getReadme() {
        if (this.h == null && !this.isRemote() && !this.i) {
            VirtualFile virtualFile = this.getFile();
            this.h = virtualFile != null ? GemUtil.getGemReadme(virtualFile) : null;
            this.i = true;
        }
        return this.h;
    }

    @NotNull
    public List<String> getRequirePaths() {
        List<String> list2 = this.u;
        if (list2 == null) {
            GemInfo.a(6);
        }
        return list2;
    }

    @NotNull
    public static List<GemInfo> create(@Nullable Sdk sdk, @NotNull VirtualFile gemFile) {
        if (gemFile == null) {
            GemInfo.a(7);
        }
        List<GemInfo> list2 = GemInfo.create(sdk, gemFile, false);
        if (list2 == null) {
            GemInfo.a(8);
        }
        return list2;
    }

    @NotNull
    public static List<GemInfo> create(@Nullable Sdk sdk, @NotNull VirtualFile gemFile, boolean fromPath) {
        if (gemFile == null) {
            GemInfo.a(9);
        }
        ArrayList<GemInfo> arrayList = new ArrayList<GemInfo>();
        GemInfo.a(sdk, gemFile, fromPath, arrayList);
        for (VirtualFile virtualFile : gemFile.getChildren()) {
            if (!virtualFile.isDirectory() || FileTypeManager.getInstance().isFileIgnored(virtualFile)) continue;
            GemInfo.a(sdk, virtualFile, fromPath, arrayList);
        }
        ArrayList<GemInfo> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GemInfo.a(10);
        }
        return arrayList2;
    }

    private static void a(Sdk sdk, VirtualFile virtualFile, boolean bl2, List<GemInfo> list2) {
        GemDataContext gemDataContext = GemInfo.a(virtualFile);
        if (gemDataContext != null) {
            gemDataContext.putData(GemsDataKeys.SDK, sdk);
            gemDataContext.putData(GemsDataKeys.FROM_PATH, bl2);
            GemInfo gemInfo = GemInfo.create(gemDataContext, virtualFile.getUrl(), null);
            ContainerUtil.addIfNotNull(list2, (Object)gemInfo);
        }
    }

    public boolean isValid() {
        return this.getFile() != null;
    }

    @Nullable
    public VirtualFile getFile() {
        if (this.z == null || !this.z.isValid()) {
            this.z = VirtualFileManager.getInstance().findFileByUrl(this.q);
        }
        return this.z;
    }

    @Nullable
    public VirtualFile getLibFolder() {
        return GemUtil.findGemLibDirectory(this.getFile());
    }

    @NotNull
    public GemDependency asDependency() {
        GemDependency gemDependency = GemDependency.exact(this);
        if (gemDependency == null) {
            GemInfo.a(11);
        }
        return gemDependency;
    }

    @Nullable
    public static GemInfo create(@Nullable GemDataContext specs, @NotNull String url, @Nullable String readme) {
        boolean bl2;
        long l2 = K ^ 0x192062CE63CL;
        if (url == null) {
            GemInfo.a(12);
        }
        if (specs == null) {
            return null;
        }
        String string = (String)GemsDataKeys.NAME.getData((DataContext)specs);
        String string2 = (String)GemsDataKeys.VERSION.getData((DataContext)specs);
        GemAdditionalInfo gemAdditionalInfo = GemAdditionalInfo.create(specs);
        Set set = (Set)GemsDataKeys.DEPENDENCIES.getData((DataContext)specs);
        Sdk sdk = (Sdk)GemsDataKeys.SDK.getData((DataContext)specs);
        Boolean bl3 = (Boolean)GemsDataKeys.REMOTE.getData((DataContext)specs);
        Boolean bl4 = (Boolean)GemsDataKeys.GIT.getData((DataContext)specs);
        Boolean bl5 = (Boolean)GemsDataKeys.FROM_PATH.getData((DataContext)specs);
        String string3 = (String)GemsDataKeys.REF.getData((DataContext)specs);
        List<String> list2 = (List<String>)GemsDataKeys.REQUIRE_PATHS.getData((DataContext)specs);
        boolean bl6 = bl2 = bl5 != null && bl5 != false;
        if (string == null || string2 == null && string3 == null && !bl2) {
            return null;
        }
        return new GemInfo(GemInfo.b(string), string2, GemInfo.b(url), readme != null ? readme : (String)GemsDataKeys.DESCRIPTION.getData((DataContext)specs), set, sdk, bl3 != null && bl3 != false, gemAdditionalInfo, bl4 != null && bl4 != false, string3, bl2, list2 != null ? list2 : Collections.singletonList("lib"));
    }

    @Nullable
    private static GemDataContext a(VirtualFile virtualFile) {
        VirtualFile virtualFile2 = GemUtil.getSpecFile(virtualFile);
        if (virtualFile2 == null) {
            return null;
        }
        return GemSpecParser.getInstance().getGemSpec(virtualFile, virtualFile2);
    }

    public Element getState() {
        long l2 = K ^ 0x121BF6047219L;
        Element element = new Element(F);
        element.setAttribute(y, this.q);
        element.setAttribute(j, this.v);
        if (this.b != null) {
            element.setAttribute(a, this.b);
        }
        element.setAttribute(n, GemInfo.b(this.getFile()));
        element.setAttribute(m, "16");
        Element element3 = this.w.getState();
        if (element3 != null) {
            element.addContent(element3);
        }
        for (GemDependency gemDependency : this.g) {
            element.addContent(gemDependency.getState());
        }
        if (this.h != null) {
            try {
                Element element4 = new Element(o);
                element4.setAttribute(r, f, Namespace.XML_NAMESPACE);
                element4.addContent((Content)new CDATA(this.h));
                element.addContent(element4);
            }
            catch (IllegalDataException illegalDataException) {
                D.warn("probably corrupt readme for gem " + this.getLibraryName());
            }
        }
        element.setAttribute(p, String.valueOf(this.x));
        if (this.e != null) {
            element.setAttribute(s, this.e);
        }
        this.u.stream().map(string -> {
            long l2 = K ^ 0x3096EA201311L;
            Element element = new Element(E);
            element.setAttribute(d, string);
            return element;
        }).forEach(element2 -> element.addContent(element2));
        return element;
    }

    private static String b(VirtualFile virtualFile) {
        VirtualFile virtualFile2 = GemUtil.getSpecFile(virtualFile);
        return String.valueOf(virtualFile2 != null ? virtualFile2.getTimeStamp() : 0L);
    }

    @Nullable
    public static GemInfo create(Sdk sdk, Element element2) {
        long l2 = K ^ 0x684E354678FEL;
        if (Comparing.strEqual((String)element2.getName(), (String)F)) {
            String string = element2.getAttributeValue(y);
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(string);
            if (virtualFile != null) {
                VirtualFile virtualFile2 = GemUtil.getSpecFile(virtualFile);
                if (virtualFile2 == null) {
                    return null;
                }
                String string2 = element2.getAttributeValue(n);
                long l3 = string2 != null ? Long.valueOf(string2) : 0L;
                String string3 = element2.getAttributeValue(m);
                if (virtualFile2.getTimeStamp() != l3 || VersionComparatorUtil.compare((String)string3, (String)"16") < 0) {
                    return null;
                }
                String string4 = element2.getAttributeValue(j);
                String string5 = element2.getAttributeValue(a);
                Element element3 = element2.getChild(o);
                String string6 = element3 != null ? (f.equals(element3.getAttributeValue(r, Namespace.XML_NAMESPACE)) ? element3.getText() : GemUtil.getGemReadme(virtualFile)) : null;
                GemAdditionalInfo gemAdditionalInfo = GemAdditionalInfo.create(element2.getChild("additional_info"));
                HashSet<GemDependency> hashSet = new HashSet<GemDependency>();
                List list2 = element2.getChildren("dependency");
                for (Element element4 : list2) {
                    hashSet.add(GemDependency.create(element4));
                }
                String string7 = element2.getAttributeValue(p);
                boolean bl2 = string7 != null && string7.equals("true");
                String string8 = element2.getAttributeValue(s);
                List<String> list3 = element2.getChildren(E).stream().map(element -> {
                    long l2 = K ^ 0xA964F760826L;
                    return element.getAttributeValue(d);
                }).collect(Collectors.toList());
                return new GemInfo(string4, string5, string, string6, hashSet, sdk, false, gemAdditionalInfo, bl2, string8, false, list3);
            }
        }
        return null;
    }

    @NotNull
    @NonNls
    public String getLibraryName() {
        String string;
        long l2 = K ^ 0x1051DEC77FA6L;
        if (this.A) {
            string = this.v + " (v" + this.getVersion() + ") " + G;
        } else {
            String string2 = this.getVersion();
            String string3 = this.a();
            string2 = this.isGit() ? (StringUtil.equals((CharSequence)string2, (CharSequence)string3) ? "@" + string3 : string2 + "@" + string3) : string2;
            String string4 = RbenvGemsetManager.fetchGemGemset(this);
            string4 = string4 == null ? "" : ", " + string4;
            string = this.v + " (v" + string2 + ", " + (this.k != null ? this.k.getName() : "") + string4 + ") " + GEM_LIBRARY_SUFFIX;
        }
        String string5 = string;
        if (string5 == null) {
            GemInfo.a(13);
        }
        return string5;
    }

    private static String b(String string) {
        return l.matcher(string).replaceAll("");
    }

    @Nullable
    public static Pair<String, String> getNameAndVersion(String libraryName) {
        long l2 = K ^ 0x2727BCF7EC7FL;
        if (!GemInfo.isGemLibrary(libraryName)) {
            return null;
        }
        Matcher matcher = c.matcher(libraryName);
        if (matcher.matches()) {
            String string = matcher.group(1);
            String string2 = matcher.group(2);
            String[] stringArray = string2.split("@");
            if (stringArray.length == 0) {
                D.warn("split.length == 0: " + libraryName);
                return Pair.create((Object)string, (Object)"");
            }
            String string3 = StringUtil.isEmpty((String)stringArray[0]) && stringArray.length > 1 ? stringArray[1] : stringArray[0];
            return Pair.create((Object)string, (Object)string3);
        }
        D.warn("error matching gem name: " + libraryName);
        return null;
    }

    @Nullable
    public static String getSdkName(String libraryName) {
        long l2 = K ^ 0x742EA5138B8EL;
        if (!GemInfo.isGemLibrary(libraryName)) {
            return null;
        }
        Matcher matcher = c.matcher(libraryName);
        if (matcher.matches()) {
            return matcher.group(3);
        }
        D.warn("error matching gem name: " + libraryName);
        return null;
    }

    public static boolean isGemLibrary(@Nullable String libraryName) {
        long l2 = K ^ 0x4F084A08D7D2L;
        return libraryName != null && libraryName.endsWith(GEM_LIBRARY_SUFFIX);
    }

    public static boolean isPathGemLibrary(@Nullable String libraryName) {
        long l2 = K ^ 0x3EAA1BCC6A34L;
        return libraryName != null && libraryName.endsWith(G);
    }

    @NotNull
    public List<VirtualFile> getValidRequirePaths() {
        VirtualFile virtualFile;
        long l2 = K ^ 0x6C56F9E1AC81L;
        VirtualFile virtualFile2 = this.getFile();
        if (virtualFile2 == null || !virtualFile2.isValid()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                GemInfo.a(14);
            }
            return list2;
        }
        List list3 = StreamEx.of(this.u).map(string -> virtualFile2.findFileByRelativePath(string)).nonNull().toList();
        if (list3.isEmpty() && (virtualFile = virtualFile2.findFileByRelativePath("lib")) != null && virtualFile.isDirectory()) {
            list3.add(virtualFile);
        }
        for (VirtualFile virtualFile3 : B) {
            VirtualFile virtualFile4 = virtualFile2.findFileByRelativePath((String)virtualFile3);
            if (virtualFile4 == null || !virtualFile4.isDirectory() || list3.contains(virtualFile4)) continue;
            list3.add(virtualFile4);
        }
        List list4 = list3;
        if (list4 == null) {
            GemInfo.a(15);
        }
        return list4;
    }

    @NotNull
    public GemAdditionalInfo getAdditionalInfo() {
        GemAdditionalInfo gemAdditionalInfo = this.w;
        if (gemAdditionalInfo == null) {
            GemInfo.a(16);
        }
        return gemAdditionalInfo;
    }

    public GemDependency[] getDependencies() {
        return this.g;
    }

    public boolean isRemote() {
        return this.C;
    }

    public String toString() {
        return this.getName() + "(" + this.getVersion() + ")";
    }

    @Nullable
    public Library getLibrary(LibraryTable.ModifiableModel model) {
        return model.getLibraryByName(this.getLibraryName());
    }

    @Nullable
    public String getRef() {
        return this.e;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof GemInfo)) {
            return false;
        }
        GemInfo gemInfo = (GemInfo)o2;
        if (!this.v.equals(gemInfo.v)) {
            return false;
        }
        if (this.b != null ? !this.b.equals(gemInfo.b) : gemInfo.b != null) {
            return false;
        }
        if (this.C && ((GemInfo)o2).C) {
            return true;
        }
        if (!this.q.equals(gemInfo.q)) {
            return false;
        }
        if (this.x != gemInfo.x) {
            return false;
        }
        return !(this.e != null ? !this.e.equals(gemInfo.e) : gemInfo.e != null);
    }

    public int hashCode() {
        int n2 = this.v.hashCode();
        n2 = 31 * n2 + (this.b != null ? this.b.hashCode() : 0);
        if (this.C) {
            return n2;
        }
        n2 = 31 * n2 + this.q.hashCode();
        n2 = 31 * n2 + (this.x ? 1 : 0);
        n2 = 31 * n2 + (this.e != null ? this.e.hashCode() : 0);
        return n2;
    }

    public boolean isGit() {
        return this.x;
    }

    public boolean isFromPath() {
        return this.A;
    }

    public void createLibrary(LibraryTable.ModifiableModel model) {
        this.removeLibrary(model);
        String string = this.getLibraryName();
        LibraryEx libraryEx = (LibraryEx)model.createLibrary(string, (PersistentLibraryKind)RubyLibraryKind.INSTANCE);
        LibraryEx.ModifiableModelEx modifiableModelEx = libraryEx.getModifiableModel();
        List<VirtualFile> list2 = this.getValidRequirePaths();
        VirtualFile virtualFile = this.getFile();
        if (virtualFile != null) {
            for (VirtualFile virtualFile2 : virtualFile.getChildren()) {
                if (virtualFile2.isDirectory()) {
                    modifiableModelEx.addRoot(virtualFile2.getUrl(), OrderRootType.CLASSES);
                    modifiableModelEx.addRoot(virtualFile2.getUrl(), OrderRootType.SOURCES);
                }
                if (list2.contains(virtualFile2) || !virtualFile2.isDirectory()) continue;
                modifiableModelEx.addExcludedRoot(virtualFile2.getUrl());
            }
        }
        modifiableModelEx.commit();
    }

    public void removeLibrary(LibraryTable.ModifiableModel model) {
        Library library = model.getLibraryByName(this.getLibraryName());
        if (library != null) {
            model.removeLibrary(library);
        }
    }

    @Nullable
    public Sdk getSdk() {
        return this.k;
    }

    static {
        K = la.a(2100780176021096291L, -2523528477330670605L, MethodHandles.lookup().lookupClass()).a(192275433194542L);
        long l2 = K ^ 0x4797064AE202L;
        D = Logger.getInstance(GemInfo.class);
        c = Pattern.compile("(.+) \\(v([^,]*)(?:, (.*))?\\) (?:\\[path\\])?\\[gem\\]");
        B = new String[]{"app", "vendor", "features", "node_modules"};
        l = Pattern.compile("\u0000");
        H = new GemDependency[0];
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = K ^ 0x1BC1F569CF9EL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = j;
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = y;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirePaths";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/gem/GemInfo";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/gem/GemInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequirePaths";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "asDependency";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidRequirePaths";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalInfo";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

