/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rvm;

import b.h.la;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkRefresher;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSettings;

public class LocalRvmPathsSettings
implements RvmSettings {
    public static final String SHARE_RVM_PATH = "/usr/share/rvm";
    private static final Logger c;
    private static final String[] g;
    private static final String h = "export rvm_gems_path=\"${HOME}/.rvm/gems\"";
    private boolean i;
    private VirtualFile d;
    private VirtualFile b;
    private VirtualFile e;
    private String f;
    private RVMInstallationType a = RVMInstallationType.SINGLE;
    private static final long j;

    @Nullable
    public synchronized VirtualFile getRvmHome() {
        if (!this.i) {
            this.a();
        }
        return this.d;
    }

    public synchronized void setRvmHome(@Nullable VirtualFile rvmHomeDir) {
        long l2 = j ^ 0x2D3688AFC42CL;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new UnsupportedOperationException("This method is only for testing purposes");
        }
        this.d = rvmHomeDir;
        this.i = true;
    }

    @Nullable
    public synchronized VirtualFile getInterpretersFolder() {
        VirtualFile virtualFile;
        long l2 = j ^ 0x24DC2093A0C9L;
        if (this.b == null && (virtualFile = this.getRvmHome()) != null) {
            this.b = virtualFile.findChild("rubies");
        }
        return this.b;
    }

    @Nullable
    public synchronized VirtualFile getGemsFolder() {
        if (this.e == null) {
            this.e = this.h();
        }
        return this.e;
    }

    @Nullable
    public VirtualFile getRvmExecutable() {
        long l2 = j ^ 0x38ADC93FC057L;
        VirtualFile virtualFile = this.getRvmHome();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile.findChild("/bin");
        if (virtualFile2 == null || !virtualFile2.isDirectory()) {
            return null;
        }
        return virtualFile2.findChild("rvm");
    }

    @Override
    @Nullable
    public synchronized String getRvmHomePath() {
        VirtualFile virtualFile;
        if (this.f == null && (virtualFile = this.getRvmHome()) != null) {
            this.f = virtualFile.getPath();
        }
        return this.f;
    }

    public synchronized void setRvmHomePath(@Nullable String path) {
        long l2 = j ^ 0xEF5DD67FA88L;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new UnsupportedOperationException("This method is only for testing purposes");
        }
        this.f = path;
        this.i = true;
    }

    public synchronized void tearDown() {
        this.d = null;
        this.f = null;
        this.e = null;
        this.b = null;
        this.i = false;
    }

    public boolean isMixedMode() {
        return this.a == RVMInstallationType.MIXED_MODE;
    }

    private boolean b() {
        long l2 = j ^ 0x5C088522AEB6L;
        VirtualFile virtualFile = VfsUtil.getUserHomeDir();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile.findChild(".rvmrc");
        if (virtualFile2 == null) {
            return false;
        }
        String string = RvmSdkRefresher.loadText(virtualFile2);
        if (string != null && StringUtil.contains((CharSequence)string, (CharSequence)h)) {
            this.a = RVMInstallationType.MIXED_MODE;
            return true;
        }
        return false;
    }

    @Nullable
    private synchronized VirtualFile h() {
        VirtualFile virtualFile;
        long l2 = j ^ 0x9E38E5E191EL;
        if (this.isMixedMode() && (virtualFile = LocalRvmPathsSettings.d()) != null) {
            VirtualFile virtualFile2 = virtualFile.findChild("gems");
            if (virtualFile2 != null) {
                return virtualFile2;
            }
            c.warn("Cannot find gems folder for Mixed Mode installed RVM in /usr/share/rvm");
        }
        return (virtualFile = this.getRvmHome()) == null ? null : virtualFile.findChild("gems");
    }

    private void c() {
        this.a = RVMInstallationType.MULTI_USER;
        this.b();
    }

    private synchronized void a() {
        long l2 = j ^ 0x25A630D8B4C6L;
        this.i = true;
        if (SystemInfo.isWindows) {
            return;
        }
        String string = LocalRvmPathsSettings.g();
        if (string != null) {
            String string2 = VirtualFileUtil.constructLocalUrl(string);
            if (string.startsWith(SHARE_RVM_PATH)) {
                this.c();
            }
            this.d = VirtualFileManager.getInstance().refreshAndFindFileByUrl(string2);
            if (this.d == null) {
                c.warn("Cannot find custom rvm home directory: " + string);
            }
            return;
        }
        VirtualFile virtualFile = LocalRvmPathsSettings.e();
        if (virtualFile != null) {
            this.d = virtualFile;
            this.c();
            return;
        }
        VirtualFile virtualFile2 = LocalRvmPathsSettings.d();
        if (virtualFile2 != null) {
            this.d = virtualFile2;
            return;
        }
        String string3 = LocalRvmPathsSettings.f();
        if (string3 != null) {
            c.info("System wide RVM detected: " + string3);
            String string4 = VirtualFileUtil.constructLocalUrl(string3);
            this.d = VirtualFileManager.getInstance().refreshAndFindFileByUrl(string4);
            if (this.d == null) {
                c.warn("Cannot find rvm home directory: " + string3);
            }
            return;
        }
        c.info("RVM installation wasn't detected.");
    }

    @Override
    public boolean isRvmSupportEnabled() {
        if (!SystemInfo.isUnix) {
            return false;
        }
        VirtualFile virtualFile = this.getInterpretersFolder();
        return virtualFile != null && virtualFile.isDirectory();
    }

    public static LocalRvmPathsSettings getInstance() {
        return (LocalRvmPathsSettings)ServiceManager.getService(LocalRvmPathsSettings.class);
    }

    @Nullable
    private static VirtualFile e() {
        long l2 = j ^ 0x7645A525F995L;
        String string = FileUtil.toSystemIndependentName((String)SHARE_RVM_PATH);
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(string);
        if (virtualFile != null) {
            virtualFile.refresh(false, false);
            VirtualFile[] virtualFileArray = virtualFile.getChildren();
            if (virtualFileArray != null && virtualFileArray.length != 0) {
                return virtualFile;
            }
            c.warn("Local share folder is empty: " + virtualFile.getPath() + ". Looking for local rvm installation.");
        }
        return virtualFile;
    }

    @Nullable
    private static VirtualFile d() {
        long l2 = j ^ 0x75D7F16D8EA7L;
        VirtualFile virtualFile = VfsUtil.getUserHomeDir();
        if (virtualFile == null) {
            c.warn("Cannot find User home folder: " + SystemProperties.getUserHome());
            return null;
        }
        virtualFile.refresh(false, false);
        VirtualFile virtualFile2 = virtualFile.findChild(".rvm");
        if (virtualFile2 != null) {
            virtualFile2.refresh(false, false);
            VirtualFile[] virtualFileArray = virtualFile2.getChildren();
            if (virtualFileArray != null && virtualFileArray.length != 0) {
                return virtualFile2;
            }
            c.warn("Local .rvm folder is empty: " + virtualFile2.getPath() + ". Looking for system-wide installation.");
        }
        return virtualFile2;
    }

    @Nullable
    private static String g() {
        long l2 = j ^ 0x35318DE39100L;
        if (SystemInfo.isWindows) {
            throw new UnsupportedOperationException("RVM support isn't implemented for Windows");
        }
        String string = EnvironmentUtil.getValue((String)"rvm_path");
        return !StringUtil.isEmpty((String)string) ? string : null;
    }

    @Nullable
    private static String f() {
        long l2 = j ^ 0x4E4D4E393EF9L;
        if (SystemInfo.isWindows) {
            throw new UnsupportedOperationException("RVM support isn't implemented for Windows");
        }
        for (String string : g) {
            String string2 = string + "/" + "rubies";
            File file = new File(string2);
            if (!file.exists()) continue;
            return string;
        }
        return null;
    }

    static {
        j = la.a(-5497543202015281466L, 1847982595317389953L, MethodHandles.lookup().lookupClass()).a(88719230678790L);
        long l2 = j ^ 0xA64126EA6EFL;
        c = Logger.getInstance(LocalRvmPathsSettings.class);
        g = new String[]{"/usr/local/rvm"};
    }

    static final class RVMInstallationType
    extends Enum<RVMInstallationType> {
        public static final /* enum */ RVMInstallationType SINGLE;
        public static final /* enum */ RVMInstallationType MULTI_USER;
        public static final /* enum */ RVMInstallationType MIXED_MODE;
        private static final /* synthetic */ RVMInstallationType[] a;

        public static RVMInstallationType[] values() {
            return (RVMInstallationType[])a.clone();
        }

        public static RVMInstallationType valueOf(String name) {
            return Enum.valueOf(RVMInstallationType.class, name);
        }

        static {
            long l2 = la.a(-1712214885596376716L, -669631188401392766L, MethodHandles.lookup().lookupClass()).a(279008090966545L) ^ 0x2CC6D97ED48DL;
            SINGLE = new RVMInstallationType();
            MULTI_USER = new RVMInstallationType();
            MIXED_MODE = new RVMInstallationType();
            a = new RVMInstallationType[]{SINGLE, MULTI_USER, MIXED_MODE};
        }
    }
}

