/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.project;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.ide.actions.CreatePuppetModuleAction;
import com.intellij.lang.puppet.ide.project.PuppetProjectGeneratorSettings;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.wizard.RubyProjectGeneratorPane;
import org.jetbrains.plugins.ruby.wizard.RubyProjectSettings;
import org.jetbrains.plugins.ruby.wizard.RubySdkPanel;

public class PuppetProjectGeneratorPane
extends RubyProjectGeneratorPane {
    private final PuppetProjectGeneratorSettings mySettings;
    private JPanel myAdditionalSettingsPanel;
    private JBTextField myUserNameField;
    private JBTextField myModuleNameField;
    private HyperlinkLabel myPuppetVersionLink;
    private Runnable mySettingsChangeListener;
    DocumentListener myTextFieldListener;
    private RubySdkPanel mySdkPanel;

    public PuppetProjectGeneratorPane(PuppetProjectGeneratorSettings settings) {
        super((RubyProjectSettings)settings);
        this.$$$setupUI$$$();
        this.myTextFieldListener = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                PuppetProjectGeneratorPane.this.saveSettings();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/puppet/ide/project/PuppetProjectGeneratorPane$1", "textChanged"));
            }
        };
        this.init();
        this.mySettings = settings;
        if (this.mySdkPanel != null) {
            this.mySdkPanel.setOnRVMGemsetChange(sdk -> this.updateVersionStringAndSaveSettings());
        }
        this.updatePuppetVersionString();
        this.myUserNameField.getDocument().addDocumentListener(this.myTextFieldListener);
        this.myModuleNameField.getDocument().addDocumentListener(this.myTextFieldListener);
        this.mySettings.addSdkChangeListener(sdk -> this.updateVersionStringAndSaveSettings());
        this.myPuppetVersionLink.addHyperlinkListener(event -> {
            Sdk sdk = this.mySettings.getEffectiveSdk();
            if (sdk == null) {
                return;
            }
            this.myPuppetVersionLink.setText(PuppetBundle.message((String)"puppet.project.dialog.installing", (Object[])new Object[0]));
            this.myPuppetVersionLink.repaint();
            GemInstallUtil.installAndAddGemsInBackground((Sdk)sdk, null, Collections.singletonList(GemDependency.create((String)"puppet", (String[])new String[0])), (boolean)true, (boolean)false, () -> this.updateVersionStringAndSaveSettings(), new HashMap());
        });
    }

    public PuppetProjectGeneratorPane withSettingsChangeListener(@Nullable Runnable settingsChangeListener) {
        this.mySettingsChangeListener = settingsChangeListener;
        return this;
    }

    private void updatePuppetVersionString() {
        String version = this.mySettings.getPuppetVersion();
        boolean isFocusable = false;
        if (this.mySettings.getEffectiveSdk() == null) {
            this.myPuppetVersionLink.setText(RBundle.message((String)"gem.facet.wizard.error.no.skd"));
        } else if (StringUtil.isEmpty((String)version)) {
            this.myPuppetVersionLink.setHyperlinkText("", PuppetBundle.message((String)"puppet.project.dialog.install.link", (Object[])new Object[0]), "");
            isFocusable = true;
        } else {
            this.myPuppetVersionLink.setText(version);
        }
        this.myPuppetVersionLink.setFocusable(isFocusable);
        this.myPuppetVersionLink.repaint();
    }

    private void createUIComponents() {
        this.myAdditionalSettingsPanel = new JPanel();
        this.myPuppetVersionLink = new FocusableHyperlinkLabel();
    }

    @NotNull
    protected JComponent getSettingsComponent() {
        JPanel jPanel = this.myAdditionalSettingsPanel;
        if (jPanel == null) {
            PuppetProjectGeneratorPane.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @Nullable
    protected RubySdkPanel getSdkComboPane() {
        if (this.mySdkPanel == null) {
            this.mySdkPanel = new RubySdkPanel();
        }
        return this.mySdkPanel;
    }

    public void updateVersionStringAndSaveSettings() {
        this.updatePuppetVersionString();
        this.saveSettings();
    }

    @NotNull
    public ValidationResult validateSettings() {
        if (this.mySettings.getPuppetVersion() == null) {
            ValidationResult validationResult = PuppetProjectGeneratorPane.createError("puppet.project.dialog.error.no.puppet");
            if (validationResult == null) {
                PuppetProjectGeneratorPane.$$$reportNull$$$0(1);
            }
            return validationResult;
        }
        if (!CreatePuppetModuleAction.PUPPET_USER_NAME_PATTERN.matcher(this.mySettings.getUsername()).matches()) {
            ValidationResult validationResult = PuppetProjectGeneratorPane.createError("puppet.project.dialog.error.username");
            if (validationResult == null) {
                PuppetProjectGeneratorPane.$$$reportNull$$$0(2);
            }
            return validationResult;
        }
        if (!CreatePuppetModuleAction.PUPPET_MODULE_NAME_PATTERN.matcher(this.mySettings.getModuleName()).matches()) {
            ValidationResult validationResult = PuppetProjectGeneratorPane.createError("puppet.project.dialog.error.modulename");
            if (validationResult == null) {
                PuppetProjectGeneratorPane.$$$reportNull$$$0(3);
            }
            return validationResult;
        }
        ValidationResult validationResult = ValidationResult.OK;
        if (validationResult == null) {
            PuppetProjectGeneratorPane.$$$reportNull$$$0(4);
        }
        return validationResult;
    }

    private void saveSettings() {
        this.mySettings.setModuleName(this.myModuleNameField.getText());
        this.mySettings.setUsername(this.myUserNameField.getText());
        if (this.mySettingsChangeListener != null) {
            this.mySettingsChangeListener.run();
        }
    }

    private static ValidationResult createError(@NotNull String messageKey) {
        if (messageKey == null) {
            PuppetProjectGeneratorPane.$$$reportNull$$$0(5);
        }
        return new ValidationResult(PuppetBundle.message((String)messageKey, (Object[])new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/project/PuppetProjectGeneratorPane";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "validateSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/project/PuppetProjectGeneratorPane";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTextField jBTextField;
        JBTextField jBTextField2;
        this.createUIComponents();
        JPanel jPanel = this.myAdditionalSettingsPanel;
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 5, new Insets(0, 0, 0, 0), -1, -1, false, true));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("com/intellij/lang/puppet/PuppetBundle").getString("puppet.project.dialog.puppet.version"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("com/intellij/lang/puppet/PuppetBundle").getString("puppet.project.dialog.username"));
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("com/intellij/lang/puppet/PuppetBundle").getString("puppet.project.dialog.module.name"));
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 3, 1, 2, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(2, 3, 1, 2, 0, 1, 6, 1, null, null, null));
        this.myUserNameField = jBTextField2 = new JBTextField();
        jPanel.add((Component)jBTextField2, new GridConstraints(1, 1, 1, 2, 8, 0, 3, 3, new Dimension(100, -1), new Dimension(100, -1), null));
        this.myModuleNameField = jBTextField = new JBTextField();
        jPanel.add((Component)jBTextField, new GridConstraints(2, 1, 1, 2, 8, 0, 3, 3, new Dimension(100, -1), new Dimension(100, -1), null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        HyperlinkLabel hyperlinkLabel = this.myPuppetVersionLink;
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        jBLabel2.setLabelFor((Component)jBTextField2);
        jBLabel3.setLabelFor((Component)jBTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myAdditionalSettingsPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class FocusableHyperlinkLabel
    extends HyperlinkLabel {
        private boolean isFocused = false;

        FocusableHyperlinkLabel() {
            super("");
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    isFocused = true;
                    this.repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    isFocused = false;
                    this.repaint();
                }
            });
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isFocused) {
                g.setColor(UIUtil.getTreeSelectionBorderColor());
                int width = this.getWidth() - 1;
                int height = this.getHeight() - 1;
                if (width > 0 && height > 0) {
                    UIUtil.drawDottedRectangle((Graphics)g, (int)0, (int)0, (int)width, (int)height);
                }
            }
        }
    }
}

