/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSPropertyNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPropertyNameReference
implements PsiPolyVariantReference {
    @NotNull
    private final JSProperty myProperty;

    public JSPropertyNameReference(@NotNull JSProperty property) {
        if (property == null) {
            JSPropertyNameReference.$$$reportNull$$$0(0);
        }
        this.myProperty = property;
    }

    @NotNull
    public JSProperty getElement() {
        JSProperty jSProperty = this.myProperty;
        if (jSProperty == null) {
            JSPropertyNameReference.$$$reportNull$$$0(1);
        }
        return jSProperty;
    }

    @NotNull
    public TextRange getRangeInElement() {
        ASTNode nameIdentifier = this.myProperty.findNameIdentifier();
        if (nameIdentifier == null) {
            TextRange textRange = this.myProperty.getTextRange();
            if (textRange == null) {
                JSPropertyNameReference.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        int quotesDelta = nameIdentifier.getElementType() == JSTokenTypes.STRING_LITERAL && nameIdentifier.getTextLength() >= 2 ? 1 : 0;
        int startOffsetInParent = nameIdentifier.getPsi().getStartOffsetInParent();
        TextRange textRange = new TextRange(startOffsetInParent + quotesDelta, startOffsetInParent + nameIdentifier.getTextLength() - quotesDelta);
        if (textRange == null) {
            JSPropertyNameReference.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 0 || resolveResults.length > 1 || !resolveResults[0].isValidResult() ? null : resolveResults[0].getElement();
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        if (!this.myProperty.isValid()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSPropertyNameReference.$$$reportNull$$$0(4);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        PsiReference[] nameRefs = this.myProperty.getNameIdentifier() != null ? ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this.myProperty.getNameIdentifier()) : EMPTY_ARRAY;
        ResolveResult[] results = JSResolveUtil.resolve(this.myProperty.getContainingFile(), this, new JSPropertyNameResolver(), incompleteCode);
        ResolveResult[] resolveResultArray = this.merge(results, nameRefs, incompleteCode);
        if (resolveResultArray == null) {
            JSPropertyNameReference.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    private ResolveResult[] merge(ResolveResult[] resolves, PsiReference[] refs, boolean incompleteCode) {
        if (refs.length == 0) {
            return resolves;
        }
        ArrayList<ResolveResult> list = new ArrayList<ResolveResult>();
        for (ResolveResult resolveResult : resolves) {
            if (resolveResult.getElement() == this.myProperty) continue;
            list.add(resolveResult);
        }
        for (ResolveResult resolveResult : refs) {
            if (resolveResult instanceof PsiPolyVariantReference) {
                ResolveResult[] results = ((PsiPolyVariantReference)resolveResult).multiResolve(incompleteCode);
                list.addAll(Arrays.asList(results));
                continue;
            }
            PsiElement resolve = resolveResult.resolve();
            if (resolve == null || !resolve.isValid()) continue;
            list.add(new JSResolveResult(resolve));
        }
        return list.toArray(ResolveResult.EMPTY_ARRAY);
    }

    @NotNull
    public String getCanonicalText() {
        String string = JSStringUtil.unquoteAndUnescapeString(this.myProperty.getFirstChild().getText());
        if (string == null) {
            JSPropertyNameReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            JSPropertyNameReference.$$$reportNull$$$0(7);
        }
        this.myProperty.setName(newElementName);
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSPropertyNameReference.$$$reportNull$$$0(8);
        }
        return null;
    }

    @NotNull
    private List<PsiElement> resolveAndUnwrapMergedTypeMembers() {
        ResolveResult[] elements;
        PsiElement resolvedElement = this.resolve();
        if (resolvedElement instanceof TypeScriptProxyImplicitElement) {
            List list = ContainerUtil.createMaybeSingletonList((Object)((TypeScriptProxyImplicitElement)resolvedElement).getExplicitElement());
            if (list == null) {
                JSPropertyNameReference.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (resolvedElement != null) {
            List list = ContainerUtil.createMaybeSingletonList((Object)resolvedElement);
            if (list == null) {
                JSPropertyNameReference.$$$reportNull$$$0(10);
            }
            return list;
        }
        ArrayList allElements = ContainerUtil.newArrayList();
        for (ResolveResult result2 : elements = this.multiResolve(false)) {
            PsiElement explicitElement;
            PsiElement resultElement = result2.getElement();
            if (!(resultElement instanceof TypeScriptProxyImplicitElement) || allElements.contains(explicitElement = ((TypeScriptProxyImplicitElement)resultElement).getExplicitElement())) continue;
            allElements.add(explicitElement);
        }
        ArrayList arrayList = allElements;
        if (arrayList == null) {
            JSPropertyNameReference.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        JSExpression expression;
        if (element == null) {
            JSPropertyNameReference.$$$reportNull$$$0(12);
        }
        if (element instanceof TypeScriptProxyImplicitElement) {
            return this.isReferenceTo(((TypeScriptProxyImplicitElement)element).getExplicitElement());
        }
        if (element instanceof TypeScriptField || element instanceof TypeScriptFunction) {
            JSClass refElementClass = JSUtils.getMemberContainingClass(element);
            if (refElementClass != null) {
                List<PsiElement> resolvedElements = this.resolveAndUnwrapMergedTypeMembers();
                for (PsiElement el : resolvedElements) {
                    if (el == element) {
                        return true;
                    }
                    JSClass resolvedElementClass = JSUtils.getMemberContainingClass(el);
                    if (resolvedElementClass == null || !(el instanceof JSPsiElementBase) || !JSInheritanceUtil.checkMemberHierarchyIncludeClass((JSPsiElementBase)el, refElementClass)) continue;
                    return true;
                }
                return false;
            }
            if (element instanceof TypeScriptPropertySignature || element instanceof TypeScriptFunctionSignature) {
                return this.resolveAndUnwrapMergedTypeMembers().stream().anyMatch(e -> {
                    if (element == null) {
                        JSPropertyNameReference.$$$reportNull$$$0(14);
                    }
                    return e == element;
                });
            }
        }
        if (element instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)element).getExpression()) instanceof JSReferenceExpression) {
            return this.resolveAndUnwrapMergedTypeMembers().stream().anyMatch(e -> ((JSReferenceExpression)expression).isReferenceTo(e));
        }
        if (element instanceof JSProperty) {
            List<PsiElement> elements2 = this.resolveAndUnwrapMergedTypeMembers();
            for (PsiElement element2 : elements2) {
                if (element == element2 || !(element2 instanceof JSPsiElementBase) || !StringUtil.equals((CharSequence)((JSNamedElement)element).getName(), (CharSequence)((JSPsiElementBase)element2).getName()) || ((JSProperty)element).getJSNamespace().isExplicitlyDeclared() && ((JSPsiElementBase)element2).getJSNamespace().isExplicitlyDeclared() && !JSSymbolUtil.areElementsFromSameNamespace((JSPsiElementBase)((JSProperty)element), (JSPsiElementBase)element2)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        PsiReference[] references = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this.myProperty);
        ArrayList<Object> list = new ArrayList<Object>();
        for (PsiReference reference : references) {
            Object[] variants = reference.getVariants();
            if (variants.length <= 0) continue;
            list.addAll(Arrays.asList(variants));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(list);
        if (objectArray == null) {
            JSPropertyNameReference.$$$reportNull$$$0(13);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAndUnwrapMergedTypeMembers";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isReferenceTo$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

