/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;

public class JSMatchingStrategy
implements MatchingStrategy {
    private static final JSMatchingStrategy INSTANCE = new JSMatchingStrategy((Language)JavascriptLanguage.INSTANCE);
    private final Language myLanguage;

    public JSMatchingStrategy(Language language) {
        if (language != JavascriptLanguage.INSTANCE && !(language instanceof JSLanguageDialect)) {
            throw new IllegalArgumentException();
        }
        this.myLanguage = language;
    }

    public static JSMatchingStrategy getInstance() {
        return INSTANCE;
    }

    public boolean continueMatching(PsiElement start) {
        if (start instanceof XmlElement) {
            return false;
        }
        Language language = DialectDetector.languageOfElement(start);
        return language.isKindOf(this.myLanguage);
    }

    public boolean shouldSkip(PsiElement element, PsiElement elementToMatchWith) {
        return false;
    }
}

